package WordList::EN::PersonName::PopularBabyNames::US::SSA::2017::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-04'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("avg_word_len",5.751,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"num_words_contain_unicode",0,"num_words",1000,"shortest_word_len",2,"num_words_contain_nonword_chars",0,"longest_word_len",11,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 2017 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyNames::US::SSA::2017::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 2017 (from Social Security Administration)

=head1 VERSION

This document describes version 0.002 of WordList::EN::PersonName::PopularBabyNames::US::SSA::2017::MaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyNames-US-SSA), released on 2020-05-04.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyNames::US::SSA::2017::MaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyNames::US::SSA::2017::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.751 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Liam
Noah
William
James
Logan
Benjamin
Mason
Elijah
Oliver
Jacob
Lucas
Michael
Alexander
Ethan
Daniel
Matthew
Aiden
Henry
Joseph
Jackson
Samuel
David
Sebastian
Carter
Wyatt
Jayden
John
Owen
Dylan
Luke
Gabriel
Isaac
Anthony
Grayson
Jack
Julian
Levi
Christopher
Joshua
Andrew
Lincoln
Mateo
Ryan
Jaxon
Nathan
Isaiah
Aaron
Charles
Thomas
Caleb
Josiah
Christian
Hunter
Eli
Jonathan
Connor
Landon
Adrian
Asher
Cameron
Leo
Theodore
Jeremiah
Hudson
Robert
Easton
Nolan
Nicholas
Ezra
Colton
Angel
Brayden
Jordan
Dominic
Austin
Ian
Adam
Elias
Jaxson
Greyson
Jose
Ezekiel
Carson
Evan
Maverick
Bryson
Jace
Cooper
Xavier
Parker
Roman
Jason
Santiago
Chase
Sawyer
Gavin
Leonardo
Kayden
Ayden
Jameson
Kevin
Bentley
Zachary
Axel
Everett
Tyler
Micah
Vincent
Weston
Miles
Wesley
Nathaniel
Harrison
Brandon
Declan
Cole
Luis
Damian
Braxton
Silas
Tristan
Ryder
Bennett
George
Emmett
Kai
Justin
Max
Diego
Luca
Ryker
Carlos
Maxwell
Kingston
Ivan
Maddox
Juan
Ashton
Jayce
Rowan
Kaiden
Giovanni
Eric
Jesus
Abel
Calvin
King
Camden
Blake
Amir
Alex
Brody
Malachi
Emmanuel
Jonah
Jude
Beau
Antonio
Alan
Elliott
Elliot
Waylon
Timothy
Xander
Victor
Bryce
Finn
Brantley
Abraham
Edward
Patrick
Grant
Hayden
Richard
Karter
Miguel
Joel
Gael
Tucker
Rhett
Avery
Steven
Graham
Jasper
Kaleb
Jesse
Dean
Matteo
Preston
Zayden
August
Oscar
Jeremy
Alejandro
Marcus
Dawson
Lorenzo
Messiah
Zion
River
Maximus
Zane
Mark
Brooks
Judah
Nicolas
Paxton
Emiliano
Kaden
Bryan
Kyle
Myles
Peter
Charlie
Kyrie
Brian
Thiago
Kenneth
Andres
Lukas
Aidan
Jax
Caden
Milo
Paul
Beckett
Brady
Colin
Bradley
Omar
Javier
Jaden
Knox
Barrett
Israel
Matias
Zander
Jorge
Derek
Josue
Cayden
Holden
Griffin
Felix
Leon
Arthur
Killian
Remington
Jake
Clayton
Sean
Adriel
Riley
Archer
Legend
Erick
Enzo
Corbin
Francisco
Dallas
Emilio
Gunner
Simon
Andre
Walter
Damien
Phoenix
Chance
Tobias
Colt
Stephen
Tanner
Manuel
Kameron
Emerson
Amari
Louis
Finley
Cody
Iker
Martin
Nash
Rafael
Beckham
Cash
Karson
Rylan
Reid
Ace
Theo
Eduardo
Spencer
Raymond
Anderson
Maximiliano
Ronan
Cristian
Lane
Titus
Jett
Bodhi
Ricardo
Travis
Gideon
Jaiden
Fernando
Mario
Conor
Keegan
Ali
Ellis
Cesar
Jayceon
Cohen
Walker
Arlo
Dante
Hector
Kyler
Seth
Garrett
Donovan
Tyson
Jeffrey
Desmond
Jase
Caiden
Atlas
Gage
Major
Devin
Edwin
Angelo
Orion
Conner
Marco
Jensen
Julius
Daxton
Peyton
Collin
Dakota
Zayn
Jaylen
Prince
Johnny
Kayson
Cruz
Hendrix
Atticus
Troy
Kane
Sergio
Edgar
Kash
Marshall
Johnathan
Romeo
Shane
Warren
Trevor
Joaquin
Leonel
Wade
Dominick
Quinn
Odin
Erik
Muhammad
Jaxton
Dalton
Frank
Gregory
Nehemiah
Grady
Andy
Solomon
Malik
Clark
Reed
Rory
Harvey
Jay
Zayne
Jared
Noel
Shawn
Fabian
Ibrahim
Leland
Malcolm
Adonis
Ismael
Pedro
Malakai
Kason
Alexis
Porter
Ari
Sullivan
Raiden
Allen
Princeton
Russell
Winston
Roberto
Kendrick
Finnegan
Hayes
Lennox
Nasir
Landen
Nico
Emanuel
Kade
Moises
Hugo
Ruben
Adan
Abram
Zaiden
Augustus
Khalil
Cyrus
Marcos
Philip
Phillip
Esteban
Bruce
Braylen
Kamden
Albert
Lawson
Sterling
Kyson
Damon
Gunnar
Jamison
Franklin
Luka
Ezequiel
Pablo
Zachariah
Cade
Derrick
Jonas
Dexter
Kolton
Trenton
Remy
Tate
Hank
Drew
Kian
Dax
Mohamed
Rocco
Mathias
Bowen
Francis
Ronald
Matthias
Maximilian
Milan
Corey
Royce
Skyler
Kasen
Drake
Gerardo
Jayson
Sage
Moses
Benson
Braylon
Alijah
Rhys
Otto
Oakley
Armando
Jaime
Nixon
Saul
Scott
Brycen
Ariel
Donald
Enrique
Chandler
Asa
Eden
Davis
Keith
Rowen
Lawrence
Frederick
Leonidas
Aden
Julio
Darius
Johan
Danny
Deacon
Taylor
Cason
Nikolai
Royal
Alec
Armani
Omari
Kieran
Luciano
Rodrigo
Arjun
Raphael
Ahmed
Ronin
Brendan
Cullen
Raul
Brock
Alonzo
Pierce
Dillon
Casey
Uriel
Moshe
Dustin
Roland
Gianni
Landyn
Apollo
Emmitt
Kobe
Roy
Ryland
Aarav
Dorian
Duke
Sam
Quentin
Lewis
Tony
Uriah
Dennis
Braden
Isaias
Quinton
Niko
Ayaan
Cannon
Mathew
Kellan
Edison
Jerry
Izaiah
Gustavo
Jamari
Marvin
Mauricio
Ahmad
Justice
Trey
Mohammad
Sincere
Elian
Mohammed
Callen
Yusuf
Arturo
Keaton
Memphis
Rayan
Wilder
Mekhi
Cayson
Conrad
Kyree
Kaison
Lucian
Soren
Colby
Cassius
Bryant
Brennan
Marcelo
Nikolas
Alfredo
Darren
Jasiah
Forrest
Lionel
Chris
Reece
Ty
Jimmy
Korbin
Tatum
Jalen
Santino
Case
Issac
Leonard
Alvin
Samson
Bo
Quincy
Alberto
Rex
Callum
Curtis
Hezekiah
Mack
Kamari
Finnley
Briggs
Zeke
Neil
Raylan
Julien
Titan
Devon
Kellen
Kylan
Axton
Crosby
Roger
Carl
Larry
Douglas
Fletcher
Makai
Nelson
Alden
Lance
Hamza
Gary
Bruno
Jakob
Wilson
Ares
Cairo
Kashton
Alessandro
Nathanael
Stetson
Byron
Harley
Harry
Zain
Maurice
Mitchell
Kingsley
Orlando
Ramon
Trent
Kaysen
Sylas
Boston
Noe
Jagger
Lucca
Thaddeus
Reyansh
Vihaan
Randy
Lennon
Kannon
Kohen
Yosef
Abdiel
Salvador
Tristen
Valentino
Kristopher
Langston
Maxton
Rohan
Deandre
Lee
Morgan
Rayden
Tripp
Callan
Joe
Ricky
Dariel
Colten
Jedidiah
Reese
Terry
Bronson
Clay
Eddie
Jefferson
Lachlan
Layne
Madden
Amos
Jamir
Tomas
Kareem
Stanley
Brayan
Clyde
Ernesto
Kase
Kristian
Ford
Tommy
Brecken
Chaim
Casen
Braydon
Crew
Axl
Hassan
Boone
Samir
Leandro
Magnus
Abdullah
Jaziel
Branson
Yousef
Jaxen
Franco
Jadiel
Layton
Ben
Grey
Kelvin
Melvin
Ridge
Demetrius
Blaine
Colson
Lochlan
Anakin
Aryan
Dash
Jon
Otis
Canaan
Zechariah
Alonso
Zaire
Brett
Marcel
Dominik
Stefan
Aldo
Dane
Flynn
Jeffery
Talon
Baylor
Enoch
Carmelo
Jamal
Kole
Kye
Graysen
Fisher
Aron
Fox
Ray
Terrance
Vicente
Jamie
Joziah
Rey
Zaid
Emery
Gannon
Allan
Felipe
Rodney
Sonny
Zyaire
Cory
Juelz
Augustine
Jacoby
Joey
Marc
Bobby
Harlan
Anson
Marlon
Huxley
Anders
Guillermo
Shepherd
Azariah
Payton
Castiel
Damari
Harold
Harper
Elisha
Henrik
Kairo
Houston
Willie
Emory
Skylar
Toby
Ameer
Blaze
Wayne
Alfonso
Brentley
Shiloh
Sutton
Bodie
Darian
Eugene
Gordon
London
Jermaine
Denver
Jordy
Kody
Gerald
Merrick
Vincenzo
Musa
Yahir
Brodie
Tadeo
Bentlee
Billy
Darwin
Trace
Vance
Hugh
Westin
Reginald
Arian
Cain
Dayton
Javion
Terrence
Brysen
Westley
Jaxxon
Thatcher
Miller
Landry
Rene
Ephraim
Alvaro
Cristiano
Eliseo
Jerome
Caspian
Adrien
Aydin
Kendall
Khalid
Junior
Mayson
Alfred
Duncan
Koda
Maison
Zavier
Zackary
Maxim
Kace
Keagan
Rudy
Coleman
Davion
Kolten
Maximo
Briar
Dario
Kalel
Rogelio
Jairo
Micheal
Misael
Terrell
Brixton
Xzavier
Aaden
Draven
Heath
Wesson
Keanu
Ronnie
Darrell
Konnor
Leighton
Reuben
Salvatore
Shaun
Will
Yehuda
Frankie
Coen
Dangelo
Kamryn
Santana
Dimitri
Mustafa
Van
Ayan
Blaise
Benton
Keenan
Lamar
Wells
Achilles
Channing
Ishaan
Nova
Yahya
Dilan
Gibson
Ulises
Camdyn
Alexzander
Shepard
Valentin
Alistair
Leroy
Zayd
Camilo
Dwayne
Eason
Kaiser
Markus
Foster
Koa
Agustin
Bridger
Davian
Jabari
Judson
Lyric
Nickolas
Shmuel
Bjorn
Tristian
Emmet
Vivaan
Brayson
Leif
Marley
Mike
Greysen
Ignacio
Kenny
Chad
Ernest
Rocky
Gatlin
Jessie
Kyng
Randall
Reign
Vaughn
Zahir
Louie
Ira
Javon
Khari
Reagan
Simeon
Avi
Ledger
Yadiel
Maddux
Seamus
Cedric
Kylen
Dominique
Jad
Jeremias
Rashad
Santos
Craig
Gianluca
Jovanni
Yisroel
Anton
Bishop
Eliezer
Giancarlo
Brenden
Lyle
Alaric
Camron
Decker
Tyrone
Howard
Jaxx
