package WordList::EN::PersonName::PopularBabyNames::US::SSA::1920::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-04'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words",1000,"num_words_contain_unicode",0,"num_words_contains_whitespace",0,"num_words_contain_whitespace",0,"avg_word_len",5.937,"num_words_contains_nonword_chars",0,"longest_word_len",10,"num_words_contains_unicode",0,"shortest_word_len",2,"num_words_contain_nonword_chars",0); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1920 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyNames::US::SSA::1920::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1920 (from Social Security Administration)

=head1 VERSION

This document describes version 0.002 of WordList::EN::PersonName::PopularBabyNames::US::SSA::1920::FemaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyNames-US-SSA), released on 2020-05-04.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyNames::US::SSA::1920::FemaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyNames::US::SSA::1920::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.937 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Mary
Dorothy
Helen
Margaret
Ruth
Mildred
Virginia
Elizabeth
Frances
Anna
Betty
Evelyn
Marie
Doris
Alice
Florence
Irene
Lillian
Louise
Rose
Catherine
Gladys
Martha
Marjorie
Eleanor
Ruby
Edna
Josephine
Lucille
Ethel
Thelma
Edith
Jean
Hazel
Annie
Pauline
Grace
Lois
Esther
Bernice
Beatrice
Gertrude
Marion
Clara
Katherine
Emma
Barbara
Jane
Ann
Sarah
Elsie
Rita
June
Agnes
Julia
Shirley
Bertha
Eva
Viola
Geraldine
Juanita
Pearl
Laura
Vivian
Anne
Ida
Kathryn
Myrtle
Norma
Lorraine
Bessie
Phyllis
Marian
Willie
Vera
Nellie
Violet
Wilma
Charlotte
Alma
Maxine
Stella
Mabel
Jessie
Sylvia
Genevieve
Minnie
Ella
Leona
Lillie
Kathleen
Ellen
Marguerite
Lucy
Nancy
Mattie
Jennie
Lena
Mae
Eileen
Opal
Blanche
Audrey
Patricia
Velma
Geneva
Elaine
Theresa
Beulah
Dolores
Sara
Harriet
Georgia
Jeanne
Eunice
Rosa
Wanda
Christine
Emily
Loretta
Carrie
Inez
Muriel
Janet
Hilda
Jeanette
Fannie
Alberta
Sophie
Maria
Anita
Hattie
Dora
Naomi
Verna
Ada
Cora
Madeline
Lula
Miriam
Rosemary
Mamie
Joan
Roberta
Arlene
Olga
Lola
Mable
Flora
Carolyn
Olive
Erma
Joyce
Bonnie
Daisy
Rachel
Nora
Estelle
Caroline
Winifred
Marcella
Rosie
Susie
Irma
Constance
Lucile
Lorene
Margie
Eula
Fern
Henrietta
Maggie
Victoria
Sadie
Rebecca
Adeline
Lottie
Eloise
Nina
Antoinette
Nettie
Carol
Della
Katie
Lydia
Regina
Dorothea
Laverne
Jeannette
Amelia
Cleo
Veronica
Angelina
Claire
Gloria
Bette
Essie
Goldie
Isabel
Rosalie
Freda
Donna
Sally
May
Ollie
Adele
Beverly
Faye
Angeline
Melba
Addie
Billie
Isabelle
Effie
Ora
Jewell
Cecelia
Lela
Peggy
Annette
Ernestine
Iva
Johnnie
Luella
Susan
Leola
Lila
Jewel
Imogene
Etta
Sallie
Bettie
Selma
Elva
Janie
Gwendolyn
Carmen
Cecilia
Ola
Eleanore
Delores
Celia
Teresa
Alta
Lizzie
Sue
Yvonne
Reba
Maude
Fay
Ina
Helene
Frieda
Janice
Angela
Nell
Elinor
Nannie
Francis
Priscilla
Matilda
Iris
Amy
Estella
Elnora
Elma
Lenora
Elvira
Nadine
Harriett
Eugenia
Arline
Annabelle
Ila
Mollie
Neva
Clarice
Natalie
Sophia
Flossie
Lee
Jacqueline
Margery
Gracie
Virgie
Leah
Olivia
Marilyn
Myra
Carmela
Edythe
Connie
Rena
Winnie
Mavis
Sybil
Cecile
Millie
Adelaide
Hannah
Bernadine
Carmella
Madge
Odessa
Aileen
Frankie
Cornelia
Zelma
Berniece
Aline
Lorena
Avis
Dorthy
Josie
Alyce
Letha
Willa
Rhoda
Rosetta
Concetta
Allie
Rosella
Leila
Merle
Lenore
Dollie
Eliza
Corinne
Claudia
Loraine
Lily
Jimmie
Christina
Helena
Amanda
Corine
Joy
Iona
Ramona
Lora
Judith
Ione
Tillie
Florine
Callie
Hester
Marcia
Ophelia
Beth
Hope
Katharine
Linda
Dolly
Paula
Leota
Althea
Lou
Earline
Wilda
Bernadette
Maudie
Gussie
Iola
Dixie
Lessie
Guadalupe
Reva
Yolanda
Mercedes
Kay
Stephanie
Tessie
Antonia
Beryl
Pearlie
Lilly
Eddie
Bertie
Nola
Augusta
Madelyn
Johanna
Charlene
Bobbie
Theda
Polly
Robbie
Cynthia
Suzanne
Georgie
Lupe
Dessie
Delia
Roxie
John
Melva
Lelia
Aurora
Darlene
Harriette
Oma
Allene
Verda
Philomena
Deloris
Glenna
Evangeline
Maurine
Alene
Consuelo
Mona
Enid
Elisabeth
Erna
Kate
Margarita
Mozelle
Alvina
Hallie
Isabella
Nona
Garnet
Isabell
James
Dortha
Jannie
Molly
Corrine
Zella
Vesta
Jaunita
Lorine
Rubye
Marjory
Clare
Belle
Lorna
Marietta
Pansy
Tommie
Valeria
Ruthie
Diana
Jo
Birdie
Queen
Ester
Leta
Madeleine
Syble
Nelda
Hortense
Dorris
Fanny
Winona
Elouise
Phoebe
Vida
Oleta
Roslyn
Louella
Monica
Leora
Wilhelmina
Cecil
Jayne
Elvera
Mayme
Rosalind
Elise
Joanne
Zelda
Agatha
Alfreda
Catharine
Robert
William
Gene
Marianne
Minerva
Ferne
Katheryn
Judy
Julie
Lucinda
Manuela
Freida
Leone
Elda
Rae
Charlie
Adell
Patsy
Dovie
Rowena
Vada
Emilie
Veda
Ilene
Louisa
Una
Velda
Millicent
Albina
Alpha
Bella
Jenny
Lura
Sibyl
Retha
Edwina
Trinidad
Juliette
Orpha
Ava
Elsa
Margret
Rhea
Betsy
Camille
Magdalene
Rosalee
Angie
Cassie
Gail
Gertie
Lauretta
Zola
Claudine
Elena
Evalyn
Lulu
Marcelle
Filomena
Floy
Hellen
Rosemarie
Theodora
Aurelia
Verla
Alva
Linnie
Justine
Reta
Earnestine
Valerie
Vernice
Ima
Maybelle
Dorotha
Ethelyn
Lona
Jerry
Joanna
Bennie
George
Mazie
Myrtis
Belva
Delphine
Maryann
Blanch
Faith
Charles
Adela
Ona
Ursula
Winnifred
Maud
Ardis
Celestine
Florene
Idella
Lavina
Odell
Estell
Freddie
Bettye
Elna
Mittie
Lettie
Petra
Celeste
Francisca
Georgiana
Margarette
Alicia
Juana
Marvel
Artie
Eleanora
Johnie
Larue
Lucia
Mathilda
Delma
Germaine
Jackie
Adella
Joann
Mina
Ivy
Janette
Aletha
Hettie
Ray
Treva
Bonita
Earlene
Golda
Melvina
Roma
Lavonne
Pearline
Twila
Zora
Arleen
Joe
Myrna
Yetta
Marianna
Camilla
Carolina
Rosalyn
Emogene
Gretchen
Lavern
Annabel
Gilda
Josefina
Lue
Rubie
Alda
Doretha
Era
Georgianna
Hedwig
Myrtice
Nelle
Kathrine
Laverna
Magnolia
Tina
Dorcas
Jeane
Albertha
Eldora
Nan
Ouida
Almeda
Berneice
Crystal
Easter
Therese
Anastasia
Nita
Norine
Yvette
Evelyne
Janis
Cordelia
Clementine
Evie
Rachael
Cathryn
Leatha
Leonora
Novella
Velva
Vernie
Antonette
Ardith
Esta
Malinda
Violette
Carmel
Esperanza
Georgette
Rosina
Dona
Margarett
Octavia
Sammie
Vernell
Lavon
Maryjane
Elenora
Joseph
Sandra
Corene
Lina
Madaline
Nova
Tressie
Verona
Vina
Glenda
Claudie
Emilia
Bulah
Vergie
Andrea
Audra
Maureen
Berta
Alvera
Charline
Lavada
Martina
Zula
Bethel
Daphne
Idell
Renee
Carole
Eulalia
Lovie
Elisa
Gayle
Eve
Felicia
Hilma
Lucretia
Vincenza
Annamae
Myrtie
Garnett
Lida
Abbie
Chloe
Theo
Elmira
Kathryne
Marilynn
Rosanna
Ruthe
Georgina
Lyda
Adelle
Annabell
Clyde
Concepcion
Dena
Juliet
Vivienne
Adelia
Hazle
Marge
Pinkie
Angelita
Annetta
Delphia
Donnie
Gwen
Hulda
Neoma
Cathrine
Lavinia
Leslie
Lonnie
Meta
Eloisa
Luvenia
Madie
Madonna
Ocie
Sheila
Susanna
Mozell
Sabina
Berenice
Mandy
Savannah
Freeda
Hildred
Jonnie
Amalia
Waneta
Zona
Adrienne
Cleta
Grayce
Maxie
Patty
Rosamond
Kitty
Dawn
Magdalen
Magdalena
Myrl
Arvilla
Ellie
Lennie
Libby
Macie
Ossie
Annis
Bess
Deborah
Elizebeth
Jacquelyn
Jettie
Neta
Pattie
Thomas
Yoshiko
Bernita
Clarissa
Ira
Lilian
Lucie
Roselyn
Sudie
Diane
Naoma
Zoe
Ardell
Colleen
Adelina
Pat
Ardella
Elvina
Norene
Rozella
Altha
Edyth
Emmie
Lilla
Nathalie
Pearle
Rosaline
Socorro
Sonia
Stasia
Viva
Dimple
Meredith
Nedra
Paul
Rosalia
Stephania
Elease
Loyce
Prudence
Alverta
Enola
Laurine
Myrle
Romaine
Beverley
Dominga
Eda
Elinore
Eugenie
Ozella
Verdie
Adaline
Elvie
Florida
Francine
Kattie
Lilyan
Maryellen
Palma
Santa
Bridget
Doreen
Fairy
Georgetta
Lera
Mariam
Alline
Beaulah
Dana
Exie
Ludie
Lyla
Reatha
Walter
Audie
Delpha
Gearldine
Laurel
Leonor
Almeta
Creola
Dottie
Margurite
Mickey
Shirlee
Vena
Vita
Ana
Clarabelle
Harold
Henry
Ines
Josefa
Kathlyn
Marybelle
Queenie
Willia
Aldona
Augustine
Carlene
Dale
Frank
Arthur
Edward
Hildegarde
Jamie
Versie
Vinnie
Catalina
Charity
Christene
Delilah
Dorathy
Fae
Wynona
Blossom
Erlene
Eulah
Greta
Lea
Leo
Lynn
Maurice
Nila
Verlie
Denise
Erline
Eudora
Leda
Lilia
Merry
Tomasa
Venita
Burnice
Clarine
Cleora
Jack
Juliana
Laurene
Lavera
Lorayne
Oneta
Sofia
Audry
Goldia
Hermina
Herminia
Letitia
Louis
Margarete
Marylou
Melissa
Rutha
Santos
Elberta
Elenor
Euna
Fumiko
Lorenza
Marina
Susanne
Tiny
Aleen
Benita
Ena
Gay
Helyn
Ivory
Katy
Mozella
Nella
Theola
Veva
Virgil
Amie
Clifford
Cruz
Loma
Lorean
Mammie
Marlene
Maybell
Thora
Afton
Billy
Clemmie
Elenore
Ellamae
Elois
Etha
Eveline
Gregoria
Kiyoko
Luisa
Lurline
