package Data::Sah::Coerce::perl::To_bool::From_str::common_words;

use 5.010001;
use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-10-18'; # DATE
our $DIST = 'Data-Sah-Coerce'; # DIST
our $VERSION = '0.051'; # VERSION

sub meta {
    +{
        v => 4,
        summary => 'Convert common true/false words (e.g. "yes","true","on","1" to "1", and "no","false","off","0" to "")',
        prio => 50,
        args => {
            # mostly for testing of args
            ci => {
                schema => 'bool*',
                default => 1,
            },
        },
    };
}

sub coerce {
    my %cargs = @_;

    my $dt = $cargs{data_term};
    my $gen_args = $cargs{args} // {};

    my $res = {};

    $res->{expr_match} = join(
        " && ",
        "1",
    );

    my $modifier = ($gen_args->{ci} // 1) ? "i" : "";
    $res->{expr_coerce} = "$dt =~ /\\A(yes|true|on)\\z/$modifier ? 1 : $dt =~ /\\A(no|false|off|0)\\z/$modifier ? '' : $dt";

    $res;
}

1;
# ABSTRACT: Convert common true/false words (e.g. "yes","true","on","1" to "1", and "no","false","off","0" to "")

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Sah::Coerce::perl::To_bool::From_str::common_words - Convert common true/false words (e.g. "yes","true","on","1" to "1", and "no","false","off","0" to "")

=head1 VERSION

This document describes version 0.051 of Data::Sah::Coerce::perl::To_bool::From_str::common_words (from Perl distribution Data-Sah-Coerce), released on 2021-10-18.

=head1 SYNOPSIS

To use in a Sah schema:

 ["bool",{"x.perl.coerce_rules"=>["From_str::common_words"]}]

=head1 DESCRIPTION

This coercion rule converts "true", "yes", "on" (matched case-insensitively) to
"1"; and "false", "no", "off", "0" (matched case-insensitively) to "". All other
strings are left untouched.

B<Note that this rule is incompatible with Perl's notion of true/false.> Perl
regards all non-empty string that isn't "0" (including "no", "false", "off") as
true. But this might be useful in CLI's or other places.

=for Pod::Coverage ^(meta|coerce)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Data-Sah-Coerce>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Data-Sah-Coerce>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla plugin and/or Pod::Weaver::Plugin. Any additional steps required
beyond that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2019, 2018, 2017, 2016 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Data-Sah-Coerce>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
