#!perl -T

use strict;
use Test::More tests => 8;

BEGIN {
    use_ok( 'Data::iRealPro' );
    use_ok( 'Data::iRealPro::Input' );
    use_ok( 'Data::iRealPro::Output::MMA' );
}

my $i = Data::iRealPro::Input->new;
ok( $i, "Create Input object" );

my $be = Data::iRealPro::Output::MMA->new;
ok( $be, "Create MMA backend" );

my $data = <<EOD;
Song: Test Repeats (Johan Vromans)
Style: Medium Swing (Pop-Slow Rock); key: C; tempo: 180; repeat: 3

[ A- ___ | C ___ } N1 D7 ___ } N2 D7 _ D- _ } N4 G7 ___ | A ___ ]
EOD

my $u = $i->parsedata($data);
ok( $u->{playlist}, "Got playlist" );
my $pl = $u->{playlist};
is( scalar(@{$pl->{songs}}), 1, "Got one song" );

my $res;
my $me = "Data::iRealPro $Data::iRealPro::VERSION";
$be->process( $u, { output => \$res } );
my $exp = <<EOD;
// Title: Test Repeats
// Style: Medium Swing
// Composer: Johan Vromans
// Converted from iReal by $me

MIDIText Test Repeats
MIDIText MMA input generated by $me

KeySig C major
Time 4
TimeSig 4/4
Tempo 180

Set SongForms 3

Repeat         // song form

// Section: section
Groove CountrySwing
Repeat
Repeat
  1 Am
  2 C
RepeatEnd
RepeatEnding
  3 D7
RepeatEnding 2
  4 D7 / Dm
RepeatEnd
  5 G7
  6 A

RepeatEnd NoWarn \$SongForms
EOD

my @res = split(/\n/, $res);
my @exp = split(/\n/, $exp);

is_deeply( \@res, \@exp, "MMA song content" );

unless ( $res eq $exp ) {
    for ( my $ln = 0; $ln < @res; $ln++ ) {
	printf( "%2d  %-30.30s | %s\n", $ln, $exp[$ln], $res[$ln] );
    }
}
