use strict;
use warnings;

use Test::More tests => 4;
# use Data::Dump qw/dump/;

use Math::Grid::Coordinates;

use lib './t/lib';

my $g = Math::Grid::Coordinates->new(3, 4, 3508, 2480, 10);

is_deeply([ $g->bbox ], [10544, 9950]);

is_deeply([ $g->numbers ], [(1..12)]);

is_deeply([ $g->sequence ], [ [0, 0], [1, 0], [2, 0],
			      [0, 1], [1, 1], [2, 1],
			      [0, 2], [1, 2], [2, 2],
			      [0, 3], [1, 3], [2, 3] ]);

is_deeply([ $g->positions ], [[0, 0], [3518, 0], [7036, 0],
			      [0, 2490], [3518, 2490], [7036, 2490],
			      [0, 4980], [3518, 4980], [7036, 4980],
			      [0, 7470], [3518, 7470], [7036, 7470], ]);



# -----------------------------------------------------------------------------
# End of File.
# -----------------------------------------------------------------------------
