# This Makefile.PL for Crypt-OpenSSL-SignCSR was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.014;
use ExtUtils::MakeMaker;

use Config;
use File::Spec;
use Crypt::OpenSSL::Guess;
my %args;

my ($major, $minor, $patch) = openssl_version();
print "Installed OpenSSL: $major.$minor.$patch\n";

$args{INC} =  openssl_inc_paths();
$args{LIBS} = [openssl_lib_paths() . ' -lssl -lcrypto'];

my $cc_option_flags = $major ge 3 ? ' -DOPENSSL_API_COMPAT=30000' : ' -DOPENSSL_API_COMPAT=10100';

if ($Config::Config{cc} =~ /gcc/i) {
  $cc_option_flags .= $ENV{AUTHOR_TESTING} ? ' -Wall -Werror' : ' -Wall';
} else {
  $cc_option_flags .= '';
}

if ($Config{gccversion} =~ /llvm/i) {
  if ( $^O eq 'darwin' && (
    $Config{gccversion} =~ /LLVM 1[2-9].\d.[5-9]/ ||
    $Config{gccversion} =~ /LLVM 1[3-9]/ ))
  {
    $cc_option_flags .= ' -Wno-deprecated-declarations -Wno-compound-token-split-by-macro';
  } else {
    $cc_option_flags .= ' -Wno-deprecated-declarations';
  }

  if ($Config{gccversion} =~ /llvm 13/i) {
      $cc_option_flags .= ' -Wno-compound-token-split-by-macro';
  }

  if ($Config{perl_version} <= 20) {
    $cc_option_flags .= ' -Wno-error=pointer-bool-conversion';
  }
}

if ($Config{myuname} =~ /sunos|solaris/i) {
  $args{OPTIMIZE} = $cc_option_flags;
} else {
  $args{OPTIMIZE} = $cc_option_flags;
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "Sign a Certificate Signing Request in XS.",
  "AUTHOR" => "Timothy Legge <timlegge\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "Crypt::OpenSSL::Guess" => 0,
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Crypt-OpenSSL-SignCSR",
  "LICENSE" => "apache",
  "MIN_PERL_VERSION" => "5.014",
  "NAME" => "Crypt::OpenSSL::SignCSR",
  "PREREQ_PM" => {},
  "TEST_REQUIRES" => {
    "Crypt::OpenSSL::PKCS10" => "0.19",
    "Crypt::OpenSSL::RSA" => 0,
    "File::Slurper" => "0.012",
    "File::Which" => 0
  },
  "VERSION" => "0.07",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %args,
);

my %FallbackPrereqs = (
  "Crypt::OpenSSL::PKCS10" => "0.19",
  "Crypt::OpenSSL::RSA" => 0,
  "File::Slurper" => "0.012",
  "File::Which" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);
