package WordList::PersonName::PopularBabyNames::US::SSA::1930::FemaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contains_nonword_chars",0,"num_words_contain_unicode",0,"num_words_contains_whitespace",0,"avg_word_len",5.976,"shortest_word_len",2,"num_words_contains_unicode",0,"num_words_contain_whitespace",0,"num_words",1000,"num_words_contain_nonword_chars",0,"longest_word_len",10); # STATS

1;
# ABSTRACT: Top 1000 most popular names for female babies born in the USA in 1930 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1930::FemaleTop1000 - Top 1000 most popular names for female babies born in the USA in 1930 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1930::FemaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1930::FemaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1930::FemaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.976 |
 | longest_word_len                 | 10    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Mary
Betty
Dorothy
Helen
Margaret
Barbara
Patricia
Joan
Doris
Ruth
Shirley
Virginia
Dolores
Jean
Elizabeth
Frances
Lois
Joyce
Evelyn
Alice
Mildred
Marilyn
Anna
Nancy
Norma
Marie
Martha
Phyllis
Rose
Gloria
Louise
Marjorie
Irene
Beverly
Catherine
Ruby
Donna
Florence
Eleanor
Annie
Ann
Rita
Geraldine
Lillian
Thelma
Lorraine
June
Gladys
Josephine
Theresa
Edna
Pauline
Janet
Carol
Jane
Wanda
Juanita
Bernice
Lucille
Marion
Edith
Grace
Audrey
Clara
Ethel
Delores
Peggy
Wilma
Elaine
Sarah
Hazel
Carolyn
Emma
Jacqueline
Charlotte
Beatrice
Esther
Bonnie
Billie
Marian
Joanne
Rosemary
Anne
Kathleen
Katherine
Eva
Willie
Elsie
Laura
Julia
Vivian
Jeanne
Maxine
Ida
Bertha
Gertrude
Patsy
Sally
Maria
Ellen
Kathryn
Agnes
Arlene
Vera
Loretta
Jeanette
Ella
Bessie
Alma
Eileen
Lillie
Margie
Nellie
Jessie
Anita
Viola
Georgia
Joann
Lucy
Violet
Pearl
Minnie
Myrtle
Christine
Roberta
Janice
Velma
Mattie
Rosa
Leona
Jo
Sylvia
Geneva
Sara
Bobbie
Claire
Mae
Harriet
Naomi
Stella
Darlene
Dora
Genevieve
Lena
Carrie
Constance
Alberta
Eunice
Ramona
Mabel
Verna
Jennie
Emily
Rosie
Muriel
Opal
Lula
Hilda
Marguerite
Hattie
Cora
Lola
Joy
Rachel
Yvonne
Fannie
Sue
Beulah
Erma
Lila
Inez
Caroline
Madeline
Flora
Rosalie
Rebecca
Faye
Laverne
Blanche
Irma
Daisy
Eula
Miriam
Carmen
Ada
Marcella
Mamie
Eloise
Imogene
Nora
Bettie
Susan
Nina
Teresa
Charlene
Jeannette
Mable
Antoinette
Gwendolyn
Ernestine
Colleen
Judith
Iris
Rosemarie
Susie
Johnnie
Della
Deloris
Estelle
Melba
Lorene
Angelina
Priscilla
Sadie
Regina
Maggie
Suzanne
Marianne
Connie
Annette
Bette
Olga
Patty
Bettye
Diane
Katie
Pat
Victoria
Janie
Winifred
Marcia
Jewel
Lydia
Dorthy
Reba
Amelia
Ora
Henrietta
Nadine
Jacquelyn
Ollie
Nettie
Angela
Dorothea
Veronica
Fern
Jackie
Ina
Natalie
Essie
Fay
Paula
Freda
Iva
Isabel
Luella
Cynthia
Jeannine
Lela
Therese
Jimmie
Cecilia
Diana
Sallie
Adele
Celia
Lottie
Adeline
Glenna
May
Etta
Helene
Selma
Angeline
Frankie
Mona
Jewell
Olive
Clarice
Bernadine
Maureen
Mavis
Leola
Ola
Goldie
Cecelia
Sophie
Lenora
Sharon
Cleo
Dixie
Willa
Elva
Nell
Addie
Elinor
Rhoda
Lizzie
Linda
Myra
Effie
Lucile
Myrna
Elvira
Gracie
Lou
Francis
Lee
Annabelle
Estella
Carmela
Ila
Corinne
Earline
Maryann
Isabelle
Nelda
Alta
Guadalupe
Carole
Robert
Rosetta
James
Virgie
Lenore
Lupe
John
Olivia
Dona
Ruthie
Dolly
Amy
Lavonne
Elnora
Polly
Rena
Arline
Zelma
Consuelo
Dollie
Judy
Flossie
Neva
Rosella
Eleanore
Jerry
Renee
Betsy
Elma
Beverley
Joanna
Carmella
Nannie
Eddie
Josie
Margery
Mollie
Kay
Yolanda
Greta
Aileen
Molly
Eugenia
Sheila
Wilda
Claudia
Earnestine
Tommie
Loraine
Alicia
Cornelia
Harriett
Pearlie
Lorna
Concetta
Leah
Aurora
Robbie
Bernadette
Corrine
Lora
Nola
Frieda
Margarita
Sybil
Christina
Leila
Marlene
Lily
Matilda
Nona
Sandra
Winnie
Letha
Cecile
Avis
Delia
Odessa
William
Aline
Earlene
Evangeline
Janis
Allie
Bobby
Louella
Maude
Melva
Roslyn
Ilene
Millie
Antonia
Doreen
Beth
Ophelia
Hannah
Georgie
Joe
Reva
Florine
Gwen
Julie
Eliza
Lessie
Johanna
Lilly
Delphine
Elouise
George
Helena
Lorine
Pansy
Hope
Corine
Dorris
Merle
Charles
Jenny
Bertie
Mercedes
Emogene
Berniece
Iona
Callie
Clare
Faith
Marietta
Ima
Alyce
Zelda
Angie
Valerie
Dawn
Winona
Bonita
Elena
Jannie
Leatrice
Hester
Leta
Lorena
Marlys
Alene
Gilda
Adelaide
Madge
Claudine
Josefina
Katharine
Bennie
Maurine
Dortha
Leota
Lelia
Queen
Gail
Beryl
Amanda
Rosalyn
Janette
Ardis
Ester
Freddie
Maudie
Edwina
Vada
Madelyn
Marjory
Dessie
Juana
Iola
Zella
Allene
Roxie
Glenda
Margret
Jaunita
Lucia
Charlie
Gretchen
Ione
Philomena
Rosalee
Ardith
Petra
Althea
Donald
Nita
Roma
Birdie
Retha
Marylou
Dorla
Isabell
Belva
Millicent
Reta
Esperanza
Francisca
Wilhelmina
Gene
Monica
Oma
Gussie
Rae
Billy
Sonia
Twila
Deborah
Freida
Hallie
Louisa
Phoebe
Richard
Verda
Velda
Verla
Edythe
Jeanine
Vernell
Lynn
Rowena
Minerva
Elda
Manuela
Camille
Enid
Gay
Syble
Leora
Carla
Noreen
Terry
Doretha
Sophia
Billye
Augusta
Aurelia
Tillie
Germaine
Gertie
Shirlee
Vilma
Elisabeth
Magdalene
Andrea
Arleen
Hellen
Ofelia
Tina
Ava
Isabella
Vernice
Delma
Francine
Joseph
Lucinda
Ursula
Alvina
Gayle
Laurel
Pearline
Charline
Dovie
Elise
Elsa
Madonna
Marvel
Socorro
Valeria
Lauretta
Madeleine
Alfreda
Carlene
Roselyn
Vida
Erna
Justine
Lue
Carolina
Georgette
Ladonna
Lavon
Leslie
Sammie
Caryl
Gerry
Marilynn
Nan
Rosalind
Elisa
Dorotha
Lavern
Thomas
Marceline
Una
Veda
Yvette
Lura
Rhea
Rubye
Charmaine
Darleen
Fanny
Peggie
Angelita
Lettie
Gearldine
Ardeth
Harriette
Alva
Floy
Idella
Raquel
Berta
Bobbye
Emilia
Myrtis
Treva
Pattie
Delois
Vesta
Adrienne
Mozelle
Catalina
Camilla
Kitty
Paul
Theodora
Albertha
Marianna
Oleta
Zola
Adela
Kate
Mina
Cassie
Elvera
Jeane
Linnie
Catharine
Celestine
Florene
Carmelita
Georgianna
Ona
Donnie
Garnet
Cherie
Eleanora
Jayne
Johnie
Margarette
Nedra
Agatha
Larue
Mayme
Theda
Adell
Edward
Lona
Ray
Stephanie
Tessie
Easter
Georgiana
Norine
Novella
Karen
Ana
Christene
Jacquelin
Jeanie
Katheryn
Maybelle
Jeraldine
Margot
Odell
Celeste
Dale
Daphne
Darline
Ernestina
Ouida
Susanne
Wynona
Blanch
Clementine
Henry
Artie
Dottie
Elida
Hortense
Jeannie
Lavina
Norene
Carmel
Cathryn
Chloe
Ivy
Magnolia
Martina
Mazie
Meredith
Pamela
Cecil
Juliette
Lovie
Mickey
Willene
Zora
Alda
Maryjane
Cleta
Elna
Lina
Sherry
Arden
Filomena
Lolita
Magdalena
Margarett
Cordelia
Antonette
Carroll
Frank
Georgina
Jack
Amalia
Annetta
Romona
Vergie
Verona
Vonda
David
Kenneth
Marlyn
Maxie
Nila
Toni
Dominga
Eugene
Laverna
Leone
Leonora
Maryellen
Alpha
Beatriz
Charleen
Estell
Ethelyn
Walter
Denise
Evangelina
Belle
Freeda
Hortencia
Nanette
Audra
Concepcion
Crystal
Doloris
Eulalia
Kathrine
Neoma
Arthur
Cherry
Ira
Jonnie
Loyce
Marilee
Marilou
Orpha
Vernie
Elease
Eloisa
Herminia
Lawanda
Merna
Armida
Benita
Dena
Eve
Felicia
Kattie
Romaine
Sofia
Abbie
Bernardine
Lavada
Bulah
Dana
Dorene
Lea
Marcelle
Melvina
Rubie
Velva
Dorcas
Lyla
Nova
Palma
Rosina
Arvilla
Erlene
Lita
Myrtice
Nathalie
Patti
Phylis
Bernita
Beverlee
Dianne
Earl
Leonor
Lilia
Twyla
Venita
Waneta
Era
Georgene
Ines
Marge
Maryanne
Sonya
Willia
Cathrine
Coleen
Evie
Lulu
Marylin
Rutha
Sonja
Tressie
Zula
Ardella
Elois
Maud
Albina
Almeda
Annabell
Delphia
Harold
Marva
Mittie
Nada
Naoma
Eldora
Estela
Evalyn
Imelda
Joycelyn
Joye
Laquita
Lonnie
Lucretia
Nella
Santa
Vincenza
Aida
Aletha
Annamae
Elmira
Emilie
Ferne
Idell
Jocelyn
Rosaline
Adella
Clyde
Colette
Elayne
Winnifred
Adelina
Alvera
Dorine
Erlinda
Esta
Hettie
Julianne
Laurie
Lavera
Libby
Luvenia
Luz
Lyda
Rachael
Roseann
Anastasia
Bella
Berneice
Letitia
Nannette
Ossie
Rozella
Vivienne
Brenda
Dean
Delilah
Earlean
Inell
Josefa
Rosamond
Velia
Vina
Annabel
Bethel
Corene
Evelyne
Jettie
Jovita
Mozell
Noma
Rosanna
Viva
Concha
Cruz
Elizebeth
Margo
Zona
Albert
Arla
Claudette
Emmie
Jan
Jeanetta
Leatha
Lennie
Audry
Carl
Charlsie
Claudie
Marylyn
Myrtie
Oralia
Raymond
Vita
Arletta
Bettylou
Bridget
Carma
Christeen
Golda
Hazle
Jill
Madaline
Mitzi
Patrica
Prudence
Versie
Cathleen
Clarabelle
Lida
Louvenia
Margy
Melissa
Ocie
Sudie
Tomasa
Trinidad
Vivien
Willodean
Ethelene
Florida
Georgetta
Herlinda
Jamie
Luisa
Octavia
Roy
Susanna
Trudy
Altha
Delpha
Eartha
Eda
Elenora
Ellie
Rosia
Theo
