package WordList::PersonName::PopularBabyNames::US::SSA::1920::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-01'; # DATE
our $DIST = 'WordLists-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contain_nonword_chars",0,"longest_word_len",11,"avg_word_len",5.808,"num_words_contains_nonword_chars",0,"num_words_contains_whitespace",0,"num_words_contain_unicode",0,"shortest_word_len",2,"num_words_contain_whitespace",0,"num_words_contains_unicode",0,"num_words",1000); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1920 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::PersonName::PopularBabyNames::US::SSA::1920::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1920 (from Social Security Administration)

=head1 VERSION

This document describes version 0.001 of WordList::PersonName::PopularBabyNames::US::SSA::1920::MaleTop1000 (from Perl distribution WordLists-PersonName-PopularBabyNames-US-SSA), released on 2020-05-01.

=head1 SYNOPSIS

 use WordList::PersonName::PopularBabyNames::US::SSA::1920::MaleTop1000;

 my $wl = WordList::PersonName::PopularBabyNames::US::SSA::1920::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.808 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
John
William
Robert
James
Charles
George
Joseph
Edward
Frank
Richard
Thomas
Harold
Walter
Paul
Raymond
Donald
Henry
Arthur
Albert
Jack
Harry
Ralph
Kenneth
Howard
David
Clarence
Carl
Louis
Willie
Eugene
Earl
Roy
Fred
Francis
Joe
Lawrence
Ernest
Leonard
Warren
Stanley
Herbert
Alfred
Anthony
Samuel
Elmer
Bernard
Norman
Leo
Andrew
Michael
Russell
Daniel
Edwin
Melvin
Chester
Leroy
Peter
Lloyd
Clifford
Frederick
Floyd
Marvin
Theodore
Gerald
Vernon
Herman
Ray
Clyde
Lester
Charlie
Philip
Lewis
Vincent
Milton
Leon
Alvin
Cecil
Martin
Jesse
Glenn
Victor
Lee
Benjamin
Sam
Gordon
Wayne
Harvey
Willard
Edgar
Oscar
Arnold
Claude
Wallace
Allen
Everett
Stephen
Gilbert
Wilbur
Johnnie
Homer
Virgil
Maurice
Roger
Eddie
Dale
Douglas
Sidney
Morris
Marion
Leslie
Jessie
Max
Hubert
Roland
Hugh
Irving
Alexander
Manuel
Franklin
Curtis
Bill
Glen
Luther
Nicholas
Julius
Jerome
Steve
Horace
Wesley
Jose
Tom
Billy
Willis
Orville
Oliver
Tony
Ben
Edmund
Calvin
Earnest
Mike
Alex
Jacob
Jerry
Archie
Otis
Jimmie
Don
Bruce
Delbert
Lyle
Matthew
Clayton
Guy
Angelo
Clifton
Salvatore
Clinton
Patrick
Wilbert
Bennie
Marshall
Ervin
Phillip
Jim
Nathaniel
Emil
Ronald
Rudolph
Ira
Merle
Nathan
Gene
Sylvester
Keith
Wilfred
Leland
Forrest
Ivan
Dean
Elbert
Irvin
Woodrow
Johnny
Dan
Lonnie
Nelson
Rufus
Bob
Antonio
Isaac
Johnie
Junior
Nick
Julian
Grover
Alton
Lowell
Aaron
Felix
Jay
Seymour
Abraham
Ellis
Pete
Otto
Dennis
Dewey
Emmett
Rex
August
Carroll
Juan
Roscoe
Grady
Percy
Owen
Bert
Mark
Elwood
Wilson
Loyd
Adam
Byron
Dominick
Fredrick
Malcolm
Laurence
Myron
Ross
Ted
Wendell
Perry
Dominic
Allan
Mack
Loren
Jesus
Murray
Billie
Adolph
Troy
Eldon
Norbert
Karl
Amos
Neil
Sherman
Charley
Harley
Preston
Aubrey
Austin
Reuben
Erwin
Boyd
Duane
Freddie
Wilmer
Carlton
Larry
Morton
Alan
Burton
Cornelius
Edmond
Carlos
Louie
Millard
Steven
Mitchell
Tommie
Dwight
Lynn
Gerard
Mario
Harrison
Garland
Elmo
Doyle
Elton
Grant
Russel
Jasper
Ramon
Moses
Kermit
Emanuel
Laverne
Maynard
Dave
Rocco
Neal
Will
Wade
Jake
Thurman
Francisco
Darrell
Monroe
Roosevelt
Cleveland
Solomon
Rodney
Cleo
Dallas
Earle
Joel
Tommy
Simon
Clair
Quentin
Odell
Ruben
Delmar
Irwin
Jess
Elvin
Harlan
Alphonse
Dick
Stuart
Armand
Weldon
Jimmy
Marcus
Andy
Merlin
Gus
Claud
Ed
Alonzo
Clark
Clement
Emory
Conrad
Thaddeus
Orval
Christopher
Randolph
Bruno
Carmen
Forest
Ollie
Merrill
Patsy
Ward
Adrian
Alfonso
Ned
Emery
Pedro
Alva
Buford
Cyril
Elijah
Jean
Vito
Reginald
Vern
Hollis
Benny
Lionel
Stewart
Hyman
Timothy
Wilburn
Sammie
Barney
Wiley
Truman
Anton
Emerson
Sterling
Levi
Eli
Mervin
Wilford
Roman
Sol
Ellsworth
Herschel
Basil
Noah
Coy
Travis
Teddy
Lavern
Jackson
Miles
Harding
Milford
Spencer
Norris
Winfred
Harris
Hiram
Silas
Milo
Van
Luis
Sanford
Carmine
Rolland
Winston
Ambrose
Pasquale
Abe
Buster
Jeff
Mathew
Vance
Casimir
Noel
Saul
Pat
Salvador
Foster
Freeman
Gabriel
Lenard
Bertram
Royal
Sheldon
Dudley
Isadore
Noble
Shirley
Booker
Mary
Aloysius
Hershel
Odis
Frederic
Hal
Scott
Denver
Lorenzo
Newton
Omer
Ulysses
Delmer
Olin
Bud
Eric
Ferdinand
Lamar
Lyman
Orlando
Alden
Anderson
Chris
Elliott
Gregory
Raul
Sydney
Gale
Guadalupe
Burl
Darwin
Houston
Micheal
Cletus
Royce
Marlin
Gail
Randall
Bobby
Major
Elias
Hobert
Luke
Riley
Augustus
Everette
Hoyt
Olen
Armando
Hugo
Linwood
Morgan
Evan
Warner
Wilton
Arlie
Nolan
Rupert
Jefferson
Dewitt
Junius
Walker
Wilber
Al
Merton
Waldo
Mckinley
Roberto
Clay
Lemuel
Shelby
Theron
Augustine
Columbus
Gustave
Oren
Palmer
Carlo
Christian
Dalton
Darrel
Emile
Ezra
Mason
Terry
Rene
Granville
Nickolas
Otha
Elroy
Sebastian
Hilton
Lucius
Lincoln
Blaine
Israel
Albin
Carrol
Fay
Harland
Raleigh
Jewel
Pablo
Meyer
Verne
Isidore
Ottis
Phil
Quinton
Elden
Elwin
Jeremiah
Dock
Harmon
Joshua
Benedict
Bobbie
Miguel
Gaylord
Haywood
Rafael
Alberto
Domingo
Emilio
Fletcher
Isiah
Lucian
Reed
Valentine
Antone
Hobart
Isaiah
Lucien
Mose
Vaughn
Walton
Kelly
Sigmund
Edd
Maxwell
Ora
Porter
Winfield
Hector
Dorsey
Eldred
Cyrus
Davis
Domenic
Rubin
Bryce
Joesph
Trinidad
Bernice
Hermon
Judson
Tomas
Arther
Avery
Sammy
Arden
Coleman
Arturo
Casimer
Hardy
Jewell
Jonathan
Orin
Raymon
Rudy
Alfredo
Enoch
Frankie
Seth
Felipe
Frances
Graham
King
Taylor
Carol
Justin
Lacy
Merritt
Marcel
Meredith
Asa
Bryant
Roderick
Talmadge
Eldridge
Garfield
Rollin
Romeo
Buddy
Clare
Emmitt
Raphael
Aldo
Elzie
Clem
Alvie
Andres
Carson
Emmet
Rosario
Alvis
Carter
Dana
Julio
Winford
Dee
Ignacio
Ignatius
Sherwood
Stanford
Theo
Carlyle
Fernando
Napoleon
Bennett
Connie
Jennings
Jules
Benton
Beverly
Brady
Durward
Enrique
Loyal
Matt
Claudie
Constantine
Dempsey
Elwyn
Florian
Howell
Mahlon
Arvid
General
Glendon
Kent
Leander
Pearl
Stanton
Bernie
Danny
Evert
Buck
Guido
Santo
Dexter
Edison
Loy
Omar
Rogers
Santos
Urban
Alphonso
Dillard
Garnett
Milan
Bertrand
Bradley
Dayton
Domenick
Doris
Duncan
Ike
Lawson
Angel
Casper
Elmore
Kyle
Normand
Webster
Benito
Carmelo
Hayward
Jonas
Miller
Oral
Oran
Orrin
Alford
Americo
Aron
Bryan
Garrett
Arlo
Otho
Rodger
Blair
Felton
Galen
Ellwood
Garth
Gilberto
Gregorio
Ivory
Oswald
Prince
Santiago
Abel
Haskell
Hazel
Obie
Rowland
Shelton
Verlin
Clovis
Evans
Leeroy
Reid
Winton
Brooks
Cameron
Craig
Elliot
Ernesto
Ernie
Estel
Gaetano
Theadore
Verl
Allie
Clarance
Dorothy
Early
Franklyn
Henderson
Jason
Lambert
Ruby
Carleton
Jordan
Newell
Arvil
Bradford
Denzil
Elvis
Gary
Logan
Mac
Merl
Ricardo
Burt
Chauncey
Cloyd
June
Murphy
Rayford
Reynold
Rodolfo
Vernie
Williams
Adolphus
Claire
Norwood
Regis
Silvio
Vivian
Wm
Abner
Alois
Cruz
Elisha
Fritz
Lonzo
Milburn
Myles
Pierre
Vergil
Werner
Mortimer
Nicolas
Boyce
Elgin
Giles
Hunter
Johnson
Olan
Smith
Beryl
Guillermo
Sylvan
Thornton
Alec
Alejandro
Audrey
Burnell
Clint
Lafayette
Lauren
Leopold
Thurston
Vester
Bonnie
Dante
Elza
Glenwood
Issac
Marcellus
Merlyn
Murry
Turner
Arvel
Burdette
Cleve
Judge
Kay
Madison
Orland
Stacy
Sumner
Verner
Welton
Chas
Clemens
Hayden
Parker
Tillman
Tim
Verle
Barton
Carey
Hans
Helen
Leamon
Maxie
Melton
Mitchel
Nunzio
Vicente
Waymon
Wylie
Crawford
Damon
Hilbert
Hiroshi
Hosea
Joyce
Loran
Lupe
Malvin
Odie
Orvil
Sandy
Angus
Cary
Donovan
Fredric
Hamilton
Hillard
Lawerence
Ludwig
Norval
Virgle
Archibald
Benjiman
Gaston
Gustav
Kendall
Kirby
Lorin
Melville
Whitney
Addison
Armond
Gino
Jerald
Joaquin
Ocie
Worth
Cedric
Jodie
Jones
Jonnie
Lindsay
Reinhold
Tracy
Wellington
Allison
Ardell
Artis
Arvin
Cleon
Ford
Gayle
Godfrey
Lindsey
Norton
Pierce
Watson
Durwood
Finis
Gardner
Lois
Mariano
Mickey
Berry
Edsel
Eduardo
Fidel
Garnet
Kennith
Laurel
Linus
Lorenza
Terrence
Weston
Auther
Chalmer
Eloy
Farris
Rosevelt
Ruth
Yoshio
Abram
Adelbert
Earlie
Ennis
Ezekiel
Gorden
Hilliard
Ivy
Kiyoshi
Lenwood
Llewellyn
Lucious
Rollie
Almon
Caleb
Emmit
Leonardo
Murl
Oakley
Daryl
Golden
Hardin
Masao
Rayburn
Rueben
Washington
Wyatt
Zack
Arne
Artie
Blake
Gerhard
Jon
Lesley
Levy
Margaret
Price
Wardell
Erling
Minoru
Agustin
Arch
Bailey
Christ
Courtney
Denis
Dewayne
Ewell
Huey
Joy
Malcom
Manley
Marco
Marcos
