# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154350;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              31
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15(?:
            [0-25-9]\\d\\d|
            310
          )\\d{6}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"494684", "Langeneß\ Hallig",
"493647", "Pößneck",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4935952", "Großröhrsdorf\ OL",
"492203", "Köln\-Porz",
"4935841", "Großschönau\ Sachsen",
"49221", "Köln",
"4935753", "Großräschen",
"4939883", "Groß\ Dölln",
"499242", "Gößweinstein",
"499141", "Weißenburg\ in\ Bayern",
"4936484", "Knau\ bei\ Pößneck",
"492339", "Sprockhövel\-Haßlinghausen",
"4935938", "Großpostwitz\ OL",
"4934901", "Roßlau\ Elbe",
"498633", "Tüßling",
"497162", "Süßen",
"4938234", "Born\ Darß",
"495053", "Faßberg\-Müden",
"495384", "Seesen\-Groß\ Rhüden",
"4936072", "Weißenborn\-Lüderode",
"4989", "München",
"495827", "Unterlüß",
"495064", "Groß\ Düngen",
"494497", "Barßel\-Harkebrügge",
"498807", "Dießen\ am\ Ammersee",
"498170", "Straßlach\-Dingharting",
"4936949", "Obermaßfeld\-Grimmenthal",
"4934445", "Stößen",
"4939976", "Groß\ Bützin",
"4934493", "Gößnitz\ Thüringen",
"496663", "Steinau\ an\ der\ Straße",
"498536", "Kößlarn",
"499636", "Plößberg",
"498367", "Roßhaupten\ Forggensee",
"4935726", "Groß\ Särchen",
"4935248", "Schönfeld\ bei\ Großenhain",
"4935240", "Tauscha\ bei\ Großenhain",
"497351", "Biberach\ an\ der\ Riß",
"496321", "Neustadt\ an\ der\ Weinstraße",
"499567", "Seßlach\-Gemünda",
"494483", "Ovelgönne\-Großenmeer",
"4939934", "Groß\ Plasten",
"494509", "Groß\ Grönau",
"497355", "Hochdorf\ Riß",
"49911", "Nürnberg",
"499656", "Moosbach\ bei\ Vohenstrauß",
"496364", "Nußbach\ Pfalz",
"496252", "Heppenheim\ Bergstraße",};
$areanames{en} = {"4935696", "Briesnig",
"494884", "Schwabstedt",
"498405", "Stammham\ bei\ Ingolstadt",
"495464", "Alfhausen",
"499187", "Altdorf\ bei\ Nürnberg",
"4935754", "Klettwitz",
"499321", "Kitzingen",
"4940", "Hamburg",
"499183", "Burgthann",
"496775", "Strüth\ Taunus",
"497738", "Steisslingen",
"4935725", "Wittichenau",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"499358", "Gössenheim",
"496395", "Münchweiler\ an\ der\ Rodalb",
"499445", "Neustadt\ an\ der\ Donau",
"4938375", "Koserow",
"492364", "Haltern\ Westfalen",
"494106", "Quickborn\ Kreis\ Pinneberg",
"497242", "Rheinstetten",
"4939857", "Drense",
"496384", "Konken",
"4936602", "Ronneburg\ Thüringen",
"496635", "Kirtorf",
"497624", "Grenzach\-Wyhlen",
"494735", "Butjadingen\-Stollhamm",
"4939268", "Egeln",
"495644", "Willebadessen\-Peckelsheim",
"499726", "Euerbach",
"498709", "Eching\ Niederbayern",
"497502", "Wolpertswende",
"4939922", "Dambeck\ bei\ Röbel",
"492137", "Neuss\-Norf",
"498822", "Oberammergau",
"495222", "Bad\ Salzuflen",
"498083", "Isen",
"496479", "Waldbrunn\ Westerwald",
"492133", "Dormagen",
"497307", "Senden\ Iller",
"4936085", "Reinholterode",
"499665", "Königstein\ Oberpfalz",
"499749", "Oberbach\ Unterfranken",
"4935605", "Komptendorf",
"4937322", "Brand\-Erbisdorf",
"496589", "Kell\ am\ See",
"493683", "Schmalkalden",
"497303", "Illertissen",
"497130", "Löwenstein\ Württemberg",
"4933603", "Falkenhagen\ bei\ Seelow",
"4939889", "Boitzenburg",
"497551", "Überlingen\ Bodensee",
"494525", "Ahrensbök",
"496085", "Waldsolms",
"499292", "Konradsreuth",
"4936259", "Tabarz\ Thüringer\ Wald",
"499848", "Simmershofen",
"497484", "Simmersfeld",
"492065", "Duisburg\-Rheinhausen",
"49651", "Trier",
"4934901", "Rosslau\ Elbe",
"4936254", "Friedrichswerth",
"496094", "Weibersbrunn",
"499948", "Eschlkam",
"4939884", "Hassleben\ bei\ Prenzlau",
"497574", "Gammertingen",
"4939421", "Osterwieck",
"4935247", "Zehren\ Sachsen",
"495836", "Wittingen\-Radenbeck",
"498236", "Fischach",
"497528", "Neukirch\ bei\ Tettnang",
"496566", "Körperich",
"498808", "Pähl",
"495208", "Leopoldshöhe",
"492586", "Beelen",
"4936042", "Tonna",
"494498", "Saterland\-Ramsloh",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"495936", "Twist",
"4935773", "Schleife",
"496403", "Linden\ Hessen",
"496056", "Bad\ Soden\-Salmünster",
"493423", "Eilenburg",
"495754", "Extertal\-Bremke",
"49760", "Oberried\ Breisgau",
"498592", "Wegscheid\ Niederbayern",
"4936027", "Lengenfeld\ Unterm\ Stein",
"495631", "Korbach",
"496407", "Rabenau\ Hessen",
"498773", "Neufahrn\ in\ Niederbayern",
"498393", "Holzgünz",
"498637", "Lohkirchen",
"497939", "Schrozberg\-Spielbach",
"4939323", "Schönhausen\ Elbe",
"4933232", "Brieselang",
"499536", "Kirchlauter",
"495771", "Rahden\ Westfalen",
"492555", "Schöppingen",
"498633", "Tüssling",
"497839", "Schapbach",
"4938323", "Prohn",
"499659", "Leuchtenberg",
"497306", "Vöhringen\ Iller",
"493686", "Eisfeld",
"498565", "Dietersburg\-Baumgarten",
"497642", "Endingen\ Kaiserstuhl",
"496235", "Schifferstadt",
"497224", "Gernsbach",
"495504", "Friedland\ Kreis\ Göttingen",
"4938209", "Sanitz\ bei\ Rostock",
"499727", "Schonungen\-Marktsteinach",
"499155", "Simmelsdorf",
"4937600", "Neumark\ Sachsen",
"496198", "Eppstein",
"4939204", "Niederndodeleben",
"498086", "Buchbach\ Oberbayern",
"494275", "Ehrenburg",
"4939209", "Wanzleben",
"4938204", "Broderstorf",
"499723", "Röthlein",
"4934207", "Zwochau",
"499804", "Aurach",
"499265", "Pressig",
"494107", "Siek\ Kreis\ Stormarn",
"4935930", "Seitschen",
"495309", "Lehre\-Wendhausen",
"4939365", "Bellingen\ bei\ Stendal",
"499904", "Lalling",
"4933765", "Märkisch\ Buchholz",
"494103", "Wedel",
"497462", "Immendingen",
"493981", "Neustrelitz",
"495244", "Rietberg",
"499186", "Lauterhofen\ Oberpfalz",
"495622", "Fritzlar",
"492409", "Stolberg\-Gressenich",
"498055", "Halfing",
"493881", "Grevesmühlen",
"4933920", "Walsleben\ bei\ Neuruppin",
"4936482", "Triptis",
"4933928", "Wildberg\ Brandenburg",
"498636", "Ampfing",
"4939241", "Leitzkau",
"499533", "Untermerzbach",
"495608", "Söhrewald",
"4938781", "Mellen",
"4934776", "Rothenschirmbach",
"499872", "Heilsbronn",
"494330", "Emkendorf",
"4933477", "Trebnitz\ bei\ Müncheberg",
"496057", "Flörsbachtal",
"4935938", "Grosspostwitz\ OL",
"496053", "Wächtersbach",
"4935876", "Weissenberg\ Sachsen",
"4933437", "Reichenberg\ bei\ Strausberg",
"496406", "Lollar",
"499332", "Marktbreit",
"499972", "Waldmünchen",
"494179", "Winsen\-Tönnhausen",
"494962", "Papenburg\-Aschendorf",
"495933", "Lathen",
"495373", "Hillerse\ Kreis\ Gifhorn",
"498237", "Aindling",
"495837", "Sprakensehl",
"492583", "Sassenberg",
"496567", "Oberkail",
"496563", "Kyllburg",
"493745", "Falkenstein\ Vogtland",
"492587", "Ennigerloh\-Westkirchen",
"4937608", "Waldenburg\ Sachsen",
"498233", "Kissing",
"494862", "Garding",
"495833", "Brome",
"495377", "Ehra\-Lessien",
"495482", "Tecklenburg",
"495937", "Geeste\-Gross\ Hesepe",
"496139", "Budenheim",
"496362", "Alsenz",
"492473", "Simmerath",
"495572", "Bodenfelde",
"495231", "Detmold",
"492382", "Ahlen\ Westfalen",
"499925", "Bayerisch\ Eisenstein",
"499366", "Geroldshausen\ Unterfranken",
"492903", "Meschede\-Freienohl",
"496297", "Ravenstein\ Baden",
"4936484", "Knau\ bei\ Pössneck",
"492803", "Wesel\-Büderich",
"496731", "Alzey",
"499825", "Herrieden",
"496293", "Schefflenz",
"494754", "Bülkau",
"496654", "Gersfeld\ Rhön",
"494631", "Glücksburg\ Ostsee",
"497173", "Heubach",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"497545", "Immenstaad\ am\ Bodensee",
"494771", "Hemmoor",
"49931", "Würzburg",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"494796", "Teufelsmoor",
"492541", "Coesfeld",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"4934298", "Taucha\ bei\ Leipzig",
"4938202", "Volkenshagen",
"492638", "Waldbreitbach",
"496696", "Gilserberg",
"496876", "Weiskirchen\ Saar",
"495525", "Walkenried",
"497964", "Stödtlen",
"498670", "Reischach\ Kreis\ Altötting",
"499402", "Regenstauf",
"4939202", "Gross\ Ammensleben",
"496336", "Dellfeld",
"492778", "Siegbach",
"4939036", "Binde",
"494208", "Grasberg",
"492724", "Finnentrop\-Serkenrode",
"494836", "Hennstedt\ Dithmarschen",
"499099", "Kaisheim",
"494936", "Grossheide",
"498442", "Wolnzach",
"494644", "Karby",
"4934221", "Schildau\ Gneisenaustadt",
"496744", "Oberwesel",
"494222", "Ganderkesee",
"496182", "Seligenstadt",
"496558", "Büdesheim\ Eifel",
"492162", "Viersen",
"499451", "Schierling",
"492339", "Sprockhövel\-Hasslinghausen",
"499220", "Kasendorf\-Azendorf",
"493501", "Pirna",
"499474", "Schmidmühlen",
"495439", "Bersenbrück",
"499428", "Kirchroth",
"4937203", "Gersdorf\ bei\ Chemnitz",
"498284", "Ziemetshausen",
"494464", "Wittmund\-Carolinensiel",
"495675", "Trendelburg",
"498295", "Altenmünster\ Schwaben",
"492534", "Münster\-Roxel",
"4939051", "Calvörde",
"4938796", "Viesecke",
"493847", "Sternberg",
"497436", "Messstetten\-Oberdigisheim",
"497026", "Lenningen",
"498138", "Schwabhausen\ bei\ Dachau",
"493943", "Wernigerode",
"496068", "Beerfelden",
"492252", "Zülpich",
"4933396", "Klosterfelde",
"493947", "Thale",
"49365", "Gera",
"493843", "Güstrow",
"499134", "Neunkirchen\ am\ Brand",
"4937324", "Reinsberg\ Sachsen",
"494933", "Dornum\ Ostfriesland",
"495962", "Herzlake",
"494837", "Neuenkirchen\ Dithmarschen",
"499480", "Sünching",
"498262", "Mittelneufnach",
"495862", "Hitzacker\ Elbe",
"494833", "Wesselburen",
"496532", "Zeltingen\-Rachtig",
"4939407", "Seehausen\ Börde",
"4937329", "Grosshartmannsdorf",
"492601", "Nauort",
"496271", "Eberbach\ Baden",
"494482", "Hatten",
"4939929", "Jabel\ bei\ Waren",
"497191", "Backnang",
"496333", "Waldfischbach\-Burgalben",
"496697", "Willingshausen",
"499288", "Bad\ Steben",
"4934927", "Globig\-Bleddin",
"4938845", "Kaarssen",
"4939955", "Jürgenstorf",
"496873", "Nonnweiler",
"496693", "Neuental",
"4939924", "Stuer",
"494231", "Verden\ Aller",
"496337", "Grossbundenbach",
"494793", "Hambergen",
"496254", "Lautertal\ Odenwald",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"493774", "Schwarzenberg",
"4936604", "Münchenbernsdorf",
"492742", "Wissen",
"499562", "Sonnefeld",
"494608", "Handewitt",
"498424", "Nassenfels",
"492195", "Radevormwald",
"497176", "Spraitbach",
"498034", "Brannenburg",
"496164", "Reichelsheim\ Odenwald",
"499367", "Unterpleichfeld",
"496296", "Ahorn\ Baden",
"492238", "Pulheim",
"4933200", "Bergholz\-Rehbrücke",
"493385", "Rathenow",
"493634", "Sömmerda",
"498152", "Herrsching\ am\ Ammersee",
"4935752", "Ruhland",
"493394", "Wittstock\ Dosse",
"499363", "Arnstein\ Unterfranken",
"4933234", "Wustermark",
"4933208", "Fahrland",
"495103", "Wennigsen\ Deister",
"497023", "Weilheim\ an\ der\ Teck",
"493946", "Quedlinburg",
"497433", "Balingen",
"4933239", "Gross\ Behnitz",
"499141", "Weissenburg\ in\ Bayern",
"494244", "Harpstedt",
"496722", "Rüdesheim\ am\ Rhein",
"496809", "Grossrosseln",
"4934441", "Hohenmölsen",
"494622", "Taarstedt",
"493461", "Merseburg\ Saale",
"498041", "Bad\ Tölz",
"492652", "Mendig",
"494504", "Ratekau",
"498335", "Fellheim",
"498684", "Fridolfing",
"4934343", "Regis\-Breitingen",
"4936252", "Tambach\-Dietharz",
"495043", "Lauenau",
"4939882", "Gollin",
"495275", "Höxter\-Ottbergen",
"493641", "Jena",
"4935057", "Hermsdorf\ Erzgebirge",
"498465", "Kipfenberg",
"497134", "Weinsberg",
"496757", "Becherbach\ bei\ Kirn",
"498076", "Pfaffing",
"494285", "Rhade\ bei\ Zeven",
"495404", "Westerkappeln",
"496753", "Meisenheim",
"494294", "Riede\ Kreis\ Verden",
"497570", "Sigmaringen\-Gutenstein",
"499191", "Forchheim\ Oberfranken",
"494166", "Ahlerstedt",
"493996", "Teterow",
"497052", "Bad\ Liebenzell",
"4935207", "Moritzburg",
"4935751", "Welzow",
"492304", "Schwerte",
"492226", "Rheinbach",
"493691", "Eisenach\ Thüringen",
"493871", "Parchim",
"494256", "Hilgermissen",
"497562", "Isny\ im\ Allgäu",
"4935693", "Lauschütz",
"499176", "Allersberg",
"493971", "Anklam",
"493331", "Angermünde",
"492509", "Nottuln\-Appelhülsen",
"497367", "Aalen\-Ebnat",
"492623", "Ransbach\-Baumbach",
"499605", "Weiherhammer",
"492627", "Braubach",
"497363", "Lauchheim",
"498091", "Kirchseeon",
"4938455", "Plaaz",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"494743", "Langen\ bei\ Bremerhaven",
"4938429", "Glasin",
"496643", "Herbstein",
"496647", "Herbstein\-Stockhausen",
"4939455", "Schierke",
"498459", "Manching",
"4938424", "Bobitz",
"494747", "Beverstedt",
"497141", "Ludwigsburg\ Württemberg",
"499433", "Nabburg",
"498868", "Schwabsoien",
"4934909", "Aken\ Elbe",
"496506", "Welschbillig",
"492360", "Haltern\-Lippramsdorf",
"4936642", "Harra",
"4934904", "Oranienbaum",
"4938326", "Grimmen",
"4939881", "Ringenwalde\ bei\ Templin",
"4934978", "Radegast\ Kreis\ Köthen",
"497620", "Schopfheim\-Gersbach",
"493344", "Bad\ Freienwalde",
"492372", "Hemer",
"492932", "Neheim\-Hüsten",
"498123", "Moosinning",
"495582", "Sankt\ Andreasberg",
"4933606", "Müllrose",
"495158", "Hemeringen",
"498381", "Lindenberg\ im\ Allgäu",
"496246", "Eich\ Rheinhessen",
"492832", "Kevelaer",
"496467", "Hatzfeld\ Eder",
"495472", "Bad\ Essen",
"495121", "Hildesheim",
"492573", "Nordwalde",
"494189", "Undeloh",
"496229", "Neckarsteinach",
"495383", "Lutter\ am\ Barenberge",
"496328", "Elmstein",
"497366", "Abtsgmünd",
"4939201", "Wolmirstedt",
"494951", "Weener",
"496374", "Weilerbach",
"4936847", "Steinbach\-Hallenberg",
"4933875", "Rhinow",
"4933835", "Golzow\ bei\ Brandenburg",
"497825", "Kippenheim",
"498505", "Hutthurm",
"492626", "Selters\ Westferwald",
"495564", "Dassel",
"496834", "Bous",
"4938757", "Neustadt\-Glewe",
"4938201", "Gelbensande",
"494851", "Marne",
"496785", "Herrstein",
"4935825", "Kodersdorf",
"494928", "Ihlow\-Riepe",
"494974", "Neuharlingersiel",
"499173", "Thalmässing",
"494334", "Bredenbek\ bei\ Rendsburg",
"496351", "Eisenberg\ Pfalz",
"494257", "Schweringen",
"494253", "Asendorf\ Kreis\ Diepholz",
"494828", "Lägerdorf",
"499177", "Heideck",
"499545", "Buttenheim",
"494874", "Todenbüttel",
"49731", "Ulm\ Donau",
"492858", "Hünxe",
"492223", "Königswinter",
"499205", "Vorbach",
"494167", "Apensen",
"497761", "Bad\ Säckingen",
"495132", "Lehrte",
"494163", "Horneburg\ Niederelbe",
"499964", "Stallwang",
"492227", "Bornheim\-Merten",
"495071", "Schwarmstedt",
"497402", "Fluorn\-Winzeln",
"492958", "Büren\-Harth",
"493677", "Ilmenau\ Thüringen",
"494539", "Westerau",
"4934605", "Gröbers",
"496756", "Winterbach\ Soonwald",
"492821", "Kleve\ Niederrhein",
"493733", "Annaberg\-Buchholz",
"498245", "Türkheim\ Wertach",
"495845", "Bergen\ Dumme",
"492921", "Soest",
"493737", "Rochlitz",
"498073", "Gars\ am\ Inn",
"495945", "Wilsum",
"495054", "Bergen\-Sülze",
"496841", "Homburg\ Saar",
"49641", "Giessen",
"4939052", "Erxleben\ bei\ Haldensleben",
"497451", "Horb\ am\ Neckar",
"494425", "Wangerland\-Hooksiel",
"497220", "Forbach\-Hundsbach",
"497584", "Altshausen",
"492486", "Nettersheim",
"4938789", "Wolfshagen\ bei\ Perleberg",
"4939244", "Steutz",
"492759", "Bad\ Berleburg\-Aue",
"496243", "Monsheim",
"496247", "Worms\-Pfeddersheim",
"4938784", "Kleinow\ Kreis\ Prignitz",
"497474", "Haigerloch",
"497428", "Rosenfeld",
"496466", "Dautphetal\-Friedensdorf",
"495355", "Frellstedt",
"494902", "Jemgum\-Ditzum",
"495448", "Barver",
"496507", "Neumagen\-Dhron",
"494802", "Wrohm",
"497389", "Heroldstatt",
"4934773", "Schwittersdorf",
"4934222", "Arzberg\ bei\ Torgau",
"496503", "Hermeskeil",
"493523", "Coswig\ bei\ Dresden",
"496629", "Schenklengsfeld",
"496302", "Winnweiler",
"499436", "Nittenau",
"492455", "Waldfeucht",
"498783", "Rohr\ in\ Niederbayern",
"493322", "Falkensee",
"496646", "Grebenau",
"4935873", "Herrnhut",
"494746", "Hagen\ bei\ Bremerhaven",
"492591", "Lüdinghausen",
"4939745", "Hetzdorf\ bei\ Strasburg",
"492963", "Brilon\-Messinghausen",
"499306", "Kist",
"4936377", "Rastenberg",
"496432", "Diez",
"492867", "Heiden\ Kreis\ Borken",
"496022", "Obernburg\ am\ Main",
"494158", "Roseburg",
"4936945", "Henneberg",
"4933977", "Gumtow",
"499278", "Weidenberg",
"496887", "Schmelz\ Saar",
"499642", "Kemnath\ Stadt",
"4935478", "Goyatz",
"492863", "Velen",
"4936337", "Schiedungen",
"494121", "Elmshorn",
"497727", "Vöhrenbach",
"496281", "Buchen\ Odenwald",
"494472", "Lastrup",
"498346", "Pforzen",
"4936481", "Neustadt\ an\ der\ Orla",
"4939033", "Wallstawe",
"492261", "Gummersbach",
"494383", "Grebin",
"497723", "Furtwangen\ im\ Schwarzwald",
"497804", "Oppenau",
"495743", "Espelkamp\-Gestringen",
"499701", "Sandberg\ Unterfranken",
"497265", "Angelbachtal",
"493935", "Tangerhütte",
"497904", "Ilshofen",
"493375", "Königs\ Wusterhausen",
"4939087", "Jerchel\ Altmark",
"492151", "Krefeld",
"499462", "Falkenstein\ Oberpfalz",
"498741", "Vilsbiburg",
"494268", "Bötersen",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"492174", "Burscheid\ Rheinland",
"498856", "Penzberg",
"497533", "Allensbach",
"4937206", "Frankenberg\ Sachsen",
"492102", "Ratingen",
"496650", "Hosenfeld",
"4938227", "Lüdershagen\ bei\ Barth",
"4934224", "Belgern\ Sachsen",
"4938793", "Dergenthin",
"493561", "Guben",
"497972", "Gschwend\ bei\ Gaildorf",
"497332", "Lauterstein",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"4938782", "Reetz\ bei\ Perleberg",
"495657", "Meissner",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"494404", "Elsfleth",
"49511", "Hannover",
"4937465", "Tannenbergsthal\ Vogtland",
"498628", "Kienberg\ Oberbayern",
"495653", "Sontra",
"4939242", "Prödel",
"497259", "Östringen\-Odenheim",
"495294", "Hövelhof\-Espeln",
"4939059", "Wegenstedt",
"496008", "Echzell",
"495166", "Walsrode\-Kirchboitzen",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"498734", "Reisbach\ Niederbayern",
"498651", "Bad\ Reichenhall",
"4939054", "Flechtingen",
"4937295", "Lugau\ Erzgebirge",
"495902", "Freren",
"496681", "Hilders",
"494355", "Rieseby",
"497321", "Heidenheim\ an\ der\ Brenz",
"497183", "Rudersberg\ Württemberg",
"495802", "Wrestedt",
"498202", "Althegnenberg",
"499738", "Rottershausen",
"492661", "Bad\ Marienberg\ Westerwald",
"4939388", "Goldbeck\ Altm",
"4939921", "Ankershagen",
"496044", "Schotten\ Hessen",
"497445", "Pfalzgrafenweiler",
"497358", "Eberhardzell\-Füramoos",
"494240", "Syke\-Heiligenfelde",
"4937321", "Frankenstein\ Sachsen",
"496855", "Freisen",
"499242", "Gössweinstein",
"495746", "Rödinghausen",
"499624", "Ensdorf\ Oberpfalz",
"497726", "Bad\ Dürrheim",
"498347", "Friesenried",
"49291", "Meschede",
"494668", "Klanxbüll",
"499502", "Frensdorf",
"495035", "Gross\ Munzel",
"49281", "Wesel",
"492441", "Kall",
"49214", "Leverkusen",
"496104", "Heusenstamm",
"498343", "Aitrang",
"495425", "Borgholzhausen",
"4936601", "Hermsdorf\ Thüringen",
"499307", "Altertheim",
"492866", "Dorsten\-Rhade",
"497665", "March\ Breisgau",
"498542", "Ortenburg",
"4937423", "Adorf\ Vogtland",
"4933967", "Freyenstein",
"495341", "Salzgitter",
"499303", "Eibelstadt",
"492325", "Wanne\-Eickel",
"499551", "Burgwindheim",
"499484", "Brennberg",
"495167", "Walsrode\-Westenholz",
"4934444", "Lützen",
"495163", "Fallingbostel\-Dorfmark",
"494132", "Amelinghausen",
"496345", "Albersweiler",
"497948", "Öhringen\-Ohrnberg",
"496458", "Rosenthal\ Hessen",
"499495", "Breitenbrunn\ Oberpfalz",
"496869", "Merzig\-Silwingen",
"499574", "Marktzeuln",
"4933231", "Pausin",
"494845", "Ostenfeld\ Husum",
"495656", "Waldkappel",
"499528", "Donnersdorf",
"493762", "Crimmitschau",
"4937435", "Reuth\ bei\ Plauen",
"4934346", "Narsdorf",
"496421", "Marburg",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"498161", "Freising",
"496031", "Friedberg\ Hessen",
"494945", "Grossefehn\-Timmel",
"4936644", "Hirschberg\ Saale",
"492434", "Wegberg",
"495951", "Werlte",
"4939998", "Loitz\ bei\ Demmin",
"4936649", "Gefell\ bei\ Schleiz",
"498251", "Aichach",
"495851", "Dahlenburg",
"494564", "Schashagen",
"4936041", "Bad\ Tennstedt",
"4938422", "Neukloster",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"498857", "Benediktbeuern",
"495257", "Hövelhof",
"495685", "Knüllwald",
"4939422", "Badersleben",
"495253", "Bad\ Driburg",
"495828", "Himbergen",
"495874", "Soltendieck",
"498274", "Buttenwiesen",
"495694", "Diemelstadt",
"4934953", "Gräfenhainichen",
"498394", "Lautrach",
"493588", "Niesky",
"492620", "Neuhäusel\ Westerwald",
"498385", "Hergatz",
"498634", "Garching\ an\ der\ Alz",
"4939382", "Kamern",
"498751", "Mainburg",
"496404", "Lich\ Hessen",
"495753", "Auetal\-Bernsen",
"4933054", "Liebenwalde",
"498728", "Geratskirchen",
"4936465", "Oberndorf\ bei\ Apolda",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"497573", "Stetten\ am\ kalten\ Markt",
"4936072", "Weissenborn\-Lüderode",
"497577", "Veringenstadt",
"497145", "Markgröningen",
"4938393", "Binz\ Ostseebad",
"497832", "Haslach\ im\ Kinzigtal",
"499652", "Waidhaus",
"4936206", "Grossfahner",
"497483", "Horb\-Mühringen",
"497932", "Niederstetten\ Württemberg",
"4939393", "Werben\ Elbe",
"496093", "Laufach",
"494148", "Drochtersen\-Assel",
"496268", "Hüffenhardt",
"495506", "Adelebsen",
"4935795", "Königsbrück",
"498538", "Pocking\-Hartkirchen",
"497226", "Bühl\-Sand",
"4937383", "Lunzenau",
"498641", "Grassau\ Kreis\ Traunstein",
"493695", "Bad\ Salzungen",
"493335", "Finowfurt",
"492052", "Velbert\-Langenberg",
"49906", "Donauwörth",
"497304", "Blaustein\ Württemberg",
"4933087", "Bredereiche",
"495643", "Borgentreich",
"497249", "Stutensee",
"4989", "Munich",
"498084", "Taufkirchen\ Vils",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"4936783", "Gehren\ Thüringen",
"4933676", "Friedland\ bei\ Beeskow",
"498095", "Aying",
"495647", "Lichtenau\-Kleinenberg",
"498461", "Beilngries",
"497627", "Steinen\ Kreis\ Lörrach",
"49340", "Dessau\ Anh",
"496387", "Sankt\ Julian",
"4933745", "Petkus",
"494281", "Zeven",
"492363", "Datteln",
"496472", "Weilmünster",
"499906", "Mariaposching",
"4939345", "Parchen",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"498702", "Wörth\ an\ der\ Isar",
"4935023", "Bad\ Gottleuba",
"4939992", "Görmin",
"492367", "Henrichenburg",
"496383", "Glan\-Münchweiler",
"4936737", "Drognitz",
"4939977", "Jördenstorf",
"497623", "Rheinfelden\ Baden",
"499238", "Röslau",
"4938428", "Hohenkirchen\ bei\ Wismar",
"499195", "Adelsdorf\ Mittelfranken",
"496582", "Freudenburg",
"496158", "Riedstadt",
"494740", "Loxstedt\-Dedesdorf",
"494883", "Süderstapel",
"494432", "Dötlingen\-Brettorf",
"499742", "Kalbach\ Rhön",
"495467", "Voltlage",
"4939428", "Pabstorf",
"499184", "Deining\ Oberpfalz",
"495246", "Verl",
"498846", "Uffing\ am\ Staffelsee",
"492562", "Gronau\ Westfalen",
"492474", "Nideggen\-Schmidt",
"496096", "Wiesen\ Unterfranken",
"495351", "Helmstedt",
"4934635", "Bad\ Lauchstädt",
"492428", "Niederzier",
"497486", "Horb\-Altheim",
"4935472", "Schlepzig",
"498552", "Grafenau\ Niederbayern",
"495934", "Haren\-Rütenbrock",
"499339", "Ippesheim",
"499162", "Scheinfeld",
"495374", "Isenbüttel",
"492451", "Geilenkirchen",
"495328", "Altenau\ Harz",
"492584", "Warendorf\-Milte",
"496564", "Neuerburg\ Eifel",
"495834", "Wittingen\-Knesebeck",
"498234", "Bobingen",
"4935267", "Diesbar\-Seusslitz",
"492595", "Olfen",
"4938780", "Lanz\ Brandenburg",
"497576", "Krauchenwies",
"499252", "Helmbrechts",
"499088", "Mönchsdeggingen",
"499170", "Schwanstetten",
"497455", "Dornhan",
"496054", "Birstein",
"497348", "Beimerstetten",
"494172", "Salzhausen",
"494421", "Wilhelmshaven",
"492389", "Werne",
"4934746", "Giersleben",
"499534", "Burgpreppach",
"496071", "Dieburg",
"494458", "Wiefelstede\-Spohle",
"496132", "Ingelheim\ am\ Rhein",
"4938231", "Barth",
"498062", "Bruckmühl\ Mangfall",
"4937367", "Lengefeld\ Erzgebirge",
"4937601", "Mülsen\ Skt\ Jacob",
"4936423", "Orlamünde",
"499201", "Gesees",
"497765", "Rickenbach\ Hotzenwald",
"49231", "Dortmund",
"495466", "Merzen",
"498847", "Obersöchering",
"495247", "Harsewinkel",
"496668", "Birstein\-Lichenroth",
"492825", "Uedem",
"499803", "Colmberg",
"497626", "Kandern",
"498241", "Buchloe",
"495841", "Lüchow\ Wendland",
"496386", "Altenkirchen\ Pfalz",
"494768", "Hipstedt",
"499907", "Zenting",
"49541", "Osnabrück",
"499903", "Schöllnach",
"496500", "Waldrach",
"494104", "Aumühle\ bei\ Hamburg",
"492925", "Warstein\-Allagen",
"492366", "Herten\ Westfalen",
"495941", "Neuenhaus\ Dinkel",
"492688", "Kroppach",
"4938788", "Gross\ Warnow",
"495302", "Vechelde",
"494955", "Westoverledingen",
"498501", "Thyrnau",
"4933921", "Zechlinerhütte",
"497821", "Lahr\ Schwarzwald",
"499778", "Fladungen",
"495646", "Willebadessen",
"499724", "Stadtlauringen",
"494855", "Eddelak",
"4939248", "Dobritz",
"495507", "Ebergötzen",
"496781", "Idar\-Oberstein",
"4935931", "Königswartha",
"497227", "Lichtenau\ Baden",
"499398", "Birkenfeld\ bei\ Würzburg",
"492402", "Stolberg\ Rheinland",
"494681", "Wyk\ auf\ Föhr",
"496355", "Albisheim\ Pfrimm",
"497958", "Rot\ Am\ See\-Brettheim",
"497223", "Bühl\ Baden",
"499638", "Neualbenreuth",
"492761", "Olpe\ Biggesee",
"4935971", "Sebnitz",
"495503", "Nörten\-Hardenberg",
"4939606", "Glienke",
"493944", "Blankenburg\ Harz",
"492972", "Schmallenberg",
"495281", "Bad\ Pyrmont",
"492332", "Gevelsberg",
"4934291", "Borsdorf",
"492692", "Kelberg",
"493844", "Schwaan",
"492872", "Rhede\ Westfalen",
"495022", "Wietzen",
"498283", "Neuburg\ an\ der\ Kammel",
"495883", "Lemgow",
"494463", "Wangerland",
"495432", "Löningen",
"494467", "Wittmund\-Funnix",
"4934461", "Nebra\ Unstrut",
"492533", "Münster\-Nienberge",
"494246", "Twistringen\-Heiligenloh",
"494506", "Stockelsdorf\-Krumbeck",
"4939003", "Jübar",
"499382", "Gerolzhofen",
"499473", "Kallmünz",
"497720", "Schwenningen\ am\ Neckar",
"497042", "Vaihingen\ an\ der\ Enz",
"494643", "Gelting\ Angeln",
"4935474", "Schönwalde\ bei\ Lübben",
"4935439", "Zinnitz",
"496743", "Bacharach",
"4939726", "Ducherow",
"4939050", "Bartensleben",
"496747", "Emmelshausen",
"498368", "Halblech",
"4938726", "Spornitz",
"498686", "Petting",
"4934363", "Cavertitz",
"4936926", "Creuzburg",
"4935434", "Altdöbern",
"493831", "Stralsund",
"497261", "Sinsheim",
"4939058", "Uthmöden",
"492723", "Kirchhundem",
"493371", "Luckenwalde",
"493931", "Stendal",
"496256", "Lampertheim\-Hüttenfeld",
"4935453", "Drahnsdorf",
"498745", "Bodenkirchen",
"498669", "Traunreut",
"497967", "Jagstzell",
"497963", "Adelmannsfelden",
"495650", "Cornberg",
"495148", "Steinhorst\ Niedersachsen",
"498192", "Schondorf\ am\ Ammersee",
"496166", "Fischbachtal",
"499409", "Pielenhofen",
"497128", "Sonnenbühl",
"498036", "Stephanskirchen\ Simssee",
"497174", "Mögglingen",
"498426", "Walting\ Kreis\ Eichstätt",
"499092", "Wemding",
"496657", "Hofbieber",
"496285", "Walldürn\-Altheim",
"494125", "Seestermühe",
"492904", "Bestwig",
"494757", "Wanna",
"497151", "Waiblingen",
"493636", "Greussen",
"492804", "Xanten\-Marienbaum",
"494753", "Balje",
"496294", "Krautheim\ Jagst",
"49611", "Wiesbaden",
"492265", "Reichshof\-Eckenhagen",
"496653", "Burghaun",
"498683", "Tittmoning",
"495044", "Springe\-Eldagsen",
"495955", "Esterwegen",
"4938823", "Selmsdorf",
"494302", "Kirchbarkau",
"496746", "Pfalzfeld",
"4939823", "Rechlin",
"494646", "Mohrkirch",
"495855", "Nahrendorf",
"498687", "Taching\-Tengling",
"492948", "Lippstadt\-Rebbeke",
"495681", "Homberg\ Efze",
"492292", "Windeck\ Sieg",
"4936074", "Worbis",
"494503", "Timmendorfer\ Strand",
"496802", "Völklingen\-Lauterbach",
"498340", "Baisweil",
"4933052", "Leegebruch",
"494243", "Twistringen",
"499555", "Schlüsselfeld\-Aschbach",
"492536", "Münster\-Albachten",
"4936640", "Remptendorf",
"494466", "Wittmund\-Ardorf",
"499491", "Hemau",
"496341", "Landau\ in\ der\ Pfalz",
"4938486", "Gustävel",
"494247", "Affinghausen",
"4939384", "Arendsee\ Altmark",
"49441", "Oldenburg",
"494841", "Husum\ Nordsee",
"495768", "Petershagen\-Heimsen",
"4939389", "Schollene",
"496425", "Rauschenberg\ Hessen",
"497024", "Wendlingen\ am\ Neckar",
"496035", "Reichelsheim\ Wetterau",
"494941", "Aurich",
"497434", "Winterlingen",
"498165", "Neufahrn\ bei\ Freising",
"496656", "Ebersburg",
"494489", "Apen",
"494756", "Odisheim",
"498269", "Unteregg\ bei\ Mindelheim",
"495250", "Delbrück\ Westfalen",
"492445", "Schleiden\ Eifel",
"492358", "Meinerzhagen\-Valbert",
"495031", "Wunstorf",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"499364", "Zellingen",
"495172", "Ilsede",
"4939994", "Metschow",
"492183", "Rommerskirchen",
"496167", "Modautal",
"493773", "Johanngeorgenstadt",
"498427", "Wellheim",
"497661", "Kirchzarten",
"493592", "Kirschau",
"495345", "Baddeckenstedt",
"4936648", "Dittersdorf\ bei\ Schleiz",
"495458", "Hopsten",
"498423", "Titting",
"498033", "Oberaudorf",
"4939999", "Tutow",
"496163", "Höchst\ im\ Odenwald",
"496334", "Thaleischweiler\-Fröschen",
"496257", "Seeheim\-Jugenheim",
"4934325", "Mochau\-Lüttewitz",
"4933201", "Gross\ Glienicke",
"494351", "Eckernförde",
"497966", "Unterschneidheim",
"497325", "Sontheim\ an\ der\ Brenz",
"496874", "Wadern\-Nunkirchen",
"499569", "Sesslach",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"496694", "Neukirchen\ Knüll",
"496253", "Fürth\ Odenwald",
"494794", "Worpswede\-Ostersode",
"499133", "Baiersdorf\ Mittelfranken",
"49781", "Offenburg",
"494934", "Marienhafe",
"497441", "Freudenstadt",
"494328", "Rickling",
"494834", "Büsum",
"496851", "St\ Wendel",
"49791", "Schwäbisch\ Hall",
"497586", "Herbertingen",
"4934497", "Langenleuba\-Niederhain",
"498452", "Geisenfeld",
"493542", "Lübbenau\ Spreewald",
"4933051", "Nassenheide",
"492574", "Saerbeck",
"492528", "Ennigerloh\-Enniger",
"49375", "Zwickau",
"497300", "Roggenburg",
"495384", "Seesen\-Gross\ Rhüden",
"495635", "Vöhl",
"496464", "Angelburg",
"498178", "Icking",
"4936203", "Vieselbach",
"497476", "Bisingen",
"498124", "Forstern\ Oberbayern",
"492551", "Steinfurt\-Burgsteinfurt",
"495775", "Diepenau",
"4933654", "Fünfeichen",
"4939264", "Kroppenstedt",
"4939396", "Neukirchen\ Altmark",
"492484", "Mechernich\-Eiserfey",
"497555", "Deggenhausertal",
"496081", "Usingen",
"492839", "Straelen\-Herongen",
"4934956", "Zörbig",
"494521", "Eutin",
"492379", "Menden\-Asbeck",
"4938305", "Gingst",
"494182", "Tostedt",
"494558", "Todesfelde",
"494744", "Loxstedt",
"496222", "Wiesloch",
"496644", "Grebenhain",
"499180", "Pyrbaum",
"499434", "Bodenwöhr",
"499078", "Mertingen",
"492242", "Hennef\ Sieg",
"496836", "Überherrn",
"492678", "Büchel\ bei\ Cochem",
"492624", "Höhr\-Grenzhausen",
"498630", "Oberneukirchen",
"4933202", "Töplitz",
"497364", "Oberkochen",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"496400", "Mücke",
"494876", "Reher\ Holstein",
"495085", "Burgdorf\-Ehlershausen",
"499661", "Sulzbach\-Rosenberg",
"492738", "Netphen",
"494336", "Owschlag",
"494976", "Spiekeroog",
"49551", "Göttingen",
"499325", "Kleinlangheim",
"499966", "Wiesenfelden",
"492303", "Unna",
"492307", "Kamen",
"494671", "Bredstedt",
"497569", "Isny\-Eisenbach",
"498762", "Wartenberg\ Oberbayern",
"496771", "St\ Goarshausen",
"499441", "Kelheim",
"4933633", "Spreenhagen",
"4936258", "Friemar",
"495056", "Winsen\-Meissendorf",
"494297", "Ottersberg\-Posthausen",
"49981", "Ansbach",
"497133", "Lauffen\ am\ Neckar",
"496391", "Dahn",
"4939888", "Lychen",
"495403", "Bad\ Iburg",
"49991", "Deggendorf",
"495407", "Wallenhorst",
"496631", "Alsfeld",
"494731", "Nordenham",
"494293", "Ottersberg\-Fischerhude",
"496754", "Martinstein",
"492502", "Nottuln",
"4933673", "Weichensdorf",
"498142", "Olching",
"495198", "Schneverdingen\-Wintermoor",
"498784", "Hohenthann",
"4935843", "Hirschfelde\ bei\ Zittau",
"4935953", "Burkau",
"493741", "Plauen",
"499102", "Wilhermsdorf",
"498375", "Weitnau",
"4934743", "Ermsleben",
"493578", "Kamenz",
"492752", "Bad\ Laasphe",
"496504", "Thalfang",
"495235", "Blomberg\ Lippe",
"496622", "Bebra",
"497382", "Römerstein",
"497477", "Jungingen\ bei\ Hechingen",
"4934292", "Brandis\ bei\ Wurzen",
"496244", "Westhofen\ Rheinhessenen",
"4938208", "Kavelstorf",
"494722", "Cuxhaven\-Altenbruch",
"497473", "Mössingen",
"4939208", "Loitsche",
"499720", "Üchtelhausen",
"4938234", "Born\ Darss",
"493346", "Seelow",
"4934462", "Laucha\ Unstrut",
"497587", "Hosskirch",
"493329", "Stahnsdorf",
"497583", "Bad\ Schussenried",
"494296", "Schwanewede\-Aschwarden",
"499261", "Kronach",
"497705", "Wolterdingen\ Schwarzw",
"495406", "Belm",
"498074", "Schnaitsee",
"495053", "Fassberg\-Müden",
"498028", "Fischbachau",
"497136", "Bad\ Friedrichshall",
"492642", "Remagen",
"4937604", "Mosel",
"4939200", "Gommern",
"492224", "Bad\ Honnef",
"494708", "Ringstedt",
"493628", "Arnstadt",
"492306", "Lünen",
"498230", "Gablingen",
"493994", "Malchin",
"494164", "Harsefeld",
"499963", "Konzell",
"498051", "Prien\ am\ Chiemsee",
"4937609", "Wolkenburg\ Mulde",
"499867", "Geslau",
"4935895", "Klitten",
"494877", "Hennstedt\ bei\ Itzehoe",
"499128", "Feucht",
"4936426", "Ottendorf\ bei\ Stadtroda",
"4935934", "Grossdubrau",
"495139", "Burgwedel",
"494973", "Wittmund\-Burhafe",
"499174", "Hilpoltstein",
"495362", "Wolfsburg\-Fallersleben",
"494333", "Erfde",
"496231", "Hochdorf\-Assenheim",
"494337", "Jevenstedt",
"494254", "Eystrup",
"494977", "Blomberg\ Ostfriesland",
"496050", "Biebergemünd",
"498561", "Pfarrkirchen\ Niederbayern",
"4937755", "Schönheide\ Erzgebirge",
"496572", "Manderscheid\ Eifel",
"4935974", "Hinterhermsdorf",
"4935939", "Hochkirch",
"494873", "Aukrug",
"496837", "Wallerfangen",
"4933929", "Gühlen\-Glienicke",
"499151", "Hersbruck",
"496373", "Schönenberg\-Kübelberg",
"492462", "Linnich",
"4933845", "Borkheide",
"494271", "Sulingen",
"4933924", "Rägelin",
"496482", "Runkel",
"494532", "Bargteheide",
"495563", "Kreiensen",
"496833", "Rehlingen\-Siersburg",
"4939006", "Miesterhorst",
"498733", "Mengkofen",
"498291", "Zusmarshausen",
"4934464", "Freyburg\ Unstrut",
"495671", "Hofgeismar",
"4939723", "Krien",
"497162", "Süssen",
"4934299", "Gaschwitz",
"498677", "Burghausen\ Salzach",
"494403", "Bad\ Zwischenahn",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4938232", "Zingst\ Ostseebad",
"4936923", "Treffurt",
"4938723", "Kladrum",
"495654", "Herleshausen",
"494407", "Wardenburg",
"4938297", "Moitin",
"495293", "Paderborn\-Dahl",
"499576", "Lichtenfels\-Isling",
"495731", "Bad\ Oeynhausen",
"4934294", "Rackwitz",
"497252", "Bretten",
"4935471", "Birkenhainchen",
"4939603", "Burg\ Stargard",
"499348", "Werbach\-Gamburg",
"492436", "Wegberg\-Rödgen",
"495696", "Bad\ Arolsen\-Landau",
"496525", "Irrel",
"498276", "Baar\ Schwaben",
"497534", "Reichenau\ Baden",
"4935387", "Seyda",
"495976", "Salzbergen",
"495336", "Semmenstedt",
"49451", "Lübeck",
"492545", "Rosendahl\-Darfeld",
"4933922", "Karwesee",
"495521", "Herzberg\ am\ Harz",
"499765", "Trappstadt",
"498322", "Oberstdorf",
"496029", "Mömbris",
"492173", "Langenfeld\ Rheinland",
"496439", "Holzappel",
"499626", "Hohenburg",
"495744", "Hüllhorst",
"497803", "Gengenbach",
"495182", "Gronau\ Leine",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"4935932", "Guttau",
"497903", "Mainhardt",
"497807", "Neuried\ Ortenaukreis",
"494479", "Molbergen\-Peheim",
"496046", "Ortenberg\ Hessen",
"499469", "Roding\-Neubäu",
"499921", "Regen",
"496106", "Rodgau",
"495068", "Elze\ Leine",
"496735", "Eppelsheim",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"4937602", "Kirchberg\ Sachsen",
"494384", "Selent",
"494635", "Sörup",
"497724", "St\ Georgen\ im\ Schwarzwald",
"492964", "Brilon\-Alme",
"499227", "Neuenmarkt",
"4935456", "Terpt",
"4933335", "Pinnow\ Kreis\ Uckermark",
"494775", "Grossenwörden",
"492864", "Reken",
"497541", "Friedrichshafen",
"4938735", "Plau\ am\ See",
"496675", "Breitenbach\ am\ Herzberg",
"492205", "Rösrath",
"4939775", "Ahlbeck\ bei\ Torgelow",
"499223", "Rugendorf",
"498045", "Lenggries\-Fall",
"4939483", "Ballenstedt",
"4933230", "Börnicke\ Kreis\ Havelland",
"494362", "Heiligenhafen",
"495333", "Dettum",
"494139", "Hohnstorf\ Elbe",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4938483", "Brüel",
"495977", "Spelle",
"495337", "Kissenbrück",
"495254", "Paderborn\-Schloss\ Neuhaus",
"498273", "Nordendorf",
"499360", "Thüngen",
"495873", "Eimke",
"4936071", "Teistungen",
"495693", "Volkmarsen",
"498331", "Memmingen",
"492433", "Hückelhoven",
"492982", "Medebach",
"4936608", "Seelingstädt\ bei\ Gera",
"495271", "Höxter",
"495532", "Stadtoldendorf",
"494563", "Scharbeutz\-Haffkrug",
"4938826", "Dassow",
"499573", "Staffelstein\ Oberfranken",
"4939262", "Güsten\ Anh",
"4933652", "Neuzelle",
"4939928", "Möllenhagen",
"494406", "Berne",
"4939826", "Blankensee\ bei\ Neustrelitz",
"499145", "Solnhofen",
"497652", "Hinterzarten",
"499832", "Wassertrüdingen",
"4935363", "Fermerswalde",
"499932", "Osterhofen",
"4937328", "Grossschirma",
"499372", "Klingenberg\ am\ Main",
"494830", "Süderhastedt",
"495164", "Hodenhagen",
"498105", "Gilching",
"4939991", "Daberkow",
"4937320", "Mulda\ Sachsen",
"495722", "Bückeburg",
"4936965", "Stadtlengsfeld",
"492191", "Remscheid",
"495909", "Wettrup",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"496107", "Kelsterbach",
"493381", "Brandenburg\ an\ der\ Havel",
"498344", "Westendorf\ bei\ Kaufbeuren",
"496103", "Langen\ Hessen",
"496043", "Nidda",
"499627", "Freudenberg\ Oberpfalz",
"493968", "Schönbeck",
"497906", "Braunsbach",
"493868", "Rastow",
"496275", "Rothenberg\ Odenwald",
"492605", "Löf",
"496047", "Altenstadt\ Hessen",
"497806", "Bad\ Peterstal\-Griesbach",
"497195", "Winnenden",
"4933204", "Beelitz\ Mark",
"497184", "Kaisersbach",
"497742", "Klettgau",
"498549", "Vilshofen\-Pleinting",
"4936653", "Lehesten\ Thüringer\ Wald",
"4933238", "Senzke",
"494235", "Langwedel\-Etelsen",
"4933209", "Caputh",
"4934466", "Janisroda",
"4939038", "Henningen",
"499089", "Bissingen\-Unterringingen",
"492725", "Lennestadt\-Oedingen",
"492157", "Nettetal\-Kaldenkirchen",
"4939009", "Badel",
"495741", "Lübbecke",
"49261", "Koblenz\ am\ Rhein",
"492153", "Nettetal\-Lobberich",
"4939004", "Köckte\ bei\ Gardelegen",
"494968", "Neulehe",
"498743", "Geisenhausen",
"492388", "Hamm\-Uentrop",
"4935433", "Vetschau",
"4934364", "Wermsdorf",
"497204", "Malsch\-Völkersbach",
"495524", "Bad\ Lauterberg\ im\ Harz",
"492666", "Freilingen\ Westerwald",
"4934296", "Groitzsch\ bei\ Pegau",
"4939601", "Friedland",
"4933767", "Friedersdorf\ bei\ Berlin",
"497965", "Ellwangen\-Röhlingen",
"497326", "Neresheim",
"4935473", "Neu\ Lübbenau",
"495346", "Liebenburg",
"496881", "Lebach",
"492429", "Hürtgenwald",
"4936921", "Wutha\-Farnroda",
"4938721", "Ziegendorf",
"492961", "Brilon",
"495602", "Hessisch\ Lichtenau",
"4939721", "Liepen\ bei\ Anklam",
"497544", "Markdorf",
"492861", "Borken\ Westfalen",
"4934205", "Markranstädt",
"499338", "Röttingen\ Unterfranken",
"492446", "Heimbach\ Eifel",
"499978", "Schönthal\ Oberpfalz",
"496283", "Hardheim\ Odenwald",
"495329", "Schulenberg\ im\ Oberharz",
"492267", "Wipperfürth",
"499924", "Bodenmais",
"494123", "Barmstedt",
"497721", "Villingen\ im\ Schwarzwald",
"494127", "Westerhorn",
"492263", "Engelskirchen",
"496655", "Neuhof\ Kreis\ Fulda",
"496287", "Limbach\ Baden",
"494381", "Lütjenburg",
"494755", "Ihlienworth",
"499824", "Dietenhofen",
"496426", "Fronhausen",
"498166", "Allershausen\ Oberbayern",
"496036", "Wölfersheim",
"495734", "Bergkirchen\ Westfalen",
"499779", "Nordheim\ von\ der\ Rhön",
"4933398", "Werneuchen",
"495651", "Eschwege",
"497260", "Sinsheim\-Hilsbach",
"4936422", "Reinstädt\ Thüringen",
"494465", "Friedeburg\ Ostfriesland",
"498657", "Ramsau\ bei\ Berchtesgaden",
"498285", "Burtenbach",
"497959", "Frankenhardt",
"496449", "Ehringshausen\-Katzenfurt",
"492535", "Sendenhorst\-Albersloh",
"499556", "Geiselwind",
"49811", "Hallbergmoos",
"495674", "Grebenstein",
"498294", "Horgau",
"499639", "Mähring",
"497150", "Korntal\-Münchingen",
"497531", "Konstanz",
"4933475", "Letschin",
"497272", "Rülzheim",
"4933435", "Rehfelde",
"493362", "Erkner",
"493563", "Spremberg",
"496745", "Gondershausen",
"496669", "Neuhof\-Hauswurz",
"494769", "Bremervörde\-Iselersheim",
"496192", "Hofheim\ am\ Taunus",
"4935454", "Uckro",
"4939030", "Brunau",
"495956", "Rastdorf",
"492689", "Dierdorf",
"4936087", "Wüstheuterode",
"493635", "Kölleda",
"492447", "Dahlem\ bei\ Kall",
"492266", "Lindlar",
"495542", "Witzenhausen",
"4935607", "Jänschwalde",
"493395", "Pritzwalk",
"494126", "Horst\ Holstein",
"496286", "Walldürn\-Rippberg",
"498341", "Kaufbeuren",
"4935361", "Schlieben",
"492443", "Mechernich",
"495347", "Burgdorf\ bei\ Salzgitter",
"49221", "Cologne",
"498035", "Raubling",
"496165", "Breuberg",
"4939383", "Sandau\ Elbe",
"494149", "Fredenbeck",
"499942", "Viechtach",
"4939824", "Hohenzieritz",
"4938377", "Zinnowitz",
"497323", "Gerstetten",
"4938855", "Lübtheen",
"492667", "Stein\-Neukirch",
"496683", "Ehrenberg\ Rhön",
"4938392", "Sassnitz",
"4938824", "Mallentin",
"4939855", "Parmen\-Weggun",
"499842", "Uffenheim",
"496255", "Lindenfels",
"492663", "Westerburg\ Westerwald",
"497327", "Dischingen",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"497181", "Schorndorf\ Württemberg",
"4939829", "Blankenförde",
"494492", "Saterland",
"499135", "Hessdorf\ Mittelfranken",
"492156", "Willich\-Anrath",
"4938481", "Witzin",
"497522", "Wangen\ im\ Allgäu",
"496340", "Wörth\-Schaidt",
"495202", "Oerlinghausen",
"498802", "Huglfing",
"4935727", "Burghammer",
"4939481", "Hedersleben\ bei\ Aschersleben",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"497660", "St\ Peter\ Schwarzwald",
"495953", "Börger",
"498685", "Kirchanschöring",
"498257", "Inchenhofen",
"495857", "Bleckede\-Brackede",
"498334", "Bad\ Grönenbach",
"4936651", "Lobenstein",
"495228", "Vlotho\-Exter",
"495853", "Neu\ Darchau",
"498253", "Pöttmes",
"495274", "Nieheim",
"495957", "Lindern\ Oldenburg",
"496159", "Messel",
"49351", "Dresden",
"4937382", "Geringswalde",
"494505", "Stockelsdorf\-Curau",
"495251", "Paderborn",
"498851", "Kochel\ am\ See",
"4936025", "Körner",
"496269", "Gundelsheim\ Württemberg",
"497732", "Radolfzell\ am\ Bodensee",
"498656", "Anger",
"4935245", "Burkhardswalde\-Munzig",
"494245", "Neuenkirchen\ bei\ Bassum",
"499553", "Ebrach\ Oberfranken",
"497440", "Bad\ Rippoldsau",
"495161", "Walsrode",
"496427", "Cölbe\-Schönstadt",
"498167", "Zolling",
"497248", "Marxzell",
"497672", "St\ Blasien",
"496033", "Butzbach",
"4933206", "Fichtenwalde",
"499352", "Lohr\ am\ Main",
"4939993", "Hohenmocker",
"496423", "Wetter\ Hessen",
"4935022", "Bad\ Schandau",
"499664", "Hahnbach",
"493693", "Meiningen",
"496599", "Weidenbach\ bei\ Gerolstein",
"493337", "Biesenthal\ Brandenburg",
"493973", "Pasewalk",
"493877", "Wittenberge",
"496356", "Carlsberg\ Pfalz",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"492621", "Lahnstein",
"4933656", "Bahro",
"4939266", "Förderstedt",
"4939394", "Hohenberg\-Krusemark",
"495645", "Borgentreich\-Borgholz",
"495769", "Steyerberg\-Voigtei",
"494856", "Kronprinzenkoog",
"4939399", "Kleinau",
"498093", "Glonn\ Kreis\ Ebersberg",
"497361", "Aalen",
"4939822", "Kratzeburg",
"494956", "Uplengen",
"492365", "Marl",
"49771", "Donaueschingen",
"496394", "Bundenthal",
"4934925", "Bad\ Schmiedeberg",
"4938847", "Boizenburg\ Elbe",
"499444", "Siegenburg",
"4939957", "Gielow",
"497625", "Zell\ im\ Wiesental",
"496751", "Bad\ Sobernheim",
"492826", "Kranenburg\ Niederrhein",
"494734", "Stadland\-Seefeld",
"496634", "Gemünden\ Felda",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"496385", "Reichenbach\-Steegen",
"4936201", "Walschleben",
"495465", "Neuenkirchen\ bei\ Bramsche",
"4935698", "Hornow",
"499193", "Höchstadt\ an\ der\ Aisch",
"498404", "Oberdolling",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"494885", "Bergenhusen",
"496774", "Kaub",
"499197", "Egloffstein",
"4939405", "Hötensleben",
"496728", "Ober\-Hilbersheim",
"494674", "Ockholm",
"494346", "Gettorf",
"493909", "Klötze\ Altmark",
"498387", "Weiler\-Simmerberg",
"498121", "Markt\ Schwaben",
"4933671", "Lieberose",
"4935024", "Stadt\ Wehlen",
"496461", "Biedenkopf",
"494602", "Freienwill",
"493722", "Limbach\-Oberfrohna",
"499568", "Neustadt\ bei\ Coburg",
"4934973", "Osternienburg",
"4933631", "Bad\ Saarow\-Pieskow",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"492554", "Laer\ Kreis\ Steinfurt",
"498383", "Grünenbach\ Allgäu",
"498640", "Reit\ Im\ Winkl",
"497456", "Haiterbach",
"498158", "Tutzing",
"498582", "Röhrnbach",
"495123", "Schellerten",
"494329", "Langwedel\ Holstein",
"492232", "Brühl\ Rheinland",
"495381", "Seesen",
"495127", "Harsum",
"492571", "Greven\ Westfalen",
"495755", "Kalletal\-Varenholz",
"496641", "Lauterbach\ Hessen",
"494488", "Westerstede",
"498268", "Tussenhausen",
"494741", "Nordholz\ bei\ Bremerhaven",
"497147", "Sachsenheim\ Württemberg",
"492596", "Nordkirchen",
"497575", "Messkirch",
"499431", "Schwandorf",
"497143", "Besigheim",
"492359", "Kierspe",
"4937384", "Wechselburg",
"494524", "Scharbeutz\-Pönitz",
"497485", "Empfingen",
"4969", "Frankfurt\ am\ Main",
"496120", "Aarbergen",
"496084", "Schmitten\ Taunus",
"498460", "Berching\-Holnstein",
"499282", "Naila",
"496095", "Bessenbach",
"4936784", "Stützerbach",
"495459", "Hörstel",
"492064", "Dinslaken",
"497763", "Murg",
"493671", "Saalfeld\ Saale",
"498845", "Bad\ Kohlgrub",
"495245", "Herzebrock\-Clarholz",
"495073", "Neustadt\-Esperke",
"499196", "Wiesenttal",
"498054", "Breitbrunn\ am\ Chiemsee",
"494161", "Buxtehude",
"493991", "Waren\ Müritz",
"492927", "Neuengeseke",
"499264", "Küps",
"493731", "Freiberg\ Sachsen",
"492823", "Goch",
"499805", "Burgoberbach",
"496062", "Erbach\ Odenwald",
"498369", "Rückholz",
"492827", "Goch\-Hassum",
"499905", "Bernried\ Niederbayern",
"498071", "Wasserburg\ am\ Inn",
"492923", "Lippetal\-Herzfeld",
"499154", "Pommelsbrunn",
"494953", "Bunde",
"494857", "Barlt",
"4934362", "Mügeln\ bei\ Oschatz",
"494853", "Sankt\ Michaelisdonn",
"496552", "Olzheim",
"4934741", "Frose",
"496188", "Kahl\ am\ Main",
"494957", "Detern",
"494274", "Varrel\ bei\ Sulingen",
"499171", "Roth\ Mittelfranken",
"496353", "Freinsheim",
"4939002", "Oebisfelde",
"499422", "Bogen\ Niederbayern",
"493976", "Torgelow\ bei\ Ueckermünde",
"4935951", "Neukirch\ Lausitz",
"497225", "Gaggenau",
"495505", "Hardegsen",
"498564", "Johanniskirchen",
"496357", "Standenbühl",
"494251", "Hoya",
"493876", "Perleberg",
"4935841", "Grossschönau\ Sachsen",
"496234", "Mutterstadt",
"495840", "Schnackenburg",
"497129", "Lichtenstein\ Württemberg",
"499408", "Altenthann",
"4935452", "Golssen",
"492392", "Werdohl",
"493521", "Meissen",
"492632", "Andernach",
"496501", "Konz",
"495492", "Steinfeld\ Oldenburg",
"497146", "Remseck\ am\ Neckar",
"498781", "Rottenburg\ an\ der\ Laaber",
"492597", "Senden\ Westfalen",
"492593", "Ascheberg\ Westfalen",
"494202", "Achim\ bei\ Bremen",
"4937606", "Lengenfeld\ Vogtland",
"492772", "Herborn\ Hessen",
"493744", "Auerbach\ Vogtland",
"497457", "Rottenburg\-Ergenzingen",
"494542", "Mölln\ Lauenburg",
"496843", "Gersheim",
"499682", "Erbendorf",
"4935936", "Sohland\ Spree",
"495126", "Algermissen",
"4936424", "Kahla\ Thüringen",
"497453", "Altensteig\ Württemberg",
"498386", "Oberstaufen",
"4933926", "Herzberg\ Mark",
"496241", "Worms",
"494347", "Flintbek",
"495149", "Wienhausen",
"494343", "Laboe",
"4934742", "Sylda",
"4934607", "Wettin",
"4934361", "Dahlen\ Sachsen",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"492543", "Billerbeck\ Westfalen",
"494236", "Kirchlinteln",
"492175", "Leichlingen\ Rheinland",
"4939604", "Wildberg\ bei\ Altentreptow",
"492547", "Rosendahl\-Osterwick",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"495442", "Barnstorf\ Kreis\ Diepholz",
"497264", "Bad\ Rappenau",
"4935842", "Oderwitz",
"497805", "Appenweier",
"496276", "Hesseneck",
"492606", "Winningen\ Mosel",
"493834", "Greifswald",
"493328", "Teltow",
"4939001", "Apenburg",
"496308", "Olsbrücken",
"4935952", "Grossröhrsdorf\ OL",
"497905", "Langenburg",
"495199", "Schneverdingen\-Heber",
"4935827", "Nieder\-Seifersdorf",
"497154", "Kornwestheim",
"496737", "Köngernheim",
"494393", "Boostedt",
"494637", "Sterup",
"4934463", "Bad\ Kösen",
"495662", "Felsberg\ Hessen",
"494633", "Satrup",
"496733", "Gau\-Odernheim",
"496291", "Adelsheim",
"492801", "Xanten",
"4934293", "Naunhof\ bei\ Grimma",
"497422", "Schramberg",
"497171", "Schwäbisch\ Gmünd",
"494777", "Cadenberge",
"4938724", "Siggelkow",
"496897", "Sulzbach\ Saar",
"496677", "Neuenstein\ Hessen",
"492207", "Kürten\-Dürscheid",
"4936924", "Mihla",
"4933877", "Nitzahn",
"4936845", "Gehlberg",
"4935436", "Laasow\ bei\ Calau",
"497032", "Herrenberg",
"492203", "Cologne\-Porz",
"496673", "Haunetal",
"4935476", "Wittmannsdorf\-Bückchen",
"4938729", "Marnitz",
"4933837", "Brielow",
"4936929", "Ruhla",
"499225", "Stadtsteinach",
"496893", "Saarbrücken\-Ensheim",
"494773", "Lamstedt",
"4939724", "Klein\ Bünzow",
"4938755", "Eldena",
"499129", "Wendelstein",
"492952", "Rüthen",
"495138", "Sehnde",
"493466", "Artern\ Unstrut",
"498106", "Vaterstetten",
"492852", "Hamminkeln",
"498735", "Gangkofen\-Kollbach",
"494405", "Edewecht",
"495520", "Braunlage",
"495284", "Schwalenberg",
"493941", "Halberstadt",
"499146", "Markt\ Berolzheim",
"493841", "Wismar",
"495295", "Lichtenau\ Westfalen",
"49341", "Leipzig",
"4935451", "Dahme\ Brandenburg",
"493302", "Hennigsdorf",
"4934785", "Sandersleben",
"497682", "Elzach",
"496322", "Bad\ Dürkheim",
"498029", "Kreuth\ bei\ Tegernsee",
"499453", "Thalmassing",
"494822", "Kellinghusen",
"4937208", "Auerswalde",
"499920", "Bischofsmais",
"493629", "Stadtilm",
"496523", "Holsthum",
"496527", "Oberweis",
"498046", "Bad\ Heilbrunn",
"499820", "Lehrberg",
"494922", "Borkum",
"494776", "Osten\-Altendorf",
"497664", "Freiburg\-Tiengen",
"492838", "Sonsbeck",
"4936202", "Neudietendorf",
"498330", "Legau",
"492206", "Overath",
"496676", "Hohenroda\ Hessen",
"495152", "Hessisch\ Oldendorf",
"492324", "Hattingen\ Ruhr",
"492378", "Fröndenberg\-Langschede",
"492938", "Ense",
"494559", "Wensin",
"496736", "Bechenheim",
"4936076", "Niederorschel",
"494636", "Langballig",
"4935364", "Lebusa",
"496105", "Mörfelden\-Walldorf",
"495424", "Bad\ Rothenfelde",
"495034", "Neustadt\-Hagen",
"49971", "Bad\ Kissingen",
"4939489", "Strassberg\ Harz",
"497444", "Alpirsbach",
"496045", "Gedern",
"494931", "Norden",
"4938484", "Ventschow",
"494371", "Burg\ auf\ Fehmarn",
"492607", "Kobern\-Gondorf",
"4935205", "Ottendorf\-Okrilla",
"492603", "Bad\ Ems",
"499625", "Kastl\ bei\ Amberg",
"4939484", "Harzgerode",
"492529", "Oelde\-Stromberg",
"496854", "Oberthal\ Saar",
"4939821", "Carpin",
"498179", "Eurasburg\ an\ der\ Loisach",
"494354", "Fleckeby",
"497193", "Sulzbach\ an\ der\ Murr",
"496331", "Pirmasens",
"494237", "Bendingbostel",
"498862", "Steingaden\ Oberbayern",
"494233", "Blender",
"494791", "Osterholz\-Scharmbeck",
"495262", "Extertal",
"4938821", "Lüdersdorf",
"492546", "Coesfeld\-Lette",
"499766", "Grosswenkheim",
"4939386", "Seehausen\ Altmark",
"496691", "Schwalmstadt",
"496871", "Wadern",
"495684", "Frielendorf",
"495335", "Schladen",
"495975", "Rheine\-Mesum",
"498043", "Jachenau",
"495875", "Emmendorf",
"496526", "Bollendorf",
"497568", "Bad\ Wurzach\-Hauerz",
"495695", "Twistetal",
"493647", "Pössneck",
"492435", "Erkelenz\-Lövenich",
"495041", "Springe\ Deister",
"49395", "Neubrandenburg",
"4939996", "Törpin",
"4933203", "Kleinmachnow",
"49385", "Schwerin",
"493643", "Weimar\ Thüringen",
"4936625", "Langenwetzendorf",
"494844", "Pellworm",
"496209", "Mörlenbach",
"4934348", "Frohburg",
"499575", "Weismain",
"499147", "Nennslingen",
"4933632", "Hangelsberg",
"4933672", "Pfaffendorfb\ Beeskow",
"499143", "Pappenheim\ Mittelfranken",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"497431", "Albstadt\-Ebingen",
"494944", "Wiesmoor",
"497021", "Kirchheim\ unter\ Teck",
"495101", "Pattensen",
"4938457", "Krakow\ am\ See",
"492739", "Wilnsdorf",
"4934425", "Droyssig",
"496344", "Schwegenheim",
"4939457", "Benneckenstein\ Harz",
"498081", "Dorfen\ Stadt",
"499604", "Wernberg\-Köblitz",
"4939391", "Lückstedt",
"4933965", "Herzsprung\ bei\ Wittstock",
"49202", "Wuppertal",
"4938391", "Altenkirchen\ Rügen",
"492131", "Neuss",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"4939482", "Gatersleben",
"498222", "Burgau\ Schwaben",
"495083", "Hohne\ bei\ Celle",
"495822", "Ebstorf",
"4938320", "Tribsees",
"493681", "Suhl",
"495922", "Bad\ Bentheim",
"4939320", "Schinne",
"4938482", "Warin",
"499323", "Iphofen",
"4935362", "Schönewalde\ bei\ Herzberg",
"492305", "Castrop\-Rauxel",
"493886", "Gadebusch",
"497942", "Neuenstein\ Württemberg",
"496452", "Battenberg\ Eder",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"497842", "Kappelrodeck",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"496124", "Bad\ Schwalbach",
"4936209", "Klettbach",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"494284", "Selsingen",
"4933653", "Ziltendorf",
"4939263", "Unseburg",
"498464", "Dietfurt\ an\ der\ Altmühl",
"497135", "Brackenheim",
"494295", "Emtinghausen",
"499522", "Eltmann",
"497706", "Oberbaldingen",
"4936204", "Stotternheim",
"493421", "Torgau",
"493969", "Siedenbollentin",
"496401", "Grünberg\ Hessen",
"493869", "Dümmer",
"498771", "Ergoldsbach",
"495633", "Diemelsee",
"494662", "Leck",
"496762", "Kastellaun",
"4933674", "Trebatsch",
"495777", "Diepenau\-Essern",
"4935021", "Königstein\ Sächsische\ Schweiz",
"497063", "Bad\ Wimpfen",
"4933608", "Jacobsdorf\ Mark",
"498754", "Volkenschwand",
"495592", "Gleichen\-Bremke",
"498548", "Vilshofen\-Sandbach",
"4933679", "Wendisch\ Rietz",
"498631", "Mühldorf\ am\ Inn",
"495773", "Stemwede\-Wehdem",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"499732", "Hammelburg",
"4939328", "Rochau",
"495236", "Blomberg\-Grossenmarpe",
"497553", "Salem\ Baden",
"498208", "Eurasburg\ bei\ Augsburg",
"4937437", "Bad\ Elster",
"495808", "Gerdau",
"4938328", "Miltzow",
"497557", "Herdwangen\-Schönach",
"4936781", "Grossbreitenbach",
"498376", "Sulzberg\ Allgäu",
"494442", "Lohne\ Oldenburg",
"495908", "Wietmarschen\-Lohne",
"496630", "Schwalmtal\-Storndorf",
"4936652", "Wurzbach",
"4934976", "Gröbzig",
"499672", "Neunburg\ vorm\ Wald",
"497352", "Ochsenhausen",
"4937381", "Penig",
"4938233", "Prerow\ Ostseebad",
"497703", "Bonndorf\ im\ Schwarzwald",
"495844", "Clenze",
"4939722", "Sarnow\ bei\ Anklam",
"498622", "Tacherting\-Peterskirchen",
"495055", "Fassberg",
"499349", "Werbach\-Wenkheim",
"495944", "Hoogstede",
"497707", "Bräunlingen",
"4938722", "Raduhn",
"494101", "Pinneberg",
"4936922", "Gerstungen",
"499204", "Plankenfels",
"499865", "Adelshofen\ Mittelfranken",
"493987", "Templin",
"496002", "Ober\-Mörlen",
"4939085", "Zichtau",
"493883", "Hagenow",
"499326", "Markt\ Einersheim",
"499965", "Sankt\ Englmar",
"494975", "Westerholt\ Ostfriesland",
"494684", "Langeness\ Hallig",
"494335", "Hohn\ bei\ Rendsburg",
"496142", "Rüsselsheim",
"496784", "Weierbach",
"4935954", "Grossharthau",
"495086", "Celle\-Scheuen",
"492764", "Welschen\ Ennest",
"494875", "Stafstedt",
"4935844", "Oybin\ Kurort",
"499544", "Baunach",
"4939747", "Züsedom",
"4939602", "Kleeth",
"4936375", "Kindelbrück",
"496375", "Wallhalben",
"495565", "Einbeck\-Wenzen",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4936947", "Jüchsen",
"499721", "Schweinfurt",
"496835", "Beckingen",
"497824", "Schwanau",
"4936335", "Grosswechsungen",
"498504", "Tittling",
"492581", "Warendorf",
"499468", "Zell\ Oberpfalz",
"4935973", "Stolpen",
"495069", "Nordstemmen",
"492454", "Gangelt",
"495371", "Gifhorn",
"495931", "Meppen",
"498572", "Tann\ Niederbayern",
"4935933", "Neschwitz",
"498231", "Königsbrunn\ bei\ Augsburg",
"495831", "Wittingen",
"496561", "Bitburg",
"4937297", "Thum\ Sachsen",
"498373", "Altusried",
"499260", "Wilhelmsthal\ Oberfranken",
"495354", "Jerxheim",
"495237", "Augustdorf",
"492471", "Roetgen\ Eifel",
"4933923", "Flecken\ Zechlin",
"4937467", "Klingenthal\ Sachsen",
"495233", "Steinheim\ Westfalen",
"494262", "Visselhövede",
"497556", "Uhldingen\-Mühlhofen",
"498377", "Unterthingau",
"499531", "Ebern",
"495776", "Preussisch\ Ströhen",
"4938225", "Trinwillershagen",
"499272", "Fichtelberg",
"499648", "Neustadt\ am\ Kulm",
"496028", "Sulzbach\ am\ Main",
"494152", "Geesthacht",
"4939225", "Altengrabow",
"497066", "Bad\ Rappenau\-Bonfeld",
"496438", "Hünfelden",
"497475", "Burladingen",
"496074", "Rödermark",
"495636", "Lichtenfels\-Goddelsheim",
"4936421", "Camburg",
"497585", "Ostrach",
"494478", "Cappeln\ Oldenburg",
"496051", "Gelnhausen",
"4937603", "Wildenfels",
"493564", "Schwarze\ Pumpe",
"495276", "Marienmünster",
"4939728", "Medow\ bei\ Anklam",
"499772", "Bischofsheim\ an\ der\ Rhön",
"4933981", "Putlitz",
"495308", "Lehre",
"498336", "Erkheim",
"496670", "Ludwigsau\ Hessen",
"4936928", "Neuenhof\ Thüringen",
"494770", "Wischhafen",
"4938728", "Domsühl",
"497852", "Willstätt",
"499632", "Waldsassen",
"499392", "Faulbach\ Unterfranken",
"492408", "Aachen\-Kornelimünster",
"496442", "Braunfels",
"497952", "Gerabronn",
"494630", "Barderup",
"495677", "Calden\-Westuffeln",
"4936483", "Ziegenrück",
"4939031", "Dähre",
"498654", "Freilassing",
"4935265", "Glaubitz",
"495673", "Immenhausen\ Hessen",
"498731", "Dingolfing",
"498293", "Welden\ bei\ Augsburg",
"494401", "Brake\ Unterweser",
"4939608", "Staven",
"4934637", "Frankleben",
"492682", "Hamm\ Sieg",
"495733", "Vlotho",
"494762", "Kutenholz",
"4934692", "Alsleben\ Saale",
"498671", "Altötting",
"499827", "Lichtenau\ Mittelfranken",
"494178", "Radbruch",
"4937209", "Einsiedel\ bei\ Chemnitz",
"499923", "Teisnach",
"4935341", "Bad\ Liebenwerda",
"496284", "Mudau",
"494124", "Glückstadt",
"492905", "Bestwig\-Ramsbeck",
"499927", "Kirchberg\ Wald",
"492264", "Marienheide",
"493386", "Premnitz",
"4939600", "Zwiedorf",
"499823", "Leutershausen",
"499082", "Oettingen\ in\ Bayern",
"4937204", "Lichtenstein\ Sachsen",
"496295", "Rosenberg\ Baden",
"492196", "Wermelskirchen",
"497175", "Leinzell",
"496138", "Mommenheim",
"494452", "Zetel\-Neuenburg",
"499221", "Kulmbach",
"497543", "Kressbronn\ am\ Bodensee",
"497203", "Walzbachtal",
"498744", "Gerzen",
"498558", "Hohenau\ Niederbayern",
"495523", "Bad\ Sachsa",
"495609", "Ahnatal",
"492422", "Kreuzau",
"492171", "Leverkusen\-Opladen",
"4938791", "Bad\ Wilsnack",
"495527", "Duderstadt",
"493448", "Meuselwitz\ Thüringen",
"499704", "Euerdorf",
"4937365", "Sayda",
"4938720", "Grebbin",
"4936920", "Grossenlupnitz",
"4939056", "Klüden",
"495322", "Bad\ Harzburg",
"492154", "Willich",
"499232", "Wunsiedel",
"498708", "Weihmichl\-Unterneuhausen",
"499571", "Lichtenfels\ Bayern",
"497435", "Albstadt\-Laufen",
"496478", "Greifenstein\-Ulm",
"496034", "Wöllstadt",
"494230", "Verden\-Walle",
"4937421", "Oelsnitz\ Vogtland",
"4936603", "Weida",
"495105", "Barsinghausen",
"497025", "Neuffen",
"496424", "Ebsdorfergrund",
"498296", "Villenbach",
"492568", "Heek",
"499481", "Pfatter",
"495676", "Liebenau\ Hessen",
"499748", "Motten",
"4939061", "Weferlingen",
"499554", "Untersteinbach\ Unterfranken",
"4939488", "Güntersberge",
"496152", "Gross\-Gerau",
"4938488", "Demen",
"496588", "Pluwig",
"495971", "Rheine",
"495331", "Wolfenbüttel",
"492058", "Wülfrath",
"495691", "Bad\ Arolsen",
"498271", "Meitingen",
"496262", "Aglasterhausen",
"498532", "Griesbach\ im\ Rottal",
"497739", "Hilzingen",
"4937323", "Lichtenberg\ Erzgebirge",
"495954", "Lorup",
"499359", "Karlstadt\-Wiesenfeld",
"495045", "Springe\-Bennigsen",
"4939923", "Priborn",
"492431", "Erkelenz",
"495277", "Höxter\-Fürstenau",
"498333", "Babenhausen\ Schwaben",
"494561", "Neustadt\ in\ Holstein",
"498254", "Altomünster",
"495854", "Bleckede\-Barskamp",
"498337", "Altenstadt\ Iller",
"495273", "Beverungen",
"494935", "Juist",
"496041", "Glauburg",
"499621", "Amberg\ Oberpfalz",
"4936043", "Kirchheilingen",
"494835", "Albersdorf\ Holstein",
"4934446", "Grosskorbetha",
"497324", "Herbrechtingen",
"494142", "Steinkirchen\ Kreis\ Stade",
"4933747", "Marzahna",
"496684", "Hofbieber\-Schwarzbach",
"496335", "Trulben",
"4933602", "Alt\ Zeschdorf",
"4939347", "Kade",
"497938", "Mulfingen\ Jagst",
"494795", "Garlstedt",
"492664", "Rennerod",
"4936735", "Probstzella",
"4939975", "Thürkow",
"496875", "Nonnweiler\-Primstal",
"497838", "Nordrach",
"499658", "Georgenberg",
"4934344", "Kohren\-Sahlis",
"496695", "Jesberg",
"4939322", "Tangermünde",
"497546", "Oberteuringen",
"4936646", "Tanna\ bei\ Schleiz",
"4938322", "Richtenberg",
"495344", "Lengede",
"492193", "Dabringhausen",
"4933233", "Ketzin",
"499826", "Weidenbach\ Mittelfranken",
"4935797", "Schwepnitz",
"498722", "Gangkofen",
"497529", "Waldburg\ Württemberg",
"498809", "Wessobrunn",
"4935772", "Rietschen",
"495209", "Gütersloh\-Friedrichsdorf",
"499926", "Frauenau",
"496101", "Bad\ Vilbel",
"499365", "Rimpar",
"494499", "Barssel",
"492444", "Schleiden\-Gemünd",
"4933085", "Seilershof",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"494523", "Malente",
"496083", "Weilrod",
"494609", "Eggebek",
"4936208", "Ermstedt",
"4934385", "Mutzschen",
"496087", "Waldems",
"493902", "Diesdorf\ Altm",
"494527", "Bosau",
"494322", "Bordesholm",
"497144", "Marbach\ am\ Neckar",
"4935691", "Bärenklau\ NL",
"493425", "Wurzen",
"496405", "Laubach\ Hessen",
"492352", "Altena\ Westfalen",
"4935753", "Grossräschen",
"492557", "Wettringen\ Kreis\ Steinfurt",
"498395", "Tannheim\ Württemberg",
"499289", "Schwarzenbach\ am\ Wald",
"493341", "Strausberg",
"495452", "Mettingen\ Westfalen",
"492553", "Ochtrup",
"498635", "Pleiskirchen",
"498384", "Röthenbach\ Allgäu",
"492301", "Holzwickede",
"49921", "Bayreuth",
"498056", "Eggstätt",
"4938426", "Neuburg\-Steinhausen",
"499194", "Ebermannstadt",
"498403", "Pförring",
"498407", "Grossmehring",
"4939426", "Hessen",
"496773", "Kamp\-Bornhofen",
"494893", "Hohenaspe",
"499185", "Mühlhausen\ Oberpfalz",
"4935774", "Boxberg\ Sachsen",
"496592", "Daun",
"494673", "Joldelund",
"495401", "Georgsmarienhütte",
"496637", "Feldatal",
"4934906", "Raguhn",
"497072", "Gomaringen",
"4934327", "Waldheim\ Sachsen",
"4938324", "Velgast",
"497131", "Heilbronn\ Neckar",
"496393", "Fischbach\ bei\ Dahn",
"494737", "Stadland\-Schwei",
"4939329", "Möringen",
"499443", "Abensberg",
"4939324", "Kläden\ bei\ Stendal",
"499447", "Essing",
"4938355", "Züssow",
"494733", "Butjadingen\-Burhave",
"496397", "Leimen\ Pfalz",
"499266", "Mitwitz",
"496633", "Homberg\ Ohm",
"494276", "Borstel\ bei\ Sulingen",
"4939883", "Gross\ Dölln",
"4933609", "Brieskow\-Finkenheerd",
"498085", "Sankt\ Wolfgang",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4936253", "Georgenthal\ Thüringer\ Wald",
"4934342", "Neukieritzsch",
"498094", "Steinhöring",
"4933678", "Storkow\ Mark",
"494308", "Schwedeneck",
"4933604", "Lebus",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"49851", "Passau",
"492842", "Kamp\-Lintfort",
"496236", "Neuhofen\ Pfalz",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"493874", "Ludwigslust",
"493685", "Hildburghausen",
"4936200", "Elxleben\ bei\ Arnstadt",
"493334", "Eberswalde",
"492942", "Geseke",
"497305", "Erbach\ Donau",
"493928", "Schönebeck\ Elbe",
"499535", "Pfarrweisach",
"492556", "Metelen",
"492639", "Anhausen\ Kreis\ Neuwied",
"497471", "Hechingen",
"497122", "St\ Johann\ Württemberg",
"494344", "Schönberg\ Holstein",
"492779", "Greifenstein\-Beilstein",
"494209", "Schwanewede",
"496844", "Blieskastel\-Altheim",
"497581", "Saulgau",
"496055", "Freigericht",
"497454", "Sulz\ am\ Neckar",
"4933457", "Altreetz",
"492585", "Warendorf\-Hoetmar",
"495935", "Twist\-Schöninghsdorf",
"495375", "Müden\ Aller",
"492594", "Dülmen",
"496565", "Dudeldorf",
"49201", "Essen",
"495835", "Wahrenholz",
"49335", "Frankfurt\ \(Oder\)",
"495142", "Eschede",
"492066", "Duisburg\-Homberg",
"4938203", "Bad\ Doberan",
"4939203", "Barleben",
"496086", "Grävenwiesbach",
"494526", "Ascheberg\ Holstein",
"496237", "Maxdorf",
"494331", "Rendsburg",
"494971", "Esens",
"494871", "Hohenwestedt",
"498563", "Bad\ Birnbach\ Rottal",
"496233", "Frankenthal\ Pfalz",
"499666", "Illschwang",
"499153", "Schnaittach",
"496371", "Landstuhl",
"494277", "Schwaförden",
"494954", "Moormerland",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4934771", "Querfurt",
"498139", "Röhrmoos",
"498362", "Füssen",
"494854", "Friedrichskoog",
"499725", "Poppenhausen\ Unterfranken",
"496831", "Saarlouis",
"495561", "Einbeck",
"4939246", "Lindau\ Anh",
"494273", "Kirchdorf\ bei\ Sulingen",
"499157", "Alfeld\ Mittelfranken",
"499263", "Ludwigsstadt",
"498370", "Wiggensbach",
"496636", "Romrod",
"494736", "Butjadingen\-Tossens",
"492824", "Kalkar",
"496559", "Leidenborn",
"499446", "Altmannstein",
"495051", "Bergen\ Kreis\ Celle",
"492338", "Breckerfeld",
"496396", "Hinterweidenthal",
"494105", "Seevetal",
"499267", "Nordhalben",
"492924", "Möhnesee",
"497764", "Herrischried",
"498057", "Aschau\-Sachrang",
"496776", "Dachsenhausen",
"499861", "Rothenburg\ ob\ der\ Tauber",
"4937202", "Claussnitz\ bei\ Chemnitz",
"498406", "Böhmfeld",
"495438", "Bakum\-Lüsche",
"495074", "Rodewald",
"495028", "Pennigsehl",
"498053", "Bad\ Endorf",
"499961", "Mitterfels",
"499429", "Rain\ Niederbayern",
"496578", "Salmtal",
"493504", "Dippoldiswalde",
"494120", "Ellerhoop",
"492859", "Wesel\-Bislich",
"496524", "Rodershausen",
"495368", "Parsau",
"499122", "Schwabach",
"499471", "Burglengenfeld",
"495686", "Schwarzenborn\ Knüll",
"496741", "St\ Goar",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"494641", "Süderbrarup",
"4933989", "Sadenbeck",
"499454", "Aufhausen\ Oberpfalz",
"498022", "Tegernsee",
"495283", "Lügde\-Rischenau",
"496329", "Weidenthal\ Pfalz",
"494946", "Grossefehn\-Bagband",
"498432", "Burgheim",
"494846", "Hattstedt",
"495655", "Wanfried",
"4939008", "Kunrau",
"494461", "Jever",
"494929", "Ihlow\ Kreis\ Aurich",
"4939039", "Bonese",
"496346", "Annweiler\ am\ Trifels",
"498281", "Thannhausen\ Schwaben",
"492150", "Meerbusch\-Lank",
"494829", "Wewelsfleth",
"4939034", "Fleetmark",
"494702", "Sandstedt",
"493622", "Waltershausen\ Thüringen",
"492272", "Bedburg\ Erft",
"496674", "Friedewald\ Hessen",
"4936875", "Straufhain\-Streufdorf",
"4933847", "Görzke",
"492204", "Bensberg",
"497388", "Pfronstetten",
"496894", "St\ Ingbert",
"497666", "Denzlingen",
"494774", "Hechthausen",
"4939000", "Beetzendorf",
"492865", "Raesfeld",
"496628", "Oberaula",
"49761", "Freiburg\ im\ Breisgau",
"494394", "Bokhorst",
"495036", "Neustadt\-Schneeren",
"4939053", "Süplingen",
"497153", "Plochingen",
"495426", "Glandorf",
"494634", "Husby",
"496651", "Rasdorf",
"494385", "Hohenfelde\ bei\ Kiel",
"497725", "Königsfeld\ im\ Schwarzwald",
"4937757", "Rittersgrün",
"497157", "Waldenbuch",
"494751", "Otterndorf",
"496734", "Flonheim",
"493377", "Zossen\ Brandenburg",
"496856", "St\ Wendel\-Niederkirchen",
"492721", "Lennestadt",
"497263", "Waibstadt",
"493937", "Osterburg\ Altmark",
"495745", "Stemwede\-Levern",
"498650", "Marktschellenberg",
"4935872", "Neusalza\-Spremberg",
"497446", "Lossburg",
"497267", "Gemmingen",
"493933", "Genthin",
"495192", "Munster",
"4933394", "Blumberg\ Kreis\ Barnim",
"499764", "Höchheim",
"492758", "Bad\ Berleburg\-Girkhausen",
"4938794", "Cumlosen",
"494356", "Gross\ Wittensee",
"497429", "Egesheim",
"4934223", "Dommitzsch",
"4934772", "Helbra",
"497961", "Ellwangen\ Jagst",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"496347", "Hochstadt\ Pfalz",
"494241", "Bassum",
"496343", "Bad\ Bergzabern",
"498104", "Sauerlach",
"493464", "Sangerhausen",
"4937326", "Frauenstein\ Sachsen",
"499493", "Beratzhausen",
"495165", "Rethem\ Aller",
"494843", "Viöl",
"492508", "Drensteinfurt",
"49465", "Sylt",
"4936695", "Söllmnitz",
"496542", "Bullay",
"4938828", "Schönberg",
"4939926", "Grabowhöfe",
"494947", "Aurich\-Ogenbargen",
"499144", "Pleinfeld",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"494943", "Grossefehn",
"495286", "Ottenstein\ Niedersachsen",
"4938307", "Poseritz",
"494847", "Oster\-Ohrstedt",
"498681", "Waging\ am\ See",
"492992", "Marsberg",
"4936606", "Kraftsdorf",
"492248", "Hennef\-Uckerath",
"493644", "Apolda",
"496202", "Schwetzingen",
"492672", "Treis\-Karden",
"4935692", "Kerkwitz",
"495683", "Wabern\ Hessen",
"4934495", "Dobitschen",
"492732", "Kreuztal",
"494501", "Kastorf\ Holstein",
"495255", "Altenbeken",
"492440", "Nettersheim\-Tondorf",
"49721", "Karlsruhe",
"495159", "Coppenbrügge\-Bisperode",
"497194", "Spiegelberg",
"494353", "Ascheffel",
"494357", "Sehestedt\ Eider",
"496251", "Bensheim",
"494234", "Dörverden",
"496420", "Lahntal",
"4934341", "Geithain",
"4936643", "Thimmendorf",
"496857", "Namborn",
"499072", "Lauingen\ Donau",
"497443", "Dornstetten",
"499131", "Erlangen",
"493836", "Wolgast",
"492604", "Nassau\ Lahn",
"496274", "Waldbrunn\ Odenwald",
"497447", "Baiersbronn\-Schwarzenberg",
"494552", "Leezen",
"497266", "Kirchardt",
"494188", "Welle\ Nordheide",
"496228", "Schönau\ Odenwald",
"496853", "Marpingen",
"493631", "Nordhausen\ Thüringen",
"492522", "Oelde",
"495037", "Bad\ Rehburg",
"495427", "Melle\-Buer",
"4939820", "Triepkendorf",
"4934443", "Teuchern",
"498345", "Stöttwang",
"495423", "Versmold",
"493391", "Neuruppin",
"498458", "Gaimersheim",
"495033", "Wunstorf\-Grossenheidorn",
"497156", "Ditzingen",
"497663", "Eichstetten",
"498869", "Kinsau",
"492327", "Bochum\-Wattenscheid",
"493771", "Aue\ Sachsen",
"492181", "Grevenbroich",
"499305", "Estenfeld",
"496161", "Brensbach",
"495850", "Neetze",
"498250", "Hilgertshausen\-Tandern",
"492323", "Herne",
"498031", "Rosenheim\ Oberbayern",
"498421", "Eichstätt\ Bayern",
"497667", "Breisach\ am\ Rhein",
"497232", "Königsbach\-Stein",
"496645", "Ulrichstein",
"4935020", "Struppen",
"497571", "Sigmaringen",
"499190", "Heroldsbach",
"494745", "Bad\ Bederkesa",
"4935694", "Gosda\ bei\ Klinge",
"499435", "Schwarzenfeld",
"492456", "Selfkant",
"4935756", "Hosena",
"494192", "Bad\ Bramstedt",
"493962", "Penzlin\ bei\ Waren",
"497554", "Heiligenberg\ Baden",
"497748", "Grafenhausen\ Hochschwarzwald",
"495356", "Helmstedt\-Barmke",
"4937422", "Markneukirchen",
"496465", "Breidenbach\ bei\ Biedenkopf",
"498753", "Elsendorf\ Niederbayern",
"492485", "Schleiden\-Dreiborn",
"4939398", "Gross\ Garz",
"495774", "Wagenfeld\-Ströhen",
"494426", "Wangerland\-Horumersiel",
"495634", "Waldeck\-Sachsenhausen",
"495751", "Rinteln",
"492575", "Greven\-Reckenfeld",
"4939062", "Bebertal",
"4938321", "Martensdorf\ bei\ Stralsund",
"496123", "Eltville\ am\ Rhein",
"494283", "Tarmstedt",
"4936256", "Wechmar",
"492361", "Recklinghausen",
"498463", "Greding",
"495946", "Georgsdorf",
"4939886", "Milmersdorf",
"496755", "Odernheim\ am\ Glan",
"4939321", "Arneburg",
"498467", "Kinding",
"497621", "Lörrach",
"495846", "Gartow\ Niedersachsen",
"498246", "Waal",
"496381", "Kusel",
"494287", "Heeslingen\-Boitzen",
"496127", "Niedernhausen\ Taunus",
"4939390", "Iden",
"499324", "Dettelbach",
"495461", "Bramsche\ Hase",
"499938", "Moos\ Niederbayern",
"494881", "Friedrichstadt",
"499378", "Eichenbühl\-Riedern",
"495702", "Petershagen\-Lahde",
"495829", "Wriedel",
"4935771", "Bad\ Muskau",
"499206", "Mistelgau\-Obernsees",
"499546", "Burgebrach",
"4938423", "Bad\ Kleinen",
"495084", "Hambühren",
"496786", "Kempfeld",
"4939423", "Wegeleben",
"497949", "Pfedelbach\-Untersteinbach",
"496868", "Mettlach\-Tünsdorf",
"498506", "Bad\ Höhenstadt",
"492625", "Ochtendung",
"499603", "Floss",
"497826", "Schuttertal",
"495641", "Warburg",
"4934903", "Coswig\ Anhalt",
"499529", "Oberaurach",
"4936967", "Geisa",
"497365", "Essingen\ Württemberg",
"49271", "Siegen",
"498380", "Achberg",
"4935028", "Krippen",
"499607", "Luhe\-Wildenau",
"4933367", "Friedrichswalde\ Brandenburg",
"4933601", "Podelzig",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"4935385", "Annaburg",
"494423", "Fedderwarden",
"495062", "Holle\ bei\ Hildesheim",
"497632", "Badenweiler",
"494950", "Holtland",
"4934691", "Könnern",
"499852", "Feuchtwangen",
"496245", "Biblis",
"4938206", "Graal\-Müritz\ Seeheilbad",
"494269", "Ahausen\-Kirchwalsede",
"498756", "Nandlstadt",
"499952", "Eichendorf",
"497392", "Laupheim",
"492129", "Haan\ Rheinland",
"496073", "Babenhausen\ Hessen",
"4939206", "Eichenbarleben",
"498374", "Dietmannsried",
"498328", "Balderschwang",
"495353", "Königslutter\ am\ Elm",
"494159", "Basthorst",
"4939295", "Zuchau",
"499279", "Mistelgau",
"493525", "Riesa",
"495357", "Grasleben",
"495234", "Horn\-Bad\ Meinberg",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"4938295", "Satow\ bei\ Bad\ Doberan",
"496505", "Kordel",
"492453", "Heinsberg\-Randerath",
"498785", "Rottenburg\-Oberroning",
"495552", "Katlenburg",
"498507", "Neuburg\ am\ Inn",
"4938792", "Lenzen\ \(Elbe\)",
"4933337", "Altkünkendorf",
"499342", "Wertheim",
"4934774", "Röblingen\ am\ See",
"4934779", "Abberode",
"498629", "Palling",
"4938737", "Ganzlin",
"499606", "Pfreimd",
"497258", "Oberderdingen\-Flehingen",
"494340", "Achterwehr",
"497082", "Neuenbürg\ Württemberg",
"497823", "Seelbach\ Schutter",
"498503", "Neuhaus\ am\ Inn",
"4939777", "Borkenfriede",
"499547", "Zapfendorf",
"4936428", "Stadtroda",
"499175", "Spalt",
"4935874", "Bernstadt\ an\ der\ Eigen",
"494683", "Oldsum",
"498302", "Görisried",
"496783", "Baumholder",
"4935327", "Priessen",
"492763", "Drolshagen\-Bleche",
"496787", "Niederbrombach",
"497221", "Baden\-Baden",
"494255", "Martfeld",
"499543", "Hirschaid",
"492225", "Meckenheim\ Rheinland",
"499203", "Neudrossenfeld",
"493675", "Sonneberg\ Thüringen",
"498841", "Murnau\ am\ Staffelsee",
"495241", "Gütersloh",
"49841", "Ingolstadt\ Donau",
"493984", "Prenzlau",
"4930", "Berlin",
"492590", "Dülmen\-Buldern",
"499207", "Königsfeld\ Oberfranken",
"494165", "Hollenstedt\ Nordheide",
"4935342", "Mühlberg\ Elbe",
"493735", "Marienberg\ Sachsen",
"495843", "Wustrow\ Wendland",
"498243", "Fuchstal",
"497704", "Geisingen\ Baden",
"4938783", "Dallmin",
"495947", "Laar\ Vechte",
"495943", "Emlichheim",
"4939243", "Nedlitz\ bei\ Zerbst",
"498466", "Denkendorf\ Oberbayern",
"494286", "Gyhum",
"498247", "Bad\ Wörishofen",
"499901", "Hengersberg\ Bayern",
"498075", "Amerang",
"496126", "Idstein",
"4938352", "Kemnitz\ bei\ Greifswald",
"495151", "Hameln",
"4935200", "Arnsdorf\ bei\ Dresden",
"493585", "Löbau",
"492747", "Molzhain",
"4936628", "Zeulenroda",
"499567", "Sesslach\-Gemünda",
"493594", "Bischofswerda",
"498666", "Teisendorf",
"499563", "Rödental",
"492743", "Daaden",
"498388", "Hergensweiler",
"495174", "Lahstedt",
"4933089", "Himmelpfort",
"49861", "Traunstein",
"498153", "Wessling",
"493475", "Lutherstadt\ Eisleben",
"495128", "Hohenhameln",
"498157", "Feldafing",
"4933084", "Gutengermendorf",
"498725", "Wurmannsquick",
"494483", "Ovelgönne\-Grossenmeer",
"496533", "Morbach\ Hunsrück",
"494832", "Meldorf",
"498263", "Breitenbrunn\ Schwaben",
"495863", "Zernien",
"497148", "Grossbottwar",
"498267", "Dirlewang",
"495963", "Bawinkel",
"494932", "Norderney",
"498446", "Pörnbach",
"494372", "Westfehmarn",
"494487", "Grossenkneten\-Huntlosen",
"498861", "Schongau",
"495261", "Lemgo",
"494792", "Worpswede",
"4939934", "Gross\ Plasten",
"496692", "Neustadt\ Hessen",
"4934977", "Quellendorf",
"496872", "Losheim\ am\ See",
"4936739", "Rottenbach",
"4936734", "Leutenberg",
"498039", "Rott\ am\ Inn",
"496332", "Zweibrücken",
"499406", "Mintraching",
"4934345", "Bad\ Lausick",
"4937436", "Weischlitz",
"496804", "Mandelbachtal",
"494249", "Bassum\-Nordwohlde",
"492294", "Morsbach\ Sieg",
"498535", "Haarbach",
"49211", "Düsseldorf",
"492653", "Kaisersesch",
"4934491", "Schmölln\ Thüringen",
"496265", "Billigheim\ Baden",
"492657", "Uersfeld",
"493338", "Bernau\ Brandenburg",
"4934261", "Kühren\ bei\ Wurzen",
"4934382", "Nerchau",
"496186", "Grosskrotzenburg",
"4938843", "Bennin",
"4939953", "Schwinkendorf",
"492166", "Mönchengladbach\-Rheydt",
"495042", "Bad\ Münder\ am\ Deister",
"4936691", "Eisenberg\ Thüringen",
"497432", "Albstadt\-Tailfingen",
"497022", "Nürtingen",
"495102", "Laatzen",
"499235", "Thierstein",
"492256", "Mechernich\-Satzvey",
"496727", "Gensingen",
"494627", "Dörpstedt",
"499198", "Heiligenstadt\ in\ Oberfranken",
"496155", "Griesheim\ Hessen",
"494623", "Böklund",
"4935208", "Radeburg",
"494509", "Gross\ Grönau",
"496723", "Oestrich\-Winkel",
"499403", "Donaustauf",
"492425", "Nideggen\-Embken",
"498194", "Vilgertshofen",
"49821", "Augsburg",
"49581", "Uelzen",
"4936764", "Neuhaus\-Schierschnitz",
"495441", "Diepholz",
"499407", "Wenzenbach",
"49591", "Lingen\ \(Ems\)",
"498443", "Hohenwart\ Paar",
"4937364", "Reitzenhain\ Erzgebirge",
"495966", "Meppen\-Apeldorn",
"4936840", "Trusetal",
"495325", "Goslar\-Hahnenklee",
"4937296", "Stollberg\ Erzgebirge",
"498266", "Kirchheim\ in\ Schwaben",
"4938750", "Malliss",
"492598", "Senden\-Ottmarsbocholt",
"496536", "Kleinich",
"496659", "Eichenzell",
"4937369", "Wolkenstein",
"494486", "Edewecht\-Friedrichsfehn",
"495661", "Melsungen",
"496848", "Homburg\-Einöd",
"499085", "Alerheim",
"496292", "Seckach",
"492802", "Alpen",
"49951", "Bamberg",
"497345", "Langenau\ Württemberg",
"492902", "Warstein",
"497458", "Ebhausen",
"499094", "Tagmersheim",
"499566", "Meeder",
"498663", "Ruhpolding",
"498667", "Seeon\-Seebruck",
"497172", "Lorch\ Württemberg",
"4936871", "Bad\ Colberg\-Heldburg",
"497250", "Kraichtal",
"494348", "Schönkirchen",
"494455", "Jade\-Schweiburg",
"497031", "Böblingen",
"492851", "Rees",
"496726", "Lorch\ Rheingau",
"494626", "Treia",
"495434", "Essen\ Oldenburg",
"492951", "Büren",
"4935264", "Strehla",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"492874", "Isselburg",
"494765", "Ebersdorf\ bei\ Bremervörde",
"492694", "Wershofen",
"498320", "Missen\-Wilhams",
"492828", "Emmerich\-Elten",
"496665", "Sinntal\-Altengronau",
"492253", "Bad\ Münstereifel",
"492257", "Reckerscheid",
"492685", "Flammersfeld",
"492334", "Hagen\-Hohenlimburg",
"492974", "Schmallenberg\-Fredeburg",
"492928", "Soest\-Ostönnen",
"4936946", "Erbenhausen\ Thüringen",
"493301", "Oranienburg",
"494958", "Jemgum",
"497681", "Waldkirch\ Breisgau",
"4938758", "Dömitz",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"496187", "Schöneck",
"492163", "Schwalmtal\ Niederrhein",
"4939746", "Krackow",
"496183", "Erlensee",
"494223", "Ganderkesee\-Bookholzberg",
"494858", "Sankt\ Margarethen\ Holstein",
"499775", "Schönau\ an\ der\ Brend",
"4936848", "Wernshausen",
"497044", "Mönsheim",
"497955", "Wallhausen\ Württemberg",
"496445", "Schöffengrund",
"499395", "Triefenstein",
"496358", "Kriegsfeld",
"494469", "Wangerooge",
"494921", "Emden\ Stadt",
"499635", "Bärnau",
"492656", "Virneburg",
"499384", "Schwanfeld",
"494821", "Itzehoe",
"497463", "Mühlheim\ an\ der\ Donau",
"494102", "Ahrensburg",
"492750", "Diedenshausen",
"497246", "Malsch\ Kreis\ Karlsruhe",
"497467", "Neuhausen\ ob\ Eck",
"498621", "Trostberg",
"493431", "Döbeln",
"4936370", "Grossenehrich",
"4936330", "Grossberndten",
"495623", "Edertal",
"495509", "Rosdorf\ Kreis\ Göttingen",
"4933970", "Neustadt\ Dosse",
"497229", "Iffezheim",
"497643", "Herbolzheim\ Breisgau",
"4937362", "Seiffen\ Erzgebirge",
"492404", "Alsdorf\ Rheinland",
"499722", "Werneck",
"497506", "Wangen\-Leupolz",
"495226", "Bruchmühlen\ Westfalen",
"495304", "Meine",
"4938228", "Dettmannsdorf\-Kölzow",
"4936762", "Steinach\ Thüringen",
"498365", "Wertach",
"4939080", "Kalbe\ Milde",
"496620", "Philippsthal\ Werra",
"4939088", "Letzlingen",
"498571", "Simbach\ am\ Inn",
"494967", "Rhauderfehn\-Burlage",
"495483", "Lienen",
"499708", "Bad\ Bocklet",
"498232", "Schwabmünchen",
"494863", "Sankt\ Peter\-Ording",
"495832", "Hankensbüttel",
"4938220", "Wustrow\ Ostseebad",
"496562", "Speicher",
"4938461", "Bützow",
"492158", "Grefrath\ bei\ Krefeld",
"492582", "Everswinkel",
"495372", "Meinersen",
"499164", "Langenfeld\ Mittelfranken",
"494963", "Dörpen",
"495932", "Haren\ Ems",
"498554", "Schönberg\ Niederbayern",
"492383", "Bönen",
"494261", "Rotenburg\ Wümme",
"4939291", "Calbe\ Saale",
"495573", "Uslar\-Volpriehausen",
"49203", "Duisburg",
"4934606", "Teicha\ Sachsen\-Anhalt",
"495145", "Beedenbostel",
"492472", "Monschau",
"496363", "Niederkirchen",
"492387", "Drensteinfurt\-Walstedde",
"498064", "Au\ bei\ Bad\ Aibling",
"4933836", "Butzow\ bei\ Brandenburg",
"4935477", "Rietzneuendorf\-Friedrichshof",
"496134", "Mainz\-Kastel",
"4933978", "Segeletz",
"494151", "Schwarzenbek",
"497125", "Bad\ Urach",
"4933763", "Bestensee",
"4936338", "Bleicherode",
"4939363", "Angern",
"499532", "Maroldsweisach",
"4936378", "Ostramondra",
"497753", "Albbruck",
"499271", "Thurnau\-Alladorf",
"4933876", "Buschow",
"499973", "Furth\ im\ Wald",
"499333", "Sommerhausen",
"494174", "Stelle\ Kreis\ Harburg",
"494128", "Kollmar",
"496052", "Bad\ Orb",
"492268", "Kürten",
"4935826", "Königshain\ bei\ Görlitz",
"499873", "Abenberg\-Wassermungenau",
"499254", "Gefrees",
"499337", "Gaukönigshofen",
"499977", "Arnschwang",
"4939997", "Jarmen",
"4936732", "Könitz",
"492132", "Meerbusch\-Büderich",
"4939972", "Walkendorf",
"492369", "Dorsten\-Wulfen",
"498823", "Mittenwald",
"495223", "Bünde",
"498082", "Schwindegg",
"498258", "Sielenbach",
"495858", "Hitzacker\-Wietzetze",
"4939932", "Malchow\ bei\ Waren",
"497503", "Wilhelmsdorf\ Württemberg",
"4933605", "Boossen",
"497629", "Tegernau\ Baden",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"492054", "Essen\-Kettwig",
"4933093", "Fürstenberg\ Havel",
"492945", "Lippstadt\-Benninghausen",
"493682", "Zella\-Mehlis",
"495921", "Nordhorn",
"49228", "Bonn",
"497646", "Weisweil\ Breisgau",
"492845", "Neukirchen\-Vluyn",
"498450", "Ingolstadt\-Zuchering",
"498221", "Günzburg",
"495821", "Bad\ Bevensen",
"497841", "Achern",
"492564", "Vreden",
"4939456", "Altenbrak",
"49741", "Rottweil",
"496595", "Dockweiler",
"499182", "Velburg",
"4933082", "Menz\ Kreis\ Oberhavel",
"495626", "Bad\ Zwesten",
"499744", "Zeitlofs\-Detter",
"4938456", "Langhagen\ bei\ Güstrow",
"497941", "Öhringen",
"496451", "Frankenberg\ Eder",
"494434", "Colnrade",
"494180", "Königsmoor",
"496584", "Wellen\ Mosel",
"496220", "Wilhelmsfeld",
"4935775", "Pechern",
"495765", "Raddestorf",
"4938325", "Rolofshagen",
"499521", "Hassfurt",
"498704", "Altdorf\-Pfettrach",
"497243", "Ettlingen",
"4939325", "Vinzelberg",
"497247", "Linkenheim\-Hochstetten",
"498168", "Attenkirchen",
"4938354", "Wusterhusen",
"496474", "Villmar\-Aumenau",
"496428", "Stadtallendorf",
"497466", "Beuron",
"498772", "Mallersdorf\-Pfaffenberg",
"497579", "Schwenningen\ Baden",
"4935723", "Bernsdorf\ OL",
"494661", "Niebüll",
"498593", "Untergriesbach",
"499876", "Rohr\ Mittelfranken",
"496761", "Simmern\ Hunsrück",
"492355", "Schalksmühle",
"499336", "Bütthard",
"4936077", "Grossbodungen",
"496402", "Hungen",
"492448", "Hellenthal\-Rescheid",
"499976", "Rötz",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"4938333", "Horst\ bei\ Grimmen",
"4933733", "Stülpe",
"4938373", "Katzow",
"495455", "Tecklenburg\-Brochterbeck",
"498392", "Markt\ Rettenbach",
"497328", "Königsbronn",
"497934", "Weikersheim",
"4939387", "Havelberg",
"494441", "Vechta",
"497374", "Uttenweiler",
"49481", "Heide\ Holstein",
"496825", "Illingen\ Saar",
"499293", "Berg\ Oberfranken",
"49491", "Leer\ Ostfriesland",
"4934384", "Grossbothen",
"499654", "Pleystein",
"497834", "Wolfach",
"494966", "Neubörger",
"4935603", "Burg\ Spreewald",
"497351", "Biberach\ an\ der\ Riss",
"499671", "Oberviechtach",
"49631", "Kaiserslautern",
"4936083", "Uder",
"498342", "Marktoberdorf",
"496049", "Kefenrod",
"4938850", "Gammelin",
"4936028", "Kammerforst\ Thüringen",
"499503", "Oberhaid\ Oberfranken",
"492525", "Beckum\-Neubeckum",
"495541", "Hann\.\ Münden",
"496436", "Dornburg\ Hessen",
"499302", "Rottendorf\ Unterfranken",
"496026", "Grossostheim",
"498547", "Osterhofen\-Gergweis",
"498543", "Aidenbach",
"4937433", "Gutenfürst",
"499646", "Freihung",
"495724", "Obernkirchen",
"49941", "Regensburg",
"495907", "Geeste",
"4939931", "Röbel\ Müritz",
"499841", "Bad\ Windsheim",
"497744", "Stühlingen",
"498203", "Grossaitingen",
"495803", "Rosche",
"497182", "Welzheim",
"497558", "Illmensee",
"4936731", "Unterloquitz",
"499941", "Kötzting",
"495807", "Altenmedingen",
"498207", "Affing",
"4939971", "Gnoien",
"495903", "Emsbüren",
"495201", "Halle\ Westfalen",
"498801", "Seeshaupt",
"499243", "Pottenstein",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"494491", "Friesoythe",
"499075", "Glött",
"499466", "Stamsried",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4935248", "Schönfeld\ bei\ Grossenhain",
"495534", "Eschershausen\ an\ der\ Lenne",
"4935240", "Tauscha\ bei\ Grossenhain",
"496864", "Mettlach",
"492675", "Ediger\-Eller",
"496205", "Hockenheim",
"492984", "Hallenberg",
"4933657", "Steinsdorf\ Brandenburg",
"4939267", "Schneidlingen",
"497976", "Sulzbach\-Laufen",
"497336", "Lonsee",
"492735", "Neunkirchen\ Siegerl",
"4934494", "Ehrenhain",
"495252", "Bad\ Lippspringe",
"494364", "Dahme\ Kreis\ Ostholstein",
"4937348", "Oberwiesenthal\ Kurort",
"495162", "Fallingbostel",
"499374", "Eschau",
"494133", "Wittorf\ Kreis\ Lüneburg",
"495339", "Gielde",
"494137", "Barendorf",
"497731", "Singen\ Hohentwiel",
"499834", "Theilenhofen",
"497654", "Löffingen",
"4939858", "Bietikow",
"4936694", "Schkölen\ Thüringen",
"499351", "Gemünden\ am\ Main",
"496173", "Kronberg\ im\ Taunus",
"496545", "Blankenrath",
"4938858", "Lassahn",
"493763", "Glauchau",
"4936020", "Ebeleben",
"4939956", "Neukalen",
"497671", "Todtnau",
"493494", "Wolfen",
"4937607", "Ebersbrunn\ Sachsen",
"499463", "Wald\ Oberpfalz",
"4937361", "Neuhausen\ Erzgebirge",
"495195", "Neuenkirchen\ bei\ Soltau",
"499246", "Pegnitz\-Trockau",
"495184", "Freden\ Leine",
"499467", "Michelsneukirchen",
"495742", "Preussisch\ Oldendorf",
"498378", "Buchenberg\ bei\ Kempten",
"4933395", "Zerpenschleuse",
"495906", "Lünne",
"498324", "Hindelang",
"4936761", "Heubisch",
"495238", "Nieheim\-Himmighausen",
"492330", "Herdecke",
"498206", "Egling\ an\ der\ Paar",
"495806", "Barum\ bei\ Bad\ Bevensen",
"499229", "Mainleus",
"495601", "Schauenburg",
"492862", "Südlohn",
"496027", "Stockstadt\ am\ Main",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"4937463", "Bergen\ Vogtland",
"498546", "Windorf\-Otterskirchen",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"4933927", "Linum",
"499647", "Kirchenthumbach",
"496023", "Alzenau\ in\ Unterfranken",
"496433", "Hadamar",
"492962", "Olsberg",
"4937293", "Eppendorf\ Sachsen",
"497722", "Triberg\ im\ Schwarzwald",
"4933438", "Altlandsberg",
"494382", "Wangels",
"4935937", "Prischwitz",
"494477", "Lastrup\-Hemmelte",
"494473", "Emstek",
"4933478", "Gross\ Neuendorf",
"497708", "Geisingen\-Leipferdingen",
"4933470", "Lietzen",
"495652", "Bad\ Sooden\-Allendorf",
"4936943", "Bettenhausen\ Thüringen",
"498025", "Miesbach",
"498435", "Ehekirchen",
"4939743", "Zerrenthin",
"497164", "Boll\ Kreis\ Göppingen",
"494705", "Wremen",
"492275", "Kerpen\-Buir",
"492043", "Gladbeck",
"4939035", "Kuhfelde",
"49371", "Chemnitz\ Sachsen",
"494136", "Scharnebeck",
"493361", "Fürstenwalde\ Spree",
"4938462", "Baumgarten",
"492103", "Hilden",
"497532", "Meersburg",
"499090", "Rain\ Lech",
"497271", "Wörth\ am\ Rhein",
"497333", "Laichingen",
"497973", "Obersontheim",
"4938292", "Kröpelin",
"4934208", "Löbnitz\ bei\ Delitzsch",
"494409", "Westerstede\-Ocholt",
"497977", "Oberrot\ bei\ Gaildorf",
"497337", "Nellingen\ Alb",
"4939292", "Biederitz",
"498679", "Burgkirchen\ an\ der\ Alz",
"497254", "Waghäusel",
"497403", "Dunningen",
"494339", "Christiansholm",
"497056", "Gechingen",
"494162", "Jork",
"495137", "Seelze",
"492222", "Bornheim\ Rheinland",
"492644", "Linz\ am\ Rhein",
"493672", "Rudolstadt",
"498131", "Dachau",
"498550", "Philippsreut",
"496061", "Michelstadt",
"498072", "Haag\ in\ Oberbayern",
"4934658", "Hayn\ Harz",
"496130", "Schwabenheim\ an\ der\ Selz",
"494534", "Steinburg\ Kreis\ Storman",
"496551", "Prüm",
"497085", "Enzklösterle",
"4934775", "Wippra",
"496484", "Beselich",
"492464", "Aldenhoven\ bei\ Jülich",
"49751", "Ravensburg",
"499345", "Külsheim\ Baden",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"499869", "Wettringen\ Mittelfranken",
"496574", "Hasborn",
"497566", "Argenbühl",
"494252", "Bruchhausen\-Vilsen",
"499172", "Georgensgmünd",
"495364", "Velpke",
"499421", "Straubing",
"4936458", "Bad\ Berka",
"492631", "Neuwied",
"4939366", "Kehnert",
"493522", "Grossenhain\ Sachsen",
"4933766", "Teupitz",
"496502", "Schweich",
"492754", "Bad\ Laasphe\-Feudingen",
"4936450", "Kranichfeld",
"4939294", "Gross\ Rosenburg",
"494803", "Pahlen",
"4933833", "Wollin\ bei\ Brandenburg",
"492548", "Dülmen\-Rorup",
"4933873", "Grosswudicke",
"492391", "Plettenberg",
"4938294", "Neubukow",
"494903", "Wymeer",
"499104", "Emskirchen",
"4934297", "Liebertwolkwitz",
"496307", "Schopp",
"495555", "Moringen\-Fredelsloh",
"493327", "Werder\ Havel",
"492771", "Dillenburg",
"4934467", "Eckartsberga",
"4938464", "Bernitt",
"495491", "Damme\ Dümmer",
"4935823", "Ostritz",
"498782", "Pfeffenhausen",
"498144", "Grafrath",
"496303", "Enkenbach\-Alsenborn",
"499681", "Windischeschenbach",
"495476", "Ostercappeln\-Venne",
"495065", "Sibbesse",
"4935384", "Steinsdorf\ bei\ Jessen",
"4935389", "Holzdorf\ Elster",
"494638", "Tarp",
"494541", "Ratzeburg",
"497775", "Mühlingen",
"497395", "Ehingen\-Dächingen",
"499955", "Mamming",
"495586", "Wieda",
"492836", "Wachtendonk",
"499855", "Dentlein\ am\ Forst",
"496242", "Osthofen",
"496898", "Völklingen",
"495300", "Salzgitter\-Üfingen",
"494724", "Cuxhaven\-Lüdingworth",
"497384", "Schelklingen\-Hütten",
"492208", "Niederkassel",
"497635", "Schliengen",
"496678", "Wildeck\-Hönebach",
"496624", "Heringen\ Werra",
"494778", "Wingst",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"4934920", "Kropstädt",
"4939453", "Derenburg",
"492309", "Waltrop",
"497567", "Leutkirch\-Friesenhofen",
"497563", "Kisslegg",
"4938453", "Mistorf",
"497139", "Neuenstadt\ am\ Kocher",
"497362", "Bopfingen",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"4935058", "Pretzschendorf",
"4939400", "Wefensleben",
"493531", "Finsterwalde",
"492622", "Bendorf\ am\ Rhein",
"492244", "Königswinter\-Oberpleis",
"496752", "Kirn\ Nahe",
"4933207", "Gross\ Kreutz",
"492504", "Telgte",
"497930", "Boxberg\ Baden",
"499148", "Ettenstatt",
"4938351", "Mesekenhagen",
"495705", "Petershagen\-Windheim",
"498764", "Mauern\ Kreis\ Freising",
"497053", "Bad\ Teinach\-Zavelstein",
"495136", "Burgdorf\ Kreis\ Hannover",
"492482", "Hellenthal",
"493721", "Meinersdorf",
"492377", "Wickede\ Ruhr",
"492937", "Arnsberg\-Oeventrop",
"496701", "Sprendlingen\ Rheinhessen",
"492833", "Kerken",
"492837", "Weeze",
"4936692", "Bürgel",
"495583", "Braunlage\-Hohegeiss",
"498122", "Erding",
"492933", "Sundern\ Sauerland",
"492373", "Menden\ Sauerland",
"496462", "Gladenbach",
"495382", "Bad\ Gandersheim",
"4935606", "Briesen\ bei\ Cottbus",
"493544", "Luckau\ Brandenburg",
"492572", "Emsdetten",
"498454", "Karlshuld",
"498581", "Waldkirchen\ Niederbayern",
"495473", "Ostercappeln",
"496306", "Trippstadt",
"494195", "Hartenholm",
"493965", "Burow\ bei\ Altentreptow",
"4935726", "Gross\ Särchen",
"4939408", "Hadmersleben",
"496642", "Schlitz",
"4935695", "Simmersdorf",
"492608", "Welschneudorf",
"497235", "Unterreichenbach\ Kreis\ Calw",
"494742", "Dorum",
"496224", "Sandhausen\ Baden",
"496580", "Zemmer",
"4934492", "Lucka",
"494184", "Hanstedt\ Nordheide",
"493865", "Holthusen",
"499281", "Hof\ Saale",
"494806", "Sarzbüttel",
"494238", "Neddenaverbergen",
"4938376", "Zirchow",
"4934262", "Falkenhain\ bei\ Wurzen",
"4934928", "Seegrehna",
"4934381", "Colditz",
"495026", "Steimbke",
"4935244", "Krögis",
"495436", "Nortrup",
"497735", "Öhningen",
"4935249", "Basslitz",
"494624", "Kropp",
"494242", "Syke",
"496724", "Stromberg\ Hunsrück",
"499448", "Hausen\ Niederbayern",
"4935052", "Kipsdorf\ Kurort",
"492336", "Schwelm",
"499355", "Frammersbach",
"496398", "Vorderweidenthal",
"496541", "Traben\-Trarbach",
"4936701", "Lichte",
"4936257", "Luisenthal\ Thüringen",
"492696", "Nohn\ Eifel",
"496638", "Schwalmtal\-Renzendorf",
"497675", "Bernau\ Baden",
"4939887", "Gerswalde",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4933366", "Chorin",
"496201", "Weinheim\ Bergstr",
"492671", "Cochem",
"494307", "Raisdorf",
"4938873", "Carlow",
"494303", "Schlesen",
"495109", "Ronnenberg",
"4936621", "Elsterberg\ bei\ Plauen",
"492991", "Marsberg\-Bredelar",
"4936966", "Kaltennordheim",
"498682", "Laufen\ Salzach",
"496803", "Mandelbachtal\-Ommersheim",
"4936029", "Menteroda",
"494502", "Lübeck\-Travemünde",
"492293", "Nümbrecht",
"499386", "Prosselsheim",
"492654", "Polch",
"492297", "Wildbergerhütte",
"4936024", "Diedorf\ bei\ Mühlhausen",
"493923", "Zerbst",
"497046", "Zaberfeld",
"499845", "Oberdachstetten",
"496252", "Heppenheim\ Bergstrasse",
"4939825", "Wokuhl",
"4938854", "Redefin",
"494528", "Schönwalde\ am\ Bungsberg",
"4939859", "Fürstenwerder",
"4938825", "Klütz",
"4939854", "Kleptow",
"4936744", "Remda",
"499945", "Arnbruck",
"498196", "Pürgen",
"4938859", "Alt\ Zachun",
"498805", "Hohenpeissenberg",
"495205", "Bielefeld\-Sennestadt",
"494484", "Hude\-Wüsting",
"4937349", "Scheibenberg",
"497525", "Aulendorf",
"496534", "Mülheim\ Mosel",
"4935201", "Langebrück",
"494551", "Bad\ Segeberg",
"495864", "Jameln",
"494495", "Friesoythe\-Thüle",
"499071", "Dillingen\ an\ der\ Donau",
"499369", "Uettingen",
"495964", "Lähden",
"4937344", "Crottendorf\ Sachsen",
"499132", "Herzogenaurach",
"494939", "Baltrum",
"495173", "Uetze",
"4939402", "Völpke",
"492521", "Beckum",
"493632", "Sondershausen",
"494839", "Wöhrden\ Dithmarschen",
"495545", "Hedemünden",
"495177", "Edemissen\-Abbensen",
"4934498", "Rositz",
"496162", "Reinheim\ Odenwald",
"496339", "Grosssteinhausen",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"498422", "Dollnstein",
"498171", "Wolfratshausen",
"499564", "Bad\ Rodach",
"493772", "Schneeberg\ Erzgebirge",
"4934922", "Mühlanger",
"492744", "Herdorf",
"492558", "Horstmar",
"492182", "Grevenbroich\-Kapellen",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"497043", "Maulbronn",
"4933474", "Neutrebbin",
"499472", "Hohenfels\ Oberpfalz",
"4933439", "Fredersdorf\-Vogelsdorf",
"499383", "Wiesentheid",
"4933479", "Küstrin\-Kietz",
"4933434", "Herzfelde\ bei\ Strausberg",
"497275", "Kandel",
"496238", "Dirmstein",
"492296", "Reichshof\-Brüchermühle",
"496806", "Heusweiler",
"499158", "Offenhausen\ Mittelfranken",
"496195", "Kelkheim\ Taunus",
"4936878", "Oberland",
"4938736", "Goldberg",
"492164", "Jüchen\-Otzenrath",
"4939776", "Hintersee",
"493949", "Oschersleben\ Bode",
"4934781", "Greifenhagen",
"496184", "Langenselbold",
"496020", "Heigenbrücken",
"496742", "Boppard",
"4935455", "Walddrehna",
"494224", "Gross\ Ippener",
"4933336", "Passow\ Kreis\ Uckermark",
"4939863", "Seehausen\ bei\ Prenzlau",
"496430", "Hahnstätten",
"4934652", "Allstedt",
"4934241", "Jesewitz",
"494642", "Kappeln\ Schlei",
"492873", "Isselburg\-Werth",
"492693", "Antweiler",
"499268", "Teuschnitz",
"49208", "Oberhausen\ Rheinland",
"492977", "Schmallenberg\-Bödefeld",
"492254", "Weilerswist",
"492337", "Hagen\-Dahl",
"492333", "Ennepetal",
"498021", "Waakirchen",
"492973", "Eslohe\ Sauerland",
"492697", "Blankenheim\-Ahrhütte",
"498431", "Neuburg\ an\ der\ Donau",
"495027", "Linsburg",
"493621", "Gotha\ Thüringen",
"492532", "Ostbevern",
"495437", "Menslage",
"492271", "Bergheim\ Erft",
"495433", "Badbergen",
"494462", "Wittmund",
"4936452", "Berlstedt",
"498282", "Krumbach\ Schwaben",
"495882", "Gorleben",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"495605", "Kaufungen\ Hessen",
"4936841", "Schleusingen",
"498664", "Chieming",
"493596", "Neustadt\ in\ Sachsen",
"4939751", "Penkun",
"4939207", "Colbitz",
"4938751", "Picher",
"4938207", "Stäbelow",
"4934204", "Schkeuditz",
"496652", "Hünfeld",
"499097", "Marxheim",
"494752", "Neuhaus\ Oste",
"495176", "Edemissen",
"499093", "Polsingen",
"498444", "Schweitenkirchen",
"495191", "Soltau",
"492722", "Attendorn",
"4939005", "Kusey",
"4936870", "Masserberg",
"499404", "Nittendorf",
"498193", "Geltendorf",
"497962", "Fichtenau",
"493571", "Hoyerswerda",
"495379", "Sassenburg\-Grussendorf",
"4936454", "Magdala",
"499974", "Traitsching",
"499257", "Zell\ Oberfranken",
"495939", "Sustrum",
"494173", "Wulfsen",
"499334", "Giebelstadt",
"4937756", "Breitenbrunn\ Erzgebirge",
"499928", "Kirchdorf\ im\ Wald",
"498239", "Langenneufnach",
"495839", "Wittingen\-Ohrdorf",
"499874", "Neuendettelsau",
"493663", "Schleiz",
"496569", "Bickendorf",
"4936425", "Isserstedt",
"499828", "Rügland",
"494177", "Drage\ Elbe",
"497771", "Stockach",
"4936459", "Blankenhain\ Thüringen",
"499253", "Weissenstadt",
"494545", "Seedorf\ Lauenburg",
"498063", "Feldkirchen\-Westerham",
"499951", "Landau\ an\ der\ Isar",
"4933846", "Dippmannsdorf",
"4938221", "Marlow",
"497391", "Ehingen\ Donau",
"496133", "Oppenheim",
"4939221", "Möckern\ bei\ Magdeburg",
"497631", "Müllheim\ Baden",
"499851", "Dinkelsbühl",
"497754", "Görwihl",
"498067", "Tuntenhausen",
"498553", "Spiegelau",
"495528", "Gieboldehausen",
"497836", "Schiltach",
"499656", "Moosbach\ bei\ Vohenstrauss",
"492635", "Rheinbrohl",
"492384", "Welver",
"493447", "Altenburg\ Thüringen",
"495574", "Oberweser",
"4934654", "Stolberg\ Harz",
"492395", "Finnentrop\-Rönkhausen",
"497376", "Langenenslingen",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"497936", "Schrozberg\-Bartenstein",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"496364", "Nussbach\ Pfalz",
"498557", "Mauth",
"494205", "Ottersberg",
"499167", "Oberscheinfeld",
"4933432", "Müncheberg",
"495484", "Lienen\-Kattenvenne",
"494864", "Oldenswort",
"495130", "Wedemark",
"495551", "Northeim",
"492775", "Driedorf",
"495495", "Vörden\ Kreis\ Vechta",
"496059", "Jossgrund",
"4933472", "Golzow\ bei\ Seelow",
"499163", "Dachsbach",
"494964", "Rhede\ Ems",
"4936371", "Schlossvippach",
"496555", "Bleialf",
"4934673", "Heldrungen",
"497081", "Bad\ Wildbad",
"495307", "Braunschweig\-Wenden",
"4933931", "Rheinsberg\ Mark",
"494109", "Tangstedt\ Bz\ Hamburg",
"4933971", "Kyritz\ Brandenburg",
"495303", "Wendeburg",
"4934633", "Braunsbedra",
"499341", "Tauberbischofsheim",
"4936331", "Ilfeld",
"495502", "Dransfeld",
"497222", "Rastatt",
"492407", "Herzogenrath\-Kohlscheid",
"497644", "Kenzingen",
"492403", "Eschweiler\ Rheinland",
"4935388", "Klöden",
"492056", "Heiligenhaus",
"496586", "Beuren\ Hochwald",
"499746", "Zeitlofs",
"495624", "Bad\ Emstal",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"495242", "Rheda\-Wiedenbrück",
"492566", "Legden",
"497464", "Talheim\ Kreis\ Tuttlingen",
"498135", "Sulzemoos",
"49251", "Münster",
"496476", "Mengerskirchen",
"4934202", "Delitzsch",
"498706", "Vilsheim",
"499802", "Ansbach\-Katterbach",
"4939298", "Barby\ Elbe",
"499729", "Grettstadt",
"496409", "Biebertal",
"499166", "Münchsteinach",
"4936022", "Grossengottern",
"494191", "Kaltenkirchen\ Holstein",
"493961", "Altentreptow",
"497231", "Pforzheim",
"497572", "Mengen\ Württemberg",
"4935793", "Elstra",
"493861", "Plate",
"497837", "Oberharmersbach",
"4933237", "Paulinenaue",
"499657", "Waldthurn",
"499285", "Kirchenlamitz",
"496092", "Heimbuchenthal",
"497933", "Creglingen",
"497373", "Zwiefalten",
"499294", "Regnitzlosau",
"498639", "Neumarkt\-Sankt\ Veit",
"497482", "Horb\-Dettingen",
"4936785", "Gräfinau\-Angstedt",
"497937", "Dörzbach",
"499653", "Eslarn",
"498556", "Haidmühle",
"49911", "Nuremberg",
"497833", "Hornberg\ Schwarzwaldbahn",
"493725", "Zschopau",
"494605", "Medelby",
"4935025", "Liebstadt",
"4939343", "Jerichow",
"49361", "Erfurt",
"4933743", "Blönsdorf",
"4935054", "Lauenstein\ Sachsen",
"496136", "Nieder\-Olm",
"498066", "Bad\ Feilnbach",
"492235", "Erftstadt",
"499256", "Stammbach",
"495752", "Auetal\-Hattendorf",
"494176", "Marschacht",
"4935242", "Nossen",
"498585", "Grainet",
"497622", "Schopfheim",
"496382", "Lauterecken",
"496477", "Greifenstein\-Nenderoth",
"4934924", "Zahna",
"497244", "Weingarten\ Baden",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"498703", "Essenbach",
"4938306", "Samtens",
"498707", "Adlkofen",
"4934929", "Straach",
"496473", "Leun",
"492362", "Dorsten",
"4939927", "Nossentiner\ Hütte",
"4934955", "Gossa",
"496587", "Zerf",
"4939409", "Eilsleben",
"4937327", "Rechenberg\-Bienenmühle",
"492563", "Stadtlohn",
"4936463", "Gebstedt",
"499747", "Geroda\ Bayern",
"494433", "Dötlingen",
"495462", "Ankum",
"494882", "Lunden",
"497309", "Weissenhorn",
"4939404", "Ausleben",
"492567", "Ahaus\-Alstätte",
"496583", "Palzem",
"492053", "Velbert\-Neviges",
"492406", "Herzogenrath",
"4937342", "Cranzahl",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4939852", "Schönermark\ bei\ Prenzlau",
"4936607", "Niederpöllnitz",
"4936742", "Uhlstädt",
"4939395", "Wanzer",
"495306", "Cremlingen",
"498338", "Böhen",
"493535", "Herzberg\ Elster",
"498824", "Oberau\ Loisach",
"495224", "Enger\ Westfalen",
"4938852", "Wittenburg",
"497504", "Horgenzell",
"495642", "Warburg\-Scherfede",
"495278", "Höxter\-Ovenhausen",
"494288", "Horstedt\ Kreis\ Rotenburg",
"497166", "Adelberg",
"4938876", "Roggendorf",
"4936738", "Königsee",
"496128", "Taunusstein",
"4933363", "Altenhof\ Kreis\ Barnim",
"496174", "Königstein\ im\ Taunus",
"498468", "Altmannstein\-Pondorf",
"4939978", "Gross\ Roge",
"4934907", "Jeber\-Bergfrieden",
"4936963", "Dorndorf\ Rhön",
"493764", "Meerane",
"4936704", "Steinheid",
"499231", "Marktredwitz",
"499572", "Burgkunstadt",
"497657", "Eisenbach\ Hochschwarzwald",
"4939427", "Ströbeck",
"494480", "Ovelgönne\-Strückhausen",
"499837", "Haundorf",
"499373", "Amorbach",
"494134", "Embsen\ Kreis\ Lüneburg",
"496151", "Darmstadt",
"499933", "Wallersdorf",
"4935241", "Lommatzsch",
"4934424", "Reuden\ bei\ Zeitz",
"499937", "Oberpöring",
"495259", "Bad\ Driburg\-Neuenheerse",
"499482", "Wörth\ an\ der\ Donau",
"499377", "Freudenberg\-Boxtal",
"4938427", "Blowatz",
"499833", "Heidenheim\ Mittelfranken",
"49711", "Stuttgart",
"497653", "Lenzkirch",
"495692", "Wolfhagen",
"495872", "Stoetze",
"498272", "Wertingen",
"4933088", "Falkenthal",
"494367", "Grossenbrode",
"496261", "Mosbach\ Baden",
"498531", "Pocking",
"494363", "Lensahn",
"495332", "Schöppenstedt",
"4936021", "Schlotheim",
"497256", "Philippsburg",
"499608", "Kohlberg\ Oberpfalz",
"494562", "Grömitz",
"495533", "Bodenwerder",
"492983", "Winterberg\-Siedlinghausen",
"499560", "Grub\ am\ Forst",
"492432", "Wassenberg",
"496867", "Perl",
"4936624", "Teichwolframsdorf",
"499622", "Hirschau\ Oberpfalz",
"495186", "Salzhemmendorf\-Wallensen",
"499244", "Betzenstein",
"4938485", "Dabel",
"4935204", "Wilsdruff",
"4935209", "Mohorn",
"4939485", "Gernrode\ Harz",
"4937341", "Ehrenfriedersdorf",
"496042", "Büdingen\ Hessen",
"498349", "Stötten\ am\ Auerberg",
"493496", "Köthen\ Anhalt",
"4933962", "Heiligengrabe",
"4938851", "Zarrentin",
"495265", "Dörentrup",
"498204", "Mickhausen",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"497743", "Ühlingen\-Birkendorf",
"498326", "Fischen\ im\ Allgäu",
"4936741", "Bad\ Blankenburg",
"497747", "Berau",
"494141", "Stade",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4939851", "Göritz\ bei\ Prenzlau",
"495904", "Lengerich\ Emsl",
"493581", "Görlitz",
"495155", "Emmerthal",
"498544", "Eging\ am\ See",
"495723", "Bad\ Nenndorf",
"496102", "Neu\-Isenburg",
"493471", "Bernburg\ Saale",
"4935365", "Falkenberg\ Elster",
"499504", "Stadelhofen",
"498721", "Eggenfelden",
"4936730", "Sitzendorf",
"497334", "Deggingen",
"497257", "Bruchsal\-Untergrombach",
"497685", "Gutach\-Bleibach",
"497974", "Bühlerzell",
"4939247", "Güterglück",
"496325", "Lambrecht\ Pfalz",
"495659", "Ringgau",
"49431", "Kiel",
"4938787", "Glöwen",
"496866", "Perl\-Nennig",
"4934244", "Mockrehna",
"497253", "Bad\ Schönborn",
"495536", "Holzminden\-Neuhaus",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"499391", "Marktheidenfeld",
"49681", "Saarbrücken",
"496441", "Wetzlar",
"497951", "Crailsheim",
"496788", "Sien",
"494366", "Grömitz\-Cismar",
"494925", "Hinte",
"492104", "Mettmann",
"497851", "Kehl",
"499631", "Tirschenreuth",
"499548", "Mühlhausen\ Mittelfranken",
"494825", "Burg\ Dithmarschen",
"499208", "Bindlach",
"497656", "Schluchsee",
"499836", "Gunzenhausen\-Cronheim",
"492855", "Voerde\ Niederrhein",
"4935323", "Sonnewalde",
"498732", "Frontenhausen",
"499936", "Wallerfing",
"492955", "Büren\-Wewelsburg",
"499376", "Collenberg",
"4937368", "Deutschneudorf",
"498248", "Lamerdingen",
"4939773", "Altwarp",
"495848", "Trebel",
"495292", "Lichtenau\-Atteln",
"494761", "Bremervörde",
"4939222", "Möser",
"496661", "Schlüchtern",
"4938733", "Karbow\-Vietlübbe",
"4938222", "Semlow",
"495948", "Itterbeck",
"492681", "Altenkirchen\ Westerwald",
"494402", "Rastede",
"4933333", "Tantow",
"497163", "Ebersbach\ an\ der\ Fils",
"4939082", "Mieste",
"495665", "Guxhagen",
"4933456", "Wriezen",
"499081", "Nördlingen",
"494474", "Garrel",
"499222", "Presseck",
"4938759", "Tewswoos",
"495726", "Wiedensahl",
"499644", "Pressath",
"4938725", "Gross\ Godems",
"4937360", "Olbernhau",
"4939754", "Löcknitz\ Vorpom",
"4936925", "Marksuhl",
"4936844", "Rohr\ Thüringen",
"497425", "Trossingen",
"496024", "Schöllkrippen",
"4936849", "Kleinschmalkalden",
"494451", "Varel\ Jadebusen",
"496078", "Gross\-Umstadt",
"496434", "Bad\ Camberg",
"4938754", "Leussow\ bei\ Ludwigslust",
"49212", "Solingen",
"4933972", "Breddin",
"492421", "Düren",
"4936332", "Ellrich",
"495445", "Drebber",
"498323", "Immenstadt\ im\ Allgäu",
"495358", "Bahrdorf\-Mackendorf",
"4939605", "Gross\ Nemerow",
"498327", "Rettenberg",
"497746", "Wutöschingen",
"4936372", "Kleinneuhausen",
"4933932", "Fehrbellin",
"4935268", "Stauchitz",
"495321", "Goslar",
"493493", "Bitterfeld",
"495187", "Delligsen",
"499464", "Walderbach",
"497729", "Tennenbronn",
"495183", "Lamspringe",
"497802", "Oberkirch\ Baden",
"4938224", "Gresenhorst",
"494155", "Büchen",
"496627", "Nentershausen\ Hessen",
"497387", "Hohenstein\ Württemberg",
"497472", "Rottenburg\ am\ Neckar",
"497121", "Reutlingen",
"493603", "Bad\ Langensalza",
"496509", "Büdlich",
"494723", "Cuxhaven\-Altenwalde",
"4939224", "Büden",
"497383", "Münsingen\-Buttenhausen",
"496623", "Rotenburg\ an\ der\ Fulda",
"493529", "Heidenau\ Sachsen",
"4938229", "Bad\ Sülze",
"499275", "Speichersdorf",
"4935893", "Mücka",
"497582", "Bad\ Buchau",
"497158", "Neuhausen\ auf\ den\ Fildern",
"4936451", "Buttelstedt",
"498456", "Lenting",
"493546", "Lübben\ Spreewald",
"494186", "Buchholz\-Trelde",
"497268", "Bad\ Rappenau\-Obergimpern",
"496226", "Meckesheim",
"493838", "Bergen\ auf\ Rügen",
"49234", "Bochum",
"493378", "Ludwigsfelde",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"496304", "Wolfstein\ Pfalz",
"498143", "Inning\ am\ Ammersee",
"499107", "Trautskirchen",
"494265", "Fintel",
"4934782", "Mansfeld\ Südharz",
"4934242", "Hohenpriessnitz",
"496249", "Guntersblum",
"4934651", "Rossla",
"492753", "Erndtebrück",
"494804", "Nordhastedt",
"4933843", "Niemegk",
"495141", "Celle",
"499103", "Cadolzburg",
"494872", "Hanerau\-Hademarschen",
"493679", "Neuhaus\ am\ Rennweg",
"496573", "Gillenfeld",
"495367", "Rühen",
"4935955", "Pulsnitz",
"495363", "Wolfsburg\-Vorsfelde",
"494332", "Hamdorf\ bei\ Rendsburg",
"494972", "Langeoog",
"494169", "Sauensiek",
"496145", "Flörsheim\ am\ Main",
"496832", "Beckingen\-Reimsbach",
"492246", "Lohmar\ Rheinland",
"4936374", "Weissensee",
"495562", "Dassel\-Markoldendorf",
"494533", "Reinfeld\ Holstein",
"4933979", "Wusterhausen\ Dosse",
"496483", "Selters\ Taunus",
"496372", "Bruchmühlbach\-Miesau",
"4933974", "Dessow",
"492463", "Titz",
"4934745", "Winningen\ Sachsen\-Anhalt",
"494537", "Sülfeld\ Holstein",
"4936334", "Wolkramshausen",
"498361", "Nesselwang",
"4936379", "Holzengel",
"495052", "Hermannsburg",
"49871", "Landshut",
"4938752", "Zierzow\ bei\ Ludwigslust",
"4934636", "Schafstädt",
"4939752", "Blumenhagen\ bei\ Strasburg",
"492506", "Münster\-Wolbeck",
"4936842", "Oberhof\ Thüringen",
"492647", "Kesseling",
"493435", "Oschatz",
"497404", "Epfendorf",
"499962", "Schwarzach\ Niederbayern",
"499179", "Freystadt",
"4939089", "Bismark\ Altmark",
"498766", "Gammelsdorf",
"4939084", "Lindstedt",
"492643", "Altenahr",
"499106", "Markt\ Erlbach",
"493901", "Salzwedel",
"497240", "Pfinztal",
"494358", "Loose\ bei\ Eckernförde",
"4936622", "Triebes",
"494445", "Visbek\ Kreis\ Vechta",
"499735", "Massbach",
"496821", "Neunkirchen\ Saar",
"4933746", "Werbig\ bei\ Jüterbog",
"4939346", "Tucheim",
"494187", "Holm\-Seppensen",
"498146", "Moorenweis",
"496227", "Walldorf\ Baden",
"494321", "Neumünster",
"497355", "Hochdorf\ Riss",
"497448", "Seewald",
"496223", "Neckargemünd",
"496858", "Ottweiler\-Fürth",
"499675", "Altendorf\ am\ Nabburg",
"494183", "Jesteburg",
"494749", "Schiffdorf\-Geestenseth",
"494665", "Emmelsbüll\-Horsbüll",
"4934422", "Osterfeld",
"496765", "Gemünden\ Hunsrück",
"498457", "Vohburg\ an\ der\ Donau",
"495428", "Melle\-Neuenkirchen",
"498453", "Reichertshofen\ Oberbayern",
"4935796", "Panschwitz\-Kuckau",
"499439", "Neunburg\-Kemnath",
"492351", "Lüdenscheid",
"495474", "Stemwede\-Dielingen",
"497668", "Ihringen",
"4936702", "Lauscha",
"4933675", "Tauche",
"4936647", "Saalburg\ Thüringen",
"496626", "Wildeck\-Obersuhl",
"497386", "Hayingen",
"493606", "Heiligenstadt\ Heilbad",
"492834", "Straelen",
"495584", "Hattorf\ am\ Harz",
"492934", "Sundern\-Altenhellefeld",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"495451", "Ibbenbüren",
"493342", "Neuenhagen\ bei\ Berlin",
"492374", "Iserlohn\-Letmathe",
"492646", "Königsfeld\ Eifel",
"496591", "Gerolstein",
"497945", "Wüstenrot",
"496455", "Frankenau\ Hessen",
"499498", "Laaber",
"492302", "Witten",
"497054", "Wildberg\ Württemberg",
"496348", "Offenbach\ an\ der\ Queich",
"4939401", "Neuwegersleben",
"499525", "Königsberg\ in\ Bayern",
"494848", "Rantrum",
"494292", "Ritterhude",
"495761", "Stolzenau",
"4934921", "Kemberg",
"494948", "Wiesmoor\-Marcardsmoor",
"497071", "Tübingen",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"497132", "Neckarsulm",
"492507", "Havixbeck",
"4936205", "Gräfenroda",
"492247", "Neunkirchen\-Seelscheid",
"4938303", "Sellin\ Ostseebad",
"4933969", "Stepenitz",
"496486", "Katzenelnbogen",
"4933703", "Sperenberg",
"4933964", "Fretzdorf",
"49531", "Braunschweig",
"494536", "Steinhorst\ Lauenburg",
"492243", "Eitorf",
"492941", "Lippstadt",
"495366", "Jembke",
"495925", "Wietmarschen",
"497564", "Bad\ Wurzach",
"492841", "Moers",
"49241", "Aachen",
"495825", "Wieren",
"498225", "Jettingen\-Scheppach",
"4935202", "Klingenberg\ Sachsen",
"4939226", "Hohenziatz",
"499269", "Tettau\ Kreis\ Kronach",
"496553", "Schönecken",
"494852", "Brunsbüttel",
"4938226", "Dierhagen\ Ostseebad",
"498364", "Seeg",
"4934653", "Rottleberode",
"4933841", "Belzig",
"496557", "Hallschlag",
"4939862", "Schmölln\ bei\ Prenzlau",
"494952", "Rhauderfehn",
"495305", "Sickte",
"499427", "Leiblfing",
"495060", "Bodenburg",
"4934600", "Ostrau\ Saalkreis",
"499423", "Geiselhöring",
"496352", "Kirchheimbolanden",
"4937207", "Hainichen\ Sachsen",
"492405", "Würselen",
"495131", "Garbsen",
"4933870", "Zollchow\ bei\ Rathenow",
"495072", "Neustadt\-Mandelsloh",
"4935891", "Rothenburg\ OL",
"4933830", "Ziesar",
"496239", "Bobenheim\-Roxheim",
"4936453", "Mellingen",
"497762", "Wehr\ Baden",
"492922", "Werl",
"496063", "Bad\ König",
"498133", "Haimhausen\ Oberbayern",
"4935820", "Zodel",
"498137", "Petershausen",
"492822", "Emmerich",
"497452", "Nagold",
"498586", "Hauzenberg",
"494547", "Gudow\ Lauenburg",
"499683", "Friedenfels",
"494175", "Egestorf\ Nordheide",
"496298", "Möckmühl",
"496842", "Blieskastel",
"499255", "Marktleugast",
"4935828", "Reichenbach\ OL",
"492236", "Wesseling\ Rheinland",
"494543", "Nusse",
"4933976", "Wutike",
"497124", "Trochtelfingen\ Hohenz",
"494342", "Preetz\ Kreis\ Plön",
"4933838", "Päwesin",
"498065", "Tuntenhausen\-Schönau",
"4936336", "Klettenberg",
"496135", "Bodenheim\ Rhein",
"499340", "Königheim\-Brehmen",
"493726", "Flöha",
"494606", "Wanderup",
"4936376", "Straussfurt",
"496706", "Wallhausen\ Nahe",
"4933878", "Nennhausen",
"498555", "Perlesreut",
"492633", "Brohl\-Lützing",
"493445", "Naumburg\ Saale",
"492637", "Weissenthurm",
"499286", "Oberkotzau",
"492393", "Sundern\-Allendorf",
"4934639", "Wallendorf\ Luppe",
"495144", "Wathlingen",
"4939086", "Jävenitz",
"492773", "Haiger",
"494203", "Weyhe\ bei\ Bremen",
"492592", "Selm",
"4933452", "Neulewin",
"499165", "Sugenheim",
"494207", "Oyten",
"496301", "Otterbach\ Pfalz",
"493321", "Nauen\ Brandenburg",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"492777", "Breitscheid\ Hessen",
"4935053", "Glashütte\ Sachsen",
"498705", "Altfraunhofen",
"4933744", "Hohenseefeld",
"495764", "Steyerberg",
"4934975", "Görzig\ Kreis\ Köthen",
"4939344", "Güsen",
"498136", "Markt\ Indersdorf",
"4939349", "Parey\ Elbe",
"496066", "Michelstadt\-Vielbrunn",
"495108", "Gehrden\ Han",
"496475", "Weilmünster\-Wolfenhausen",
"4934347", "Oelzschau\ bei\ Borna",
"496594", "Birresborn",
"4939458", "Heudeber",
"499745", "Wildflecken",
"492565", "Gronau\-Epe",
"493860", "Raben\ Steinfeld",
"496585", "Ralingen",
"499192", "Gräfenberg",
"4938458", "Zehna",
"494435", "Grossenkneten",
"497051", "Calw",
"499426", "Oberschneiding",
"492944", "Rietberg\-Mastholte",
"493332", "Schwedt\/Oder",
"497561", "Leutkirch\ im\ Allgäu",
"492844", "Rheinberg\-Orsoy",
"4938872", "Rehna",
"493537", "Jessen\ Elster",
"4939832", "Wesenberg",
"498092", "Grafing\ bei\ München",
"4934322", "Rosswein",
"496556", "Pronsfeld",
"493533", "Elsterwerda",
"496639", "Ottrau",
"494938", "Hagermarsch",
"494324", "Brokstedt",
"497142", "Bietigheim\-Bissingen",
"494206", "Stuhr\-Heiligenrode",
"494838", "Tellingstedt",
"492776", "Bad\ Endbach\-Hartenrod",
"497935", "Schrozberg",
"497375", "Obermarchtal",
"493904", "Haldensleben",
"496338", "Hornbach\ Pfalz",
"4933701", "Grossbeeren",
"499283", "Rehau",
"492636", "Burgbrohl",
"499655", "Tännesberg",
"499287", "Selb",
"496698", "Schrecksbach",
"497835", "Zell\ am\ Harmersbach",
"496824", "Ottweiler",
"4938301", "Putbus",
"492831", "Geldern",
"498382", "Lindau\ Bodensee",
"4933966", "Dranse",
"494529", "Süsel\-Bujendorf",
"496703", "Wöllstein\ Rheinhessen",
"4938450", "Tarnow\ bei\ Bützow",
"494603", "Havetoft",
"493723", "Hohenstein\-Ernstthal",
"492371", "Iserlohn",
"494607", "Janneby",
"493727", "Mittweida",
"495454", "Hörstel\-Riesenbeck",
"492931", "Arnsberg",
"4934923", "Cobbelsdorf",
"496707", "Windesheim",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"494546", "Mustin\ Lauenburg",
"492233", "Hürth\ Rheinland",
"495471", "Bohmte",
"492237", "Kerpen\ Rheinland\-Türnich",
"4933055", "Kremmen",
"492354", "Meinerzhagen",
"4936464", "Wormstedt",
"498583", "Neureichenau",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"4934324", "Ostrau\ Sachsen",
"4938327", "Elmenhorst\ Vorpom",
"492662", "Hachenburg",
"499843", "Burgbernheim",
"4938874", "Lützow",
"4939327", "Klietz",
"495901", "Fürstenau\ bei\ Bramsche",
"496682", "Tann\ Rhön",
"499847", "Ergersheim",
"497322", "Giengen\ an\ der\ Brenz",
"4937438", "Bad\ Brambach",
"494144", "Himmelpforten",
"499943", "Lam\ Oberpfalz",
"4934426", "Kayna",
"494497", "Barssel\-Harkebrügge",
"4936023", "Horsmar",
"499241", "Pegnitz",
"498803", "Peissenberg",
"495203", "Werther\ Westfalen",
"497527", "Wolfegg",
"498807", "Diessen\ am\ Ammersee",
"495207", "Schloss\ Holte\-Stukenbrock",
"4935792", "Ossling",
"494493", "Friesoythe\-Gehlenberg",
"496408", "Buseck",
"495175", "Lehrte\-Arpke",
"495543", "Staufenberg\ Niedersachsen",
"498724", "Massing",
"4935243", "Weinböhla",
"4939995", "Nossendorf",
"4936961", "Bad\ Liebenstein",
"4936626", "Auma",
"498638", "Waldkraiburg",
"495606", "Zierenberg",
"4933607", "Briesen\ Mark",
"4933742", "Oehna\ Brandenburg",
"4933361", "Joachimsthal",
"498541", "Vilshofen\ Niederbayern",
"4939342", "Gladau",
"494550", "Bühnsdorf",
"496154", "Ober\-Ramstadt",
"494131", "Lüneburg",
"4936462", "Ossmannstedt",
"499188", "Postbauer\-Heng",
"499552", "Burghaslach",
"497733", "Engen\ Hegau",
"499070", "Tapfheim",
"4935206", "Kreischa\ bei\ Dresden",
"4935032", "Langenhennersdorf",
"496422", "Kirchhain",
"499353", "Karlstadt",
"496171", "Oberursel\ Taunus",
"496032", "Bad\ Nauheim",
"497673", "Schönau\ im\ Schwarzwald",
"499234", "Neusorg",
"499357", "Gräfendorf\ Bayern",
"493761", "Werdau\ Sachsen",
"498170", "Strasslach\-Dingharting",
"498252", "Schrobenhausen",
"4936743", "Teichel",
"495852", "Bleckede",
"49331", "Potsdam",
"4939853", "Holzendorf\ bei\ Prenzlau",
"496196", "Bad\ Soden\ am\ Taunus",
"4938853", "Drönnewitz\ bei\ Hagenow",
"494305", "Westensee",
"495952", "Sögel",
"4937343", "Jöhstadt",
"498534", "Tettenweis",
"4937430", "Eichigt",
"496264", "Neudenau",
"496805", "Kleinblittersdorf",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"492295", "Ruppichteroth",
"493925", "Stassfurt",
"493366", "Beeskow",
"4936075", "Dingelstädt\ Eichsfeld",
"492520", "Wadersloh\-Diestedde",
"497308", "Nersingen",
"495529", "Rhumspringe",
"4933331", "Casekow",
"499641", "Grafenwöhr",
"495603", "Gudensberg",
"4938731", "Lübz",
"495607", "Fuldatal",
"496431", "Limburg\ an\ der\ Lahn",
"494454", "Jade",
"496021", "Aschaffenburg",
"4939771", "Ueckermünde",
"499120", "Leinburg",
"499084", "Bissingen\ Schwaben",
"492262", "Wiehl",
"495546", "Scheden",
"494122", "Uetersen",
"497344", "Blaubeuren",
"494471", "Cloppenburg",
"496058", "Gründau",
"496282", "Walldürn",
"494496", "Friesoythe\-Markhausen",
"495378", "Sassenburg\-Platendorf",
"4933433", "Buckow\ Märkische\ Schweiz",
"499461", "Roding",
"4937298", "Oelsnitz\ Erzgebirge",
"492588", "Harsewinkel\-Greffen",
"4939740", "Nechlin",
"492152", "Kempen",
"495324", "Vienenburg",
"499929", "Ruhmannsfelden",
"498238", "Gessertshausen",
"495838", "Gross\ Oesingen",
"498806", "Utting\ am\ Ammersee",
"496568", "Wolsfeld",
"495206", "Bielefeld\-Jöllenbeck",
"4933473", "Zechin",
"4936940", "Oepfershausen",
"499829", "Flachslanden",
"499946", "Hohenwarth\ bei\ Kötzing",
"4937468", "Treuen\ Vogtland",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"492424", "Vettweiss",
"499846", "Ipsheim",
"498020", "Weyarn",
"498742", "Velden\ Vils",
"496444", "Bischoffen",
"497954", "Kirchberg\ an\ der\ Jagst",
"497045", "Oberderdingen",
"499394", "Esselbach",
"497277", "Wörth\-Büchelberg",
"497273", "Hagenbach\ Pfalz",
"499385", "Kolitzheim",
"499634", "Wiesau",
"4933454", "Wölsickendorf\/Wollenberg",
"497854", "Kehl\-Goldscheuer",
"4935475", "Straupitz",
"4936948", "Römhild",
"4934672", "Rossleben",
"497971", "Gaildorf",
"4938756", "Grabow",
"497331", "Geislingen\ an\ der\ Steige",
"499774", "Oberelsbach",
"4934632", "Mücheln\ Geiseltal",
"4939748", "Viereck",
"4935435", "Gollmitz\ bei\ Calau",
"493562", "Forst\ Lausitz",
"4936846", "Suhl\-Dietzhausen",
"499728", "Wülfershausen\ Unterfranken",
"4934203", "Zwenkau",
"496664", "Sinntal\-Sterbfritz",
"492695", "Insul",
"494764", "Gnarrenburg\-Klenkendorf",
"497676", "Feldberg\ Schwarzwald",
"494108", "Rosengarten\ Kreis\ Harburg",
"492335", "Wetter\ Ruhr",
"499356", "Burgsinn",
"492684", "Puderbach\ Westerwald",
"492975", "Schmallenberg\-Oberkirchen",
"495190", "Soltau\-Emmingen",
"497736", "Tengen",
"498652", "Berchtesgaden",
"495025", "Estorf\ Weser",
"495435", "Berge\ bei\ Quakenbrück",
"492041", "Bottrop",
"497641", "Emmendingen",
"499209", "Emtmannsberg",
"4935935", "Kleinwelka",
"496147", "Trebur",
"498226", "Bibertal",
"495826", "Suderburg",
"496575", "Landscheid",
"498304", "Wildpoldsried",
"4937754", "Zwönitz",
"495365", "Wolfsburg\-Neindorf",
"4935975", "Hohnstein",
"495926", "Engden",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"498249", "Ettringen\ Wertach",
"495849", "Waddeweitz",
"496485", "Nentershausen\ Westerwald",
"497084", "Schömberg\ bei\ Neuenbürg",
"4933849", "Wiesenburg\ Mark",
"494535", "Nahe",
"4933844", "Brück\ Brandenburg",
"4933925", "Wustrau\-Altfriesack",
"499344", "Gerchsheim",
"492465", "Inden",
"4933397", "Wandlitz",
"4938732", "Gallin\ bei\ Lübz",
"4939223", "Theessen",
"497461", "Tuttlingen",
"4939772", "Rothemühl",
"4938797", "Karstädt\ Kreis\ Prignitz",
"498623", "Kirchweidach",
"495658", "Wehretal",
"4933332", "Gartz\ Oder",
"499526", "Riedbach",
"497702", "Blumberg\ Baden",
"498509", "Ruderting",
"4938223", "Saal\ Vorpom",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4937605", "Hartenstein\ Sachsen",
"4935322", "Doberlug\-Kirchhain",
"496456", "Haina\ Kloster",
"497946", "Bretzfeld",
"496789", "Heimbach\ Nahe",
"493433", "Borna\ Stadt",
"496003", "Rosbach\ von\ der\ Höhe",
"496007", "Rosbach\-Rodheim",
"493437", "Grimma",
"492645", "Vettelschoss",
"499549", "Lisberg",
"4935894", "Hähnichen",
"495621", "Bad\ Wildungen",
"49671", "Bad\ Kreuznach",
"497394", "Schelklingen",
"499277", "Warmensteinach",
"494153", "Lauenburg\ Elbe",
"49461", "Flensburg",
"499954", "Simbach\ Niederbayern",
"496888", "Lebach\-Steinbach",
"496625", "Niederaula",
"497751", "Waldshut",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"494725", "Helgoland",
"493605", "Leinefelde",
"499854", "Wittelshofen",
"497634", "Sulzburg",
"497385", "Gomadingen",
"495064", "Gross\ Düngen",
"499331", "Ochsenfurt",
"4939083", "Messdorf",
"499971", "Cham",
"494666", "Ladelund",
"497774", "Eigeltingen",
"499871", "Windsbach",
"497728", "Niedereschach",
"496766", "Kisselbach",
"495554", "Moringen",
"494861", "Tönning",
"499676", "Winklarn",
"495481", "Lengerich\ Westfalen",
"498573", "Ering",
"494961", "Papenburg",
"4939037", "Pretzier",
"498145", "Mammendorf",
"497356", "Schemmerhofen",
"4933768", "Prieros",
"495571", "Uslar",
"499736", "Oberthulba",
"492755", "Bad\ Berleburg\-Schwarzenau",
"4936333", "Heringen\ Helme",
"492381", "Hamm\ Westfalen",
"495232", "Lage\ Lippe",
"494263", "Scheessel",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4933933", "Lindow\ Mark",
"499105", "Grosshabersdorf",
"496361", "Rockenhausen",
"494267", "Lauenbrück",
"4936373", "Buttstädt",
"494446", "Bakum\ Kreis\ Vechta",
"498372", "Obergünzburg",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"498649", "Schleching",
"498765", "Bruckberg\ Niederbayern",
"497947", "Forchtenberg",
"496457", "Burgwald\ Eder",
"497843", "Renchen",
"495704", "Petershagen\-Friedewalde",
"494320", "Heidmühlen",
"495168", "Walsrode\-Stellichte",
"496453", "Gemünden\ Wohra",
"497943", "Schöntal\ Jagst",
"4939341", "Redekin",
"499523", "Hofheim\ in\ Unterfranken",
"4933362", "Liepe\ Kreis\ Barnim",
"492505", "Altenberge\ Westfalen",
"4933741", "Niedergörsdorf",
"499527", "Knetzgau",
"4935600", "Döbern\ NL",
"4936962", "Vacha",
"494289", "Kirchtimke",
"496129", "Schlangenbad",
"4935056", "Altenberg\ Sachsen",
"498469", "Freystadt\-Burggriesbach",
"492245", "Much",
"498821", "Garmisch\-Partenkirchen",
"495221", "Herford",
"495923", "Schüttorf",
"496146", "Hochheim\ am\ Main",
"495827", "Unterlüss",
"4938370", "Kröslin",
"498858", "Kochel\-Walchensee",
"495258", "Salzkotten",
"498223", "Ichenhausen",
"495082", "Langlingen",
"495823", "Bienenbüttel",
"499737", "Wartmannsroth",
"4938309", "Trent",
"494443", "Dinklage",
"4933704", "Baruth\ Mark",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"4938378", "Heringsdorf\ Seebad",
"497552", "Pfullendorf",
"494266", "Brockel",
"494447", "Vechta\-Langförden",
"4934926", "Pretzsch\ Elbe",
"4938304", "Garz\ Rügen",
"499733", "Münnerstadt",
"494194", "Sievershütten",
"493964", "Bredenfelde\ bei\ Strasburg",
"497353", "Schwendi",
"4939406", "Harbke",
"499677", "Oberviechtach\-Pullenried",
"4935728", "Uhyst\ Spree",
"49421", "Bremen",
"499673", "Tiefenbach\ Oberpfalz",
"494185", "Marxen\ Auetal",
"497357", "Attenweiler",
"497234", "Tiefenbronn",
"496763", "Kirchberg\ Hunsrück",
"498591", "Obernzell",
"4935608", "Gross\ Ossnig",
"495632", "Willingen\ Upland",
"494663", "Süderlügum",
"4936461", "Bad\ Sulza",
"494667", "Dagebüll",
"498348", "Bidingen",
"495772", "Espelkamp",
"495593", "Bovenden\-Lenglern",
"499276", "Bischofsgrün",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"497062", "Beilstein\ Württemberg",
"4939265", "Löderburg",
"494156", "Talkau",
"495861", "Dannenberg\ Elbe",
"498261", "Mindelheim",
"496150", "Weiterstadt",
"494748", "Stubben\ bei\ Bremerhaven",
"494554", "Wahlstedt",
"496531", "Bernkastel\-Kues",
"496648", "Bad\ Salzschlirf",
"494481", "Hatten\-Sandkrug",
"492602", "Montabaur",
"496272", "Hirschhorn\ Neckar",
"495429", "Melle\-Wellingholzhausen",
"495961", "Haselünne",
"499074", "Höchstädt\ an\ der\ Donau",
"4935246", "Ziegenhain\ Sachsen",
"499438", "Fensterbach",
"4936623", "Berga\ Elster",
"497745", "Jestetten",
"497669", "St\ Märgen",
"4933205", "Michendorf",
"4934321", "Leisnig",
"494232", "Langwedel\ Kreis\ Verden",
"495263", "Barntrup",
"498867", "Rottenbuch\ Oberbayern",
"497192", "Murrhardt",
"4938871", "Mühlen\ Eichsen",
"495446", "Rehden",
"4939831", "Feldberg",
"4933369", "Oderberg",
"497426", "Gosheim",
"496468", "Dautphetal\-Mornshausen",
"49561", "Kassel",
"495153", "Salzhemmendorf",
"4936703", "Gräfenthal",
"4936964", "Dermbach\ Rhön",
"495157", "Emmerthal\-Börry",
"492741", "Betzdorf",
"4936969", "Merkers",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"499561", "Coburg",
"495725", "Lindhorst\ bei\ Stadthagen",
"498151", "Starnberg",
"4936026", "Struth\ bei\ Mühlhausen",
"497449", "Baiersbronn\-Obertal",
"4934423", "Heuckewalde",
"492524", "Ennigerloh",
"4939856", "Beenz\ bei\ Prenzlau",
"499142", "Treuchtlingen",
"4938856", "Pritzier\ bei\ Hagenow",
"4938848", "Vellahn",
"496544", "Rhaunen",
"494140", "Estorf\ Kreis\ Stade",
"496758", "Waldböckelheim",
"499375", "Freudenberg\ Baden",
"499935", "Stephansposching",
"498102", "Höhenkirchen\-Siegertsbrunn",
"493462", "Bad\ Dürrenberg",
"4937346", "Geyer",
"499835", "Ehingen\ Mittelfranken",
"492856", "Hamminkeln\-Brünen",
"496721", "Bingen\ am\ Rhein",
"4935697", "Bagenz",
"497655", "Feldberg\-Altglashütten",
"494621", "Schleswig",
"492651", "Mayen",
"492734", "Freudenberg\ Westfalen",
"494826", "Hohenlockstedt",
"499499", "Painten",
"4935203", "Tharandt",
"496349", "Billigheim\-Ingenheim",
"498042", "Lenggries",
"494365", "Heringsdorf\ Holstein",
"494926", "Krummhörn\-Greetsiel",
"496204", "Viernheim",
"492674", "Bad\ Bertrich",
"492985", "Winterberg\-Niedersfeld",
"494849", "Hooge",
"495535", "Polle",
"496865", "Mettlach\-Orscholz",
"492628", "Rhens",
"4938302", "Sagard",
"493306", "Gransee",
"492994", "Marsberg\-Westheim",
"496326", "Deidesheim",
"4933702", "Wünsdorf",
"497269", "Sulzfeld\ Baden",
"4935877", "Cunewalde",
"4933436", "Prötzel",
"496732", "Wörrstadt",
"4935329", "Dollenchen",
"494632", "Steinbergkirche",
"495663", "Spangenberg",
"4935892", "Horka\ OL",
"497950", "Schnelldorf",
"496440", "Kölschhausen",
"4935324", "Crinitz",
"494392", "Nortorf\ bei\ Neumünster",
"4933476", "Neuhardenberg",
"493379", "Mahlow",
"497427", "Schömberg\ bei\ Balingen",
"498661", "Grabenstätt\ Chiemsee",
"4933334", "Greiffenberg",
"494772", "Oberndorf\ Oste",
"4939779", "Eggesin",
"496672", "Eiterfeld",
"492202", "Bergisch\ Gladbach",
"497033", "Weil\ Der\ Stadt",
"495156", "Coppenbrügge",
"4939774", "Mönkebude",
"497423", "Oberndorf\ am\ Neckar",
"496660", "Steinau\-Marjoss",
"495443", "Lemförde",
"4939861", "Gramzow\ bei\ Prenzlau",
"498325", "Oberstaufen\-Thalkirchdorf",
"4934243", "Bad\ Düben",
"4934783", "Gerbstedt",
"499401", "Neutraubling",
"495266", "Lemgo\-Kirchheide",
"496508", "Hetzerath\ Mosel",
"492542", "Gescher",
"493574", "Lauchhammer",
"493528", "Radeberg",
"499762", "Saal\ an\ der\ Saale",
"495447", "Lembruch",
"492680", "Mündersbach",
"497159", "Renningen",
"495194", "Bispingen",
"49881", "Weilheim\ in\ Oberbayern",
"4937752", "Eibenstock",
"49521", "Bielefeld",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"495185", "Duingen",
"499452", "Langquaid",
"492161", "Mönchengladbach",
"496323", "Edenkoben",
"497683", "Simonswald",
"4934206", "Rötha",
"493303", "Birkenwerder",
"493307", "Zehdenick",
"497255", "Graben\-Neudorf",
"496327", "Neustadt\-Lachen",
"494221", "Delmenhorst",
"496181", "Hanau",
"494923", "Krummhörn\-Pewsum",
"499080", "Harburg\ Schwaben",
"499178", "Abenberg\ Mittelfranken",
"494827", "Wacken",
"496522", "Mettendorf",
"494258", "Schwarme",
"497340", "Neenstetten",
"494823", "Wilster",
"4933451", "Heckelberg",
"494927", "Krummhörn\-Loquard",
"492274", "Elsdorf\ Rheinland",
"492957", "Wünnenberg\-Haaren",
"495320", "Torfhaus",
"493624", "Ohrdruf",
"494704", "Drangstedt",
"492853", "Schermbeck",
"492228", "Remagen\-Rolandseck",
"4934465", "Bad\ Bibra",
"492857", "Rees\-Mehr",
"494168", "Neu\ Wulmstorf\-Elstorf",
"493998", "Demmin",
"492953", "Wünnenberg",
"4938753", "Wöbbelin",
"492251", "Euskirchen",
"498434", "Rennertshofen",
"4936843", "Benshausen",
"497165", "Göppingen\-Hohenstaufen",
"4939753", "Strasburg",
"498024", "Holzkirchen",
"4934295", "Krensitz",
"494865", "Osterhever",
"492774", "Dietzhölztal",
"49355", "Cottbus",
"496849", "Kirkel",
"495485", "Ladbergen",
"494204", "Thedinghausen",
"498141", "Fürstenfeldbruck",
"494965", "Surwold",
"494326", "Wankendorf",
"495494", "Holdorf\ Niedersachsen",
"497459", "Nagold\-Hochdorf",
"495147", "Uetze\-Hänigsen",
"496826", "Bexbach",
"492751", "Bad\ Berleburg",
"492385", "Hamm\-Rhynern",
"492634", "Rengsdorf",
"499101", "Langenzenn",
"492394", "Neuenrade\-Affeln",
"494349", "Dänischenhagen",
"495143", "Winsen\ Aller",
"497123", "Metzingen\ Württemberg",
"4933848", "Raben",
"495456", "Westerkappeln\-Velpe",
"497755", "Weilheim\ Kreis\ Waldshut",
"496621", "Bad\ Hersfeld",
"497381", "Münsingen",
"497127", "Neckartenzlingen",
"494721", "Cuxhaven",
"493601", "Mühlhausen\ Thüringen",
"499975", "Waldmünchen\-Geigant",
"499335", "Aub\ Kreis\ Würzburg",
"494758", "Nordleda",
"494544", "Berkenthin",
"492599", "Ascheberg\-Herbern",
"496658", "Poppenhausen\ Wasserkuppe",
"499875", "Wolframs\-Eschenbach",
"494959", "Dollart",
"4934601", "Teutschenthal",
"4938296", "Rerik\ Ostseebad",
"497465", "Emmingen\-Liptingen",
"4933769", "Töpchin",
"498134", "Odelzhausen",
"494260", "Visselhövede\-Wittorf",
"4939364", "Dolle",
"494859", "Windbergen",
"4933764", "Mittenwalde\ Mark",
"495766", "Rehburg\-Loccum",
"4939296", "Welsleben",
"499262", "Wallenfels",
"496359", "Grünstadt",
"498052", "Aschau\ im\ Chiemgau",
"4938466", "Jürgenshagen",
"494468", "Friedeburg\-Reepsholt",
"49571", "Minden\ Westfalen",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"4939007", "Tangeln",
"495625", "Naumburg\ Hessen",
"492538", "Drensteinfurt\-Rinkerode",
"496596", "Üdersdorf",
"496232", "Speyer",
"497645", "Freiamt",
"498562", "Triftern",
"496571", "Wittlich",
"499424", "Strasskirchen",
"4935386", "Prettin",
"495361", "Wolfsburg",
"494272", "Siedenburg",
"496554", "Waxweiler",
"494531", "Bad\ Oldesloe",
"4934721", "Nienburg\ Saale",
"498367", "Rosshaupten\ Forggensee",
"4939205", "Langenweddingen",
"498363", "Pfronten",
"499270", "Creussen",
"4933831", "Weseram",
"4938205", "Tessin\ bei\ Rostock",
"492461", "Jülich",
"499152", "Hartenstein\ Mittelfranken",
"493541", "Calau",
"492234", "Frechen",
"492357", "Herscheid\ Westfalen",
"492353", "Halver",
"4938300", "Insel\ Hiddensee",
"495820", "Suhlendorf",
"498584", "Breitenberg\ Niederbayern",
"492552", "Steinfurt\-Borghorst",
"496704", "Langenlonsheim",
"494604", "Grossenwiehe",
"493724", "Burgstädt",
"4938353", "Gützkow\ bei\ Greifswald",
"495457", "Hopsten\-Schale",
"495453", "Recke",
"497126", "Burladingen\-Melchingen",
"498038", "Vogtareuth",
"495146", "Wietze",
"496827", "Eppelborn",
"499284", "Schwarzenbach\ an\ der\ Saale",
"4936255", "Goldbach\ bei\ Gotha",
"496258", "Gernsheim",
"496082", "Niederreifenberg",
"499295", "Töpen",
"498389", "Weissensberg",
"493907", "Gardelegen",
"494522", "Plön",
"4939885", "Jakobshagen",
"4938451", "Hoppenrade\ bei\ Güstrow",
"494323", "Bornhöved",
"495129", "Söhlde",
"4939451", "Wasserleben",
"494181", "Buchholz\ in\ der\ Nordheide",
"496221", "Heidelberg",
"494327", "Grossenaspe",
"497940", "Künzelsau",
"4933094", "Löwenberg",
"4934383", "Trebsen\ Mulde",
"498366", "Oy\-Mittelberg",
"492241", "Siegburg",
"495225", "Spenge",
"498825", "Krün",
"4939952", "Grammentin",
"4938842", "Lüttenmark",
"497505", "Fronreute",
"4936084", "Heuthen",
"4935609", "Drachhausen",
"492943", "Erwitte",
"499199", "Kunreuth",
"4935604", "Krieschow",
"492947", "Anröchte",
"49831", "Kempten\ Allgäu",
"499662", "Vilseck",
"492843", "Rheinberg",
"494508", "Krummesse",
"494672", "Langenhorn",
"496593", "Hillesheim\ Eifel",
"498761", "Moosburg\ an\ der\ Isar",
"494892", "Schenefeld\ Mittelholstein",
"494248", "Bassum\-Neubruchhausen",
"4935755", "Ortrand",
"496772", "Nastätten",
"498402", "Münchsmünster",
"4935724", "Lohsa",
"496597", "Jünkerath",
"4938374", "Lassan\ bei\ Wolgast",
"4939827", "Schwarz\ bei\ Neustrelitz",
"497245", "Durmersheim",
"492501", "Münster\-Hiltrup",
"4938308", "Göhren\ Rügen",
"495763", "Uchte",
"4933734", "Felgentreu",
"494732", "Stadland\-Rodenkirchen",
"4938827", "Kalkhorst",
"499442", "Riedenburg",
"496392", "Hauenstein\ Pfalz",
"495767", "Warmsen",
"4933708", "Rangsdorf",
"4938334", "Grammendorf",
"497073", "Ammerbuch",
"4938379", "Benz\ Usedom",
"498533", "Rotthalmünster",
"499636", "Plössberg",
"492655", "Weibern",
"496263", "Neckargerach",
"499396", "Urspringen\ bei\ Lohr",
"496446", "Hohenahr",
"496267", "Fahrenbach\ Baden",
"494361", "Oldenburg\ in\ Holstein",
"498537", "Bad\ Füssing\-Aigen",
"492981", "Winterberg\ Westfalen",
"495648", "Brakel\-Gehrden",
"4939973", "Altkalen",
"495272", "Brakel\ Westfalen",
"496861", "Merzig",
"4936733", "Kaulsdorf",
"4935027", "Weesenstein",
"4933368", "Hohensaaten",
"495531", "Holzminden",
"499776", "Mellrichstadt",
"498332", "Ottobeuren",
"496039", "Karben",
"4936968", "Rossdorf\ Rhön",
"496429", "Schweinsberg\ Hessen",
"4939933", "Vollrathsruhe",
"4933235", "Friesack",
"492686", "Weyerbusch",
"499354", "Rieneck",
"498860", "Bernbeuren",
"4937431", "Mehltheuer\ Vogtland",
"492368", "Oer\-Erkenschwick",
"495859", "Thomasburg",
"498259", "Schiltberg",
"497674", "Todtmoos",
"494766", "Basdahl",
"496666", "Freiensteinau",
"499233", "Arzberg\ Oberfranken",
"497628", "Efringen\-Kirchen",
"499931", "Plattling",
"49661", "Fulda",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"499371", "Miltenberg",
"49471", "Bremerhaven",
"495468", "Bramsche\-Engter",
"497651", "Titisee\-Neustadt",
"499831", "Gunzenhausen",
"496725", "Gau\-Algesheim",
"496157", "Pfungstadt",
"497734", "Gailingen",
"494625", "Jübek",
"497329", "Steinheim\ am\ Albuch",
"492192", "Hückeswagen",
"4936605", "Bad\ Köstritz",
"494456", "Varel\-Altjührden",
"4939397", "Geestgottberg",
"4938332", "Gross\ Bisdorf",
"493583", "Zittau",
"492745", "Brachbach\ Sieg",
"4938372", "Usedom",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"495721", "Stadthagen",
"499565", "Untersiemau",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"498727", "Falkenberg\ Niederbayern",
"497346", "Illerkirchberg",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495544", "Reinhardshagen",
"498723", "Arnstorf",
"4934496", "Nöbdenitz",
"493382", "Lehnin",
"499086", "Fremdingen",
"496535", "Osann\-Monzel",
"497578", "Wald\ Hohenz",
"4935602", "Drebkau",
"4937325", "Niederbobritzsch",
"495865", "Gusborn",
"498265", "Pfaffenhausen\ Schwaben",
"494485", "Elsfleth\-Huntorf",
"495204", "Steinhagen\ Westfalen",
"497524", "Bad\ Waldsee",
"4936082", "Ershausen",
"495965", "Klein\ Berssen",
"495326", "Langelsheim",
"492449", "Blankenheim\ Ahr",
"494494", "Bösel\ Oldenburg",
"497741", "Tiengen\ Hochrhein",
"499844", "Obernzenn",
"4938844", "Gülze",
"4939954", "Stavenhagen\ Reuterstadt",
"492426", "Nörvenich",
"4939959", "Dargun",
"494143", "Drochtersen",
"4939925", "Wredenhagen",
"499944", "Miltach",
"498292", "Dinkelscherben",
"495248", "Langenberg\ Kreis\ Gütersloh",
"495672", "Bad\ Karlshafen",
"4937291", "Augustusburg",
"496663", "Steinau\ an\ der\ Strasse",
"499236", "Nagel",
"492687", "Horhausen\ Westerwald",
"492255", "Euskirchen\-Flamersheim",
"494763", "Gnarrenburg",
"495732", "Löhne",
"494767", "Bremervörde\-Bevern",
"497161", "Göppingen",
"499908", "Schöfweg",
"492683", "Asbach\ Westerwald",
"496667", "Steinau\-Ulmbach",
"49209", "Gelsenkirchen",
"4938738", "Karow\ bei\ Lübz",
"49621", "Mannheim",
"492165", "Jüchen",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"499777", "Ostheim\ von\ der\ Rhön",
"4933338", "Stolpe\/Oder",
"497251", "Bruchsal",
"499773", "Unsleben",
"497420", "Deisslingen",
"496185", "Hammersbach\ Hessen",
"499637", "Falkenberg\ Oberpfalz",
"493364", "Eisenhüttenstadt",
"496443", "Ehringshausen\ Dill",
"497953", "Blaufelden",
"499393", "Rothenfels\ Unterfranken",
"499397", "Wertheim\-Dertingen",
"497274", "Germersheim",
"497957", "Kressberg",
"496447", "Langgöns\-Niederkleen",
"4936427", "Dornburg\ Saale",
"499633", "Mitterteich",
"496266", "Hassmersheim",
"495508", "Gleichen\-Rittmarshausen",
"497228", "Forbach",
"498536", "Kösslarn",
"4937363", "Zöblitz",
"497853", "Kehl\-Bodersweier",
"498321", "Sonthofen",
"494146", "Stade\-Bützfleth",
"499405", "Bad\ Abbach",
"492423", "Langerwehe",
"492427", "Nideggen",
"495522", "Osterode\ am\ Harz",
"497202", "Karlsbad",
"498445", "Gerolsbach",
"492850", "Rees\-Haldern",
"494129", "Haseldorf",
"493491", "Lutherstadt\ Wittenberg",
"495323", "Clausthal\-Zellerfeld",
"495327", "Bad\ Grund\ Harz",
"492269", "Kierspe\-Rönsahl",
"495181", "Alfeld\ Leine",
"499083", "Möttingen",
"499822", "Bechhofen\ an\ der\ Heide",
"494920", "Wirdum",
"498726", "Schönau\ Niederbayern",
"4935263", "Gröditz\ bei\ Riesa",
"497347", "Dietenheim",
"497343", "Buch\ bei\ Illertissen",
"492159", "Meerbusch\-Osterath",
"499922", "Zwiesel",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"499087", "Marktoffingen",
"4939362", "Grieben\ bei\ Tangerhütte",
"4939741", "Jatznick",
"4933762", "Zeuthen",
"497542", "Tettnang",
"498665", "Inzell",
"495604", "Grossalmerode",
"493586", "Neugersdorf\ Sachsen",
"494453", "Zetel",
"4936941", "Wasungen",
"494805", "Schafstedt",
"49391", "Magdeburg",
"494264", "Sottrum\ Kreis\ Rotenburg",
"498551", "Freyung",
"49381", "Rostock",
"495352", "Schöningen",
"493441", "Zeitz",
"497236", "Keltern",
"495553", "Kalefeld",
"497808", "Hohberg\ bei\ Offenburg",
"493866", "Cambs",
"498574", "Wittibreut",
"492452", "Heinsberg\ Rheinland",
"499161", "Neustadt\ an\ der\ Aisch",
"496305", "Hochspeyer",
"493966", "Cölpin",
"495063", "Bad\ Salzdetfurth",
"494171", "Winsen\ Luhe",
"497777", "Sauldorf",
"4937292", "Oederan",
"494422", "Sande\ Kreis\ Friesl",
"497773", "Bodman\-Ludwigshafen",
"499251", "Münchberg",
"493661", "Greiz",
"495067", "Bockenem",
"499420", "Feldkirchen\ Niederbayern",
"4937462", "Rothenkirchen\ Vogtland",
"498379", "Waltenhofen\-Oberdorf",
"499857", "Schopfloch\ Mittelfranken",
"494154", "Trittau",
"4939245", "Loburg",
"497393", "Munderkingen",
"496131", "Mainz",
"499953", "Pilsting",
"498061", "Bad\ Aibling",
"496550", "Irrhausen",
"4938785", "Berge\ bei\ Perleberg",
"499274", "Hollfeld",
"499853", "Wilburgstetten",
"499228", "Thurnau",
"497633", "Staufen\ im\ Breisgau",
"492770", "Eschenburg",
"495135", "Burgwedel\-Fuhrberg",
"496004", "Lich\-Eberstadt",
"495706", "Porta\ Westfalica",
"4935383", "Elster\ Elbe",
"499202", "Waischenfeld",
"4934604", "Niemberg",
"492630", "Mülheim\-Kärlich",
"494408", "Hude\ Oldenburg",
"495942", "Uelsen",
"4934638", "Zöschen",
"4939607", "Kotelow",
"4939742", "Brüssow\ bei\ Pasewalk",
"498624", "Obing",
"4939361", "Lüderitz",
"4934609", "Salzmünde",
"495842", "Schnega",
"498678", "Marktl",
"498502", "Fürstenzell",
"497709", "Wutach",
"497822", "Ettenheim",
"4938293", "Kühlungsborn\ Ostseebad",
"497083", "Bad\ Herrenalb",
"499347", "Wittighausen",
"4933839", "Wusterwitz",
"4938727", "Mestlin",
"4933874", "Stechow\ Brandenburg",
"4936927", "Unterellen",
"4939293", "Dreileben",
"4933834", "Pritzerbe",
"499343", "Lauda\-Königshofen",
"495301", "Lehre\-Essenrode",
"4939727", "Spantekow",
"499542", "Schesslitz",
"492762", "Wenden\ Südsauerland",
"496782", "Birkenfeld\ Nahe",
"498303", "Waltenhofen",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"494682", "Amrum",
"492401", "Baesweiler",
"4935829", "Gersdorf\ bei\ Görlitz",
"497636", "Münstertal\ Schwarzwald",
"492835", "Issum",
"499856", "Dürrwangen",
"495594", "Bovenden\-Reyershausen",
"498752", "Au\ in\ der\ Hallertau",
"492935", "Sundern\-Hachen",
"499956", "Eichendorf\-Aufhausen",
"492375", "Balve",
"49345", "Halle\ Saale",
"4937432", "Pausa\ Vogtland",
"495585", "Herzberg\-Sieber",
"496764", "Rheinböllen",
"494664", "Neukirchen\ bei\ Niebüll",
"495475", "Bohmte\-Hunteburg",
"496108", "Mühlheim\ am\ Main",
"495066", "Sarstedt",
"4938454", "Kritzkow",
"497354", "Erolzheim",
"4939425", "Dingelstedt\ am\ Huy",
"497237", "Neulingen\ Enzkreis",
"494193", "Henstedt\-Ulzburg",
"493963", "Woldegk",
"496048", "Büdingen\-Eckartshausen",
"493867", "Lübstorf",
"4939459", "Hasselfelde",
"4939454", "Elbingerode\ Harz",
"4938425", "Kirchdorf\ Poel",
"499674", "Schönsee",
"493863", "Crivitz",
"499628", "Ursensollen",
"4938459", "Laage",
"493967", "Oertzenhof\ bei\ Strasburg",
"497233", "Niefern\-Öschelbronn",
"495556", "Lindau\ Harz",
"4938356", "Behrenhoff",
"497371", "Riedlingen\ Württemberg",
"494444", "Goldenstedt",
"497931", "Bad\ Mergentheim",
"4934905", "Wörlitz",
"497831", "Hausach",
"499651", "Vohenstrauss",
"4939348", "Klitsche",
"499734", "Burkardroth",
"4933748", "Treuenbrietzen",
"495924", "Bad\ Bentheim\-Gildehaus",
"4936081", "Arenshausen",
"498306", "Ronsberg",
"495978", "Hörstel\-Dreierwalde",
"492051", "Velbert",
"498224", "Offingen\ Donau",
"495824", "Bad\ Bodenteich",
"4935601", "Peitz",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"498642", "Übersee",
"499346", "Grünsfeld",
"499602", "Neustadt\ an\ der\ Waldnaab",
"4938371", "Karlshagen",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"499280", "Selbitz\ Oberfranken",
"499524", "Zeil\ am\ Main",
"4933731", "Trebbin",
"498462", "Berching",
"496471", "Weilburg",
"494282", "Sittensen",
"496122", "Hofheim\-Wallau",
"4938331", "Rakow\ Vorpom",
"499741", "Bad\ Brückenau",
"495703", "Hille",
"492561", "Ahaus",
"497844", "Rheinau",
"495707", "Petershagen\ Weser",
"496581", "Saarburg",
"4939487", "Friedrichsbrunn",
"497055", "Neuweiler\ Kreis\ Calw",
"494431", "Wildeshausen",
"497944", "Kupferzell",
"496454", "Lichtenfels\-Sachsenberg",
"492673", "Ellenz\-Poltersdorf",
"496203", "Ladenburg",
"4933677", "Glienicke\ bei\ Beeskow",
"4936645", "Mühltroff",
"492993", "Marsberg\-Canstein",
"499149", "Weissenburg\-Suffersheim",
"4933637", "Beerfelde",
"492677", "Lutzerath",
"496207", "Wald\-Michelbach",
"493821", "Ribnitz\-Damgarten",
"4939452", "Ilsenburg",
"492733", "Hilchenbach",
"492291", "Waldbröl",
"4933086", "Grieben\ Kreis\ Oberhavel",
"493921", "Burg\ bei\ Magdeburg",
"4938452", "Lalendorf",
"492737", "Netphen\-Deuz",
"499126", "Eckental",
"495682", "Borken\ Hessen",
"494135", "Kirchgellersen",
"492308", "Unna\-Hemmerde",
"499492", "Parsberg",
"497520", "Bodnegg",
"4934445", "Stössen",
"496342", "Schweigen\-Rechtenbach",
"494706", "Schiffdorf",
"498026", "Hausham",
"496175", "Friedrichsdorf\ Taunus",
"497138", "Schwaigern",
"4936736", "Arnsgereuth",
"4939976", "Gross\ Bützin",
"494942", "Südbrookmerland",
"4937434", "Bobenneukirchen",
"4934328", "Hartha\ bei\ Döbeln",
"4937439", "Jocketa",
"493765", "Reichenbach\ Vogtland",
"496543", "Büchenbeuren",
"494298", "Lilienthal",
"494842", "Nordstrand",
"492527", "Lippetal\-Lippborg",
"495032", "Neustadt\ am\ Rübenberge",
"495422", "Melle",
"495171", "Peine",
"499505", "Litzendorf",
"492523", "Wadersloh",
"495154", "Aerzen",
"494239", "Dörverden\-Westen",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"498545", "Hofkirchen\ Bayern",
"4936693", "Crossen\ an\ der\ Elster",
"493591", "Bautzen",
"498177", "Münsing\ Starnberger\ See",
"499350", "Eussenheim\-Hundsbach",
"498205", "Dasing",
"495805", "Oetzen",
"493576", "Weisswasser",
"4938841", "Neuhaus\ Elbe",
"4939951", "Faulenrost",
"495264", "Kalletal",
"494352", "Damp",
"495905", "Beesten",
"4934263", "Hohburg",
"4936207", "Plaue\ Thüringen",
"496852", "Nohfelden",
"499245", "Obertrubach",
"499077", "Bachhagel",
"494553", "Geschendorf",
"497442", "Baiersbronn",
"4934493", "Gössnitz\ Thüringen",
"494557", "Blunk",
"499073", "Gundelfingen\ an\ der\ Donau",
"495196", "Wietzendorf",
"498027", "Dietramszell",
"492691", "Adenau",
"4936873", "Themar",
"492871", "Bocholt",
"498433", "Königsmoos",
"4937464", "Schöneck\ Vogtland",
"492971", "Schmallenberg\-Dorlar",
"4936766", "Schalkau",
"492331", "Hagen\ Westfalen",
"495282", "Schieder\-Schwalenberg",
"498023", "Bayrischzell",
"492273", "Kerpen\-Horrem",
"499868", "Schillingsfürst",
"494703", "Loxstedt\-Donnern",
"493623", "Friedrichroda",
"4937366", "Rübenau",
"495021", "Nienburg\ Weser",
"494707", "Langen\-Neuenwalde",
"492045", "Bottrop\-Kirchhellen",
"492954", "Rüthen\-Oestereiden",
"4939055", "Hörsingen",
"495431", "Quakenbrück",
"4937294", "Grünhainichen",
"494924", "Moormerland\-Oldersum",
"499123", "Lauf\ an\ der\ Pegnitz",
"494338", "Alt\ Duvenstedt",
"497041", "Mühlacker",
"494824", "Krempe",
"492736", "Burbach\ Siegerl",
"499127", "Rosstal\ Mittelfranken",
"499381", "Volkach",
"496324", "Hassloch",
"497684", "Glottertal",
"497335", "Wiesensteig",
"497975", "Untergröningen",
"493304", "Velten",
"496838", "Saarwellingen",
"496206", "Lampertheim",
"492676", "Ulmen",
"493372", "Jüterbog",
"495193", "Schneverdingen",
"499076", "Wittislingen",
"4935266", "Heyda\ bei\ Riesa",
"499465", "Neukirchen\-Balbini",
"494639", "Schafflund",
"4935822", "Hagenwerder",
"495197", "Soltau\-Frielingen",
"497262", "Eppingen",
"494556", "Ahrensbök\-Gnissau",
"4933832", "Rogäsen",
"495444", "Wagenfeld",
"498191", "Landsberg\ am\ Lech",
"493573", "Senftenberg",
"4934722", "Preusslitz",
"4933872", "Hohennauen",
"494779", "Freiburg\ Elbe",
"4939744", "Rothenklempenow",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"496190", "Hattersheim\ am\ Main",
"4936949", "Obermassfeld\-Grimmenthal",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"497478", "Hirrlingen",
"496435", "Wallmerod",
"4936944", "Rentwertshausen",
"497034", "Ehningen",
"4939749", "Grambow\ bei\ Pasewalk",
"498176", "Egling\ bei\ Wolfratshausen",
"497424", "Spaichingen",
"492526", "Sendenhorst",
"4933458", "Falkenberg\ Mark",
"495664", "Morschen",
"494475", "Molbergen",
"499091", "Monheim\ Schwaben",
"497152", "Leonberg\ Württemberg",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;