package WordList::EN::PersonName::PopularBabyNames::US::SSA::1970::MaleTop1000;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-05-04'; # DATE
our $DIST = 'WordLists-EN-PersonName-PopularBabyNames-US-SSA'; # DIST
our $VERSION = '0.002'; # VERSION

use WordList;
our @ISA = qw(WordList);

our $SORT = 'rank';

our %STATS = ("num_words_contains_unicode",0,"num_words_contains_nonword_chars",0,"longest_word_len",11,"num_words_contain_nonword_chars",0,"shortest_word_len",2,"num_words",1000,"num_words_contain_unicode",0,"num_words_contain_whitespace",0,"num_words_contains_whitespace",0,"avg_word_len",5.704); # STATS

1;
# ABSTRACT: Top 1000 most popular names for male babies born in the USA in 1970 (from Social Security Administration)

=pod

=encoding UTF-8

=head1 NAME

WordList::EN::PersonName::PopularBabyNames::US::SSA::1970::MaleTop1000 - Top 1000 most popular names for male babies born in the USA in 1970 (from Social Security Administration)

=head1 VERSION

This document describes version 0.002 of WordList::EN::PersonName::PopularBabyNames::US::SSA::1970::MaleTop1000 (from Perl distribution WordLists-EN-PersonName-PopularBabyNames-US-SSA), released on 2020-05-04.

=head1 SYNOPSIS

 use WordList::EN::PersonName::PopularBabyNames::US::SSA::1970::MaleTop1000;

 my $wl = WordList::EN::PersonName::PopularBabyNames::US::SSA::1970::MaleTop1000->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

Taken from L<https://www.ssa.gov/oact/babynames/>

Sorted by rank (most popular first).

=head1 STATISTICS

 +----------------------------------+-------+
 | key                              | value |
 +----------------------------------+-------+
 | avg_word_len                     | 5.704 |
 | longest_word_len                 | 11    |
 | num_words                        | 1000  |
 | num_words_contain_nonword_chars  | 0     |
 | num_words_contain_unicode        | 0     |
 | num_words_contain_whitespace     | 0     |
 | num_words_contains_nonword_chars | 0     |
 | num_words_contains_unicode       | 0     |
 | num_words_contains_whitespace    | 0     |
 | shortest_word_len                | 2     |
 +----------------------------------+-------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordLists-EN-PersonName-PopularBabyNames-US-SSA>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordLists-PersonName-PopularBabyNames-US-SSA>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordLists-EN-PersonName-PopularBabyNames-US-SSA>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
Michael
James
David
John
Robert
Christopher
William
Brian
Mark
Richard
Jeffrey
Scott
Jason
Kevin
Steven
Joseph
Thomas
Eric
Daniel
Timothy
Charles
Anthony
Paul
Matthew
Kenneth
Gregory
Stephen
Todd
Ronald
Donald
Edward
Andrew
Patrick
Shawn
Gary
Douglas
Sean
Keith
Craig
George
Troy
Jonathan
Larry
Peter
Jerry
Dennis
Bradley
Frank
Raymond
Jeffery
Chad
Aaron
Bryan
Terry
Rodney
Jose
Tony
Russell
Randy
Marc
Roger
Samuel
Chris
Shane
Johnny
Gerald
Carl
Jon
Travis
Jeremy
Adam
Marcus
Phillip
Brent
Darren
Lance
Derek
Billy
Vincent
Wayne
Benjamin
Joel
Lawrence
Corey
Danny
Jimmy
Bobby
Curtis
Walter
Joe
Alan
Philip
Martin
Bruce
Juan
Derrick
Jay
Carlos
Brett
Randall
Erik
Darrell
Willie
Henry
Ricky
Victor
Albert
Roy
Glenn
Dale
Arthur
Dean
Steve
Allen
Frederick
Jeff
Barry
Lee
Jesse
Kyle
Antonio
Harold
Nicholas
Louis
Jamie
Micheal
Christian
Shannon
Jack
Nathan
Brandon
Tyrone
Ronnie
Andre
Kelly
Alexander
Mike
Justin
Ryan
Brad
Dwayne
Reginald
Ernest
Leonard
Luis
Eugene
Ralph
Tommy
Kurt
Joshua
Eddie
Wesley
Marvin
Greg
Glen
Howard
Stanley
Kirk
Mario
Theodore
Daryl
Tracy
Duane
Cory
Maurice
Calvin
Edwin
Jerome
Harry
Manuel
Melvin
Ricardo
Earl
Damon
Clinton
Clifford
Karl
Neil
Mitchell
Darrin
Norman
Warren
Fred
Jody
Jesus
Terrence
Ray
Darin
Wade
Alfred
Alex
Francis
Clarence
Lonnie
Darryl
Roberto
Miguel
Tim
Ruben
Adrian
Geoffrey
Dustin
Don
Jim
Gabriel
Byron
Leon
Franklin
Francisco
Bernard
Rick
Stacy
Terrance
Gilbert
Leroy
Kent
Joey
Nathaniel
Tom
Hector
Jorge
Ian
Alvin
Vernon
Oscar
Dana
Roderick
Raul
Angel
Herbert
Dwight
Bill
Dan
Leslie
Guy
Lewis
Ramon
Gordon
Lloyd
Shaun
Trevor
Toby
Kerry
Andy
Rafael
Ted
Gregg
Fredrick
Jaime
Gene
Marty
Jacob
Donnie
Javier
Kelvin
Casey
Pedro
Ross
Cedric
Bret
Rene
Trent
Perry
Clayton
Mathew
Jimmie
Allan
Clint
Seth
Ron
Bryant
Grant
Charlie
Stuart
Fernando
Johnnie
Eduardo
Heath
Floyd
Nelson
Jackie
Marshall
Tyler
Jared
Matt
Roland
Armando
Jessie
Orlando
Spencer
Alberto
Neal
Marco
Leo
Dexter
Stacey
Lester
Ivan
Noel
Clifton
Robbie
Kenny
Edgar
Nick
Freddie
Timmy
Julio
Felix
Julian
Scot
Dominic
Milton
Erick
Clyde
Colin
Ben
Herman
Bradford
Robin
Garrett
Sam
Frankie
Evan
Terence
Angelo
Alejandro
Carlton
Enrique
Alfredo
Scotty
Cary
Randolph
Arnold
Isaac
Arturo
Brendan
Cecil
Loren
Lorenzo
Randal
Rickey
Zachary
Dewayne
Dion
Omar
Gerard
Harvey
Luke
Sergio
Malcolm
Wendell
Lamont
Blake
Jonathon
Preston
Devin
Brady
Dave
Chester
Salvatore
Sidney
Rex
Cameron
Johnathan
Donovan
Bart
Otis
Max
Hugh
Ken
Darnell
Rudy
Sammy
Demetrius
Curt
Lyle
Garry
Marlon
Clay
Ernesto
Everett
Bryon
Claude
Gerardo
Doug
Ty
Kendall
Jerald
Cesar
Israel
Monte
Kris
Sheldon
Quentin
Stephan
Virgil
Alfonso
Salvador
Vance
Bob
Scottie
Alonzo
Drew
Jayson
Wallace
Lamar
Antoine
Morris
Myron
Jarrod
Mickey
Rodolfo
Darrel
Sherman
Benny
Rusty
Earnest
Clark
Cody
Lynn
Pablo
Teddy
Roman
Pete
Chadwick
Tracey
Marcos
Oliver
Kristopher
Julius
Dallas
Terrell
Abraham
Bennie
Willard
Ira
Daren
Andres
Chuck
Luther
Alton
Dirk
Gilberto
Noah
Stewart
Damian
Morgan
Archie
Darrick
Rob
Blaine
Monty
Carey
Rolando
Stefan
Kim
Jeffry
Dylan
Robby
Tommie
Forrest
Rudolph
Cornelius
Erich
Laurence
Marion
Dominick
Ismael
Edmund
Jamey
Grady
Guillermo
Felipe
Roosevelt
Wilson
Elmer
Stevie
Tod
Abel
Jamal
Derick
Reynaldo
Rory
Shon
Simon
Jordan
Bryce
Deon
Jefferson
Boyd
Jean
Donnell
Ethan
Gustavo
Hans
Leland
Kurtis
Erin
Rogelio
Darius
Thad
Willis
Wilbert
Rodger
Delbert
Rocky
Ashley
Austin
Tomas
Guadalupe
Josh
Reuben
Robb
Vince
Hubert
Denny
Sylvester
Bert
Brant
Horace
Van
Lionel
Lowell
Owen
Dino
Elliott
Dane
Doyle
Emanuel
Eli
Lane
Miles
Will
Vaughn
Dewey
Trenton
Joesph
Shayne
Conrad
Elias
Micah
Ramiro
Kendrick
Nicolas
Thaddeus
Xavier
Dante
Sterling
Kory
Freddy
Saul
Fabian
Jeremiah
Alphonso
Royce
Ernie
Galen
Kraig
Courtney
Anton
Gavin
Rodrick
Louie
Darian
Darwin
Ervin
Reid
Aubrey
Denis
Devon
Reggie
Mack
Pierre
Cleveland
Tad
Leonardo
Jamison
Cornell
Gerry
Brock
Jonas
Rod
Darron
Efrain
Pat
Santiago
Sonny
Aron
Garth
Jess
Buddy
Edmond
Bradly
Ellis
Kip
Brenton
Elijah
Moses
Rufus
Marcel
Blair
Domingo
Marlin
Wilfredo
Homer
Quinton
Nolan
Jarrett
Mason
Winston
Antony
Emilio
Graham
Percy
Shad
Santos
Tyson
Emmett
Reed
Avery
Carlo
Jermaine
Jerrold
Richie
Kristian
Beau
Keven
Michel
Raphael
Benito
Desmond
Garland
Ignacio
Sebastian
Daron
Jan
Joaquin
Randell
Ronny
Hugo
Elbert
Irvin
Quincy
Quinn
Gino
Lucas
Humberto
Lonny
Rhett
Shelby
Chet
Esteban
Judd
Leif
Cliff
Carter
Danial
Phil
Sammie
Hank
Jacques
Jake
Jerrod
Theron
Billie
Judson
Edwardo
Donny
Eddy
Lon
Al
Collin
Kirby
Wilbur
Amos
Carroll
Aric
Barton
Brooks
Jude
Rickie
Woodrow
Deron
Dorian
Elliot
Frederic
Levi
Lincoln
Wilfred
Zane
Jarvis
Russel
Brain
Nicky
Andrea
Colby
Daryle
Rico
Shelton
Solomon
Tobias
Rocco
Errol
Korey
Emmanuel
Harlan
Kennith
Dusty
Eldon
Lisa
Douglass
Damion
Duncan
Davis
Irving
Kelley
Britt
Elvin
Elvis
Merle
Darby
Jefferey
Ward
Coy
Harley
Nickolas
Malik
Adolfo
Carmen
Chance
Ed
Russ
Mikel
Hal
Michelle
Sandy
Alexis
Brendon
Damien
Elton
Emil
Vito
Wyatt
Ari
Kirt
Vicente
Tobin
Torrey
Burton
Harrison
Markus
Paris
Tyron
Jennifer
Kermit
Moises
Taylor
Torrance
Waylon
Jade
Lenny
Noe
Deric
Dwain
Heriberto
Linwood
Baron
Lorne
Bobbie
Gregorio
Lanny
Trey
Kimberly
Len
Toney
Tory
Hunter
Jed
Brook
Carmine
Norris
Agustin
Greggory
August
Bennett
Jackson
Keenan
Ulysses
Adan
Arron
Erwin
Landon
Murray
Rodrigo
Mauricio
Alec
Carson
Loyd
Diego
Lars
Carmelo
Chandler
Junior
Jasen
Jerold
Eloy
Garret
Hiram
Odell
Brice
Cole
Cyrus
Jasper
Jeromy
Mary
Ned
Stan
Chauncey
Giovanni
Grover
Kenton
Marcellus
Barrett
Mitchel
Sanford
Caleb
Armand
Dannie
Fidel
Thurman
Timmothy
Wiley
Charley
Edgardo
Bernardo
Derwin
Jerel
Josef
Che
Federico
Jammie
Otto
Reginal
Cedrick
Chip
Dalton
Enrico
Everette
Alfonzo
Davin
Dereck
Leonel
Rigoberto
Augustine
Garrick
Shanon
Marquis
Myles
Parrish
Roscoe
Bernie
Bronson
Dax
Francesco
Leigh
Ritchie
Tammy
Wes
Denver
Gus
Ivory
Mervin
Orville
Andreas
Barney
Brandt
Donavan
Brien
Cordell
Donn
Lenard
Angela
Ariel
Barron
Broderick
Emory
Giuseppe
Gonzalo
Norberto
Pasquale
Derik
Issac
Raymundo
Boris
Erie
Layne
Norbert
Darcy
Del
Delmar
Kenyatta
Antione
Whitney
Duke
Hollis
Johnie
Nestor
Riley
Terrill
Ali
Andra
Laron
Lindsey
Quintin
Weldon
Aldo
Burt
Claudio
Dario
Alvaro
Anderson
Bruno
Cale
Fletcher
Lesley
Mitch
Adolph
Antwan
Berry
Branden
Brennan
Buck
Curtiss
Johnathon
Lemuel
Michele
Millard
Royal
Corwin
Dedric
Dwaine
Efren
Forest
Jayme
Luigi
Major
Romeo
Shea
Torrence
Vincenzo
Adrain
Isidro
Kelsey
Maxwell
Michale
Patricia
Reese
Reinaldo
Antonia
Emerson
Ezra
Fredric
Jonah
Melissa
Monroe
Stanford
Arnulfo
Darien
Kenyon
Kristin
Marcelino
Octavio
Ollie
Shay
Silas
Titus
Brion
Corbin
Cristopher
Cruz
Derrell
Desi
Emery
Genaro
Jeramy
Timmie
Vinson
Augustus
Bertram
Braden
Christophe
Constantine
Elgin
Elizabeth
Freeman
Jacky
Kenya
Lamonte
Yancy
Dedrick
