package Astro::Coord::ECI::VSOP87D::Neptune;

use 5.008;

use strict;
use warnings;

use base qw{ Astro::Coord::ECI::VSOP87D::_Superior };

our $VERSION = '0.001_02';

sub __model_definition {
    my ( undef, $key ) = @_;
    return {
      body => "Neptune",
      default_model_cutoff => {
        Meeus => {
                   B0   => 17,
                   B1   => 13,
                   B2   => 6,
                   B3   => 4,
                   B4   => 1,
                   L0   => 38,
                   L1   => 18,
                   L2   => 7,
                   L3   => 4,
                   L4   => 1,
                   name => "Meeus",
                   R0   => 32,
                   R1   => 15,
                   R2   => 5,
                   R3   => 1,
                 },
        none  => {
                   B0   => 172,
                   B1   => 82,
                   B2   => 25,
                   B3   => 9,
                   B4   => 1,
                   B5   => 1,
                   L0   => 423,
                   L1   => 183,
                   L2   => 57,
                   L3   => 15,
                   L4   => 2,
                   L5   => 1,
                   name => "none",
                   R0   => 607,
                   R1   => 250,
                   R2   => 72,
                   R3   => 22,
                   R4   => 7,
                 },
      },
      diameter => 49244,
      model => [
        [
          {
            series => "L0",
            terms  => [
                        [5.31188633047, 0, 0],
                        [0.01798475509, 2.9010127305, 38.1330356378],
                        [0.01019727662, 0.4858092366, 1.4844727083],
                        [0.00124531845, 4.83008090682, 36.6485629295],
                        [0.0004206445, 5.41054991607, 2.9689454166],
                        [0.00037714589, 6.09221834946, 35.1640902212],
                        [0.00033784734, 1.24488865578, 76.2660712756],
                        [0.00016482741, 7.729261e-05, 491.5579294568],
                        [9.198582e-05, 4.93747059924, 39.6175083461],
                        [8.994249e-05, 0.27462142569, 175.1660598002],
                        [4.216235e-05, 1.98711914364, 73.297125859],
                        [3.364818e-05, 1.03590121818, 33.6796175129],
                        [2.2848e-05, 4.20606932559, 4.4534181249],
                        [1.433512e-05, 2.78340432711, 74.7815985673],
                        [9.0024e-06, 2.07606702418, 109.9456887885],
                        [7.44996e-06, 3.19032530145, 71.8126531507],
                        [5.06206e-06, 5.74785370252, 114.3991069134],
                        [3.99552e-06, 0.34972342569, 1021.2488945514],
                        [3.45195e-06, 3.46186210169, 41.1019810544],
                        [3.06338e-06, 0.49684039897, 0.5212648618],
                        [2.87322e-06, 4.50523446022, 0.0481841098],
                        [3.23004e-06, 2.24815188609, 32.1951448046],
                        [3.40323e-06, 3.30369900416, 77.7505439839],
                        [2.66605e-06, 4.88932609483, 0.9632078465],
                        [2.27079e-06, 1.79713054538, 453.424893819],
                        [2.44722e-06, 1.24693337933, 9.5612275556],
                        [2.32887e-06, 2.50459795017, 137.0330241624],
                        [2.8217e-06, 2.24565579693, 146.594251718],
                        [2.51941e-06, 5.78166597292, 388.4651552382],
                        [1.5018e-06, 2.99706110414, 5.9378908332],
                        [1.70404e-06, 3.3239063065, 108.4612160802],
                        [1.51401e-06, 2.1915309428, 33.9402499438],
                        [1.48295e-06, 0.85948986145, 111.4301614968],
                        [1.18672e-06, 3.67706204305, 2.4476805548],
                        [1.01821e-06, 5.70539236951, 0.1118745846],
                        [9.7873e-07, 2.80518260528, 8.0767548473],
                        [1.03054e-06, 4.40441222, 70.3281804424],
                        [1.03305e-06, 0.04078966679, 0.2606324309],
                        [1.093e-06, 2.41599378049, 183.2428146475],
                        [7.3938e-07, 1.32805041516, 529.6909650946],
                        [7.7725e-07, 4.16446516424, 4.192785694],
                        [8.6379e-07, 4.22834506045, 490.0734567485],
                        [8.1536e-07, 5.19908046216, 493.0424021651],
                        [7.1503e-07, 5.29530386579, 350.3321196004],
                        [6.4418e-07, 3.5454101605, 168.0525127994],
                        [6.257e-07, 0.15028731465, 182.279606801],
                        [5.8488e-07, 3.50106873945, 145.1097790097],
                        [4.8276e-07, 1.11259925628, 112.9146342051],
                        [4.7229e-07, 4.57373229818, 46.2097904851],
                        [3.9124e-07, 1.6656935605, 213.299095438],
                        [4.7728e-07, 0.12906212461, 484.444382456],
                        [4.6858e-07, 3.01699530327, 498.6714764576],
                        [3.8659e-07, 2.38685706479, 2.9207613068],
                        [4.7046e-07, 4.498446604, 173.6815870919],
                        [4.7565e-07, 2.58404814824, 219.891377577],
                        [4.4714e-07, 5.47302733614, 176.6505325085],
                        [3.2279e-07, 3.4575915122, 30.7106720963],
                        [2.8249e-07, 4.13282446716, 6.592282139],
                        [2.4433e-07, 4.55736848232, 106.9767433719],
                        [2.4661e-07, 3.67822620786, 181.7583419392],
                        [2.4505e-07, 1.55095867965, 7.1135470008],
                        [2.1848e-07, 1.04366818343, 39.0962434843],
                        [1.6936e-07, 6.10896452834, 44.7253177768],
                        [2.2169e-07, 2.74932970271, 256.5399405065],
                        [1.6614e-07, 4.98188930613, 37.611770776],
                        [1.7728e-07, 3.55049134167, 1.3725981237],
                        [1.7347e-07, 2.1406923488, 42.5864537627],
                        [1.4953e-07, 3.36405649131, 98.8999885246],
                        [1.4566e-07, 0.69857991985, 1550.939859646],
                        [1.5676e-07, 6.22010212025, 454.9093665273],
                        [1.3243e-07, 5.61712542227, 68.8437077341],
                        [1.4837e-07, 3.52557245517, 25.6028626656],
                        [1.2757e-07, 0.04509743861, 11.0457002639],
                        [1.1988e-07, 4.81687553351, 24.1183899573],
                        [1.106e-07, 1.78958277553, 7.4223635415],
                        [1.2108e-07, 1.87022663714, 79.2350166922],
                        [1.1698e-07, 0.49005698002, 1.5963472929],
                        [1.0459e-07, 2.38743199893, 381.3516082374],
                        [1.1681e-07, 3.85151357766, 218.4069048687],
                        [8.744e-08, 0.1416856861, 148.0787244263],
                        [9.196e-08, 1.00274090619, 72.0732855816],
                        [1.1343e-07, 0.81432278263, 525.4981794006],
                        [1.0097e-07, 5.03383557061, 601.7642506762],
                        [8.035e-08, 1.7768572301, 0.2124483211],
                        [8.382e-08, 3.07534786987, 1.2720243872],
                        [1.0803e-07, 2.92081211459, 293.188503436],
                        [7.666e-08, 1.52223325105, 115.8835796217],
                        [7.531e-08, 5.37537256533, 5.1078094307],
                        [8.691e-08, 4.74352784364, 143.6253063014],
                        [1.0183e-07, 1.15395455831, 6244.9428143536],
                        [8.283e-08, 0.35956716764, 138.5174968707],
                        [9.544e-08, 4.02452832984, 152.5321425512],
                        [7.274e-08, 4.10937535938, 251.4321310758],
                        [7.465e-08, 1.72131945843, 31.019488637],
                        [6.902e-08, 4.62452068308, 2.7083129857],
                        [7.094e-08, 5.11528393609, 312.1990839626],
                        [7.929e-08, 2.10765101655, 27.0873353739],
                        [6.156e-08, 3.50746507109, 28.5718080822],
                        [7.134e-08, 2.05292376023, 278.2588340188],
                        [8.193e-08, 2.58588219154, 141.2258098564],
                        [5.499e-08, 2.09250039025, 1.6969210294],
                        [5.279e-08, 4.09390686798, 983.1158589136],
                        [6.947e-08, 3.48041784595, 415.2918581812],
                        [5.916e-08, 0.68957324226, 62.2514255951],
                        [5.925e-08, 4.0250459262, 255.0554677982],
                        [4.606e-08, 1.17779101436, 43.2408450685],
                        [5.357e-08, 3.63061058987, 5.4166259714],
                        [5.918e-08, 2.57693824084, 10175.1525105732],
                        [5.482e-08, 3.0797973728, 329.8370663655],
                        [3.956e-08, 5.00418696742, 184.7272873558],
                        [5.408e-08, 3.31313295602, 528.2064923863],
                        [4.767e-08, 4.91981150665, 456.3938392356],
                        [3.77e-08, 1.57277409442, 32.7164096664],
                        [3.924e-08, 4.92763242635, 180.2738692309],
                        [3.707e-08, 4.82965453201, 221.3758502853],
                        [3.802e-08, 4.96279204998, 594.6507036754],
                        [4.014e-08, 1.6390516403, 40.5807161926],
                        [3.061e-08, 0.39713858313, 1.4362885985],
                        [3.261e-08, 4.65478978469, 29.226199388],
                        [3.474e-08, 5.65891305944, 395.578702239],
                        [2.918e-08, 5.91079083895, 1.2238402774],
                        [3.649e-08, 3.88114678609, 494.5268748734],
                        [3.225e-08, 5.57423738665, 1014.1353475506],
                        [2.845e-08, 0.56009386585, 144.1465711632],
                        [2.848e-08, 0.55423029727, 567.8240007324],
                        [3.44e-08, 1.70887250883, 12.5301729722],
                        [3.267e-08, 5.6328779982, 488.5889840402],
                        [3.107e-08, 5.79335949207, 105.4922706636],
                        [2.712e-08, 2.43726364359, 60.7669528868],
                        [3.202e-08, 2.21483496593, 41.0537969446],
                        [3.134e-08, 4.69665220513, 82.8583534146],
                        [3.59e-08, 5.69939670162, 1124.34166877],
                        [2.967e-08, 0.54448940101, 135.5485514541],
                        [3.211e-08, 4.19927605853, 291.7040307277],
                        [2.899e-08, 5.99669788291, 22.633917249],
                        [3.143e-08, 2.93495725805, 31.2319369581],
                        [2.729e-08, 4.62707721219, 5.6290742925],
                        [2.513e-08, 5.60391563025, 19.1224551112],
                        [2.69e-08, 5.32070128202, 2.0057375701],
                        [2.63e-08, 6.00855841124, 37.1698277913],
                        [2.296e-08, 6.06934502789, 451.9404211107],
                        [2.858e-08, 4.88677262419, 258.0244132148],
                        [2.879e-08, 5.12239168488, 38.6543004996],
                        [2.27e-08, 2.08634524182, 30.0562807905],
                        [2.301e-08, 3.35951602914, 1028.3624415522],
                        [3.001e-08, 3.59143817947, 211.8146227297],
                        [2.237e-08, 0.3845555347, 3.6233367224],
                        [2.901e-08, 3.24755614136, 366.485629295],
                        [2.592e-08, 1.36262641469, 35.4247226521],
                        [2.418e-08, 4.93467056526, 47.6942631934],
                        [2.089e-08, 5.79838063413, 4.665866446],
                        [2.586e-08, 2.69392971321, 38.1812197476],
                        [1.913e-08, 5.53560681085, 149.5631971346],
                        [1.971e-08, 6.00790964671, 34.2008823747],
                        [2.586e-08, 6.24984047544, 38.084851528],
                        [2.098e-08, 4.57819744766, 1019.7644218431],
                        [1.869e-08, 3.85907708723, 911.042573332],
                        [2.486e-08, 5.21235809332, 140.001969579],
                        [1.795e-08, 1.68012868451, 1059.3819301892],
                        [2.326e-08, 2.82664069146, 807.9497991134],
                        [1.984e-08, 5.54763522932, 1022.7333672597],
                        [1.919e-08, 5.10717766499, 216.9224321604],
                        [2.004e-08, 5.47811228948, 63.7358983034],
                        [2.021e-08, 4.15631916516, 178.1350052168],
                        [1.76e-08, 6.00927149342, 172.1971143836],
                        [2.14e-08, 2.65037925793, 700.6642392008],
                        [1.988e-08, 3.3585027278, 186.2117600641],
                        [1.956e-08, 5.01527508588, 294.6729761443],
                        [1.966e-08, 4.07957525462, 20.6069278195],
                        [1.637e-08, 0.53823942149, 67.3592350258],
                        [1.54e-08, 2.62327849119, 41.7563723602],
                        [1.81e-08, 5.81430038477, 129.9194771616],
                        [1.776e-08, 4.37047808449, 328.3525936572],
                        [1.46e-08, 2.63664516309, 2.857070832],
                        [1.388e-08, 2.10598045632, 3.9321532631],
                        [1.352e-08, 0.55618245459, 0.6543913058],
                        [1.668e-08, 2.77543377384, 16.1535096946],
                        [1.338e-08, 0.37643611305, 14.0146456805],
                        [1.218e-08, 0.7345643475, 426.598190876],
                        [1.531e-08, 4.54891769768, 526.722019678],
                        [1.61e-08, 3.40993944436, 403.1341922245],
                        [1.361e-08, 4.48227243414, 17.6379824029],
                        [1.589e-08, 5.59323020112, 3302.479391062],
                        [1.132e-08, 5.6452072536, 151.0476698429],
                        [1.357e-08, 4.0639903143, 26.826702943],
                        [1.494e-08, 4.98692049495, 666.723989257],
                        [1.077e-08, 4.3091147025, 0.6331394464],
                        [1.042e-08, 6.02756893581, 106.0135355254],
                        [1.06e-08, 0.74679491358, 487.3651437628],
                        [1.31e-08, 3.7852638093, 386.9806825299],
                        [1.342e-08, 4.52685061062, 563.6312150384],
                        [9.86e-09, 0.00600924269, 81.3738807063],
                        [1.232e-08, 5.17443930901, 331.3215390738],
                        [9.29e-09, 4.51267465978, 38.3936680687],
                        [9.56e-09, 3.5044779102, 64.9597385808],
                        [9.29e-09, 4.43109514438, 37.8724032069],
                        [9.26e-09, 6.09803297747, 4.1446015842],
                        [9.72e-09, 0.59038366513, 8.9068362498],
                        [1.246e-08, 4.69840351226, 389.9496279465],
                        [1.009e-08, 5.98451242784, 142.1408335931],
                        [1.02e-08, 0.832338923, 39.3568759152],
                        [1.013e-08, 0.37845630298, 36.9091953604],
                        [9.4e-09, 2.42688145966, 343.2185725996],
                        [9.74e-09, 5.23958752786, 253.5709950899],
                        [9.64e-09, 5.09748190218, 357.4456666012],
                        [8.35e-09, 1.4556862667, 35.212274331],
                        [1.077e-08, 0.71409061316, 44.070926471],
                        [1.083e-08, 2.27578897621, 6.9010986797],
                        [9.38e-09, 5.03471583911, 69.3649725959],
                        [1.078e-08, 1.20253141912, 35.685355083],
                        [1.027e-08, 0.18243183397, 84.3428261229],
                        [7.64e-09, 4.62720907712, 0.8300814025],
                        [1.013e-08, 0.42234855022, 32.4557772355],
                        [9.39e-09, 4.50445799766, 365.0011565867],
                        [7.56e-09, 0.82872484717, 17.5261078183],
                        [9.16e-09, 3.89409205418, 38.2449102224],
                        [7.36e-09, 4.78125743795, 5.3684418616],
                        [7.62e-09, 0.0189733713, 189.3931538018],
                        [7.38e-09, 2.31770478416, 42.3258213318],
                        [8.6e-09, 4.82440483506, 210.3301500214],
                        [8.88e-09, 3.20360339895, 348.8476468921],
                        [9.16e-09, 5.04967792934, 38.0211610532],
                        [6.38e-09, 0.63267396269, 244.318584075],
                        [6.36e-09, 1.02615137352, 2080.6308247406],
                        [7.74e-09, 5.44432678139, 367.9701020033],
                        [6.44e-09, 1.94044989547, 446.3113468182],
                        [6.31e-09, 4.82928491724, 460.5384408198],
                        [8.55e-09, 3.57592750113, 439.782755154],
                        [6.78e-09, 4.48687912809, 351.8165923087],
                        [7.24e-09, 4.8914160928, 119.5069163441],
                        [5.94e-09, 0.59315717529, 491.036664595],
                        [6.55e-09, 1.99014093, 19.0105805266],
                        [5.8e-09, 2.57189536188, 492.0791943186],
                        [6.94e-09, 0.08328521209, 5.6772584023],
                        [7.33e-09, 5.81485239057, 29.7474642498],
                        [6.66e-09, 3.42196897591, 179.0982130633],
                        [6.78e-09, 0.29428615814, 171.2339065371],
                        [6.35e-09, 2.13805182663, 164.1203595363],
                        [6.23e-09, 5.6145494038, 285.3723810196],
                        [5.29e-09, 1.88063108785, 416.7763308895],
                        [5.29e-09, 5.1325078803, 697.743477894],
                        [5e-09, 1.49548514415, 704.8570248948],
                        [4.87e-09, 4.97772067947, 274.0660483248],
                        [6.66e-09, 6.26456825266, 1474.6737883704],
                        [5.32e-09, 0.25784352716, 477.3308354552],
                        [5.57e-09, 0.71378452161, 80.7194894005],
                        [5.56e-09, 2.60791360513, 418.2608035978],
                        [5.84e-09, 4.29064541383, 16.6747745564],
                        [5.24e-09, 5.4275939228, 290.2195580194],
                        [5.24e-09, 0.29054995359, 247.2393453818],
                        [5.41e-09, 4.36400580938, 815.0633461142],
                        [5.26e-09, 1.66512720297, 97.4155158163],
                        [4.97e-09, 4.72640318293, 401.6497195162],
                        [4.32e-09, 2.98481475894, 100.3844612329],
                        [3.82e-09, 0.28067758468, 8.385571388],
                        [4.24e-09, 6.16774845481, 178.7893965226],
                        [4.84e-09, 0.01535318279, 738.7972748386],
                        [5.18e-09, 4.4891659141, 875.830299001],
                        [5.06e-09, 5.38611121207, 404.6186649328],
                        [3.96e-09, 4.62747640832, 6.1503391543],
                        [4.66e-09, 0.23340415764, 120.9913890524],
                        [4.09e-09, 3.08849480895, 59.2824801785],
                        [4.7e-09, 5.01853200224, 313.6835566709],
                        [4.42e-09, 3.68919475089, 457.8783119439],
                        [3.84e-09, 3.69499925394, 160.9389657986],
                        [3.64e-09, 0.76192181046, 104.0077979553],
                        [4.16e-09, 0.26652109651, 103.0927742186],
                        [4.01e-09, 4.06530055968, 14.6690369863],
                        [4.54e-09, 3.72767803715, 476.4313180835],
                        [4.34e-09, 0.335338022, 984.6003316219],
                        [3.4e-09, 0.99915726716, 31.5407534988],
                        [4.2e-09, 3.65147769268, 20.4950532349],
                        [3.34e-09, 0.35121412008, 1227.4344429886],
                        [3.23e-09, 5.45836731979, 918.1561203328],
                        [4.07e-09, 4.19457842203, 309.7995875176],
                        [3.81e-09, 0.0136485696, 495.4900827199],
                        [3.34e-09, 4.05924071124, 8.3373872782],
                        [3.8e-09, 3.17063415023, 487.6257761937],
                        [3.09e-09, 0.48352303405, 118.0224436358],
                        [3.8e-09, 2.70238752925, 134.1122628556],
                        [3.62e-09, 4.8898581061, 438.2982824457],
                        [3.27e-09, 2.91090790412, 505.7850234584],
                        [3.08e-09, 0.96082817124, 21.1494445407],
                        [2.88e-09, 1.48123872077, 220.4126424388],
                        [2.93e-09, 2.56582281789, 662.531203563],
                        [3.31e-09, 4.37715965811, 180.7951340927],
                        [3.26e-09, 2.46104924164, 169.5369855077],
                        [2.89e-09, 2.63591886391, 55.7710180407],
                        [2.88e-09, 5.02487283285, 1440.7335384266],
                        [3.44e-09, 1.4893099727, 166.5680400911],
                        [2.66e-09, 0.63672427386, 79.1868325824],
                        [2.68e-09, 5.02354540478, 377.4194549743],
                        [3.08e-09, 1.50185265748, 77.2292791221],
                        [3.24e-09, 5.30240189273, 457.617679513],
                        [2.65e-09, 1.087366328, 450.4559484024],
                        [2.64e-09, 0.83337660655, 488.3765357191],
                        [2.9e-09, 1.80003152563, 101.8689339412],
                        [2.62e-09, 2.3039000336, 494.7393231945],
                        [3.25e-09, 5.52669889053, 441.2672278623],
                        [2.54e-09, 0.02963623277, 117.36805233],
                        [3e-09, 0.1743570554, 252.9166037841],
                        [3.15e-09, 5.3488501304, 183.7640795093],
                        [3.13e-09, 5.45945846595, 13.4933808187],
                        [3.06e-09, 5.23085809622, 45.2465826386],
                        [2.37e-09, 0.32676889138, 208.8456773131],
                        [2.63e-09, 2.66670785888, 464.7312265138],
                        [2.34e-09, 1.82700149824, 52175.8062831484],
                        [2.75e-09, 5.04385701142, 156.1554792736],
                        [2.65e-09, 5.64967127743, 326.8681209489],
                        [2.47e-09, 1.74540930625, 65.8747623175],
                        [2.69e-09, 6.09827783249, 1654.0326338646],
                        [2.29e-09, 2.25832077914, 190.665178189],
                        [2.94e-09, 5.45249564193, 206.1855484372],
                        [2.38e-09, 1.55647021369, 79.889407998],
                        [2.3e-09, 6.13158632762, 178.3474535379],
                        [2.74e-09, 4.10829870815, 518.3846323998],
                        [2.25e-09, 3.86300359251, 171.9846660625],
                        [2.28e-09, 2.48511565618, 12566.1516999828],
                        [2.72e-09, 5.61149862463, 148.3393568572],
                        [2.14e-09, 1.45987216039, 522.5774180938],
                        [2.11e-09, 4.04791980901, 6205.3253060075],
                        [2.66e-09, 0.99036038827, 209.106309744],
                        [2.3e-09, 0.5404995153, 532.6117264014],
                        [2.26e-09, 3.8415296162, 283.6272758804],
                        [2.43e-09, 5.32730346969, 485.9288551643],
                        [2.09e-09, 4.35051470487, 536.8045120954],
                        [2.32e-09, 3.01948719112, 10.9338256793],
                        [2.64e-09, 5.70536379124, 490.3340891794],
                        [2.8e-09, 3.99993658196, 674.8007441043],
                        [2.46e-09, 0.37698964335, 157.6399519819],
                        [2.19e-09, 5.67679857772, 52099.5402118728],
                        [2.51e-09, 1.52353965506, 6.8529145699],
                        [2.03e-09, 5.44328656642, 145.6310438715],
                        [2.38e-09, 0.96169723853, 497.1870037493],
                        [2.19e-09, 4.52300776062, 1615.8995982268],
                        [2.75e-09, 2.37619210741, 2118.7638603784],
                        [2.58e-09, 5.1244814878, 608.877797677],
                        [2.6e-09, 3.88543008475, 513.079881013],
                        [1.91e-09, 3.72574595369, 65.2203710117],
                        [2.11e-09, 0.06484535455, 215.4379594521],
                        [2.36e-09, 3.95835282821, 141.4864422873],
                        [1.89e-09, 5.28135043909, 377.1588225434],
                        [2.43e-09, 4.35559878377, 482.9599097477],
                        [2.43e-09, 6.06808644973, 154.0166152595],
                        [2.49e-09, 1.57215637373, 14.2270940016],
                        [2.38e-09, 1.93340192445, 500.1559491659],
                        [2.09e-09, 5.02893682321, 364.559213602],
                        [2.27e-09, 5.7298429854, 1543.8263126452],
                        [2.17e-09, 2.45036922991, 187.1749679106],
                        [1.81e-09, 1.65699502247, 1627.2059309216],
                        [2.14e-09, 1.60213179145, 11.3063326948],
                        [2.03e-09, 0.74638490279, 14.5571624017],
                        [1.92e-09, 3.17719161639, 343.4792050305],
                        [1.77e-09, 1.50027795761, 9.449352971],
                        [1.77e-09, 0.03038098292, 165.6048322446],
                        [1.76e-09, 4.64462444674, 315.1680293792],
                        [2.08e-09, 2.65835778368, 496.0113475817],
                        [1.74e-09, 2.76155855705, 49.1787359017],
                        [1.96e-09, 1.95549714182, 335.7749571987],
                        [2e-09, 4.16839394758, 285.1117485887],
                        [1.99e-09, 0.06168021293, 73.5577582899],
                        [1.88e-09, 6.17288913873, 535.3200393871],
                        [2.15e-09, 1.92414563346, 552.6973893591],
                        [1.66e-09, 5.4903813969, 10135.5350022271],
                        [1.92e-09, 0.9697343412, 304.2342036999],
                        [2.09e-09, 5.34065233845, 13.642138665],
                        [2.03e-09, 5.11234865419, 324.7292569348],
                        [1.77e-09, 3.5068084179, 207.3612046048],
                        [1.74e-09, 1.95010708561, 319.3126309634],
                        [1.87e-09, 5.57685931698, 266.1011680621],
                        [1.81e-09, 1.43525075751, 279.7433067271],
                        [1.65e-09, 4.00537112057, 493.5636670269],
                        [1.91e-09, 1.68313683465, 563.3705826075],
                        [1.73e-09, 3.93200456456, 238.9019581036],
                        [1.61e-09, 5.96143146317, 36.1272980677],
                        [1.94e-09, 2.3766423145, 944.9828232758],
                        [1.65e-09, 0.97421918976, 556.5176680376],
                        [1.89e-09, 1.11279570541, 1127.2624300768],
                        [1.72e-09, 0.75085513952, 267.5856407704],
                        [1.93e-09, 2.12636756833, 20350.3050211464],
                        [1.81e-09, 2.1081456208, 113.8778420516],
                        [1.94e-09, 1.13504964219, 57.255490749],
                        [1.81e-09, 6.23699820519, 355.9611938929],
                        [1.98e-09, 5.68125942959, 6280.1069045748],
                        [1.73e-09, 5.15083799917, 474.9468453752],
                        [1.51e-09, 1.66981962338, 116.5379709275],
                        [1.5e-09, 5.42593657173, 526.9826521089],
                        [2.05e-09, 4.16096717573, 711.4493070338],
                        [1.77e-09, 3.49360697678, 421.2297490144],
                        [1.68e-09, 0.52839230204, 487.1045113319],
                        [1.6e-09, 4.77712663799, 524.0137066923],
                        [1.45e-09, 2.81448128781, 1512.8068240082],
                        [1.46e-09, 4.9957011266, 142.6620984549],
                        [1.88e-09, 0.8210416155, 10210.3166007944],
                        [1.45e-09, 4.96888131586, 1189.3014073508],
                        [1.81e-09, 2.9970479059, 75.7448064138],
                        [1.76e-09, 0.41626373842, 222.8603229936],
                        [1.37e-09, 2.96534226337, 6206.8097787158],
                        [1.38e-09, 1.22260849471, 187.6962327724],
                        [1.28e-09, 2.53394068407, 276.7743613105],
                        [1.3e-09, 3.04810765699, 310.7146112543],
                        [1.22e-09, 3.01323006886, 70.8494453042],
                        [1.11e-09, 0.77449448649, 179.3588454942],
                        [1.41e-09, 0.18423889807, 131.4039498699],
                        [1.26e-09, 5.77648809669, 525.2375469697],
                        [1.24e-09, 2.93225731024, 179.6194779251],
                        [1.11e-09, 6.18471578216, 981.6313862053],
                        [1.41e-09, 2.63342951123, 381.6122406683],
                        [1.1e-09, 5.25053027081, 986.0848043302],
                        [9.6e-10, 3.86591534559, 240.125798381],
                        [1.2e-09, 3.78755085035, 1057.8974574809],
                        [9.3e-10, 4.54014016637, 36.6967470393],
                        [1.09e-09, 1.533275859, 419.7452763061],
                        [9.4e-10, 4.21870300178, 1024.217839968],
                        [1.09e-09, 2.15905156247, 289.5651667136],
                        [1.04e-09, 0.20665642552, 564.8550553158],
                        [8.1e-10, 1.89134135215, 36.6003788197],
                        [8e-10, 4.38832594589, 10137.0194749354],
                        [8e-10, 1.73940577376, 39.5056337615],
                        [8.4e-10, 0.81316746605, 170.7126416753],
                        [9e-10, 0.60145818457, 36.7604375141],
                        [7.4e-10, 4.92511651321, 1549.4553869377],
                        [7.2e-10, 5.06852406179, 249.9476583675],
                      ],
          },
          {
            series => "L1",
            terms  => [
                        [38.37687716731, 0, 0],
                        [0.00016604187, 4.86319129565, 1.4844727083],
                        [0.00015807148, 2.27923488532, 38.1330356378],
                        [3.334701e-05, 3.6819967602, 76.2660712756],
                        [1.30584e-05, 3.67320813491, 2.9689454166],
                        [6.04832e-06, 1.50477747549, 35.1640902212],
                        [1.78623e-06, 3.45318524147, 39.6175083461],
                        [1.06537e-06, 2.45126138334, 4.4534181249],
                        [1.05747e-06, 2.7547932655, 33.6796175129],
                        [7.2684e-07, 5.48724732699, 36.6485629295],
                        [5.7069e-07, 5.2164980497, 0.5212648618],
                        [5.7355e-07, 1.85767603384, 114.3991069134],
                        [3.5368e-07, 4.51676827545, 74.7815985673],
                        [3.2216e-07, 5.9041148968, 77.7505439839],
                        [2.9871e-07, 3.67043294114, 388.4651552382],
                        [2.8866e-07, 5.16877529164, 9.5612275556],
                        [2.8742e-07, 5.16732589024, 2.4476805548],
                        [2.5507e-07, 5.24526281928, 168.0525127994],
                        [2.4869e-07, 4.7319306781, 182.279606801],
                        [2.0205e-07, 5.78945415677, 1021.2488945514],
                        [1.9022e-07, 1.82981144269, 484.444382456],
                        [1.8661e-07, 1.31606255521, 498.6714764576],
                        [1.5063e-07, 4.9500389376, 137.0330241624],
                        [1.5094e-07, 3.9870525494, 32.1951448046],
                        [1.072e-07, 2.44148149225, 4.192785694],
                        [1.1725e-07, 4.89255650674, 71.8126531507],
                        [9.581e-08, 1.23188039594, 5.9378908332],
                        [9.606e-08, 1.88534821556, 41.1019810544],
                        [8.968e-08, 0.01758559103, 8.0767548473],
                        [9.882e-08, 6.08165628679, 7.1135470008],
                        [7.632e-08, 5.51307048241, 73.297125859],
                        [6.992e-08, 0.61688864282, 2.9207613068],
                        [5.543e-08, 2.24141557794, 46.2097904851],
                        [4.845e-08, 3.7105582375, 112.9146342051],
                        [3.7e-08, 5.25713252333, 111.4301614968],
                        [3.233e-08, 6.10303038418, 70.3281804424],
                        [2.939e-08, 4.86520586648, 98.8999885246],
                        [2.403e-08, 2.90637675099, 601.7642506762],
                        [2.398e-08, 1.04343654629, 6.592282139],
                        [2.784e-08, 4.95821114677, 108.4612160802],
                        [2.894e-08, 4.20148844767, 381.3516082374],
                        [2.111e-08, 5.93089610785, 25.6028626656],
                        [2.075e-08, 5.20632201951, 30.7106720963],
                        [2.126e-08, 0.54976393136, 41.0537969446],
                        [2.235e-08, 2.38045158073, 453.424893819],
                        [1.859e-08, 0.89409373259, 24.1183899573],
                        [2.018e-08, 3.42245274178, 31.019488637],
                        [1.7e-08, 3.91715254287, 11.0457002639],
                        [1.776e-08, 3.86571077241, 395.578702239],
                        [1.644e-08, 0.15855999051, 152.5321425512],
                        [1.646e-08, 3.34591387314, 44.7253177768],
                        [1.876e-08, 2.59784179105, 33.9402499438],
                        [1.614e-08, 0.42137145545, 175.1660598002],
                        [1.468e-08, 6.12983933526, 1550.939859646],
                        [1.408e-08, 6.13722948564, 490.0734567485],
                        [1.207e-08, 0.59525736062, 312.1990839626],
                        [1.336e-08, 3.28611928206, 493.0424021651],
                        [1.176e-08, 5.87266726996, 5.4166259714],
                        [1.517e-08, 3.12967210501, 491.5579294568],
                        [1.053e-08, 4.6037551683, 79.2350166922],
                        [1.037e-08, 4.89007314395, 1.2720243872],
                        [1.034e-08, 5.93741289103, 32.7164096664],
                        [1.038e-08, 1.13470380744, 1014.1353475506],
                        [1.002e-08, 1.85850922283, 5.1078094307],
                        [9.83e-09, 0.05345050384, 7.4223635415],
                        [9.98e-09, 1.73689827444, 1028.3624415522],
                        [1.193e-08, 4.63176675581, 60.7669528868],
                        [9.4e-09, 3.09103721222, 62.2514255951],
                        [9.94e-09, 4.11489180313, 4.665866446],
                        [8.9e-09, 0.87049255398, 31.2319369581],
                        [8.52e-09, 5.35508394316, 144.1465711632],
                        [9.22e-09, 5.12373360511, 145.1097790097],
                        [7.89e-09, 0.37496785039, 26.826702943],
                        [8.28e-09, 4.060351946, 115.8835796217],
                        [7.11e-09, 3.14189997439, 278.2588340188],
                        [7.27e-09, 1.39718382835, 213.299095438],
                        [7.81e-09, 0.10946327923, 173.6815870919],
                        [7.93e-09, 6.13086312116, 567.8240007324],
                        [6.69e-09, 4.50554989443, 27.0873353739],
                        [8.25e-09, 1.35568908148, 129.9194771616],
                        [7.38e-09, 3.5676601896, 176.6505325085],
                        [7.14e-09, 6.24797992301, 106.9767433719],
                        [6.54e-09, 1.13177751192, 68.8437077341],
                        [6.24e-09, 0.01567750666, 28.5718080822],
                        [6.08e-09, 4.60180625368, 189.3931538018],
                        [5.95e-09, 0.00857468445, 42.5864537627],
                        [5.3e-09, 5.61201247153, 12.5301729722],
                        [5.21e-09, 1.02371768017, 415.2918581812],
                        [6.39e-09, 0.68930265745, 529.6909650946],
                        [5.26e-09, 3.02138731705, 5.6290742925],
                        [4.56e-09, 4.44331571392, 43.2408450685],
                        [5.24e-09, 3.43316448349, 38.6543004996],
                        [4.36e-09, 2.41630174435, 82.8583534146],
                        [4.24e-09, 1.95736011325, 477.3308354552],
                        [4.43e-09, 3.39350946329, 357.4456666012],
                        [3.83e-09, 1.90232196422, 22.633917249],
                        [4.79e-09, 5.55141744216, 37.611770776],
                        [4.62e-09, 3.80436154644, 343.2185725996],
                        [3.84e-09, 5.60377408953, 594.6507036754],
                        [3.69e-09, 4.45577410338, 6.9010986797],
                        [3.58e-09, 3.69126616347, 3.9321532631],
                        [3.52e-09, 3.10952926034, 135.5485514541],
                        [3.68e-09, 3.53577440355, 40.5807161926],
                        [4.24e-09, 5.27159202779, 181.7583419392],
                        [3.61e-09, 0.29018303419, 72.0732855816],
                        [3.9e-09, 5.49512204296, 350.3321196004],
                        [3.78e-09, 2.74122401337, 488.3765357191],
                        [3.72e-09, 0.39980033572, 494.7393231945],
                        [3.53e-09, 1.10614174053, 20.6069278195],
                        [2.96e-09, 0.86351261285, 149.5631971346],
                        [3.07e-09, 5.39420288683, 160.9389657986],
                        [3.95e-09, 1.93577214824, 10137.0194749354],
                        [2.88e-09, 2.28755739359, 47.6942631934],
                        [2.95e-09, 2.4873753724, 19.1224551112],
                        [2.9e-09, 0.18636083306, 143.6253063014],
                        [2.66e-09, 3.09977370364, 69.3649725959],
                        [2.66e-09, 1.21002824826, 505.7850234584],
                        [2.52e-09, 3.12745026026, 460.5384408198],
                        [3.28e-09, 0.50849285663, 6206.8097787158],
                        [2.57e-09, 3.64119914774, 446.3113468182],
                        [2.39e-09, 5.54080102299, 911.042573332],
                        [2.65e-09, 0.62702473701, 253.5709950899],
                        [2.87e-09, 2.44403568436, 16.6747745564],
                        [2.31e-09, 2.47026250085, 454.9093665273],
                        [2.3e-09, 3.24571542922, 1066.49547719],
                        [2.82e-09, 1.48595620175, 983.1158589136],
                        [2.12e-09, 5.41931177641, 64.9597385808],
                        [2.13e-09, 1.64175339637, 1089.129394439],
                        [2.38e-09, 2.69801319489, 882.9438460018],
                        [2.1e-09, 4.53976756699, 1093.322180133],
                        [2.2e-09, 2.30038816175, 1052.2683831884],
                        [2.56e-09, 0.4207359846, 23.9059416362],
                        [2.16e-09, 5.4422591887, 39.0962434843],
                        [2.01e-09, 2.58746514605, 119.5069163441],
                        [2.24e-09, 4.43751392203, 639.897286314],
                        [1.86e-09, 2.50651218075, 487.3651437628],
                        [1.89e-09, 4.05785534221, 120.9913890524],
                        [1.84e-09, 2.24245977278, 815.0633461142],
                        [2.02e-09, 3.43517732411, 45.2465826386],
                        [1.75e-09, 4.49165234532, 171.2339065371],
                        [1.71e-09, 5.50633466316, 179.0982130633],
                        [2e-09, 6.12663205401, 14.2270940016],
                        [1.73e-09, 2.61090344107, 389.9496279465],
                        [1.67e-09, 3.94754384833, 77.2292791221],
                        [1.66e-09, 3.41009128748, 81.3738807063],
                        [1.63e-09, 3.88198848446, 556.5176680376],
                        [1.64e-09, 1.49614763046, 63.7358983034],
                        [1.76e-09, 3.86129425367, 148.3393568572],
                        [1.61e-09, 2.22215642318, 574.9375477332],
                        [1.71e-09, 0.66899426684, 179.3106613844],
                        [1.61e-09, 1.21480182441, 1024.4302882891],
                        [1.55e-09, 3.25842414799, 10251.4185818488],
                        [1.83e-09, 5.45168150656, 218.4069048687],
                        [1.52e-09, 3.35145509017, 285.3723810196],
                        [1.52e-09, 0.42398786475, 274.0660483248],
                        [1.46e-09, 5.70714579127, 419.4846438752],
                        [1.56e-09, 0.6432152487, 1029.8469142605],
                        [1.47e-09, 4.3095893074, 157.6399519819],
                        [1.47e-09, 1.8068917751, 377.4194549743],
                        [1.4e-09, 1.49826604627, 386.9806825299],
                        [1.37e-09, 2.14480243915, 563.6312150384],
                        [1.27e-09, 3.9872659971, 84.3428261229],
                        [1.34e-09, 4.16039455079, 169.5369855077],
                        [1.21e-09, 0.29300927469, 206.1855484372],
                        [1.29e-09, 2.6762505701, 180.7951340927],
                        [1.34e-09, 3.18868986487, 166.5680400911],
                        [1.35e-09, 5.0751756178, 426.598190876],
                        [1.36e-09, 1.8167245174, 151.0476698429],
                        [1.29e-09, 3.64795525602, 183.7640795093],
                        [1.16e-09, 6.06435563172, 220.4126424388],
                        [1.23e-09, 4.46641157829, 1022.7333672597],
                        [1.12e-09, 4.34485256988, 138.5174968707],
                        [1.16e-09, 5.58946529961, 35.685355083],
                        [1.08e-09, 1.03796693383, 488.5889840402],
                        [1.08e-09, 2.1037848588, 494.5268748734],
                        [1.06e-09, 0.87068583107, 1059.3819301892],
                        [9.7e-10, 0.74486741478, 485.9288551643],
                        [9.5e-10, 5.54259914856, 497.1870037493],
                        [8.5e-10, 3.16062141266, 522.5774180938],
                        [9.7e-10, 6.05634803604, 482.9599097477],
                        [9.5e-10, 0.2311185273, 500.1559491659],
                        [8.4e-10, 2.64687252518, 536.8045120954],
                        [7.4e-10, 3.90678924318, 1019.7644218431],
                      ],
          },
          {
            series => "L2",
            terms  => [
                        [0.00053892649, 0, 0],
                        [2.81251e-06, 1.19084538887, 38.1330356378],
                        [2.95693e-06, 1.85520292248, 1.4844727083],
                        [2.7019e-06, 5.72143228148, 76.2660712756],
                        [2.3023e-07, 1.21035596452, 2.9689454166],
                        [7.333e-08, 0.5403330683, 2.4476805548],
                        [9.057e-08, 4.42544992035, 35.1640902212],
                        [5.223e-08, 0.67427930044, 168.0525127994],
                        [5.201e-08, 3.02338671812, 182.279606801],
                        [4.288e-08, 3.84351844003, 114.3991069134],
                        [3.925e-08, 3.53214557374, 484.444382456],
                        [3.741e-08, 5.90238217874, 498.6714764576],
                        [2.966e-08, 0.31002477611, 4.4534181249],
                        [3.415e-08, 0.55971639038, 74.7815985673],
                        [3.255e-08, 1.84921884906, 175.1660598002],
                        [2.157e-08, 1.89135758747, 388.4651552382],
                        [2.211e-08, 4.3799709224, 7.1135470008],
                        [1.847e-08, 3.48574435762, 9.5612275556],
                        [2.451e-08, 4.68586840176, 491.5579294568],
                        [1.844e-08, 5.12281562096, 33.6796175129],
                        [2.204e-08, 1.69321574906, 77.7505439839],
                        [1.652e-08, 2.55859494053, 36.6485629295],
                        [1.309e-08, 4.52400192922, 1021.2488945514],
                        [1.124e-08, 0.38710602242, 137.0330241624],
                        [6.64e-09, 0.88101734307, 4.192785694],
                        [4.97e-09, 2.24615784762, 395.578702239],
                        [5.12e-09, 6.22609200672, 381.3516082374],
                        [5.82e-09, 5.25716719826, 31.019488637],
                        [4.46e-09, 0.36647221351, 98.8999885246],
                        [3.83e-09, 5.48585528762, 5.9378908332],
                        [3.75e-09, 4.61250246774, 8.0767548473],
                        [3.54e-09, 1.30783918287, 601.7642506762],
                        [2.59e-09, 5.66033623678, 112.9146342051],
                        [2.47e-09, 2.89695614593, 189.3931538018],
                        [2.45e-09, 4.26572913391, 220.4126424388],
                        [2e-09, 0.52604535784, 64.9597385808],
                        [1.91e-09, 4.88786653062, 39.6175083461],
                        [2.33e-09, 3.16423779113, 41.1019810544],
                        [2.48e-09, 5.85877831382, 1059.3819301892],
                        [1.94e-09, 2.37949641473, 73.297125859],
                        [2.27e-09, 0.20028518978, 60.7669528868],
                        [1.84e-09, 3.01962045713, 1014.1353475506],
                        [1.9e-09, 5.57500985081, 343.2185725996],
                        [1.72e-09, 3.66036463613, 477.3308354552],
                        [1.72e-09, 0.59550457102, 46.2097904851],
                        [1.82e-09, 1.92429384025, 183.7640795093],
                        [1.71e-09, 1.61368476689, 357.4456666012],
                        [1.73e-09, 6.23717119485, 493.0424021651],
                        [2.17e-09, 1.46218158211, 71.8126531507],
                        [1.78e-09, 0.34928799031, 1028.3624415522],
                        [1.69e-09, 4.91086673212, 166.5680400911],
                        [1.57e-09, 5.89200571154, 169.5369855077],
                        [1.82e-09, 2.33457064554, 152.5321425512],
                        [1.51e-09, 3.81621340568, 146.594251718],
                        [1.36e-09, 2.75150881988, 144.1465711632],
                        [1.04e-09, 6.03262825314, 529.6909650946],
                        [7.6e-10, 0.20932812381, 453.424893819],
                      ],
          },
          {
            series => "L3",
            terms  => [
                        [3.1254e-07, 0, 0],
                        [1.2461e-07, 6.04431418812, 1.4844727083],
                        [1.4541e-07, 1.35337075856, 76.2660712756],
                        [1.1547e-07, 6.11257808366, 38.1330356378],
                        [1.351e-08, 4.93951495175, 2.9689454166],
                        [7.41e-09, 2.35936954597, 168.0525127994],
                        [7.15e-09, 1.27409542804, 182.279606801],
                        [5.37e-09, 5.23632185196, 484.444382456],
                        [5.23e-09, 4.16769839601, 498.6714764576],
                        [6.64e-09, 0.55871435877, 31.019488637],
                        [3.01e-09, 2.69253200796, 7.1135470008],
                        [1.94e-09, 2.05904114139, 137.0330241624],
                        [2.06e-09, 2.51012178002, 74.7815985673],
                        [1.6e-09, 5.63111039032, 114.3991069134],
                        [1.49e-09, 3.09327713923, 35.1640902212],
                      ],
          },
          {
            series => "L4",
            terms  => [
                        [1.13998e-06, 3.14159265359, 0],
                        [6.05e-09, 3.18211885677, 76.2660712756],
                      ],
          },
          { series => "L5", terms => [[8.74e-09, 3.14159265359, 0]] },
        ],
        [
          {
            series => "B0",
            terms  => [
                        [0.03088622933, 1.44104372626, 38.1330356378],
                        [0.00027780087, 5.91271882843, 76.2660712756],
                        [0.00027623609, 0, 0],
                        [0.0001535549, 2.52123799481, 36.6485629295],
                        [0.00015448133, 3.50877080888, 39.6175083461],
                        [1.999919e-05, 1.50998669505, 74.7815985673],
                        [1.96754e-05, 4.37778195768, 1.4844727083],
                        [1.015137e-05, 3.21561035875, 35.1640902212],
                        [6.05767e-06, 2.80246601405, 73.297125859],
                        [5.94878e-06, 2.12892708114, 41.1019810544],
                        [5.88805e-06, 3.18655882497, 2.9689454166],
                        [4.0183e-06, 4.16883287237, 114.3991069134],
                        [2.54333e-06, 3.27120499438, 453.424893819],
                        [2.61647e-06, 3.76722704749, 213.299095438],
                        [2.79964e-06, 1.68165309699, 77.7505439839],
                        [2.0559e-06, 4.25652348864, 529.6909650946],
                        [1.40455e-06, 3.52969556376, 137.0330241624],
                        [9.853e-07, 4.16774829927, 33.6796175129],
                        [5.1257e-07, 1.95121181203, 4.4534181249],
                        [6.7971e-07, 4.66970781659, 71.8126531507],
                        [4.1931e-07, 5.41783694467, 111.4301614968],
                        [4.1822e-07, 5.94832001477, 112.9146342051],
                        [3.0637e-07, 0.93620571932, 42.5864537627],
                        [1.1084e-07, 5.88898793049, 108.4612160802],
                        [9.62e-08, 0.03944255108, 70.3281804424],
                        [9.664e-08, 0.22455797403, 79.2350166922],
                        [9.728e-08, 5.30069593532, 32.1951448046],
                        [7.386e-08, 3.00684933642, 426.598190876],
                        [7.087e-08, 0.12535040656, 109.9456887885],
                        [6.021e-08, 6.20514068152, 115.8835796217],
                        [6.169e-08, 3.62098109648, 983.1158589136],
                        [4.777e-08, 0.75210194972, 5.9378908332],
                        [6.391e-08, 5.8464610106, 148.0787244263],
                        [6.251e-08, 2.41678769385, 152.5321425512],
                        [4.539e-08, 5.581820987, 175.1660598002],
                        [5.006e-08, 4.60815664851, 1059.3819301892],
                        [4.289e-08, 4.19647392821, 47.6942631934],
                        [5.795e-08, 5.07516716087, 415.2918581812],
                        [4.749e-08, 2.51605725604, 37.611770776],
                        [4.119e-08, 1.72779509865, 28.5718080822],
                        [4.076e-08, 6.00252170354, 145.1097790097],
                        [4.429e-08, 5.65995321659, 98.8999885246],
                        [3.95e-08, 2.74104636753, 350.3321196004],
                        [4.091e-08, 1.61787956945, 39.0962434843],
                        [4.131e-08, 4.40682554313, 37.1698277913],
                        [4.71e-08, 3.50929350767, 38.6543004996],
                        [4.44e-08, 4.78977105547, 38.084851528],
                        [4.433e-08, 1.23386935925, 38.1812197476],
                        [3.762e-08, 4.83940791709, 491.5579294568],
                        [2.606e-08, 1.20956732792, 451.9404211107],
                        [2.537e-08, 2.18628045751, 454.9093665273],
                        [2.328e-08, 5.19779918719, 72.0732855816],
                        [2.502e-08, 0.8598790435, 106.9767433719],
                        [2.342e-08, 0.81387240947, 4.192785694],
                        [1.981e-08, 0.46617960831, 184.7272873558],
                        [1.963e-08, 6.01909114576, 44.070926471],
                        [2.18e-08, 0.70099749844, 206.1855484372],
                        [1.811e-08, 0.40456996647, 40.5807161926],
                        [1.814e-08, 3.64699555185, 220.4126424388],
                        [1.705e-08, 6.13551142362, 181.7583419392],
                        [1.855e-08, 5.61635630213, 35.685355083],
                        [1.595e-08, 2.97147156093, 37.8724032069],
                        [1.785e-08, 2.42154818096, 388.4651552382],
                        [1.595e-08, 3.05266110075, 38.3936680687],
                        [1.437e-08, 1.48678704605, 135.5485514541],
                        [1.387e-08, 2.46149266117, 138.5174968707],
                        [1.366e-08, 1.52026779665, 68.8437077341],
                        [1.575e-08, 3.58964541604, 38.0211610532],
                        [1.297e-08, 5.06156596196, 33.9402499438],
                        [1.487e-08, 0.20211121607, 30.0562807905],
                        [1.504e-08, 5.80298577327, 46.2097904851],
                        [1.192e-08, 0.87275514483, 42.3258213318],
                        [1.569e-08, 2.43405967107, 38.2449102224],
                        [1.207e-08, 1.84658687853, 251.4321310758],
                        [1.015e-08, 0.53439848924, 129.9194771616],
                        [9.99e-09, 2.47463873948, 312.1990839626],
                        [9.9e-09, 3.41514319052, 144.1465711632],
                        [9.63e-09, 4.31733242907, 151.0476698429],
                        [1.02e-08, 0.98226686775, 143.6253063014],
                        [9.41e-09, 1.02993053785, 221.3758502853],
                        [9.38e-09, 2.43648356625, 567.8240007324],
                        [1.111e-08, 0.65175024456, 146.594251718],
                        [7.77e-09, 0.00175975222, 218.4069048687],
                        [8.95e-09, 0.2512386962, 30.7106720963],
                        [7.95e-09, 5.80519741659, 149.5631971346],
                        [7.37e-09, 3.40060492866, 446.3113468182],
                        [7.19e-09, 1.43795191278, 8.0767548473],
                        [7.2e-09, 0.0065100755, 460.5384408198],
                        [7.66e-09, 4.03399506246, 522.5774180938],
                        [6.66e-09, 1.39457824982, 84.3428261229],
                        [5.84e-09, 1.01405548136, 536.8045120954],
                        [5.96e-09, 0.62390100715, 35.212274331],
                        [5.98e-09, 5.39946724188, 41.0537969446],
                        [4.75e-09, 5.80072248338, 7.4223635415],
                        [5.1e-09, 1.3447857974, 258.0244132148],
                        [4.58e-09, 5.25325523118, 80.7194894005],
                        [4.21e-09, 3.24496387889, 416.7763308895],
                        [4.46e-09, 1.19167306357, 180.2738692309],
                        [4.71e-09, 0.92632922375, 44.7253177768],
                        [3.87e-09, 1.68488418788, 183.2428146475],
                        [3.75e-09, 0.15223869165, 255.0554677982],
                        [3.54e-09, 4.21526988674, 0.9632078465],
                        [3.79e-09, 2.16947487177, 105.4922706636],
                        [3.41e-09, 4.7919405168, 110.2063212194],
                        [4.27e-09, 5.15774894584, 31.5407534988],
                        [3.02e-09, 3.4570630628, 100.3844612329],
                        [2.98e-09, 2.26790695187, 639.897286314],
                        [2.79e-09, 0.25689162963, 39.5056337615],
                        [3.2e-09, 3.58085653166, 45.2465826386],
                        [2.69e-09, 5.72024180826, 36.7604375141],
                        [2.47e-09, 0.61040148804, 186.2117600641],
                        [2.45e-09, 0.64173616273, 419.4846438752],
                        [2.35e-09, 0.73189197665, 10213.285546211],
                        [2.32e-09, 0.37399822852, 490.0734567485],
                        [2.3e-09, 5.76570492457, 12.5301729722],
                        [2.4e-09, 4.13447692727, 0.5212648618],
                        [2.79e-09, 1.62614865256, 294.6729761443],
                        [2.38e-09, 2.1852891655, 219.891377577],
                        [2.62e-09, 3.08384135298, 6.592282139],
                        [2.17e-09, 2.93214905312, 27.0873353739],
                        [2.17e-09, 4.69210602828, 406.1031376411],
                        [2.19e-09, 1.3521271256, 216.9224321604],
                        [2e-09, 2.35215465744, 605.9570363702],
                        [2.32e-09, 3.92583619589, 1512.8068240082],
                        [2.23e-09, 5.52392277606, 187.6962327724],
                        [1.9e-09, 0.29169556516, 291.7040307277],
                        [2.36e-09, 3.12464145036, 563.6312150384],
                        [1.93e-09, 0.53675942386, 60.7669528868],
                        [2.15e-09, 3.78391259001, 103.0927742186],
                        [1.72e-09, 5.63262770743, 7.1135470008],
                        [1.64e-09, 4.14700645532, 77.2292791221],
                        [1.62e-09, 0.72021213236, 11.0457002639],
                        [1.6e-09, 4.23490438166, 487.3651437628],
                        [1.91e-09, 0.37651439206, 31.019488637],
                        [1.57e-09, 1.02419759383, 6283.0758499914],
                        [1.57e-09, 4.42530429545, 6206.8097787158],
                        [1.78e-09, 6.24797160202, 316.3918696566],
                        [1.61e-09, 5.65988283675, 343.2185725996],
                        [1.53e-09, 5.58405022784, 252.0865223816],
                        [1.89e-09, 4.8079103997, 641.1211265914],
                        [1.66e-09, 5.50438043692, 662.531203563],
                        [1.46e-09, 5.08949604858, 286.596221297],
                        [1.45e-09, 2.13015521881, 2042.4977891028],
                        [1.56e-09, 2.19452173251, 274.0660483248],
                        [1.48e-09, 4.85696640135, 442.7517005706],
                        [1.87e-09, 4.96121139073, 1589.0728952838],
                        [1.55e-09, 2.28260574227, 142.1408335931],
                        [1.34e-09, 1.29277093566, 456.3938392356],
                        [1.26e-09, 5.59769497652, 179.3588454942],
                        [1.46e-09, 2.53359213478, 256.5399405065],
                        [1.4e-09, 1.57962199954, 75.7448064138],
                        [1.23e-09, 0.05442220184, 944.9828232758],
                        [1.22e-09, 1.90676379802, 418.2608035978],
                        [1.54e-09, 1.86865302773, 331.3215390738],
                        [1.44e-09, 5.52229258454, 14.0146456805],
                        [1.38e-09, 2.80728175526, 82.8583534146],
                        [1.07e-09, 0.66995358132, 190.665178189],
                        [1.14e-09, 1.4889498028, 253.5709950899],
                        [1.1e-09, 5.32587573069, 240.125798381],
                        [1.05e-09, 0.65548440578, 173.6815870919],
                        [1.02e-09, 2.58735617801, 450.4559484024],
                        [9.8e-10, 0.44044795266, 328.3525936572],
                        [1.01e-09, 4.71267656829, 117.36805233],
                        [9.4e-10, 0.54938580474, 293.188503436],
                        [9.5e-10, 2.17636214523, 101.8689339412],
                        [9.3e-10, 0.63687810471, 377.1588225434],
                        [9.1e-10, 5.84828809934, 10137.0194749354],
                        [8.9e-10, 1.02830167997, 1021.2488945514],
                        [9.4e-10, 1.79320597168, 493.0424021651],
                        [8e-10, 1.58140274465, 69.1525242748],
                        [7.5e-10, 0.23453373368, 63.7358983034],
                        [7.1e-10, 1.5196198969, 488.5889840402],
                      ],
          },
          {
            series => "B1",
            terms  => [
                        [0.00227279214, 3.8079308987, 38.1330356378],
                        [1.80312e-05, 1.97576485377, 76.2660712756],
                        [1.385733e-05, 4.82555548018, 36.6485629295],
                        [1.4333e-05, 3.14159265359, 0],
                        [1.073298e-05, 6.08054240712, 39.6175083461],
                        [1.47903e-06, 3.85766231348, 74.7815985673],
                        [1.36448e-06, 0.47764957338, 1.4844727083],
                        [7.0285e-07, 6.18782052139, 35.1640902212],
                        [5.1899e-07, 5.05221791891, 73.297125859],
                        [3.7273e-07, 4.89476629246, 41.1019810544],
                        [4.2568e-07, 0.30721737205, 114.3991069134],
                        [3.7104e-07, 5.75999349109, 2.9689454166],
                        [2.6399e-07, 5.21566335936, 213.299095438],
                        [1.6949e-07, 4.26463671859, 77.7505439839],
                        [1.8747e-07, 0.90426522185, 453.424893819],
                        [1.2951e-07, 6.17709713139, 529.6909650946],
                        [1.0502e-07, 1.20336443465, 137.0330241624],
                        [4.416e-08, 1.25478204684, 111.4301614968],
                        [4.383e-08, 6.14147099615, 71.8126531507],
                        [3.694e-08, 0.94837702528, 33.6796175129],
                        [2.957e-08, 4.7753287121, 4.4534181249],
                        [2.698e-08, 1.92435531119, 112.9146342051],
                        [1.989e-08, 3.96637567224, 42.5864537627],
                        [1.15e-08, 4.30568700024, 37.611770776],
                        [8.71e-09, 4.81775882249, 152.5321425512],
                        [9.44e-09, 2.2177777205, 109.9456887885],
                        [9.36e-09, 1.1705498394, 148.0787244263],
                        [9.25e-09, 2.40329074, 206.1855484372],
                        [6.9e-09, 1.57381082857, 38.6543004996],
                        [6.24e-09, 2.79466003645, 79.2350166922],
                        [7.26e-09, 4.13829519132, 28.5718080822],
                        [6.4e-09, 2.46161252327, 115.8835796217],
                        [5.31e-09, 2.969915305, 98.8999885246],
                        [5.37e-09, 1.95986772922, 220.4126424388],
                        [5.39e-09, 2.06690307827, 40.5807161926],
                        [7.16e-09, 0.5578184701, 350.3321196004],
                        [5.63e-09, 1.84072805158, 983.1158589136],
                        [5.33e-09, 1.3478767794, 47.6942631934],
                        [5.66e-09, 1.80111775954, 175.1660598002],
                        [4.49e-09, 1.62191691011, 144.1465711632],
                        [3.71e-09, 2.74239666472, 415.2918581812],
                        [3.81e-09, 6.11910193382, 426.598190876],
                        [3.66e-09, 2.3975258536, 129.9194771616],
                        [4.56e-09, 3.19611413854, 108.4612160802],
                        [3.27e-09, 3.62341506247, 38.1812197476],
                        [3.28e-09, 0.89613145346, 38.084851528],
                        [3.41e-09, 3.8726546907, 35.685355083],
                        [3.31e-09, 4.48858774501, 460.5384408198],
                        [4.14e-09, 1.03543720726, 70.3281804424],
                        [3.1e-09, 0.51297445145, 37.1698277913],
                        [2.87e-09, 2.183516518, 491.5579294568],
                        [2.74e-09, 6.11504724934, 522.5774180938],
                        [2.81e-09, 3.81657117512, 5.9378908332],
                        [2.98e-09, 4.00532631258, 39.0962434843],
                        [2.65e-09, 5.26569823181, 446.3113468182],
                        [3.19e-09, 1.34097217817, 184.7272873558],
                        [2.03e-09, 6.02944475303, 149.5631971346],
                        [2.05e-09, 5.5393573202, 536.8045120954],
                        [2.26e-09, 6.17710997862, 454.9093665273],
                        [1.86e-09, 3.24302117645, 4.192785694],
                        [1.79e-09, 4.91458426239, 451.9404211107],
                        [1.98e-09, 2.3077585288, 146.594251718],
                        [1.66e-09, 1.16793600058, 72.0732855816],
                        [1.47e-09, 2.10574339673, 44.070926471],
                        [1.23e-09, 1.98250467171, 46.2097904851],
                        [1.59e-09, 3.46955908364, 145.1097790097],
                        [1.16e-09, 5.8897111359, 38.0211610532],
                        [1.15e-09, 4.73412534395, 38.2449102224],
                        [1.25e-09, 3.42713474801, 251.4321310758],
                        [1.28e-09, 1.51108932026, 221.3758502853],
                        [1.27e-09, 0.17176461812, 138.5174968707],
                        [1.24e-09, 5.85160407534, 1059.3819301892],
                        [9.1e-10, 2.38273591235, 30.0562807905],
                        [1.18e-09, 5.27114846878, 37.8724032069],
                        [1.17e-09, 5.35267669439, 38.3936680687],
                        [9.9e-10, 5.19920708255, 135.5485514541],
                        [1.14e-09, 4.37452353441, 388.4651552382],
                        [9.3e-10, 4.64183693718, 106.9767433719],
                        [8.4e-10, 1.35269684746, 33.9402499438],
                        [1.11e-09, 3.5622646377, 181.7583419392],
                        [8.2e-10, 3.18401661435, 42.3258213318],
                        [8.4e-10, 5.51669920239, 8.0767548473],
                      ],
          },
          {
            series => "B2",
            terms  => [
                        [9.690766e-05, 5.57123750291, 38.1330356378],
                        [7.8815e-07, 3.62705474219, 76.2660712756],
                        [7.1523e-07, 0.4547668858, 36.6485629295],
                        [5.8646e-07, 3.14159265359, 0],
                        [2.9915e-07, 1.60671721861, 39.6175083461],
                        [6.472e-08, 5.60736756575, 74.7815985673],
                        [5.8e-08, 2.25341847151, 1.4844727083],
                        [4.309e-08, 1.68126737666, 35.1640902212],
                        [3.502e-08, 2.39142672984, 114.3991069134],
                        [2.649e-08, 0.65061457644, 73.297125859],
                        [1.518e-08, 0.37600329684, 213.299095438],
                        [1.223e-08, 1.2311604303, 2.9689454166],
                        [7.66e-09, 5.45279753249, 453.424893819],
                        [7.79e-09, 2.07081431472, 529.6909650946],
                        [4.96e-09, 0.26552533921, 41.1019810544],
                        [4.69e-09, 5.87866293959, 77.7505439839],
                        [4.82e-09, 5.63056237954, 137.0330241624],
                        [3.45e-09, 1.80085651594, 71.8126531507],
                        [2.74e-09, 2.86650141006, 33.6796175129],
                        [1.58e-09, 4.63868656467, 206.1855484372],
                        [1.66e-09, 1.24877330835, 220.4126424388],
                        [1.53e-09, 2.87376446497, 111.4301614968],
                        [1.16e-09, 3.63838544843, 112.9146342051],
                        [8.5e-10, 0.43712705655, 4.4534181249],
                        [1.04e-09, 6.12597614674, 144.1465711632],
                      ],
          },
          {
            series => "B3",
            terms  => [
                        [2.73423e-06, 1.01688979072, 38.1330356378],
                        [2.274e-08, 2.36805657126, 36.6485629295],
                        [2.029e-08, 5.33364321342, 76.2660712756],
                        [2.393e-08, 0, 0],
                        [5.38e-09, 3.21934211365, 39.6175083461],
                        [2.42e-09, 4.52650721578, 114.3991069134],
                        [1.85e-09, 1.04913770083, 74.7815985673],
                        [1.55e-09, 3.62376309338, 35.1640902212],
                        [1.57e-09, 3.9419536961, 1.4844727083],
                      ],
          },
          {
            series => "B4",
            terms  => [[5.728e-08, 2.66872693322, 38.1330356378]],
          },
          { series => "B5", terms => [[1.13e-09, 4.70646877989, 38.1330356378]] },
        ],
        [
          {
            series => "R0",
            terms  => [
                        [30.07013206102, 0, 0],
                        [0.2706225949, 1.3299945893, 38.1330356378],
                        [0.01691764281, 3.25186138896, 36.6485629295],
                        [0.00807830737, 5.18592836167, 1.4844727083],
                        [0.00537760613, 4.52113902845, 35.1640902212],
                        [0.00495725642, 1.57105654815, 491.5579294568],
                        [0.0027457197, 1.84552256801, 175.1660598002],
                        [0.00135134095, 3.37220607384, 39.6175083461],
                        [0.00121801825, 5.79754444303, 76.2660712756],
                        [0.00100895397, 0.37702748681, 73.297125859],
                        [0.00069791722, 3.79617226928, 2.9689454166],
                        [0.00046687838, 5.74937810094, 33.6796175129],
                        [0.00024593778, 0.50801728204, 109.9456887885],
                        [0.00016939242, 1.59422166991, 71.8126531507],
                        [0.00014229686, 1.07786112902, 74.7815985673],
                        [0.00012011825, 1.92062131635, 1021.2488945514],
                        [8.394731e-05, 0.67816895547, 146.594251718],
                        [7.5718e-05, 1.07149263431, 388.4651552382],
                        [5.720852e-05, 2.59059512267, 4.4534181249],
                        [4.839672e-05, 1.9068599107, 41.1019810544],
                        [4.483492e-05, 2.90573457534, 529.6909650946],
                        [4.270202e-05, 3.41343865825, 453.424893819],
                        [4.35379e-05, 0.6798566237, 32.1951448046],
                        [4.420804e-05, 1.74993796503, 108.4612160802],
                        [2.881063e-05, 1.98600105123, 137.0330241624],
                        [2.635535e-05, 3.09755943422, 213.299095438],
                        [3.38093e-05, 0.84810683275, 183.2428146475],
                        [2.878942e-05, 3.67415901855, 350.3321196004],
                        [2.306293e-05, 2.80962935724, 70.3281804424],
                        [2.530149e-05, 5.79839567009, 490.0734567485],
                        [2.523132e-05, 0.48630800015, 493.0424021651],
                        [2.087303e-05, 0.61858378281, 33.9402499438],
                        [1.976522e-05, 5.1170304456, 168.0525127994],
                        [1.905254e-05, 1.72186472126, 182.279606801],
                        [1.654039e-05, 1.92782545887, 145.1097790097],
                        [1.435072e-05, 1.70005157785, 484.444382456],
                        [1.403029e-05, 4.58914203187, 498.6714764576],
                        [1.499193e-05, 1.01623299513, 219.891377577],
                        [1.39886e-05, 0.7622031762, 176.6505325085],
                        [1.403377e-05, 6.07659416908, 173.6815870919],
                        [1.12856e-05, 5.96661179805, 9.5612275556],
                        [1.228304e-05, 1.59881465324, 77.7505439839],
                        [8.35414e-06, 3.97066884218, 114.3991069134],
                        [8.11186e-06, 3.0025888087, 46.2097904851],
                        [7.31925e-06, 2.10447054189, 181.7583419392],
                        [6.15781e-06, 2.97874625677, 106.9767433719],
                        [7.04778e-06, 1.1873821088, 256.5399405065],
                        [5.0204e-06, 1.38657803368, 5.9378908332],
                        [5.30357e-06, 4.24059166485, 111.4301614968],
                        [4.37096e-06, 2.27029212923, 1550.939859646],
                        [4.0025e-06, 1.25609325435, 8.0767548473],
                        [4.21011e-06, 1.89084929506, 30.7106720963],
                        [3.82457e-06, 3.29965259685, 983.1158589136],
                        [4.22485e-06, 5.53186169605, 525.4981794006],
                        [3.55389e-06, 2.27847846648, 218.4069048687],
                        [2.80062e-06, 1.54129714238, 98.8999885246],
                        [3.14499e-06, 3.95932948594, 381.3516082374],
                        [2.80556e-06, 4.54238271682, 44.7253177768],
                        [2.67738e-06, 5.13323364247, 112.9146342051],
                        [3.33311e-06, 5.75067616021, 39.0962434843],
                        [2.91625e-06, 4.02398326341, 68.8437077341],
                        [3.21429e-06, 1.50625025822, 454.9093665273],
                        [3.09196e-06, 2.85452752153, 72.0732855816],
                        [3.45094e-06, 1.35905860594, 293.188503436],
                        [3.07439e-06, 0.31964571332, 601.7642506762],
                        [2.51356e-06, 3.53992782846, 312.1990839626],
                        [2.48152e-06, 3.41078346726, 37.611770776],
                        [3.06e-06, 2.72475094464, 6244.9428143536],
                        [2.93532e-06, 4.89079857814, 528.2064923863],
                        [2.34479e-06, 0.59231043427, 42.5864537627],
                        [2.39628e-06, 3.16441455173, 143.6253063014],
                        [2.14523e-06, 3.6248028304, 278.2588340188],
                        [2.46198e-06, 1.01506302015, 141.2258098564],
                        [1.74089e-06, 5.55011789988, 567.8240007324],
                        [1.63934e-06, 2.10166491786, 2.4476805548],
                        [1.62897e-06, 2.48946521653, 4.192785694],
                        [1.93455e-06, 1.5842528758, 138.5174968707],
                        [1.55323e-06, 3.28425127954, 31.019488637],
                        [1.82469e-06, 2.45244890571, 255.0554677982],
                        [1.77846e-06, 4.14773474853, 10175.1525105732],
                        [1.74413e-06, 1.53042999914, 329.8370663655],
                        [1.37649e-06, 3.34900537767, 0.9632078465],
                        [1.61011e-06, 5.16655038482, 211.8146227297],
                        [1.13473e-06, 4.96286007991, 148.0787244263],
                        [1.28823e-06, 3.25521535448, 24.1183899573],
                        [1.07363e-06, 3.26457701792, 1059.3819301892],
                        [1.22732e-06, 5.39399536941, 62.2514255951],
                        [1.20529e-06, 3.08050145518, 184.7272873558],
                        [9.9356e-07, 1.92888554099, 28.5718080822],
                        [9.7713e-07, 2.59474415429, 6.592282139],
                        [1.24095e-06, 3.1151675034, 221.3758502853],
                        [1.24693e-06, 2.97042405451, 251.4321310758],
                        [1.14252e-06, 0.25039919123, 594.6507036754],
                        [1.11006e-06, 3.34276426767, 180.2738692309],
                        [1.20939e-06, 1.92914010593, 25.6028626656],
                        [1.04667e-06, 0.94883561775, 395.578702239],
                        [1.09779e-06, 5.43147520571, 494.5268748734],
                        [9.6919e-07, 0.86184760695, 1014.1353475506],
                        [9.8685e-07, 0.8957795271, 488.5889840402],
                        [8.8968e-07, 4.78109764779, 144.1465711632],
                        [1.07888e-06, 0.98700578434, 1124.34166877],
                        [9.7067e-07, 2.62667400276, 291.7040307277],
                        [7.5131e-07, 5.88936524779, 43.2408450685],
                        [9.3718e-07, 6.09873565184, 526.722019678],
                        [9.4822e-07, 0.2066294394, 456.3938392356],
                        [7.0036e-07, 2.39683345663, 426.598190876],
                        [7.7187e-07, 4.2107675324, 105.4922706636],
                        [8.9874e-07, 3.25100749923, 258.0244132148],
                        [6.9133e-07, 4.93031154435, 1028.3624415522],
                        [9.0657e-07, 1.69466970587, 366.485629295],
                        [7.4242e-07, 3.14479101276, 82.8583534146],
                        [5.7995e-07, 0.86159785905, 60.7669528868],
                        [7.8695e-07, 1.0930757555, 700.6642392008],
                        [5.723e-07, 0.81331949225, 2.9207613068],
                        [6.3443e-07, 4.39590123005, 149.5631971346],
                        [5.5698e-07, 3.89047249911, 47.6942631934],
                        [5.643e-07, 5.15003563302, 0.5212648618],
                        [5.6174e-07, 5.42986960794, 911.042573332],
                        [6.1746e-07, 6.16453667559, 1019.7644218431],
                        [7.0503e-07, 0.08077330612, 40.5807161926],
                        [7.4677e-07, 4.8590449998, 186.2117600641],
                        [6.1861e-07, 4.78702599861, 11.0457002639],
                        [6.1135e-07, 0.83712253227, 1022.7333672597],
                        [6.1268e-07, 5.70228826765, 178.1350052168],
                        [5.2887e-07, 0.37458943972, 27.0873353739],
                        [5.6722e-07, 3.52318112447, 216.9224321604],
                        [4.8819e-07, 5.10789123481, 64.9597385808],
                        [6.329e-07, 4.3942491003, 807.9497991134],
                        [6.4062e-07, 6.28297531806, 7.1135470008],
                        [4.6356e-07, 1.34735469284, 451.9404211107],
                        [6.054e-07, 3.40316162416, 294.6729761443],
                        [4.69e-07, 0.17048203552, 7.4223635415],
                        [5.6766e-07, 0.45048868231, 140.001969579],
                        [5.5887e-07, 1.06815733757, 172.1971143836],
                        [5.3761e-07, 2.79644687008, 328.3525936572],
                        [4.3828e-07, 6.04655696644, 135.5485514541],
                        [4.9549e-07, 0.64106656292, 41.0537969446],
                        [5.396e-07, 2.91774494436, 563.6312150384],
                        [4.2961e-07, 5.40175361431, 487.3651437628],
                        [5.1508e-07, 0.09105540708, 210.3301500214],
                        [4.1889e-07, 3.12343223889, 29.226199388],
                        [4.7655e-07, 3.90701760087, 63.7358983034],
                        [4.1639e-07, 6.26847783513, 32.7164096664],
                        [4.1429e-07, 4.45464156759, 37.1698277913],
                        [4.0745e-07, 0.16043648294, 79.2350166922],
                        [4.8205e-07, 1.8419837301, 403.1341922245],
                        [3.6912e-07, 0.44771386183, 30.0562807905],
                        [4.7762e-07, 0.88083849566, 3302.479391062],
                        [3.9465e-07, 3.50565484069, 357.4456666012],
                        [4.2139e-07, 0.63375113663, 343.2185725996],
                        [4.1275e-07, 1.36370496322, 31.2319369581],
                        [4.2612e-07, 3.55270845713, 38.6543004996],
                        [3.8931e-07, 5.2669175327, 415.2918581812],
                        [3.8967e-07, 5.25866056502, 386.9806825299],
                        [3.3734e-07, 5.24400184426, 67.3592350258],
                        [4.0879e-07, 3.55292279438, 331.3215390738],
                        [3.8768e-07, 1.12288359393, 38.1812197476],
                        [3.75e-07, 6.08687972441, 35.4247226521],
                        [3.8831e-07, 4.67876780698, 38.084851528],
                        [3.8231e-07, 6.26491054328, 389.9496279465],
                        [2.9976e-07, 4.45759985804, 22.633917249],
                        [3.1356e-07, 0.07746010366, 12.5301729722],
                        [2.6341e-07, 4.59559782754, 106.0135355254],
                        [2.7465e-07, 5.9954158789, 206.1855484372],
                        [2.5152e-07, 4.4986776032, 34.2008823747],
                        [2.4122e-07, 5.17089441917, 129.9194771616],
                        [2.8997e-07, 3.6492721021, 253.5709950899],
                        [2.7173e-07, 4.37944546475, 142.1408335931],
                        [3.0634e-07, 1.5934880656, 348.8476468921],
                        [3.1464e-07, 1.05065113524, 100.3844612329],
                        [2.4056e-07, 1.02801635413, 41.7563723602],
                        [2.2632e-07, 4.72511111292, 81.3738807063],
                        [2.1942e-07, 3.48416607882, 69.1525242748],
                        [2.6333e-07, 3.01556008632, 365.0011565867],
                        [2.2355e-07, 3.92220883921, 5.1078094307],
                        [2.2498e-07, 4.03487494425, 19.1224551112],
                        [2.2885e-07, 1.58977064672, 189.3931538018],
                        [2.652e-07, 3.61427038042, 367.9701020033],
                        [2.5496e-07, 2.43810518614, 351.8165923087],
                        [1.9111e-07, 2.59694457001, 2080.6308247406],
                        [1.964e-07, 6.15701741238, 35.212274331],
                        [2.5688e-07, 2.00512719767, 439.782755154],
                        [2.1613e-07, 3.32354204724, 119.5069163441],
                        [2.5389e-07, 4.74025836522, 1474.6737883704],
                        [1.8107e-07, 5.35129342595, 244.318584075],
                        [2.3295e-07, 5.93767742799, 316.3918696566],
                        [2.2087e-07, 4.81594755148, 84.3428261229],
                        [1.6972e-07, 3.0510514994, 220.4126424388],
                        [2.0022e-07, 4.99276451168, 179.0982130633],
                        [2.037e-07, 1.86508317889, 171.2339065371],
                        [1.9426e-07, 2.04829970231, 5.4166259714],
                        [2.2628e-07, 0.27205783433, 666.723989257],
                        [1.9072e-07, 3.70882976684, 164.1203595363],
                        [1.7969e-07, 3.40425338171, 69.3649725959],
                        [1.8716e-07, 0.90215956591, 285.3723810196],
                        [1.5889e-07, 0.42011285882, 697.743477894],
                        [1.4988e-07, 3.08544843665, 704.8570248948],
                        [1.4774e-07, 3.36129613309, 274.0660483248],
                        [1.5972e-07, 1.82864185268, 477.3308354552],
                        [1.3892e-07, 2.94161501165, 38.3936680687],
                        [1.3922e-07, 2.85574364078, 37.8724032069],
                        [1.5481e-07, 4.94982954853, 101.8689339412],
                        [1.7571e-07, 5.82317632469, 35.685355083],
                        [1.5856e-07, 5.04973561582, 36.9091953604],
                        [1.6414e-07, 3.63049397028, 45.2465826386],
                        [1.7158e-07, 2.51251149482, 20.6069278195],
                        [1.2941e-07, 3.03041555329, 522.5774180938],
                        [1.5752e-07, 5.00292909214, 247.2393453818],
                        [1.2679e-07, 0.20331109568, 460.5384408198],
                        [1.626e-07, 5.93480347217, 815.0633461142],
                        [1.2903e-07, 3.51141502996, 446.3113468182],
                        [1.3891e-07, 5.5106469767, 31.5407534988],
                        [1.3668e-07, 5.4557613532, 39.3568759152],
                        [1.3418e-07, 3.95805150079, 290.2195580194],
                        [1.5368e-07, 2.45783892707, 26.826702943],
                        [1.4246e-07, 3.18588280921, 401.6497195162],
                        [1.2222e-07, 4.94370170146, 14.0146456805],
                        [1.5484e-07, 3.79703715637, 404.6186649328],
                        [1.3427e-07, 3.79527836573, 151.0476698429],
                        [1.445e-07, 4.93940408761, 120.9913890524],
                        [1.4331e-07, 4.71117327722, 738.7972748386],
                        [1.1566e-07, 5.91003539239, 536.8045120954],
                        [1.5578e-07, 2.91836788254, 875.830299001],
                        [1.3124e-07, 2.16056013419, 152.5321425512],
                        [1.1744e-07, 2.94770244071, 2.7083129857],
                        [1.2793e-07, 1.97868575679, 1.3725981237],
                        [1.2969e-07, 0.00535826017, 97.4155158163],
                        [1.3891e-07, 4.7643544182, 0.2606324309],
                        [1.3729e-07, 2.3230647385, 38.2449102224],
                        [1.0714e-07, 6.18129683877, 115.8835796217],
                        [1.161e-07, 4.61712859898, 178.7893965226],
                        [1.1257e-07, 0.79300245838, 42.3258213318],
                        [1.45e-07, 5.44690193314, 44.070926471],
                        [1.1534e-07, 5.26580538005, 160.9389657986],
                        [1.3355e-07, 5.20849186729, 32.4557772355],
                        [1.3658e-07, 2.15687632802, 476.4313180835],
                        [1.3782e-07, 3.47865209163, 38.0211610532],
                        [1.2714e-07, 2.09462988855, 20.4950532349],
                        [1.3257e-07, 5.15138524813, 103.0927742186],
                        [9.715e-08, 0.7459788348, 918.1561203328],
                        [1.034e-07, 5.38977407079, 222.8603229936],
                        [1.3357e-07, 5.89635739027, 748.0978699633],
                        [1.2632e-07, 1.20306997433, 16.1535096946],
                        [1.1437e-07, 1.58444114292, 495.4900827199],
                        [1.1424e-07, 4.74142930795, 487.6257761937],
                        [9.098e-08, 5.19932138822, 118.0224436358],
                        [9.336e-08, 0.97313630925, 662.531203563],
                        [9.827e-08, 4.48170250645, 505.7850234584],
                        [8.585e-08, 0.20375451897, 944.9828232758],
                        [8.875e-08, 5.53111742265, 17.5261078183],
                        [9.957e-08, 4.03258125243, 169.5369855077],
                        [1.1506e-07, 3.11649121817, 17.6379824029],
                        [9.818e-08, 5.20376439002, 1.5963472929],
                        [1.016e-07, 3.74441320429, 457.617679513],
                        [8.661e-08, 0.31247523804, 1440.7335384266],
                        [8.496e-08, 1.06445636872, 55.7710180407],
                        [1.1162e-07, 1.92907800408, 564.8550553158],
                        [8.057e-08, 0.31116345866, 377.4194549743],
                        [9.851e-08, 4.23328578127, 418.2608035978],
                        [7.938e-08, 2.40417397694, 488.3765357191],
                        [9.894e-08, 0.63707319139, 183.7640795093],
                        [9.913e-08, 3.94049519088, 441.2672278623],
                        [7.867e-08, 3.87469522964, 494.7393231945],
                        [7.589e-08, 3.15909316566, 416.7763308895],
                        [8.496e-08, 5.38968698704, 104.0077979553],
                        [9.716e-08, 3.06038536864, 166.5680400911],
                        [9.377e-08, 0.56416645296, 673.316271396],
                        [8.771e-08, 5.24534141981, 1057.8974574809],
                        [7.99e-08, 1.55726966638, 59.2824801785],
                        [9.09e-08, 4.32953439022, 29.7474642498],
                        [9.667e-08, 5.89033222679, 358.4088744477],
                        [7.209e-08, 2.29464803358, 79.1868325824],
                        [8.062e-08, 0.44458003524, 19.0105805266],
                        [8.254e-08, 3.47304582051, 156.1554792736],
                        [9.804e-08, 6.06393995615, 784.7464328928],
                        [8.516e-08, 5.99060386955, 180.7951340927],
                        [8.09e-08, 1.38588221442, 1654.0326338646],
                        [9.074e-08, 4.0397149046, 1017.0561088574],
                        [6.908e-08, 1.41919832926, 178.3474535379],
                        [8.23e-08, 2.53750470473, 518.3846323998],
                        [8.594e-08, 5.29104206063, 457.8783119439],
                        [6.769e-08, 5.43380191356, 171.9846660625],
                        [8.571e-08, 0.35876828441, 636.6677084665],
                        [8.995e-08, 1.36992508507, 6209.7787241324],
                        [6.641e-08, 2.92327140872, 0.0481841098],
                        [9.278e-08, 3.80308677009, 25558.2121764796],
                        [6.567e-08, 4.01934954352, 0.1118745846],
                        [6.441e-08, 4.28250687347, 36.1272980677],
                        [7.257e-08, 4.09776235307, 326.8681209489],
                        [8.384e-08, 5.49363770202, 532.6117264014],
                        [7.471e-08, 4.62144262894, 526.9826521089],
                        [7.5e-08, 0.61545750834, 485.9288551643],
                        [7.716e-08, 1.04880632264, 525.2375469697],
                        [8.504e-08, 2.79350586429, 10139.988420352],
                        [7.466e-08, 5.07942174095, 157.6399519819],
                        [7.186e-08, 6.22833818429, 77.2292791221],
                        [7.784e-08, 1.89308880453, 984.6003316219],
                        [6.513e-08, 0.07498932215, 79.889407998],
                        [6.077e-08, 2.96673519667, 36.6967470393],
                        [7.706e-08, 5.7063258079, 209.106309744],
                        [7.265e-08, 4.94483532589, 131.4039498699],
                        [6.984e-08, 2.53239305821, 497.1870037493],
                        [7.824e-08, 2.31462643851, 513.079881013],
                        [7.175e-08, 3.69203633127, 524.0137066923],
                        [6.855e-08, 0.14076801572, 283.6272758804],
                        [6.922e-08, 3.36515011915, 438.2982824457],
                        [7.349e-08, 3.50406958122, 500.1559491659],
                        [6.301e-08, 0.14776691217, 608.877797677],
                        [5.892e-08, 4.24403528888, 4.665866446],
                        [7.613e-08, 5.14905171677, 259.5088859231],
                        [7.128e-08, 5.92696788834, 482.9599097477],
                        [6.829e-08, 1.01745137848, 1543.8263126452],
                        [5.981e-08, 4.79954091087, 215.4379594521],
                        [5.526e-08, 2.34003154732, 65.2203710117],
                        [6.817e-08, 6.1216282969, 395.0574373772],
                        [5.369e-08, 3.76855960849, 52099.5402118728],
                        [5.776e-08, 5.61434462641, 987.5692770385],
                        [7.523e-08, 5.60432148128, 2810.9214616052],
                        [7.329e-08, 3.76815551582, 1512.8068240082],
                        [5.616e-08, 2.13872867116, 145.6310438715],
                        [5.258e-08, 0.3085083691, 36.6003788197],
                        [5.688e-08, 1.82274388581, 1227.4344429886],
                        [5.658e-08, 2.35049199704, 5.6290742925],
                        [6.135e-08, 4.23390561816, 496.0113475817],
                        [5.128e-08, 2.89050864873, 313.6835566709],
                        [6.472e-08, 3.49494191669, 552.6973893591],
                        [4.983e-08, 3.91958511552, 10135.5350022271],
                        [5.217e-08, 0.40052635702, 319.3126309634],
                        [4.952e-08, 1.42482088612, 49.1787359017],
                        [5.964e-08, 5.70758449643, 309.7995875176],
                        [5.091e-08, 6.00974510144, 1409.7140497896],
                        [5.205e-08, 5.5027133451, 238.9019581036],
                        [4.8e-08, 1.1345031067, 134.0640787458],
                        [4.943e-08, 1.43051344597, 422.405405182],
                        [5.604e-08, 2.05669305961, 207.3612046048],
                        [6.31e-08, 5.22966882627, 139.7413371481],
                        [4.772e-08, 3.06668713747, 464.7312265138],
                        [4.919e-08, 3.57280542629, 52175.8062831484],
                        [4.762e-08, 5.90654311203, 838.9692877504],
                        [4.848e-08, 0.77467099227, 1.6969210294],
                        [5.694e-08, 0.77313415569, 709.9648343255],
                        [5.455e-08, 0.90289242792, 208.8456773131],
                        [4.901e-08, 3.79986913631, 15.4991183888],
                        [4.772e-08, 0.15755140037, 39.5056337615],
                        [5.673e-08, 2.68359159067, 1127.2624300768],
                        [5.477e-08, 0.53123497431, 113.8778420516],
                        [5.077e-08, 1.59268428609, 1547.9709142294],
                        [4.981e-08, 1.44584050478, 1.2720243872],
                        [5.813e-08, 5.85024085408, 57.255490749],
                        [5.52e-08, 5.06396698257, 421.2297490144],
                        [5.938e-08, 0.96886308551, 6280.1069045748],
                        [5.206e-08, 3.5800381937, 474.9468453752],
                        [5.256e-08, 0.61005270999, 95.9792272178],
                        [5.531e-08, 5.28764137194, 36.7604375141],
                        [6.158e-08, 5.73176703797, 711.4493070338],
                        [5.003e-08, 2.19048397989, 501.6404218742],
                        [5.15e-08, 5.58407480282, 26049.7701059364],
                        [5.138e-08, 4.55234158942, 670.916774951],
                        [5.609e-08, 4.3727275978, 52.8020726241],
                        [5.636e-08, 2.39183054397, 10210.3166007944],
                        [4.512e-08, 2.59978208967, 1234.5479899894],
                        [5.412e-08, 4.58813638089, 179.6194779251],
                        [4.314e-08, 3.38846714337, 142.6620984549],
                        [4.708e-08, 5.23537414423, 3.6233367224],
                        [4.471e-08, 3.94378336812, 12566.1516999828],
                        [5.296e-08, 1.12249063176, 134.1122628556],
                        [4.188e-08, 2.52490407427, 6205.3253060075],
                        [4.645e-08, 1.90644271528, 13324.3166711614],
                        [4.502e-08, 2.01956920977, 315.1680293792],
                        [5.346e-08, 2.94804816223, 353.0404325861],
                        [4.177e-08, 2.09489065926, 803.7570134194],
                        [5.296e-08, 3.88249567974, 2118.7638603784],
                        [5.325e-08, 4.28221258353, 477.9157907918],
                        [5.519e-08, 0.09960891963, 600.019145537],
                        [5.169e-08, 0.59948596687, 6.9010986797],
                        [4.179e-08, 0.14619703083, 6644.5762904701],
                        [4.49e-08, 1.07042724999, 52139.1577202189],
                        [3.97e-08, 6.13227798578, 1553.9088050626],
                        [3.97e-08, 4.69887237362, 91.7864415238],
                        [4.234e-08, 0.14478458924, 65.8747623175],
                        [5.183e-08, 3.52837189306, 110.2063212194],
                        [5.259e-08, 6.20809827528, 142.7102825647],
                        [3.869e-08, 5.25125030487, 1558.0534066468],
                        [4.457e-08, 2.10248126544, 487.1045113319],
                        [4.89e-08, 1.83606790269, 46.5186070258],
                        [3.875e-08, 5.60269278935, 385.4962098216],
                        [3.826e-08, 1.30946706974, 2176.6100519584],
                        [4.591e-08, 4.84657580441, 1337.640764208],
                        [5.111e-08, 1.18808079775, 981.6313862053],
                        [4.709e-08, 1.40878215308, 52213.9393187862],
                        [3.891e-08, 5.43661875415, 154.6710065653],
                        [4.145e-08, 4.32505910718, 363.5166838784],
                        [4.441e-08, 3.5015842457, 187.6962327724],
                        [3.703e-08, 2.48768949613, 67.8804998876],
                        [4.094e-08, 1.4234704726, 310.7146112543],
                        [3.681e-08, 5.70552661143, 491.6698040414],
                        [4.787e-08, 3.65822147476, 589.3459522886],
                        [4.02e-08, 5.45643059988, 6641.6073450535],
                        [3.656e-08, 0.57790726599, 491.4460548722],
                        [4.288e-08, 3.35265955957, 203.2166030206],
                        [3.843e-08, 4.61508898119, 1025.7023126763],
                        [3.767e-08, 0.05292047125, 320.2758388099],
                        [4.632e-08, 0.82011276589, 3265.8308281325],
                        [4.609e-08, 5.25443775917, 296.1574488526],
                        [4.555e-08, 5.30391170376, 26013.1215430069],
                        [3.556e-08, 4.80267245336, 224.3447957019],
                        [4.859e-08, 5.52756242256, 487.4133278726],
                        [3.626e-08, 1.44624342082, 70.8494453042],
                        [4.302e-08, 1.60914544159, 12529.5031370533],
                        [3.493e-08, 4.75315651083, 12489.8856287072],
                        [3.722e-08, 0.27433061822, 949.4362414007],
                        [4.234e-08, 5.25112033465, 194.2885149114],
                        [3.451e-08, 2.97409317928, 499.6346843041],
                        [4.796e-08, 6.21059766333, 491.8185618877],
                        [3.639e-08, 1.25605018211, 2603.2082428344],
                        [4.646e-08, 5.71392540144, 321.7603115182],
                        [3.702e-08, 2.08952561657, 491.036664595],
                        [3.672e-08, 2.87489628704, 497.49582029],
                        [3.965e-08, 1.0548498824, 75.7448064138],
                        [3.416e-08, 0.68584132933, 305.0855369618],
                        [4.513e-08, 4.3892700249, 425.1137181677],
                        [3.853e-08, 0.61321572401, 12526.5341916367],
                        [3.788e-08, 3.3222199584, 3140.0127549298],
                        [3.781e-08, 5.58125317044, 1652.5481611563],
                        [3.903e-08, 5.31609723466, 408.1783111804],
                        [3.945e-08, 3.60558877407, 1589.0728952838],
                        [4.084e-08, 0.83813879869, 52.3601296394],
                        [4.084e-08, 3.50290269471, 23.9059416362],
                        [3.694e-08, 1.03218855688, 481.4754370394],
                        [3.636e-08, 5.31068934607, 141.4864422873],
                        [3.345e-08, 3.94392179077, 20389.9225294925],
                        [4.639e-08, 6.24618220184, 821.3949958223],
                        [3.934e-08, 0.26992234338, 1655.5171065729],
                        [4.431e-08, 2.486474378, 549.7284439425],
                        [4.168e-08, 5.39993754642, 236.5024616586],
                        [4.02e-08, 0.07393243012, 52136.1887748023],
                        [4.055e-08, 1.34004288978, 1054.9285120643],
                        [3.275e-08, 0.98533127454, 1344.7543112088],
                        [3.213e-08, 2.97105590703, 20386.9535840759],
                        [4.428e-08, 0.06728869735, 491.2972970259],
                        [4.063e-08, 0.0619283857, 6168.676743078],
                        [3.804e-08, 5.34897033476, 523.7530742614],
                        [3.917e-08, 5.67905809516, 1131.1945833399],
                        [3.833e-08, 0.87811168267, 52.6901980395],
                        [4.02e-08, 2.69209723289, 1439.4615140394],
                        [4.373e-08, 1.86209663434, 73.5577582899],
                        [3.159e-08, 1.04693380342, 703.3725521865],
                        [3.116e-08, 5.2015916684, 449.232108125],
                        [3.258e-08, 4.65131076542, 696.2590051857],
                        [3.427e-08, 0.27003884843, 2389.9091473964],
                        [4.349e-08, 0.07531141761, 20426.571092422],
                        [3.383e-08, 5.61838426864, 699.2279506023],
                        [3.305e-08, 1.4166687729, 562.1467423301],
                        [3.297e-08, 5.46677712589, 1442.2180111349],
                        [3.277e-08, 2.71815883511, 980.146913497],
                        [3.171e-08, 4.49510885866, 1439.2490657183],
                        [4.175e-08, 4.24327707038, 381.6122406683],
                        [3.155e-08, 3.40776789576, 39.7293829307],
                        [4.112e-08, 0.90309319273, 1087.6931058405],
                        [3.35e-08, 5.27474671017, 80.7194894005],
                        [3.725e-08, 1.52448613082, 1058.109905802],
                        [3.65e-08, 3.59798316565, 192.8040422031],
                        [3.837e-08, 1.48519528444, 10098.8864392976],
                        [2.959e-08, 1.23012121982, 2500.1154686158],
                        [3.33e-08, 6.12470287875, 10172.1835651566],
                        [3.361e-08, 4.31837298696, 492.0791943186],
                        [3.288e-08, 3.14692435376, 347.3631741838],
                        [2.992e-08, 5.01304660316, 175.21424391],
                        [3.294e-08, 2.52694043155, 1692.1656695024],
                        [2.984e-08, 1.8178065989, 175.1178756904],
                        [3.013e-08, 0.92957285991, 1515.7757694248],
                        [3.863e-08, 5.4604492857, 332.8060117821],
                        [3.403e-08, 1.10932483984, 987.3086446076],
                        [3.312e-08, 0.67710158807, 977.4867846211],
                        [3.03e-08, 1.77996261146, 156489.285813807],
                        [3.605e-08, 4.89955108152, 1043.8828118004],
                        [2.937e-08, 0.6046967123, 990.2294059144],
                        [3.276e-08, 4.26765608367, 1189.3014073508],
                        [2.966e-08, 5.29808076929, 31.9826964835],
                        [2.994e-08, 2.58599359402, 178.086821107],
                        [3.905e-08, 1.87748122254, 1158.2819187138],
                        [3.11e-08, 3.09203517638, 235.933012687],
                        [3.313e-08, 2.70308129756, 604.4725636619],
                        [3.276e-08, 1.24440460327, 874.6546428334],
                        [3.276e-08, 5.58544609667, 950.920714109],
                        [3.746e-08, 0.33859914037, 913.9633346388],
                        [3.552e-08, 3.07180917863, 240.3864308119],
                        [2.885e-08, 6.01130634957, 1097.514965827],
                        [3.643e-08, 5.11977873355, 452.2010535416],
                        [2.768e-08, 4.38396269009, 391.4341006548],
                        [2.776e-08, 5.0182159483, 8.9068362498],
                        [2.99e-08, 5.62911695857, 140.6563608848],
                        [2.761e-08, 4.05534163807, 6283.0758499914],
                        [3.226e-08, 4.76711354367, 6241.973868937],
                        [3.748e-08, 4.84009347869, 341.7340998913],
                        [2.752e-08, 4.53621078796, 6206.8097787158],
                        [3.847e-08, 2.40982343643, 26086.4186688659],
                        [2.727e-08, 3.28234198801, 483.4811746095],
                        [2.884e-08, 4.05452029151, 1.2238402774],
                        [2.702e-08, 3.72061244391, 946.4672959841],
                        [2.723e-08, 4.37517047024, 15.1903018481],
                        [2.847e-08, 5.22951186538, 661.0467308547],
                        [2.68e-08, 4.19379121323, 13.184564278],
                        [3.269e-08, 0.4311977852, 496.9745554282],
                        [3.489e-08, 3.82213189319, 625.9945152181],
                        [3.757e-08, 3.88223872147, 495.702531041],
                        [2.872e-08, 5.00345974886, 252.0865223816],
                        [3.742e-08, 2.03372773652, 8.5980197091],
                        [3.172e-08, 1.11135762382, 260.9933586314],
                        [3.341e-08, 2.91360557418, 304.2342036999],
                        [2.915e-08, 2.63627684599, 6681.2248533996],
                        [2.915e-08, 1.4377362589, 6604.958782124],
                        [2.629e-08, 2.0982440745, 2713.4145640538],
                        [2.901e-08, 3.3392480023, 515.463871093],
                        [2.803e-08, 1.23584865903, 6643.0918177618],
                        [3.045e-08, 3.33515866438, 921.0768816396],
                        [2.699e-08, 5.4259779465, 925.2696673336],
                        [2.808e-08, 5.77870303237, 1024.217839968],
                        [3.028e-08, 3.75501312393, 511.5954083047],
                        [3.09e-08, 2.49453093252, 14.6690369863],
                        [2.913e-08, 4.83296711477, 515.936951845],
                        [3.139e-08, 5.9913425471, 570.7447620392],
                        [2.752e-08, 3.08268180744, 853.196381752],
                        [2.779e-08, 3.74527347899, 494.0056100116],
                        [2.643e-08, 1.99093797444, 470.2172884544],
                        [2.763e-08, 4.01095972177, 448.9714756941],
                        [2.643e-08, 5.24970673655, 249.9476583675],
                        [3.426e-08, 4.73955481174, 1050.9963588012],
                        [2.573e-08, 2.01267457287, 1514.2912967165],
                        [2.633e-08, 1.63640090603, 170.7126416753],
                        [3.034e-08, 4.48979734509, 560.7104537316],
                        [3.025e-08, 5.51446170055, 369.4545747116],
                        [3.095e-08, 4.01459691667, 1615.8995982268],
                        [2.49e-08, 0.15301603966, 78187.443353447],
                        [2.589e-08, 0.79196093766, 1228.9189156969],
                        [3.143e-08, 5.33170343283, 1542.3418399369],
                        [3.138e-08, 4.50785484172, 461.7622810972],
                        [2.812e-08, 3.7424659412, 2.0057375701],
                        [3.062e-08, 4.88018345098, 227.9681324243],
                        [2.553e-08, 4.85437812287, 488.8496164711],
                        [2.971e-08, 1.27359129352, 530.914805372],
                        [2.646e-08, 3.64828423565, 335.7749571987],
                        [3.329e-08, 2.71693827722, 171.021458216],
                        [2.648e-08, 0.60243117586, 70.5888128733],
                        [3.061e-08, 5.05044834864, 378.6432952517],
                        [2.738e-08, 4.75405645015, 151.260118164],
                        [2.728e-08, 5.89052930055, 213.9534867438],
                        [3.411e-08, 2.24137878065, 734.4557312983],
                        [2.623e-08, 0.54340876464, 1586.1039498672],
                        [3.169e-08, 5.84871429991, 1049.5118860929],
                        [2.43e-08, 2.34595493263, 450.4559484024],
                        [2.907e-08, 5.58085498481, 597.5714649822],
                        [3.3e-08, 0.94221473935, 58.1705144857],
                        [2.543e-08, 5.30426930256, 419.4846438752],
                        [3.175e-08, 2.32600231924, 339.2864193365],
                        [2.858e-08, 2.36621678719, 32.5039613453],
                        [2.712e-08, 5.79983621237, 1587.5884225755],
                        [3.34e-08, 1.36950315448, 384.2723695442],
                        [3.301e-08, 5.83023910521, 51.7751743028],
                        [2.415e-08, 0.6944692367, 489.5521918867],
                        [2.736e-08, 5.74320864965, 1167.8431462694],
                        [2.956e-08, 5.22962139507, 199.8538987291],
                        [3.262e-08, 0.01501002027, 1545.3107853535],
                        [2.506e-08, 4.84043333582, 943.4983505675],
                        [3.24e-08, 2.46676155925, 1016.7954764265],
                        [3.148e-08, 4.62079057738, 233.533516242],
                        [2.327e-08, 4.10421417326, 70.1157321213],
                        [2.371e-08, 4.79963943424, 271.145287018],
                        [3.006e-08, 3.66877796077, 1476.1582610787],
                        [2.537e-08, 5.66681769885, 21.1494445407],
                        [3.006e-08, 0.9304890948, 21.9795259432],
                        [3.033e-08, 0.6715748869, 292.4859280204],
                        [2.344e-08, 1.83547256266, 492.3086889822],
                        [3.117e-08, 2.76268894894, 1473.1893156621],
                        [2.323e-08, 2.88799980853, 533.6231183577],
                        [2.34e-08, 4.44862573253, 490.8071699314],
                        [2.511e-08, 0.99467349084, 266.1011680621],
                        [2.919e-08, 4.75889516601, 1511.3223512999],
                        [2.493e-08, 6.10541658597, 1225.9499702803],
                        [2.798e-08, 3.06162629894, 419.7452763061],
                        [2.691e-08, 3.20679023131, 463.5073862364],
                        [2.291e-08, 5.81534758547, 246.9787129509],
                        [2.319e-08, 6.0551428147, 525.7588118315],
                        [3.112e-08, 0.89712836583, 314.9073969483],
                        [3.085e-08, 5.84605938859, 1192.2221686576],
                        [2.897e-08, 0.54747024257, 20350.3050211464],
                        [3.067e-08, 2.22206306288, 248.4631856592],
                        [2.252e-08, 0.87483094907, 61.0275853177],
                        [2.392e-08, 3.62837597194, 439.1977998174],
                        [2.817e-08, 2.73562306571, 16.6747745564],
                        [2.379e-08, 6.17876088396, 467.6519878206],
                        [2.598e-08, 4.82643304253, 384.5811860849],
                        [2.718e-08, 1.01823841209, 215.9592243139],
                        [2.998e-08, 1.097557153, 1964.7472451189],
                        [2.884e-08, 2.97813466834, 383.0967133766],
                        [2.231e-08, 4.48841493844, 4.1446015842],
                        [2.203e-08, 2.23336308907, 481.2629887183],
                        [2.26e-08, 2.3540491366, 659.6104422562],
                        [2.491e-08, 1.7023635707, 445.3481389717],
                        [3.041e-08, 5.55577674116, 674.8007441043],
                        [2.289e-08, 1.18497528002, 1552.4243323543],
                        [2.975e-08, 0.48272389481, 1052.4808315095],
                        [2.339e-08, 0.75318738767, 478.8153081635],
                        [3.011e-08, 0.16359500858, 54.2865453324],
                        [2.82e-08, 6.18522693724, 556.5176680376],
                        [2.266e-08, 5.91286000054, 3.4902102784],
                        [2.231e-08, 1.45038594906, 196.5067008026],
                      ],
          },
          {
            series => "R1",
            terms  => [
                        [0.00236338502, 0.70498011235, 38.1330356378],
                        [0.00013220279, 3.32015499895, 1.4844727083],
                        [8.621863e-05, 6.2162895163, 35.1640902212],
                        [2.70174e-05, 1.88140666779, 39.6175083461],
                        [2.15315e-05, 5.16873840979, 76.2660712756],
                        [2.154735e-05, 2.09431198086, 2.9689454166],
                        [1.463924e-05, 1.18417031047, 33.6796175129],
                        [1.603165e-05, 0, 0],
                        [1.135773e-05, 3.91891199655, 36.6485629295],
                        [8.9765e-06, 5.24122933533, 388.4651552382],
                        [7.89908e-06, 0.5331548458, 168.0525127994],
                        [7.6003e-06, 0.02051033644, 182.279606801],
                        [6.07183e-06, 1.0770650035, 1021.2488945514],
                        [5.71622e-06, 3.40060785432, 484.444382456],
                        [5.6079e-06, 2.88685815667, 498.6714764576],
                        [4.9019e-06, 3.46830928696, 137.0330241624],
                        [2.64093e-06, 0.86220057976, 4.4534181249],
                        [2.70526e-06, 3.27355867939, 71.8126531507],
                        [2.03524e-06, 2.41820674409, 32.1951448046],
                        [1.55438e-06, 0.36537064534, 41.1019810544],
                        [1.32766e-06, 3.60157672619, 9.5612275556],
                        [9.3626e-07, 0.66670888163, 46.2097904851],
                        [8.3317e-07, 3.25992461673, 98.8999885246],
                        [7.2205e-07, 4.47717435693, 601.7642506762],
                        [6.8983e-07, 1.46326969479, 74.7815985673],
                        [8.6953e-07, 5.77228651853, 381.3516082374],
                        [6.8717e-07, 4.52563942435, 70.3281804424],
                        [6.4724e-07, 3.85477388838, 73.297125859],
                        [6.8377e-07, 3.39509945953, 108.4612160802],
                        [5.3375e-07, 5.43650770516, 395.578702239],
                        [4.4453e-07, 3.61409723545, 2.4476805548],
                        [4.1243e-07, 4.73866592865, 8.0767548473],
                        [4.8331e-07, 1.98568593981, 175.1660598002],
                        [4.1744e-07, 4.94257598763, 31.019488637],
                        [4.4102e-07, 1.41744904844, 1550.939859646],
                        [4.117e-07, 1.41999374753, 490.0734567485],
                        [4.1099e-07, 4.86312637841, 493.0424021651],
                        [3.6267e-07, 5.30764043577, 312.1990839626],
                        [3.6284e-07, 0.38187812797, 77.7505439839],
                        [4.0619e-07, 2.27237172464, 529.6909650946],
                        [3.236e-07, 5.91123007786, 5.9378908332],
                        [3.1197e-07, 2.70549944134, 1014.1353475506],
                        [3.273e-07, 5.22147683115, 41.0537969446],
                        [3.6079e-07, 4.87817494829, 491.5579294568],
                        [3.0181e-07, 3.63273193845, 30.7106720963],
                        [2.9991e-07, 3.30769367603, 1028.3624415522],
                        [2.7048e-07, 1.77647060739, 44.7253177768],
                        [2.7756e-07, 4.55583165091, 7.1135470008],
                        [2.7475e-07, 0.97228280623, 33.9402499438],
                        [2.4944e-07, 3.10083391185, 144.1465711632],
                        [2.5958e-07, 2.99724758632, 60.7669528868],
                        [2.1369e-07, 4.71270048898, 278.2588340188],
                        [2.1283e-07, 0.68957829113, 251.4321310758],
                        [2.3727e-07, 5.12044184469, 176.6505325085],
                        [2.1392e-07, 0.86286397645, 4.192785694],
                        [2.3373e-07, 1.64955088447, 173.6815870919],
                        [2.4163e-07, 3.56602004577, 145.1097790097],
                        [2.0238e-07, 5.61479765982, 24.1183899573],
                        [2.6958e-07, 4.14294870704, 453.424893819],
                        [2.4048e-07, 1.00718363213, 213.299095438],
                        [1.8322e-07, 1.98028683488, 72.0732855816],
                        [1.8266e-07, 6.17260374467, 189.3931538018],
                        [1.9201e-07, 4.65162168927, 106.9767433719],
                        [1.7606e-07, 1.60307551767, 62.2514255951],
                        [1.6545e-07, 1.69931816587, 357.4456666012],
                        [2.0132e-07, 3.29520553529, 114.3991069134],
                        [1.5425e-07, 4.38812302799, 25.6028626656],
                        [1.9173e-07, 2.20014267311, 343.2185725996],
                        [1.5077e-07, 3.66802659382, 0.5212648618],
                        [1.4029e-07, 0.5533633329, 129.9194771616],
                        [1.3361e-07, 5.8575108372, 68.8437077341],
                        [1.5357e-07, 4.20731277007, 567.8240007324],
                        [1.2746e-07, 3.52815836608, 477.3308354552],
                        [1.1724e-07, 5.5764726346, 31.2319369581],
                        [1.1533e-07, 0.89138506506, 594.6507036754],
                        [1.0508e-07, 4.35552732772, 32.7164096664],
                        [1.0826e-07, 5.21826226871, 26.826702943],
                        [1.0085e-07, 1.98102855874, 40.5807161926],
                        [1.0518e-07, 5.27281360238, 2.9207613068],
                        [9.207e-08, 0.50092534158, 64.9597385808],
                        [9.231e-08, 0.6818097771, 160.9389657986],
                        [8.735e-08, 5.80657503476, 6.592282139],
                        [1.0114e-07, 4.51164596694, 28.5718080822],
                        [1.0392e-07, 5.18877536013, 42.5864537627],
                        [9.873e-08, 3.7651215808, 181.7583419392],
                        [8.35e-08, 2.82449631025, 43.2408450685],
                        [9.838e-08, 1.494387636, 47.6942631934],
                        [7.645e-08, 4.07503370297, 389.9496279465],
                        [8.004e-08, 2.78082277326, 505.7850234584],
                        [7.44e-08, 2.35731983047, 11.0457002639],
                        [7.342e-08, 1.62279119952, 135.5485514541],
                        [9.45e-08, 0.27241261915, 426.598190876],
                        [7.192e-08, 0.82841201068, 911.042573332],
                        [6.979e-08, 1.86753914872, 206.1855484372],
                        [6.874e-08, 0.83802906828, 82.8583534146],
                        [7.897e-08, 1.86554246391, 38.6543004996],
                        [6.729e-08, 3.98338053636, 12.5301729722],
                        [6.357e-08, 0.90093123522, 487.3651437628],
                        [6.72e-08, 1.339360407, 220.4126424388],
                        [7.695e-08, 5.13312500855, 23.9059416362],
                        [7.059e-08, 5.99832463494, 639.897286314],
                        [8.302e-08, 3.85960902325, 37.611770776],
                        [6.412e-08, 2.41743702679, 1059.3819301892],
                        [6.751e-08, 1.9686089447, 45.2465826386],
                        [6.431e-08, 4.07813226506, 35.685355083],
                        [5.517e-08, 3.8132579089, 815.0633461142],
                        [5.562e-08, 0.4161960215, 563.6312150384],
                        [6.115e-08, 2.10934525342, 697.743477894],
                        [6.216e-08, 4.79301628209, 143.6253063014],
                        [5.346e-08, 3.13071964722, 386.9806825299],
                        [5.245e-08, 6.06245070403, 171.2339065371],
                        [5.129e-08, 0.79394555531, 179.0982130633],
                        [5.168e-08, 4.73765992885, 522.5774180938],
                        [6.422e-08, 0.64684316894, 350.3321196004],
                        [5.006e-08, 2.37645082899, 77.2292791221],
                        [5.005e-08, 4.70632786971, 460.5384408198],
                        [5.167e-08, 5.2024661657, 446.3113468182],
                        [5.119e-08, 2.17338058771, 494.7393231945],
                        [5.025e-08, 4.21265519856, 536.8045120954],
                        [4.722e-08, 6.22814313946, 63.7358983034],
                        [5.125e-08, 5.38138329172, 179.3106613844],
                        [4.918e-08, 4.09031782903, 488.3765357191],
                        [4.652e-08, 5.10765073368, 274.0660483248],
                        [4.711e-08, 5.56542374115, 42.3258213318],
                        [4.459e-08, 1.3078482983, 69.3649725959],
                        [5.485e-08, 3.88088464259, 218.4069048687],
                        [4.416e-08, 3.05353893868, 27.0873353739],
                        [4.559e-08, 4.92224120952, 285.3723810196],
                        [4.393e-08, 4.18047835584, 5.4166259714],
                        [4.687e-08, 2.2140115321, 1029.8469142605],
                        [4.644e-08, 1.87902594973, 1433.6199914258],
                        [5.639e-08, 3.05596737234, 983.1158589136],
                        [6.045e-08, 5.68817982786, 351.8165923087],
                        [4.43e-08, 3.37768805833, 377.4194549743],
                        [4.683e-08, 2.14346624864, 97.4155158163],
                        [5.845e-08, 4.62301099402, 1024.217839968],
                        [4.536e-08, 2.45860473853, 496.0113475817],
                        [4.398e-08, 5.65312496227, 3.9321532631],
                        [4.287e-08, 0.66340266603, 1012.6508748423],
                        [4.086e-08, 0.14551174994, 385.2837615005],
                        [4.029e-08, 5.98399329775, 178.3474535379],
                        [4.276e-08, 3.6820508297, 348.8476468921],
                        [5.257e-08, 3.75263242432, 379.8671355291],
                        [4.012e-08, 0.42559540783, 104313.479530659],
                        [4.025e-08, 2.40645188238, 84.3428261229],
                        [3.957e-08, 0.86846121055, 171.9846660625],
                        [3.961e-08, 3.04953080906, 1017.3167412883],
                        [5.559e-08, 0.77714806229, 1447.8470854274],
                        [5.071e-08, 2.61075526868, 1536.7127656444],
                        [4.052e-08, 5.00014006312, 391.6465489759],
                        [5.182e-08, 4.73444634983, 382.8360809457],
                        [3.763e-08, 4.29449373755, 313.6835566709],
                        [4.038e-08, 2.82857942788, 1661.1461808654],
                        [4.067e-08, 5.7316992896, 169.5369855077],
                        [3.841e-08, 1.6258092842, 0.9632078465],
                        [3.901e-08, 2.70874386576, 14.0146456805],
                        [3.721e-08, 1.20062375429, 1026.8779688439],
                        [3.911e-08, 3.01809123569, 100.3844612329],
                        [3.489e-08, 4.28865448963, 1025.1810478145],
                        [3.714e-08, 5.05021268365, 292.4859280204],
                        [3.816e-08, 3.93084933114, 39.0962434843],
                        [3.988e-08, 2.82832650224, 134.1122628556],
                        [3.745e-08, 4.24728135115, 180.7951340927],
                        [3.836e-08, 1.02685786071, 1018.2799491348],
                        [3.941e-08, 5.21895739331, 183.7640795093],
                        [4.669e-08, 4.38080962573, 1066.49547719],
                        [3.78e-08, 6.03723468132, 1022.7333672597],
                        [3.647e-08, 3.98130320367, 608.877797677],
                        [3.456e-08, 5.54052355058, 846.0828347512],
                        [4.047e-08, 3.71041480907, 1018.0675008137],
                        [3.865e-08, 4.76002199091, 166.5680400911],
                        [3.629e-08, 3.29053233846, 447.7958195265],
                        [3.564e-08, 4.36703678321, 397.0631749473],
                        [3.304e-08, 1.49289552229, 1505.6932770074],
                        [3.976e-08, 2.42476188945, 106.0135355254],
                        [4.217e-08, 4.21677652639, 1052.2683831884],
                        [3.294e-08, 0.42088065654, 22.633917249],
                        [3.615e-08, 3.68096122231, 494.5268748734],
                        [3.23e-08, 5.10786091356, 69.1525242748],
                        [3.28e-08, 3.62226152032, 531.1754378029],
                        [3.337e-08, 2.7250287632, 481.4754370394],
                        [3.187e-08, 0.08677634706, 399.5108555021],
                        [3.389e-08, 1.79454271219, 1519.920371009],
                        [3.179e-08, 3.40418030121, 423.6292454594],
                        [3.154e-08, 3.69356460843, 470.2172884544],
                        [3.706e-08, 2.79048710497, 462.0229135281],
                        [3.136e-08, 4.38015969606, 385.4962098216],
                        [3.122e-08, 0.48346644637, 79.1868325824],
                        [3.392e-08, 0.48037804731, 521.0929453855],
                        [3.465e-08, 0.93152295589, 2183.7235989592],
                        [3.735e-08, 0.98809808606, 487.4133278726],
                        [3.998e-08, 3.38773325131, 6283.0758499914],
                        [2.998e-08, 2.61728063127, 487.6257761937],
                        [3.295e-08, 2.53821501556, 4.665866446],
                        [2.964e-08, 3.66274645375, 495.4900827199],
                        [3.901e-08, 1.65463523144, 210.3301500214],
                        [2.95e-08, 1.99904237956, 872.9095376942],
                        [2.948e-08, 2.90769224206, 391.4341006548],
                        [2.971e-08, 0.31626092637, 5.1078094307],
                        [3.085e-08, 0.95725590904, 109.9456887885],
                        [2.995e-08, 3.34433305798, 394.0942295307],
                        [3.126e-08, 5.89472116854, 105.4922706636],
                        [3.904e-08, 3.01022809543, 556.5176680376],
                        [3.388e-08, 6.24936444215, 535.3200393871],
                        [2.93e-08, 6.15005257333, 164.1203595363],
                        [3.267e-08, 4.19718045293, 518.3846323998],
                        [3.946e-08, 2.8884275967, 151.260118164],
                        [3.076e-08, 6.04134449219, 142.1408335931],
                        [2.823e-08, 0.60712626756, 214.7835681463],
                        [2.917e-08, 2.74502617182, 138.5174968707],
                        [3.347e-08, 6.09373507569, 6246.4272870619],
                        [3.659e-08, 5.12211619716, 79.2350166922],
                        [3.01e-08, 0.24656411754, 91.7864415238],
                        [2.861e-08, 6.17465663902, 422.405405182],
                        [2.989e-08, 2.31620917965, 485.9288551643],
                        [3.088e-08, 2.29186342974, 110.2063212194],
                        [3.03e-08, 3.698661491, 532.6117264014],
                        [3.02e-08, 2.36422658177, 290.2195580194],
                        [3.17e-08, 1.23078934548, 10176.6369832815],
                        [2.652e-08, 3.35836234807, 148.0787244263],
                        [2.673e-08, 6.03366372927, 196.5067008026],
                        [2.63e-08, 0.46957619348, 1970.4245035212],
                        [2.599e-08, 4.86022081674, 439.1977998174],
                        [2.878e-08, 2.61946597178, 488.5889840402],
                        [2.72e-08, 1.71836225398, 364.559213602],
                        [3.333e-08, 3.25126857354, 30.0562807905],
                        [3.053e-08, 2.49346960035, 6243.4583416453],
                        [3.062e-08, 6.23776299963, 419.4846438752],
                        [2.786e-08, 0.83078219939, 497.1870037493],
                        [2.834e-08, 3.52926079424, 457.8783119439],
                        [2.932e-08, 1.80245810977, 500.1559491659],
                        [3.03e-08, 5.10152500393, 367.9701020033],
                        [2.956e-08, 5.76230870725, 986.0848043302],
                        [3.116e-08, 2.20042242739, 495.702531041],
                        [2.554e-08, 0.65945973992, 67.3592350258],
                        [2.901e-08, 3.91891656185, 10173.6680378649],
                        [2.84e-08, 1.34453183591, 482.9599097477],
                        [2.458e-08, 1.20012815574, 489.110248902],
                        [2.556e-08, 3.86921927085, 487.1045113319],
                        [2.614e-08, 1.51881085312, 463.5073862364],
                        [2.386e-08, 4.58400538443, 615.9913446778],
                        [2.438e-08, 5.19827220476, 501.1191570124],
                        [2.537e-08, 1.64802783144, 519.6084726772],
                        [2.444e-08, 3.87859489652, 185.2485522176],
                        [2.795e-08, 4.0426575258, 255.0554677982],
                        [2.895e-08, 3.26202698812, 1646.9190868638],
                        [2.225e-08, 5.75197574692, 605.9570363702],
                        [2.324e-08, 3.99503920129, 481.2629887183],
                        [2.962e-08, 1.74151265966, 2080.6308247406],
                        [2.621e-08, 1.74442251671, 35.212274331],
                      ],
          },
          {
            series => "R2",
            terms  => [
                        [4.247412e-05, 5.89910679117, 38.1330356378],
                        [2.1757e-06, 0.3458182908, 1.4844727083],
                        [1.63025e-06, 2.2387294713, 168.0525127994],
                        [1.56285e-06, 4.59414467342, 182.279606801],
                        [1.1794e-06, 5.10295026024, 484.444382456],
                        [1.12429e-06, 1.19000583596, 498.6714764576],
                        [1.27141e-06, 2.84786298079, 35.1640902212],
                        [9.9467e-07, 3.41578558739, 175.1660598002],
                        [6.4814e-07, 3.4621406484, 388.4651552382],
                        [7.7286e-07, 0.01659281785, 491.5579294568],
                        [4.9509e-07, 4.06995509133, 76.2660712756],
                        [3.933e-07, 6.09521855958, 1021.2488945514],
                        [3.645e-07, 5.17130059988, 137.0330241624],
                        [3.708e-07, 5.97288967681, 2.9689454166],
                        [3.0484e-07, 3.58259801313, 33.6796175129],
                        [2.1099e-07, 0.76843555176, 36.6485629295],
                        [1.3886e-07, 3.59248623971, 395.578702239],
                        [1.3117e-07, 5.09263515697, 98.8999885246],
                        [1.1379e-07, 1.18060018898, 381.3516082374],
                        [9.132e-08, 2.34787658568, 601.7642506762],
                        [8.527e-08, 5.25134685897, 2.4476805548],
                        [8.136e-08, 4.96270726986, 4.4534181249],
                        [7.417e-08, 4.46775409796, 189.3931538018],
                        [7.225e-08, 1.92287508629, 9.5612275556],
                        [7.289e-08, 1.6551952578, 1028.3624415522],
                        [8.076e-08, 5.84268048311, 220.4126424388],
                        [9.654e-08, 0, 0],
                        [6.554e-08, 0.69397520733, 144.1465711632],
                        [7.782e-08, 1.14341656235, 1059.3819301892],
                        [5.665e-08, 6.25378258571, 74.7815985673],
                        [5.628e-08, 5.23383764266, 46.2097904851],
                        [5.523e-08, 4.59041448911, 1014.1353475506],
                        [5.177e-08, 5.23116646157, 477.3308354552],
                        [5.503e-08, 3.49522319102, 183.7640795093],
                        [4.878e-08, 3.52934357721, 39.6175083461],
                        [4.787e-08, 2.08260524745, 41.1019810544],
                        [5.055e-08, 0.19949888617, 166.5680400911],
                        [4.751e-08, 1.1805494827, 169.5369855077],
                        [4.747e-08, 1.50608965076, 73.297125859],
                        [6.113e-08, 6.18326155595, 71.8126531507],
                        [4.606e-08, 3.91970908886, 587.5371566746],
                        [5.756e-08, 2.23667359233, 176.6505325085],
                        [4.536e-08, 2.84337336954, 7.1135470008],
                        [4.338e-08, 0.51553847388, 446.3113468182],
                        [3.891e-08, 0.26338839265, 1550.939859646],
                        [4.465e-08, 3.01487041298, 129.9194771616],
                        [3.727e-08, 2.37977930658, 160.9389657986],
                        [3.84e-08, 3.7929038188, 111.4301614968],
                        [4.142e-08, 1.70293820961, 983.1158589136],
                        [3.296e-08, 1.07748822909, 505.7850234584],
                        [4.008e-08, 0.30663868827, 494.7393231945],
                        [3.974e-08, 5.9735178384, 488.3765357191],
                        [3.925e-08, 4.85736421123, 60.7669528868],
                        [2.966e-08, 2.01608546009, 822.176893115],
                        [3.972e-08, 1.07780371834, 374.2380612366],
                        [3.843e-08, 5.23002047199, 350.3321196004],
                        [2.848e-08, 6.17799253802, 704.8570248948],
                        [3.527e-08, 0.79317138165, 274.0660483248],
                        [2.828e-08, 1.32275775835, 386.9806825299],
                        [2.773e-08, 5.37132330836, 251.4321310758],
                        [3.113e-08, 5.1262228869, 426.598190876],
                        [3.344e-08, 5.61433537548, 1124.34166877],
                        [2.597e-08, 0.67759426519, 312.1990839626],
                        [2.581e-08, 3.55847612121, 567.8240007324],
                        [2.578e-08, 1.45603792456, 1035.475988553],
                        [2.541e-08, 5.19427579702, 1227.4344429886],
                        [2.51e-08, 4.12148891512, 171.2339065371],
                        [2.511e-08, 2.71606957319, 179.0982130633],
                        [2.342e-08, 0.96469916587, 1019.7644218431],
                        [2.5e-08, 0.7028227603, 707.7777862016],
                        [2.48e-08, 4.59623030219, 693.5506922],
                        [2.253e-08, 0.74334306011, 976.0023119128],
                      ],
          },
          {
            series => "R3",
            terms  => [
                        [1.66297e-06, 4.55243893489, 38.1330356378],
                        [2.238e-07, 3.94830879358, 168.0525127994],
                        [2.1348e-07, 2.86296778794, 182.279606801],
                        [1.6233e-07, 0.54226725872, 484.444382456],
                        [1.5623e-07, 5.75702251906, 498.6714764576],
                        [1.1867e-07, 4.4028019271, 1.4844727083],
                        [6.448e-08, 5.19003066847, 31.019488637],
                        [3.655e-08, 5.91335292846, 1007.0218005498],
                        [3.681e-08, 1.62865545676, 388.4651552382],
                        [3.198e-08, 0.70197118575, 1558.0534066468],
                        [3.243e-08, 1.8803566598, 522.5774180938],
                        [3.269e-08, 2.94301808574, 76.2660712756],
                        [2.688e-08, 1.87062743473, 402.6922492398],
                        [3.246e-08, 0.79381356193, 536.8045120954],
                        [2.65e-08, 5.76858449026, 343.2185725996],
                        [2.644e-08, 4.64542905401, 500.1559491659],
                        [2.541e-08, 4.79217120822, 482.9599097477],
                        [2.523e-08, 1.7286988978, 395.578702239],
                        [2.69e-08, 2.21096415618, 446.3113468182],
                        [2.355e-08, 5.77381398401, 485.9288551643],
                        [2.874e-08, 6.1964334054, 815.0633461142],
                        [2.278e-08, 3.66579603119, 497.1870037493],
                      ],
          },
          {
            series => "R4",
            terms  => [
                        [4.227e-08, 2.40375758563, 477.3308354552],
                        [4.333e-08, 0.10459484545, 395.578702239],
                        [3.545e-08, 4.78431259422, 1028.3624415522],
                        [3.154e-08, 3.88192942366, 505.7850234584],
                        [3.016e-08, 1.03609346831, 189.3931538018],
                        [2.294e-08, 1.10879658603, 182.279606801],
                        [2.295e-08, 5.67776133184, 168.0525127994],
                      ],
          },
        ],
      ],
      name => "VSOP87D",
      order => 8,
      sidereal_period => 5199746634.017,
      tropical_period => 5166711397.215,
    }->{$key};
}

1;

__END__

=head1 NAME

Astro::Coord::ECI::VSOP87D::Neptune - VSOP87D model of the position of Neptune

=head1 SYNOPSIS

 use Astro::Coord::ECI::VSOP87D::Neptune;
 use Astro::Coord::ECI::Utils qw{ deg2rad };
 use POSIX qw{ strftime };
 use Time::Local qw{ localtime };
 
 my $station = Astro::Coord::ECI->new(
     name => 'White House',
 )->geodetic(
     deg2rad( 38.899 ),  # radians
     deg2rad( -77.038 ), # radians
     16.68/1000,         # Kilometers
 );
 my $venus = Astro::Coord::ECI::VSOP87D::Neptune->new(
     station => $station,
 );
 my $today = timelocal( 0, 0, 0, ( localtime )[ 3 .. 5 ] );
 foreach my $item ( $venus->almanac( $today, $today + 86400 ) ) {
     local $\ = "\n";
     print strftime( '%d-%b-%Y %H:%M:%S', localtime $item->[0] ),
         $item->[3];
 }

=head1 DESCRIPTION

This Perl class computes the position of Neptune using the VSOP87D
model. It is a subclass of
L<Astro::Coord::ECI::VSOP87D::_Superior|Astro::Coord::ECI::VSOP87D::_Superior>.

=head1 METHODS

This class supports no additional public methods.

=head2 ATTRIBUTES

This class has no additional attributes.

=head1 SEE ALSO

L<Astro::Coord::ECI|Astro::Coord::ECI>

L<Astro::Coord::ECI::VSOP87D|Astro::Coord::ECI::VSOP87D>

=head1 SUPPORT

Support is by the author. Please file bug reports at
L<http://rt.cpan.org>, or in electronic mail to the author.

=head1 AUTHOR

Thomas R. Wyant, III F<wyant at cpan dot org>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2018-2019 by Thomas R. Wyant, III

This program is free software; you can redistribute it and/or modify it
under the same terms as Perl 5.10.0. For more details, see the full text
of the licenses in the directory LICENSES.

This program is distributed in the hope that it will be useful, but
without any warranty; without even the implied warranty of
merchantability or fitness for a particular purpose.

=cut

# ex: set filetype=perl textwidth=72 :
