package Sah::SchemaR::date::tz_offset;

our $DATE = '2021-08-04'; # DATE
our $VERSION = '0.016'; # VERSION

our $rschema = do{my$var={base=>"int",clsets_after_base=>[{description=>"\nOnly timezone offsets that are known to exist are allowed. For example, 1 second\n(+00:00:01) is not allowed. See `date::tz_offset_lax` for a more relaxed\nvalidation.\n\nA coercion from these form of string is provided:\n\n    UTC\n\n    UTC-14 or UTC+12 or UTC+12:45 or UTC-00:25:21\n    -14 or +12, -1400 or +12:00\n\nA coercion from timezone name is also provided.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,validated_value=>0,value=>"UTC"},{valid=>1,validated_value=>3600,value=>3600},{valid=>1,validated_value=>-43200,value=>-43200},{valid=>1,validated_value=>-43200,value=>-12},{valid=>1,validated_value=>-43200,value=>-1200},{valid=>1,validated_value=>-43200,value=>"-12:00"},{valid=>1,validated_value=>-43200,value=>"UTC-12"},{valid=>1,validated_value=>-43200,value=>"UTC-1200"},{valid=>1,validated_value=>45900,value=>"UTC+12:45"},{valid=>0,value=>"UTC-13"},{summary=>"Unknown offset",valid=>0,value=>"UTC+12:01"}],in=>[-43200,-39600,-37800,-36000,-34200,-32400,-30600,-28800,-25200,-21600,-18000,-16200,-14400,-12600,-10800,-9000,-7200,-3600,-2640,-1521,0,0,1200,1800,3600,5040,5400,7200,9000,10800,12600,14400,16200,17460,18000,19800,20400,20700,21600,23400,25200,26400,27000,28800,30600,31500,32400,34200,35100,36000,37800,39600,41400,43200,45900,46800,49500,50400],summary=>"Timezone offset in seconds from UTC","x.completion"=>sub{package Sah::Schema::date::tz_offset;require Complete::TZ;require Complete::Util;my(%args) = @_;Complete::Util::combine_answers(Complete::TZ::complete_tz_offset('word', $args{'word'}), Complete::TZ::complete_tz_name('word', $args{'word'}))},"x.perl.coerce_rules"=>["From_str::tz_offset_strings"]}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["int"],type=>"int",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Timezone offset in seconds from UTC

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::date::tz_offset - Timezone offset in seconds from UTC

=head1 VERSION

This document describes version 0.016 of Sah::SchemaR::date::tz_offset (from Perl distribution Sah-Schemas-Date), released on 2021-08-04.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Date>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Date>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Date>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020, 2019 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
