package Bencher::Scenario::List::Utils::MoveElement::move_element_to_beginning;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-07-23'; # DATE
our $DIST = 'Bencher-Scenarios-List-Utils-MoveElement'; # DIST
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;

our $scenario = {
    summary => "Benchmark move_to_beginning()",
    participants => [
        {fcall_template=>'List::Utils::MoveElement::move_element_to_beginning(<i>, @{<array>})', result_is_list=>1},
        {fcall_template=>'List::Utils::MoveElement::PP::to_beginning(<i>, @{<array>})', result_is_list=>1},
        {fcall_template=>'List::Utils::MoveElement::Splice::to_beginning_copy(<i>, @{<array>})', result_is_list=>1},
        {fcall_template=>'List::Utils::MoveElement::Splice::to_beginning_nocopy(<i>, @{<array>})', result_is_list=>1},
    ],
    datasets => [
        {name=>'a1_1'       , args=>{i=>1, array=>[qw/a b/]}, result=>[qw/b a/]},
        {name=>'a5_10'      , args=>{i=>5, array=>[(('a') x 5), 'b', (('a') x 4)]}, result=>['b', (('a') x 9)]},
        {name=>'a500_1000'  , args=>{i=>500, array=>[(('a') x 500), 'b', (('a') x 499)]}, result=>['b', (('a') x 999)]},
        {name=>'a5000_10000', args=>{i=>5000, array=>[(('a') x 5000), 'b', (('a') x 4999)]}, result=>['b', (('a') x 9999)]},
    ],
};

1;
# ABSTRACT: Benchmark move_to_beginning()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::List::Utils::MoveElement::move_element_to_beginning - Benchmark move_to_beginning()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::List::Utils::MoveElement::move_element_to_beginning (from Perl distribution Bencher-Scenarios-List-Utils-MoveElement), released on 2021-07-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m List::Utils::MoveElement::move_element_to_beginning

To run module startup overhead benchmark:

 % bencher --module-startup -m List::Utils::MoveElement::move_element_to_beginning

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<List::Utils::MoveElement> 0.02

L<List::Utils::MoveElement::PP>

L<List::Utils::MoveElement::Splice>

=head1 BENCHMARK PARTICIPANTS

=over

=item * List::Utils::MoveElement::move_element_to_beginning (perl_code)

Function call template:

 List::Utils::MoveElement::move_element_to_beginning(<i>, @{<array>})



=item * List::Utils::MoveElement::PP::to_beginning (perl_code)

Function call template:

 List::Utils::MoveElement::PP::to_beginning(<i>, @{<array>})



=item * List::Utils::MoveElement::Splice::to_beginning_copy (perl_code)

Function call template:

 List::Utils::MoveElement::Splice::to_beginning_copy(<i>, @{<array>})



=item * List::Utils::MoveElement::Splice::to_beginning_nocopy (perl_code)

Function call template:

 List::Utils::MoveElement::Splice::to_beginning_nocopy(<i>, @{<array>})



=back

=head1 BENCHMARK DATASETS

=over

=item * a1_1

=item * a5_10

=item * a500_1000

=item * a5000_10000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.30.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux LinuxMint version 19 >>, OS kernel: I<< Linux version 5.3.0-68-generic >>.

Benchmark with default options (C<< bencher -m List::Utils::MoveElement::move_element_to_beginning >>):

 #table1#
 +-------------------------------------------------------+-------------+-------------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                                           | dataset     | rate (/s)   | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +-------------------------------------------------------+-------------+-------------+-----------+-----------------------+-----------------------+---------+---------+
 | List::Utils::MoveElement::move_element_to_beginning   | a5000_10000 |    1050     | 955       |                 0.00% |            181358.12% | 1.6e-07 |      20 |
 | List::Utils::MoveElement::PP::to_beginning            | a5000_10000 |    1050     | 955       |                 0.09% |            181195.12% | 2.1e-07 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a5000_10000 |    1232     | 811.6     |                17.73% |            154029.78% | 5.3e-08 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a5000_10000 |    2276.946 | 439.1848  |               117.55% |             83307.94% | 1.7e-11 |      20 |
 | List::Utils::MoveElement::move_element_to_beginning   | a500_1000   |   10400     |  96.3     |               891.74% |             18197.00% | 2.2e-08 |      30 |
 | List::Utils::MoveElement::PP::to_beginning            | a500_1000   |   10400     |  96       |               894.79% |             18140.76% | 2.7e-08 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a500_1000   |   12283.82  |  81.40793 |              1073.68% |             15360.62% | 5.5e-12 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a500_1000   |   20000     |  49       |              1854.06% |              9186.20% | 5.3e-08 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a5_10       |  159968     |   6.25126 |             15184.40% |              1087.21% | 5.6e-12 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a1_1        |  169600     |   5.8962  |             16104.71% |              1019.79% | 1.7e-11 |      20 |
 | List::Utils::MoveElement::PP::to_beginning            | a5_10       |  750100     |   1.333   |             71568.61% |               153.19% | 1.7e-11 |      22 |
 | List::Utils::MoveElement::move_element_to_beginning   | a5_10       |  750300     |   1.333   |             71589.74% |               153.12% | 1.5e-11 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a5_10       |  833300     |   1.2     |             79518.83% |               127.91% | 1.7e-11 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a1_1        | 1877000     |   0.5328  |            179246.24% |                 1.18% | 1.7e-11 |      20 |
 | List::Utils::MoveElement::move_element_to_beginning   | a1_1        | 1893000     |   0.5282  |            180801.29% |                 0.31% | 5.8e-12 |      20 |
 | List::Utils::MoveElement::PP::to_beginning            | a1_1        | 1900000     |   0.527   |            181358.12% |                 0.00% | 2.1e-10 |      20 |
 +-------------------------------------------------------+-------------+-------------+-----------+-----------------------+-----------------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m List::Utils::MoveElement::move_element_to_beginning --module-startup >>):

 #table2#
 +----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | participant                      | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | List::Utils::MoveElement         |      10   |               5   |                 0.00% |               141.40% |   0.0002  |      20 |
 | List::Utils::MoveElement::PP     |       8   |               3   |                30.83% |                84.51% |   0.00014 |      22 |
 | perl -e1 (baseline)              |       5   |               0   |               135.37% |                 2.56% |   0.0002  |      21 |
 | List::Utils::MoveElement::Splice |       4.5 |              -0.5 |               141.40% |                 0.00% | 4.2e-05   |      20 |
 +----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 BENCHMARK NOTES

Using copy+splice+unshift (L<List::Utils::MoveElement::Splice>) is faster. And
we can get significantly faster still with larger list by avoiding copying
C<@_>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-List-Utils-MoveElement>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-List-Utils-MoveElement>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-List-Utils-MoveElement>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
