package Bencher::Scenario::CloneModules::Startup;

our $DATE = '2021-07-31'; # DATE
our $VERSION = '0.050'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup of various data cloning modules',
    module_startup => 1,
    modules => {
        'Clone::Util' => {version=>0.03},
    },
    participants => [
        {module=>'Clone'},
        {module=>'Clone::PP'},
        #{module=>'Clone::Any'}, # i no longer recommend using this
        {module=>'Clone::Util'},
        {module=>'Data::Clone'},
        {module=>'Function::Fallback::CoreOrPP'},
        {module=>'Sereal::Dclone'},
        {module=>'Storable'},
    ],
    #datasets => [
    #],
    on_failure => 'skip',
};

1;
# ABSTRACT: Benchmark startup of various data cloning modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::CloneModules::Startup - Benchmark startup of various data cloning modules

=head1 VERSION

This document describes version 0.050 of Bencher::Scenario::CloneModules::Startup (from Perl distribution Bencher-Scenarios-CloneModules), released on 2021-07-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m CloneModules::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Clone> 0.45

L<Clone::PP> 1.08

L<Clone::Util> 0.03

L<Data::Clone> 0.004

L<Function::Fallback::CoreOrPP> 0.090

L<Sereal::Dclone> 0.003

L<Storable> 3.23

=head1 BENCHMARK PARTICIPANTS

=over

=item * Clone (perl_code)

L<Clone>



=item * Clone::PP (perl_code)

L<Clone::PP>



=item * Clone::Util (perl_code)

L<Clone::Util>



=item * Data::Clone (perl_code)

L<Data::Clone>



=item * Function::Fallback::CoreOrPP (perl_code)

L<Function::Fallback::CoreOrPP>



=item * Sereal::Dclone (perl_code)

L<Sereal::Dclone>



=item * Storable (perl_code)

L<Storable>



=back

=head1 BENCHMARK SAMPLE RESULTS

=head2 Sample benchmark #1

Run on: perl: I<< v5.34.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux LinuxMint version 19 >>, OS kernel: I<< Linux version 5.3.0-68-generic >>.

Benchmark command (cloning a 10k-element array):

 % bencher -m CloneModules::Startup --include-datasets array10k

Result formatted as table:

 #table1#
 +------------------------------+-----------+-------------------+-----------------------+-----------------------+---------+---------+
 | participant                  | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +------------------------------+-----------+-------------------+-----------------------+-----------------------+---------+---------+
 | Storable                     |        10 |                 5 |                 0.00% |               145.33% | 0.00022 |      20 |
 | Sereal::Dclone               |        10 |                 5 |                 0.80% |               143.39% | 0.00032 |      21 |
 | Clone                        |        10 |                 5 |                34.36% |                82.59% | 0.00014 |      20 |
 | Clone::PP                    |         9 |                 4 |                51.75% |                61.67% | 0.00016 |      20 |
 | Clone::Util                  |         8 |                 3 |                66.17% |                47.64% | 0.00014 |      20 |
 | Function::Fallback::CoreOrPP |         7 |                 2 |                73.07% |                41.75% | 0.00014 |      20 |
 | Data::Clone                  |         7 |                 2 |                85.98% |                31.91% | 0.00014 |      20 |
 | perl -e1 (baseline)          |         5 |                 0 |               145.33% |                 0.00% | 0.00018 |      21 |
 +------------------------------+-----------+-------------------+-----------------------+-----------------------+---------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

                          Rate     S   S:D     C  C:P   C:U  FF:C   D:C  perl -e1 (baseline) 
  S                    100.0/s    --    0%    0%  -9%  -19%  -30%  -30%                 -50% 
  S:D                  100.0/s    0%    --    0%  -9%  -19%  -30%  -30%                 -50% 
  C                    100.0/s    0%    0%    --  -9%  -19%  -30%  -30%                 -50% 
  C:P                  111.1/s   11%   11%   11%   --  -11%  -22%  -22%                 -44% 
  C:U                  125.0/s   25%   25%   25%  12%    --  -12%  -12%                 -37% 
  FF:C                 142.9/s   42%   42%   42%  28%   14%    --    0%                 -28% 
  D:C                  142.9/s   42%   42%   42%  28%   14%    0%    --                 -28% 
  perl -e1 (baseline)  200.0/s  100%  100%  100%  80%   60%   39%   39%                   -- 
 
 Legends:
   C: mod_overhead_time=5 participant=Clone
   C:P: mod_overhead_time=4 participant=Clone::PP
   C:U: mod_overhead_time=3 participant=Clone::Util
   D:C: mod_overhead_time=2 participant=Data::Clone
   FF:C: mod_overhead_time=2 participant=Function::Fallback::CoreOrPP
   S: mod_overhead_time=5 participant=Storable
   S:D: mod_overhead_time=5 participant=Sereal::Dclone
   perl -e1 (baseline): mod_overhead_time=0 participant=perl -e1 (baseline)

The above result presented as chart:

#IMAGE: share/images/bencher-result-1.png|/tmp/stQrYN5WkQ/bencher-result-1.png

=head2 Sample benchmark #2

Benchmark command (cloning a 10k-pair hash):

 % bencher -m CloneModules::Startup --include-datasets hash10k

Result formatted as table:

 #table2#
 +------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | participant                  | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | Storable                     |        10 |                 5 |                 0.00% |               161.00% |   0.00015 |      22 |
 | Sereal::Dclone               |        12 |                 7 |                 6.44% |               145.21% | 6.4e-05   |      20 |
 | Clone                        |        10 |                 5 |                27.43% |               104.82% |   0.00018 |      21 |
 | Function::Fallback::CoreOrPP |         8 |                 3 |                46.41% |                78.27% |   0.00019 |      20 |
 | Clone::PP                    |         8 |                 3 |                48.73% |                75.48% |   0.00011 |      20 |
 | Clone::Util                  |         8 |                 3 |                59.79% |                63.34% |   0.00012 |      20 |
 | Data::Clone                  |         7 |                 2 |                73.17% |                50.72% | 9.5e-05   |      20 |
 | perl -e1 (baseline)          |         5 |                 0 |               161.00% |                 0.00% |   0.00018 |      20 |
 +------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+


The above result formatted in L<Benchmark.pm|Benchmark> style:

                          Rate   S:D     S     C  FF:C   C:P   C:U   D:C  perl -e1 (baseline) 
  S:D                   83.3/s    --  -16%  -16%  -33%  -33%  -33%  -41%                 -58% 
  S                    100.0/s   19%    --    0%  -19%  -19%  -19%  -30%                 -50% 
  C                    100.0/s   19%    0%    --  -19%  -19%  -19%  -30%                 -50% 
  FF:C                 125.0/s   50%   25%   25%    --    0%    0%  -12%                 -37% 
  C:P                  125.0/s   50%   25%   25%    0%    --    0%  -12%                 -37% 
  C:U                  125.0/s   50%   25%   25%    0%    0%    --  -12%                 -37% 
  D:C                  142.9/s   71%   42%   42%   14%   14%   14%    --                 -28% 
  perl -e1 (baseline)  200.0/s  140%  100%  100%   60%   60%   60%   39%                   -- 
 
 Legends:
   C: mod_overhead_time=5 participant=Clone
   C:P: mod_overhead_time=3 participant=Clone::PP
   C:U: mod_overhead_time=3 participant=Clone::Util
   D:C: mod_overhead_time=2 participant=Data::Clone
   FF:C: mod_overhead_time=3 participant=Function::Fallback::CoreOrPP
   S: mod_overhead_time=5 participant=Storable
   S:D: mod_overhead_time=7 participant=Sereal::Dclone
   perl -e1 (baseline): mod_overhead_time=0 participant=perl -e1 (baseline)

The above result presented as chart:

#IMAGE: share/images/bencher-result-2.png|/tmp/stQrYN5WkQ/bencher-result-2.png

To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-CloneModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-CloneModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-CloneModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2017, 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
