package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-11'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20231211.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'ETHER' => '',
    'PEVANS' => '',
    'SKIM' => '',
    'JRM' => '',
    'KIMOTO' => '',
    'DERF' => '',
    'BDFOY' => '',
    'JJATRIA' => '',
    'UTASHIRO' => '',
    'DORNER' => '',
    'RKAPL' => '',
    'DDUMONT' => '',
    'AJNN' => '',
    'PJACKLAM' => '',
    'SIDNEY' => '',
    'BINGOS' => '',
    'DJERIUS' => '',
    'JMATES' => '',
    'RRWO' => '',
    'PACMAN' => '',
    'VVELOX' => '',
    'ABALAMA' => '',
    'EMUNDALL' => '',
    'GSG' => '',
    'JGOMEZ' => '',
    'LEEJO' => '',
    'OALDERS' => '',
    'SHLOMIF' => '',
    'WYANT' => '',
    'JDEGUEST' => '',
    'SREZIC' => '',
    'AAHAZRED' => '',
    'ABRAXXA' => '',
    'ASPOSE' => '',
    'BURAK' => '',
    'CGPAN' => '',
    'DCHURCH' => '',
    'DRCLAW' => '',
    'FREED' => '',
    'GBROWN' => '',
    'GDT' => '',
    'GRYPHON' => '',
    'HKOBA' => '',
    'JAVONET' => '',
    'JGNI' => '',
    'MERKYS' => '',
    'MICHIELB' => '',
    'OLIVER' => '',
    'OODLER' => '',
    'OVID' => '',
    'PMPERRY' => '',
    'TEAM' => '',
    'TEODESIAN' => '',
    'TURNSTEP' => '',
    'YANGAK' => '',
    'ZHMYLOVE' => '',
    'DAKKAR' => '',
    'DCANTRELL' => '',
    'DROLSKY' => '',
    'JV' => '',
    'YTURTLE' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20231211.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2023-12-11.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2023-12-11, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 486 | 2014-08-24 | ongoing     |
  | ETHER     |  91 | 2022-03-20 | ongoing     |
  | PEVANS    |  23 | 2023-07-02 | might-break |
  | SKIM      |   9 | 2023-10-15 | ongoing     |
  | JRM       |   8 | 2023-10-22 | ongoing     |
  | KIMOTO    |   7 | 2023-10-22 | might-break |
  | DERF      |   7 | 2023-10-29 | ongoing     |
  | BDFOY     |   6 | 2023-10-29 | might-break |
  | JJATRIA   |   6 | 2023-10-29 | might-break |
  | UTASHIRO  |   6 | 2023-11-05 | ongoing     |
  | DORNER    |   5 | 2023-11-05 | might-break |
  | RKAPL     |   5 | 2023-11-05 | might-break |
  | DDUMONT   |   5 | 2023-11-12 | ongoing     |
  | AJNN      |   4 | 2023-11-12 | might-break |
  | PJACKLAM  |   4 | 2023-11-12 | might-break |
  | SIDNEY    |   4 | 2023-11-19 | ongoing     |
  | BINGOS    |   3 | 2023-11-19 | might-break |
  | DJERIUS   |   3 | 2023-11-19 | might-break |
  | JMATES    |   3 | 2023-11-19 | might-break |
  | RRWO      |   3 | 2023-11-19 | might-break |
  | PACMAN    |   3 | 2023-11-26 | ongoing     |
  | VVELOX    |   3 | 2023-11-26 | ongoing     |
  | ABALAMA   |   2 | 2023-11-26 | might-break |
  | EMUNDALL  |   2 | 2023-11-26 | might-break |
  | GSG       |   2 | 2023-11-26 | might-break |
  | JGOMEZ    |   2 | 2023-11-26 | might-break |
  | LEEJO     |   2 | 2023-11-26 | might-break |
  | OALDERS   |   2 | 2023-11-26 | might-break |
  | SHLOMIF   |   2 | 2023-11-26 | might-break |
  | WYANT     |   2 | 2023-11-26 | might-break |
  | JDEGUEST  |   2 | 2023-12-03 | ongoing     |
  | SREZIC    |   2 | 2023-12-03 | ongoing     |
  | AAHAZRED  |   1 | 2023-12-03 | might-break |
  | ABRAXXA   |   1 | 2023-12-03 | might-break |
  | ASPOSE    |   1 | 2023-12-03 | might-break |
  | BURAK     |   1 | 2023-12-03 | might-break |
  | CGPAN     |   1 | 2023-12-03 | might-break |
  | DCHURCH   |   1 | 2023-12-03 | might-break |
  | DRCLAW    |   1 | 2023-12-03 | might-break |
  | FREED     |   1 | 2023-12-03 | might-break |
  | GBROWN    |   1 | 2023-12-03 | might-break |
  | GDT       |   1 | 2023-12-03 | might-break |
  | GRYPHON   |   1 | 2023-12-03 | might-break |
  | HKOBA     |   1 | 2023-12-03 | might-break |
  | JAVONET   |   1 | 2023-12-03 | might-break |
  | JGNI      |   1 | 2023-12-03 | might-break |
  | MERKYS    |   1 | 2023-12-03 | might-break |
  | MICHIELB  |   1 | 2023-12-03 | might-break |
  | OLIVER    |   1 | 2023-12-03 | might-break |
  | OODLER    |   1 | 2023-12-03 | might-break |
  | OVID      |   1 | 2023-12-03 | might-break |
  | PMPERRY   |   1 | 2023-12-03 | might-break |
  | TEAM      |   1 | 2023-12-03 | might-break |
  | TEODESIAN |   1 | 2023-12-03 | might-break |
  | TURNSTEP  |   1 | 2023-12-03 | might-break |
  | YANGAK    |   1 | 2023-12-03 | might-break |
  | ZHMYLOVE  |   1 | 2023-12-03 | might-break |
  | DAKKAR    |   1 | 2023-12-10 | ongoing     |
  | DCANTRELL |   1 | 2023-12-10 | ongoing     |
  | DROLSKY   |   1 | 2023-12-10 | ongoing     |
  | JV        |   1 | 2023-12-10 | ongoing     |
  | YTURTLE   |   1 | 2023-12-10 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
