package Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::AllTime;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-12-11'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20231211.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'MGV' => '',
    'KENTNL' => '',
    'ETHER' => '',
    'TOBYINK' => '',
    'BINGOS' => '',
    'NEILB' => '',
    'RJBS' => '',
    'ADAMK' => '',
    'SHARYANTO' => '',
    'TOKUHIROM' => '',
    'RCLAMP' => '',
    'GUGOD' => '',
    'BOBTFISH' => '',
    'FAYLAND' => '',
    'PLICEASE' => '',
    'NUFFIN' => '',
    'MSCHWERN' => '',
    'MIYAGAWA' => '',
    'SIMON' => '',
    'KAZEBURO' => '',
    'JHTHORSEN' => '',
    'SKIM' => '',
    'GFUJI' => '',
    'SARTAK' => '',
    'FLORA' => '',
    'LEONT' => '',
    'BARBIE' => '',
    'BINARY' => '',
    'INGY' => '',
    'XERN' => '',
    'SRI' => '',
    'ANDYA' => '',
    'PEVANS' => '',
    'DOY' => '',
    'DBOOK' => '',
    'CWEST' => '',
    'MRAMBERG' => '',
    'LEOCHARRE' => '',
    'TSIBLEY' => '',
    'MANWAR' => '',
    'ETJ' => '',
    'AUTRIJUS' => '',
    'STEVAN' => '',
    'DAVEBAIRD' => '',
    'DMAKI' => '',
    'VVELOX' => '',
    'MOZNION' => '',
    'CHENGANG' => '',
    'ITUB' => '',
    'CRAKRJACK' => '',
    'SMUELLER' => '',
    'JROCKWAY' => '',
    'YAPPO' => '',
    'XSAWYERX' => '',
    'GETTY' => '',
    'DROLSKY' => '',
    'YTURTLE' => '',
    'BPS' => '',
    'JPRIT' => '',
    'TMTM' => '',
    'PIJLL' => '',
    'TBONE' => '',
    'SIMONW' => '',
    'SHLOMIF' => '',
    'LYOKATO' => '',
    'DMUEY' => '',
    'HIO' => '',
    'ZIGOROU' => '',
    'GPHAT' => '',
    'AWNCORP' => '',
    'RWSTAUNER' => '',
    'RSAVAGE' => '',
    'MSTROUT' => '',
    'DAGOLDEN' => '',
    'YANICK' => '',
    'SONGMU' => '',
    'CSSON' => '',
    'STEVEB' => '',
    'ATHREEF' => '',
    'ILYAZ' => '',
    'JWIED' => '',
    'DOUGM' => '',
    'SBURKE' => '',
    'KAKE' => '',
    'LGODDARD' => '',
    'LBROCARD' => '',
    'SALVA' => '',
    'GEOTIGER' => '',
    'TYPESTER' => '',
    'BRICAS' => '',
    'NEKOKAK' => '',
    'FERREIRA' => '',
    'MSCHILLI' => '',
    'MARKSTOS' => '',
    'RKRIMEN' => '',
    'KRYDE' => '',
    'KITANO' => '',
    'ZOFFIX' => '',
    'SZABGAB' => '',
    'KIMOTO' => '',
    'CORNELIUS' => '',
    'AZAWAWI' => '',
    'FREW' => '',
    'RUZ' => '',
    'AVAR' => '',
    'TODDR' => '',
    'FRANCKC' => '',
    'DAVIDP' => '',
    'AMBS' => '',
    'GRAY' => '',
    'MNUNBERG' => '',
    'BAYASHI' => '',
    'JBERGER' => '',
    'BKB' => '',
    'ALEXMV' => '',
    'JJNAPIORK' => '',
    'RSRCHBOY' => '',
    'MELEZHIK' => '',
    'SYSPETE' => '',
    'LNATION' => '',
    'PRBRENAN' => '',
    'GENE' => '',
    'RENEEB' => '',
    'ATOOMIC' => '',
    'SRCHULO' => '',
    'UTASHIRO' => '',
    'BRTASTIC' => '',
    'TIMLEGGE' => '',
);


1;
# ABSTRACT: Authors with all-time monthly new distributions streak (release a new distribution every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::AllTime - Authors with all-time monthly new distributions streak (release a new distribution every month)

=head1 VERSION

This document describes version 20231211.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyNewDistributions::AllTime (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2023-12-11.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2023-12-11, produced by L<cpan-streaks>, only streaks with length of at least 6 are included):

  +-----------+-----+------------+----------+-------------+
  | author    | len | start_date | end_date | status      |
  +-----------+-----+------------+----------+-------------+
  | PERLANCAR | 113 | 2014-08    |          | ongoing     |
  | MGV       |  53 | 2014-01    | 2018-05  | broken      |
  | KENTNL    |  46 | 2013-01    | 2016-10  | broken      |
  | ETHER     |  36 | 2013-01    | 2015-12  | broken      |
  | TOBYINK   |  27 | 2011-09    | 2013-11  | broken      |
  | BINGOS    |  23 | 2006-09    | 2008-07  | broken      |
  | NEILB     |  22 | 2013-11    | 2015-08  | broken      |
  | RJBS      |  21 | 2006-02    | 2007-10  | broken      |
  | ADAMK     |  20 | 2004-06    | 2006-01  | broken      |
  | RJBS      |  20 | 2008-08    | 2010-03  | broken      |
  | SHARYANTO |  19 | 2010-10    | 2012-04  | broken      |
  | TOKUHIROM |  18 | 2012-06    | 2013-11  | broken      |
  | RCLAMP    |  17 | 2003-04    | 2004-08  | broken      |
  | GUGOD     |  17 | 2004-06    | 2005-10  | broken      |
  | BOBTFISH  |  17 | 2008-12    | 2010-04  | broken      |
  | BINGOS    |  17 | 2009-07    | 2010-11  | broken      |
  | FAYLAND   |  16 | 2008-09    | 2009-12  | broken      |
  | PLICEASE  |  16 | 2015-01    | 2016-04  | broken      |
  | NUFFIN    |  15 | 2007-12    | 2009-02  | broken      |
  | SHARYANTO |  15 | 2013-07    | 2014-09  | broken      |
  | MSCHWERN  |  14 | 2000-11    | 2001-12  | broken      |
  | ADAMK     |  14 | 2008-12    | 2010-01  | broken      |
  | MIYAGAWA  |  14 | 2009-02    | 2010-03  | broken      |
  | SIMON     |  13 | 2003-08    | 2004-08  | broken      |
  | KAZEBURO  |  13 | 2012-04    | 2013-04  | broken      |
  | PLICEASE  |  13 | 2012-12    | 2013-12  | broken      |
  | JHTHORSEN |  13 | 2013-04    | 2014-04  | broken      |
  | SKIM      |  13 | 2014-04    | 2015-04  | broken      |
  | GFUJI     |  12 | 2008-06    | 2009-05  | broken      |
  | SARTAK    |  12 | 2008-10    | 2009-09  | broken      |
  | FLORA     |  12 | 2010-01    | 2010-12  | broken      |
  | LEONT     |  12 | 2011-01    | 2011-12  | broken      |
  | SHARYANTO |  12 | 2012-06    | 2013-05  | broken      |
  | BARBIE    |  12 | 2014-03    | 2015-02  | broken      |
  | BINARY    |  12 | 2014-05    | 2015-04  | broken      |
  | INGY      |  12 | 2014-05    | 2015-04  | broken      |
  | XERN      |  11 | 2002-11    | 2003-09  | broken      |
  | SRI       |  11 | 2004-08    | 2005-06  | broken      |
  | ANDYA     |  11 | 2007-09    | 2008-07  | broken      |
  | PEVANS    |  11 | 2010-08    | 2011-06  | broken      |
  | DOY       |  11 | 2010-09    | 2011-07  | broken      |
  | DBOOK     |  11 | 2015-01    | 2015-11  | broken      |
  | CWEST     |  10 | 2004-05    | 2005-02  | broken      |
  | MRAMBERG  |  10 | 2005-07    | 2006-04  | broken      |
  | LEOCHARRE |  10 | 2008-06    | 2009-03  | broken      |
  | FLORA     |  10 | 2009-02    | 2009-11  | broken      |
  | TSIBLEY   |  10 | 2012-08    | 2013-05  | broken      |
  | TOBYINK   |  10 | 2014-01    | 2014-10  | broken      |
  | MANWAR    |  10 | 2015-08    | 2016-05  | broken      |
  | ETJ       |  10 | 2020-05    | 2021-02  | broken      |
  | PEVANS    |  10 | 2021-03    | 2021-12  | broken      |
  | SKIM      |  10 | 2023-03    |          | ongoing     |
  | MIYAGAWA  |   9 | 2001-05    | 2002-01  | broken      |
  | AUTRIJUS  |   9 | 2003-07    | 2004-03  | broken      |
  | STEVAN    |   9 | 2004-03    | 2004-11  | broken      |
  | DAVEBAIRD |   9 | 2005-04    | 2005-12  | broken      |
  | DMAKI     |   9 | 2007-08    | 2008-04  | broken      |
  | VVELOX    |   9 | 2008-09    | 2009-05  | broken      |
  | MOZNION   |   9 | 2013-04    | 2013-12  | broken      |
  | CHENGANG  |   9 | 2014-01    | 2014-09  | broken      |
  | MANWAR    |   9 | 2014-09    | 2015-05  | broken      |
  | AUTRIJUS  |   8 | 2002-08    | 2003-03  | broken      |
  | ITUB      |   8 | 2004-02    | 2004-09  | broken      |
  | AUTRIJUS  |   8 | 2004-05    | 2004-12  | broken      |
  | CRAKRJACK |   8 | 2005-10    | 2006-05  | broken      |
  | ADAMK     |   8 | 2006-03    | 2006-10  | broken      |
  | SMUELLER  |   8 | 2006-06    | 2007-01  | broken      |
  | JROCKWAY  |   8 | 2006-07    | 2007-02  | broken      |
  | TOKUHIROM |   8 | 2007-11    | 2008-06  | broken      |
  | ADAMK     |   8 | 2008-03    | 2008-10  | broken      |
  | YAPPO     |   8 | 2008-03    | 2008-10  | broken      |
  | PEVANS    |   8 | 2009-11    | 2010-06  | broken      |
  | XSAWYERX  |   8 | 2009-12    | 2010-07  | broken      |
  | GETTY     |   8 | 2010-10    | 2011-05  | broken      |
  | TOKUHIROM |   8 | 2010-10    | 2011-05  | broken      |
  | DROLSKY   |   8 | 2010-11    | 2011-06  | broken      |
  | INGY      |   8 | 2011-05    | 2011-12  | broken      |
  | YTURTLE   |   8 | 2013-04    | 2013-11  | broken      |
  | JHTHORSEN |   8 | 2014-06    | 2015-01  | broken      |
  | BPS       |   8 | 2016-02    | 2016-09  | broken      |
  | DBOOK     |   8 | 2018-09    | 2019-04  | broken      |
  | PLICEASE  |   8 | 2020-02    | 2020-09  | broken      |
  | PLICEASE  |   8 | 2021-03    | 2021-10  | broken      |
  | TOBYINK   |   8 | 2022-06    | 2023-01  | broken      |
  | JPRIT     |   7 | 1998-09    | 1999-03  | broken      |
  | TMTM      |   7 | 2001-06    | 2001-12  | broken      |
  | PIJLL     |   7 | 2003-02    | 2003-08  | broken      |
  | TBONE     |   7 | 2003-07    | 2004-01  | broken      |
  | BINGOS    |   7 | 2004-08    | 2005-02  | broken      |
  | SIMONW    |   7 | 2004-10    | 2005-04  | broken      |
  | SHLOMIF   |   7 | 2005-02    | 2005-08  | broken      |
  | LYOKATO   |   7 | 2005-06    | 2005-12  | broken      |
  | TOKUHIROM |   7 | 2005-09    | 2006-03  | broken      |
  | INGY      |   7 | 2006-01    | 2006-07  | broken      |
  | SHLOMIF   |   7 | 2006-03    | 2006-09  | broken      |
  | DMUEY     |   7 | 2006-06    | 2006-12  | broken      |
  | HIO       |   7 | 2006-09    | 2007-03  | broken      |
  | MIYAGAWA  |   7 | 2006-12    | 2007-06  | broken      |
  | LEOCHARRE |   7 | 2007-03    | 2007-09  | broken      |
  | ZIGOROU   |   7 | 2007-04    | 2007-10  | broken      |
  | ADAMK     |   7 | 2007-05    | 2007-11  | broken      |
  | RJBS      |   7 | 2007-12    | 2008-06  | broken      |
  | SARTAK    |   7 | 2008-02    | 2008-08  | broken      |
  | PEVANS    |   7 | 2008-10    | 2009-04  | broken      |
  | DOY       |   7 | 2009-04    | 2009-10  | broken      |
  | KENTNL    |   7 | 2009-05    | 2009-11  | broken      |
  | GPHAT     |   7 | 2009-07    | 2010-01  | broken      |
  | AWNCORP   |   7 | 2010-07    | 2011-01  | broken      |
  | RWSTAUNER |   7 | 2010-10    | 2011-04  | broken      |
  | RSAVAGE   |   7 | 2011-04    | 2011-10  | broken      |
  | BINGOS    |   7 | 2011-05    | 2011-11  | broken      |
  | MSTROUT   |   7 | 2011-11    | 2012-05  | broken      |
  | BOBTFISH  |   7 | 2012-02    | 2012-08  | broken      |
  | DAGOLDEN  |   7 | 2012-12    | 2013-06  | broken      |
  | YANICK    |   7 | 2013-02    | 2013-08  | broken      |
  | SKIM      |   7 | 2013-05    | 2013-11  | broken      |
  | SONGMU    |   7 | 2013-05    | 2013-11  | broken      |
  | SONGMU    |   7 | 2014-03    | 2014-09  | broken      |
  | CSSON     |   7 | 2014-11    | 2015-05  | broken      |
  | RJBS      |   7 | 2015-02    | 2015-08  | broken      |
  | NEILB     |   7 | 2015-10    | 2016-04  | broken      |
  | STEVEB    |   7 | 2017-01    | 2017-07  | broken      |
  | ATHREEF   |   7 | 2017-06    | 2017-12  | broken      |
  | PLICEASE  |   7 | 2018-12    | 2019-06  | broken      |
  | AWNCORP   |   7 | 2020-02    | 2020-08  | broken      |
  | BPS       |   7 | 2022-01    | 2022-07  | broken      |
  | ILYAZ     |   6 | 1998-02    | 1998-07  | broken      |
  | JWIED     |   6 | 1998-02    | 1998-07  | broken      |
  | DOUGM     |   6 | 1999-06    | 1999-11  | broken      |
  | SBURKE    |   6 | 2000-07    | 2000-12  | broken      |
  | SIMON     |   6 | 2002-04    | 2002-09  | broken      |
  | KAKE      |   6 | 2003-01    | 2003-06  | broken      |
  | LGODDARD  |   6 | 2003-02    | 2003-07  | broken      |
  | LBROCARD  |   6 | 2003-10    | 2004-03  | broken      |
  | RJBS      |   6 | 2004-06    | 2004-11  | broken      |
  | TMTM      |   6 | 2004-08    | 2005-01  | broken      |
  | INGY      |   6 | 2005-01    | 2005-06  | broken      |
  | SALVA     |   6 | 2005-02    | 2005-07  | broken      |
  | GEOTIGER  |   6 | 2005-03    | 2005-08  | broken      |
  | TYPESTER  |   6 | 2005-07    | 2005-12  | broken      |
  | BRICAS    |   6 | 2005-08    | 2006-01  | broken      |
  | NEKOKAK   |   6 | 2005-09    | 2006-02  | broken      |
  | FERREIRA  |   6 | 2006-05    | 2006-10  | broken      |
  | MIYAGAWA  |   6 | 2006-05    | 2006-10  | broken      |
  | NUFFIN    |   6 | 2006-05    | 2006-10  | broken      |
  | PEVANS    |   6 | 2006-07    | 2006-12  | broken      |
  | MSCHILLI  |   6 | 2007-02    | 2007-07  | broken      |
  | MARKSTOS  |   6 | 2007-03    | 2007-08  | broken      |
  | RKRIMEN   |   6 | 2007-06    | 2007-11  | broken      |
  | BRICAS    |   6 | 2007-07    | 2007-12  | broken      |
  | SARTAK    |   6 | 2007-07    | 2007-12  | broken      |
  | DAGOLDEN  |   6 | 2007-12    | 2008-05  | broken      |
  | VVELOX    |   6 | 2008-02    | 2008-07  | broken      |
  | KRYDE     |   6 | 2008-04    | 2008-09  | broken      |
  | KITANO    |   6 | 2008-09    | 2009-02  | broken      |
  | ZOFFIX    |   6 | 2008-10    | 2009-03  | broken      |
  | SZABGAB   |   6 | 2008-11    | 2009-04  | broken      |
  | KIMOTO    |   6 | 2008-12    | 2009-05  | broken      |
  | CORNELIUS |   6 | 2009-01    | 2009-06  | broken      |
  | AZAWAWI   |   6 | 2009-05    | 2009-10  | broken      |
  | LEOCHARRE |   6 | 2009-06    | 2009-11  | broken      |
  | VVELOX    |   6 | 2009-07    | 2009-12  | broken      |
  | DMAKI     |   6 | 2009-09    | 2010-02  | broken      |
  | FREW      |   6 | 2009-09    | 2010-02  | broken      |
  | RUZ       |   6 | 2009-09    | 2010-02  | broken      |
  | DAGOLDEN  |   6 | 2009-12    | 2010-05  | broken      |
  | AVAR      |   6 | 2010-01    | 2010-06  | broken      |
  | TODDR     |   6 | 2010-02    | 2010-07  | broken      |
  | FRANCKC   |   6 | 2010-03    | 2010-08  | broken      |
  | DAVIDP    |   6 | 2010-04    | 2010-09  | broken      |
  | TOBYINK   |   6 | 2010-04    | 2010-09  | broken      |
  | GFUJI     |   6 | 2010-06    | 2010-11  | broken      |
  | LEONT     |   6 | 2010-06    | 2010-11  | broken      |
  | AMBS      |   6 | 2010-09    | 2011-02  | broken      |
  | GRAY      |   6 | 2010-11    | 2011-04  | broken      |
  | TOBYINK   |   6 | 2010-11    | 2011-04  | broken      |
  | TSIBLEY   |   6 | 2011-05    | 2011-10  | broken      |
  | TOKUHIROM |   6 | 2011-07    | 2011-12  | broken      |
  | MNUNBERG  |   6 | 2011-11    | 2012-04  | broken      |
  | DOY       |   6 | 2012-01    | 2012-06  | broken      |
  | TYPESTER  |   6 | 2012-05    | 2012-10  | broken      |
  | NEILB     |   6 | 2012-07    | 2012-12  | broken      |
  | BAYASHI   |   6 | 2012-10    | 2013-03  | broken      |
  | JBERGER   |   6 | 2012-10    | 2013-03  | broken      |
  | DROLSKY   |   6 | 2013-02    | 2013-07  | broken      |
  | GETTY     |   6 | 2013-02    | 2013-07  | broken      |
  | RJBS      |   6 | 2013-09    | 2014-02  | broken      |
  | BKB       |   6 | 2014-01    | 2014-06  | broken      |
  | ALEXMV    |   6 | 2014-04    | 2014-09  | broken      |
  | PEVANS    |   6 | 2014-08    | 2015-01  | broken      |
  | JJNAPIORK |   6 | 2014-12    | 2015-05  | broken      |
  | YANICK    |   6 | 2014-12    | 2015-05  | broken      |
  | RSRCHBOY  |   6 | 2015-03    | 2015-08  | broken      |
  | MELEZHIK  |   6 | 2015-07    | 2015-12  | broken      |
  | SYSPETE   |   6 | 2016-03    | 2016-08  | broken      |
  | LNATION   |   6 | 2016-12    | 2017-05  | broken      |
  | PRBRENAN  |   6 | 2016-12    | 2017-05  | broken      |
  | PRBRENAN  |   6 | 2017-07    | 2017-12  | broken      |
  | FERREIRA  |   6 | 2017-08    | 2018-01  | broken      |
  | GENE      |   6 | 2018-01    | 2018-06  | broken      |
  | SHLOMIF   |   6 | 2018-05    | 2018-10  | broken      |
  | RENEEB    |   6 | 2018-10    | 2019-03  | broken      |
  | ATOOMIC   |   6 | 2018-12    | 2019-05  | broken      |
  | VVELOX    |   6 | 2019-06    | 2019-11  | broken      |
  | SRCHULO   |   6 | 2019-09    | 2020-02  | broken      |
  | PRBRENAN  |   6 | 2021-01    | 2021-06  | broken      |
  | UTASHIRO  |   6 | 2022-04    | 2022-09  | broken      |
  | BRTASTIC  |   6 | 2022-08    | 2023-01  | broken      |
  | TIMLEGGE  |   6 | 2023-06    |          | might-break |
  +-----------+-----+------------+----------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
