# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::AT;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220305001837;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            1(?:
              11|
              [2-9]
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '517',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '5[079]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,5})'
                },
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            (?:
              31|
              4
            )6|
            51|
            6(?:
              5[0-3579]|
              [6-9]
            )|
            7(?:
              20|
              32|
              8
            )|
            [89]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [2-467]|
            5[2-6]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{3,9})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '5',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'geographic' => '
          1(?:
            11\\d|
            [2-9]\\d{3,11}
          )|
          (?:
            316|
            463|
            (?:
              51|
              66|
              73
            )2
          )\\d{3,10}|
          (?:
            2(?:
              1[467]|
              2[13-8]|
              5[2357]|
              6[1-46-8]|
              7[1-8]|
              8[124-7]|
              9[1458]
            )|
            3(?:
              1[1-578]|
              3[23568]|
              4[5-7]|
              5[1378]|
              6[1-38]|
              8[3-68]
            )|
            4(?:
              2[1-8]|
              35|
              7[1368]|
              8[2457]
            )|
            5(?:
              2[1-8]|
              3[357]|
              4[147]|
              5[12578]|
              6[37]
            )|
            6(?:
              13|
              2[1-47]|
              4[135-8]|
              5[468]
            )|
            7(?:
              2[1-8]|
              35|
              4[13478]|
              5[68]|
              6[16-8]|
              7[1-6]|
              9[45]
            )
          )\\d{4,10}
        ',
                'mobile' => '
          6(?:
            5[0-3579]|
            6[013-9]|
            [7-9]\\d
          )\\d{4,10}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          8(?:
            10|
            2[018]
          )\\d{6,10}|
          828\\d{5}
        )|(
          (?:
            8[69][2-68]|
            9(?:
              0[01]|
              3[019]
            )
          )\\d{6,10}
        )',
                'toll_free' => '800\\d{6,10}',
                'voip' => '
          5(?:
            0[1-9]|
            17|
            [79]\\d
          )\\d{2,10}|
          7[28]0\\d{6,10}
        '
              };
my %areanames = ();
$areanames{de} = {"4317", "Wien",
"433183", "Sankt\ Georgen\ an\ der\ Stiefing",
"434825", "Großkirchheim",
"432629", "Warth\,\ Niederösterreich",
"4313", "Wien",
"437254", "Großraming",
"437566", "Rosenau\ am\ Hengstpaß",
"436215", "Straßwalchen",
"432719", "Droß",
"433834", "Wald\ am\ Schoberpaß",
"434873", "Sankt\ Jakob\ in\ Defereggen",
"433469", "Sankt\ Oswald\ im\ Freiland",
"432680", "Sankt\ Margarethen\ im\ Burgenland",
"433327", "Sankt\ Michael\ im\ Burgenland",
"437565", "Sankt\ Pankraz",
"432242", "Sankt\ Andrä\-Wördern",
"435678", "Weißenbach\ am\ Lech",
"433468", "Sankt\ Oswald\ ob\ Eibiswald",
"433843", "Sankt\ Michael\ in\ Obersteiermark",
"436414", "Großarl",
"4319", "Wien",
"4318", "Wien",
"433536", "Sankt\ Peter\ am\ Kammersberg",
"434876", "Kals\ am\ Großglockner",
"4315", "Wien",
"432268", "Großmugl",
"432617", "Draßmarkt",
"437717", "Sankt\ Aegidi",
"436565", "Neukirchen\ am\ Großvenediger",
"436241", "Sankt\ Koloman",
"432822", "Zwettl\-Niederösterreich",
"435352", "Sankt\ Johann\ in\ Tirol",
"432857", "Bad\ Großpertholz",
"437232", "Sankt\ Martin\ im\ Mühlkreis",
"436476", "Sankt\ Margarethen\ im\ Lungau",
"436247", "Großgmain",
"437945", "Sankt\ Oswald\ bei\ Freistadt",
"434783", "Reißeck",
"435449", "Fließ",
"436545", "Bruck\ an\ der\ Großglocknerstraße",
"437224", "Sankt\ Florian",
"433864", "Sankt\ Marein\ im\ Mürztal",
"432763", "Sankt\ Veit\ an\ der\ Gölsen",
"434266", "Straßburg",
"434785", "Außerfragant",
"433689", "Sankt\ Nikolai\ im\ Sölktal",
"435557", "Sankt\ Gallenkirch",
"4316", "Wien",
"437751", "Sankt\ Martin\ im\ Innkreis",
"437237", "Sankt\ Georgen\ an\ der\ Gusen",
"433140", "Sankt\ Martin\ am\ Wöllmißberg",
"432987", "Sankt\ Leonhard\ am\ Hornerwald",
"436138", "Sankt\ Wolfgang\ im\ Salzkammergut",
"433123", "Sankt\ Oswald\ bei\ Plankenwarth",
"434212", "Sankt\ Veit\ an\ der\ Glan",
"436276", "Nußdorf\ am\ Haunsberg",
"436242", "Rußbach\ am\ Paß\ Gschütt",
"434264", "Klein\ Sankt\ Paul",
"432812", "Groß\ Gerungs",
"432249", "Groß\-Enzersdorf",
"435413", "Sankt\ Leonhard\ im\ Pitztal",
"436546", "Fusch\ an\ der\ Großglocknerstraße",
"432618", "Markt\ Sankt\ Martin",
"432233", "Preßbaum",
"432686", "Draßburg",
"433575", "Sankt\ Johann\ am\ Tauern",
"434358", "Sankt\ Andrä",
"434226", "Sankt\ Margareten\ im\ Rosental",
"433869", "Sankt\ Katharein\ an\ der\ Laming",
"437956", "Unterweißenbach",
"4312", "Wien",
"433684", "Sankt\ Martin\ am\ Grimming",
"433178", "Sankt\ Ruprecht\ an\ der\ Raab",
"433868", "Tragöß",
"434877", "Prägraten\ am\ Großvenediger",
"432823", "Großglobnitz",
"433537", "Sankt\ Georgen\ ob\ Murau",
"433477", "Sankt\ Peter\ am\ Ottersbach",
"432847", "Groß\-Siegharts",
"434843", "Außervillgraten",
"432768", "Sankt\ Aegyd\ am\ Neuwalde",
"435446", "Sankt\ Anton\ am\ Arlberg",
"437217", "Sankt\ Veit\ im\ Mühlkreis",
"437954", "Sankt\ Georgen\ am\ Walde",
"435245", "Hinterriß",
"436412", "Sankt\ Johann\ im\ Pongau",
"432742", "Sankt\ Pölten",
"4314", "Wien",
"433158", "Sankt\ Anna\ am\ Aigen",
"434357", "Sankt\ Paul\ im\ Lavanttal",
"432647", "Krumbach\,\ Niederösterreich",
"432263", "Großrußbach",
"432674", "Weißenbach\ an\ der\ Triesting",
"432715", "Weißenkirchen\ in\ der\ Wachau",
"434350", "Bad\ Sankt\ Leonhard\ im\ Lavanttal",
"433515", "Sankt\ Lorenzen\ bei\ Knittelfeld",
"437477", "Sankt\ Peter\ in\ der\ Au",
"436477", "Sankt\ Michael\ im\ Lungau",
"432556", "Großkrut",
"435279", "Sankt\ Jodok\ am\ Brenner",
"434879", "Sankt\ Veit\ in\ Defereggen",
"437219", "Vorderweißenbach",
"433464", "Groß\ Sankt\ Florian",
"434283", "Sankt\ Stefan\ im\ Gailtal",
"433119", "Sankt\ Marein\ bei\ Graz",
"433585", "Sankt\ Lambrecht",
"432756", "Sankt\ Leonhard\ am\ Forst",
"432642", "Aspangberg\-Sankt\ Peter",
"434253", "Sankt\ Jakob\ im\ Rosental",
"437218", "Großtraberg",
"433386", "Großsteinbach",
"437667", "Sankt\ Georgen\ im\ Attergau",
"437435", "Sankt\ Valentin",
"433632", "Sankt\ Gallen",
"433331", "Sankt\ Lorenzen\ am\ Wechsel",
"434286", "Weißbriach",
"432815", "Großschönau",
"434239", "Sankt\ Kanzian\ am\ Klopeiner\ See",
"436277", "Sankt\ Pantaleon",
"436227", "Sankt\ Gilgen",
"432955", "Großweikersdorf",
"433362", "Großpetersdorf",};
$areanames{en} = {"437233", "Feldkirchen\ an\ der\ Donau",
"433385", "Ilz",
"433855", "Krieglach",
"433144", "Köflach",
"437219", "Vorderweissenbach",
"437445", "Hollenstein\ an\ der\ Ybbs",
"437211", "Reichenau\ im\ Mühlkreis",
"432916", "Riegersburg\,\ Hardegg",
"435583", "Lech",
"432265", "Hausleiten",
"432731", "Idolsberg",
"435674", "Bichlbach",
"437489", "Purgstall\ an\ der\ Erlauf",
"437613", "Laakirchen",
"435263", "Silz",
"432739", "Tiefenfucha",
"434717", "Steinfeld",
"432713", "Spitz",
"436235", "Thalgau",
"434283", "St\.\ Stefan\ im\ Gailtal",
"433464", "Gross\ St\.\ Florian",
"434852", "Lienz",
"435516", "Doren",
"436246", "Grödig",
"432849", "Schwarzenau",
"432287", "Strasshof\ an\ der\ Nordbahn",
"432983", "Sigmundsherberg",
"432841", "Vitis",
"433514", "Seckau",
"432786", "Oberwölbling",
"433177", "Puch\ bei\ Weiz",
"433127", "Peggau",
"436272", "Oberndorf\ bei\ Salzburg",
"432748", "Kilb",
"43316", "Graz",
"435353", "Waidring",
"432538", "Velm\-Götzendorf",
"436418", "Kleinarl",
"433338", "Lafnitz",
"435252", "Oetz",
"436470", "Atzmannsdorf",
"433848", "Eisenerz",
"432632", "Pernitz",
"433356", "Markt\ Allhau",
"433886", "Weichselboden",
"437732", "Haag\ am\ Hausruck",
"432556", "Grosskrut",
"435354", "Fieberbrunn",
"434284", "Kirchbach",
"433463", "Stainz",
"436477", "St\.\ Michael\ im\ Lungau",
"432984", "Eggenburg",
"432212", "Orth\ an\ der\ Donau",
"433513", "Bischoffeld",
"433118", "Sinabelkirchen",
"433170", "Fischbach",
"434782", "Obervellach",
"435673", "Ehrwald",
"434879", "St\.\ Veit\ in\ Defereggen",
"437614", "Vorchdorf",
"435264", "Mieming",
"432714", "Rossatz",
"432625", "Bad\ Sauerbrunn",
"432755", "Mank",
"437234", "Ottensheim",
"433452", "Leibnitz",
"433143", "Krottendorf",
"432856", "Weitra",
"434710", "Oberdrauburg",
"433586", "Mühlen",
"435279", "St\.\ Jodok\ am\ Brenner",
"437251", "Schiedlberg",
"435675", "Tannheim",
"432956", "Ziersdorf",
"433637", "Gams\ bei\ Hieflau",
"434256", "Nötsch\ im\ Gailtal",
"432264", "Rückersdorf\,\ Harmannsdorf",
"436234", "Zell\ am\ Moos",
"432673", "Altenmarkt\ an\ der\ Triesting",
"432623", "Pottendorf",
"437942", "Freistadt",
"437723", "Altheim",
"437259", "Sierning",
"433145", "Edelschrott",
"433854", "Langenwang",
"432753", "Gansbach",
"432279", "Kirchberg\ am\ Wagram",
"432271", "Ried\ am\ Riederberg",
"437444", "Opponitz",
"435280", "Hochfügen",
"433136", "Dobl",
"435556", "Schruns",
"437477", "St\.\ Peter\ in\ der\ Au",
"435632", "Stanzach",
"432762", "Lilienfeld",
"436542", "Zell\ am\ See",
"433465", "Pölfing\-Brunn",
"435339", "Wildschönau",
"437662", "Seewalchen\ am\ Attersee",
"436458", "Hüttau",
"435212", "Seefeld\ in\ Tirol",
"435331", "Brandenberg",
"434350", "Bad\ St\.\ Leonhard\ im\ Lavanttal",
"433515", "St\.\ Lorenzen\ bei\ Knittelfeld",
"432985", "Gars\ am\ Kamp",
"434285", "Tröpolach",
"433862", "Bruck\ an\ der\ Mur",
"437747", "Kirchberg\ bei\ Mattighofen",
"435287", "Tux",
"437272", "Eferding",
"432647", "Krumbach\,\ Lower\ Austria",
"432252", "Baden",
"434357", "St\.\ Paul\ im\ Lavanttal",
"432949", "Niederfladnitz",
"433158", "St\.\ Anna\ am\ Aigen",
"435417", "Roppen",
"437288", "Ulrichsberg",
"437246", "Gunskirchen",
"435355", "Jochberg",
"433853", "Spital\ am\ Semmering",
"432146", "Nickelsdorf",
"437235", "Gallneukirchen",
"432754", "Loosdorf",
"434766", "Millstatt",
"433383", "Burgau",
"435585", "Dalaas",
"437443", "Ybbsitz",
"434267", "Metnitz",
"432263", "Grossrussbach",
"432172", "Frauenkirchen",
"432715", "Weissenkirchen\ in\ der\ Wachau",
"436233", "Oberwang",
"432674", "Weissenbach\ an\ der\ Triesting",
"434238", "Eisenkappel\-Vellach",
"432624", "Ebenfurth",
"437615", "Scharnstein",
"435265", "Nassereith",
"436219", "Obertrum\ am\ See",
"432816", "Karlstift",
"437724", "Mauerkirchen",
"435676", "Jungholz",
"432278", "Absdorf",
"433362", "Grosspetersdorf",
"432955", "Grossweikersdorf",
"434255", "Arnoldstein",
"433172", "Weiz",
"436227", "St\.\ Gilgen",
"436277", "St\.\ Pantaleon",
"433624", "Pichl\-Kainisch",
"433146", "Modriach",
"432282", "Gänserndorf",
"433583", "Unzmarkt",
"432853", "Schrems",
"434214", "Brückl",
"432630", "Ternitz",
"437258", "Bad\ Hall",
"432914", "Japons",
"437684", "Frankenmarkt",
"435338", "Kundl",
"433883", "Terz",
"432784", "Perschling",
"437434", "Haag",
"433353", "Oberschützen",
"433135", "Kalsdorf\ bei\ Graz",
"434712", "Greifenburg",
"436244", "Golling\ an\ der\ Salzach",
"433466", "Eibiswald",
"435514", "Bezau",
"432862", "Heidenreichstein",
"433516", "Kleinlobming",
"437281", "Aigen\ im\ Mühlkreis",
"433159", "Bad\ Gleichenberg",
"434248", "Treffen",
"436243", "Abtenau",
"433457", "Gleinstätten",
"432986", "Irnfritz",
"434286", "Weissbriach",
"435513", "Hittisau",
"432948", "Weitersfeld",
"4346", "Klagenfurt",
"437289", "Rohrbach\ in\ Oberösterreich",
"433151", "Gnas",
"437683", "Frankenburg\ am\ Hausruck",
"432554", "Stützenhofen",
"433884", "Wegscheid",
"432783", "Traismauer",
"437433", "Wallsee",
"433354", "Bernstein",
"437245", "Lambach",
"435356", "Kitzbühel",
"434231", "Mittertrixen",
"433584", "Neumarkt\ in\ Steiermark",
"432145", "Prellenkirchen",
"432854", "Kirchberg\ am\ Walde",
"436472", "Mauterndorf",
"437236", "Pregarten",
"434213", "Launsdorf",
"434239", "St\.\ Kanzian\ am\ Klopeiner\ See",
"432913", "Hötzelsdorf",
"43662", "Salzburg",
"432637", "Grünbach\ am\ Schneeberg",
"433623", "Bad\ Mitterndorf",
"432716", "Gföhl",
"437616", "Grünau\ im\ Almtal",
"435266", "Ötztal\-Bahnhof",
"432815", "Grossschönau",
"437667", "St\.\ Georgen\ im\ Attergau",
"433386", "Grosssteinbach",
"436547", "Kaprun",
"433856", "Veitsch",
"432767", "Hohenberg",
"432143", "Kittsee",
"432915", "Drosendorf\-Zissersdorf",
"434215", "Liebenfels",
"437488", "Steinakirchen\ am\ Forst",
"432738", "Fels\ am\ Wagram",
"434254", "Faak\ am\ See",
"432266", "Stockerau",
"437218", "Grosstraberg",
"432954", "Göllersdorf",
"432813", "Arbesbach",
"437472", "Amstetten",
"432749", "Prinzersdorf",
"435515", "Au",
"436245", "Hallein",
"433331", "St\.\ Lorenzen\ am\ Wechsel",
"433339", "Friedberg",
"432741", "Flinsbach",
"436433", "Dorfgastein",
"433632", "St\.\ Gallen",
"432848", "Pfaffenschlag\ bei\ Waidhofen",
"437435", "St\.\ Valentin",
"437947", "Kefermarkt",
"437243", "Marchtrenk",
"433134", "Heiligenkreuz\ am\ Waasen",
"435554", "Sonntag",
"432177", "Podersdorf\ am\ See",
"433355", "Stadtschlaining",
"434262", "Treibach",
"433885", "Greith",
"432555", "Herrnbaumgarten",
"433119", "St\.\ Marein\ bei\ Graz",
"437244", "Sattledt",
"433133", "Nestelbach",
"435553", "Raggal",
"433849", "Vordernberg",
"436434", "Bad\ Gastein",
"435412", "Imst",
"434253", "St\.\ Jakob\ im\ Rosental",
"434352", "Wolfsberg",
"432257", "Klausen\-Leopoldsdorf",
"432953", "Nappersdorf",
"432814", "Langschlag",
"432626", "Mattersburg",
"435278", "Navis",
"432756", "St\.\ Leonhard\ am\ Forst",
"433867", "Pernegg\ an\ der\ Mur",
"433585", "St\.\ Lambrecht",
"432144", "Deutsch\ Jahrndorf",
"432855", "Waldenstein",
"432642", "Aspangberg\-St\.\ Peter",
"437277", "Waizenkirchen",
"437227", "Neuhofen\ an\ der\ Krems",
"437742", "Mattighofen",
"435282", "Zell\ am\ Ziller",
"433337", "Vorau",
"436417", "Hüttschlag",
"435375", "Kössen",
"436133", "Ebensee",
"432272", "Tulln\ an\ der\ Donau",
"433573", "Fohnsdorf",
"432163", "Petronell\-Carnuntum",
"432747", "Ober\-Grafendorf",
"433178", "St\.\ Ruprecht\ an\ der\ Raab",
"437949", "Rainbach\ im\ Mühlkreis",
"433684", "St\.\ Martin\ am\ Grimming",
"437252", "Steyr",
"437353", "Gaflenz",
"432288", "Auersthal",
"433182", "Wildon",
"432246", "Gerasdorf\ bei\ Wien",
"437941", "Neumarkt\ im\ Mühlkreis",
"436541", "Saalbach",
"437583", "Kremsmünster",
"434718", "Dellach",
"435445", "Kappl",
"437754", "Waldzell",
"432235", "Maria\-Lanzendorf",
"435332", "Wörgl",
"432769", "Türnitz",
"436549", "Piesendorf",
"437263", "Bad\ Zell",
"437674", "Attnang\-Puchheim",
"432724", "Schwarzenbach\ an\ der\ Pielach",
"432774", "Innermanzing",
"432615", "Lutzmannsburg",
"437956", "Unterweissenbach",
"437264", "Windhaag\ bei\ Perg",
"434242", "Villach",
"437673", "Schwanenstadt",
"432723", "Rabenstein\ an\ der\ Pielach",
"433616", "Selzthal",
"432259", "Münchendorf",
"432773", "Eichgraben",
"432942", "Retz",
"437584", "Molln",
"437753", "Eberschwang",
"433861", "Aflenz",
"437279", "Haibach\ ob\ der\ Donau",
"437229", "Traun",
"433869", "St\.\ Katharein\ an\ der\ Laming",
"437221", "Hörsching",
"435234", "Axams",
"434226", "St\.\ Margareten\ im\ Rosental",
"434276", "Feldkirchen\ in\ Kärnten",
"433683", "Donnersbach",
"433117", "Eggersdorf\ bei\ Graz",
"436212", "Seekirchen\ am\ Wallersee",
"436478", "Zederhaus",
"435526", "Laterns",
"435576", "Hohenems",
"437762", "Raab",
"432662", "Gloggnitz",
"4312", "Vienna",
"436134", "Hallstatt",
"433574", "Pusterwald",
"432164", "Rohrau",
"433847", "Trofaiach",
"437482", "Scheibbs",
"433685", "Gröbming",
"435477", "Tösens",
"432732", "Krems\ an\ der\ Donau",
"433150", "Paldau",
"437280", "Schwarzenberg\ am\ Böhmerwald",
"436457", "Flachau",
"435374", "Walchsee",
"437478", "Oed\-Oehling",
"433326", "Stegersbach",
"437212", "Zwettl\ an\ der\ Rodl",
"432576", "Ernstbrunn",
"432526", "Stronsdorf",
"436221", "Koppl",
"432725", "Frankenfels",
"434230", "Globasnitz",
"436584", "Maria\ Alm\ am\ Steinernen\ Meer",
"432614", "Kleinwarasdorf",
"433472", "Mureck",
"437675", "Ampflwang\ im\ Hausruckwald",
"436229", "Hof\ bei\ Salzburg",
"432876", "Els",
"432826", "Rastenfeld",
"437714", "Esternberg",
"435444", "Ischgl",
"432234", "Gramatneusiedl",
"437755", "Mettmach",
"433638", "Palfau",
"432842", "Waidhofen\ an\ der\ Thaya",
"433532", "Murau",
"435443", "Galtür",
"432233", "Pressbaum",
"434237", "Miklauzhof",
"437585", "Klaus\ an\ der\ Pyhrnbahn",
"434268", "Friesach",
"432631", "Pöttsching",
"437265", "Pabneukirchen",
"434736", "Innerkrems",
"436583", "Leogang",
"432613", "Deutschkreutz",
"432639", "Bad\ Fischau",
"437713", "Schardenberg",
"435373", "Ebbs",
"436135", "Bad\ Goisern",
"437287", "Peilstein\ im\ Mühlviertel",
"435272", "Steinach\ am\ Brenner",
"435418", "Schönwies",
"433157", "Kapfenstein",
"434358", "St\.\ Andrä",
"432165", "Hainburg\ a\.d\.\ Donau",
"434846", "Abfaltersbach",
"433575", "St\.\ Johann\ am\ Tauern",
"432648", "Hochneukirchen",
"437355", "Weyer",
"433832", "Kraubath\ an\ der\ Mur",
"435246", "Achenkirch",
"435288", "Fügen",
"432686", "Drassburg",
"437748", "Eggelsberg",
"434822", "Winklern",
"434872", "Huben",
"436466", "Werfenweng",
"437479", "Ardagger",
"433686", "Haus",
"432244", "Langenzersdorf",
"43732", "Linz",
"437471", "Neustadtl\ an\ der\ Donau",
"434240", "Bad\ Kleinkirchheim",
"435523", "Götzis",
"435573", "Hörbranz",
"433325", "Heiligenkreuz\ im\ Lafnitztal",
"432575", "Ladendorf",
"432525", "Gnadendorf",
"435337", "Brixlegg",
"433631", "Unterlaussa",
"4314", "Vienna",
"437953", "Liebenau",
"437257", "Grünburg",
"432726", "Puchenstuben",
"433613", "Admont",
"434858", "Nikolsdorf",
"437676", "Ottnang\ am\ Hausruck",
"432875", "Grafenschlag",
"432825", "Göpfritz\ an\ der\ Wild",
"432532", "Zistersdorf",
"433332", "Hartberg",
"436412", "St\.\ Johann\ im\ Pongau",
"434223", "Maria\ Saal",
"434273", "Reifnitz",
"436278", "Ostermiething",
"436228", "Faistenau",
"432742", "St\.\ Pölten",
"432277", "Zwentendorf",
"436562", "Mittersill",
"432667", "Schwarzau\ im\ Gebirge",
"437767", "Eggerding",
"437586", "Pettenbach",
"437250", "Maria\ Neustift",
"435236", "Gries\ im\ Sellrain",
"434224", "Pischeldorf",
"434274", "Velden\ am\ Wörther\ See",
"433842", "Leoben",
"432638", "Winzendorf\-Muthmannsdorf",
"434735", "Kremsbrücke",
"437266", "Bad\ Kreuzen",
"433112", "Gleisdorf",
"437954", "St\.\ Georgen\ am\ Walde",
"436217", "Mattsee",
"433614", "Rottenmann",
"434269", "Flattnitz",
"435289", "Häusling",
"436136", "Gosau",
"435574", "Bregenz",
"432649", "Mönichkirchen",
"435524", "Satteins",
"432641", "Kirchberg\ am\ Wechsel",
"432166", "Parndorf",
"433576", "Bretstein",
"435245", "Hinterriss",
"432685", "Rust",
"434359", "Reichenfels",
"432947", "Theras",
"432243", "Klosterneuburg",
"434247", "Afritz",
"437948", "Hirschbach\ im\ Mühlkreis",
"435376", "Thiersee",
"432524", "Kautendorf",
"432574", "Gaweinstal",
"434843", "Ausservillgraten",
"432289", "Matzen",
"432847", "Gross\-Siegharts",
"433324", "Strem",
"432683", "Purbach\ am\ Neusiedler\ See",
"433171", "Gasen",
"435243", "Maurach",
"433179", "Passail",
"436463", "Annaberg\-Lungötz",
"433477", "St\.\ Peter\ am\ Ottersbach",
"432245", "Wolkersdorf\ im\ Weinviertel",
"435446", "St\.\ Anton\ am\ Arlberg",
"432236", "Mödling",
"437217", "St\.\ Veit\ im\ Mühlkreis",
"435472", "Prutz",
"437487", "Gresten",
"434733", "Malta",
"432768", "St\.\ Aegyd\ am\ Neuwalde",
"432824", "Allentsteig",
"432874", "Martinsberg",
"436548", "Niedernsill",
"437716", "Münzkirchen",
"436452", "Radstadt",
"432616", "Lockenhaus",
"437955", "Königswiesen",
"437278", "Neukirchen\ am\ Walde",
"437228", "Kematen\ an\ der\ Krems",
"434734", "Rennweg",
"437562", "Windischgarsten",
"432873", "Kottes",
"432823", "Grossglobnitz",
"433615", "Trieben",
"434877", "Prägraten\ am\ Grossvenediger",
"437412", "Ybbs\ an\ der\ Donau",
"433868", "Tragöss",
"437282", "Neufelden",
"432258", "Alland",
"433152", "Feldbach",
"434275", "Ebene\ Reichenau",
"434225", "Grafenstein",
"437480", "Langau\,\ Gaming",
"432684", "Schützen\ am\ Gebirge",
"435244", "Jenbach",
"435525", "Nenzing",
"435575", "Langen\ bei\ Bregenz",
"434232", "Völkermarkt",
"433537", "St\.\ Georgen\ ob\ Murau",
"436471", "Tweng",
"432523", "Kirchstetten\,\ Neudorf\ bei\ Staatz",
"436479", "Muhr",
"432573", "Wilfersdorf",
"433323", "Eberau",
"437442", "Waidhofen\ an\ der\ Ybbs",
"437240", "Sipbachzell",
"433852", "Mürzzuschlag",
"433382", "Fürstenfeld",
"433137", "Söding",
"435557", "St\.\ Gallenkirch",
"437476", "Aschbach\-Markt",
"436232", "Mondsee",
"433689", "St\.\ Nikolai\ im\ Sölktal",
"437944", "Sandl",
"432173", "Gols",
"433328", "Kukmirn",
"432262", "Korneuburg",
"4316", "Vienna",
"437223", "Enns",
"437759", "Antiesenhofen",
"437273", "Aschach\ an\ der\ Donau",
"436544", "Rauris",
"432828", "Rappottenstein",
"432878", "Traunstein",
"432764", "Hainfeld",
"434855", "Assling",
"435214", "Leutasch",
"433863", "Turnau",
"437751", "St\.\ Martin\ im\ Innkreis",
"437664", "Weyregg\ am\ Attersee",
"435255", "Umhausen",
"435634", "Elbigenalp",
"432253", "Oberwaltersdorf",
"432957", "Hohenwarth",
"434257", "Fürnitz",
"433636", "Wildalpen",
"436225", "Eugendorf",
"437269", "Baumgartenberg",
"435633", "Hägerau",
"437735", "Gaspoltshofen",
"434266", "Strassburg",
"432254", "Ebreichsdorf",
"432635", "Neunkirchen",
"437261", "Schönau\ im\ Mühlkreis",
"437274", "Alkoven",
"437224", "St\.\ Florian",
"432215", "Probstdorf",
"436543", "Taxenbach",
"432763", "St\.\ Veit\ an\ der\ Gölsen",
"435239", "Kühtai",
"432147", "Zurndorf",
"435213", "Scharnitz",
"434767", "Rothenthurn",
"433864", "St\.\ Marein\ im\ Mürztal",
"437663", "Steinbach\ am\ Attersee",
"432622", "Wiener\ Neustadt",
"432672", "Berndorf",
"437722", "Braunau\ am\ Inn",
"437943", "Windhaag\ bei\ Freistadt",
"437247", "Kematen\ am\ Innbach",
"434848", "Kartitsch",
"434785", "Ausserfragant",
"434356", "Lavamünd",
"432174", "Wallern\ im\ Burgenland",
"432688", "Steinbrunn",
"437746", "Friedburg",
"435286", "Ginzling",
"433571", "Möderbrugg",
"435248", "Steinberg\ am\ Rofan",
"432646", "Kirchschlag\ in\ der\ Buckligen\ Welt",
"436468", "Werfen",
"433455", "Arnfels",
"433579", "Pöls",
"432169", "Trautmannsdorf\ an\ der\ Leitha",
"435550", "Thüringen",
"436131", "Obertraun",
"432752", "Melk",
"437945", "St\.\ Oswald\ bei\ Freistadt",
"433126", "Frohnleiten",
"433176", "Stubenberg",
"433366", "Kohfidisch",
"434783", "Reisseck",
"435672", "Reutte",
"432248", "Markgrafneusiedl",
"435517", "Riezlern",
"436247", "Grossgmain",
"433142", "Voitsberg",
"432286", "Obersiebenbrunn",
"433453", "Ehrenhausen",
"435635", "Elmen",
"432611", "Mannersdorf\ an\ der\ Rabnitz",
"434716", "Lesachtal",
"435254", "Sölden",
"437711", "Suben",
"437719", "Taufkirchen\ an\ der\ Pram",
"436224", "Hintersee",
"436274", "Lamprechtshausen",
"432633", "Markt\ Piesting",
"432619", "Lackendorf",
"436589", "Unken",
"437733", "Neumarkt\ im\ Hausruckkreis",
"433512", "Knittelfeld",
"432213", "Lassee",
"432239", "Breitenfurt\ bei\ Wien",
"435449", "Fliess",
"435441", "See",
"433462", "Deutschlandsberg",
"432231", "Purkersdorf",
"437665", "Unterach\ am\ Attersee",
"436545", "Bruck\ an\ der\ Grossglocknerstrasse",
"432765", "Kaumberg",
"432214", "Kopfstetten",
"437225", "Hargelsberg",
"434853", "Ainet",
"433865", "Kindberg",
"434282", "Hermagor",
"433618", "Hohentauern",
"432982", "Horn",
"432857", "Bad\ Grosspertholz",
"433587", "Schönberg\-Lachtal",
"435352", "St\.\ Johann\ in\ Tirol",
"435253", "Längenfeld",
"436223", "Anthering",
"434278", "Gnesau",
"432634", "Gutenstein",
"434228", "Feistritz\ im\ Rosental",
"432255", "Deutsch\ Brodersdorf",
"437734", "Hofkirchen\ an\ der\ Trattnach",
"435582", "Klösterle",
"436476", "St\.\ Margarethen\ im\ Lungau",
"437232", "St\.\ Martin\ im\ Mühlkreis",
"433454", "Leutschach",
"435262", "Telfs",
"436240", "Krispl",
"437612", "Gmunden",
"435578", "Höchst",
"432712", "Aggsbach",
"435510", "Damüls",
"432175", "Apetlon",
"433357", "Pinkafeld",
"432557", "Bernhardsthal",
"434784", "Mallnitz",
"437946", "Gutau",
"437474", "Euratsfeld",
"433125", "Übelbach",
"433175", "Anger",
"434252", "Wernberg",
"435413", "St\.\ Leonhard\ im\ Pitztal",
"433365", "Deutsch\ Schützen\-Eisenberg",
"432952", "Hollabrunn",
"434353", "Prebl",
"432249", "Gross\-Enzersdorf",
"432643", "Lichtenegg",
"437743", "Maria\ Schmolln",
"435283", "Kaltenbach",
"432285", "Marchegg",
"432238", "Kaltenleutgeben",
"435448", "Pettneu\ am\ Arlberg",
"434715", "Kötschach\-Mauthen",
"433132", "Kumberg",
"435552", "Bludenz",
"433634", "Hieflau",
"432267", "Sierndorf",
"434263", "Hüttenberg",
"432865", "Litschau",
"432618", "Markt\ St\.\ Martin",
"436588", "Lofer",
"432620", "Willendorf",
"437666", "Attersee",
"433387", "Söchau",
"437718", "Waldkirchen\ am\ Wesen",
"436546", "Fusch\ an\ der\ Grossglocknerstrasse",
"433857", "Neuberg\ an\ der\ Mürz",
"432766", "Kleinzell",
"434221", "Gallizien",
"434271", "Steuerberg",
"437276", "Peuerbach",
"436432", "Bad\ Hofgastein",
"437226", "Wilhering",
"432757", "Pöchlarn",
"433866", "Breitenau\ am\ Hochlantsch",
"434279", "Sirnitz",
"434229", "Krumpendorf\ am\ Wörther\ See",
"433611", "Johnsbach",
"437242", "Wels",
"437727", "Ach",
"432627", "Pitten",
"433633", "Landl",
"434264", "Klein\ St\.\ Paul",
"432256", "Leobersdorf",
"433619", "Oppenberg",
"435579", "Alberschwende",
"432644", "Grimmenstein",
"437744", "Munderfing",
"435284", "Gerlos",
"436475", "Ramingstein",
"434762", "Spittal\ an\ der\ Drau",
"432142", "Gattendorf",
"432812", "Gross\ Gerungs",
"437473", "Blindenmarkt",
"432176", "Tadten",
"435414", "Wenns",
"434354", "Preitenegg",
"433688", "Tauplitz",
"434212", "St\.\ Veit\ an\ der\ Glan",
"432912", "Geras",
"433329", "Jennersdorf",
"432284", "Oberweiden",
"433467", "Schwanberg",
"436473", "Mariapfarr",
"433622", "Bad\ Aussee",
"437475", "Hausmening\,\ Neuhofen\ an\ der\ Ybbs",
"433364", "Hannersdorf",
"433174", "Birkfeld",
"433124", "Gratkorn",
"436242", "Russbach\ am\ Pass\ Gschütt",
"433147", "Salla",
"435512", "Egg",
"432864", "Kautzen",
"432728", "Wienerbruck",
"437230", "Altenberg\ bei\ Linz",
"435256", "Untergurgl",
"437758", "Obernberg\ am\ Inn",
"434714", "Dellach\ im\ Drautal",
"435677", "Vils",
"437682", "Vöcklamarkt",
"433635", "Radmer",
"436276", "Nussdorf\ am\ Haunsberg",
"437432", "Strengberg",
"432829", "Schweiggers",
"436226", "Fuschl\ am\ See",
"432782", "Herzogenburg",
"432717", "Unter\-Meisling",
"437588", "Ried\ im\ Traunkreis",
"437617", "Traunkirchen",
"433140", "St\.\ Martin\ am\ Wöllmissberg",
"434713", "Techendorf",
"437736", "Pram",
"433882", "Mariazell",
"432552", "Poysdorf",
"434265", "Weitensfeld\ im\ Gurktal",
"433352", "Oberwart",
"432636", "Puchberg\ am\ Schneeberg",
"435238", "Zirl",
"437268", "Grein",
"432216", "Leopoldsdorf\ im\ Marchfelde",
"432863", "Eggern",
"437237", "St\.\ Georgen\ an\ der\ Gusen",
"433460", "Soboth",
"436461", "Dienten\ am\ Hochkönig",
"436138", "St\.\ Wolfgang\ im\ Salzkammergut",
"432689", "Hornstein",
"435357", "Kirchberg\ in\ Tirol",
"433363", "Rechnitz",
"433578", "Obdach",
"432168", "Mannersdorf\ am\ Leithagebirge",
"434355", "Gemmersdorf",
"433173", "Ratten",
"433123", "St\.\ Oswald\ bei\ Plankenwarth",
"437745", "Lochen",
"435285", "Mayrhofen",
"432645", "Wiesmath",
"433582", "Scheifling",
"432852", "Gmünd",
"433456", "Fresing",
"432283", "Angern\ an\ der\ March",
"432987", "St\.\ Leonhard\ am\ Hornerwald",
"436474", "Tamsweg",
"437214", "Reichenthal",
"433149", "Geistthal",
"434258", "Gummern",
"432958", "Maissau",
"432275", "Atzenbrugg",
"435372", "Kufstein",
"435223", "Hall\ in\ Tirol",
"435273", "Matrei\ am\ Brenner",
"433141", "Hirschegg",
"434873", "St\.\ Jakob\ in\ Defereggen",
"434823", "Tresdorf\,\ Rangersdorf",
"433185", "Preding",
"432827", "Schönbach",
"432877", "Grainbrunn",
"433833", "Traboch",
"437255", "Losenstein",
"432734", "Langenlois",
"437484", "Göstling\ an\ der\ Ybbs",
"432844", "Karlstein\ an\ der\ Thaya",
"433327", "St\.\ Michael\ im\ Burgenland",
"432680", "St\.\ Margarethen\ im\ Burgenland",
"432577", "Asparn\ an\ der\ Zaya",
"432527", "Wulzeshofen",
"435335", "Hopfgarten\ im\ Brixental",
"433469", "St\.\ Oswald\ im\ Freiland",
"433461", "Trahütten",
"432232", "Fischamend",
"433533", "Turrach",
"435442", "Landeck",
"435558", "Gaschurn",
"436582", "Saalfelden\ am\ Steinernen\ Meer",
"432612", "Oberpullendorf",
"436456", "Obertauern",
"437712", "Schärding",
"433474", "Deutsch\ Goritz",
"435476", "Serfaus",
"432945", "Zellerndorf",
"437416", "Wieselburg",
"436467", "Mühlbach\ am\ Hochkönig",
"434245", "Feistritz\ an\ der\ Drau",
"433473", "Straden",
"437566", "Rosenau\ am\ Hengstpass",
"435359", "Hochfilzen",
"432687", "Siegendorf",
"432989", "Brunn\ an\ der\ Wild",
"432843", "Dobersberg",
"434847", "Obertilliach",
"437248", "Grieskirchen",
"433534", "Stadl\ an\ der\ Mur",
"437286", "Lembach\ im\ Mühlkreis",
"434824", "Heiligenblut",
"434874", "Virgen",
"434768", "Kleblach\-Lind",
"432711", "Dürnstein",
"433834", "Wald\ am\ Schoberpass",
"432719", "Dross",
"432733", "Schönberg\ am\ Kamp",
"436215", "Strasswalchen",
"437619", "Kirchham",
"437483", "Oberndorf\ an\ der\ Melk",
"437213", "Bad\ Leonfelden",
"437239", "Lichtenberg",
"432665", "Prein\ an\ der\ Rax",
"437231", "Herzogsdorf",
"435274", "Gries\ am\ Brenner",
"435224", "Wattens",
"437765", "Lambrechten",
"434236", "Eberndorf",
"432269", "Niederfellabrunn",
"433184", "Wolfsberg\ im\ Schwarzautal",
"432735", "Hadersdorf\ am\ Kamp",
"437254", "Grossraming",
"436213", "Oberhofen\ am\ Irrsee",
"434220", "Köttmannsdorf",
"437485", "Gaming",
"433682", "Stainach",
"432274", "Sieghartskirchen",
"437215", "Hellmonsödt",
"433859", "Mürzsteg",
"436483", "Göriach",
"4313", "Vienna",
"437763", "Kopfing\ im\ Innkreis",
"432663", "Schottwien",
"433475", "Hürth",
"434243", "Bodensdorf",
"437672", "Vöcklabruck",
"432943", "Obritz",
"435518", "Mellau",
"432247", "Deutsch\-Wagram",
"432772", "Neulengbach",
"432722", "Kirchberg\ an\ der\ Pielach",
"436566", "Bramberg\ am\ Wildkogel",
"435334", "Westendorf",
"432746", "Wilhelmsburg",
"432845", "Weikertschlag\ an\ der\ Thaya",
"433336", "Waldbach",
"436416", "Lend",
"437752", "Ried\ im\ Innkreis",
"432536", "Drösing",
"435333", "Söll",
"433358", "Litzelsdorf",
"435232", "Kematen\ in\ Tirol",
"433846", "Kalwang",
"437582", "Kirchdorf\ an\ der\ Krems",
"435577", "Lustenau",
"433535", "Krakaudorf",
"434244", "Bad\ Bleiberg",
"432944", "Haugsdorf",
"4317", "Vienna",
"433116", "Kirchbach\ in\ Steiermark",
"437262", "Perg",
"432162", "Bruck\ an\ der\ Leitha",
"433572", "Judenburg",
"432273", "Tulbing",
"434277", "Glanegg",
"434227", "Ferlach",
"436484", "Lessach",
"435275", "Trins",
"435225", "Fulpmes",
"437764", "Riedau",
"432664", "Semmering",
"436132", "Bad\ Ischl",
"432858", "Moorbad\ Harbach",
"433588", "Katsch\ an\ der\ Mur",
"432621", "Sieggraben",
"433617", "Gaishorn\ am\ See",
"434825", "Grosskirchheim",
"434875", "Matrei\ in\ Osttirol",
"433183", "St\.\ Georgen\ an\ der\ Stiefing",
"437729", "Neukirchen\ an\ der\ Enknach",
"437253", "Wolfern",
"436214", "Henndorf\ am\ Wallersee",
"432629", "Warth\,\ Lower\ Austria",
"433858", "Mitterdorf\ im\ Mürztal",
"437717", "St\.\ Aegidi",
"432617", "Drassmarkt",
"432736", "Paudorf",
"437486", "Lunz\ am\ See",
"437448", "Kematen\ an\ der\ Ybbs",
"432572", "Mistelbach",
"432522", "Laa\ an\ der\ Thaya",
"433322", "Güssing",
"437216", "Helfenberg",
"432268", "Grossmugl",
"434233", "Griffen",
"435447", "Flirsch",
"432237", "Gaaden",
"432822", "Zwettl\,\ Lower\ Austria",
"432872", "Ottenschlag",
"433476", "Bad\ Radkersburg",
"436454", "Mandling",
"437413", "Marbach\ an\ der\ Donau",
"435474", "Pfunds",
"437563", "Spital\ am\ Pyhrn",
"436565", "Neukirchen\ am\ Grossvenediger",
"435519", "Schröcken",
"43512", "Innsbruck",
"432745", "Pyhra",
"432846", "Raabs\ an\ der\ Thaya",
"433153", "Riegersburg",
"437283", "Sarleinsbach",
"433335", "Pöllau",
"436241", "St\.\ Koloman",
"436415", "Schwarzach\ im\ Pongau",
"432535", "Hohenau\ an\ der\ March",
"433845", "Mautern\ in\ Steiermark",
"437284", "Oberkappel",
"433536", "St\.\ Peter\ am\ Kammersberg",
"433359", "Loipersdorf\-Kitzladen",
"436453", "Filzmoos",
"437414", "Weins\-Isperdorf",
"433115", "Studenzen",
"435473", "Nauders",
"434732", "Gmünd\ in\ Kärnten",
"437564", "Hinterstoder",
"4318", "Vienna",
"434842", "Sillian",
"432859", "Brand\-Nagelberg",
"435226", "Neustift\ im\ Stubaital",
"435276", "Gschnitz",
"434234", "Ruden",
"432628", "Felixdorf",
"432610", "Horitschon",
"433581", "Oberwölz",
"437728", "Schwand\ im\ Innkreis",
"4315", "Vienna",
"432230", "Schwadorf",
"436462", "Bischofshofen",
"434826", "Mörtschach",
"434876", "Kals\ am\ Grossglockner",
"432758", "Pöggstall",
"432682", "Eisenstadt",
"435242", "Schwaz",
"432276", "Reidling",
"435678", "Weissenbach\ am\ Lech",
"437260", "Waldhausen",
"437757", "Gurten",
"432959", "Sitzendorf\ an\ der\ Schmida",
"432242", "St\.\ Andrä\-Wördern",
"433148", "Kainach\ bei\ Voitsberg",
"435230", "Sellrain",
"437256", "Ternberg",
"432951", "Guntersdorf",
"433843", "St\.\ Michael\ in\ Obersteiermark",
"436564", "Krimml",
"435336", "Alpbach",
"432744", "Kasten\ bei\ Böheimkirchen",
"432534", "Niedersulz",
"4319", "Vienna",
"433334", "Kaindorf",
"436414", "Grossarl",
"436455", "Untertauern",
"433468", "St\.\ Oswald\ ob\ Eibiswald",
"435559", "Brand",
"432160", "Jois",
"433687", "Schladming",
"433113", "Pischelsdorf\ in\ der\ Steiermark",
"435475", "Feichten",
"432946", "Pulkau",
"437241", "Steinerkirchen\ an\ der\ Traun",
"433612", "Liezen",
"437415", "Altenmarkt\,\ Yspertal",
"432988", "Neupölla",
"434246", "Radenthein",
"437565", "St\.\ Pankraz",
"437357", "Kleinreifling",
"437249", "Bad\ Schallerbach",
"437952", "Weitersfelden",
"433114", "Markt\ Hartmannsdorf",
"433680", "Donnersbachwald",
"433155", "Fehring",
"433844", "Kammern\ im\ Liesingtal",
"434272", "Pörtschach\ am\ Wörther\ See",
"436563", "Uttendorf",
"433577", "Zeltweg",
"432167", "Neusiedl\ am\ See",
"432743", "Böheimkirchen",
"432533", "Neusiedl\ an\ der\ Zaya",
"435358", "Ellmau",
"436137", "Strobl",
"437285", "Hofkirchen\ im\ Mühlkreis",
"433333", "Sebersdorf",
"436413", "Wagrain",
"437238", "Mauthausen",
"437750", "Andrichsfurt",
"437267", "Mönchdorf",
"436216", "Neumarkt\ am\ Wallersee",
"434769", "Möllbrücke",
"432666", "Reichenau",
"434761", "Stockenboi",
"437618", "Neukirchen\,\ Altmünster",
"435572", "Dornbirn",
"435522", "Feldkirch",
"434235", "Bleiburg",
"437766", "Andorf",
"437587", "Wartberg\ an\ der\ Krems",
"432718", "Lichtenau\ im\ Waldviertel",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+43|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;