# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MY;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20201204215957;

my $formatters = [
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '[4-79]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '
            1(?:
              [02469]|
              [378][1-9]
            )|
            8
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3-$4',
                  'leading_digits' => '1[36-8]',
                  'pattern' => '(\\d)(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2 $3',
                  'leading_digits' => '1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            3(?:
              2[0-36-9]|
              3[0-368]|
              4[0-278]|
              5[0-24-8]|
              6[0-467]|
              7[1246-9]|
              8\\d|
              9[0-57]
            )\\d|
            4(?:
              2[0-689]|
              [3-79]\\d|
              8[1-35689]
            )|
            5(?:
              2[0-589]|
              [3468]\\d|
              5[0-489]|
              7[1-9]|
              9[23]
            )|
            6(?:
              2[2-9]|
              3[1357-9]|
              [46]\\d|
              5[0-6]|
              7[0-35-9]|
              85|
              9[015-8]
            )|
            7(?:
              [2579]\\d|
              3[03-68]|
              4[0-8]|
              6[5-9]|
              8[0-35-9]
            )|
            8(?:
              [24][2-8]|
              3[2-5]|
              5[2-7]|
              6[2-589]|
              7[2-578]|
              [89][2-9]
            )|
            9(?:
              0[57]|
              13|
              [25-7]\\d|
              [3489][0-8]
            )
          )\\d{5}
        ',
                'mobile' => '
          1(?:
            4400|
            8(?:
              47|
              8[27]
            )[0-4]
          )\\d{4}|
          1(?:
            0(?:
              [23568]\\d|
              4[0-6]|
              7[016-9]|
              9[0-8]
            )|
            1(?:
              [1-5]\\d\\d|
              6(?:
                0[5-9]|
                [1-9]\\d
              )|
              7(?:
                [01]\\d|
                2[2-6]
              )
            )|
            (?:
              (?:
                [269]|
                59
              )\\d|
              [37][1-9]|
              4[235-9]
            )\\d|
            8(?:
              1[23]|
              [236]\\d|
              4[06]|
              5[7-9]|
              7[016-9]|
              8[01]|
              9[0-8]
            )
          )\\d{5}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(1600\\d{6})',
                'toll_free' => '1[378]00\\d{6}',
                'voip' => '
          15(?:
            4(?:
              6[0-4]\\d|
              8(?:
                0[125]|
                [17]\\d|
                21|
                3[01]|
                4[01589]|
                5[014]|
                6[02]
              )
            )|
            6(?:
              32[0-6]|
              78\\d
            )
          )\\d{4}
        '
              };
my %areanames = ();
$areanames{en} = {"6032117", "Kuala\ Lumpur",
"6088797", "Tuaran",
"607251", "Johor\ Bahru",
"6034279", "Kuala\ Lumpur",
"606509", "Jasin",
"6089722", "Tawau",
"6088801", "Tuaran",
"605210", "Ipoh",
"6088412", "Kota\ Kinabalu",
"607961", "Segamat",
"604919", "Alor\ Setar",
"6037890", "Kuala\ Lumpur",
"606531", "Jasin",
"6089923", "Tawau",
"6089560", "Kinabatangan",
"604487", "Sungai\ Bakap",
"6088404", "Kota\ Kinabalu",
"6087770", "Tambunan",
"609958", "Batu\ Gajah",
"6033192", "Banting",
"605732", "Parit\ Buntar",
"609974", "Machang",
"6082220", "Kuching",
"6088863", "Bongawan",
"607740", "Kahang",
"605517", "Tanjung\ Rambutan",
"606423", "Simpang\ Durian",
"609268", "Damak",
"6039236", "Kuala\ Lumpur",
"605349", "Batu\ Gajah",
"608634", "Bintulu",
"607363", "Johor\ Bahru",
"6083414", "Kabong",
"604449", "Baling",
"6035892", "Kinrara",
"6084366", "Sibu",
"6085630", "Miri",
"609265", "Jerantut",
"6035030", "Kinrara",
"6035526", "Kinrara",
"609229", "Bilut\ Valley",
"604727", "Bedong",
"607506", "Senai",
"609955", "Machang",
"6034290", "Kuala\ Lumpur",
"6039103", "Cheras",
"6037118", "Kuala\ Lumpur",
"604399", "Penang",
"6032781", "Kuala\ Lumpur",
"604701", "Bedong",
"6033216", "Sabak\ Bernam",
"6033884", "Kelang",
"6033140", "Banting",
"6089288", "Elopura",
"6082329", "Serian",
"6037879", "Kuala\ Lumpur",
"6038913", "Semenyih",
"6036124", "Kuala\ Lumpur",
"6032386", "Kuala\ Lumpur",
"609237", "Bilut\ Valley",
"60787", "Kota\ Tinggi",
"605673", "Bruas",
"6087466", "Labuan",
"6087731", "Tenom",
"607512", "Senai",
"6039021", "Kuala\ Lumpur",
"6049371", "Kangar",
"6035033", "Kinrara",
"606486", "Simpang\ Durian",
"6033082", "Kelang",
"6086880", "Bakun",
"6085633", "Miri",
"608433", "Sibu",
"609784", "Pasirputih",
"6084367", "Sibu",
"609686", "Kuala\ Brang",
"604621", "Penang",
"6036064", "Kuala\ Kubu\ Baru",
"6084788", "Kapit",
"607765", "Endau",
"6032387", "Kuala\ Lumpur",
"604607", "Penang",
"604908", "Kangar",
"6089203", "Elopura",
"6087467", "Labuan",
"605294", "Tanjung\ Rambutan",
"607447", "Batu\ Pahat",
"606385", "Tangga\ Batu",
"6036178", "Kuala\ Lumpur",
"6087218", "Beaufort",
"6033143", "Sepang",
"605320", "Ipoh",
"6087822", "Sipitang",
"608521", "Limbang",
"6033217", "Sabak\ Bernam",
"6038769", "Semenyih",
"6034293", "Kuala\ Lumpur",
"6039100", "Cheras",
"609703", "Kota\ Bharu",
"6084222", "Sibu",
"606612", "Kuala\ Klawang",
"6087225", "Beaufort",
"6036789", "Genting",
"6085756", "Marudi",
"6084662", "Sarikei",
"6039779", "Kuala\ Lumpur",
"6085284", "Lawas",
"603300", "Kelang",
"609412", "Kuala\ Rompin",
"604358", "Tasek\ Gelugor",
"6032240", "Kuala\ Lumpur",
"6086321", "Bintulu",
"607768", "Paloh",
"6032116", "Kuala\ Lumpur",
"6088796", "Tuaran",
"6084818", "Daro",
"6038084", "Kinrara",
"606388", "Kuala\ Sungai\ Baru",
"609240", "Kemayan",
"605356", "Ipoh",
"606726", "Seremban",
"609547", "Kuantan",
"609888", "Kemasik",
"609751", "Kota\ Bharu",
"6082663", "Kota\ Samarahan",
"605807", "Taiping",
"6088469", "Kota\ Kinabalu",
"607382", "Johor\ Bahru",
"6082223", "Kuching",
"6083475", "Debak",
"606973", "Bukit\ Gambir",
"6087773", "Tambunan",
"6089563", "Kinabatangan",
"607917", "Tenang",
"609370", "Dong",
"6089920", "Tawau",
"6083310", "Bandar\ Sri\ Aman",
"609952", "Machang",
"607531", "Senai",
"6038957", "Cheras",
"6089983", "Tawau",
"6037947", "Kuala\ Lumpur",
"60478", "Pokok\ Sena",
"604281", "Penang",
"6093261", "Padang\ Tengku",
"609630", "Kuala\ Brang",
"607509", "Senai",
"6084807", "Sibu",
"606430", "Gemencheh",
"6039191", "Kuala\ Lumpur",
"6033250", "Kelang",
"6082280", "Kuching",
"606251", "Melaka",
"6034260", "Kuala\ Lumpur",
"607423", "Rengit",
"6035124", "Kinrara",
"6085609", "Miri",
"6083326", "Bandar\ Sri\ Aman",
"605448", "Tanjung\ Malim",
"6082824", "Asajaya",
"6089668", "Elopura",
"609250", "Triang",
"608873", "Kinarut",
"6032721", "Kuala\ Lumpur",
"605767", "Lenggong",
"606631", "Seremban",
"6039174", "Kuala\ Lumpur",
"607783", "Keluang",
"609960", "Kuala\ Krai",
"604916", "Alor\ Setar",
"6036184", "Kuala\ Lumpur",
"6033359", "Kelang",
"6082389", "Kuching",
"6089463", "Elopura",
"605395", "Besout",
"609863", "Chukai",
"60442", "Sungai\ Petani",
"604254", "Penang",
"6033162", "Kelang",
"605617", "Telukintan",
"6033280", "Kuala\ Selangor",
"605834", "Taiping",
"6035625", "Kinrara",
"6082690", "Kuching",
"604964", "Kuah",
"609557", "Kuantan",
"605661", "Ipoh",
"606737", "Mantin",
"605793", "Grik",
"6088361", "Kota\ Kinabalu",
"6032034", "Kuala\ Lumpur",
"6084692", "Bintangor",
"6037863", "Kuala\ Lumpur",
"608244", "Kuching",
"6089534", "Elopura",
"607486", "Batu\ Pahat",
"6086351", "Bintulu",
"6086284", "Bintulu",
"6036211", "Kuala\ Lumpur",
"609415", "Kuala\ Rompin",
"6088512", "Kota\ Kinabalu",
"607241", "Johor\ Bahru",
"606512", "Jasin",
"6035549", "Kinrara",
"6089274", "Elopura",
"606615", "Kuala\ Klawang",
"6089950", "Balung",
"605359", "Batu\ Gajah",
"606729", "Seremban",
"6039081", "Cheras",
"60497", "Kangar",
"607518", "Senai",
"6082741", "Lundu",
"60743", "Batu\ Pahat",
"6082581", "Kota\ Samarahan",
"607750", "Lavang\-Lavang",
"6033283", "Kuala\ Selangor",
"6085710", "Bekenu",
"606524", "Jasin",
"6033135", "Kelang",
"6036738", "Kuala\ Kubu\ Baru",
"6089869", "Lahad\ Datu",
"6088303", "Kota\ Kinabalu",
"6082283", "Kuching",
"609945", "Ayer\ Lanas",
"6084806", "Kapit",
"607388", "Johor\ Bahru",
"609586", "Gebeng",
"604521", "Tasek\ Gelugor",
"6084640", "Sarikei",
"604200", "Penang",
"6033346", "Kelang",
"6032108", "Kuala\ Lumpur",
"6032180", "Kuala\ Lumpur",
"606489", "Kuala\ Klawang",
"6032262", "Kuala\ Lumpur",
"6039051", "Cheras",
"6037946", "Kuala\ Lumpur",
"607515", "Tanjung\ Kupang",
"6038956", "Serdang",
"6058710", "Semanggol",
"6082551", "Kuching",
"6039139", "Kuala\ Lumpur",
"6036094", "Rawang",
"609418", "Nenasi",
"6085664", "Miri",
"6086254", "Bintulu",
"6085224", "Limbang",
"6087852", "Menumbok",
"6082878", "Baki",
"609204", "Jerantut",
"6038024", "Kinrara",
"6086381", "Tatau",
"607762", "Renggam",
"6083327", "Bandar\ Sri\ Aman",
"6088938", "Kota\ Belud",
"605581", "Chemor",
"6082797", "Tebedu",
"609936", "Kuala\ Balah",
"605810", "Taiping",
"607788", "Kahang",
"607425", "Parit\ Betak",
"605672", "Sitiawan",
"6035101", "Kinrara",
"6038751", "Semenyih",
"6087313", "Keningau",
"6085616", "Miri",
"607469", "Sri\ Gading",
"6085474", "Miri",
"607900", "Tenggara",
"6086290", "Bintulu",
"6034278", "Kuala\ Lumpur",
"6035020", "Kinrara",
"6083566", "Pantu",
"6035163", "Kinrara",
"6036193", "Kuala\ Lumpur",
"6082863", "Kota\ Samarahan",
"607362", "Johor\ Bharu",
"606782", "Seremban",
"6085620", "Miri",
"6082315", "Kuching",
"6087502", "Labuan",
"609868", "Chukai",
"6087441", "Labuan",
"604941", "Kangar",
"6088451", "Kinarut",
"604610", "Penang",
"609666", "Kuala\ Brang",
"609525", "Kuantan",
"6089670", "Elopura",
"6086461", "Belaga",
"6088702", "Kinarut",
"606337", "Melaka",
"6089289", "Elopura",
"606466", "Palong",
"609865", "Kemasik",
"606422", "Tampin",
"609764", "Bachok",
"6039226", "Kuala\ Lumpur",
"6085491", "Miri",
"6086951", "Bintulu",
"6082328", "Serian",
"609829", "Paka",
"606797", "Mantin",
"605733", "Parit\ Buntar",
"6039070", "Cheras",
"6088961", "Kota\ Belud",
"608875", "Kinarut",
"6088903", "Papar",
"604760", "Alor\ Setar",
"608758", "Labuan",
"6088854", "Ranau",
"605443", "Tapah",
"605311", "Ipoh",
"605759", "Kuala\ Kangsar",
"6034025", "Kuala\ Lumpur",
"607785", "Keluang",
"6089247", "Elopura",
"607884", "Kota\ Tinggi",
"607428", "Senggarang",
"604748", "Alor\ Setar",
"606972", "Bukit\ Gambir",
"603772", "Kuala\ Lumpur",
"605436", "Tapah",
"6035885", "Kinrara",
"6084789", "Kapit",
"605367", "Pusing",
"6087219", "Beaufort",
"6036179", "Kuala\ Lumpur",
"607216", "Johor\ Bahru",
"609285", "Mentakab",
"6033271", "Batang\ Berjuntai",
"606691", "Linggi",
"6038768", "Semenyih",
"6089673", "Elopura",
"609271", "Mentakab",
"6033860", "Sekinchan",
"605795", "Grik",
"605894", "Taiping",
"6089246", "Elopura",
"6036142", "Kuala\ Lumpur",
"6082294", "Kuching",
"6086488", "Balingan",
"6084232", "Sibu",
"606613", "Kuala\ Klawang",
"608261", "Kuching",
"609413", "Kuala\ Rompin",
"605644", "Hutan\ Melintang",
"607677", "Pontian",
"6085617", "Miri",
"6082391", "Kuching",
"606490", "Rembau",
"606270", "Melaka",
"6087832", "Menumbok",
"6082684", "Kuching",
"6083348", "Bandar\ Sri\ Aman",
"607304", "Johor\ Bahru",
"608742", "Labuan",
"609840", "Dungun",
"60438", "Penang",
"605798", "Lenggong",
"6085201", "Limbang",
"6032084", "Kuala\ Lumpur",
"609288", "Bukit\ Tinggi",
"608432", "Sibu",
"6089631", "Elopura",
"6082271", "Kuching",
"6036436", "Genting",
"6085263", "Sundar",
"6033185", "Banting",
"6088663", "Kotamarudu",
"6082860", "Kota\ Samarahan",
"607513", "Tanjung\ Kupang",
"6083496", "Lingga",
"6082531", "Kuching",
"6083567", "Lingga",
"604467", "Jeniang",
"6086293", "Bintulu",
"609669", "Batu\ Rakit",
"6084375", "Sibu",
"606469", "Kemavan",
"605480", "Tanjung\ Malim",
"6038079", "Kinrara",
"609862", "Chukai",
"6085461", "Miri",
"606425", "Tampin",
"6082473", "Kuching",
"6085680", "Miri",
"609826", "Kerteh",
"604881", "Penang",
"6089851", "Kunak",
"606851", "Seremban",
"6039544", "Cheras",
"604758", "Alor\ Setar",
"6089711", "Tawau",
"604510", "Tasek\ Gelugor",
"609566", "Kuantan",
"6084840", "Kuala\ Igan",
"605678", "Bruas",
"609351", "Raub",
"6087768", "Tambunan",
"604217", "Penang",
"607782", "Paloh",
"609719", "Kota\ Bharu",
"605654", "Kampong\ Gajah",
"6085403", "Miri",
"6032336", "Kuala\ Lumpur",
"607944", "Segamat",
"605756", "Kuala\ Kangsar",
"609770", "Bachok",
"6087475", "Labuan",
"6085242", "Limbang",
"6085737", "Batu\ Niah",
"6039205", "Kuala\ Lumpur",
"6032731", "Kuala\ Lumpur",
"608872", "Kinarut",
"6032773", "Kuala\ Lumpur",
"609850", "Chukai",
"6036101", "Genting",
"6039411", "Cheras",
"6037663", "Kuala\ Lumpur",
"607422", "Kampung\ Parit\ Tengah",
"605675", "Changkat\ Keruing",
"605681", "Sitiawan",
"6084892", "Selangau",
"6086260", "Bintulu",
"6089669", "Elopura",
"60969", "Jerteh",
"606428", "Kuala\ Pilah",
"609263", "Damak",
"6083467", "Sebuyau",
"6082300", "Kuching",
"6088347", "Kota\ Kinabalu",
"6038090", "Kinrara",
"607365", "Johor\ Bahru",
"6036276", "Kuala\ Lumpur",
"606771", "Seremban",
"607208", "Johor\ Bahru",
"6088690", "Kota\ Marudu",
"605720", "Parit\ Buntar",
"606350", "Tangga\ Batu",
"6085290", "Lawas",
"6033358", "Kelang",
"6082388", "Kuching",
"607414", "Rengit",
"6036020", "Batu\ Arang",
"6089612", "Elopura",
"6086201", "Bintulu",
"606383", "Tangga\ Batu",
"6088928", "Papar",
"607763", "Ayer\ Hitam",
"6083337", "Bandar\ Sri\ Aman",
"609980", "Kuala\ Krai",
"608844", "Kota\ Kinabalu",
"6037481", "Kuala\ Lumpur",
"6037660", "Kuala\ Lumpur",
"6082766", "Bau",
"6084302", "Sibu",
"609590", "Kuantan",
"609708", "Kota\ Bharu",
"6039012", "Cheras",
"6032770", "Kuala\ Lumpur",
"6089868", "Lahad\ Datu",
"6036739", "Kuala\ Kubu\ Baru",
"6033264", "Kuala\ Selangor",
"604432", "Kulim",
"6084405", "Sibu",
"604984", "Kangar",
"6087811", "Sipitang",
"6087402", "Labuan",
"6037884", "Kuala\ Lumpur",
"6082499", "Kuching",
"6082890", "Serian",
"6088741", "Kinarut",
"603778", "Kuala\ Lumpur",
"606978", "Tangkak",
"609477", "Maran",
"604799", "Pokok\ Sena",
"6083466", "Debak",
"6038093", "Kinrara",
"6082303", "Kuching",
"6082504", "Kuching",
"6036277", "Kuala\ Lumpur",
"604594", "Parit\ Buntar",
"6035548", "Kinrara",
"6088346", "Kota\ Kinabalu",
"605439", "Tapah",
"604261", "Penang",
"60735", "Johor\ Bahru",
"607219", "Johor\ Bahru",
"609282", "Lanchang",
"606981", "Bakri",
"6034816", "Kuala\ Lumpur",
"605401", "Tapah",
"604951", "Kuah",
"606975", "Muar",
"605427", "Tapah",
"6052321", "Ipoh",
"6032109", "Kuala\ Lumpur",
"6082842", "Damai\ Beach",
"6085736", "Batu\ Niah",
"6032024", "Kuala\ Lumpur",
"6033361", "Kelang",
"604903", "Kuah",
"605792", "Grik",
"603620", "Kuala\ Lumpur",
"6084738", "Julau",
"6089524", "Telupid",
"6085331", "Miri",
"6034820", "Kuala\ Lumpur",
"607340", "Johor\ Bahru",
"606410", "Tampin",
"6039106", "Cheras",
"6088943", "Kota\ Belud",
"604764", "Alor\ Setar",
"6089611", "Elopura",
"6034297", "Kuala\ Lumpur",
"609872", "Cheneh",
"6033213", "Hutan\ Melintang",
"609610", "Bandar\ Permaisuri",
"6085540", "Miri",
"6084301", "Sibu",
"606242", "Melaka",
"606479", "Ayer\ Hitam",
"607511", "Senai",
"6032383", "Kuala\ Lumpur",
"604569", "Kepala\ Batas",
"6089207", "Elopura",
"6087463", "Labuan",
"607880", "Kota\ Tinggi",
"609679", "Jerteh",
"6039011", "Cheras",
"604829", "Penang",
"6087401", "Labuan",
"608826", "Kota\ Kinabalu",
"6087812", "Sipitang",
"6085637", "Miri",
"608862", "Kudat",
"6039271", "Kuala\ Lumpur",
"604614", "Penang",
"6084815", "Rejang",
"6088742", "Kinarut",
"6036281", "Kuala\ Lumpur",
"6084363", "Sibu",
"6036048", "Kerling",
"6084755", "Kanowit",
"604716", "Alor\ Setar",
"6036420", "Rawang",
"609760", "Bachok",
"6035523", "Kinrara",
"605668", "Sitiawan",
"6087228", "Beaufort",
"6089926", "Tawau",
"605665", "Sitiawan",
"605526", "Ipoh",
"607296", "Johor\ Bahru",
"6084828", "Daro",
"6089567", "Kinabatangan",
"6087777", "Tambunan",
"604936", "Kangar",
"605629", "Telukintan",
"6087215", "Beaufort",
"606611", "Kuala\ Klawang",
"6035480", "Kinrara",
"6082227", "Kuching",
"6038870", "Putrajaya",
"6087782", "Tambunan",
"6088552", "Telupid",
"6082667", "Kota\ Samarahan",
"6035889", "Kinrara",
"6083584", "Lubukantu",
"60695", "Muar",
"6088790", "Tuaran",
"6032110", "Kuala\ Lumpur",
"6032246", "Kuala\ Lumpur",
"606693", "Rantau",
"605637", "Sabak\ Bernam",
"60626", "Melaka",
"6033362", "Kelang",
"604868", "Penang",
"6085750", "Marudi",
"607381", "Johor\ Bahru",
"609752", "Pasir\ Putih",
"607904", "Tenang",
"607926", "Labis",
"606532", "Jasin",
"6038873", "Putrajaya",
"6035483", "Kinrara",
"6082666", "Kota\ Samarahan",
"6033099", "Pulau\ Ketam",
"605313", "Ipoh",
"605441", "Trolak",
"6082226", "Kuching",
"6084874", "Mukah",
"6089285", "Elopura",
"6089852", "Kunak",
"6033319", "Kelang",
"6085462", "Miri",
"6089927", "Tawau",
"607252", "Johor\ Bahru",
"6089712", "Tawau",
"6087776", "Keningau",
"6089566", "Kinabatangan",
"605286", "Ipoh",
"604943", "Kangar",
"606494", "Kuala\ Klawang",
"606274", "Melaka",
"6083308", "Bandar\ Sri\ Aman",
"604288", "Penang",
"607300", "Johor\ Bahru",
"6034104", "Kuala\ Lumpur",
"60741", "Parit\ Sulong",
"6089704", "Tawau",
"606968", "Pagoh",
"609467", "Maran",
"6032113", "Kuala\ Lumpur",
"6088793", "Tuaran",
"6088641", "Kudat",
"606667", "Sepang",
"609844", "Dungun",
"6032247", "Kuala\ Lumpur",
"6032732", "Kuala\ Lumpur",
"6085241", "Kampung\ Pahlawan",
"6087460", "Labuan",
"606965", "Tangkak",
"605890", "Semanggol",
"6032380", "Kuala\ Lumpur",
"6036102", "Genting",
"6089206", "Elopura",
"60477", "Alor\ Setar",
"607950", "Aver\ Panas",
"6088940", "Kota\ Belud",
"6084891", "Selangau",
"605640", "Hutan\ Melintang",
"6034296", "Kuala\ Lumpur",
"60794", "Gemas",
"605583", "Chemor",
"6082319", "Kuching",
"60565", "Langkap",
"6035520", "Kinrara",
"6035036", "Kinrara",
"604413", "Sungai\ Petani",
"6085636", "Miri",
"606638", "Kuala\ Pilah",
"609438", "Perwira\ Jaya",
"60951", "Kuantan",
"604702", "Alor\ Setar",
"6096830", "Kuala\ Brang",
"6089466", "Elopura",
"6088307", "Kota\ Kinabalu",
"605529", "Ipoh",
"604850", "Penang",
"607299", "Johor\ Bahru",
"6033272", "Batang\ Berjuntai",
"605626", "Telukintan",
"604901", "Changlon",
"605230", "Ipoh",
"606354", "Tangga\ Batu",
"6033129", "Tk\ Panglima\ Garang",
"609755", "Kota\ Bharu",
"609854", "Chukai",
"604628", "Penang",
"6038776", "Mantin",
"6085720", "Batu\ Niah",
"6036141", "Kuala\ Lumpur",
"604927", "Ayer\ Hitam",
"604263", "Penang",
"605537", "Tanjung\ Rambutan",
"6084231", "Sibu",
"606983", "Bakri",
"605712", "Parit\ Buntar",
"6033392", "Kelang",
"605403", "Tapah",
"604953", "Kuah",
"6037734", "Kuala\ Lumpur",
"609380", "Jerantut",
"6087831", "Menumbok",
"6083323", "Bandar\ Sri\ Aman",
"604669", "Penang",
"607940", "Segamat",
"6039766", "Cheras",
"606476", "Ladang\ Geddes",
"604522", "Tasek\ Gelugor",
"6088602", "Kudat",
"609758", "Pasir\ Putih",
"609774", "Kota\ Bharu",
"604625", "Penang",
"604566", "Tasekgelugor",
"6085202", "Limbang",
"604826", "Penang",
"6036037", "Rawang",
"6082272", "Kuching",
"6089632", "Elopura",
"608829", "Kota\ Kinabalu",
"6038950", "Cheras",
"6037940", "Kuala\ Lumpur",
"607761", "Ayer\ Hitam",
"6032604", "Kuala\ Lumpur",
"6084393", "Sibu",
"604351", "Kepala\ Batas",
"609217", "Mentakab",
"604719", "Sungai\ Petani",
"6089986", "Tawau",
"6082532", "Kuching",
"6082495", "Kuching",
"6082287", "Damai\ Beach",
"6088614", "Kudat",
"6084646", "Sarikei",
"6087490", "Labuan",
"605540", "Ipoh",
"604282", "Penang",
"6039767", "Cheras",
"606252", "Melaka",
"6035628", "Kinrara",
"609951", "Machang",
"6083320", "Bandar\ Sri\ Aman",
"6035102", "Kinrara",
"6038752", "Semenyih",
"603762", "Kuala\ Lumpur",
"606962", "Bakri",
"6084689", "Bintangor",
"6034266", "Kuala\ Lumpur",
"607532", "Senai",
"6082286", "Kuching",
"6084803", "Sibu",
"604705", "Alor\ Setar",
"60961", "Kuala\ Brang",
"6033256", "Kelang",
"607968", "Gemas",
"6033343", "Kelang",
"6084647", "Sarikei",
"6036036", "Batuarang",
"6039388", "Cheras",
"6089665", "Elopura",
"605683", "Sitiawan",
"6038953", "Cheras",
"6087501", "Labuan",
"607274", "Johor\ Bahru",
"609353", "Raub",
"607929", "Aver\ Panas",
"6035740", "Kinrara",
"604980", "Kangar",
"6087442", "Labuan",
"607255", "Johor\ Bahru",
"6086462", "Bakun",
"6088701", "Kinarut",
"6088675", "Pantai\ Pitas",
"609327", "Padang\ Tengku",
"6086952", "Bintulu",
"6085492", "Bekenu",
"6038075", "Kinrara",
"6082544", "Kuching",
"606632", "Seremban",
"607965", "Kota\ Tinggi",
"6088962", "Papar",
"6085717", "Bekenu",
"605289", "Pusing",
"6085395", "Miri",
"6087479", "Labuan",
"6037866", "Kuala\ Lumpur",
"609301", "Jerantut",
"6088355", "Kota\ Kinabalu",
"6038777", "Mantin",
"6034131", "Kuala\ Lumpur",
"6088362", "Kota\ Kinabalu",
"6084691", "Bintangor",
"605920", "Sitiawan",
"6088906", "Papar",
"6084384", "Sibu",
"604530", "Tasek\ Gelugor",
"6036049", "Kerling",
"609753", "Bachok",
"609272", "Lanchang",
"6088511", "Kota\ Kinabalu",
"6039775", "Kuala\ Lumpur",
"6089240", "Elopura",
"604955", "Kuah",
"6038744", "Semenyih",
"606971", "Bukit\ Kepong",
"606546", "Durian\ Tunggal",
"604308", "Tasek\ Gelugor",
"604229", "Penang",
"6087229", "Beaufort",
"606985", "Muar",
"6087881", "Kuala\ Penyu",
"605857", "Taiping",
"6039082", "Cheras",
"609701", "Kota\ Bharu",
"607587", "Senai",
"6082582", "Kota\ Samarahan",
"609534", "Kuantan",
"6089677", "Elopura",
"6039223", "Kuala\ Lumpur",
"6056340", "Kampong\ Gajah",
"6087484", "Labuan",
"6089936", "Luasong",
"6036087", "Rawang",
"6039521", "Kuala\ Lumpur",
"608741", "Labuan",
"6086297", "Bintulu",
"6036057", "Kuala\ Kubu\ Baru",
"6083563", "Engkilili",
"607896", "Tenggara",
"6035166", "Kinrara",
"6086485", "Belaga",
"609970", "Machang",
"6036196", "Kuala\ Lumpur",
"607744", "Ayer\ Hitam",
"6085627", "Miri",
"604406", "Padang\ Serai",
"6032261", "Kuala\ Lumpur",
"6088667", "Kota\ Marudu",
"6082552", "Kuching",
"609919", "Ayer\ Lanas",
"604958", "Kuah",
"604305", "Penang",
"6087851", "Kuala\ Penyu",
"6032203", "Kuala\ Lumpur",
"606988", "Bakri",
"6082790", "Tebedu",
"604268", "Penang",
"6087316", "Keningau",
"6085613", "Miri",
"608431", "Sibu",
"6035888", "Kuala\ Lumpur",
"609873", "Cheneh",
"604623", "Penang",
"6083309", "Bandar\ Sri\ Aman",
"6085626", "Miri",
"6082867", "Kota\ Samarahan",
"604412", "Penang",
"607659", "Linggiu",
"6036433", "Genting",
"6085266", "Lawas",
"6082734", "Lundu",
"604703", "Bedong",
"6035270", "Kinrara",
"606620", "Port\ Dickson",
"6047930", "Pokok\ Sena",
"6034028", "Kuala\ Lumpur",
"605685", "Sitiawan",
"6093262", "Padang\ Tengku",
"604240", "Penang",
"609358", "Raub",
"605671", "Sitiawan",
"6035167", "Kinrara",
"6086296", "Bintulu",
"6087317", "Keningau",
"607361", "Johor\ Bharu",
"606775", "Seremban",
"6038994", "Cheras",
"6085610", "Miri",
"6037875", "Kuala\ Lumpur",
"6082325", "Serian",
"6077690", "Paloh",
"606781", "Sepang",
"60628", "Melaka",
"604888", "Penang",
"6082793", "Tebedu",
"6033318", "Kelang",
"604370", "Penang",
"609244", "Triang",
"607860", "Senai",
"607520", "Senai",
"605470", "Kampar",
"6032722", "Kuala\ Lumpur",
"6089243", "Elopura",
"605290", "Tanjung\ Rambutan",
"6038308", "Putrajaya",
"6033103", "Pulau\ Ketam",
"604686", "Penang",
"609456", "Chini",
"606421", "Bahau",
"606656", "Port\ Dickson",
"6033325", "Kelang",
"605419", "Tapah",
"604885", "Penang",
"6039140", "Kuala\ Lumpur",
"604784", "Lubuk\ Merbau",
"6089937", "Luasong",
"607253", "Johor\ Bahru",
"6039076", "Cheras",
"605688", "Sitiawan",
"6038699", "Semenyih",
"603216", "Kuala\ Lumpur",
"6033161", "Kelang",
"609355", "Raub",
"607227", "Johor\ Bahru",
"60463", "Penang",
"606533", "Jasin",
"605597", "Chemor",
"609780", "Kok\ Lanas",
"6089676", "Elopura",
"605312", "Ipoh",
"6085555", "Miri",
"6049372", "Kangar",
"607899", "Tiram",
"6036273", "Kuala\ Lumpur",
"604250", "Penang",
"6083460", "Sebuyau",
"6099560", "Batu\ Gajah",
"6085297", "Lawas",
"6082896", "Serian",
"604409", "Kulim",
"6085485", "Kampung\ Bakam",
"6033081", "Kelang",
"6089622", "Elopura",
"607595", "Senai",
"603414", "Kuala\ Lumpur",
"605225", "Ipoh",
"604960", "Kuah",
"6089798", "Tawau",
"6032776", "Kuala\ Lumpur",
"609278", "Mentakab",
"609254", "Triang",
"606698", "Linggi",
"60942", "Pekan",
"6082760", "Bau",
"6087821", "Sipitang",
"6037666", "Kuala\ Lumpur",
"603337", "Kelang",
"604557", "Tasek\ Gelugor",
"6047454", "Alor\ Setar",
"604741", "Alor\ Setar",
"6038323", "Putrajaya",
"6084719", "Pakan",
"6084480", "Sibu",
"6035545", "Kinrara",
"608237", "Kuching",
"606646", "Port\ Dickson",
"6084661", "Sarikei",
"6099200", "Ayer\ Lanas",
"6084221", "Sibu",
"6085406", "Miri",
"6032333", "Kuala\ Lumpur",
"604952", "Kuah",
"606317", "Melaka",
"6086322", "Bintulu",
"606549", "Durian\ Tunggal",
"609281", "Kuala\ Krau",
"604226", "Penang",
"6032274", "Kuala\ Lumpur",
"606695", "Linggi",
"6086507", "Bintulu",
"604262", "Penang",
"605791", "Grik",
"6089865", "Lahad\ Datu",
"6033051", "Kelang",
"6085455", "Miri",
"603205", "Kuala\ Lumpur",
"6034810", "Kuala\ Lumpur",
"609817", "Dungun",
"607598", "Senai",
"6089514", "Beluran",
"609345", "Raub",
"609634", "Bandar\ Permaisuri",
"6088532", "Kota\ Kinabalu",
"606434", "Jelai",
"607687", "Pontian",
"6032681", "Kuala\ Lumpur",
"604945", "Kangar",
"6086506", "Bintulu",
"6088411", "Kota\ Kinabalu",
"606852", "Melaka",
"609521", "Kuantan",
"6085733", "Batu\ Niah",
"6032330", "Kuala\ Lumpur",
"606659", "Sepang",
"6085407", "Miri",
"605416", "Tapah",
"6086555", "Bintulu",
"6035629", "Kinrara",
"604418", "Mahang",
"608871", "Kinarut",
"6033191", "Banting",
"606633", "Seremban",
"607781", "Paloh",
"6034813", "Kuala\ Lumpur",
"609352", "Sungai\ Koyan",
"605847", "Taiping",
"6035891", "Kinrara",
"607421", "Kampung\ Parit\ Tengah",
"607656", "Kulai",
"6085296", "Lawas",
"6087478", "Labuan",
"6082701", "Lundu",
"605682", "Changkat\ Keruing",
"607754", "Ayer\ Hitam",
"6083463", "Debak",
"605318", "Ipoh",
"6036270", "Kuala\ Lumpur",
"6082306", "Kuching",
"6088784", "Tuaran",
"604415", "Sungai\ Petani",
"605889", "Taiping",
"6087765", "Tambunan",
"6084762", "Kanowit",
"6088343", "Kota\ Kinabalu",
"6032782", "Kuala\ Lumpur",
"6038320", "Putrajaya",
"6038964", "Cheras",
"607533", "Senai",
"606227", "Melaka",
"606963", "Tangkak",
"604283", "Penang",
"6085605", "Miri",
"6082763", "Bau",
"6085771", "Long\ Lama",
"6033385", "Kelang",
"6088205", "Kota\ Kinabalu",
"606253", "Melaka",
"607407", "Parit\ Sulong",
"606228", "Melaka",
"6038894", "Putrajaya",
"6039010", "Cheras",
"606663", "Tekok\ Kemang",
"604898", "Penang",
"6038588", "Putrajaya",
"6033184", "Banting",
"6032772", "Kuala\ Lumpur",
"606791", "Seremban",
"607408", "Kampong\ Parit\ Tengah",
"6084893", "Selangau",
"604947", "Kangar",
"605434", "Tapah",
"6032787", "Kuala\ Lumpur",
"6037662", "Kuala\ Lumpur",
"606331", "Melaka",
"609831", "Paka",
"6084834", "Matu",
"6082685", "Kuching",
"6035192", "Kinrara",
"605744", "Manong",
"609505", "Kuantan",
"609602", "Bandar\ Permaisuri",
"6087736", "Tenom",
"605646", "Bagan\ Datoh",
"6089745", "Merotai",
"607222", "Johor\ Bahru",
"605592", "Lintang",
"607266", "Johor\ Bahru",
"605549", "Ipoh",
"6036421", "Rawang",
"608887", "Ranau",
"6036280", "Kuala\ Lumpur",
"6032085", "Kuala\ Lumpur",
"605698", "Sitiawan",
"607823", "Penawar",
"604417", "Mahang",
"6035481", "Kinrara",
"6038871", "Putrajaya",
"6087234", "Beaufort",
"6036690", "Batuarang",
"605848", "Taiping",
"609508", "Teruntum",
"6088536", "Kota\ Kinabalu",
"6082472", "Kuching",
"6083589", "Lubukantu",
"608849", "Kota\ Kinabalu",
"6085402", "Miri",
"6089506", "Beluran",
"604599", "Parit\ Buntar",
"6088396", "Kota\ Kinabalu",
"605280", "Ipoh",
"6083547", "Maludam",
"607920", "Segamat",
"604989", "Kangar",
"6086326", "Bintulu",
"604794", "Ayer\ Hitam",
"6082840", "Damai\ Beach",
"6088791", "Tuaran",
"609818", "Kerteh",
"607597", "Senai",
"6088537", "Kota\ Kinabalu",
"607688", "Pontian",
"6039231", "Kuala\ Lumpur",
"6034024", "Kuala\ Lumpur",
"605253", "Ipoh",
"6082843", "Damai\ Beach",
"606682", "Seremban",
"6085240", "Kampung\ Pahlawan",
"604461", "Bedong",
"6084879", "Dalat",
"604555", "Tasek\ Gelugor",
"6086327", "Bintulu",
"6083438", "Saratok",
"604859", "Penang",
"6038998", "Cheras",
"605201", "Chemor",
"6088397", "Kota\ Kinabalu",
"605520", "Ipoh",
"604930", "Alor\ Setar",
"606318", "Melaka",
"603894", "Cheras",
"603795", "Kuala\ Lumpur",
"605633", "Kampong\ Gajah",
"606697", "Linggi",
"603798", "Kuala\ Lumpur",
"606315", "Melaka",
"6089613", "Elopura",
"604779", "Pokok\ Sena",
"609277", "Mentakab",
"6032786", "Kuala\ Lumpur",
"6087461", "Labuan",
"609664", "Batu\ Rakit",
"6084303", "Sibu",
"604558", "Tasek\ Gelugor",
"606464", "Ladang\ Geddes",
"609766", "Bachok",
"6032381", "Kuala\ Lumpur",
"608235", "Kuching",
"6082314", "Kuching",
"604710", "Alor\ Setar",
"608923", "Elopura",
"608267", "Kota\ Samarahan",
"6084361", "Sibu",
"607685", "Pontian",
"605852", "Taiping",
"6036135", "Kuala\ Lumpur",
"6085768", "Marudi",
"6087403", "Labuan",
"607886", "Penawar",
"6036022", "Batu\ Arang",
"6084766", "Kanowit",
"6082302", "Kuching",
"609815", "Kerteh",
"609714", "Kota\ Bharu",
"609570", "Kuantan",
"6087737", "Tenom",
"6038092", "Kinrara",
"6035521", "Kinrara",
"6088885", "Ranau",
"6085475", "Miri",
"603207", "Kuala\ Lumpur",
"604660", "Penang",
"6034770", "Kuala\ Lumpur",
"6088703", "Kinarut",
"6085310", "Limbang",
"605243", "Ipoh",
"608989", "Lahad\ Datu",
"6082625", "Kuching",
"605687", "Sitiawan",
"6089848", "Kunak",
"6039086", "Cheras",
"608542", "Miri",
"6032025", "Kuala\ Lumpur",
"607663", "Kulai",
"607791", "Felda\ Tenggaroh",
"605598", "Chemor",
"607228", "Johor\ Bahru",
"6087201", "Beaufort",
"6033124", "Tk\ Panglima\ Garang",
"604892", "Penang",
"6088902", "Papar",
"606266", "Sungai\ Rambai",
"6088366", "Kota\ Kinabalu",
"6035568", "Kinrara",
"606222", "Melaka",
"6034285", "Kuala\ Lumpur",
"604545", "Sungai\ Bakap",
"604699", "Alor\ Setar",
"604986", "Kangar",
"6032727", "Kuala\ Lumpur",
"6036140", "Kuala\ Lumpur",
"6032278", "Kuala\ Lumpur",
"6034255", "Kuala\ Lumpur",
"604548", "Tasek\ Gelugor",
"6037885", "Kuala\ Lumpur",
"604293", "Penang",
"6087439", "Labuan",
"6082505", "Kuching",
"6087312", "Keningau",
"6033341", "Kelang",
"607830", "Penggerang",
"609323", "Kuala\ Lipis",
"6035162", "Kinrara",
"6084797", "Kapit",
"6084801", "Sibu",
"605595", "Chemor",
"607225", "Johor\ Bahru",
"605692", "Sitiawan",
"605649", "Hutan\ Melintang",
"6037941", "Kuala\ Lumpur",
"6089518", "Beluran",
"6038951", "Cheras",
"6087304", "Keningau",
"6087503", "Labuan",
"605546", "Ipoh",
"605899", "Semanggol",
"6039056", "Cheras",
"6082862", "Kota\ Samarahan",
"6036192", "Kuala\ Lumpur",
"6089296", "Elopura",
"6033265", "Kuala\ Selangor",
"606987", "Bakri",
"6083321", "Bandar\ Sri\ Aman",
"6038331", "Putrajaya",
"609725", "Kota\ Bharu",
"609824", "Kerteh",
"6087833", "Menumbok",
"606312", "Melaka",
"6035878", "Kinrara",
"605533", "Tanjung\ Rambutan",
"604923", "Changlon",
"609769", "Bachok",
"604267", "Penang",
"6032224", "Kuala\ Lumpur",
"6088662", "Kota\ Marudu",
"6084391", "Sibu",
"6084684", "Sarikei",
"604560", "Kepala\ Batas",
"607889", "Kota\ Tinggi",
"6039057", "Cheras",
"604820", "Penang",
"6085622", "Miri",
"6084796", "Kapit",
"607571", "Senai",
"6086292", "Bintulu",
"6088975", "Kota\ Belud",
"605421", "Besout",
"6035022", "Kinrara",
"607585", "Senai",
"607682", "Air\ Baloi",
"605855", "Taiping",
"6089965", "Lahad\ Datu",
"6088788", "Tuaran",
"605858", "Taiping",
"603401", "Kuala\ Lumpur",
"604238", "Penang",
"6089672", "Elopura",
"609213", "Jengka\ Lapan\ Belas",
"6048640", "Penang",
"607697", "Pontian",
"6036143", "Kuala\ Lumpur",
"6032726", "Kuala\ Lumpur",
"605620", "Telukintan",
"6082549", "Kuching",
"603749", "Kuala\ Lumpur",
"605236", "Ipoh",
"6089730", "Tawau",
"6087871", "Weston",
"609485", "Jengka\ Lapan\ Belas",
"6039212", "Kuala\ Lumpur",
"604307", "Penang",
"604552", "Tasek\ Gelugor",
"6039545", "Kuala\ Lumpur",
"609471", "Sungai\ Tekam",
"6088367", "Kota\ Kinabalu",
"60979", "Kota\ Bharu",
"605375", "Bota",
"609786", "Pasirputih",
"6089241", "Elopura",
"607938", "Tenang",
"605381", "Batugajah",
"6087880", "Membakut",
"604298", "Penang",
"604454", "Sungai\ Petani",
"609684", "Bukit\ Bading",
"6083474", "Debak",
"6084690", "Bintangor",
"6033101", "Pulau\ Ketam",
"6033396", "Kelang",
"6038787", "Mantin",
"6088967", "Tenghilan",
"605245", "Ipoh",
"609231", "Karak",
"6033163", "Kelang",
"609450", "Bukit\ Ibam",
"604680", "Penang",
"6087224", "Beaufort",
"6085285", "Lawas",
"606650", "Port\ Dickson",
"6089462", "Elopura",
"6038749", "Semenyih",
"6089952", "Balung",
"6036044", "Kampong\ Suharto",
"607822", "Penawar",
"608287", "Serian",
"607665", "Kulai",
"609328", "Kuala\ Lipis",
"605476", "Kampar",
"607562", "Senai",
"605296", "Tanjung\ Rambutan",
"6036065", "Kuala\ Kubu\ Baru",
"606537", "Jasin",
"6032182", "Kuala\ Lumpur",
"6032260", "Kuala\ Lumpur",
"6089982", "Tawau",
"607223", "Johor\ Bahru",
"604376", "Penang",
"607668", "Kulai",
"6039520", "Kuala\ Lumpur",
"607257", "Johor\ Bharu",
"6084642", "Sarikei",
"609369", "Dong",
"6087726", "Tenom",
"6082536", "Kuching",
"606529", "Jasin",
"605880", "Selama",
"603673", "Kuala\ Lumpur",
"609651", "Batu\ Rakit",
"6085206", "Kampung\ Pahlawan",
"6082807", "Simunjan",
"605354", "Ipoh",
"6082791", "Tebedu",
"606230", "Melaka",
"604475", "Kupang",
"6087850", "Kuala\ Penyu",
"606662", "Tekok\ Kemang",
"6087459", "Labuan",
"6088606", "Kudat",
"6082715", "Semantan",
"6082537", "Kuching",
"6033885", "Kelang",
"6087727", "Tenom",
"6082282", "Kuching",
"609404", "Pekan",
"6036125", "Kuala\ Lumpur",
"605853", "Sungai\ Nyior",
"6038705", "Mantin",
"608922", "Elopura",
"6047931", "Pokok\ Sena",
"6036303", "Genting",
"6036032", "Rawang",
"6038999", "Cheras",
"6083439", "Saratok",
"6032263", "Kuala\ Lumpur",
"605839", "Selama",
"6087853", "Kuala\ Penyu",
"6032201", "Kuala\ Lumpur",
"604400", "Padang\ Serai",
"6088607", "Kudat",
"607911", "Aver\ Panas",
"608838", "Kota\ Kinabalu",
"6089708", "Tawau",
"6034108", "Kuala\ Lumpur",
"604969", "Kuah",
"609541", "Sungai\ Lembing",
"605535", "Tanjung\ Rambutan",
"6034262", "Kuala\ Lumpur",
"605632", "Kampong\ Gajah",
"604925", "Ayer\ Hitam",
"607890", "Linggiu",
"6082739", "Lundu",
"609976", "Machang",
"605801", "Taiping",
"6085611", "Miri",
"604259", "Penang",
"6085769", "Marudi",
"6088405", "Kota\ Kinabalu",
"604928", "Changlon",
"6037862", "Kuala\ Lumpur",
"607504", "Tanjung\ Kupang",
"604627", "Penang",
"6039141", "Kuala\ Lumpur",
"6084693", "Bintangor",
"60723", "Johor\ Bahru",
"60458", "Sungai\ Bakap",
"608220", "Kuching",
"6087883", "Kuala\ Penyu",
"6088513", "Kota\ Kinabalu",
"60655", "Durian\ Tunggal",
"6086466", "Sebauh",
"6039221", "Kuala\ Lumpur",
"606540", "Durian\ Tunggal",
"6033277", "Kuala\ Selangor",
"609215", "Genting",
"6088302", "Kota\ Kinabalu",
"6088966", "Kota\ Belud",
"604536", "Tasek\ Gelugor",
"607441", "Senggarang",
"6085496", "Ladang\ Tiga",
"6082885", "Serian",
"6084634", "Pakan",
"6033282", "Kuala\ Selangor",
"6033160", "Kelang",
"6033855", "Sabak\ Bernam",
"6033080", "Kelang",
"6036095", "Rawang",
"6085665", "Miri",
"6086255", "Bintulu",
"6088746", "Kinarut",
"6085225", "Limbang",
"6038529", "Mantin",
"6035569", "Kinrara",
"609322", "Kuala\ Lipis",
"604310", "Penang",
"609437", "Perwira\ Jaya",
"6038025", "Kinrara",
"6088341", "Kota\ Kinabalu",
"608246", "Kuching",
"606637", "Seremban",
"605693", "Sitiawan",
"6083461", "Debak",
"607828", "Penawar",
"607484", "Batu\ Pahat",
"6033008", "Banting",
"604292", "Penang",
"6087820", "Sipitang",
"6036412", "Kuala\ Lumpur",
"6089849", "Kunak",
"609551", "Kuantan",
"6039102", "Cheras",
"6084702", "Bintangor",
"6038727", "Semenyih",
"6054620", "Kampar",
"607650", "Layang\-Layang",
"6082761", "Bau",
"6038912", "Semenyih",
"6032242", "Kuala\ Lumpur",
"6088413", "Kota\ Kinabalu",
"609789", "Pasir\ Putih",
"6084220", "Sibu",
"609584", "Gebeng",
"6033134", "Kelang",
"6089519", "Beluran",
"6084660", "Sarikei",
"6038609", "Kinrara",
"604893", "Penang",
"609468", "Maran",
"606967", "Bakri",
"607451", "Batu\ Pahat",
"6089717", "Tawau",
"6088618", "Kudat",
"608543", "Miri",
"6032035", "Kuala\ Lumpur",
"607662", "Kulai",
"6032279", "Kuala\ Lumpur",
"6089922", "Tawau",
"6089492", "Beluran",
"6089535", "Elopura",
"605410", "Tapah",
"607869", "Senai",
"606550", "Tampin",
"6086285", "Bintulu",
"6033050", "Kelang",
"6087438", "Labuan",
"604811", "Penang",
"6089275", "Elopura",
"605479", "Tapah",
"605299", "Tanjung\ Rambutan",
"605242", "Ipoh",
"6034811", "Kuala\ Lumpur",
"609224", "Bentong",
"6032331", "Kuala\ Lumpur",
"608832", "Kota\ Kinabalu",
"6084223", "Sibu",
"6089805", "Lahad\ Datu",
"6035624", "Kinrara",
"607706", "Keluang",
"6082222", "Kuching",
"604835", "Penang",
"6082662", "Kota\ Samarahan",
"604220", "Penang",
"607289", "Johor\ Bahru",
"609212", "Maran",
"6039175", "Kuala\ Lumpur",
"606640", "Port\ Dickson",
"6035879", "Kinrara",
"6089716", "Tawau",
"6087772", "Tambunan",
"6089562", "Kinabatangan",
"604539", "Tasek\ Gelugor",
"605255", "Ipoh",
"6033190", "Banting",
"6036185", "Kuala\ Lumpur",
"609440", "Bandar\ Tun\ Razak",
"6089856", "Kunak",
"60755", "Senai",
"6035032", "Kinrara",
"606391", "Tangga\ Batu",
"604914", "Alor\ Setar",
"6082548", "Kuching",
"607683", "Pontian",
"6035125", "Kinrara",
"6088747", "Kinarut",
"6082825", "Asajaya",
"604838", "Penang",
"605667", "Bruas",
"6085632", "Miri",
"6033179", "Kelang",
"6082700", "Lundu",
"6033083", "Kelang",
"609813", "Paka",
"6089202", "Elopura",
"605836", "Selama",
"6085770", "Long\ Lama",
"6038726", "Semenyih",
"604922", "Kangar",
"604966", "Kuah",
"6034292", "Kuala\ Lumpur",
"605717", "Parit\ Buntar",
"608233", "Kuching",
"6038321", "Putrajaya",
"6087823", "Sipitang",
"6033142", "Sepang",
"609979", "Machang",
"6032332", "Kuala\ Lumpur",
"605771", "Grik",
"60549", "Cameron\ Highland",
"6088888", "Ranau",
"607578", "Senai",
"6088393", "Kota\ Kinabalu",
"605350", "Batu\ Gajah",
"606720", "Seremban",
"6085765", "Marudi",
"606234", "Melaka",
"607443", "Rengit",
"6086323", "Bintulu",
"6036138", "Kuala\ Lumpur",
"607759", "Ayer\ Hitam",
"608465", "Sarikei",
"6084614", "Rejang",
"604369", "Serdang",
"6082661", "Kota\ Samarahan",
"6082889", "Serian",
"6082221", "Kuching",
"609246", "Bera",
"603563", "Kinrara",
"609475", "Maran",
"6087771", "Tambunan",
"6089561", "Kinabatangan",
"606681", "Seremban",
"609481", "Kota\ Gelangi",
"6088334", "Kota\ Kinabalu",
"6033324", "Kelang",
"6088533", "Kota\ Kinabalu",
"604462", "Jeniang",
"6036272", "Kuala\ Lumpur",
"609478", "Maran",
"606977", "Tangkak",
"6049373", "Kangar",
"609454", "Bukit\ Ibam",
"604684", "Penang",
"6035031", "Kinrara",
"6038995", "Cheras",
"6083435", "Saratok",
"6083592", "Lubuk\ Antu",
"606654", "Port\ Dickson",
"607913", "Labis",
"6037874", "Kuala\ Lumpur",
"6082324", "Asajaya",
"6087733", "Tenom",
"609721", "Kota\ Bharu",
"6084760", "Kanowit",
"609543", "Sungai\ Lembing",
"6036287", "Kuala\ Lumpur",
"60444", "Sungai\ Petani",
"6089623", "Elopura",
"6085631", "Miri",
"6087407", "Labuan",
"606480", "Ayer\ Hitam",
"605469", "Kampar",
"6089201", "Elopura",
"6082735", "Lundu",
"60473", "Alor\ Setar",
"607879", "Linggiu",
"6085744", "Beluru",
"609680", "Kuala\ Brang",
"6079010", "Tenggara",
"6084307", "Sibu",
"6038322", "Putrajaya",
"6032780", "Kuala\ Lumpur",
"6084896", "Stapang",
"609707", "Kota\ Bharu",
"6087848", "Sipitang",
"6088858", "Ranau",
"6034291", "Kuala\ Lumpur",
"603214", "Kuala\ Lumpur",
"6089617", "Elopura",
"6033141", "Sepang",
"607810", "Paloh",
"6036286", "Kuala\ Lumpur",
"6087406", "Labuan",
"6089871", "Tungku",
"606544", "Durian\ Tunggal",
"606332", "Melaka",
"606427", "Kuala\ Pilah",
"609928", "Gua\ Musang",
"609653", "Batu\ Rakit",
"604483", "Baling",
"6088342", "Kota\ Kinabalu",
"6087730", "Tenom",
"6082520", "Kuching",
"6049370", "Kangar",
"606792", "Sepang",
"607207", "Johor\ Bahru",
"605591", "Lintang",
"6084897", "Stapang",
"607221", "Johor\ Bahru",
"609639", "Kuala\ Brang",
"607500", "Tanjung\ Kupang",
"6082658", "Kuching",
"6039101", "Cheras",
"606439", "Simpang\ Empat",
"6036411", "Kuala\ Lumpur",
"6086484", "Balingan",
"6089616", "Elopura",
"6032783", "Kuala\ Lumpur",
"609832", "Merchang",
"6062710", "Sungai\ Rambai",
"608224", "Kuching",
"6084306", "Sibu",
"6038911", "Semenyih",
"6082762", "Bau",
"609536", "Kuantan",
"6032088", "Kuala\ Lumpur",
"6082846", "Damai\ Beach",
"609233", "Genting",
"6089894", "Kunak",
"6037839", "Kuala\ Lumpur",
"6086320", "Bintulu",
"6032241", "Kuala\ Lumpur",
"604404", "Mahang",
"607746", "Renggam",
"604218", "Penang",
"608891", "Papar",
"605677", "Bruas",
"6089748", "Tawau",
"6087485", "Labuan",
"6083344", "Bandar\ Sri\ Aman",
"607894", "Kota\ Tinggi",
"6082688", "Kuching",
"607795", "Felda\ Tenggaroh",
"6089921", "Balung",
"6089491", "Beluran",
"604757", "Alor\ Setar",
"6034812", "Kuala\ Lumpur",
"6088861", "Bongawan",
"606759", "Mantin",
"605208", "Ipoh",
"6093260", "Padang\ Tengku",
"6038687", "Putrajaya",
"606311", "Melaka",
"6039548", "Cheras",
"6083562", "Roban",
"6082281", "Kuching",
"6082829", "Asajaya",
"607720", "Mersing",
"604789", "Alor\ Setar",
"6084790", "Kapit",
"604468", "Bedong",
"606554", "Tampin",
"6085604", "Miri",
"6087506", "Labuan",
"603269", "Kuala\ Lumpur",
"6082553", "Kuching",
"6088204", "Kota\ Kinabalu",
"607675", "Pontian",
"6032202", "Kuala\ Lumpur",
"605466", "Kampar",
"609580", "Gebeng",
"6086584", "Tatau",
"606733", "Mantin",
"6088785", "Tuaran",
"6085612", "Miri",
"6089968", "Lahad\ Datu",
"6037861", "Kuala\ Lumpur",
"6088363", "Kota\ Kinabalu",
"6084237", "Sibu",
"607678", "Pontian",
"607654", "Linggiu",
"605782", "Kuala\ Kangsar",
"6089736", "Tawau",
"609310", "Kuala\ Lipis",
"607756", "Renggam",
"6032720", "Kuala\ Lumpur",
"6039222", "Kuala\ Lumpur",
"604465", "Bedong",
"604551", "Tasek\ Gelugor",
"6036073", "Kuala\ Kubu\ Baru",
"6082583", "Kota\ Samarahan",
"6036189", "Kuala\ Lumpur",
"605368", "Pusing",
"6039179", "Kuala\ Lumpur",
"609249", "Bera",
"604747", "Alor\ Setar",
"6089591", "Telupid",
"605205", "Ipoh",
"604314", "Penang",
"6038657", "Cheras",
"6088301", "Kota\ Kinabalu",
"6033281", "Kuala\ Selangor",
"603228", "Kuala\ Lumpur",
"6032856", "Kuala\ Lumpur",
"6089242", "Elopura",
"6032723", "Kuala\ Lumpur",
"6033268", "Kuala\ Selangor",
"6086424", "Sebauh",
"6089864", "Lahad\ Datu",
"608541", "Miri",
"6085454", "Miri",
"607749", "Ayer\ Hitam",
"608976", "Tawau",
"609914", "Gua\ Musang",
"6085238", "Limbang",
"6089515", "Beluran",
"6038605", "Kinrara",
"607427", "Senggarang",
"6088360", "Kota\ Kinabalu",
"6084236", "Sibu",
"6086350", "Bintulu",
"6033102", "Pulau\ Ketam",
"609838", "Merchang",
"6038656", "Cheras",
"6035544", "Kinrara",
"6082639", "Kuching",
"6089279", "Elopura",
"609966", "Kuala\ Krai",
"6032857", "Kuala\ Lumpur",
"6089461", "Elopura",
"6039080", "Cheras",
"606798", "Mantin",
"6089951", "Balung",
"609256", "Triang",
"604891", "Penang",
"606221", "Melaka",
"6082580", "Kota\ Samarahan",
"6032039", "Kuala\ Lumpur",
"6034258", "Kuala\ Lumpur",
"6032275", "Kuala\ Lumpur",
"6037718", "Kuala\ Lumpur",
"6089290", "Elopura",
"6039050", "Cheras",
"60445", "Bedong",
"6032181", "Kuala\ Lumpur",
"6087507", "Labuan",
"6089981", "Tawau",
"604224", "Penang",
"6082550", "Kuching",
"609553", "Kuantan",
"60648", "Kuala\ Pilah",
"6034288", "Kuala\ Lumpur",
"6084641", "Sarikei",
"6038686", "Putrajaya",
"609867", "Kemasik",
"6035565", "Kinrara",
"606644", "Port\ Dickson",
"604390", "Penang",
"606335", "Melaka",
"6047455", "Alor\ Setar",
"605613", "Teluk\ Intan",
"6036099", "Rawang",
"6038525", "Mantin",
"609220", "Bentong",
"6039134", "Kuala\ Lumpur",
"6084734", "Julau",
"607787", "Keluang",
"606436", "Johol",
"609835", "Dungun",
"605841", "Taiping",
"6032028", "Kuala\ Lumpur",
"6082628", "Kuching",
"605763", "Lenggong",
"605691", "Sitiawan",
"608877", "Kinarut",
"609539", "Kuantan",
"606617", "Kuala\ Klawang",
"608921", "Elopura",
"6082888", "Serian",
"6038750", "Semenyih",
"6083322", "Bandar\ Sri\ Aman",
"6082393", "Sejingkat",
"609417", "Nenasi",
"604330", "Penang",
"607924", "Labis",
"6086371", "Sebauh",
"604790", "Pokok\ Sena",
"6088889", "Ranau",
"605631", "Kampong\ Gajah",
"609542", "Sungai\ Lembing",
"609599", "Gambang",
"6088661", "Kotamarudu",
"605506", "Ipoh",
"6084392", "Sibu",
"6032267", "Kuala\ Lumpur",
"6085621", "Miri",
"609846", "Kuala\ Brang",
"607387", "Johor\ Bahru",
"6089633", "Elopura",
"6082273", "Kuching",
"6035021", "Kinrara",
"606496", "Kuala\ Klawang",
"6083425", "Roban",
"606276", "Melaka",
"609794", "Kok\ Lanas",
"6086291", "Bintulu",
"6088408", "Kota\ Kinabalu",
"607912", "Aver\ Panas",
"6036139", "Kuala\ Lumpur",
"605609", "Teluk\ Intan",
"6033166", "Kelang",
"6036081", "Batu\ Arang",
"6088960", "Tenghilan",
"604463", "Jeniang",
"6089671", "Elopura",
"6034105", "Kuala\ Lumpur",
"6089705", "Tawau",
"6087440", "Labuan",
"605203", "Chemor",
"6083418", "Bandar\ Sri\ Aman",
"6033273", "Batang\ Berjuntai",
"609947", "Ayer\ Lanas",
"6086460", "Belaga",
"6087887", "Membakut",
"6038708", "Mantin",
"607442", "Senggarang",
"6036128", "Kuala\ Lumpur",
"607279", "Johor\ Bahru",
"6088517", "Kota\ Kinabalu",
"6084875", "Mukah",
"6038780", "Mantin",
"605430", "Besout",
"6087872", "Weston",
"6033393", "Kelang",
"607210", "Johor\ Bahru",
"606398", "Tangga\ Batu",
"605618", "Changkat\ Keruing",
"6033270", "Batang\ Berjuntai",
"6083585", "Lubukantu",
"6086590", "Tatau",
"604497", "Bedong",
"609779", "Bachok",
"6087443", "Labuan",
"6082659", "Kota\ Samarahan",
"609558", "Kuantan",
"604722", "Kulim",
"6033167", "Kelang",
"604766", "Alor\ Setar",
"6082299", "Kuching",
"609710", "Kota\ Bharu",
"6085493", "Sundar",
"6089817", "Lahatdatu",
"605768", "Lenggong",
"604347", "Penang",
"6038783", "Mantin",
"6084696", "Bintangor",
"607561", "Senai",
"6092410", "Telemong",
"6087214", "Beaufort",
"608824", "Kota\ Kinabalu",
"609660", "Kuala\ Brang",
"609232", "Karak",
"604616", "Penang",
"608564", "Miri",
"6088516", "Kota\ Kinabalu",
"606460", "Bahau",
"6033010", "Pulau\ Ketam",
"604570", "Tasek\ Gelugor",
"604714", "Alor\ Setar",
"6082803", "Simunjan",
"609833", "Bukit\ Besi",
"6085200", "Limbang",
"6084754", "Kanowit",
"604818", "Penang",
"605765", "Lenggong",
"6085288", "Lawas",
"6035103", "Kinrara",
"6038000", "Putrajaya",
"6087311", "Keningau",
"6082530", "Kuching",
"6035161", "Kinrara",
"609555", "Kuantan",
"6032089", "Kuala\ Lumpur",
"6033342", "Kelang",
"6089749", "Tawau",
"6084802", "Sibu",
"607906", "Segamat",
"606793", "Mantin",
"606661", "Tekok\ Kemang",
"6098700", "Kemasik",
"609859", "Chukai",
"6089630", "Elopura",
"6082270", "Kuching",
"6083555", "Bandar\ Sri\ Aman",
"6038952", "Cheras",
"6036191", "Kuala\ Lumpur",
"606333", "Melaka",
"6032266", "Kuala\ Lumpur",
"6089850", "Kunak",
"6032687", "Kuala\ Lumpur",
"605808", "Taiping",
"6085460", "Miri",
"6035614", "Kinrara",
"609548", "Gambang",
"608831", "Kota\ Kinabalu",
"60457", "Kepala\ Batas",
"607918", "Aver\ Panas",
"6087344", "Keningau",
"6039232", "Kuala\ Lumpur",
"609473", "Bukit\ Ibam",
"6089969", "Lahad\ Datu",
"6083485", "Betong",
"605783", "Kuala\ Kangsar",
"6089726", "Tawau",
"6039549", "Cheras",
"6032730", "Kuala\ Lumpur",
"604323", "Penang",
"6082828", "Asajaya",
"607276", "Johor\ Bahru",
"6088674", "Kudat",
"606387", "Kuala\ Sungai\ Baru",
"607445", "Batu\ Pahat",
"6036158", "Kuala\ Lumpur",
"6038074", "Kinrara",
"6082545", "Kuching",
"6033363", "Kelang",
"607767", "Mersing",
"6036188", "Kuala\ Lumpur",
"607448", "Batu\ Pahat",
"6083406", "Maludam",
"6082755", "Kuching",
"6087462", "Labuan",
"605423", "Tapah",
"6032382", "Kuala\ Lumpur",
"606517", "Jasin",
"6039410", "Cheras",
"6089664", "Elopura",
"6036100", "Genting",
"6035115", "Kinrara",
"607915", "Bukit\ Kepong",
"6088743", "Kinarut",
"6084362", "Sibu",
"6032297", "Kuala\ Lumpur",
"6036021", "Batuarang",
"609849", "Dungun",
"6088979", "Kota\ Belud",
"606499", "Batu\ Kikir",
"6082301", "Kuching",
"607738", "Lavang\-Lavang",
"605805", "Taiping",
"604921", "Kangar",
"6038091", "Kinrara",
"6035522", "Kinrara",
"6036103", "Genting",
"6089278", "Elopura",
"605624", "Hutan\ Melintang",
"609321", "Kuala\ Lipis",
"6038723", "Semenyih",
"6032605", "Kuala\ Lumpur",
"605726", "Parit\ Buntar",
"6032771", "Kuala\ Lumpur",
"6089538", "Elopura",
"609238", "Karak",
"6034259", "Kuala\ Lumpur",
"6088615", "Kudat",
"6037661", "Kuala\ Lumpur",
"6037480", "Kuala\ Lumpur",
"6035191", "Kinrara",
"6033269", "Kuala\ Selangor",
"6078710", "Tiram",
"605612", "Sitiawan",
"604291", "Penang",
"609856", "Chukai",
"604471", "Sungai\ Bakap",
"605388", "Bota",
"6087810", "Sipitang",
"6082707", "Kota\ Samarahan",
"6087750", "Tenom",
"604485", "Padang\ Serai",
"6088740", "Kinarut",
"609552", "Kuantan",
"6032296", "Kuala\ Lumpur",
"6033086", "Kelang",
"605385", "Bota",
"606294", "Melaka",
"606474", "Palong",
"606458", "Serting",
"609957", "Batu\ Gajah",
"604564", "Kepala\ Batas",
"609776", "Bachok",
"604488", "Padang\ Serai",
"6038872", "Putrajaya",
"6035482", "Kinrara",
"6032848", "Kuala\ Lumpur",
"604824", "Penang",
"6082629", "Kuching",
"607711", "Keluang",
"6089713", "Tawau",
"604769", "Alor\ Setar",
"6033197", "Banting",
"609267", "Jerantut",
"6032686", "Kuala\ Lumpur",
"6085463", "Miri",
"6082471", "Kuching",
"6037735", "Kuala\ Lumpur",
"605750", "Kuala\ Kangsar",
"6089853", "Kunak",
"6085401", "Miri",
"6037719", "Kuala\ Lumpur",
"609820", "Paka",
"6034289", "Kuala\ Lumpur",
"609235", "Genting",
"6034821", "Kuala\ Lumpur",
"605241", "Ipoh",
"609560", "Kuantan",
"6037859", "Kuala\ Lumpur",
"606906", "Muar",
"607793", "Endau",
"607661", "Kulai",
"6052320", "Ipoh",
"6032733", "Kuala\ Lumpur",
"604619", "Penang",
"6089727", "Tawau",
"6088792", "Tuaran",
"6085668", "Miri",
"605486", "Cameron\ Highland",
"605358", "Batu\ Gajah",
"606728", "Seremban",
"603928", "Kuala\ Lumpur",
"6083548", "Maludam",
"6083436", "Saratok",
"609582", "Gebeng",
"6038996", "Cheras",
"6088880", "Ranau",
"606471", "Simpang\ Durian",
"6085470", "Miri",
"6082683", "Kuching",
"6037772", "Kuala\ Lumpur",
"609685", "Kuala\ Brang",
"604455", "Sungai\ Petani",
"604561", "Kepala\ Batas",
"6032083", "Kuala\ Lumpur",
"6034217", "Kuala\ Lumpur",
"609949", "Ayer\ Lanas",
"6036130", "Kuala\ Lumpur",
"607570", "Senai",
"6032222", "Kuala\ Lumpur",
"607277", "Johor\ Bahru",
"605244", "Ipoh",
"6088664", "Kota\ Marudu",
"6084682", "Sarikei",
"6085264", "Sundar",
"6063131", "Melaka",
"6086294", "Bintulu",
"604356", "Tasek\ Gelugor",
"6089942", "Tawau",
"607766", "Mersing",
"6082809", "Simunjan",
"607722", "Renggam",
"6084895", "Kuala\ Igan",
"6036084", "Batu\ Arang",
"609419", "Kuala\ Rompin",
"607482", "Kangkar\ Baru",
"604906", "Changlon",
"605621", "Telukintan",
"6039074", "Cheras",
"609324", "Kuala\ Lipis",
"609470", "Bukit\ Ibam",
"6089674", "Elopura",
"6085766", "Marudi",
"6087472", "Labuan",
"6037931", "Kuala\ Lumpur",
"6086391", "Bintulu",
"6039202", "Kuala\ Lumpur",
"6082293", "Kuching",
"609312", "Kuala\ Lipis",
"6088969", "Kota\ Belud",
"604320", "Penang",
"6095070", "Kuantan",
"6086860", "Bintulu",
"6086469", "Belaga",
"6089281", "Elopura",
"6088850", "Ranau",
"607934", "Labis",
"6032788", "Kuala\ Lumpur",
"609688", "Kuala\ Brang",
"6085767", "Marudi",
"6089792", "Semporna",
"606357", "Tangga\ Batu",
"605727", "Parit\ Buntar",
"6082845", "Damai\ Beach",
"609405", "Pekan",
"6033242", "Sekinchan",
"605449", "Tanjung\ Malim",
"605753", "Kuala\ Kangsar",
"6087486", "Labuan",
"6087738", "Tenom",
"6033122", "Tk\ Panglima\ Garang",
"6088853", "Ranau",
"6082650", "Kuching",
"6033279", "Batang\ Berjuntai",
"6088904", "Papar",
"6032193", "Kuala\ Lumpur",
"609823", "Al\ Muktafi\ Billa\ H\ Shah",
"604673", "Penang",
"607508", "Tanjung\ Kupang",
"6087211", "Beaufort",
"604924", "Changlon",
"6082290", "Kuching",
"6084811", "Mukah",
"607505", "Tanjung\ Kupang",
"6087405", "Labuan",
"6058300", "Taiping",
"6082539", "Kuching",
"604499", "Baling",
"6086328", "Bintulu",
"6084751", "Kanowit",
"6087729", "Tenom",
"6032080", "Kuala\ Lumpur",
"6033290", "Kelang",
"6036285", "Kuala\ Lumpur",
"60536", "Batu\ Gajah",
"609266", "Jerantut",
"6082279", "Kuching",
"6087314", "Keningau",
"604210", "Penang",
"609222", "Bentong",
"6083437", "Saratok",
"6089615", "Elopura",
"6035164", "Kinrara",
"6088609", "Kudat",
"604392", "Penang",
"6088538", "Kota\ Kinabalu",
"6082403", "Kuching",
"605487", "Cameron\ Highland",
"6087302", "Keningau",
"6093141", "Kuala\ Lipis",
"609214", "Bentong",
"6084305", "Sibu",
"606907", "Muar",
"609408", "Kuala\ Rompin",
"6082864", "Kota\ Samarahan",
"6082737", "Lundu",
"6084798", "Kapit",
"6035611", "Kinrara",
"604460", "Bedong",
"60733", "Johor\ Bahru",
"6039540", "Kuala\ Lumpur",
"6038211", "Semenyih",
"605743", "Manong",
"6084844", "Mukah",
"6037713", "Kuala\ Lumpur",
"6034022", "Kuala\ Lumpur",
"6087341", "Keningau",
"604931", "Changlon",
"60779", "Mersing",
"606519", "Jasin",
"6088351", "Kota\ Kinabalu",
"6089517", "Beluran",
"6089735", "Semporna",
"607485", "Batu\ Pahat",
"607386", "Johor\ Bahru",
"6086303", "Bintulu",
"606664", "Tekok\ Kemang",
"6088671", "Kudat",
"6088705", "Kota\ Kinabalu",
"6089859", "Kunak",
"605507", "Ipoh",
"6038071", "Kinrara",
"6089523", "Telupid",
"606277", "Melaka",
"609315", "Kuala\ Lipis",
"606497", "Rembau",
"605433", "Tapah",
"6032023", "Kuala\ Lumpur",
"607670", "Kulai",
"6088970", "Kota\ Belud",
"6038527", "Mantin",
"604333", "Penang",
"607516", "Tanjung\ Kupang",
"6038966", "Cheras",
"6035567", "Kinrara",
"6033176", "Kelang",
"609682", "Kuala\ Brang",
"609946", "Ayer\ Lanas",
"6082830", "Sebangan",
"609585", "Gebeng",
"6087505", "Labuan",
"6082312", "Kuching",
"609571", "Kuantan",
"6037883", "Kuala\ Lumpur",
"6034253", "Kuala\ Lumpur",
"607488", "Batu\ Pahat",
"6082304", "Kota\ Samarahan",
"6088786", "Tuaran",
"6082503", "Kuching",
"6038094", "Kinrara",
"6087862", "Bongawan",
"608821", "Kota\ Kinabalu",
"609225", "Bentong",
"6038892", "Putrajaya",
"609959", "Batu\ Gajah",
"6033620", "Kelang",
"609830", "Paka",
"6033182", "Banting",
"6033260", "Kuala\ Selangor",
"6038526", "Mantin",
"6047456", "Alor\ Setar",
"6082491", "Kuching",
"603893", "Cheras",
"609269", "Damak",
"6033177", "Kelang",
"6088973", "Kota\ Belud",
"6088368", "Kota\ Kinabalu",
"6035566", "Kinrara",
"6037664", "Kuala\ Lumpur",
"605348", "Batu\ Gajah",
"6088787", "Tuaran",
"606790", "Mantin",
"6084832", "Matu",
"6034250", "Kuala\ Lumpur",
"6036078", "Batu\ Arang",
"606330", "Melaka",
"6037880", "Kuala\ Lumpur",
"604918", "Alor\ Setar",
"605254", "Ipoh",
"6082894", "Serian",
"6034280", "Kuala\ Lumpur",
"6034162", "Kuala\ Lumpur",
"604398", "Penang",
"604915", "Changlon",
"605281", "Ipoh",
"6039058", "Cheras",
"6037710", "Kuala\ Lumpur",
"6036145", "Kuala\ Lumpur",
"6087232", "Beaufort",
"605446", "Tapah",
"609402", "Chini",
"6089901", "Merotai",
"6084235", "Sibu",
"6039543", "Cheras",
"607921", "Labis",
"6066920", "Linggi",
"609713", "Kota\ Bharu",
"6082474", "Kuching",
"607907", "Labis",
"6032020", "Kuala\ Lumpur",
"6085404", "Miri",
"6035882", "Kinrara",
"6088931", "Kota\ Belud",
"6089520", "Telupid",
"6038655", "Cheras",
"606463", "Palong",
"609228", "Bilut\ Valley",
"6032276", "Kuala\ Lumpur",
"60667", "Seremban",
"604573", "Tasek\ Gelugor",
"6082871", "Baki",
"6086300", "Bintulu",
"6082620", "Kuching",
"6082260", "Kuching",
"60929", "Mentakab",
"609663", "Batu\ Rakit",
"604500", "Kulim",
"609286", "Kuala\ Krau",
"60472", "Alor\ Setar",
"6085283", "Lawas",
"6065350", "Jasin",
"6033165", "Kelang",
"6033850", "Banting",
"606979", "Tangkak",
"6035622", "Kinrara",
"6082808", "Simunjan",
"606641", "Port\ Dickson",
"6089706", "Tawau",
"6034106", "Kuala\ Lumpur",
"606910", "Muar",
"6082224", "Kuching",
"6082664", "Kota\ Samarahan",
"605467", "Kampar",
"6083549", "Pantu",
"607483", "Batu\ Pahat",
"6087774", "Tambunan",
"6034271", "Kuala\ Lumpur",
"605796", "Grik",
"6088331", "Kota\ Kinabalu",
"6033321", "Kelang",
"6037260", "Kuala\ Lumpur",
"6088968", "Kota\ Belud",
"608544", "Miri",
"6082321", "Kuching",
"6098000", "Kerteh",
"6086468", "Belaga",
"607757", "Renggam",
"6033224", "Sabak\ Bernam",
"604367", "Serdang",
"6083410", "Kabong",
"6089204", "Elopura",
"6036120", "Kuala\ Lumpur",
"605438", "Tapah",
"606390", "Tangga\ Batu",
"607218", "Johor\ Bahru",
"6036063", "Kuala\ Kubu\ Baru",
"6034294", "Kuala\ Lumpur",
"606224", "Melaka",
"60448", "Kulim",
"60645", "Bahau",
"6088653", "Kotamarudu",
"6082850", "Serian",
"609583", "Gebeng",
"605679", "Sitiawan",
"6038761", "Semenyih",
"609550", "Kuantan",
"608977", "Tawau",
"609718", "Kota\ Bharu",
"6083413", "Kabong",
"6035721", "Kinrara",
"605610", "Telukintan",
"6036243", "Kuala\ Lumpur",
"605872", "Semanggol",
"607426", "Parit\ Betak",
"607651", "Layang\-Layang",
"609668", "Batu\ Rakit",
"6083427", "Roban",
"604554", "Tasek\ Gelugor",
"606468", "Ayer\ Hitam",
"609223", "Bentong",
"6082713", "Semantan",
"6032265", "Kuala\ Lumpur",
"6087739", "Tenom",
"6038703", "Mantin",
"604759", "Alor\ Setar",
"6036123", "Kuala\ Lumpur",
"6088981", "Tenghilan",
"606429", "Bahau",
"6038080", "Kinrara",
"6034107", "Kuala\ Lumpur",
"607450", "Senggarang",
"6088608", "Kudat",
"607209", "Johor\ Bahru",
"6038008", "Putrajaya",
"609665", "Kuala\ Brang",
"6034801", "Kuala\ Lumpur",
"6065110", "Jasin",
"6033132", "Tk\ Panglima\ Garang",
"606551", "Simpang\ Empat",
"606465", "Ayer\ Hitam",
"6085280", "Lawas",
"609822", "Al\ Muktafi\ Billa\ H\ Shah",
"604672", "Penang",
"604810", "Penang",
"608234", "Kuching",
"609866", "Kemasik",
"6083341", "Bandar\ Sri\ Aman",
"605752", "Kuala\ Kangsar",
"607684", "Pontian",
"6084695", "Bintangor",
"606437", "Johol",
"6084877", "Mukah",
"607786", "Felda\ Kahang\ Timur",
"609637", "Kuala\ Brang",
"6087728", "Tenom",
"6088403", "Kota\ Kinabalu",
"6082538", "Kuching",
"604913", "Alor\ Setar",
"608876", "Kinarut",
"609814", "Paka",
"6039771", "Kuala\ Lumpur",
"6088515", "Kota\ Kinabalu",
"6087885", "Kuala\ Penyu",
"6082278", "Kuching",
"6088617", "Kudat",
"607910", "Tenang",
"6089718", "Tawau",
"604401", "Kulim",
"6082284", "Kuching",
"607891", "Kota\ Tinggi",
"6033381", "Kelang",
"6087437", "Labuan",
"6078010", "Mersing",
"6085601", "Miri",
"6036034", "Rawang",
"609540", "Kuantan",
"6037650", "Kuala\ Lumpur",
"6088201", "Kota\ Kinabalu",
"609247", "Bera",
"6084799", "Kapit",
"604453", "Kulim",
"6085223", "Limbang",
"6086253", "Bintulu",
"6085663", "Miri",
"6036093", "Rawang",
"604332", "Penang",
"6034264", "Kuala\ Lumpur",
"6086581", "Tatau",
"604427", "Kulim",
"6038023", "Kinrara",
"6035120", "Kinrara",
"6087761", "Tenom",
"6036150", "Kuala\ Lumpur",
"6039170", "Kuala\ Lumpur",
"604787", "Alor\ Setar",
"606541", "Durian\ Tunggal",
"6089533", "Elopura",
"6084770", "Song",
"6032302", "Kuala\ Lumpur",
"605432", "Trolak",
"6036262", "Kuala\ Lumpur",
"6035652", "Kinrara",
"606757", "Mantin",
"606976", "Bukit\ Gambir",
"6036108", "Genting",
"607440", "Batu\ Pahat",
"6089273", "Elopura",
"6088830", "Tuaran",
"605353", "Ipoh",
"6086283", "Bintulu",
"6082381", "Kuching",
"6034032", "Kuala\ Lumpur",
"60745", "Sri\ Gading",
"605594", "Chemor",
"6088415", "Kota\ Kinabalu",
"607224", "Johor\ Bahru",
"6089725", "Tawau",
"6088304", "Kota\ Kinabalu",
"6082546", "Kuching",
"609706", "Kota\ Bharu",
"6033007", "Kuala\ Selangor",
"605799", "Lenggong",
"608221", "Kuching",
"6033284", "Kuala\ Selangor",
"6084632", "Selalang",
"606651", "Port\ Dickson",
"606426", "Ayer\ Hitam",
"604572", "Tasek\ Gelugor",
"6089861", "Lahad\ Datu",
"606462", "Palong",
"609825", "Kerteh",
"609662", "Kuala\ Brang",
"609451", "Bandar\ Tun\ Razak",
"609565", "Kuantan",
"6083472", "Betong",
"609529", "Kuantan",
"6032030", "Kuala\ Lumpur",
"6032685", "Kuala\ Lumpur",
"6084773", "Song",
"6039173", "Kuala\ Lumpur",
"609869", "Kemasik",
"605380", "Pusing",
"6082547", "Kuching",
"6087222", "Beaufort",
"6035541", "Kinrara",
"606603", "Seremban",
"607789", "Keluang",
"609712", "Kota\ Bharu",
"6033006", "Sabak\ Bernam",
"60450", "Tasek\ Gelugor",
"6089464", "Elopura",
"6036042", "Kampong\ Suharto",
"608991", "Tawau",
"6089954", "Balung",
"607468", "Sri\ Gading",
"6088369", "Kota\ Kinabalu",
"6087818", "Sipitang",
"605854", "Sungai\ Nyior",
"6034065", "Kuala\ Lumpur",
"605676", "Changkat\ Keruing",
"6089984", "Tawau",
"6057180", "Parit\ Buntar",
"605881", "Selama",
"6087436", "Labuan",
"608759", "Labuan",
"607747", "Ayer\ Hitam",
"605758", "Kuala\ Kangsar",
"606231", "Melaka",
"6088616", "Kudat",
"6084644", "Sarikei",
"609650", "Batu\ Rakit",
"607429", "Senggarang",
"603892", "Semenyih",
"6084731", "Julau",
"6039131", "Kuala\ Lumpur",
"60644", "Tampin",
"6035123", "Kinrara",
"6038020", "Kinrara",
"6039059", "Cheras",
"6033085", "Kelang",
"6032295", "Kuala\ Lumpur",
"6036090", "Rawang",
"608733", "Keningau",
"6085481", "Bekenu",
"6085660", "Miri",
"609828", "Paka",
"6085220", "Limbang",
"6033630", "Banting",
"609568", "Kuantan",
"607400", "Rengit",
"6089862", "Lahad\ Datu",
"6086422", "Sebauh",
"6089244", "Elopura",
"6038740", "Semenyih",
"6039018", "Cheras",
"60577", "Kuala\ Kangsar",
"6085452", "Miri",
"607969", "Bukit\ Gambir",
"6084308", "Sibu",
"604911", "Alor\ Setar",
"605285", "Ipoh",
"607925", "Labis",
"6083471", "Betong",
"6088535", "Kota\ Kinabalu",
"6084380", "Sibu",
"608247", "Sejingkat",
"607259", "Johor\ Bahru",
"609367", "Dong",
"6089618", "Elopura",
"604890", "Penang",
"6087889", "Membakut",
"6088395", "Kota\ Kinabalu",
"6035542", "Kinrara",
"6087221", "Beaufort",
"6087480", "Labuan",
"605413", "Cameron\ Highland",
"6089505", "Beluran",
"606527", "Jasin",
"6088519", "Kota\ Kinabalu",
"60668", "Rembau",
"6086325", "Bintulu",
"6087408", "Labuan",
"60465", "Penang",
"6084699", "Bintangor",
"605840", "Taiping",
"609221", "Bentong",
"605690", "Sitiawan",
"606966", "Bakri",
"6084821", "Daro",
"6087450", "Labuan",
"604313", "Penang",
"607832", "Penawar",
"607928", "Aver\ Panas",
"6087735", "Tenom",
"6035590", "Kinrara",
"6039132", "Kuala\ Lumpur",
"6084350", "Sibu",
"6038993", "Cheras",
"6082686", "Kuching",
"6039025", "Kuala\ Lumpur",
"604709", "Alor\ Setar",
"6085482", "Kampung\ Bakam",
"6036137", "Kuala\ Lumpur",
"605288", "Pusing",
"6089746", "Tawau",
"604391", "Penang",
"6032785", "Kuala\ Lumpur",
"607680", "Pontian",
"6083564", "Engkilili",
"604629", "Penang",
"6087453", "Labuan",
"609575", "Kuantan",
"6033382", "Kelang",
"604866", "Penang",
"6082730", "Lundu",
"604562", "Kepala\ Batas",
"607707", "Keluang",
"609581", "Gebeng",
"604526", "Kulim",
"606472", "Kuala\ Klawang",
"606292", "Melaka",
"6058307", "Selama",
"607721", "Renggam",
"6032087", "Kuala\ Lumpur",
"609913", "Gua\ Musang",
"6033297", "Kelang",
"605528", "Ipoh",
"6089747", "Tawau",
"6036136", "Kuala\ Lumpur",
"607298", "Johor\ Bahru",
"604938", "Kangar",
"603831", "Putrajaya",
"608825", "Kota\ Kinabalu",
"6088886", "Ranau",
"6083430", "Saratok",
"6038990", "Cheras",
"608565", "Miri",
"6085614", "Miri",
"6084353", "Sibu",
"6082687", "Kuching",
"606379", "Tangga\ Batu",
"6084765", "Kanowit",
"608828", "Kota\ Kinabalu",
"6084898", "Sibu",
"6036261", "Kuala\ Lumpur",
"6035651", "Kinrara",
"605829", "Taiping",
"6084383", "Sibu",
"6032301", "Kuala\ Lumpur",
"607481", "Kangkar\ Baru",
"6033169", "Kelang",
"6038691", "Semenyih",
"605525", "Ipoh",
"6089557", "Kinabatangan",
"607475", "Sri\ Gading",
"607295", "Johor\ Bahru",
"605622", "Telukintan",
"6039224", "Kuala\ Lumpur",
"6034031", "Kuala\ Lumpur",
"604967", "Kuah",
"604223", "Penang",
"6082382", "Kuching",
"6085760", "Marudi",
"605837", "Selama",
"604668", "Penang",
"605614", "Sitiawan",
"609759", "Pasirputih",
"609443", "Bandar\ Tun\ Razak",
"6083545", "Pantu",
"606643", "Port\ Dickson",
"605716", "Parit\ Buntar",
"6087483", "Labuan",
"6084631", "Selalang",
"607734", "Ayer\ Hitam",
"6037886", "Kuala\ Lumpur",
"609787", "Machang",
"604289", "Penang",
"6034256", "Kuala\ Lumpur",
"607220", "Johor\ Bahru",
"6088344", "Kota\ Kinabalu",
"606969", "Bukit\ Kepong",
"6088783", "Tuaran",
"6082506", "Kuching",
"6033610", "Kuala\ Selangor",
"6083464", "Debak",
"605883", "Taiping",
"6037202", "Kuala\ Lumpur",
"6084238", "Sibu",
"6038963", "Cheras",
"6032299", "Kuala\ Lumpur",
"6047450", "Alor\ Setar",
"6088977", "Kota\ Belud",
"6038520", "Kinrara",
"6089295", "Elopura",
"6036148", "Kuala\ Lumpur",
"607444", "Senggarang",
"606233", "Melaka",
"6039055", "Cheras",
"605477", "Kampar",
"607527", "Kangkar\ Pulai",
"6082555", "Kuching",
"6088982", "Tenghilan",
"607867", "Tiram",
"6082764", "Bau",
"6039085", "Cheras",
"6082626", "Kuching",
"604377", "Penang",
"606601", "Seremban",
"606536", "Jasin",
"6032270", "Kuala\ Lumpur",
"6036075", "Kuala\ Kubu\ Baru",
"607922", "Bekok",
"604540", "Tasek\ Gelugor",
"605282", "Ipoh",
"6034802", "Kuala\ Lumpur",
"607256", "Johor\ Bahru",
"6089967", "Lahad\ Datu",
"6039368", "Kuala\ Lumpur",
"6083342", "Bandar\ Sri\ Aman",
"6032026", "Kuala\ Lumpur",
"6039547", "Cheras",
"6038688", "Putrajaya",
"606653", "Port\ Dickson",
"607914", "Tenang",
"604683", "Penang",
"609453", "Bukit\ Ibam",
"6039772", "Kuala\ Lumpur",
"607838", "Penawar",
"605804", "Taiping",
"609544", "Kuantan",
"6084229", "Sibu",
"6038600", "Kinrara",
"6089510", "Beluran",
"604932", "Ayer\ Hitam",
"605625", "Telukintan",
"6038408", "Cheras",
"605522", "Ipoh",
"6032027", "Kuala\ Lumpur",
"6089966", "Lahad\ Datu",
"608257", "Kuching",
"6086307", "Bintulu",
"6082627", "Kuching",
"6032273", "Kuala\ Lumpur",
"609480", "Maran",
"6035621", "Kinrara",
"605669", "Sitiawan",
"6038661", "Mantin",
"6084612", "Rejang",
"608223", "Kuching",
"6032800", "Kuala\ Lumpur",
"6089513", "Beluran",
"6087508", "Labuan",
"60464", "Penang",
"6037717", "Kuala\ Lumpur",
"6034287", "Kuala\ Lumpur",
"6085790", "Miri",
"6032725", "Kuala\ Lumpur",
"609977", "Machang",
"6032393", "Kuala\ Lumpur",
"6089729", "Tawau",
"6039546", "Cheras",
"604568", "Sungai\ Bakap",
"6033322", "Kelang",
"6088332", "Kota\ Kinabalu",
"605719", "Parit\ Buntar",
"604828", "Penang",
"605351", "Batu\ Gajah",
"6082507", "Kuching",
"607990", "Bakri",
"606475", "Ayer\ Hitam",
"6036274", "Kuala\ Lumpur",
"606295", "Melaka",
"604626", "Penang",
"609681", "Kuala\ Brang",
"604565", "Kepala\ Batas",
"604451", "Jeniang",
"6037872", "Kuala\ Lumpur",
"6082322", "Kuching",
"6088780", "Kota\ Kinabalu",
"609572", "Kuantan",
"6044110", "Serdang",
"6085779", "Long\ Lama",
"6032858", "Kuala\ Lumpur",
"604869", "Penang",
"6034257", "Kuala\ Lumpur",
"6089843", "Kunak",
"605850", "Sungai\ Nyior",
"6037887", "Kuala\ Lumpur",
"6036460", "Kerling",
"6085742", "Beluru",
"609234", "Karak",
"604403", "Kulim",
"608822", "Kota\ Kinabalu",
"6033170", "Kelang",
"603806", "Kinrara",
"6038523", "Kinrara",
"607893", "Kota\ Tinggi",
"6038324", "Putrajaya",
"6047453", "Alor\ Setar",
"6082709", "Kota\ Samarahan",
"604537", "Tasek\ Gelugor",
"6088976", "Kota\ Belud",
"6039195", "Kuala\ Lumpur",
"6082275", "Kuching",
"6038891", "Putrajaya",
"603404", "Kuala\ Lumpur",
"604324", "Penang",
"6087888", "Membakut",
"605885", "Taiping",
"6088518", "Kota\ Kinabalu",
"604419", "Sungai\ Petani",
"607652", "Kulai",
"6036127", "Kuala\ Lumpur",
"6033181", "Banting",
"6038707", "Mantin",
"6036066", "Kuala\ Kubu\ Baru",
"608847", "Kota\ Kinabalu",
"6082492", "Kuching",
"6087725", "Tenom",
"606235", "Melaka",
"604290", "Penang",
"6085784", "Bakun",
"607930", "Labis",
"6084698", "Bintangor",
"6087409", "Labuan",
"6088656", "Kotamarudu",
"606560", "Simpang\ Empat",
"604597", "Parit\ Buntar",
"6039019", "Cheras",
"6084831", "Matu",
"6088605", "Kudat",
"609474", "Kota\ Gelangi",
"609294", "Kuala\ Krau",
"606776", "Seremban",
"604688", "Penang",
"609458", "Bukit\ Ibam",
"606658", "Sepang",
"6089619", "Elopura",
"604987", "Kangar",
"6083417", "Betong",
"605240", "Ipoh",
"606856", "Mantin",
"609455", "Bukit\ Ibam",
"609561", "Kuantan",
"6034161", "Kuala\ Lumpur",
"604685", "Penang",
"6035484", "Kinrara",
"606655", "Port\ Dickson",
"606552", "Simpang\ Empat",
"609821", "Sri\ Gading",
"604886", "Penang",
"6032268", "Kuala\ Lumpur",
"6089902", "Merotai",
"605412", "Trolak",
"6087231", "Beaufort",
"604949", "Kangar",
"607660", "Kulai",
"6084873", "Mukah",
"605370", "Batu\ Gajah",
"6082887", "Serian",
"6085286", "Lawas",
"6033275", "Batang\ Berjuntai",
"605751", "Kuala\ Kangsar",
"607710", "Keluang",
"609356", "Raub",
"6088794", "Tuaran",
"6032114", "Kuala\ Lumpur",
"605547", "Ipoh",
"605888", "Taiping",
"6089703", "Tawau",
"6034103", "Kuala\ Lumpur",
"6087718", "Tenom",
"6084870", "Mukah",
"604956", "Kuah",
"605406", "Tapah",
"609279", "Mentakab",
"6035612", "Kinrara",
"606545", "Durian\ Tunggal",
"606986", "Bakri",
"606699", "Linggi",
"606642", "Port\ Dickson",
"6087342", "Keningau",
"6088352", "Kota\ Kinabalu",
"604222", "Penang",
"6034021", "Kuala\ Lumpur",
"6094310", "Pekan",
"6034100", "Kuala\ Lumpur",
"60782", "Penggerang",
"605623", "Telukintan",
"607898", "Tenggara",
"6033856", "Sabak\ Bernam",
"6085287", "Lawas",
"6082886", "Serian",
"609732", "Kota\ Bharu",
"604408", "Kulim",
"608225", "Kuching",
"603209", "Kuala\ Lumpur",
"6085495", "Miri",
"6089436", "Kinabatangan",
"6092871", "Kuala\ Krau",
"6033214", "Sabak\ Bernam",
"6087803", "Sipitang",
"604405", "Padang\ Serai",
"6089818", "Lahad\ Datu",
"6088657", "Kotamarudu",
"607599", "Senai",
"6082716", "Semantan",
"6092620", "Jerantut",
"609912", "Gua\ Musang",
"605530", "Tanjung\ Rambutan",
"607696", "Pontian",
"6087464", "Labuan",
"6037610", "Kuala\ Lumpur",
"604920", "Kangar",
"607895", "Air\ Tawar",
"6082311", "Kuching",
"607794", "Endau",
"6038706", "Mantin",
"6036126", "Kuala\ Lumpur",
"6082720", "Lundu",
"6084364", "Sibu",
"606473", "Kemavan",
"606293", "Melaka",
"605237", "Ipoh",
"6082805", "Simunjan",
"604563", "Sungai\ Bakap",
"6033168", "Kelang",
"604306", "Penang",
"6035524", "Kinrara",
"6087861", "Bongawan",
"607560", "Senai",
"6033241", "Sekinchan",
"6084239", "Sibu",
"605415", "Tapah",
"6032298", "Kuala\ Lumpur",
"606461", "Ladanggeddes",
"604571", "Tasek\ Gelugor",
"6082543", "Kuching",
"609452", "Bukit\ Ibam",
"604946", "Kangar",
"607674", "Pontian",
"6089536", "Elopura",
"6036187", "Kuala\ Lumpur",
"607658", "Kulai",
"6087828", "Kuala\ Penyu",
"6032036", "Kuala\ Lumpur",
"6084777", "Song",
"6087212", "Beaufort",
"6089276", "Elopura",
"6038659", "Cheras",
"605897", "Semanggol",
"608685", "Bintulu",
"607267", "Johor\ Bahru",
"607923", "Bukit\ Kepong",
"6086286", "Bintulu",
"605689", "Sitiawan",
"6038861", "Putrajaya",
"606232", "Melaka",
"6084812", "Stapang",
"6098710", "Cheneh",
"6038689", "Putrajaya",
"606660", "Tekok\ Kemang",
"604416", "Sungai\ Petani",
"609460", "Maran",
"6088745", "Kinarut",
"6082827", "Asajaya",
"6085666", "Limbang",
"6086256", "Bintulu",
"6084752", "Kanowit",
"607655", "Kulai",
"6036157", "Kuala\ Lumpur",
"6038026", "Kinrara",
"6084228", "Sibu",
"604464", "Jeniang",
"6032688", "Kuala\ Lumpur",
"6033344", "Kelang",
"6084804", "Sarikei",
"6087301", "Keningau",
"6032600", "Kuala\ Lumpur",
"605418", "Tapah",
"6036156", "Kuala\ Lumpur",
"6035126", "Kinrara",
"607892", "Kota\ Tinggi",
"6083324", "Bandar\ Sri\ Aman",
"6087509", "Labuan",
"6082592", "Kota\ Samarahan",
"607596", "Senai",
"609915", "Gua\ Musang",
"605226", "Ipoh",
"6037771", "Kuala\ Lumpur",
"6038027", "Kinrara",
"6089728", "Tawau",
"607699", "Pontian",
"608823", "Kota\ Kinabalu",
"6086257", "Bintulu",
"604402", "Kulim",
"6085667", "Miri",
"609738", "Kota\ Bharu",
"6083450", "Saratok",
"6082826", "Asajaya",
"603551", "Kinrara",
"606648", "Port\ Dickson",
"6084681", "Sarikei",
"6084394", "Sibu",
"604331", "Penang",
"6084869", "Kuala\ Igan",
"6038800", "Putrajaya\/Cyberjaya",
"6032603", "Kuala\ Lumpur",
"6038725", "Semenyih",
"6032847", "Kuala\ Lumpur",
"6035110", "Kinrara",
"6036105", "Genting",
"6033198", "Banting",
"60793", "Segamat",
"6089941", "Tawau",
"6088613", "Kudat",
"60447", "Baling",
"6082810", "Asajaya",
"604228", "Penang",
"604309", "Sungai\ Petani",
"609573", "Kuantan",
"6082750", "Kota\ Samarahan",
"604959", "Kuah",
"609276", "Mentakab",
"604830", "Penang",
"606794", "Mantin",
"6034051", "Kuala\ Lumpur",
"60537", "Pusing",
"606989", "Bakri",
"6082780", "Gedong",
"606696", "Linggi",
"604269", "Penang",
"609767", "Bachok",
"606645", "Port\ Dickson",
"6082708", "Kota\ Samarahan",
"607211", "Johor\ Bahru",
"606334", "Melaka",
"606542", "Durian\ Tunggal",
"6039201", "Kuala\ Lumpur",
"6037932", "Kuala\ Lumpur",
"605431", "Besout",
"609445", "Bandar\ Tun\ Razak",
"607887", "Kota\ Tinggi",
"6089277", "Elopura",
"6032859", "Kuala\ Lumpur",
"609834", "Bukit\ Besi",
"6083480", "Betong",
"609735", "Kota\ Bharu",
"6088709", "Kinarut",
"6089855", "Kunak",
"6036186", "Kuala\ Lumpur",
"6037733", "Kuala\ Lumpur",
"6083408", "Maludam",
"6089537", "Elopura",
"6087874", "Weston",
"604933", "Kuah",
"6089715", "Tawau",
"609918", "Gua\ Musang",
"6032037", "Kuala\ Lumpur",
"6036263", "Kuala\ Lumpur",
"6035653", "Kinrara",
"6084381", "Sibu",
"6083470", "Betong",
"6032032", "Kuala\ Lumpur",
"6084694", "Bintangor",
"607751", "Lavang\-Lavang",
"6032303", "Kuala\ Lumpur",
"6089287", "Elopura",
"605710", "Parit\ Buntar",
"6089532", "Elopura",
"6089925", "Tawau",
"607424", "Rengit",
"6038741", "Semenyih",
"6086282", "Bintulu",
"6087884", "Kuala\ Penyu",
"608421", "Sibu",
"6089272", "Elopura",
"6087216", "Beaufort",
"607412", "Batu\ Pahat",
"609489", "Maran",
"6032245", "Kuala\ Lumpur",
"6082770", "Bau",
"6033109", "Pulau\ Ketam",
"603796", "Kuala\ Lumpur",
"603745", "Kuala\ Lumpur",
"607240", "Johor\ Bahru",
"6087481", "Labuan",
"6084633", "Selalang",
"604852", "Penang",
"609768", "Bachok",
"609447", "Bandar\ Tun\ Razak",
"6087451", "Labuan",
"6084820", "Daro",
"604253", "Penang",
"6032938", "Kuala\ Lumpur",
"608236", "Kuching",
"606647", "Port\ Dickson",
"609864", "Kemasik",
"6039105", "Cheras",
"609765", "Bachok",
"6084671", "Sarikei",
"6032264", "Kuala\ Lumpur",
"604963", "Kuah",
"604227", "Penang",
"606316", "Durian\ Tunggal",
"6086252", "Bintulu",
"6085662", "Miri",
"606415", "Tampin",
"6036092", "Rawang",
"6085222", "Limbang",
"604860", "Penang",
"609816", "Dungun",
"6032118", "Kuala\ Lumpur",
"6088798", "Tuaran",
"6084816", "Rejang",
"605930", "Sitiawan",
"6087854", "Bongawan",
"605859", "Taiping",
"604201", "Penang",
"607686", "Pontian",
"6084351", "Miri",
"6082597", "Kuching",
"6085758", "Marudi",
"6038022", "Kinrara",
"6035591", "Kinrara",
"607784", "Kahang",
"607885", "Kota\ Tinggi",
"605461", "Tapah",
"6082731", "Lundu",
"6089205", "Elopura",
"6037652", "Kuala\ Lumpur",
"605417", "Tapah",
"6034295", "Kuala\ Lumpur",
"609284", "Mentakab",
"604997", "Kangar",
"6084823", "Daro",
"6033145", "Banting",
"606523", "Jasin",
"6038991", "Cheras",
"6035035", "Kinrara",
"608243", "Sejingkat",
"607530", "Senai",
"609609", "Bandar\ Permaisuri",
"607265", "Johor\ Bahru",
"6082596", "Kuching",
"606960", "Bukit\ Gambir",
"605794", "Grik",
"6035122", "Kinrara",
"6083300", "Bandar\ Sri\ Aman",
"608988", "Lahad\ Datu",
"605895", "Taiping",
"609363", "Fraser\ Hill",
"606431", "Gemencheh",
"6033225", "Sabak\ Bernam",
"6082822", "Asajaya",
"605846", "Taiping",
"605542", "Ipoh",
"605599", "Chemor",
"604280", "Penang",
"6085635", "Miri",
"605645", "Bagan\ Datoh",
"609631", "Kuala\ Brang",
"6083569", "Engkilili",
"6082225", "Kuching",
"604434", "Padang\ Serai",
"6082665", "Kota\ Samarahan",
"6032388", "Kuala\ Lumpur",
"6087217", "Beaufort",
"6036177", "Kuala\ Lumpur",
"6087468", "Labuan",
"607657", "Kulai",
"6038690", "Semenyih",
"607305", "Johor\ Bahru",
"605648", "Hutan\ Melintang",
"608842", "Kota\ Kinabalu",
"6084772", "Song",
"6039172", "Kuala\ Lumpur",
"6089565", "Kinabatangan",
"6087775", "Tambunan",
"607268", "Johor\ Bahru",
"605898", "Semanggol",
"6089814", "Tungku",
"6032300", "Kuala\ Lumpur",
"6083473", "Betong",
"6035650", "Kinrara",
"6089286", "Elopura",
"606226", "Melaka",
"604549", "Tasek\ Gelugor",
"604592", "Parit\ Buntar",
"606630", "Seremban",
"609430", "Pekan",
"6087223", "Beaufort",
"604744", "Alor\ Setar",
"604982", "Kangar",
"609961", "Kuala\ Krai",
"6085761", "Layang\-Layang",
"6087208", "Beaufort",
"6036736", "Batu\ Arang",
"603261", "Kuala\ Lumpur",
"6033084", "Kelang",
"606424", "Batu\ Kikir",
"609762", "Pasir\ Putih",
"606547", "Durian\ Tunggal",
"609726", "Kota\ Bharu",
"6038988", "Cheras",
"605321", "Ipoh",
"606319", "Melaka",
"6084850", "Dalat",
"6039765", "Cheras",
"6089985", "Tawau",
"6089667", "Elopura",
"6083469", "Sebuyau",
"607882", "Kota\ Tinggi",
"609819", "Paka",
"605655", "Kampong\ Gajah",
"6038052", "Kinrara",
"607586", "Senai",
"6088349", "Kota\ Kinabalu",
"605856", "Taiping",
"606240", "Melaka",
"607945", "Tenang",
"607689", "Pontian",
"6088652", "Kotamarudu",
"6035561", "Kinrara",
"604620", "Penang",
"6084645", "Sarikei",
"6038521", "Sepang",
"6047451", "Alor\ Setar",
"609750", "Kota\ Bharu",
"6084224", "Sibu",
"6034819", "Kuala\ Lumpur",
"607897", "Tiram",
"6085282", "Lawas",
"608852", "Kota\ Kinabalu",
"6089465", "Elopura",
"605674", "Bruas",
"607283", "Johor\ Bahru",
"604407", "Serdang",
"6038082", "Kinrara",
"6035623", "Kinrara",
"609486", "Jengka\ Tiga\ Belas",
"6032011", "Kuala\ Lumpur",
"6038601", "Kinrara",
"6037948", "Kuala\ Lumpur",
"6088357", "Kota\ Kinabalu",
"6089511", "Beluran",
"6087250", "Beaufort",
"607364", "Johor\ Bahru",
"6038775", "Mantin",
"6038958", "Cheras",
"608633", "Bintulu",
"6084880", "Daro",
"604778", "Pokok\ Sena",
"6084808", "Sibu",
"60974", "Kota\ Bharu",
"6033348", "Kelang",
"604559", "Tasek\ Gelugor",
"6085739", "Batu\ Niah",
"605820", "Taiping",
"6037832", "Kuala\ Lumpur",
"6032391", "Kuala\ Lumpur",
"607415", "Batu\ Pahat",
"6032106", "Kuala\ Lumpur",
"6035620", "Kinrara",
"607523", "Senai",
"605293", "Tanjung\ Rambutan",
"605473", "Bagan\ Datoh",
"607863", "Tiram",
"6038660", "Mantin",
"608845", "Kota\ Kinabalu",
"6088414", "Kota\ Kinabalu",
"607302", "Johor\ Bahru",
"605548", "Ipoh",
"6034009", "Kuala\ Lumpur",
"6083570", "Lingga",
"6038076", "Kinrara",
"607741", "Felda\ Kahang\ Timur",
"6033852", "Banting",
"6082882", "Serian",
"606229", "Melaka",
"6038216", "Kuala\ Lumpur",
"604985", "Kangar",
"605211", "Ipoh",
"6088402", "Kota\ Kinabalu",
"6037865", "Kuala\ Lumpur",
"6032107", "Kuala\ Lumpur",
"607250", "Johor\ Bahru",
"604899", "Penang",
"607409", "Parit\ Sulong",
"606265", "Sungai\ Rambai",
"6084398", "Sibu",
"607960", "Gemas",
"609783", "Bachok",
"608434", "Sibu",
"6088356", "Kota\ Kinabalu",
"606530", "Jasin",
"604595", "Parit\ Buntar",
"6085791", "Miri",
"604700", "Alor\ Setar",
"6038329", "Putrajaya",
"6083339", "Bandar\ Sri\ Aman",
"609423", "Chini",
"604598", "Parit\ Buntar",
"6034265", "Kuala\ Lumpur",
"604988", "Kangar",
"609457", "Chini",
"604687", "Penang",
"606958", "Bukit\ Gambir",
"606974", "Pagoh",
"6036242", "Kuala\ Lumpur",
"6036737", "Kuala\ Kubu\ Baru",
"6088781", "Tuaran",
"605642", "Hutan\ Melintang",
"605699", "Sitiawan",
"6038961", "Cheras",
"609606", "Tenang",
"605545", "Ipoh",
"609531", "Kuantan",
"6082712", "Semantan",
"603217", "Kuala\ Lumpur",
"6082285", "Kuching",
"6036122", "Kuala\ Lumpur",
"6089666", "Elopura",
"6036461", "Kerling",
"605892", "Semanggol",
"605849", "Taiping",
"605596", "Chemor",
"6036035", "Batuarang",
"607262", "Johor\ Bahru",
"6036279", "Kuala\ Lumpur",
"609509", "Kuantan",
"604373", "Penang",
"607226", "Johor\ Bahru",
"608848", "Kota\ Kinabalu",
"6086486", "Balingan",
"6089614", "Elopura",
"6035165", "Kinrara",
"607943", "Tenang",
"6087801", "Sipitang",
"607288", "Johor\ Bahru",
"6082313", "Kuching",
"6038890", "Putrajaya",
"6084304", "Sibu",
"604538", "Tasek\ Gelugor",
"6082865", "Kota\ Samarahan",
"6033180", "Banting",
"6089248", "Elopura",
"6036195", "Kuala\ Lumpur",
"604962", "Kuah",
"6034252", "Kuala\ Lumpur",
"6039274", "Kuala\ Lumpur",
"605536", "Tanjung\ Rambutan",
"604926", "Ayer\ Hitam",
"609981", "Kuala\ Krai",
"6037882", "Kuala\ Lumpur",
"6087404", "Labuan",
"6038766", "Semenyih",
"609975", "Machang",
"604252", "Penang",
"6037877", "Kuala\ Lumpur",
"6084830", "Matu",
"6087863", "Bongawan",
"6087315", "Keningau",
"6082502", "Kuching",
"609591", "Kuantan",
"6088799", "Tuaran",
"6032119", "Kuala\ Lumpur",
"6087230", "Beaufort",
"608532", "Miri",
"609264", "Mentakab",
"604827", "Penang",
"6085759", "Marudi",
"607413", "Batu\ Pahat",
"609954", "Machang",
"606477", "Palong",
"609978", "Kuala\ Krai",
"6039776", "Kuala\ Lumpur",
"6037712", "Kuala\ Lumpur",
"6034023", "Kuala\ Lumpur",
"6082798", "Tebedu",
"604260", "Penang",
"608258", "Kuching",
"6082622", "Kuching",
"6082844", "Damai\ Beach",
"6032022", "Kuala\ Lumpur",
"604950", "Kuah",
"60777", "Keluang",
"6035880", "Kinrara",
"607271", "Johor\ Bahru",
"603780", "Kuala\ Lumpur",
"606980", "Bukit\ Gambir",
"6033093", "Pulau\ Ketam",
"6034020", "Kuala\ Lumpur",
"604248", "Penang",
"609350", "Raub",
"6094311", "Pekan",
"605376", "Bota",
"6033326", "Kelang",
"604593", "Parit\ Buntar",
"6084871", "Mukah",
"609785", "Pasirputih",
"6083568", "Engkilili",
"6084620", "Sarikei",
"6087233", "Beaufort",
"609771", "Kota\ Bharu",
"607764", "Felda\ Tenggaroh",
"607865", "Tiram",
"6086457", "Belaga",
"604378", "Penang",
"608843", "Kota\ Kinabalu",
"605481", "Tanjung\ Malim",
"6085618", "Miri",
"607666", "Kulai",
"606901", "Muar",
"6039075", "Cheras",
"606384", "Tangga\ Batu",
"6037910", "Kuala\ Lumpur",
"605246", "Ipoh",
"606850", "Mantin",
"604511", "Padang\ Serai",
"6089701", "Tawau",
"6034101", "Kuala\ Lumpur",
"6089675", "Elopura",
"6037611", "Kuala\ Lumpur",
"6088665", "Kotamarudu",
"6033183", "Banting",
"6087391", "Keningau",
"606514", "Jasin",
"606770", "Seremban",
"6085265", "Sundar",
"6038893", "Putrajaya",
"605543", "Ipoh",
"607868", "Tiram",
"606351", "Tangga\ Batu",
"605721", "Parit\ Buntar",
"6086295", "Bintulu",
"6036055", "Kuala\ Kubu\ Baru",
"6092870", "Kuala\ Krau",
"6088972", "Kota\ Belud",
"604375", "Penang",
"608242", "Kuching",
"609362", "Fraser\ Hill",
"607528", "Kangkar\ Pulai",
"6084894", "Stapang",
"605478", "Tapah",
"6032389", "Kuala\ Lumpur",
"609788", "Kok\ Lanas",
"6037876", "Kuala\ Lumpur",
"6082326", "Kuching",
"6086449", "Pelagus",
"606522", "Jasin",
"604476", "Kupang",
"6084833", "Matu",
"609851", "Chukai",
"6057970", "Grik",
"609900", "Gua\ Musang",
"605680", "Sitiawan",
"603873", "Semenyih",
"6038767", "Semenyih",
"6083468", "Sebuyau",
"605838", "Selama",
"604667", "Penang",
"6085405", "Miri",
"607705", "Keluang",
"604968", "Kuah",
"6088348", "Kota\ Kinabalu",
"6089790", "Merotai",
"609340", "Sungai\ Koyan",
"604258", "Penang",
"604717", "Pokok\ Sena",
"6087209", "Beaufort",
"6085456", "Miri",
"605256", "Ipoh",
"608827", "Kota\ Kinabalu",
"6089866", "Lahad\ Datu",
"6082292", "Kuching",
"6036144", "Kuala\ Lumpur",
"6092590", "Karak",
"609270", "Mentakab",
"6033120", "Tk\ Panglima\ Garang",
"6084234", "Sibu",
"6037731", "Kuala\ Lumpur",
"6038989", "Cheras",
"607477", "Sri\ Gading",
"607297", "Johor\ Bahru",
"605527", "Ipoh",
"6035195", "Kinrara",
"6037773", "Kuala\ Lumpur",
"6082682", "Kuching",
"6084736", "Julau",
"6086232", "Bintulu",
"6037949", "Kuala\ Lumpur",
"6038959", "Cheras",
"607883", "Kota\ Tinggi",
"6032223", "Kuala\ Lumpur",
"6084809", "Sibu",
"6082895", "Serian",
"6032082", "Kuala\ Lumpur",
"6033292", "Kelang",
"6033349", "Kelang",
"6085738", "Batu\ Niah",
"6088207", "Kota\ Kinabalu",
"607980", "Bakri",
"6038011", "Kinrara",
"604929", "Alor\ Setar",
"6037972", "Kuala\ Lumpur",
"6084683", "Sarikei",
"6087431", "Labuan",
"606491", "Simpang\ Durian",
"604255", "Penang",
"6032775", "Kuala\ Lumpur",
"6032601", "Kuala\ Lumpur",
"609841", "Dungun",
"607708", "Keluang",
"607590", "Senai",
"605636", "Sabak\ Bernam",
"605220", "Ipoh",
"6038684", "Putrajaya",
"605501", "Ipoh",
"6037665", "Kuala\ Lumpur",
"6088611", "Kudat",
"605893", "Taiping",
"6088695", "Kudat",
"609365", "Dong",
"6085295", "Lawas",
"608245", "Kuching",
"60769", "Air\ Baloi",
"607927", "Tenang",
"605287", "Pusing",
"609414", "Kuala\ Rompin",
"6087766", "Tambunan",
"605643", "Hutan\ Melintang",
"6082305", "Kuching",
"6038095", "Kinrara",
"6037770", "Kuala\ Lumpur",
"6085472", "Miri",
"609208", "Sungai\ Tekam",
"609329", "Padangtengku",
"606614", "Kuala\ Klawang",
"6082402", "Kuching",
"605811", "Taiping",
"604242", "Penang",
"6082751", "Bau",
"607850", "Tiram",
"6084680", "Sarikei",
"6088206", "Kota\ Kinabalu",
"606525", "Jasin",
"606666", "Sepang",
"609466", "Maran",
"604410", "Kulim",
"6087303", "Keningau",
"6087504", "Labuan",
"605310", "Ipoh",
"609944", "Ayer\ Lanas",
"6033243", "Sekinchan",
"609782", "Bachok",
"6088704", "Kota\ Kinabalu",
"6039200", "Kuala\ Lumpur",
"605379", "Batu\ Gajah",
"6082781", "Gedong",
"607514", "Tanjung\ Kupang",
"6034050", "Kuala\ Lumpur",
"6082541", "Sejingkat",
"607303", "Johor\ Bahru",
"604940", "Kangar",
"6088852", "Ranau",
"604611", "Penang",
"6083338", "Bandar\ Sri\ Aman",
"6033123", "Tk\ Panglima\ Garang",
"6038328", "Putrajaya",
"609205", "Jerantut",
"605292", "Tanjung\ Rambutan",
"605249", "Ipoh",
"607522", "Senai",
"609368", "Raub",
"608248", "Kuching",
"6089867", "Lahad\ Datu",
"6083220", "Bandar\ Sri\ Aman",
"607862", "Tiram",
"604264", "Penang",
"6036131", "Kuala\ Lumpur",
"6084753", "Kanowit",
"6084365", "Sibu",
"609853", "Chukai",
"6082804", "Simunjan",
"609567", "Kuantan",
"605404", "Tapah",
"606799", "Mantin",
"609827", "Paka",
"6088669", "Kota\ Marudu",
"6082590", "Kuching",
"6085471", "Miri",
"6088881", "Ranau",
"603784", "Kuala\ Lumpur",
"6035525", "Kinrara",
"606984", "Bukit\ Gambir",
"609801", "Paka",
"605757", "Kuala\ Kangsar",
"606432", "Gemencheh",
"6082401", "Kuching",
"607748", "Keluang",
"609632", "Kuala\ Brang",
"609260", "Jerantut",
"6089568", "Kinabatangan",
"605541", "Ipoh",
"6082752", "Kuching",
"606353", "Tangga\ Batu",
"605723", "Parit\ Buntar",
"6087465", "Labuan",
"609950", "Machang",
"6082668", "Kota\ Samarahan",
"6032385", "Kuala\ Lumpur",
"6063130", "Melaka",
"6082228", "Kuching",
"609839", "Merchang",
"609300", "Mentakab",
"6085638", "Miri",
"6086390", "Bintulu",
"6036047", "Kerling",
"607745", "Renggam",
"604513", "Padang\ Serai",
"6085494", "Bekenu",
"607467", "Sri\ Gading",
"6082542", "Sejingkat",
"6087227", "Beaufort",
"6082782", "Gedong",
"609538", "Kuantan",
"6033148", "Banting",
"6089280", "Elopura",
"6032191", "Kuala\ Lumpur",
"6083477", "Betong",
"604981", "Kangar",
"603888", "Putrajaya",
"6088851", "Ranau",
"60676", "Seremban",
"6039235", "Kuala\ Lumpur",
"609252", "Triang",
"6095071", "Kuantan",
"6089208", "Elopura",
"6087213", "Beaufort",
"609773", "Kota\ Bharu",
"6085755", "Marudi",
"6087226", "Beaufort",
"6088909", "Papar",
"605684", "Sitiawan",
"6037933", "Kuala\ Lumpur",
"607752", "Lavang\-Lavang",
"6032115", "Kuala\ Lumpur",
"6036046", "Kampong\ Suharto",
"6077120", "Keluang",
"606758", "Mantin",
"605209", "Ipoh",
"605328", "Ipoh",
"609476", "Maran",
"6082291", "Kuching",
"6035485", "Kinrara",
"6084780", "Kapit",
"604469", "Jeniang",
"6082651", "Kuching",
"6032935", "Kuala\ Lumpur",
"609245", "Triang",
"6037732", "Kuala\ Lumpur",
"607760", "Keluang",
"6082681", "Kuching",
"6082593", "Kuching",
"605369", "Pusing",
"609248", "Bera",
"6086231", "Bintulu",
"6039514", "Kuala\ Lumpur",
"6084810", "Julau",
"60449", "Kulim",
"6032081", "Kuala\ Lumpur",
"6033291", "Kelang",
"604884", "Penang",
"6084750", "Kanowit",
"609593", "Gambang",
"6058301", "Taiping",
"6087319", "Keningau",
"6089634", "Elopura",
"6082274", "Kuching",
"6093140", "Kuala\ Lipis",
"6032602", "Kuala\ Lumpur",
"6037971", "Kuala\ Lumpur",
"607679", "Pontian",
"6085785", "Marudi",
"6088612", "Kudat",
"6088350", "Kota\ Kinabalu",
"6087340", "Keningau",
"607301", "Johor\ Bahru",
"609638", "Kuala\ Berang",
"6036038", "Kuala\ Lumpur",
"607742", "Lavang\-Lavang",
"609937", "Kuala\ Balah",
"6086360", "Bintulu",
"606438", "Simpang\ Empat",
"604613", "Penang",
"6082288", "Kuching",
"6089854", "Kunak",
"608981", "Felda\ Sahabat",
"6084872", "Mukah",
"6033258", "Kelang",
"60545", "Tanjung\ Malim",
"608975", "Tawau",
"6089714", "Tawau",
"6089903", "Merotai",
"6038210", "Semenyih",
"605440", "Tapah",
"6038070", "Kinrara",
"609255", "Triang",
"6089702", "Tawau",
"6033831", "Semenyih",
"605212", "Ipoh",
"6034102", "Kuala\ Lumpur",
"609965", "Kuala\ Krai",
"6085270", "Lawas",
"6082831", "Sebangan",
"6087392", "Keningau",
"606336", "Melaka",
"6084395", "Sibu",
"606467", "Ayer\ Hitam",
"6038724", "Semenyih",
"609667", "Kuala\ Brang",
"6089660", "Elopura",
"6082309", "Kuching",
"6036104", "Genting",
"6085299", "Lawas",
"6088971", "Kota\ Belud",
"6035131", "Kinrara",
"606694", "Rantau",
"6082493", "Kuching",
"6033288", "Kuala\ Selangor",
"605891", "Taiping",
"6083325", "Bandar\ Sri\ Aman",
"604219", "Penang",
"608978", "Semporna",
"607261", "Johor\ Bahru",
"6088308", "Kota\ Kinabalu",
"609635", "Kuala\ Brang",
"605641", "Hutan\ Melintang",
"606435", "Tampin",
"6082698", "Kuching",
"6084717", "Pakan",
"608264", "Kuching",
"607217", "Johor\ Bahru",
"6082899", "Serian",
"6033345", "Kelang",
"6087802", "Sipitang",
"604944", "Kangar",
"606493", "Kuala\ Klawang",
"605437", "Tapah",
"605322", "Ipoh",
"6084805", "Kuala\ Igan",
"6032742", "Kuala\ Lumpur",
"6089663", "Elopura",
"6038778", "Mantin",
"6038955", "Serdang",
"6085231", "Kampung\ Pahlawan",
"6037669", "Kuala\ Lumpur",
"609611", "Bandar\ Permaisuri",
"6034251", "Kuala\ Lumpur",
"606411", "Simpang\ Empat",
"6088744", "Kinarut",
"605429", "Trolak",
"607881", "Air\ Tawar",
"605465", "Kampar",
"607510", "Senai",
"607758", "Ayer\ Hitam",
"6085718", "Bekenu",
"604368", "Kepala\ Batas",
"6082501", "Kuching",
"6038213", "Putrajaya",
"605468", "Kampar",
"6035613", "Kinrara",
"607755", "Renggam",
"607380", "Johor\ Bahru",
"608425", "Sibu",
"6037711", "Kuala\ Lumpur",
"604414", "Serdang",
"6047210", "Sungai\ Petani",
"6088353", "Kota\ Kinabalu",
"604797", "Ayer\ Hitam",
"609479", "Maran",
"609242", "Bera",
"6082261", "Kuching",
"6082621", "Kuching",
"6086301", "Bintulu",
"604466", "Bedong",
"609410", "Pekan",
"6032021", "Kuala\ Lumpur",
"6038073", "Kinrara",
"6089521", "Telupid",
"6039225", "Kuala\ Lumpur",
"604765", "Alor\ Setar",
"609772", "Kok\ Lanas",
"604447", "Bedong",
"607908", "Bekok",
"6084610", "Rejang",
"6089569", "Kinabatangan",
"604524", "Tasek\ Gelugor",
"605389", "Bota",
"603271", "Kuala\ Lumpur",
"6083343", "Bandar\ Sri\ Aman",
"6033851", "Banting",
"607780", "Kahang",
"6035887", "Kinrara",
"6082669", "Kota\ Samarahan",
"604512", "Penang",
"6088401", "Kota\ Kinabalu",
"604615", "Penang",
"609520", "Kuantan",
"604397", "Penang",
"6088330", "Kota\ Kinabalu",
"6087237", "Beaufort",
"6034270", "Kuala\ Lumpur",
"609860", "Chukai",
"6039145", "Kuala\ Lumpur",
"6086298", "Bintulu",
"6085628", "Miri",
"6085268", "Sundar",
"609239", "Telemong",
"6085792", "Mulu",
"6088668", "Kota\ Marudu",
"6034026", "Kuala\ Lumpur",
"605766", "Lenggong",
"6083411", "Kabong",
"608241", "Kuching",
"606352", "Tangga\ Batu",
"6033149", "Banting",
"605722", "Parit\ Buntar",
"6098001", "Kerteh",
"605664", "Sitiawan",
"6034299", "Kuala\ Lumpur",
"609361", "Raub",
"607244", "Johor\ Bahru",
"606433", "Jelai",
"6039078", "Cheras",
"6037261", "Kuala\ Lumpur",
"608486", "Dalat",
"604618", "Penang",
"6089209", "Elopura",
"6084555", "Sibu",
"6085615", "Miri",
"6088782", "Tuaran",
"6037870", "Kuala\ Lumpur",
"6036241", "Kuala\ Lumpur",
"604917", "Alor\ Setar",
"6082320", "Semantan",
"609633", "Bandar\ Permaisuri",
"6086483", "Pelagus",
"605616", "Bruas",
"6082711", "Semantan",
"606459", "Serting",
"6038962", "Cheras",
"609659", "Batu\ Rakit",
"605714", "Parit\ Buntar",
"607420", "Senggarang",
"609556", "Kuantan",
"6036462", "Kerling",
"604768", "Alor\ Setar",
"6033187", "Banting",
"6035039", "Kinrara",
"6085740", "Mu",
"606521", "Jasin",
"609852", "Chukai",
"6087734", "Tenom",
"6037873", "Kuala\ Lumpur",
"6082323", "Damai\ Beach",
"606634", "Seremban",
"606736", "Mantin",
"6036419", "Kuala\ Lumpur",
"604740", "Alor\ Setar",
"6033868", "Batang\ Berjuntai",
"6038760", "Semenyih",
"607970", "Segamat",
"606275", "Melaka",
"606495", "Simpang\ Durian",
"604251", "Penang",
"6085743", "Beluru",
"6036061", "Kuala\ Kubu\ Baru",
"605809", "Taiping",
"60475", "Lubuk\ Merbau",
"609592", "Kuantan",
"609549", "Gambang",
"6038051", "Kinrara",
"6035562", "Kinrara",
"607919", "Labis",
"604961", "Kuah",
"6088908", "Papar",
"6037200", "Kuala\ Lumpur",
"605831", "Selama",
"609845", "Dungun",
"6047452", "Alor\ Setar",
"6086480", "Balingan",
"6038522", "Semenyih",
"6034800", "Kuala\ Lumpur",
"6088394", "Kota\ Kinabalu",
"6087318", "Keningau",
"606964", "Tangkak",
"6083340", "Bandar\ Sri\ Aman",
"609848", "Dungun",
"6035886", "Kinrara",
"609587", "Gebeng",
"60962", "Kuala\ Brang",
"606498", "Batu\ Kikir",
"606278", "Melaka",
"6084613", "Selalang",
"607739", "Kluang",
"6086324", "Bintulu",
"6033317", "Kelang",
"6032272", "Kuala\ Lumpur",
"6038081", "Kinrara",
"607272", "Johor\ Bahru",
"6039770", "Kuala\ Lumpur",
"6082868", "Kota\ Samarahan",
"607753", "Renggam",
"6034027", "Kuala\ Lumpur",
"604609", "Penang",
"6089512", "Beluran",
"6038602", "Kinrara",
"609280", "Lanchang",
"6088333", "Kota\ Kinabalu",
"6045960", "Parit\ Buntar",
"6033323", "Kelang",
"6088534", "Kota\ Kinabalu",
"6032392", "Kuala\ Lumpur",
"6037831", "Kuala\ Lumpur",
"605769", "Lenggong",
"6078011", "Mersing",
"607360", "Johor\ Bahru",
"6037651", "Kuala\ Lumpur",
"60443", "Sungai\ Petani",
"604518", "Tasekgelugor",
"6084848", "Kuala\ Igan",
"6038325", "Putrajaya",
"605725", "Parit\ Buntar",
"605488", "Tanjung\ Malim",
"604371", "Penang",
"609754", "Bachok",
"6036039", "Kuala\ Lumpur",
"607902", "Tangkak",
"609855", "Chukai",
"6036275", "Kuala\ Lumpur",
"6038992", "Cheras",
"6086580", "Tatau",
"609778", "Bachok",
"6089570", "Kinabatangan",
"6036151", "Kuala\ Lumpur",
"6087760", "Tenom",
"6039133", "Kuala\ Lumpur",
"6035121", "Kinrara",
"609559", "Kuantan",
"605670", "Sitiawan",
"6082821", "Asajaya",
"605812", "Taiping",
"6033259", "Kelang",
"6086508", "Bintulu",
"604241", "Penang",
"6033289", "Kuala\ Selangor",
"6085453", "Miri",
"6088309", "Kota\ Kinabalu",
"6089863", "Lahad\ Datu",
"6032724", "Kuala\ Lumpur",
"6086423", "Sebauh",
"609858", "Chukai",
"609775", "Kota\ Bharu",
"6039171", "Kuala\ Lumpur",
"609874", "Kemasik",
"607507", "Tanjung\ Kupang",
"6036181", "Kuala\ Lumpur",
"604762", "Alor\ Setar",
"609781", "Machang",
"6082699", "Kuching",
"607521", "Senai",
"605291", "Tanjung\ Rambutan",
"6082308", "Kuching",
"605728", "Parit\ Buntar",
"607861", "Tiram",
"606358", "Tangga\ Batu",
"604819", "Penang",
"605485", "Cameron\ Highland",
"6035543", "Kinrara",
"6036028", "Batu\ Arang",
"6039206", "Kuala\ Lumpur",
"606420", "Johol",
"6082380", "Kuching",
"6087476", "Labuan",
"6085298", "Lawas",
"604612", "Penang",
"609236", "Bilut\ Valley",
"604515", "Tasekgelugor",
"607743", "Keluang",
"6032031", "Kuala\ Lumpur",
"6088364", "Kota\ Kinabalu",
"609598", "Gambang",
"6084382", "Sibu",
"6088920", "Papar",
"6089959", "Lahad\ Datu",
"608631", "Bintulu",
"609700", "Kota\ Bharu",
"6089531", "Elopura",
"6033126", "Tk\ Panglima\ Garang",
"609687", "Bukit\ Bading",
"603625", "Kuala\ Lumpur",
"6085450", "Miri",
"609243", "Triang",
"6086281", "Bintulu",
"6034815", "Kuala\ Lumpur",
"6085719", "Bekenu",
"6089271", "Elopura",
"605608", "Teluk\ Intan",
"6087477", "Labuan",
"6085735", "Batu\ Niah",
"604704", "Pokok\ Sena",
"607446", "Senggarang",
"6082898", "Serian",
"6039207", "Kuala\ Lumpur",
"6033110", "Pulau\ Ketam",
"6082383", "Kuching",
"6089796", "Merotai",
"6038779", "Mantin",
"6035540", "Kinrara",
"6087482", "Labuan",
"6035198", "Kinrara",
"606970", "Muar",
"6087452", "Labuan",
"6039769", "Cheras",
"6038100", "Kinrara",
"607254", "Johor\ Bahru",
"607278", "Johor\ Bahru",
"606701", "Linggi",
"6039054", "Cheras",
"6088203", "Kota\ Kinabalu",
"6038790", "Mantin",
"608251", "Kuching",
"607964", "Bukit\ Gambir",
"6084687", "Sarikei",
"606534", "Jasin",
"6082765", "Bau",
"6085221", "Limbang",
"609842", "Dungun",
"6085661", "Miri",
"6086251", "Bintulu",
"605806", "Taiping",
"6036091", "Rawang",
"606727", "Seremban",
"605357", "Ipoh",
"603263", "Kuala\ Lumpur",
"609546", "Gambang",
"6038021", "Kinrara",
"6088345", "Kota\ Kinabalu",
"607916", "Bekok",
"604783", "Lubuk\ Merbau",
"6039130", "Kuala\ Lumpur",
"6084352", "Sibu",
"609595", "Gebeng",
"6084730", "Julau",
"605323", "Ipoh",
"6083465", "Debak",
"606492", "Kuala\ Klawang",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+60|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;