BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Exporter Time::HiRes base lib strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.014; 1}) {
    print "Perl 5.014 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.62.
use strict;
use warnings;
use 5.014;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Unofficial Perl NewRelic SDK",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker"            => 0,
    "FFI::CheckLib"                  => "0.27",
    "FFI::Platypus::Type::PtrObject" => "0.02"
  },
  "DISTNAME"         => "NewFangle",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.014",
  "NAME"             => "NewFangle",
  "PM"               => {
    "lib/NewFangle.pm"             => "\$(INST_LIB)/NewFangle.pm",
    "lib/NewFangle/App.pm"         => "\$(INST_LIB)/NewFangle/App.pm",
    "lib/NewFangle/Config.pm"      => "\$(INST_LIB)/NewFangle/Config.pm",
    "lib/NewFangle/CustomEvent.pm" => "\$(INST_LIB)/NewFangle/CustomEvent.pm",
    "lib/NewFangle/FFI.pm"         => "\$(INST_LIB)/NewFangle/FFI.pm",
    "lib/NewFangle/Segment.pm"     => "\$(INST_LIB)/NewFangle/Segment.pm",
    "lib/NewFangle/Transaction.pm" => "\$(INST_LIB)/NewFangle/Transaction.pm"
  },
  "PREREQ_PM" => {
    "FFI::C"                => "0.08",
    "FFI::C::Util"          => 0,
    "FFI::CheckLib"         => "0.27",
    "FFI::Platypus"         => "1.26",
    "FFI::Platypus::Memory" => 0,
    "JSON::MaybeXS"         => 0,
    "Ref::Util"             => 0
  },
  "TEST_REQUIRES" => {
    "Test2::Tools::AsyncSubtest"  => 0,
    "Test2::Tools::JSON::Pointer" => 0,
    "Test2::V0"                   => "0.000060",
    "YAML"                        => 0
  },
  "VERSION" => "0.05",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::C"                      => "0.08",
  "FFI::C::Util"                => 0,
  "FFI::CheckLib"               => "0.27",
  "FFI::Platypus"               => "1.26",
  "FFI::Platypus::Memory"       => 0,
  "JSON::MaybeXS"               => 0,
  "Ref::Util"                   => 0,
  "Test2::Tools::AsyncSubtest"  => 0,
  "Test2::Tools::JSON::Pointer" => 0,
  "Test2::V0"                   => "0.000060",
  "YAML"                        => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
if ( do { use FFI::CheckLib 0.27; !find_lib lib => 'newrelic' } ) {
  requires( 'Alien::libnewrelic', '0.06' );
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
sub _add_prereq {
  my ( $mm_key, $module, $version_or_range ) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
    and $WriteMakefileArgs{$mm_key}{$module} ne '0'
    and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $FallbackPrereqs{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
    and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub requires { goto &runtime_requires }

sub runtime_requires {
  my ( $module, $version_or_range ) = @_;
  _add_prereq( PREREQ_PM => $module, $version_or_range );
}