BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Time::HiRes experimental warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use v5.20.0; 1}) {
    print "Perl v5.20.0 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.75.
use strict;
use warnings;
use 5.020000;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "Sliding window rate limiting with Memcached",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker"     => 0,
    "FFI::Build::File::Cargo" => 0,
    "FFI::Build::MM"          => "0.83"
  },
  "DISTNAME"         => "Memcached-RateLimit",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.020000",
  "NAME"             => "Memcached::RateLimit",
  "PM"               => {
    "lib/Memcached/RateLimit.pm" => "\$(INST_LIB)/Memcached/RateLimit.pm"
  },
  "PREREQ_PM" => {
    "FFI::Platypus"             => "2.00",
    "FFI::Platypus::Lang::Rust" => 0,
    "Ref::Util"                 => 0,
    "URI::Escape"               => 0
  },
  "TEST_REQUIRES" => {
    "Test2::Tools::Rustfmt" => 0,
    "Test2::Tools::Subtest" => "0.000121",
    "Test2::V0"             => "0.000121",
    "YAML"                  => 0
  },
  "VERSION" => "0.08",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "FFI::Platypus"             => "2.00",
  "FFI::Platypus::Lang::Rust" => 0,
  "Ref::Util"                 => 0,
  "Test2::Tools::Rustfmt"     => 0,
  "Test2::Tools::Subtest"     => "0.000121",
  "Test2::V0"                 => "0.000121",
  "URI::Escape"               => 0,
  "YAML"                      => 0
);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
use FFI::Build::MM 0.83;
my $fbmm = FFI::Build::MM->new;
%WriteMakefileArgs = $fbmm->mm_args(%WriteMakefileArgs);

# END code inserted by Dist::Zilla::Plugin::FFI::Build

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::FFI::Build
BEGIN {
  # append to any existing postamble.
  if ( my $old = MY->can('postamble') )
  {
    no warnings 'redefine';
    *MY::postamble = sub {
      $old->(@_) .
        "\n" .
        $fbmm->mm_postamble;
    };
  }
  else
  {
    *MY::postamble = sub {
      $fbmm->mm_postamble;
    };
  }
}

# END code inserted by Dist::Zilla::Plugin::FFI::Build