BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( File::Glob File::Path base constant overload strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.47.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker 6.64;
require "./inc/mymm.pl";

my %WriteMakefileArgs = (
  "ABSTRACT"       => "Documentation and tools for using Platypus with Go",
  "AUTHOR"         => "Graham Ollis <plicease\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Capture::Tiny"                 => 0,
    "File::ShareDir::Dist::Install" => 0,
    "File::chdir"                   => 0,
    "Path::Tiny"                    => 0
  },
  "CONFIGURE_REQUIRES" => {
    "Capture::Tiny"       => 0,
    "ExtUtils::MakeMaker" => "6.64"
  },
  "DISTNAME"         => "FFI-Platypus-Lang-Go",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "FFI::Platypus::Lang::Go",
  "PM"               => {
    "lib/FFI/Build/File/GoMod.pm"       => "\$(INST_LIB)/FFI/Build/File/GoMod.pm",
    "lib/FFI/Go/String.pm"              => "\$(INST_LIB)/FFI/Go/String.pm",
    "lib/FFI/Platypus/Lang/Go.pm"       => "\$(INST_LIB)/FFI/Platypus/Lang/Go.pm",
    "lib/FFI/Platypus/Type/GoString.pm" => "\$(INST_LIB)/FFI/Platypus/Type/GoString.pm"
  },
  "PREREQ_PM" => {
    "Capture::Tiny"             => 0,
    "Class::Method::Modifiers"  => 0,
    "FFI::Build::File::Base"    => 0,
    "FFI::Build::File::Library" => 0,
    "FFI::Build::Platform"      => 0,
    "FFI::Platypus"             => "1.24",
    "File::ShareDir::Dist"      => "0.07",
    "File::chdir"               => 0,
    "Path::Tiny"                => 0,
    "Ref::Util"                 => 0
  },
  "TEST_REQUIRES" => {
    "Test2::V0" => "0.000060"
  },
  "VERSION" => "0.01",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

WriteMakefile(%WriteMakefileArgs);
{ package MY;
  sub postamble {
    my $postamble = '';

    $postamble .=
      "pure_all :: mymm-build\n" .
      "mymm-build :\n" .
      "\t\$(FULLPERL) inc/mymm-build.pl\n\n";

    $postamble;
  }
  sub special_targets {
    my($self, @therest) = @_;
    my $st = $self->SUPER::special_targets(@therest);
    $st .= "\n.PHONY: mymm-build\n";
    $st;
  }
}