BEGIN {
  use strict; use warnings;
  my %missing = map {
    eval qq{ require $_ };
    $@ ? ($_=>1) : ()
  } qw( Carp Exporter Scalar::Util base bytes constant overload strict warnings );
  if(%missing)
  {
    print "Your Perl is missing core modules: @{[ sort keys %missing ]}\n";
    print "Ideally if you are using the system Perl you can install the appropriate\n";
    print "package which includes the core Perl modules.  On at least some versions\n";
    print "of Fedora, CentOS and RHEL, this is the `perl-core` package.\n";
    print "\n";
    print " % dnf install perl-core\n";
    print "   ~ or ~\n";
    print " % yum install perl-core\n";
    print "\n";
    print "If you really want to install dual-life modules from CPAN, then you can\n";
    print "use cpanm:\n";
    print "\n";
    print " % cpanm @{[ sort keys %missing ]}\n";
    print "\n";
    print "Note that some core modules are not available from CPAN.\n";
    exit;
  }
}
BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008001; 1}) {
    print "Perl 5.008001 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.56.
use strict;
use warnings;
use 5.008001;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "C data types for FFI",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"         => "FFI-C",
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008001",
  "NAME"             => "FFI::C",
  "PM"               => {
    "lib/FFI/C.pm"           => "\$(INST_LIB)/FFI/C.pm",
    "lib/FFI/C/Array.pm"     => "\$(INST_LIB)/FFI/C/Array.pm",
    "lib/FFI/C/ArrayDef.pm"  => "\$(INST_LIB)/FFI/C/ArrayDef.pm",
    "lib/FFI/C/Def.pm"       => "\$(INST_LIB)/FFI/C/Def.pm",
    "lib/FFI/C/FFI.pm"       => "\$(INST_LIB)/FFI/C/FFI.pm",
    "lib/FFI/C/File.pm"      => "\$(INST_LIB)/FFI/C/File.pm",
    "lib/FFI/C/PosixFile.pm" => "\$(INST_LIB)/FFI/C/PosixFile.pm",
    "lib/FFI/C/Struct.pm"    => "\$(INST_LIB)/FFI/C/Struct.pm",
    "lib/FFI/C/StructDef.pm" => "\$(INST_LIB)/FFI/C/StructDef.pm",
    "lib/FFI/C/Union.pm"     => "\$(INST_LIB)/FFI/C/Union.pm",
    "lib/FFI/C/UnionDef.pm"  => "\$(INST_LIB)/FFI/C/UnionDef.pm",
    "lib/FFI/C/Util.pm"      => "\$(INST_LIB)/FFI/C/Util.pm"
  },
  "PREREQ_PM" => {
    "Class::Inspector"          => 0,
    "FFI::Platypus"             => "1.24",
    "FFI::Platypus::Memory"     => 0,
    "FFI::Platypus::Type::Enum" => "0.03",
    "Ref::Util"                 => 0,
    "Sub::Identify"             => 0,
    "Sub::Install"              => 0,
    "Sub::Util"                 => 0
  },
  "TEST_REQUIRES" => {
    "Capture::Tiny"         => 0,
    "FFI::Platypus::Record" => 0,
    "Path::Tiny"            => 0,
    "Test2::V0"             => "0.000081"
  },
  "VERSION" => "0.10",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Capture::Tiny"             => 0,
  "Class::Inspector"          => 0,
  "FFI::Platypus"             => "1.24",
  "FFI::Platypus::Memory"     => 0,
  "FFI::Platypus::Record"     => 0,
  "FFI::Platypus::Type::Enum" => "0.03",
  "Path::Tiny"                => 0,
  "Ref::Util"                 => 0,
  "Sub::Identify"             => 0,
  "Sub::Install"              => 0,
  "Sub::Util"                 => 0,
  "Test2::V0"                 => "0.000081"
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);