## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::hash_from_json;

our $DATE = '2022-08-26'; # DATE
our $VERSION = '0.006'; # VERSION

our $rschema = do{my$var={base=>"hash",clsets_after_base=>[{description=>"\nYou can use this schema if you want to accept a hash, but if user supplies a\nstring e.g. in a command-line script as command-line argument or option, the\nstring will be coerced into hash if the string contains a JSON-encoded object\n(hash). Data will not be valid if the string does not contain valid JSON.\n\nNote that hash data is accepted, unlike the `json_str::hash` schema which only\naccepts hash in JSON-encoded string form.\n\n",examples=>[{summary=>"Empty string is not a valid JSON",valid=>0,value=>""},{summary=>"Valid JSON but not a hash",valid=>0,value=>1},{summary=>"Valid JSON but not a hash",valid=>0,value=>"[]"},{summary=>"Already a hash",valid=>1,value=>{}},{summary=>"Not a hash",valid=>0,value=>[]},{summary=>"Not a valid JSON literal",valid=>0,value=>"foo"},{valid=>1,validated_value=>{},value=>"{}"},{valid=>1,validated_value=>{a=>1,b=>2},value=>"{\"a\":1,\"b\":2}"},{summary=>"Missing closing curly bracket",valid=>0,value=>"{\"a\":1,\"b\":2"}],prefilters=>["JSON::decode_str"],summary=>"Hash, coerced from JSON string"}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["hash"],type=>"hash",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Hash, coerced from JSON string

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::hash_from_json - Hash, coerced from JSON string

=head1 VERSION

This document describes version 0.006 of Sah::SchemaR::hash_from_json (from Perl distribution Sah-Schemas-JSON), released on 2022-08-26.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-JSON>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-JSON>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022, 2021 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-JSON>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
