package Bencher::Scenario::List::Utils::MoveElement::move_element_to_beginning;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-07-23'; # DATE
our $DIST = 'Bencher-Scenarios-List-Utils-MoveElement'; # DIST
our $VERSION = '0.002'; # VERSION

use strict;
use warnings;

our $scenario = {
    summary => "Benchmark move_to_beginning()",
    participants => [
        {fcall_template=>'List::Utils::MoveElement::move_element_to_beginning(<i>, @{<array>})', result_is_list=>1},
        {fcall_template=>'List::Utils::MoveElement::PP::to_beginning(<i>, @{<array>})', result_is_list=>1},
        {fcall_template=>'List::Utils::MoveElement::Splice::to_beginning_copy(<i>, @{<array>})', result_is_list=>1},
        {fcall_template=>'List::Utils::MoveElement::Splice::to_beginning_nocopy(<i>, @{<array>})', result_is_list=>1},
    ],
    datasets => [
        {name=>'a1_1'       , args=>{i=>1, array=>[qw/a b/]}, result=>[qw/b a/]},
        {name=>'a5_10'      , args=>{i=>5, array=>[(('a') x 5), 'b', (('a') x 4)]}, result=>['b', (('a') x 9)]},
        {name=>'a500_1000'  , args=>{i=>500, array=>[(('a') x 500), 'b', (('a') x 499)]}, result=>['b', (('a') x 999)]},
        {name=>'a5000_10000', args=>{i=>5000, array=>[(('a') x 5000), 'b', (('a') x 4999)]}, result=>['b', (('a') x 9999)]},
    ],
};

1;
# ABSTRACT: Benchmark move_to_beginning()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::List::Utils::MoveElement::move_element_to_beginning - Benchmark move_to_beginning()

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::List::Utils::MoveElement::move_element_to_beginning (from Perl distribution Bencher-Scenarios-List-Utils-MoveElement), released on 2021-07-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m List::Utils::MoveElement::move_element_to_beginning

To run module startup overhead benchmark:

 % bencher --module-startup -m List::Utils::MoveElement::move_element_to_beginning

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<List::Utils::MoveElement> 0.02

L<List::Utils::MoveElement::PP>

L<List::Utils::MoveElement::Splice>

=head1 BENCHMARK PARTICIPANTS

=over

=item * List::Utils::MoveElement::move_element_to_beginning (perl_code)

Function call template:

 List::Utils::MoveElement::move_element_to_beginning(<i>, @{<array>})



=item * List::Utils::MoveElement::PP::to_beginning (perl_code)

Function call template:

 List::Utils::MoveElement::PP::to_beginning(<i>, @{<array>})



=item * List::Utils::MoveElement::Splice::to_beginning_copy (perl_code)

Function call template:

 List::Utils::MoveElement::Splice::to_beginning_copy(<i>, @{<array>})



=item * List::Utils::MoveElement::Splice::to_beginning_nocopy (perl_code)

Function call template:

 List::Utils::MoveElement::Splice::to_beginning_nocopy(<i>, @{<array>})



=back

=head1 BENCHMARK DATASETS

=over

=item * a1_1

=item * a5_10

=item * a500_1000

=item * a5000_10000

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.30.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux LinuxMint version 19 >>, OS kernel: I<< Linux version 5.3.0-68-generic >>.

Benchmark with default options (C<< bencher -m List::Utils::MoveElement::move_element_to_beginning >>):

 #table1#
 +-------------------------------------------------------+-------------+------------+-----------+-----------------------+-----------------------+---------+---------+
 | participant                                           | dataset     | rate (/s)  | time (μs) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +-------------------------------------------------------+-------------+------------+-----------+-----------------------+-----------------------+---------+---------+
 | List::Utils::MoveElement::move_element_to_beginning   | a5000_10000 |    1020    | 978       |                 0.00% |            184784.03% | 6.9e-07 |      20 |
 | List::Utils::MoveElement::PP::to_beginning            | a5000_10000 |    1030    | 972       |                 0.66% |            183574.03% | 2.7e-07 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a5000_10000 |    1200    | 835       |                17.13% |            157740.96% | 4.8e-07 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a5000_10000 |    2100    | 470       |               107.61% |             88954.09% | 1.1e-06 |      21 |
 | List::Utils::MoveElement::move_element_to_beginning   | a500_1000   |   10184.71 |  98.18642 |               896.22% |             18458.54% | 5.8e-12 |      20 |
 | List::Utils::MoveElement::PP::to_beginning            | a500_1000   |   10000    |  98       |               898.28% |             18420.17% | 1.1e-07 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a500_1000   |   12000    |  83.6     |              1070.07% |             15701.15% | 2.4e-08 |      24 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a500_1000   |   19600    |  51       |              1816.96% |              9544.66% | 2.3e-08 |      28 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a5_10       |  159000    |   6.3     |             15419.60% |              1091.29% |   3e-09 |      25 |
 | List::Utils::MoveElement::Splice::to_beginning_nocopy | a1_1        |  169620    |   5.8955  |             16491.53% |              1014.33% | 2.9e-11 |      20 |
 | List::Utils::MoveElement::PP::to_beginning            | a5_10       |  740000    |   1.35    |             72279.86% |               155.44% | 4.2e-10 |      20 |
 | List::Utils::MoveElement::move_element_to_beginning   | a5_10       |  741883    |   1.34792 |             72467.55% |               154.78% |   0     |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a5_10       |  818300    |   1.222   |             79946.01% |               130.97% | 1.7e-11 |      20 |
 | List::Utils::MoveElement::move_element_to_beginning   | a1_1        | 1853000    |   0.5397  |            181144.80% |                 2.01% | 2.9e-11 |      20 |
 | List::Utils::MoveElement::Splice::to_beginning_copy   | a1_1        | 1865000    |   0.5363  |            182305.11% |                 1.36% | 5.5e-12 |      20 |
 | List::Utils::MoveElement::PP::to_beginning            | a1_1        | 1890000    |   0.529   |            184784.03% |                 0.00% | 2.1e-10 |      20 |
 +-------------------------------------------------------+-------------+------------+-----------+-----------------------+-----------------------+---------+---------+


Formatted as L<Benchmark.pm|Benchmark> result:

                                 Rate  LUM:m_e_t_b a5000_10000  LUMP:t_b a5000_10000  LUMS:t_b_c a5000_10000  LUMS:t_b_n a5000_10000  LUM:m_e_t_b a500_1000  LUMP:t_b a500_1000  LUMS:t_b_c a500_1000  LUMS:t_b_n a500_1000  LUMS:t_b_n a5_10  LUMS:t_b_n a1_1  LUMP:t_b a5_10  LUM:m_e_t_b a5_10  LUMS:t_b_c a5_10  LUM:m_e_t_b a1_1  LUMS:t_b_c a1_1  LUMP:t_b a1_1 
  LUM:m_e_t_b a5000_10000      1020/s                       --                    0%                    -14%                    -51%                   -89%                -89%                  -91%                  -94%              -99%             -99%            -99%               -99%              -99%              -99%             -99%           -99% 
  LUMP:t_b a5000_10000         1030/s                       0%                    --                    -14%                    -51%                   -89%                -89%                  -91%                  -94%              -99%             -99%            -99%               -99%              -99%              -99%             -99%           -99% 
  LUMS:t_b_c a5000_10000       1200/s                      17%                   16%                      --                    -43%                   -88%                -88%                  -89%                  -93%              -99%             -99%            -99%               -99%              -99%              -99%             -99%           -99% 
  LUMS:t_b_n a5000_10000       2100/s                     108%                  106%                     77%                      --                   -79%                -79%                  -82%                  -89%              -98%             -98%            -99%               -99%              -99%              -99%             -99%           -99% 
  LUM:m_e_t_b a500_1000    10184.71/s                     896%                  889%                    750%                    378%                     --                  0%                  -14%                  -48%              -93%             -93%            -98%               -98%              -98%              -99%             -99%           -99% 
  LUMP:t_b a500_1000          10000/s                     897%                  891%                    752%                    379%                     0%                  --                  -14%                  -47%              -93%             -93%            -98%               -98%              -98%              -99%             -99%           -99% 
  LUMS:t_b_c a500_1000        12000/s                    1069%                 1062%                    898%                    462%                    17%                 17%                    --                  -38%              -92%             -92%            -98%               -98%              -98%              -99%             -99%           -99% 
  LUMS:t_b_n a500_1000        19600/s                    1817%                 1805%                   1537%                    821%                    92%                 92%                   63%                    --              -87%             -88%            -97%               -97%              -97%              -98%             -98%           -98% 
  LUMS:t_b_n a5_10           159000/s                   15423%                15328%                  13153%                   7360%                  1458%               1455%                 1226%                  709%                --              -6%            -78%               -78%              -80%              -91%             -91%           -91% 
  LUMS:t_b_n a1_1            169620/s                   16488%                16387%                  14063%                   7872%                  1565%               1562%                 1318%                  765%                6%               --            -77%               -77%              -79%              -90%             -90%           -91% 
  LUMP:t_b a5_10             740000/s                   72344%                71900%                  61751%                  34714%                  7173%               7159%                 6092%                 3677%              366%             336%              --                 0%               -9%              -60%             -60%           -60% 
  LUM:m_e_t_b a5_10          741883/s                   72456%                72011%                  61847%                  34768%                  7184%               7170%                 6102%                 3683%              367%             337%              0%                 --               -9%              -59%             -60%           -60% 
  LUMS:t_b_c a5_10           818300/s                   79932%                79441%                  68230%                  38361%                  7934%               7919%                 6741%                 4073%              415%             382%             10%                10%                --              -55%             -56%           -56% 
  LUM:m_e_t_b a1_1          1853000/s                  181111%               180000%                 154615%                  86985%                 18092%              18058%                15390%                 9349%             1067%             992%            150%               149%              126%                --               0%            -1% 
  LUMS:t_b_c a1_1           1865000/s                  182260%               181141%                 155596%                  87537%                 18208%              18173%                15488%                 9409%             1074%             999%            151%               151%              127%                0%               --            -1% 
  LUMP:t_b a1_1             1890000/s                  184777%               183642%                 157744%                  88746%                 18460%              18425%                15703%                 9540%             1090%            1014%            155%               154%              131%                2%               1%             -- 
 
 Legends:
   LUM:m_e_t_b a1_1: dataset=a1_1 participant=List::Utils::MoveElement::move_element_to_beginning
   LUM:m_e_t_b a5000_10000: dataset=a5000_10000 participant=List::Utils::MoveElement::move_element_to_beginning
   LUM:m_e_t_b a500_1000: dataset=a500_1000 participant=List::Utils::MoveElement::move_element_to_beginning
   LUM:m_e_t_b a5_10: dataset=a5_10 participant=List::Utils::MoveElement::move_element_to_beginning
   LUMP:t_b a1_1: dataset=a1_1 participant=List::Utils::MoveElement::PP::to_beginning
   LUMP:t_b a5000_10000: dataset=a5000_10000 participant=List::Utils::MoveElement::PP::to_beginning
   LUMP:t_b a500_1000: dataset=a500_1000 participant=List::Utils::MoveElement::PP::to_beginning
   LUMP:t_b a5_10: dataset=a5_10 participant=List::Utils::MoveElement::PP::to_beginning
   LUMS:t_b_c a1_1: dataset=a1_1 participant=List::Utils::MoveElement::Splice::to_beginning_copy
   LUMS:t_b_c a5000_10000: dataset=a5000_10000 participant=List::Utils::MoveElement::Splice::to_beginning_copy
   LUMS:t_b_c a500_1000: dataset=a500_1000 participant=List::Utils::MoveElement::Splice::to_beginning_copy
   LUMS:t_b_c a5_10: dataset=a5_10 participant=List::Utils::MoveElement::Splice::to_beginning_copy
   LUMS:t_b_n a1_1: dataset=a1_1 participant=List::Utils::MoveElement::Splice::to_beginning_nocopy
   LUMS:t_b_n a5000_10000: dataset=a5000_10000 participant=List::Utils::MoveElement::Splice::to_beginning_nocopy
   LUMS:t_b_n a500_1000: dataset=a500_1000 participant=List::Utils::MoveElement::Splice::to_beginning_nocopy
   LUMS:t_b_n a5_10: dataset=a5_10 participant=List::Utils::MoveElement::Splice::to_beginning_nocopy

Benchmark module startup overhead (C<< bencher -m List::Utils::MoveElement::move_element_to_beginning --module-startup >>):

 #table2#
 +----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | participant                      | time (ms) | mod_overhead_time | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors   | samples |
 +----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+
 | List::Utils::MoveElement         |        10 |                 5 |                 0.00% |               122.42% |   0.00026 |      20 |
 | List::Utils::MoveElement::PP     |        10 |                 5 |                22.58% |                81.45% |   0.00029 |      20 |
 | List::Utils::MoveElement::Splice |         6 |                 1 |                88.11% |                18.24% | 6.9e-05   |      21 |
 | perl -e1 (baseline)              |         5 |                 0 |               122.42% |                 0.00% |   0.00016 |      20 |
 +----------------------------------+-----------+-------------------+-----------------------+-----------------------+-----------+---------+


Formatted as L<Benchmark.pm|Benchmark> result:

               Rate  LU:M  LUM:P  LUM:S  :perl -e1 ( 
  LU:M           /s    --     0%   -40%         -50% 
  LUM:P          /s    0%     --   -40%         -50% 
  LUM:S          /s   66%    66%     --         -16% 
  :perl -e1 (    /s  100%   100%    19%           -- 
 
 Legends:
   :perl -e1 (: mod_overhead_time=0 participant=perl -e1 (baseline)
   LU:M: mod_overhead_time=5 participant=List::Utils::MoveElement
   LUM:P: mod_overhead_time=5 participant=List::Utils::MoveElement::PP
   LUM:S: mod_overhead_time=1 participant=List::Utils::MoveElement::Splice

To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 BENCHMARK NOTES

Using copy+splice+unshift (L<List::Utils::MoveElement::Splice>) is faster. And
we can get significantly faster still with larger list by avoiding copying
C<@_>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-List-Utils-MoveElement>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-List-Utils-MoveElement>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-List-Utils-MoveElement>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
