package Travel::Status::DE::IRIS::Stations;

use strict;
use warnings;
use 5.014;
use utf8;

use Geo::Distance;
use List::Util qw(min);
use List::UtilsBy qw(uniq_by);
use List::MoreUtils qw(firstval pairwise);
use Text::LevenshteinXS qw(distance);

# TODO Geo::Distance is kinda deprecated, it is recommended to use GIS::Distance
# instead. However, since GIS::Distance is not packaged for Debian, I'll stick
# with Geo::Distance for now (which works fine enough here)

# TODO switch to Text::Levenshtein::XS once AUR/Debian packages become available

our $VERSION = '1.24';

my @stations = (

	[ 'KA',    'Aachen Hbf',               8000001, 6.09149900, 50.7678000 ],
	[ 'KASZ',  'Aachen Schanz',            8070704, 6.07384000, 50.7698620 ],
	[ 'KAW',   'Aachen West',              8000404, 6.07071500, 50.7803600 ],
	[ 'KAW P', 'Aachen West',              8000404, 6.07071500, 50.7803600 ],
	[ 'KARE',  'Aachen-Rothe Erde',        8000406, 6.11647500, 50.7702020 ],
	[ 'KAREP', 'Aachen-Rothe Erde',        8000406, 6.11647500, 50.7702020 ],
	[ 'TA',    'Aalen Hbf',                8000002, 10.0962710, 48.8410130 ],
	[ 'KAB',   'Abenden',                  8007826, 6.47645900, 50.6710850 ],
	[ 'MABG',  'Abensberg',                8000410, 11.8466200, 48.8194560 ],
	[ 'RAH',   'Achern',                   8000412, 8.06532400, 48.6339900 ],
	[ 'RAHS',  'Achern Stadt',             8007001, 8.06770600, 48.6257360 ],
	[ 'HACH',  'Achim',                    8000413, 9.03044700, 53.0159900 ],
	[ 'RAK',   'Achkarren',                8007291, 7.60787000, 48.0600880 ],
	[ 'HAMR',  'Achmer',                   8000414, 7.94216000, 52.3904790 ],
	[ 'AACW',  'Achterwehr',               8000416, 9.96402400, 54.3149130 ],
	[ 'HADB',  'Adelebsen',                8000418, 9.76004400, 51.5776900 ],
	[ 'MAD',   'Adelschlag',               8000419, 11.2114430, 48.8407590 ],
	[ 'NADM',  'Adelsdorf(Mittelfr)',      8000420, 10.6870410, 49.4749440 ],
	[ 'RADN',  'Adelsheim Nord',           8000423, 9.39275400, 49.4214900 ],
	[ 'TAD',   'Adelsheim Ost',            8000424, 9.39512700, 49.4031230 ],
	[ 'DADO',  'Adorf(Erzgeb)',            8011002, 12.8736660, 50.7638500 ],
	[ 'DAD',   'Adorf(Vogtl)',             8010001, 12.2607890, 50.3239260 ],
	[ 'TAF',   'Affaltrach',               8000431, 9.37901200, 49.1378320 ],
	[ 'MAGD',  'Agatharied',               8000433, 11.8244720, 47.7656060 ],
	[ 'AABG',  'Agathenburg',              8000434, 9.53124400, 53.5641110 ],
	[ 'RAG',   'Aglasterhausen',           8007445, 8.99083800, 49.3500970 ],
	[ 'RA',    'Aha',                      8000436, 8.13434900, 47.8332240 ],
	[ 'EAHS',  'Ahaus',                    8000437, 7.01645300, 52.0816810 ],
	[ 'WABG',  'Ahlbeck Grenze',           8079084, 14.2155490, 53.9219660 ],
	[ 'WABO',  'Ahlbeck Ostseetherme',     8087025, 14.1772870, 53.9444260 ],
	[ 'EAHL',  'Ahlen(Westf)',             8000441, 7.89548800, 51.7610620 ],
	[ 'HAHO',  'Ahlhorn',                  8000442, 8.20942900, 52.8993210 ],
	[ 'HALT',  'Ahlten',                   8000443, 9.90461300, 52.3760620 ],
	[ 'FATC',  'Ahnatal Casselbreite',     8000457, 9.43406100, 51.3628600 ],
	[ 'FHEH',  'Ahnatal-Heckershausen',    8002675, 9.42272700, 51.3629910 ],
	[ 'FWEI',  'Ahnatal-Weimar',           8006286, 9.39158800, 51.3636290 ],
	[ 'KBRU',  'Ahrbrück',                8001209, 6.97239100, 50.4896790 ],
	[ 'AAHR',  'Ahrensburg',               8000446, 10.2362060, 53.6691710 ],
	[ 'AAHG',  'Ahrensburg-Gartenholz',    8000480, 10.2517860, 53.6884820 ],
	[ 'BAHR',  'Ahrensfelde',              8011003, 13.5651540, 52.5713750 ],
	[ 'BAFR',  'Ahrensfelde Friedhof',     8011004, 13.5733160, 52.5808820 ],
	[ 'BAFN',  'Ahrensfelde Nord',         8011005, 13.5819850, 52.5906850 ],
	[ 'KAH',   'Ahrweiler',                8000448, 7.10707100, 50.5465440 ],
	[ 'KAHM',  'Ahrweiler Markt',          8000449, 7.09422900, 50.5442280 ],
	[ 'MAIC',  'Aich(Niederbay)',          8000451, 12.3981630, 48.4173150 ],
	[ 'MAI',   'Aichach',                  8000452, 11.1227210, 48.4611170 ],
	[ 'TAI',   'Aichstetten',              8000454, 10.0749400, 47.8878840 ],
	[ 'MAID',  'Aindorf',                  8072132, 12.3577420, 47.9870420 ],
	[ 'MAIN',  'Ainring',                  8000459, 12.9645010, 47.8150330 ],
	[ 'RAL',   'Albbruck',                 8000463, 8.13177400, 47.5922350 ],
	[ 'AAL',   'Albersdorf',               8000464, 9.29215100, 54.1463200 ],
	[ 'RAR',   'Albersweiler(Pfalz)',      8000466, 8.02446400, 49.2184700 ],
	[ 'FAG',   'Albig',                    8000468, 8.11657900, 49.7713750 ],
	[ 'FAGB',  'Albig',                    8000468, 8.11657900, 49.7713750 ],
	[ 'FALH',  'Albisheim(Pfrimm)',        8070252, 8.09675200, 49.6447760 ],
	[ 'LALB',  'Albrechtshaus',            8017000, 10.9292670, 51.6421730 ],
	[ 'BAS',   'Albrechtshof',             8080040, 13.1289170, 52.5493960 ],
	[ 'FALS',  'Albshausen',               8000471, 8.43486900, 50.5457160 ],
	[ 'RAM',   'Albsheim(Eis)',            8070096, 8.17899800, 49.5806830 ],
	[ 'TAE',   'Albstadt-Ebingen',         8000473, 9.02696200, 48.2102900 ],
	[ 'TAEW',  'Albstadt-Ebingen West',    8079089, 8.99698000, 48.2113900 ],
	[ 'TALO',  'Albstadt-Laufen Ort',      8000474, 8.91731600, 48.2228590 ],
	[ 'TALT',  'Albstadt-Lautlingen',      8000475, 8.95462000, 48.2136380 ],
	[ 'KALK',  'Aldekerk',                 8000477, 6.41254200, 51.4357590 ],
	[ 'TALD',  'Aldingen(b Spaichingen)',  8000481, 8.71303300, 48.0958450 ],
	[ 'MALH',  'Aletshausen',              8000482, 10.3836310, 48.2013130 ],
	[ 'LAX',   'Alexisbad',                8017001, 11.1153110, 51.6481320 ],
	[ 'HALF',  'Alfeld(Leine)',            8000483, 9.81777900, 51.9814170 ],
	[ 'KALI',  'Alfter-Impekoven',         8000495, 7.01983100, 50.7110160 ],
	[ 'KWIS',  'Alfter-Witterschlick',     8006516, 7.02608300, 50.6896980 ],
	[ 'HALG',  'Algermissen',              8000488, 9.96647200, 52.2518800 ],
	[ 'HALI',  'Aligse',                   8000489, 9.97934900, 52.4034620 ],
	[ 'FADD',  'Allendorf(Dillkr)',        8000492, 8.18548600, 50.7438110 ],
	[ 'RAB',   'Allensbach',               8000496, 9.06885200, 47.7144640 ],
	[ 'NALB',  'Allersberg(Rothsee)',      8000498, 11.2125730, 49.2621310 ],
	[ 'TALL',  'Allmendingen',             8000499, 9.72238200, 48.3277340 ],
	[ 'KALP',  'Alpen',                    8000500, 6.51804100, 51.5833920 ],
	[ 'RALP',  'Alpirsbach',               8000501, 8.39825100, 48.3438090 ],
	[ 'KADP',  'Alsdorf Poststraße',      8000510, 6.19707500, 50.8557490 ],
	[ 'EGNP',  'Alsdorf(Westerw)',         8007078, 7.89048600, 50.7808900 ],
	[ 'KADA',  'Alsdorf-Annapark',         8000502, 6.15666100, 50.8705170 ],
	[ 'KADB',  'Alsdorf-Busch',            8000507, 6.14058600, 50.8765880 ],
	[ 'KKEL',  'Alsdorf-Kellersberg',      8000521, 6.16735400, 50.8675270 ],
	[ 'KMAD',  'Alsdorf-Mariadorf',        8000527, 6.18845400, 50.8619780 ],
	[ 'SAZ',   'Alsenz',                   8000505, 7.81718900, 49.7274950 ],
	[ 'FAFD',  'Alsfeld(Oberhess)',        8000350, 9.26429700, 50.7509620 ],
	[ 'FAHM',  'Alsheim',                  8000506, 8.34246200, 49.7655280 ],
	[ 'WAHU',  'Alt Hüttendorf',          8011011, 13.7835740, 52.9575910 ],
	[ 'BARO',  'Alt Rosenthal',            8011014, 14.2786270, 52.5504030 ],
	[ 'TACH',  'Altbach',                  8000508, 9.38238400, 48.7203930 ],
	[ 'NADW',  'Altdorf West',             8000504, 11.3414670, 49.3911460 ],
	[ 'MAF',   'Altdorf(Niederbay)',       8026354, 12.1028130, 48.5549790 ],
	[ 'NAD',   'Altdorf(b Nürnberg)',     8000509, 11.3535300, 49.3900060 ],
	[ 'BAD',   'Altdöbern',               8011016, 14.0092360, 51.6527800 ],
	[ 'NAVE',  'Alte Veste',               8000511, 10.9723630, 49.4543220 ],
	[ 'WAF',   'Altefähr',                8011017, 13.1410100, 54.3229270 ],
	[ 'EALN',  'Altena(Westf)',            8000513, 7.66880800, 51.3019810 ],
	[ 'KALT',  'Altenahr',                 8000514, 6.98970700, 50.5156520 ],
	[ 'MALT',  'Altenau(Bay)',             8000515, 11.0173750, 47.6483650 ],
	[ 'LALT',  'Altenbach',                8011018, 12.6823240, 51.3558680 ],
	[ 'SAB',   'Altenbamberg',             8000517, 7.83074500, 49.7868570 ],
	[ 'HA',    'Altenbeken',               8000004, 8.94331900, 51.7664330 ],
	[ 'EABG',  'Altenberge',               8000518, 7.48130300, 52.0522580 ],
	[ 'LA',    'Altenburg',                8010003, 12.4440190, 50.9966480 ],
	[ 'MANE',  'Altenerding',              8000524, 11.9017440, 48.2935720 ],
	[ 'FATF',  'Altenfeld(Rhön)',         8000525, 9.84972600, 50.4508980 ],
	[ 'SALG',  'Altenglan',                8000491, 7.46184100, 49.5486430 ],
	[ 'AAT',   'Altengörs',               8000526, 10.3555540, 53.8986960 ],
	[ 'FAHN',  'Altenhasungen',            8000530, 9.22573700, 51.3435400 ],
	[ 'KAK',   'Altenkirchen(Westerwald)', 8000351, 7.63825700, 50.6844180 ],
	[ 'MATM',  'Altenmarkt(Alz)',          8000533, 12.5360270, 47.9998170 ],
	[ 'EASE',  'Altenseelbach',            8000537, 7.99239800, 50.7838370 ],
	[ 'FAST',  'Altenstadt(Hess)',         8000538, 8.94397700, 50.2833980 ],
	[ 'MASI',  'Altenstadt(Iller)',        8000539, 10.1099830, 48.1611910 ],
	[ 'NALW',  'Altenstadt(Waldnaab)',     8000540, 12.1648700, 49.7156790 ],
	[ 'FHTN',  'Altenstadt-Höchst',       8002886, 8.92341800, 50.2697670 ],
	[ 'FLIN',  'Altenstadt-Lindheim',      8003698, 8.97877500, 50.2913340 ],
	[ 'WATR',  'Altentreptow',             8011025, 13.2427130, 53.6922330 ],
	[ 'WALW',  'Altenwillershagen',        8011027, 12.5728180, 54.2594060 ],
	[ 'UACH',  'Altersbach',               8011028, 10.5445220, 50.7006400 ],
	[ 'BJA',   'Altes Lager',              8011968, 12.9890480, 52.0173560 ],
	[ 'RAT',   'Altglashütten-Falkau',    8000544, 8.11411300, 47.8593920 ],
	[ 'MAHB',  'Althegnenberg',            8000545, 11.0630030, 48.2363740 ],
	[ 'FAT',   'Altheim(Hess)',            8000546, 8.89090600, 49.9233320 ],
	[ 'WAH',   'Althof',                   8011031, 11.9223410, 54.0904420 ],
	[ 'TAG',   'Altingen(Württ)',         8070591, 8.90885200, 48.5619270 ],
	[ 'DAMD',  'Altmittweida',             8011033, 12.9596900, 50.9683480 ],
	[ 'FAMO',  'Altmorschen',              8000553, 9.61075600, 51.0672750 ],
	[ 'DAMG',  'Altmügeln',               8070697, 13.0403560, 51.2377870 ],
	[ 'MAMT',  'Altomünster',             8000556, 11.2551330, 48.3849180 ],
	[ 'DAOR',  'Altoschatz-Rosenthal',     8070689, 13.0985950, 51.2878380 ],
	[ 'BART',  'Altranft',                 8011034, 14.0821070, 52.7633680 ],
	[ 'TAT',   'Altshausen',               8000559, 9.55147800, 47.9308380 ],
	[ 'MATS',  'Altstädten(Allgäu)',     8000561, 10.2809070, 47.4885500 ],
	[ 'TATN',  'Alttann',                  8000562, 9.79303700, 47.8412140 ],
	[ 'MAT',   'Altötting',               8000555, 12.6747900, 48.2212420 ],
	[ 'AAV',   'Alveslohe',                8070185, 9.91637500, 53.7914560 ],
	[ 'FAZB',  'Alzenau Burg',             8077275, 9.07434000, 50.0879280 ],
	[ 'FAZUN', 'Alzenau Nord',             8077274, 9.05138500, 50.0894430 ],
	[ 'FAZU',  'Alzenau(Unterfr)',         8007275, 9.06560300, 50.0887160 ],
	[ 'FALZ',  'Alzey',                    8000007, 8.10974900, 49.7502000 ],
	[ 'FAZS',  'Alzey Süd',               8000558, 8.11873200, 49.7381340 ],
	[ 'FAZW',  'Alzey West',               8007474, 8.10725500, 49.7409780 ],
	[ 'NAM',   'Amberg',                   8000566, 11.8629020, 49.4476160 ],
	[ 'MAMG',  'Amerang',                  8070802, 12.3062970, 47.9858350 ],
	[ 'UAMM',  'Ammern',                   8011029, 10.4580860, 51.2333460 ],
	[ 'NAMB',  'Amorbach',                 8000575, 9.22314700, 49.6456090 ],
	[ 'MAPF',  'Ampfing',                  8000576, 12.4109190, 48.2539490 ],
	[ 'LAMS',  'Amsdorf',                  8011038, 11.7197900, 51.4635610 ],
	[ 'TAM M', 'Amstetten(W) Lokalbahn',   8079075, 9.87395900, 48.5778520 ],
	[ 'TAM',   'Amstetten(Württ)',        8000577, 9.87296500, 48.5783280 ],
	[ 'DAMH',  'Amtshainersdorf',          8011039, 14.2323640, 50.9663220 ],
	[ 'KAND',  'Andernach',                8000331, 7.40483900, 50.4345420 ],
	[ 'KANM',  'Angermund',                8000579, 6.78185700, 51.3307480 ],
	[ 'WA',    'Angermünde',              8010004, 13.9963610, 53.0152210 ],
	[ 'LANG',  'Angern-Rogätz',           8011042, 11.7595350, 52.3384640 ],
	[ 'FANG',  'Angersbach',               8000580, 9.44726000, 50.6307700 ],
	[ 'LAG',   'Angersdorf',               8011043, 11.9031390, 51.4604070 ],
	[ 'WAK',   'Anklam',                   8011044, 13.7018270, 53.8561020 ],
	[ 'DABM',  'Annaberg-Buchholz Mitte',  8011045, 12.9990780, 50.5667910 ],
	[ 'DAB',   'Annaberg-Buchholz Süd',   8010005, 12.9974040, 50.5558860 ],
	[ 'DABU', 'Annaberg-Buchholz unterer Bf', 8011047, 12.9983130, 50.5786100 ],
	[ 'LAB',  'Annaburg',                     8011048, 13.0327570, 51.7286800 ],
	[ 'RAN',  'Annweiler am Trifels',         8000582, 7.96614900, 49.2053860 ],
	[ 'RANS', 'Annweiler-Sarnstall',          8005257, 7.93719200, 49.2087250 ],
	[ 'KANR', 'Anrath',                       8000584, 6.45023000, 51.2855360 ],
	[ 'NAN',  'Ansbach',                      8000009, 10.5782390, 49.2980320 ],
	[ 'DATL', 'Antonsthal',                   8011049, 12.7554490, 50.5000960 ],
	[ 'NAWN', 'Anwanden',                     8000588, 10.9303960, 49.4116920 ],
	[ 'FAZ',  'Anzefahr',                     8000589, 8.85959000, 50.8457310 ],
	[ 'MAK',  'Anzenkirchen',                 8000590, 13.0219960, 48.4347390 ],
	[ 'AAPS', 'Apensen',                      8007831, 9.61234500, 53.4416670 ],
	[ 'UAP',  'Apolda',                       8011051, 11.5261360, 51.0309400 ],
	[ 'RAP',  'Appenweier',                   8000596, 7.97319000, 48.5414610 ],
	[ 'RAPP', 'Appenweier',                   8000596, 7.97319000, 48.5414610 ],
	[ 'EARE', 'Ardey',                        8000597, 7.72717600, 51.4811630 ],
	[ 'LAF',  'Arensdorf(Köthen)',           8011053, 12.0074160, 51.7095110 ],
	[ 'UAR',  'Arenshausen',                  8011054, 9.96863900, 51.3751660 ],
	[ 'FAF',  'Arfurt(Lahn)',                 8000599, 8.21107900, 50.4064030 ],
	[ 'FARM', 'Armsheim',                     8000602, 8.07411300, 49.8083720 ],
	[ 'MANB', 'Arnbach',                      8000603, 11.3440440, 48.3413200 ],
	[ 'EARB', 'Arnsberg(Westf)',              8000605, 8.06796500, 51.4056620 ],
	[ 'NARG', 'Arnschwang',                   8000606, 12.8116000, 49.2746080 ],
	[ 'DAF',  'Arnsdorf(Dresden)',            8010006, 13.9822120, 51.0928070 ],
	[ 'UA',   'Arnstadt Hbf',                 8010007, 10.9482620, 50.8419390 ],
	[ 'UASD', 'Arnstadt Süd',                8011055, 10.9549580, 50.8310840 ],
	[ 'NARR', 'Arrach',                       8007343, 13.0028040, 49.1953640 ],
	[ 'KARS', 'Arsbeck',                      8000611, 6.20656300, 51.1520060 ],
	[ 'UAT',  'Artern',                       8012440, 11.3107570, 51.3632400 ],
	[ 'NAZ',  'Arzberg(Oberfr)',              8000613, 12.1976920, 50.0546330 ],
	[ 'NAH',  'Aschaffenburg Hbf',            8000010, 9.14369700, 49.9805570 ],
	[ 'NAHF', 'Aschaffenburg Hochschule',     8000618, 9.16041600, 49.9744450 ],
	[ 'NASU', 'Aschaffenburg Süd',           8000619, 9.15258600, 49.9684650 ],
	[ 'MASC', 'Aschau(Chiemgau)',             8000621, 12.3255640, 47.7791060 ],
	[ 'AAG',  'Ascheberg(Holst)',             8000011, 10.3394810, 54.1484620 ],
	[ 'EASB', 'Ascheberg(Westf)',             8000623, 7.60074900, 51.7829910 ],
	[ 'HASD', 'Aschendorf',                   8000624, 7.33715300, 53.0521790 ],
	[ 'LAL',  'Aschersleben',                 8010009, 11.4656890, 51.7571220 ],
	[ 'AASN', 'Ashausen',                     8000627, 10.1455640, 53.3686930 ],
	[ 'TAX',  'Asperg',                       8000630, 9.14779700, 48.9073590 ],
	[ 'RASH', 'Asselheim',                    8000625, 8.16160200, 49.5762200 ],
	[ 'FAS',  'Assenheim(Oberhess)',          8000632, 8.81246200, 50.3049390 ],
	[ 'FAH',  'Assmannshausen',               8000635, 7.86735500, 49.9853240 ],
	[ 'EAT',  'Attendorn',                    8000638, 7.90849300, 51.1246440 ],
	[ 'EHOH', 'Attendorn-Hohen Hagen',        8087039, 7.85528100, 51.0901650 ],
	[ 'RWSA', 'Au im Murgtal',                8000643, 8.36234900, 48.7188670 ],
	[ 'KAU',  'Au(Sieg)',                     8000012, 7.65653700, 50.7737650 ],
	[ 'DAU',  'Aue(Sachs)',                   8010010, 12.6985180, 50.5916820 ],
	[ 'DAUS', 'Aue(Sachs) Erzgebirgsstadion', 8010027, 12.7093500, 50.5966410 ],
	[ 'EAWN', 'Aue-Wingeshausen',             8000647, 8.29008500, 51.0517850 ],
	[ 'UAE',  'Auehütte',                    8011057, 10.4166660, 50.7196720 ],
	[ 'DAUO', 'Auerbach(V) ob Bf',            8010011, 12.3820540, 50.5191360 ],
	[ 'DAUU', 'Auerbach(V) unt Bf',           8010012, 12.3914210, 50.5117220 ],
	[ 'DAUH', 'Auerbach(Vogtl) Hp',           8011059, 12.3792040, 50.5069550 ],
	[ 'RACH', 'Auerbach(b Mosbach, Baden)',   8000649, 9.22327600, 49.3995630 ],
	[ 'UAS',  'Auerstedt',                    8011060, 11.5904370, 51.1020300 ],
	[ 'TAUF', 'Aufhausen(Württ)',            8000655, 10.3171930, 48.8561300 ],
	[ 'MAFE', 'Aufhausen(b Erding)',          8000653, 11.8943750, 48.2743650 ],
	[ 'RAUG', 'Auggen',                       8000657, 7.58678800, 47.7899490 ],
	[ 'MAHA', 'Augsburg Haunstetterstraße',  8000658, 10.9009850, 48.3552850 ],
	[ 'MA',   'Augsburg Hbf',                 8000013, 10.8855700, 48.3654410 ],
	[ 'MAGM', 'Augsburg Messe',               8000659, 10.8860860, 48.3386840 ],
	[ 'MAMS', 'Augsburg Morellstr.',          8000660, 10.8929480, 48.3550890 ],
	[ 'MAHZ', 'Augsburg-Hochzoll',            8000661, 10.9433760, 48.3529770 ],
	[ 'MAHZH', 'Augsburg-Hochzoll',       8000661, 10.9433760, 48.3529770 ],
	[ 'MAOB',  'Augsburg-Oberhausen',     8000662, 10.8725330, 48.3807720 ],
	[ 'HAUG',  'Augustfehn',              8000664, 7.75965900, 53.2208900 ],
	[ 'AAU',   'Aukrug',                  8003078, 9.78581000, 54.0823980 ],
	[ 'TAU',   'Aulendorf',               8000014, 9.64404600, 47.9530520 ],
	[ 'FAUM',  'Aumenau',                 8000668, 8.24924900, 50.4004220 ],
	[ 'AAH',   'Aumühle',                8000669, 10.3146720, 53.5298530 ],
	[ 'AAMS',  'Aumühle',                8000669, 10.3146720, 53.5298530 ],
	[ 'FAM',   'Auringen-Medenbach',      8000671, 8.33209300, 50.1136080 ],
	[ 'SAUW',  'Auw an der Kyll',         8000674, 6.61452500, 49.9035960 ],
	[ 'NAUR',  'Außenried',              8000672, 13.1817630, 49.0157630 ],
	[ 'MAY',   'Aying',                   8000675, 11.7695780, 47.9687620 ],
	[ 'FAL',   'Aßlar',                  8000633, 8.46275600, 50.5886570 ],
	[ 'MAG',   'Aßling(Oberbay)',        8000634, 11.9935180, 47.9894910 ],
	[ 'WBA',   'Baabe',                   8011063, 13.7048060, 54.3623150 ],
	[ 'LBB',   'Baalberge',               8010013, 11.7846820, 51.7630480 ],
	[ 'MBAE',  'Baar-Ebenhausen',         8000678, 11.4609290, 48.6744630 ],
	[ 'FLAS',  'Babenhausen Langstadt',   8003559, 8.94573300, 49.9222740 ],
	[ 'FBA',   'Babenhausen(Hess)',       8000015, 8.95718200, 49.9579630 ],
	[ 'RBST',  'Babstadt',                8000681, 9.06070800, 49.2401960 ],
	[ 'FBCH',  'Bacharach',               8000683, 7.76952300, 50.0561010 ],
	[ 'MBCN',  'Bachern',                 8000685, 11.3787160, 48.2801590 ],
	[ 'UB',    'Bachfeld',                8011065, 10.9824510, 50.4057720 ],
	[ 'RBH',   'Bachheim',                8000686, 8.39939900, 47.8620720 ],
	[ 'TB',    'Backnang',                8000016, 9.42598900, 48.9426760 ],
	[ 'NBAB',  'Bad Abbach',              8000689, 11.9943220, 48.9227320 ],
	[ 'MBAI',  'Bad Aibling',             8000690, 12.0041570, 47.8620280 ],
	[ 'MBAK',  'Bad Aibling Kurpark',     8000696, 12.0138230, 47.8576170 ],
	[ 'FAR',   'Bad Arolsen',             8000609, 8.99779200, 51.3816000 ],
	[ 'RBEL',  'Bad Bellingen',           8000864, 7.55760100, 47.7308040 ],
	[ 'BBIG',  'Bad Belzig',              8010031, 12.5949810, 52.1359690 ],
	[ 'HBTH',  'Bad Bentheim',            8000879, 7.15853900, 52.3098500 ],
	[ 'RBZB',  'Bad Bergzabern',          8000691, 8.00278700, 49.1032090 ],
	[ 'UBB',   'Bad Berka',               8011066, 11.2815500, 50.8961380 ],
	[ 'UBBZ',  'Bad Berka Zeughausplatz', 8011067, 11.2800950, 50.9004410 ],
	[ 'EBLB',  'Bad Berleburg',           8000907, 8.39410900, 51.0511970 ],
	[ 'ABVS',  'Bad Bevensen',            8000935, 10.5741410, 53.0782470 ],
	[ 'MBIB',  'Bad Birnbach',            8000988, 13.0740340, 48.4328530 ],
	[ 'UBL',  'Bad Blankenburg(Thüringerw)', 8010014, 11.2754980, 50.6826480 ],
	[ 'KBOD', 'Bad Bodendorf',                8001049, 7.21721700, 50.5562660 ],
	[ 'HBOD', 'Bad Bodenteich',               8001052, 10.6733710, 52.8342750 ],
	[ 'DBM',  'Bad Brambach',                 8011068, 12.3114140, 50.2175870 ],
	[ 'ABSD', 'Bad Bramstedt',                8007058, 9.89016200, 53.9205930 ],
	[ 'ABSK', 'Bad Bramstedt Kurhaus',        8007057, 9.89046300, 53.9040130 ],
	[ 'KBRE', 'Bad Breisig',                  8000694, 7.30456400, 50.5042180 ],
	[ 'FCA',  'Bad Camberg',                  8001322, 8.25503600, 50.2964330 ],
	[ 'WDO',  'Bad Doberan',                  8010016, 11.9053350, 54.1000040 ],
	[ 'WDOG', 'Bad Doberan Goethestraße',    8011069, 11.8998940, 54.1084630 ],
	[ 'WDOS', 'Bad Doberan Stadtmitte',       8081085, 11.9021000, 54.1046500 ],
	[ 'HBDG', 'Bad Driburg(Westf)',           8000697, 9.03081000, 51.7303230 ],
	[ 'LDU',  'Bad Düben(Mulde)',            8011070, 12.5988150, 51.5876230 ],
	[ 'RBDH', 'Bad Dürkheim',                8000698, 8.17070100, 49.4606330 ],
	[ 'RBDT', 'Bad Dürkheim-Trift',          8000708, 8.19307200, 49.4664160 ],
	[ 'LDBG', 'Bad Dürrenberg',              8011071, 12.0696550, 51.3049410 ],
	[ 'DBEL', 'Bad Elster',                   8011072, 12.2562860, 50.2966720 ],
	[ 'MBEP', 'Bad Empfing',                  8000700, 12.6328880, 47.8840070 ],
	[ 'FEMS', 'Bad Ems',                      8000701, 7.72863700, 50.3276520 ],
	[ 'FEMW', 'Bad Ems West',                 8000702, 7.70603900, 50.3306940 ],
	[ 'MBEF', 'Bad Endorf',                   8001787, 12.3015580, 47.9050660 ],
	[ 'HFAL', 'Bad Fallingbostel',            8001958, 9.70023300, 52.8629250 ],
	[ 'WFW',  'Bad Freienwalde',              8010017, 14.0357510, 52.7899330 ],
	[ 'TBF',  'Bad Friedrichshall Hbf',       8000017, 9.19977100, 49.2315710 ],
	[ 'TBK', 'Bad Friedrichshall-Kochendorf', 8000704, 9.21154900, 49.2177530 ],
	[ 'HBGM', 'Bad Gandersheim',            8000352, 10.0202360, 51.8673700 ],
	[ 'RBGR', 'Bad Griesbach(Schwarzwald)', 8000707, 8.23056900, 48.4486180 ],
	[ 'MGNB', 'Bad Grönenbach',            8002378, 10.2537150, 47.8824680 ],
	[ 'HBHA', 'Bad Harzburg',               8000019, 10.5554440, 51.8881160 ],
	[ 'RHLB', 'Bad Herrenalb',              8007011, 8.43895700, 48.8024280 ],
	[ 'FBHF', 'Bad Hersfeld',               8000020, 9.71618200, 50.8696320 ],
	[ 'FHO',  'Bad Homburg',                8000712, 8.62062400, 50.2199040 ],
	[ 'KHF',  'Bad Honnef Stadtbahn',       8070073, 7.21723100, 50.6437500 ],
	[ 'KHBD', 'Bad Honnef(Rhein)',          8000713, 7.21953300, 50.6397720 ],
	[ 'MBHT', 'Bad Höhenstadt',            8000710, 13.3231950, 48.4946060 ],
	[ 'KHGB', 'Bad Hönningen',             8000711, 7.31087100, 50.5136760 ],
	[ 'TIMN', 'Bad Imnau',                  8070309, 8.77009200, 48.4041550 ],
	[ 'HKRF', 'Bad Karlshafen',             8003182, 9.44571000, 51.6462700 ],
	[ 'NBKI', 'Bad Kissingen',              8000714, 10.0798850, 50.1915470 ],
	[ 'WK',   'Bad Kleinen',                8010018, 11.4669250, 53.7669740 ],
	[ 'MBKG', 'Bad Kohlgrub',               8000716, 11.0582040, 47.6680060 ],
	[ 'MBKK', 'Bad Kohlgrub Kurhaus',       8000717, 11.0391810, 47.6702130 ],
	[ 'SBKN', 'Bad Kreuznach',              8000021, 7.86643500, 49.8423990 ],
	[ 'RBKR', 'Bad Krozingen',              8000718, 7.69763200, 47.9197210 ],
	[ 'RBKO', 'Bad Krozingen Ost',          8007330, 7.70979000, 47.9171400 ],
	[ 'FKI',  'Bad König',                 8000715, 9.00153900, 49.7385770 ],
	[ 'FZK',  'Bad König Zell',            8006643, 8.99411600, 49.7203260 ],
	[ 'UKO',  'Bad Kösen',                 8010019, 11.7182740, 51.1307420 ],
	[ 'UBKZ', 'Bad Köstritz',              8011074, 12.0284520, 50.9315900 ],
	[ 'NKZ',  'Bad Kötzting',              8003393, 12.8518920, 49.1729200 ],
	[ 'ELSP', 'Bad Laasphe',                8003486, 8.42072000, 50.9293120 ],
	[ 'ENL',  'Bad Laasphe-Niederlaasphe',  8003493, 8.44200100, 50.9243240 ],
	[ 'ULS',  'Bad Langensalza',            8010020, 10.6406710, 51.1017010 ],
	[ 'LBLS', 'Bad Lausick',                8011077, 12.6486950, 51.1438030 ],
	[
		'HBLB', 'Bad Lauterberg im Harz Barbis', 8005324, 10.4146070,
		51.6190240
	],
	[ 'BBLW', 'Bad Liebenwerda',             8011078, 13.4029300, 51.5184010 ],
	[ 'TBLI', 'Bad Liebenzell',              8000721, 8.73403900, 48.7725780 ],
	[ 'ULB',  'Bad Lobenstein',              8013452, 11.6421710, 50.4521220 ],
	[ 'AMAG', 'Bad Malente-Gremsmühlen',    8003829, 10.5515100, 54.1670140 ],
	[ 'TBMR', 'Bad Mergentheim',             8000724, 9.77166200, 49.4936470 ],
	[ 'HMDD', 'Bad Münder(Deister)',        8000725, 9.46806200, 52.1781920 ],
	[ 'SBMS', 'Bad Münster a Stein',        8000726, 7.84698900, 49.8134260 ],
	[ 'KMUE', 'Bad Münstereifel',           8000727, 6.76436900, 50.5589140 ],
	[ 'KARL', 'Bad Münstereifel-Arloff',    8000601, 6.78660800, 50.5976760 ],
	[ 'KIV',  'Bad Münstereifel-Iversheim', 8003104, 6.76916200, 50.5830340 ],
	[ 'FBNA', 'Bad Nauheim',                 8000728, 8.74933400, 50.3679040 ],
	[ 'HNDF', 'Bad Nenndorf',                8000022, 9.37860300, 52.3437350 ],
	[ 'KNEB', 'Bad Neuenahr',                8000729, 7.14430400, 50.5477650 ],
	[ 'NBNE', 'Bad Neustadt(Saale)',         8000730, 10.2261340, 50.3281270 ],
	[ 'TBN',  'Bad Niedernau',               8000731, 8.89653300, 48.4607660 ],
	[ 'HOY',  'Bad Oeynhausen',              8000732, 8.79652300, 52.2053980 ],
	[ 'HBOE', 'Bad Oeynhausen Süd',         8000733, 8.80172300, 52.1971270 ],
	[ 'AO',   'Bad Oldesloe',                8000023, 10.3828320, 53.8052830 ],
	[ 'RBPL', 'Bad Peterstal',               8000734, 8.20194800, 48.4288950 ],
	[ 'HPRT', 'Bad Pyrmont',                 8000735, 9.27271900, 51.9742330 ],
	[ 'RBRA', 'Bad Rappenau',                8000736, 9.10152900, 49.2377650 ],
	[ 'RBPK', 'Bad Rappenau Kurpark',        8000777, 9.11352600, 49.2403710 ],
	[ 'MBRL', 'Bad Reichenhall',             8000737, 12.8818250, 47.7311680 ],
	[ 'MBRK', 'Bad Reichenhall-Kirchberg',   8000738, 12.8740010, 47.7185380 ],
	[ 'NRC',  'Bad Rodach',                  8005112, 10.7783870, 50.3369860 ],
	[ 'RRO',  'Bad Rotenfels Bf',            8005183, 8.30310000, 48.8158220 ],
	[ 'RROG', 'Bad Rotenfels Schloss',       8005186, 8.29713100, 48.8199490 ],
	[
		'RROW', 'Bad Rotenfels Weinbrennerstraße',
		8005187, 8.31205400, 48.8115150
	],
	[ 'BBSP',  'Bad Saarow',                  8011079, 14.0649290, 52.2932530 ],
	[ 'BBSK',  'Bad Saarow Klinikum',         8010028, 14.0659640, 52.2846320 ],
	[ 'HSCH',  'Bad Sachsa',                  8000739, 10.5732110, 51.5819440 ],
	[ 'HBSA',  'Bad Salzdetfurth',            8000740, 10.0055950, 52.0626350 ],
	[ 'HBSK',  'Bad Salzdetfurth Solebad',    8000759, 10.0189160, 52.0699400 ],
	[ 'FBSH',  'Bad Salzhausen',              8000741, 8.98038100, 50.4188780 ],
	[ 'FSF',   'Bad Salzschlirf',             8000743, 9.49448400, 50.6269350 ],
	[ 'EBSU',  'Bad Salzuflen',               8000744, 8.74042800, 52.0816280 ],
	[ 'USZ',   'Bad Salzungen',               8010021, 10.2310600, 50.8151850 ],
	[ 'EBSA',  'Bad Sassendorf',              8000745, 8.16243900, 51.5871680 ],
	[ 'TSL',   'Bad Saulgau',                 8005301, 9.50108300, 48.0135930 ],
	[ 'DSA',   'Bad Schandau',                8010022, 14.1393220, 50.9188350 ],
	[ 'DSUB',  'Bad Schlema',                 8012873, 12.6802290, 50.6189020 ],
	[ 'LBSB',  'Bad Schmiedeberg',            8011081, 12.7438740, 51.6887610 ],
	[ 'LBSK',  'Bad Schmiedeberg Kurzentrum', 8070831, 12.7349990, 51.6790100 ],
	[ 'LBSS',  'Bad Schmiedeberg Süd',       8011083, 12.7258694, 51.6698138 ],
	[ 'TBSC',  'Bad Schussenried',            8000746, 9.66849700, 47.9940330 ],
	[ 'ASCH',  'Bad Schwartau',               8000749, 10.7027220, 53.9162760 ],
	[ 'RBS',   'Bad Schönborn Süd',         8003533, 8.64192400, 49.2000010 ],
	[ 'RBSK',  'Bad Schönborn-Kronau',       8004032, 8.64682100, 49.2193450 ],
	[ 'TBSB',  'Bad Sebastiansweiler-Belsen', 8000750, 9.03002300, 48.3955660 ],
	[ 'ASB',   'Bad Segeberg',                8000751, 10.3081630, 53.9338050 ],
	[ 'SSOB',  'Bad Sobernheim',              8005583, 7.64981600, 49.7828500 ],
	[ 'FBSO',  'Bad Soden(Taunus)',           8000752, 8.50412800, 50.1434060 ],
	[ 'FBSS',  'Bad Soden-Salmünster',       8005261, 9.37205300, 50.2807420 ],
	[ 'FBSD',  'Bad Sooden-Allendorf',        8000753, 9.96869600, 51.2679740 ],
	[ 'APSD',  'Bad St Peter Süd',           8000754, 8.64804100, 54.3050100 ],
	[ 'APO',   'Bad St Peter-Ording',         8000755, 8.61473600, 54.3172930 ],
	[ 'NSFN',  'Bad Staffelstein',            8005670, 10.9942390, 50.1082580 ],
	[ 'NBST',  'Bad Steben',                  8000756, 11.6467700, 50.3650950 ],
	[ 'LSUR',  'Bad Suderode',                8011084, 11.1257820, 51.7336730 ],
	[ 'UBS',   'Bad Sulza',                   8011085, 11.6345950, 51.0947670 ],
	[ 'UBSN',  'Bad Sulza Nord',              8011086, 11.6283000, 51.0974280 ],
	[ 'RSAE',  'Bad Säckingen',              8005255, 7.94863000, 47.5558570 ],
	[ 'TBT',   'Bad Teinach-Neubulach',       8000757, 8.72714800, 48.6784700 ],
	[ 'MBT',   'Bad Tölz',                   8000758, 11.5739400, 47.7605780 ],
	[ 'KTST',  'Bad Tönisstein',             8070314, 7.29885900, 50.4593180 ],
	[ 'TUC',   'Bad Urach',                   8006029, 9.39648300, 48.4912440 ],
	[ 'TUCK',  'Bad Urach Ermstalklinik',     8006027, 9.38690100, 48.4941550 ],
	[ 'TUCW',  'Bad Urach Wasserfall',        8070680, 9.37640100, 48.4992630 ],
	[ 'FVL',   'Bad Vilbel',                  8000760, 8.73946000, 50.1886770 ],
	[ 'FVLS',  'Bad Vilbel Süd',             8000761, 8.73347700, 50.1786960 ],
	[ 'FGRN',  'Bad Vilbel-Gronau',           8002382, 8.78320300, 50.1915290 ],
	[ 'TBWA',  'Bad Waldsee',                 8000763, 9.75227400, 47.9252440 ],
	[ 'TWB',   'Bad Wildbad Bf',              8006431, 8.55108900, 48.7557180 ],
	[ 'TWBK',  'Bad Wildbad Kurpark',         8070283, 8.55045900, 48.7487550 ],
	[ 'TWBN',  'Bad Wildbad Nord',            8070281, 8.55509500, 48.7639360 ],
	[ 'TWBU',  'Bad Wildbad Uhlandplatz',     8070282, 8.54936600, 48.7508370 ],
	[ 'FBWD',  'Bad Wildungen',               8000764, 9.13609100, 51.1196190 ],
	[ 'WWIL',  'Bad Wilsnack',                8011088, 11.9493440, 52.9602290 ],
	[ 'RBWF',  'Bad Wimpfen',                 8000765, 9.16729700, 49.2297440 ],
	[ 'TBWT',  'Bad Wimpfen Im Tal',          8000706, 9.18704600, 49.2298480 ],
	[ 'RBWH',  'Bad Wimpfen-Hohenstadt',      8000766, 9.13875300, 49.2425370 ],
	[ 'NBWI',  'Bad Windsheim',               8000767, 10.4129420, 49.5066000 ],
	[ 'TBW',   'Bad Wurzach',                 8000769, 9.88973900, 47.9102580 ],
	[ 'MBWH',  'Bad Wörishofen',             8000768, 10.5978750, 48.0057110 ],
	[ 'HZWI',  'Bad Zwischenahn',             8000770, 8.00312300, 53.1825470 ],
	[ 'HBAD',  'Baddeckenstedt',              8000772, 10.2287670, 52.0891600 ],
	[ 'HBDV',  'Baden(Verden)',               8000773, 9.08126100, 53.0078720 ],
	[ 'RBB',   'Baden-Baden',                 8000774, 8.19083100, 48.7903270 ],
	[ 'RHEB',  'Baden-Baden Haueneberstein',  8000771, 8.20902100, 48.8119070 ],
	[ 'RBBL',  'Baden-Baden Rebland',         8000775, 8.14657200, 48.7338440 ],
	[ 'BBG',   'Bagenz',                      8011097, 14.4269080, 51.6548880 ],
	[ 'RBAR',  'Bahlingen Riedlen',           8007310, 7.74777600, 48.1180190 ],
	[ 'RBAL',  'Bahlingen am Kaiserstuhl',    8007293, 7.74151600, 48.1244940 ],
	[ 'RBBR',  'Bahnbrücken',                8007144, 8.76485400, 49.1194470 ],
	[ 'BBO',   'Bahnsdorf',                   8011098, 14.1122880, 51.5817450 ],
	[ 'MBAB',  'Baierbrunn',                  8000781, 11.4800270, 48.0187410 ],
	[ 'RBSN',  'Baiersbronn Bf',              8000782, 8.37186800, 48.5041040 ],
	[ 'RBSS',  'Baiersbronn Schule',          8000789, 8.37585800, 48.5106100 ],
	[ 'NBD',   'Baiersdorf',                  8000783, 11.0369760, 49.6561470 ],
	[ 'BBAI',  'Baitz',                       8011100, 12.6851110, 52.1641490 ],
	[ 'NBAF',  'Balbersdorf',                 8000784, 12.6830640, 49.2904400 ],
	[ 'MBDH',  'Baldham',                     8000785, 11.7867800, 48.0992560 ],
	[ 'FBAD',  'Balduinstein',                8000786, 7.96800000, 50.3468200 ],
	[ 'TBLH',  'Balgheim',                    8000787, 8.75989200, 48.0658860 ],
	[ 'UBGS',  'Balgstädt',                  8011103, 11.7384540, 51.2082950 ],
	[ 'TBGS',  'Balingen Süd',               8000788, 8.84648400, 48.2690140 ],
	[ 'TBG',   'Balingen(Württ)',            8000353, 8.85030700, 48.2784690 ],
	[ 'UBAS',  'Ballstädt(Gotha)',           8011106, 10.7076660, 51.0407500 ],
	[ 'SBAL',  'Baltersweiler',               8000792, 7.16653800, 49.4937850 ],
	[ 'EBAV',  'Balve',                       8000793, 7.86307100, 51.3325940 ],
	[ 'NBA',   'Bamberg',                     8000025, 10.8994890, 49.9007590 ],
	[ 'RBAM',  'Bammental',                   8000794, 8.78368500, 49.3595880 ],
	[ 'WBAM',  'Bannemin-Mölschow',          8011108, 13.8365740, 54.0713970 ],
	[ 'WBN',   'Bansin Seebad',               8011109, 14.1293850, 53.9643890 ],
	[ 'HBAN',  'Banteln',                     8000796, 9.75033000, 52.0662640 ],
	[ 'HBTF',  'Bantorf',                     8000797, 9.41777100, 52.3322530 ],
	[ 'TBA',   'Barabein',                    8079098, 9.82690200, 48.1447340 ],
	[ 'RBRT',  'Barbelroth',                  8000802, 8.07030700, 49.1041180 ],
	[ 'ABAD',  'Bardowick',                   8000801, 10.3719940, 53.2904690 ],
	[ 'ABAW',  'Bardowick',                   8000801, 10.3719940, 53.2904690 ],
	[ 'ABAT',  'Bargstedt',                   8007840, 9.44627600, 53.4575440 ],
	[ 'ABAE',  'Bargteheide',                 8000804, 10.2691040, 53.7282000 ],
	[ 'LBAR',  'Barleben',                    8011111, 11.6208750, 52.2089450 ],
	[ 'LBAS',  'Barleber See',                8011112, 11.6408520, 52.2143280 ],
	[ 'ABMS',  'Barmstedt',                   8007070, 9.77200700, 53.7929780 ],
	[ 'ABMB',  'Barmstedt Brunnenstr',        8007069, 9.76188800, 53.7926190 ],
	[ 'HBNF',  'Barnstorf(Han)',              8000807, 8.51046200, 52.7075870 ],
	[ 'HBNT',  'Barnten',                     8000808, 9.81527900, 52.1954980 ],
	[ 'HBAR',  'Barrien',                     8000810, 8.81850600, 52.9468370 ],
	[ 'HBGH',  'Barsinghausen',               8000812, 9.46711200, 52.3048900 ],
	[ 'WBH',   'Barth',                       8011114, 12.7264600, 54.3623420 ],
	[ 'DBAM',  'Barthmühle',                 8011115, 12.1636810, 50.5579570 ],
	[ 'BBA',   'Baruth(Mark)',                8011116, 13.5119630, 52.0579160 ],
	[ 'ABAA',  'Basdahl Kluste',              8070023, 9.01217500, 53.4542000 ],
	[ 'ABAAK', 'Basdahl Kluste',              8070023, 9.01217500, 53.4542000 ],
	[ 'BBAS',  'Basdorf',                     8010025, 13.4339930, 52.7155610 ],
	[ 'RB',    'Basel Bad Bf',                8000026, 7.60780500, 47.5672880 ],
	[ 'HBAS',  'Bassum',                      8000354, 8.73992400, 52.8473880 ],
	[ 'RBZE',  'Batzenhäusle',               8000821, 7.94108000, 48.0890640 ],
	[ 'NBH',   'Batzhausen',                  8000822, 11.5930330, 49.1913640 ],
	[ 'RBBC',  'Bauerbach',                   8000823, 8.74815300, 49.0739640 ],
	[ 'SBH',   'Baumholder',                  8007888, 7.33123600, 49.6121600 ],
	[ 'NBAU',  'Baunach',                     8000826, 10.8541150, 49.9890900 ],
	[ 'FGTH',  'Baunatal-Guntershausen',      8000140, 9.46699700, 51.2299170 ],
	[ 'FREH',  'Baunatal-Rengershausen',      8005039, 9.46866700, 51.2549220 ],
	[ 'DBZ',   'Bautzen',                     8010026, 14.4287350, 51.1730970 ],
	[ 'ABF',   'Bavendorf',                   8000827, 10.6295370, 53.1874740 ],
	[ 'MBYB',  'Bayerbach',                   8000828, 13.1344510, 48.4144120 ],
	[ 'NBEI',  'Bayerisch Eisenstein',        8000830, 13.2098150, 49.1218620 ],
	[ 'MBGM',  'Bayerisch Gmain',             8000831, 12.8950700, 47.7203750 ],
	[ 'NBY',   'Bayreuth Hbf',                8000028, 11.5799850, 49.9496160 ],
	[ 'NBYG',  'Bayreuth-St Georgen',         8000833, 11.5966830, 49.9573400 ],
	[ 'MBZ',   'Bayrischzell',                8000834, 12.0117730, 47.6754060 ],
	[ 'LBBZ',  'Bebitz',                      8011119, 11.7639670, 51.7241360 ],
	[ 'FB',    'Bebra',                       8000029, 9.79778800, 50.9695680 ],
	[ 'UBET',  'Bechstedt-Trippstein',        8011121, 11.1681530, 50.6597330 ],
	[ 'SBE',   'Beckingen(Saar)',             8000840, 6.68802100, 49.3868810 ],
	[ 'KBE',   'Bedburg(Erft)',               8000030, 6.57261500, 50.9874780 ],
	[ 'KBH',   'Bedburg-Hau',                 8000842, 6.17347900, 51.7580520 ],
	[ 'EBEE',  'Beelen',                      8000846, 8.11615900, 51.9293200 ],
	[ 'BBZS',  'Beelitz Stadt',               8013468, 12.9668600, 52.2393950 ],
	[ 'BBEL',  'Beelitz-Heilstätten',        8013467, 12.9260570, 52.2623450 ],
	[ 'FHZ',   'Beerfelden Hetzbach',         8002815, 8.99285600, 49.5948990 ],
	[ 'BBES',  'Beeskow',                     8010029, 14.2509740, 52.1776840 ],
	[ 'WBES',  'Beetz-Sommerfeld',            8011125, 13.0220860, 52.8042590 ],
	[ 'NBEH',  'Behringersdorf',              8000850, 11.1984980, 49.4815740 ],
	[ 'FBEI',  'Beienheim',                   8000851, 8.82102200, 50.3591310 ],
	[ 'LBEI',  'Beilrode',                    8011131, 13.0649350, 51.5710050 ],
	[ 'TBS',   'Beimerstetten',               8000858, 9.97683500, 48.4809740 ],
	[ 'ABE',   'Beldorf',                     8000860, 9.35621700, 54.1252660 ],
	[ 'LBGH',  'Belgershain',                 8011132, 12.5427850, 51.2339470 ],
	[ 'LBLL',  'Belleben',                    8011133, 11.6333760, 51.6736030 ],
	[ 'MBNB',  'Bellenberg',                  8000862, 10.0903900, 48.2546450 ],
	[ 'RBLN',  'Bellheim Am Mühlbuckel',     8000861, 8.29762600, 49.1926390 ],
	[ 'RBLH',  'Bellheim Bf',                 8000863, 8.29456000, 49.1883030 ],
	[ 'TBEM',  'Bempflingen',                 8000865, 9.27342500, 48.5723640 ],
	[ 'MBEN',  'Benediktbeuern',              8000869, 11.4030510, 47.7091210 ],
	[ 'SBG',   'Bengel',                      8000870, 7.05803000, 50.0103790 ],
	[ 'LBEK',  'Benneckenstein',              8017002, 10.7148110, 51.6735470 ],
	[ 'HBML',  'Bennemühlen',                8000871, 9.72683600, 52.5809930 ],
	[ 'LWZW',  'Bennewitz',                   8013362, 12.7084300, 51.3559260 ],
	[ 'HBEN',  'Bennigsen',                   8000872, 9.66637600, 52.2407330 ],
	[ 'TBEN',  'Benningen(Neckar)',           8000873, 9.24450400, 48.9436140 ],
	[ 'UBEN',  'Bennungen',                   8011138, 11.1229890, 51.4640060 ],
	[ 'UBH',   'Benshausen',                  8011139, 10.6022080, 50.6570090 ],
	[ 'FBH',   'Bensheim',                    8000031, 8.61671700, 49.6813290 ],
	[ 'FBAU',  'Bensheim-Auerbach',           8000877, 8.61336600, 49.7015570 ],
	[ 'WBE',   'Bentwisch',                   8011140, 12.2105060, 54.1171930 ],
	[ 'NBE',   'Beratzhausen',                8000882, 11.8078530, 49.0928460 ],
	[ 'DBER',  'Berbisdorf',                  8011142, 13.7250650, 51.1861940 ],
	[ 'DBEA',  'Berbisdorf Anbau',            8011143, 13.7273900, 51.1977710 ],
	[ 'MBG',   'Berchtesgaden Hbf',           8000885, 12.9990580, 47.6266880 ],
	[ 'RBRG',  'Berg(Pfalz)',                 8000890, 8.21276100, 48.9806760 ],
	[ 'UBGE',  'Berga(Elster)',               8011144, 12.1588650, 50.7471890 ],
	[ 'UBK',   'Berga-Kelbra',                8010032, 11.0145990, 51.4521700 ],
	[ 'WBG',   'Bergen auf Rügen',           8010033, 13.4178210, 54.4205000 ],
	[ 'MBE',   'Bergen(Oberbay)',             8000888, 12.5928460, 47.8252700 ],
	[ 'TBER',  'Bergenweiler',                8000889, 10.2728790, 48.5762970 ],
	[ 'BBFE',  'Bergfelde(b Berlin)',         8080100, 13.3202440, 52.6703030 ],
	[ 'RBGBS', 'Berghausen Am Stadion',       8007864, 8.53601000, 49.0024560 ],
	[ 'RBGBP', 'Berghausen Pfinzbrücke',     8007863, 8.52092000, 49.0064670 ],
	[ 'RBGB',  'Berghausen(Baden)',           8000893, 8.53016900, 49.0057500 ],
	[ 'RBGP',  'Berghausen(Pfalz)',           8000894, 8.40617300, 49.2954490 ],
	[ 'EBGA',  'Berghausen(b Wittgenstein)',  8000892, 8.35001000, 51.0330360 ],
	[ 'KBEE',  'Bergheim(Erft)',              8000355, 6.64630200, 50.9517060 ],
	[ 'KBGG',  'Bergisch Gladbach',           8000899, 7.12455300, 50.9914610 ],
	[ 'WBER',  'Bergsdorf',                   8011149, 13.2607940, 52.9365650 ],
	[ 'NBHM',  'Bergtheim',                   8000902, 10.0764730, 49.8993000 ],
	[ 'LBWZ',  'Bergwitz',                    8011150, 12.5762130, 51.8036960 ],
	[ 'RBE',   'Beringen Bad Bf',             8000903, 8.57461600, 47.6948970 ],
	[ 'RBEF',  'Beringerfeld',                8000901, 8.59277100, 47.6953080 ],
	[ 'EBRH',  'Beringhausen',                8000904, 8.75141400, 51.4077710 ],
	[ 'ABGS',  'Beringstedt',                 8000905, 9.53750100, 54.1136670 ],
	[ 'BBKR',  'Berkenbrück',                8011154, 14.1652170, 52.3571900 ],
	[ 'BALE',  'Berlin Alexanderplatz',       8011155, 13.4109610, 52.5214810 ],
	[ 'BALX',  'Berlin Alexanderplatz (S)',   8089001, 13.4110070, 52.5216420 ],
	[ 'BARF',  'Berlin Alt-Reinickendorf',    8089103, 13.3496170, 52.5780910 ],
	[ 'BAHU',  'Berlin Anhalter Bf',          8089002, 13.3813620, 52.5034860 ],
	[ 'BATS',  'Berlin Attilastr.',           8089003, 13.3609510, 52.4476810 ],
	[ 'BBW',   'Berlin Baumschulenweg',       8089004, 13.4900970, 52.4672440 ],
	[ 'BBEV',  'Berlin Bellevue',             8089005, 13.3482630, 52.5199550 ],
	[ 'BRB', 'Berlin Betriebsbf Rummelsburg', 8089006, 13.4977860, 52.4938270 ],
	[
		'BSCF',  'Berlin Betriebsbf Schöneweide',
		8089007, 13.5236800,
		52.4469050
	],
	[ 'BBEU', 'Berlin Beusselstraße',       8089118, 13.3290420, 52.5343540 ],
	[ 'BBOS', 'Berlin Bornholmer Str.',      8089008, 13.3979430, 52.5544910 ],
	[ 'BBGT', 'Berlin Botanischer Garten',   8089009, 13.3067660, 52.4477840 ],
	[ 'BTOR', 'Berlin Brandenburger Tor',    8089044, 13.3818150, 52.5165060 ],
	[ 'BBCH', 'Berlin Buckower Chaussee',    8089010, 13.3829120, 52.4103510 ],
	[ 'BBUP', 'Berlin Bundesplatz',          8089107, 13.3295900, 52.4776170 ],
	[ 'BEBD', 'Berlin Eichborndamm',         8089101, 13.3168350, 52.5777220 ],
	[ 'BFB',  'Berlin Feuerbachstr.',        8089012, 13.3325750, 52.4635460 ],
	[ 'BFAL', 'Berlin Frankfurter Allee',    8089013, 13.4744100, 52.5151680 ],
	[ 'BFRI', 'Berlin Friedrichstraße',     8011306, 13.3873140, 52.5203940 ],
	[ 'BGSE', 'Berlin Gehrenseestr.',        8089014, 13.5248340, 52.5560110 ],
	[ 'BGS',  'Berlin Gesundbrunnen',        8011102, 13.3885130, 52.5489630 ],
	[ 'BGB',  'Berlin Gesundbrunnen(S)',     8089015, 13.3885130, 52.5489630 ],
	[ 'BGFB', 'Berlin Greifswalder Str',     8089011, 13.4395610, 52.5400200 ],
	[ 'BGBA', 'Berlin Grünbergallee',       8089016, 13.5424850, 52.3994110 ],
	[ 'BHKM', 'Berlin Hackescher Markt',     8089017, 13.4023640, 52.5226220 ],
	[ 'BLS',  'Berlin Hbf',                  8011160, 13.3695450, 52.5255920 ],
	[ 'BHBF', 'Berlin Hbf (S-Bahn)',         8089021, 13.3695450, 52.5255920 ],
	[ 'BL',   'Berlin Hbf (tief)',           8098160, 13.3695450, 52.5255920 ],
	[ 'BHST', 'Berlin Heerstraße',          8089329, 13.2593790, 52.5081210 ],
	[ 'BHEI', 'Berlin Heidelberger Platz',   8089112, 13.3120180, 52.4799720 ],
	[ 'BHER', 'Berlin Hermannstraße',       8089105, 13.4313130, 52.4675100 ],
	[ 'BHO',  'Berlin Hohenzollerndamm',     8089108, 13.3002570, 52.4885560 ],
	[ 'BHUM', 'Berlin Humboldthain',         8089018, 13.3792770, 52.5447950 ],
	[ 'BIP',  'Berlin Innsbrucker Platz',    8089106, 13.3421970, 52.4780840 ],
	[ 'BJB',  'Berlin Jannowitzbrücke',     8089019, 13.4193470, 52.5142700 ],
	[ 'BJLB', 'Berlin Julius-Leber-Brücke', 8089537, 13.3612660, 52.4865190 ],
	[ 'BJUF', 'Berlin Jungfernheide',        8011167, 13.2994370, 52.5302760 ],
	[ 'BJUN', 'Berlin Jungfernheide (S)',    8089100, 13.2994460, 52.5303750 ],
	[
		'BKBO', 'Berlin Karl-Bonhoeffer-Nervenklinik',
		8089102, 13.3291760, 52.5780480
	],
	[ 'BKHD', 'Berlin Köllnische Heide', 8089104, 13.4678070, 52.4696530 ],
	[ 'BLST', 'Berlin Landsberger Allee', 8089020, 13.4545670, 52.5295930 ],
	[ 'BMEA', 'Berlin Mehrower Allee',    8089022, 13.5536990, 52.5577590 ],
	[
		'BMN', 'Berlin Messe Nord/ICC (Witzleben)',
		8089110, 13.2834450, 52.5075250
	],
	[ 'BMS',  'Berlin Messe Süd (Eichkamp)', 8089328, 13.2701180, 52.4987500 ],
	[ 'BMEX', 'Berlin Mexikoplatz',           8089023, 13.2327120, 52.4369370 ],
	[ 'BNB',  'Berlin Nordbahnhof',           8089024, 13.3884640, 52.5320660 ],
	[ 'BNPL', 'Berlin Nöldnerplatz',         8089026, 13.4844520, 52.5034970 ],
	[ 'BOLS', 'Berlin Olympiastadion',        8089330, 13.2423890, 52.5111660 ],
	[ 'BORS', 'Berlin Oranienburger Straße', 8089027, 13.3930520, 52.5252100 ],
	[ 'BOSS', 'Berlin Osdorfer Straße',      8089473, 13.3142880, 52.4188410 ],
	[ 'BHF',  'Berlin Ostbahnhof',            8010255, 13.4345640, 52.5109770 ],
	[ 'BOKN', 'Berlin Ostkreuz',              8011162, 13.4691050, 52.5030370 ],
	[ 'BOKO', 'Berlin Ostkreuz',              8011162, 13.4691050, 52.5030370 ],
	[ 'BOK',  'Berlin Ostkreuz (S)',          8089028, 13.4693090, 52.5030030 ],
	[ 'BOKR', 'Berlin Ostkreuz (S)',          8089028, 13.4693090, 52.5030030 ],
	[ 'BOKS', 'Berlin Ostkreuz (S)',          8089028, 13.4693090, 52.5030030 ],
	[ 'BPWA', 'Berlin Plänterwald',          8089030, 13.4731260, 52.4785420 ],
	[ 'BPOE', 'Berlin Poelchaustr.',          8089031, 13.5353810, 52.5355930 ],
	[ 'BPOF', 'Berlin Potsdamer Platz',       8011118, 13.3759880, 52.5093790 ],
	[ 'BPOP', 'Berlin Potsdamer Platz (S)',   8089032, 13.3766490, 52.5095080 ],
	[ 'BPLA', 'Berlin Prenzlauer Allee',      8089033, 13.4264120, 52.5446150 ],
	[ 'BPRS', 'Berlin Priesterweg',           8089034, 13.3562810, 52.4599140 ],
	[ 'BRW',  'Berlin Raoul-Wallenberg-Str.', 8089035, 13.5474600, 52.5506810 ],
	[ 'BRST', 'Berlin Rathaus Steglitz',      8089036, 13.3229480, 52.4558330 ],
	[ 'BSAP', 'Berlin Savignyplatz',          8089037, 13.3192710, 52.5050930 ],
	[ 'BSC',  'Berlin Schichauweg',           8089038, 13.3893030, 52.3988370 ],
	[ 'BSAL', 'Berlin Schönhauser Allee',    8089039, 13.4154600, 52.5492000 ],
	[ 'BSO',  'Berlin Sonnenallee',           8089327, 13.4558510, 52.4731010 ],
	[ 'BSPH', 'Berlin Springpfuhl',           8089040, 13.5367400, 52.5263480 ],
	[ 'BSTO', 'Berlin Storkower Str',         8089041, 13.4643980, 52.5239100 ],
	[ 'BSDG', 'Berlin Sundgauer Str',         8089042, 13.2743770, 52.4365440 ],
	[ 'BSDE', 'Berlin Südende',              8089115, 13.3538940, 52.4484570 ],
	[ 'BPAF', 'Berlin Südkreuz',             8011113, 13.3653190, 52.4750470 ],
	[ 'BSKR', 'Berlin Südkreuz (S)',         8089073, 13.3651440, 52.4761340 ],
	[ 'BSKV', 'Berlin Südkreuz (S)',         8089073, 13.3651440, 52.4761340 ],
	[ 'BTP',  'Berlin Treptower Park',        8089043, 13.4614410, 52.4935590 ],
	[ 'BWS',  'Berlin Wannsee',               8010405, 13.1793360, 52.4210580 ],
	[ 'BWSS', 'Berlin Wannsee',               8010405, 13.1793360, 52.4210580 ],
	[ 'BWRS', 'Berlin Warschauer Straße',    8089045, 13.4516460, 52.5059760 ],
	[ 'BWES', 'Berlin Westend',               8089111, 13.2846380, 52.5180700 ],
	[ 'BWH',  'Berlin Westhafen',             8089116, 13.3442530, 52.5362500 ],
	[ 'BWKR', 'Berlin Westkreuz',             8089047, 13.2839660, 52.5007370 ],
	[ 'BWKS', 'Berlin Westkreuz',             8089047, 13.2839660, 52.5007370 ],
	[ 'BWKRR', 'Berlin Westkreuz',            8089047, 13.2839660, 52.5007370 ],
	[ 'BWOK',  'Berlin Wollankstraße',       8089048, 13.3917910, 52.5654820 ],
	[ 'BWT',   'Berlin Wuhletal',             8089049, 13.5753650, 52.5124170 ],
	[ 'BGGS',  'Berlin Yorckstr.(S1)',        8089051, 13.3677970, 52.4922890 ],
	[ 'BYOR',  'Berlin Yorckstr.(S2)',        8089050, 13.3721280, 52.4911700 ],
	[ 'BZOO',  'Berlin Zoologischer Garten',  8010406, 13.3319920, 52.5072770 ],
	[ 'BADL',  'Berlin-Adlershof',            8089052, 13.5411290, 52.4350310 ],
	[ 'BAGL',  'Berlin-Altglienicke',         8089054, 13.5587530, 52.4072990 ],
	[ 'BBDF',  'Berlin-Biesdorf',             8089055, 13.5558780, 52.5130970 ],
	[ 'BBLB',  'Berlin-Blankenburg',          8089056, 13.4433300, 52.5911640 ],
	[ 'BBU',   'Berlin-Buch',                 8089057, 13.4922860, 52.6361620 ],
	[ 'BCHB',  'Berlin-Charlottenburg',       8010403, 13.3035240, 52.5047260 ],
	[ 'BFRU',  'Berlin-Friedenau',            8089058, 13.3413880, 52.4705860 ],
	[ 'BFFO',  'Berlin-Friedrichsfelde Ost',  8089059, 13.5202540, 52.5141690 ],
	[ 'BFRH',  'Berlin-Friedrichshagen',      8089060, 13.6246000, 52.4572470 ],
	[ 'BFOH',  'Berlin-Frohnau',              8089061, 13.2899340, 52.6327580 ],
	[ 'BGWD',  'Berlin-Grunewald',            8089062, 13.2617200, 52.4886930 ],
	[ 'BGAS',  'Berlin-Grünau',              8089063, 13.5734970, 52.4130280 ],
	[ 'BHAL',  'Berlin-Halensee',             8089109, 13.2903260, 52.4962540 ],
	[ 'BHLS',  'Berlin-Heiligensee',          8089025, 13.2292780, 52.6245860 ],
	[ 'BHED',  'Berlin-Hermsdorf',            8089064, 13.3076900, 52.6177820 ],
	[ 'BHI',   'Berlin-Hirschgarten',         8089065, 13.6021340, 52.4579680 ],
	[ 'BHSH',  'Berlin-Hohenschönhausen',    8011901, 13.5125650, 52.5661110 ],
	[ 'BKH',   'Berlin-Karlshorst',           8010035, 13.5268130, 52.4806810 ],
	[ 'BKAR',  'Berlin-Karow',                8011046, 13.4692040, 52.6148840 ],
	[ 'BKRW',  'Berlin-Karow',                8011046, 13.4692040, 52.6148840 ],
	[ 'BKAD',  'Berlin-Kaulsdorf',            8089068, 13.5889400, 52.5120930 ],
	[ 'BKPK',  'Berlin-Köpenick',            8089069, 13.5809420, 52.4586100 ],
	[ 'BLAK',  'Berlin-Lankwitz',             8089114, 13.3419540, 52.4387490 ],
	[ 'BLO',   'Berlin-Lichtenberg',          8010036, 13.4969230, 52.5098960 ],
	[ 'BLRD',  'Berlin-Lichtenrade',          8089070, 13.3961750, 52.3872970 ],
	[ 'BLIH',  'Berlin-Lichterfelde Ost',     8011041, 13.3285560, 52.4294510 ],
	[ 'BLIO',  'Berlin-Lichterfelde Ost (S)', 8089113, 13.3278720, 52.4296910 ],
	[ 'BLIS',  'Berlin-Lichterfelde Süd',    8089472, 13.3090400, 52.4108990 ],
	[ 'BLIW',  'Berlin-Lichterfelde West',    8089071, 13.2937320, 52.4433500 ],
	[ 'BMDF',  'Berlin-Mahlsdorf',            8089072, 13.6110710, 52.5121630 ],
	[ 'BMF',   'Berlin-Marienfelde',          8089074, 13.3751270, 52.4236340 ],
	[ 'BMAZ',  'Berlin-Marzahn',              8089075, 13.5413410, 52.5436080 ],
	[ 'BNK',   'Berlin-Neukölln',            8089077, 13.4430600, 52.4694200 ],
	[ 'BNKN',  'Berlin-Neukölln',            8089077, 13.4430600, 52.4694200 ],
	[ 'BNIS',  'Berlin-Nikolassee',           8089078, 13.1936430, 52.4318070 ],
	[ 'BNIW',  'Berlin-Nikolassee',           8089078, 13.1936430, 52.4318070 ],
	[ 'BOSP',  'Berlin-Oberspree',            8089079, 13.5382090, 52.4524660 ],
	[ 'BPKW',  'Berlin-Pankow',               8089080, 13.4107700, 52.5664770 ],
	[ 'BPHD',  'Berlin-Pankow-Heinersdorf',   8089081, 13.4293630, 52.5779630 ],
	[ 'BPIC',  'Berlin-Pichelsberg',          8089331, 13.2271340, 52.5103930 ],
	[ 'BRD',   'Berlin-Rahnsdorf',            8089082, 13.6904050, 52.4515360 ],
	[ 'BRH',   'Berlin-Rummelsburg',          8089084, 13.4783620, 52.5013090 ],
	[ 'BRGB',  'Berlin-Rummelsburg',          8089084, 13.4783620, 52.5013090 ],
	[ 'BSLS',  'Berlin-Schlachtensee',        8089085, 13.2150250, 52.4399760 ],
	[ 'BSZF',  'Berlin-Schulzendorf',         8089000, 13.2459290, 52.6130960 ],
	[ 'BSGR',  'Berlin-Schöneberg',          8089474, 13.3520680, 52.4793770 ],
	[ 'BFHS', 'Berlin-Schönefeld Flughafen', 8010109, 13.5127100, 52.3910620 ],
	[ 'BFLH', 'Berlin-Schönefeld Flughafen', 8010109, 13.5127100, 52.3910620 ],
	[ 'BSWP', 'Berlin-Schöneweide',          8010041, 13.5093950, 52.4551270 ],
	[ 'BSW',  'Berlin-Schöneweide (S)',      8089168, 13.5091150, 52.4549760 ],
	[ 'BSNH', 'Berlin-Schönholz',            8089087, 13.3811110, 52.5714220 ],
	[ 'BSNL', 'Berlin-Schönholz',            8089087, 13.3811110, 52.5714220 ],
	[ 'BSPD', 'Berlin-Spandau',               8010404, 13.1975340, 52.5344750 ],
	[ 'BSPF', 'Berlin-Spindlersfeld',         8089088, 13.5614480, 52.4471620 ],
	[ 'BSTAB', 'Berlin-Staaken',       8013021, 13.1413670, 52.5376930 ],
	[ 'BSRW',  'Berlin-Stresow',       8089053, 13.2091250, 52.5319760 ],
	[ 'BTG',   'Berlin-Tegel (S)',     8089089, 13.2897810, 52.5879980 ],
	[ 'BTHF',  'Berlin-Tempelhof',     8089090, 13.3845470, 52.4709670 ],
	[ 'BTGN',  'Berlin-Tiergarten',    8089091, 13.3363920, 52.5140610 ],
	[ 'BWAI',  'Berlin-Waidmannslust', 8089092, 13.3209960, 52.6064800 ],
	[ 'BWAB',  'Berlin-Wartenberg',    8089093, 13.5036330, 52.5729890 ],
	[ 'BWED',  'Berlin-Wedding',       8089131, 13.3681700, 52.5432510 ],
	[ 'BWIG',  'Berlin-Wilhelmshagen', 8089094, 13.7221430, 52.4387110 ],
	[ 'BWM',   'Berlin-Wilhelmsruh',   8089095, 13.3629760, 52.5814470 ],
	[
		'BWIN', 'Berlin-Wittenau (Wilhelmsruher Damm)',
		8089096, 13.3344460, 52.5970440
	],
	[ 'BWHH', 'Berlin-Wuhlheide',             8089097, 13.5532020, 52.4690300 ],
	[ 'BZD',  'Berlin-Zehlendorf',            8089098, 13.2586590, 52.4310670 ],
	[ 'RBAH', 'Bermatingen-Ahausen',          8000909, 9.34515700, 47.7304880 ],
	[ 'MBN',  'Bernau a Chiemsee',            8000911, 12.3809570, 47.8164820 ],
	[ 'BBRN', 'Bernau(b Berlin)',             8013470, 13.5922930, 52.6758330 ],
	[ 'BBRF', 'Bernau-Friedenstal',           8089099, 13.5645780, 52.6683850 ],
	[ 'LBG',  'Bernburg',                     8010043, 11.7514550, 51.7961200 ],
	[ 'LBGF', 'Bernburg-Friedenshall',        8011168, 11.7686870, 51.7736230 ],
	[ 'LBGS', 'Bernburg-Strenzfeld',          8011169, 11.7176450, 51.8198920 ],
	[ 'LBGW', 'Bernburg-Waldau',              8011170, 11.7233120, 51.8057810 ],
	[ 'LBWD', 'Bernburg-Waldau',              8011170, 11.7233120, 51.8057810 ],
	[ 'HBER', 'Berne',                        8000913, 8.47536800, 53.1837790 ],
	[ 'MBER', 'Bernried',                     8000918, 11.2836580, 47.8613870 ],
	[ 'UBE',  'Bernterode',                   8011172, 10.4799450, 51.4054650 ],
	[ 'HBBR', 'Bersenbrück',                 8000919, 7.94240500, 52.5512420 ],
	[ 'DBF',  'Berthelsdorf(Erzgeb)',         8010044, 13.3636080, 50.8755910 ],
	[ 'DBFO', 'Berthelsdorf(Erzgebirge) Ort', 8017219, 13.3801470, 50.8678900 ],
	[ 'DBTS', 'Bertsdorf',                    8010045, 14.7466410, 50.8684460 ],
	[ 'FBEZ', 'Berzhahn',                     8000921, 8.00603100, 50.5398910 ],
	[ 'SBS',  'Besch',                        8000923, 6.37230300, 49.5043910 ],
	[ 'TBE',  'Besigheim',                    8000925, 9.13664500, 48.9977230 ],
	[ 'SBES', 'Besseringen',                  8000926, 6.60255900, 49.4759740 ],
	[ 'BBST', 'Bestensee',                    8011173, 13.6349200, 52.2421290 ],
	[ 'EBWG', 'Bestwig',                      8000927, 8.39783900, 51.3619130 ],
	[ 'NBMS', 'Bettmannsäge',                8000928, 13.1862740, 48.9976870 ],
	[ 'EBZ',  'Betzdorf(Sieg)',               8000034, 7.87005000, 50.7892940 ],
	[ 'LBEU', 'Beucha',                       8010046, 12.5731330, 51.3236200 ],
	[ 'WBEU', 'Beuchow',                      8013539, 13.5024540, 54.3621220 ],
	[ 'RBEU', 'Beuggen',                      8000932, 7.81091500, 47.5819060 ],
	[ 'LBEN', 'Beuna(Geiseltal)',             8011177, 11.9627810, 51.3227650 ],
	[ 'UBEU', 'Beuren',                       8011178, 10.2790340, 51.3771270 ],
	[ 'TBEU', 'Beuron',                       8000933, 8.97189000, 48.0487910 ],
	[ 'TBTB', 'Beutelsbach',                  8000934, 9.38602900, 48.8102930 ],
	[ 'BBE',  'Beutersitz',                   8011179, 13.3607240, 51.5903590 ],
	[ 'SBX',  'Bexbach',                      8000941, 7.25445600, 49.3456980 ],
	[ 'LBYD', 'Beyendorf',                    8011181, 11.6310500, 52.0611450 ],
	[ 'MBID', 'Bibelöd',                     8000946, 12.6466810, 47.7715170 ],
	[ 'RBI',  'Biberach(Baden)',              8000942, 8.03276200, 48.3383880 ],
	[ 'TBI',  'Biberach(Riß)',               8000943, 9.79312700, 48.1018450 ],
	[ 'TBIB', 'Biberach(Riß) Süd',          8000944, 9.80323600, 48.0870180 ],
	[ 'FBL',  'Biblis',                       8000503, 8.45041300, 49.6888810 ],
	[ 'UBA',  'Bibra',                        8011183, 10.4443260, 50.4687570 ],
	[ 'MBIC', 'Bichl',                        8000945, 11.4087690, 47.7238150 ],
	[ 'FBI',  'Bickenbach(Bergstr)',          8000948, 8.60341500, 49.7596320 ],
	[ 'FBBM', 'Biebesheim',                   8000951, 8.47397800, 49.7819770 ],
	[ 'FBIK', 'Biedenkopf',                   8000952, 8.52998900, 50.9091130 ],
	[ 'FBIZ', 'Biedenkopf-Schulzentrum',      8000954, 8.51770600, 50.9151250 ],
	[ 'LBZ',  'Biederitz',                    8010047, 11.7164660, 52.1527100 ],
	[ 'EBILP', 'Bielefeld Hbf',          8000036, 8.53272200, 52.0292610 ],
	[ 'EBIO',  'Bielefeld Ost',          8000953, 8.55941600, 52.0240130 ],
	[ 'EBIS',  'Bielefeld-Senne',        8000956, 8.52033500, 51.9651180 ],
	[ 'LBF',   'Biendorf',               8011184, 11.8564110, 51.7568610 ],
	[ 'ABIL',  'Bienenbüttel',          8000955, 10.4847140, 53.1421270 ],
	[ 'DBIE',  'Bienenmühle',           8011185, 13.5285330, 50.7403990 ],
	[ 'SBI',   'Bierbach',               8000357, 7.28201100, 49.2618900 ],
	[ 'HROE',  'Bieren-Rödinghausen',   8000957, 8.51696400, 52.2392750 ],
	[ 'TBIE',  'Bieringen',              8000959, 8.86091500, 48.4490290 ],
	[ 'EBID',  'Biersdorf(Westerw)',     8007076, 7.94362300, 50.7499870 ],
	[ 'EBDO',  'Biersdorf-Ort(Ww)',      8007113, 7.94903600, 50.7482730 ],
	[ 'WBT',   'Biesenthal',             8011188, 13.6746650, 52.7554150 ],
	[ 'MBIH',  'Biessenhofen',           8000962, 10.6404670, 47.8299560 ],
	[ 'MBIHH', 'Biessenhofen',           8000962, 10.6404670, 47.8299560 ],
	[ 'RBIE',  'Bietigheim(Baden)',      8000963, 8.25804500, 48.9105870 ],
	[ 'TBM',   'Bietigheim-Bissingen',   8000038, 9.13755700, 48.9479330 ],
	[ 'RBGN',  'Bietingen',              8000965, 8.73891500, 47.7440170 ],
	[ 'EBIG',  'Bigge',                  8000966, 8.47525300, 51.3582790 ],
	[ 'SBDS',  'Bildstock',              8000967, 7.09434100, 49.3373250 ],
	[ 'TBIL',  'Bilfingen',              8000968, 8.62049800, 48.9486740 ],
	[ 'MBIN',  'Billenhausen',           8000969, 10.3581620, 48.2755620 ],
	[ 'EBB',   'Billerbeck',             8000970, 7.29748200, 51.9813410 ],
	[ 'RBIN',  'Binau',                  8000973, 9.08363100, 49.3725890 ],
	[ 'LBIF',  'Bindfelde',              8011190, 11.8980350, 52.5845610 ],
	[ 'NBI',   'Bindlach',               8000974, 11.6034420, 49.9802200 ],
	[ 'FBGK',  'Bingen(Rhein) Hbf',      8000039, 7.88426300, 49.9687290 ],
	[ 'FBGN',  'Bingen(Rhein) Stadt',    8000976, 7.90298500, 49.9697460 ],
	[ 'FBGG',  'Bingen-Gaulsheim',       8000975, 7.95098300, 49.9670730 ],
	[ 'EBIN',  'Binolen',                8000978, 7.85943300, 51.3719810 ],
	[ 'KBIF',  'Binsfeld',               8071257, 6.53334200, 50.7949700 ],
	[ 'WBIO',  'Binz LB',                8011193, 13.6099430, 54.3927840 ],
	[ 'RBZN',  'Binzen',                 8070323, 7.62104800, 47.6314090 ],
	[ 'RBCH',  'Birach',                 8007102, 8.08036600, 48.3495190 ],
	[ 'EBKB',  'Birkelbach',             8000983, 8.25286500, 51.0206940 ],
	[ 'RBRK',  'Birkenau',               8000984, 8.70835900, 49.5610390 ],
	[ 'FBBH',  'Birkenbringhausen',      8000985, 8.74725700, 51.0250450 ],
	[ 'TBIR',  'Birkenfeld(Enz)',        8000986, 8.64527800, 48.8739110 ],
	[ 'BBSH',  'Birkengrund',            8080170, 13.2719600, 52.3155630 ],
	[ 'LBIM',  'Birkenmoor',             8017003, 10.8763230, 51.6396550 ],
	[ 'BBIS',  'Birkenstein',            8070002, 13.6471870, 52.5156010 ],
	[ 'BBIW',  'Birkenwerder(b Berlin)', 8080190, 13.2887720, 52.6882490 ],
	[ 'UBKN',  'Birkungen',              8010048, 10.3307360, 51.3663120 ],
	[ 'SBRB',  'Birresborn',             8000989, 6.62888400, 50.1764110 ],
	[ 'DBH',   'Bischheim-Gersdorf',     8011199, 14.0458440, 51.2287460 ],
	[ 'DBW',   'Bischofswerda',          8010049, 14.1861440, 51.1255850 ],
	[ 'MBI',   'Bischofswiesen',         8000997, 12.9601410, 47.6518900 ],
	[ 'RBIS',  'Bischweier',             8000998, 8.27754300, 48.8321540 ],
	[ 'TBIS',  'Bisingen',               8000999, 8.92103500, 48.3127700 ],
	[ 'HBSS',  'Bissendorf',             8001000, 9.74819100, 52.5227050 ],
	[ 'SED',   'Bitburg-Erdorf',         8001828, 6.57095800, 49.9986850 ],
	[ 'TBIT',  'Bittelbronn',            8001002, 8.58943900, 48.4444040 ],
	[ 'LBT',   'Bitterfeld',             8010050, 12.3168500, 51.6228610 ],
	[ 'TBIF',  'Bitzfeld',               8001005, 9.45322200, 49.1872330 ],
	[ 'NBLA',  'Blaibach(Oberpf)',       8001003, 12.8079250, 49.1640280 ],
	[ 'MBLH',  'Blaichach(Allgäu)',     8001004, 10.2587960, 47.5437410 ],
	[ 'FBLK',  'Blankenbach',            8007282, 9.23006400, 50.0652060 ],
	[ 'WBL',   'Blankenberg(Meckl)',     8010051, 11.7152900, 53.7723050 ],
	[ 'KBLB',  'Blankenberg(Sieg)',      8001006, 7.34849900, 50.7684760 ],
	[ 'LBK',   'Blankenburg(Harz)',      8013439, 10.9611840, 51.7958240 ],
	[ 'BBF', 'Blankenfelde(Teltow-Fläming)', 8010053, 13.4159820, 52.3372130 ],
	[ 'UBM', 'Blankenheim(Sangerhausen)',     8010054, 11.4260040, 51.5027810 ],
	[ 'KBLH',  'Blankenheim(Wald)',        8001008, 6.59350400, 50.4418710 ],
	[ 'RBAN',  'Blankenloch',              8001009, 8.46472900, 49.0665280 ],
	[ 'WBLS',  'Blankensee(Meckl)',        8011205, 13.2629070, 53.4081740 ],
	[ 'UBN',   'Blankenstein(Saale)',      8011206, 11.6985490, 50.4015330 ],
	[ 'TBL',   'Blaubeuren',               8001013, 9.79197900, 48.4038150 ],
	[ 'TBLF',  'Blaufelden',               8001014, 9.96768000, 49.2962360 ],
	[ 'TBLS',  'Blaustein',                8001015, 9.91932600, 48.4145960 ],
	[ 'UBHA',  'Blechhammer(Thür)',       8011208, 11.2031560, 50.3968340 ],
	[ 'RBLB',  'Bleibach',                 8001017, 8.00477700, 48.1240910 ],
	[ 'FBLH',  'Bleichenbach(Oberh)',      8001018, 9.05158200, 50.3203340 ],
	[ 'UBD',   'Bleicherode Ost',          8010055, 10.6088820, 51.4531750 ],
	[ 'KBLE',  'Blens',                    8007827, 6.48644200, 50.6602490 ],
	[ 'SBKL',  'Blieskastel-Lautzkirchen', 8001027, 7.25819100, 49.2491920 ],
	[ 'MBLM',  'Blindheim',                8001028, 10.6179330, 48.6450950 ],
	[ 'BBLU',  'Blumberg(b Berlin)',       8011211, 13.6117720, 52.6052340 ],
	[ 'BAHH',  'Blumberg-Rehhahn',         8011064, 13.5919480, 52.5966210 ],
	[ 'RRD',   'Blumberg-Riedöschingen',  8001029, 8.60754300, 47.8555410 ],
	[ 'RZS',   'Blumberg-Zollhaus',        8006669, 8.55584000, 47.8380590 ],
	[ 'DBLU',  'Blumenau',                 8011212, 13.2910140, 50.6712410 ],
	[ 'LBLG',  'Blumenberg',               8010056, 11.4570930, 52.0338060 ],
	[ 'WBLK',  'Blumenhagen',              8011213, 13.8720400, 53.5283290 ],
	[ 'EBKP',  'Blumenkamp',               8001030, 6.61311800, 51.6952170 ],
	[ 'WBMT',  'Blumenthal(Mark)',         8011214, 12.3340960, 53.0765160 ],
	[ 'LBD',   'Blönsdorf',               8011210, 12.8955680, 51.9554100 ],
	[ 'RBOB',  'Bobenheim',                8001032, 8.35032000, 49.5881390 ],
	[ 'MBOB',  'Bobingen',                 8001033, 10.8378910, 48.2663730 ],
	[ 'WBO',   'Bobitz',                   8011215, 11.3628000, 53.8045340 ],
	[ 'FBST',  'Bobstadt',                 8001034, 8.45178600, 49.6632510 ],
	[ 'EBCH',  'Bocholt',                  8000040, 6.62042600, 51.8341200 ],
	[ 'EBO',   'Bochum Hbf',               8000041, 7.22327500, 51.4786090 ],
	[ 'EBOW',  'Bochum West',              8006711, 7.21122300, 51.4814590 ],
	[ 'EBDA',  'Bochum-Dahlhausen',        8001038, 7.14084200, 51.4263580 ],
	[ 'EBOE',  'Bochum-Ehrenfeld',         8001039, 7.20915000, 51.4721170 ],
	[ 'EBOH',  'Bochum-Hamme',             8006710, 7.20093500, 51.4914860 ],
	[ 'EBP',   'Bochum-Langendreer',       8000358, 7.32364500, 51.4779920 ],
	[ 'EBLA',  'Bochum-Langendreer',       8000358, 7.32364500, 51.4779920 ],
	[ 'EBW',   'Bochum-Langendreer West',  8004474, 7.30432700, 51.4780320 ],
	[ 'EBGZ',  'Bochum-Riemke',            8001035, 7.20527500, 51.5178000 ],
	[ 'RBOK',  'Bockenheim-Kindenheim',    8001043, 8.18825400, 49.6068720 ],
	[ 'EBCK',  'Bockum-Hövel',            8001045, 7.77454700, 51.7048090 ],
	[ 'MBOD',  'Bodelsberg',               8001046, 10.4110920, 47.6781130 ],
	[ 'TBOD',  'Bodelshausen',             8001047, 8.99060100, 48.3833690 ],
	[ 'HBBU',  'Bodenburg',                8001048, 10.0013300, 52.0311210 ],
	[ 'HBOF',  'Bodenfelde',               8001050, 9.56166700, 51.6372090 ],
	[ 'FBOD',  'Bodenheim',                8000359, 8.31249100, 49.9295850 ],
	[ 'NBMA',  'Bodenmais',                8001051, 13.1010780, 49.0704190 ],
	[ 'UBOD',  'Bodenrode',                8011219, 10.2085500, 51.3935280 ],
	[ 'NBOE',  'Bodenwöhr Nord',          8001054, 12.3259480, 49.2783810 ],
	[ 'NBO',   'Bogen',                    8001069, 12.6861410, 48.9105940 ],
	[ 'HBOM',  'Bohmte',                   8001071, 8.30752500, 52.3616320 ],
	[ 'KBOI',  'Boisheim',                 8001072, 6.27459100, 51.2743230 ],
	[ 'WBZ',   'Boizenburg(Elbe)',         8011230, 10.7544810, 53.3780690 ],
	[ 'ABHT',  'Bokholt',                  8007067, 9.71684300, 53.7861070 ],
	[ 'TBD',   'Bondorf(b Herrenberg)',    8001080, 8.82766200, 48.5235520 ],
	[ 'KBBS',  'Bonn Brühler Str.',       8070741, 7.06890800, 50.7403170 ],
	[ 'KB',    'Bonn Hbf',                 8000044, 7.09713600, 50.7320080 ],
	[ 'KB  T', 'Bonn Hbf (tief)',          8098044, 7.09802300, 50.7321570 ],
	[ 'KBHH',  'Bonn Helmholtzstraße',    8001081, 7.05261500, 50.7218440 ],
	[
		'KB  B', 'Bonn Heussallee/Museumsmeile', 8070026, 7.12060100,
		50.7167320
	],
	[ 'KB  A', 'Bonn Konrad-Adenauer-Platz', 8070075, 7.11765600, 50.7393050 ],
	[ 'KB  H', 'Bonn Stadthaus',             8070107, 7.09526300, 50.7365930 ],
	[ 'KBBG',  'Bonn-Bad Godesberg',         8001082, 7.15955500, 50.6839270 ],
	[
		'KBBGS', 'Bonn-Bad Godesberg Stadthalle',
		8070231, 7.15855600,
		50.6805100
	],
	[ 'KBB',   'Bonn-Beuel',               8001083, 7.12765700, 50.7384760 ],
	[ 'KBD',   'Bonn-Duisdorf',            8001084, 7.04254800, 50.7164750 ],
	[ 'KBEC',  'Bonn-Endenich Nord',       8001088, 7.06221100, 50.7355900 ],
	[ 'KBM',   'Bonn-Mehlem',              8001085, 7.18134200, 50.6691530 ],
	[ 'KBO',   'Bonn-Oberkassel',          8001086, 7.15930000, 50.7150730 ],
	[ 'KBO M', 'Bonn-Oberkassel Mitte',    8070754, 7.17106000, 50.7126040 ],
	[ 'PQBR',  'Bonn-Ramersdorf',          8070027, 7.15526200, 50.7222790 ],
	[ 'HBHB',  'Bookholzberg',             8001089, 8.53255600, 53.0991120 ],
	[ 'ABOS',  'Boostedt',                 8007061, 10.0162000, 54.0177380 ],
	[ 'TBP',   'Bopfingen',                8001090, 10.3517070, 48.8551530 ],
	[ 'KBOP',  'Boppard Hbf',              8000045, 7.58610200, 50.2314130 ],
	[ 'KBPS',  'Boppard Süd',             8000324, 7.59552100, 50.2301970 ],
	[ 'KSAL',  'Boppard-Bad Salzig',       8000742, 7.63548100, 50.2052510 ],
	[ 'KBZ',   'Boppard-Buchholz',         8001235, 7.55487600, 50.2108020 ],
	[ 'KFLH',  'Boppard-Fleckertshöhe',   8002004, 7.57788900, 50.1979250 ],
	[ 'KHIR',  'Boppard-Hirzenach',        8002861, 7.64843600, 50.1750750 ],
	[ 'ABRD',  'Bordesholm',               8001092, 10.0437110, 54.1743730 ],
	[ 'EBOR',  'Borgeln',                  8001093, 8.03203300, 51.5982650 ],
	[ 'EBHS',  'Borgholzhausen',           8001095, 8.26657900, 52.0852290 ],
	[ 'BBOR',  'Borgsdorf',                8080200, 13.2767500, 52.7152520 ],
	[ 'EBOK',  'Bork(Westf)',              8001097, 7.45630800, 51.6693300 ],
	[ 'FBOK',  'Borken(Hess)',             8001098, 9.27700000, 51.0506840 ],
	[ 'EBK',   'Borken(Westf)',            8000346, 6.86527900, 51.8489620 ],
	[ 'BBK',   'Borkheide',                8011238, 12.8544130, 52.2307750 ],
	[ 'LBL',   'Borna(Leipzig)',           8011242, 12.4862910, 51.1179260 ],
	[ 'FBO',   'Borsdorf(Hess)',           8001104, 8.97522300, 50.4294100 ],
	[ 'LBOR',  'Borsdorf(Sachs)',          8010059, 12.5411650, 51.3457050 ],
	[ 'EBTH',  'Bottrop Hbf',              8000047, 6.93668400, 51.5094500 ],
	[ 'EBTHP', 'Bottrop Hbf',              8000047, 6.93668400, 51.5094500 ],
	[ 'EBTB',  'Bottrop-Boy',              8001107, 6.96772900, 51.5371630 ],
	[ 'EBTV',  'Bottrop-Vonderort',        8001108, 6.91229400, 51.5017280 ],
	[ 'SBO',   'Bous(Saar)',               8001110, 6.79263900, 49.2759790 ],
	[ 'TBOX',  'Boxberg-Wölchingen',      8001111, 9.64004800, 49.4855960 ],
	[ 'EBRB',  'Brachbach',                8001112, 7.94149200, 50.8219870 ],
	[ 'KBRC',  'Brachelen',                8001113, 6.23146300, 51.0078240 ],
	[ 'EBWE',  'Brackwede',                8000048, 8.49842600, 51.9973780 ],
	[ 'WBRH',  'Brahlstorf',               8011248, 10.9519920, 53.3644210 ],
	[ 'HBKE',  'Brake(Unterweser)',        8001120, 8.48135000, 53.3288170 ],
	[ 'EBRA',  'Brake(b Bielefeld)',       8001118, 8.60491400, 52.0696530 ],
	[ 'EBRAH', 'Brake(b Bielefeld)',       8001118, 8.60491400, 52.0696530 ],
	[ 'HBKH',  'Brakel(Höxter)',          8001121, 9.18320000, 51.7121650 ],
	[ 'HBRM',  'Bramsche',                 8001122, 7.97500700, 52.4108790 ],
	[ 'HBRA',  'Bramstedt(b Syke)',        8001123, 8.78602400, 52.8716110 ],
	[ 'BBRA',  'Brand Tropical Islands',   8011250, 13.7214900, 52.0299530 ],
	[ 'LBA',   'Brandenburg Altstadt',     8011252, 12.5303470, 52.4117000 ],
	[ 'LB',    'Brandenburg Hbf',          8010060, 12.5661380, 52.4005540 ],
	[ 'FBRD',  'Brandoberndorf',           8001126, 8.49381600, 50.4316210 ],
	[ 'MBB',   'Brannenburg',              8001129, 12.1064640, 47.7413540 ],
	[ 'KBRB',  'Braubach',                 8001130, 7.64318700, 50.2741400 ],
	[ 'LBS',   'Braunsbedra',              8011255, 11.8845940, 51.2887810 ],
	[ 'LBSO',  'Braunsbedra Ost',          8011256, 11.9025490, 51.2899160 ],
	[ 'HBS',   'Braunschweig Hbf',         8000049, 10.5402950, 52.2522180 ],
	[ 'HGLI',  'Braunschweig-Gliesmarode', 8001134, 10.5514990, 52.2757210 ],
	[ 'DBDL',  'Braunsdorf-Lichtenwalde',  8011257, 13.0118540, 50.8797760 ],
	[ 'WBDN',  'Breddin',                  8011258, 12.2242160, 52.8860470 ],
	[ 'EBDL',  'Bredelar',                 8001137, 8.77656600, 51.4191700 ],
	[ 'ABRB',  'Bredenbek',                8001136, 9.86700400, 54.3151120 ],
	[ 'ABST',  'Bredstedt',                8001139, 8.97033600, 54.6211660 ],
	[ 'LBN',   'Brehna',                   8011260, 12.2221630, 51.5544570 ],
	[ 'KBRN',  'Breinig',                  8079063, 6.21404000, 50.7311210 ],
	[ 'RBRS',  'Breisach',                 8001143, 7.58935000, 48.0269180 ],
	[ 'DBRE',  'Breitenbrunn(Erzg)',       8011263, 12.7460530, 50.4770810 ],
	[ 'MBRN',  'Breitenbrunn(Schwab)',     8001147, 10.4085050, 48.1385860 ],
	[ 'NBRE',  'Breitendiel',              8001148, 9.22505200, 49.6913820 ],
	[ 'DBTD',  'Breitendorf',              8011264, 14.6227260, 51.1386520 ],
	[ 'NBG',   'Breitengüßbach',         8001149, 10.8871350, 49.9668300 ],
	[
		'KBRS',  'Breitscheidt(Altenkirchen, Ww)',
		8001153, 7.66148600,
		50.7484350
	],
	[ 'UBRT', 'Breitungen(Werra)',            8011265, 10.3222300, 50.7524750 ],
	[ 'HB',   'Bremen Hbf',                   8000050, 8.81383400, 53.0834810 ],
	[ 'HBKO', 'Bremen Kreinsloger',           8007896, 8.55784600, 53.1887820 ],
	[ 'HBMU', 'Bremen Mühlenstraße',        8007895, 8.57134000, 53.1852100 ],
	[ 'HBN',  'Bremen Neustadt',              8001155, 8.78580800, 53.0757820 ],
	[ 'HBTU', 'Bremen Turnerstraße',         8007897, 8.54540300, 53.1932370 ],
	[ 'HBRN', 'Bremen-Aumund',                8007892, 8.61733800, 53.1852260 ],
	[ 'HBRB', 'Bremen-Blumenthal',            8007894, 8.58118000, 53.1836350 ],
	[ 'HBB',  'Bremen-Burg',                  8001156, 8.70477300, 53.1602880 ],
	[ 'HBRF', 'Bremen-Farge',                 8007898, 8.51660200, 53.2052000 ],
	[ 'HBHM', 'Bremen-Hemelingen',            8001157, 8.88675900, 53.0545720 ],
	[ 'HBL',  'Bremen-Lesum',                 8001159, 8.68615200, 53.1707160 ],
	[ 'HBM',  'Bremen-Mahndorf',              8001160, 8.94462700, 53.0397620 ],
	[ 'HBON', 'Bremen-Oberneuland',           8001161, 8.93851100, 53.0870380 ],
	[ 'HBOS', 'Bremen-Oslebshausen',          8001162, 8.74080100, 53.1352980 ],
	[ 'HBSC', 'Bremen-Schönebeck',           8001163, 8.64948100, 53.1728000 ],
	[ 'HBSB', 'Bremen-Sebaldsbrück',         8001164, 8.88738300, 53.0613550 ],
	[ 'HBMG', 'Bremen-St Magnus',             8001165, 8.66973200, 53.1715800 ],
	[ 'HBV',  'Bremen-Vegesack',              8001166, 8.62996800, 53.1697160 ],
	[ 'HBWA', 'Bremen-Walle',                 8001167, 8.78624100, 53.1037920 ],
	[ 'HBH',  'Bremerhaven Hbf',              8000051, 8.59955500, 53.5349120 ],
	[ 'HBHL', 'Bremerhaven-Lehe',             8001168, 8.60065700, 53.5663240 ],
	[ 'HBWU', 'Bremerhaven-Wulsdorf',         8001170, 8.61193400, 53.5085960 ],
	[ 'ABV',  'Bremervörde',                 8007800, 9.14025100, 53.4829540 ],
	[ 'KBK',  'Brenk',                        8071651, 7.16888800, 50.4324420 ],
	[ 'AAE',  'Brest-Aspe',                   8007841, 9.38234200, 53.4605870 ],
	[ 'UBZ',  'Breternitz',                   8011267, 11.4058630, 50.6163110 ],
	[ 'UBR',  'Bretleben',                    8010061, 11.2408390, 51.3407430 ],
	[ 'RBT',  'Bretten',                      8000053, 8.69344800, 49.0369000 ],
	[ 'RBTK', 'Bretten Kupferhälde',         8070093, 8.72367900, 49.0369870 ],
	[ 'RBTN', 'Bretten Rechberg',             8001138, 8.70161400, 49.0325960 ],
	[ 'RBTS', 'Bretten Schulzentrum',         8001144, 8.71819600, 49.0318380 ],
	[ 'RBTM', 'Bretten Stadtmitte',           8001152, 8.70280900, 49.0339930 ],
	[ 'RBTW', 'Bretten Wannenweg',            8079060, 8.70912200, 49.0304660 ],
	[ 'RBTI', 'Bretten-Ruit',                 8001131, 8.72205800, 49.0094620 ],
	[ 'HBRT', 'Brettorf',                     8001176, 8.44697000, 52.9671270 ],
	[ 'SBRH', 'Bretzenheim(Nahe)',            8001177, 7.89869200, 49.8745870 ],
	[ 'TBZ',  'Bretzfeld',                    8001178, 9.44030200, 49.1727410 ],
	[ 'KBRY', 'Breyell',                      8001180, 6.24117400, 51.2946150 ],
	[ 'BBRI', 'Brieselang',                   8013472, 13.0013940, 52.5825490 ],
	[ 'BBSN', 'Briesen(Mark)',                8011269, 14.2806350, 52.3465300 ],
	[ 'RMBK', 'Brigachtal Kirchdorf',         8003339, 8.46780700, 48.0143430 ],
	[ 'RKLN', 'Brigachtal Klengen',           8003336, 8.46577900, 48.0073660 ],
	[ 'EBRS', 'Brilon Stadt',                 8001182, 8.57528700, 51.3990600 ],
	[ 'EBRW', 'Brilon Wald',                  8000054, 8.57607300, 51.3491590 ],
	[ 'WBR',  'Britz',                        8010064, 13.8211060, 52.8732680 ],
	[ 'LBRO', 'Brocken',                      8017004, 10.6185590, 51.7995580 ],
	[ 'HBRO', 'Brockhöfe',                   8001185, 10.2584990, 53.0021170 ],
	[ 'WBTF', 'Broderstorf',                  8011270, 12.2627630, 54.0789160 ],
	[ 'KBRO', 'Brohl',                        8001186, 7.33263900, 50.4814290 ],
	[ 'ABRS', 'Brokstedt',                    8001190, 9.82380600, 53.9900860 ],
	[ 'FBB',  'Bruchenbrücken',              8001196, 8.78840200, 50.3019650 ],
	[ 'RBRH', 'Bruchhausen(b Ettlingen)',     8001198, 8.37397500, 48.9239920 ],
	[ 'FBK',  'Bruchköbel',                  8001199, 8.91929300, 50.1861890 ],
	[ 'SBUM', 'Bruchmühlbach-Miesau',        8001200, 7.44397900, 49.3853430 ],
	[ 'HBUE', 'Bruchmühlen',                 8001201, 8.44863600, 52.2045980 ],
	[ 'RBR',  'Bruchsal',                     8000055, 8.58964900, 49.1246220 ],
	[ 'RBMT', 'Bruchsal Am Mantel',           8001214, 8.56327000, 49.1411810 ],
	[ 'RBRZ', 'Bruchsal Bildungszentrum',     8001197, 8.57450700, 49.1103460 ],
	[ 'RBRF', 'Bruchsal Schlachthof',         8070009, 8.60971600, 49.1189280 ],
	[ 'RBRD', 'Bruchsal Schloßgarten',       8085001, 8.59406000, 49.1314380 ],
	[ 'RBRP', 'Bruchsal Sportzentrum',        8001212, 8.58994100, 49.1354430 ],
	[ 'RBRC', 'Bruchsal Stegwiesen',          8085002, 8.59819900, 49.1364350 ],
	[ 'RBRE', 'Bruchsal Tunnelstr.',          8070008, 8.59437800, 49.1195490 ],
	[ 'SBRW', 'Bruchweiler',                  8079080, 7.80195700, 49.1147040 ],
	[ 'MBR',  'Bruckberg',                    8001203, 11.9977820, 48.5159790 ],
	[ 'TBRU', 'Brucken',                      8001205, 9.45306100, 48.5739180 ],
	[ 'MBRM', 'Bruckmühl',                   8001207, 11.9152690, 47.8808740 ],
	[ 'LBRP', 'Brunau-Packebusch',            8011277, 11.4845860, 52.7512740 ],
	[ 'RBRN', 'Bräunlingen Bahnhof',         8001119, 8.45710400, 47.9318750 ],
	[ 'RBRI', 'Bräunlingen Industriegebiet', 8070999, 8.47081200, 47.9283370 ],
	[ 'TPB',  'Brötzingen Mitte',            8004799, 8.66702700, 48.8894640 ],
	[ 'TPBS', 'Brötzingen Sandweg',          8070274, 8.66234700, 48.8858800 ],
	[ 'TPBW', 'Brötzingen Wohnlichstraße',  8070275, 8.65398700, 48.8820770 ],
	[ 'BBRK', 'Brück(Mark)',                 8011271, 12.7584670, 52.1867950 ],
	[ 'WBGE', 'Brügge(Prign)',               8011273, 12.2292080, 53.2562870 ],
	[ 'EBRU', 'Brügge(Westf)',               8001213, 7.57108600, 51.2079200 ],
	[ 'KBR',  'Brühl',                       8001215, 6.91271800, 50.8292490 ],
	[ 'KBR P', 'Brühl',                   8001215, 6.91271800, 50.8292490 ],
	[ 'KKIE',  'Brühl-Kierberg',          8003252, 6.88837500, 50.8381970 ],
	[ 'SBB',   'Bubach',                   8001221, 6.94821000, 49.4110240 ],
	[ 'KBUB',  'Bubenheim',                8071229, 6.55260000, 50.7780150 ],
	[ 'NBTH',  'Bubenreuth',               8001223, 11.0119940, 49.6295420 ],
	[ 'NBM',   'Buchbrunn-Mainstockheim',  8001225, 10.1451790, 49.7632840 ],
	[ 'RBUO',  'Buchen Ost',               8001226, 9.33213700, 49.5191520 ],
	[ 'RBUN',  'Buchen(Odenw)',            8001227, 9.32717900, 49.5235290 ],
	[ 'FBNU',  'Buchenau(Lahn)',           8001228, 8.60052500, 50.8705440 ],
	[ 'MBAU',  'Buchenau(Oberbay)',        8001229, 11.2244970, 48.1602770 ],
	[ 'MBHA',  'Buchenhain',               8001231, 11.4974420, 48.0312550 ],
	[ 'WBUH',  'Buchenhorst',              8011281, 12.7126820, 54.2682110 ],
	[ 'RBU',   'Buchholz(Baden)',          8001234, 7.91516600, 48.0835810 ],
	[ 'ABLZ',  'Buchholz(Nordheide)',      8000056, 9.87626600, 53.3246830 ],
	[ 'BBUZ',  'Buchholz(Zauche)',         8011282, 12.9224160, 52.1675740 ],
	[ 'MBU',   'Buchloe',                  8000057, 10.7162170, 48.0337230 ],
	[ 'BBUW',  'Buckow(Beeskow)',          8011284, 14.1695070, 52.1881790 ],
	[ 'WBHN',  'Buddenhagen',              8011286, 13.6822800, 54.0015610 ],
	[ 'FBUD',  'Budenheim',                8001237, 8.17406200, 50.0268350 ],
	[ 'UBF',   'Bufleben',                 8010067, 10.7090570, 50.9976810 ],
	[ 'RBGG',  'Buggingen',                8001262, 7.62816100, 47.8552540 ],
	[ 'KBUH',  'Buir',                     8001264, 6.57451400, 50.8624010 ],
	[ 'EBUD',  'Buldern',                  8001266, 7.37047900, 51.8630540 ],
	[ 'SBY',   'Bullay(DB)',               8001267, 7.13458400, 50.0544600 ],
	[ 'SBTR',  'Bundenthal-Rumbach',       8079087, 7.80615200, 49.1023530 ],
	[ 'SSHI',  'Burbach Mitte',            8001302, 6.94493200, 49.2436110 ],
	[ 'EBUR',  'Burbach(Kr Siegen)',       8001268, 8.07780800, 50.7489650 ],
	[ 'WBSG',  'Burg Stargard(Meckl)',     8011293, 13.3032250, 53.4995900 ],
	[ 'FBUN',  'Burg(Dillkr) Nord',        8001271, 8.30768600, 50.6998840 ],
	[ 'ABR',   'Burg(Dithm)',              8001273, 9.25008700, 54.0079670 ],
	[ 'LBU',   'Burg(Magdeburg)',          8011294, 11.8403560, 52.2744060 ],
	[ 'FBNG',  'Burg-u. Nieder Gemünden', 8000061, 9.04760400, 50.6911130 ],
	[ 'MBGU',  'Burgau(Schwab)',           8001276, 10.4270120, 48.4247970 ],
	[ 'NBUM',  'Burgbernheim',             8001277, 10.3202210, 49.4543220 ],
	[ 'NBUW',  'Burgbernheim-Wildbad',     8001278, 10.3123170, 49.4432940 ],
	[ 'HBGD',  'Burgdorf',                 8001279, 10.0028370, 52.4487080 ],
	[ 'FBUH',  'Burghaun(Hünfeld)',       8001283, 9.72795300, 50.7005500 ],
	[ 'MBUH',  'Burghausen',               8001284, 12.8281820, 48.1742000 ],
	[ 'MBGH',  'Burgheim',                 8001285, 11.0269840, 48.7010500 ],
	[ 'FBGH',  'Burgholzhausen v d H',     8001287, 8.67710600, 50.2577930 ],
	[ 'LBGK',  'Burgkemnitz',              8011296, 12.4071670, 51.6888180 ],
	[ 'MBGK',  'Burgkirchen',              8001288, 12.7277830, 48.1669080 ],
	[ 'NBK',   'Burgkunstadt',             8001289, 11.2427230, 50.1376570 ],
	[ 'NBUR',  'Burglauer',                8001290, 10.1844410, 50.2743400 ],
	[ 'NBN',   'Burgsinn',                 8001293, 9.65606700, 50.1503170 ],
	[ 'TBU',   'Burgstall(Murr)',          8001296, 9.36993200, 48.9286470 ],
	[ 'DBU',   'Burgstädt',               8011297, 12.8127070, 50.9158170 ],
	[ 'NBUT',  'Burgthann',                8001297, 11.3093070, 49.3424740 ],
	[ 'TBUW',  'Burgweiler',               8001281, 9.34380500, 47.9227650 ],
	[ 'HBUR',  'Burhafe(Ostfriesl)',       8001301, 7.71107400, 53.6065570 ],
	[ 'DBWD',  'Burkhardswalde-Maxen',     8011298, 13.8388400, 50.9254020 ],
	[ 'DBUF',  'Burkhardtsdorf',           8011299, 12.9321370, 50.7331960 ],
	[ 'DBUM',  'Burkhardtsdorf Mitte',     8011303, 12.9162760, 50.7329370 ],
	[ 'RBBN',  'Burkheim-Bischoffingen',   8007289, 7.61176600, 48.1040060 ],
	[ 'TBLD',  'Burladingen',              8007226, 9.11305700, 48.2900550 ],
	[ 'TBLW',  'Burladingen West',         8070022, 9.09929200, 48.2922710 ],
	[ 'LBOW',  'Buschow',                  8011302, 12.6289960, 52.5922030 ],
	[ 'RBUS',  'Busenbach',                8007000, 8.45056300, 48.9293110 ],
	[ 'SBNS',  'Busenberg-Schindhard',     8079118, 7.79970300, 49.1388680 ],
	[ 'NBT',   'Buttenheim',               8001310, 11.0134940, 49.7996670 ],
	[ 'UBU',   'Buttstädt',               8011304, 11.4184120, 51.1269950 ],
	[ 'FBZ',   'Butzbach',                 8001312, 8.66951700, 50.4311560 ],
	[ 'ABX',   'Buxtehude',                8001315, 9.68831400, 53.4704910 ],
	[ 'DBJ',   'Bärenhecke-Johnsbach',    8011091, 13.7720210, 50.8271630 ],
	[ 'BBKL',  'Bärenklau',               8011093, 13.1435260, 52.7040430 ],
	[ 'DBS',   'Bärenstein(Annaberg)',    8011094, 13.0299410, 50.5076030 ],
	[
		'DBAG', 'Bärenstein(b Glashütte, Sachs)',
		8011095, 13.7947280, 50.8097280
	],
	[ 'DBAE',  'Bärnsdorf',               8011096, 13.7207400, 51.1667670 ],
	[ 'MBHM',  'Bäumenheim',              8000778, 10.8099720, 48.6803330 ],
	[ 'TBB',   'Böbingen(Rems)',          8005979, 9.91280700, 48.8224390 ],
	[ 'TBO',   'Böblingen',               8001055, 9.00412800, 48.6877580 ],
	[ 'TBO T', 'Böblingen Danziger Str',  8085005, 8.99778500, 48.6787830 ],
	[ 'TBO H', 'Böblingen Heusteigstr',   8085007, 9.02577100, 48.6756330 ],
	[ 'TBOS',  'Böblingen Südbf',        8085006, 9.01050900, 48.6772360 ],
	[ 'TBO Z', 'Böblingen Zimmerschlag',  8085008, 9.03501500, 48.6707830 ],
	[ 'NBOB',  'Böbrach',                 8070667, 13.0145040, 49.0529940 ],
	[ 'TBCS',  'Böckingen Sonnenbrunnen', 8070159, 9.19119800, 49.1406550 ],
	[ 'TBCW',  'Böckingen West',          8070158, 9.16609300, 49.1393190 ],
	[ 'RBGH',  'Bödigheim',               8001056, 9.31720700, 49.4759290 ],
	[ 'RBOE',  'Böhl-Iggelheim',          8001057, 8.30360200, 49.3798310 ],
	[ 'LBWE',  'Böhlen Werke',            8011222, 12.3840240, 51.1847020 ],
	[ 'LBO',   'Böhlen(Leipzig)',         8013471, 12.3819910, 51.2030370 ],
	[ 'NBHF',  'Böhmhof',                 8001058, 13.1108800, 49.0521010 ],
	[ 'RBER',  'Böhringen-Rickelshausen', 8001059, 8.92665100, 47.7487320 ],
	[ 'WBOE',  'Bölzke',                  8011225, 12.2696150, 53.1073820 ],
	[ 'EBEO',  'Bönen',                   8001061, 7.75729600, 51.5980150 ],
	[ 'ABNS',  'Bönningstedt',            8007047, 9.91024300, 53.6633950 ],
	[ 'LBOK',  'Börnecke(Harz)',          8011226, 10.9957590, 51.8196800 ],
	[ 'HBSM',  'Börßum',                 8001063, 10.5689350, 52.0604630 ],
	[ 'LBOE',  'Bösdorf(Sachs-Anh)',      8011228, 11.0641490, 52.4220990 ],
	[ 'EBSL',  'Bösensell',               8001065, 7.48768700, 51.9070300 ],
	[ 'EBSP',  'Bösperde',                8001066, 7.77423300, 51.4589400 ],
	[ 'RBTZ',  'Bötzingen',               8007296, 7.72161600, 48.0701740 ],
	[ 'RBTU',  'Bötzingen Mühle',        8007297, 7.72793100, 48.0755520 ],
	[ 'ABCH',  'Büchen',                  8000058, 10.6232980, 53.4749720 ],
	[ 'NBUE',  'Büchenbach',              8001242, 11.0740340, 49.2677440 ],
	[ 'FBDH',  'Büches-Düdelsheim',      8001244, 9.06675100, 50.2973700 ],
	[ 'HBKB',  'Bückeburg',               8001245, 9.04779600, 52.2676370 ],
	[ 'FBDG',  'Büdingen(Oberhess)',      8001250, 9.10259800, 50.2888700 ],
	[ 'FBDW',  'Büdingen(Westerw)',       8001249, 7.89590100, 50.6247470 ],
	[ 'RBUE',  'Bühl(Baden)',             8001252, 8.12929900, 48.6966760 ],
	[ 'LBZG',  'Bülzig',                  8011290, 12.7527150, 51.8948940 ],
	[ 'HBDE',  'Bünde(Westf)',            8000059, 8.57387600, 52.2020750 ],
	[ 'FBRG',  'Bürgeln',                 8001256, 8.81719400, 50.8537500 ],
	[ 'FBUE',  'Bürstadt',                8000360, 8.45907200, 49.6451250 ],
	[ 'FBUP',  'Bürstadt',                8000360, 8.45907200, 49.6451250 ],
	[ 'ABUS',  'Büsenbachtal',            8001258, 9.85859200, 53.2695950 ],
	[ 'ABSM',  'Büsum',                   8001259, 8.86711300, 54.1338220 ],
	[ 'KBUT',  'Büttgen',                 8001261, 6.60578500, 51.1972080 ],
	[ 'WB',    'Bützow',                  8010066, 11.9981940, 53.8371140 ],
	[ 'ACD',   'Cadenberge',               8001316, 9.05816300, 53.7680710 ],
	[ 'NCA',   'Cadolzburg',               8001317, 10.8636110, 49.4606490 ],
	[ 'DCDF',  'Cainsdorf',                8011305, 12.4965650, 50.6865590 ],
	[ 'BC',    'Calau(Nl)',                8010069, 13.9798200, 51.7381180 ],
	[ 'LCBO',  'Calbe(Saale) Ost',         8010070, 11.8105270, 51.9206930 ],
	[ 'LCBS',  'Calbe(Saale) Stadt',       8011323, 11.7763420, 51.9138790 ],
	[ 'LCBW',  'Calbe(Saale) West',        8010071, 11.7587830, 51.9056930 ],
	[ 'HCAL',  'Calberlah',                8001318, 10.6249140, 52.4275590 ],
	[ 'FCLD',  'Caldern',                  8001319, 8.67024400, 50.8529700 ],
	[ 'TCA',   'Calmbach Bahnhof',         8001320, 8.57113200, 48.7764810 ],
	[ 'TCAS',  'Calmbach Süd',            8070280, 8.56642400, 48.7733960 ],
	[ 'TCW',   'Calw',                     8000063, 8.74185400, 48.7146820 ],
	[ 'UCB',   'Camburg(Saale)',           8013474, 11.7046800, 51.0508570 ],
	[ 'WCA',   'Cammin(Meckl)',            8011307, 13.2996450, 53.4390350 ],
	[ 'ECP',   'Capelle(Westf)',           8001323, 7.61108000, 51.7352680 ],
	[ 'BSIS',  'Caputh Schwielowsee',      8012957, 12.9803680, 52.3409760 ],
	[ 'BCAP',  'Caputh-Geltow',            8011308, 12.9844060, 52.3502950 ],
	[ 'WCW',   'Casekow',                  8011311, 14.2081870, 53.2136140 ],
	[ 'ECA',   'Castrop-Rauxel Hbf',       8001327, 7.30398000, 51.5735260 ],
	[ 'ECAS',  'Castrop-Rauxel Süd',      8001328, 7.31018600, 51.5503000 ],
	[ 'ECASP', 'Castrop-Rauxel Süd',      8001328, 7.31018600, 51.5503000 ],
	[ 'ECME',  'Castrop-Rauxel-Merklinde', 8001329, 7.32431400, 51.5279320 ],
	[ 'HC',    'Celle',                    8000064, 10.0627060, 52.6211750 ],
	[ 'NCH',   'Cham(Oberpf)',             8001330, 12.6568320, 49.2218690 ],
	[ 'NCHA',  'Chamerau',                 8001331, 12.7452580, 49.1967180 ],
	[
		'DCACC', 'Chemnitz Alt Chemnitz Center', 8017400, 12.9179360,
		50.7963740
	],
	[ 'DCAN', 'Chemnitz Annenstraße', 8071804, 12.9229330, 50.8287490 ],
	[
		'DC  E', 'Chemnitz Brückenstraße/Freie Presse',
		8017476, 12.9247020, 50.8347520
	],
	[
		'DCACE', 'Chemnitz Erdmannsdorfer Straße',
		8017402, 12.9119690,
		50.8112110
	],
	[ 'DCE',   'Chemnitz Erfenschlag',      8011975, 12.9501840, 50.7876030 ],
	[ 'DC  F', 'Chemnitz Friedrichstraße', 8071174, 12.9193670, 50.7728530 ],
	[
		'DCS G', 'Chemnitz Gustav-Freytag-Straße',
		8017403, 12.9202660,
		50.8255960
	],
	[ 'DC', 'Chemnitz Hbf', 8010184, 12.9308770, 50.8396960 ],
	[
		'DC  O', 'Chemnitz Hbf (Bahnhofstraße)',
		8071738, 12.9291890,
		50.8382220
	],
	[ 'DCKI',  'Chemnitz Kinderwaldstätte', 8011970, 12.9535680, 50.8842110 ],
	[ 'DCM',   'Chemnitz Mitte',             8011971, 12.9125870, 50.8266280 ],
	[ 'DC  M', 'Chemnitz Moritzhof',         8017407, 12.9199310, 50.8297600 ],
	[ 'DCOM',  'Chemnitz Omnibusbahnhof',    8089295, 12.9263910, 50.8408290 ],
	[
		'DCHAR', 'Chemnitz Riemenschneiderstraße',
		8017401, 12.9254720,
		50.7853840
	],
	[ 'DC  R', 'Chemnitz Roter Turm',      8017410, 12.9230740, 50.8345090 ],
	[ 'DCACR', 'Chemnitz Rösslerstraße', 8017409, 12.9141200, 50.8168850 ],
	[ 'DCACS', 'Chemnitz Scheffelstraße', 8017411, 12.9113370, 50.8022790 ],
	[
		'DCZWS', 'Chemnitz Schneeberger Straße',
		8017413, 12.9224450,
		50.7940340
	],
	[ 'DCACA', 'Chemnitz Schule Altchemnitz', 8017414, 12.9131040, 50.7989230 ],
	[ 'DC  B', 'Chemnitz Stefan-Heym-Platz',  8071816, 12.9251690, 50.8331960 ],
	[ 'DCD',   'Chemnitz Süd',               8010185, 12.9268230, 50.8237460 ],
	[ 'DCS',   'Chemnitz Süd',               8010185, 12.9268230, 50.8237460 ],
	[ 'DC  T', 'Chemnitz Theaterplatz',       8017416, 12.9257270, 50.8373110 ],
	[ 'DCACT', 'Chemnitz Treffurthstraße',   8017417, 12.9155880, 50.8198260 ],
	[ 'DCACU', 'Chemnitz Uhlestraße',        8017418, 12.9118520, 50.8060710 ],
	[ 'DC  Z', 'Chemnitz Zentralhaltestelle', 8017419, 12.9222640, 50.8316270 ],
	[ 'DCAC',  'Chemnitz-Altchemnitz',        8017420, 12.9260680, 50.7908040 ],
	[ 'DCBH',  'Chemnitz-Borna Hp',           8011974, 12.8944590, 50.8598670 ],
	[ 'DCBO',  'Chemnitz-Borna Hp',           8011974, 12.8944590, 50.8598670 ],
	[ 'DCHA',  'Chemnitz-Harthau',            8011977, 12.9240490, 50.7768660 ],
	[ 'DCHP',  'Chemnitz-Hilbersdorf',        8013450, 12.9538790, 50.8619340 ],
	[ 'DCRE',  'Chemnitz-Reichenhain',        8011978, 12.9358770, 50.7950770 ],
	[ 'DCC',   'Chemnitz-Schönau',           8011979, 12.8765000, 50.8180950 ],
	[ 'DCSI',  'Chemnitz-Siegmar',            8011980, 12.8425100, 50.8155610 ],
	[ 'WCOK',  'Chorin',                      8011314, 13.8697140, 52.9035400 ],
	[ 'ECOH',  'Clarholz',                    8001335, 8.20083500, 51.8984540 ],
	[ 'DCL',   'Clausnitz',                   8011315, 13.4986000, 50.7558420 ],
	[ 'HCLP',  'Cloppenburg',                 8001337, 8.05576300, 52.8439960 ],
	[ 'NC',    'Coburg',                      8001338, 10.9573700, 50.2630970 ],
	[ 'NCN',   'Coburg Nord',                 8001334, 10.9648250, 50.2716000 ],
	[ 'NCNS',  'Coburg-Neuses',               8001339, 10.9513610, 50.2780820 ],
	[ 'SCOC',  'Cochem(Mosel)',               8001340, 7.16673800, 50.1530920 ],
	[ 'ECFS',  'Coesfeld Schulzentrum',       8001343, 7.16583600, 51.9512690 ],
	[ 'ECMF',  'Coesfeld(Westf)',             8000066, 7.16388000, 51.9394310 ],
	[ 'NRF',   'Collenberg',                  8005028, 9.32971900, 49.7711210 ],
	[ 'SCN',   'Contwig',                     8001341, 7.42791600, 49.2452800 ],
	[ 'HCOP',  'Coppenbrügge',               8001342, 9.53758800, 52.1195210 ],
	[ 'BCO',   'Coschen',                     8011319, 14.7181670, 52.0198440 ],
	[ 'DCB',   'Cossebaude',                  8011320, 13.6315820, 51.0851430 ],
	[ 'LCW',   'Coswig(Anh)',                 8011322, 12.4576250, 51.8880020 ],
	[ 'DCW',   'Coswig(b Dresden)',           8010072, 13.5794140, 51.1228100 ],
	[ 'BCS',   'Cottbus',                     8010073, 14.3241620, 51.7509570 ],
	[ 'BMZD',  'Cottbus-Merzdorf',            8012341, 14.3666690, 51.7689100 ],
	[ 'BMZDN', 'Cottbus-Merzdorf',            8012341, 14.3666690, 51.7689100 ],
	[ 'BCSO',  'Cottbus-Sandow',              8011318, 14.3537040, 51.7551770 ],
	[ 'BWDF',  'Cottbus-Willmersdorf Nord',   8081688, 14.3769020, 51.8067360 ],
	[ 'TC',    'Crailsheim',                  8000067, 10.0643260, 49.1378720 ],
	[ 'DCR',   'Cranzahl',                    8010074, 12.9930280, 50.5112480 ],
	[ 'NCR',   'Creidlitz',                   8001347, 10.9822460, 50.2271740 ],
	[ 'NCRE',  'Creußen(Oberfr)',            8001348, 11.6284430, 49.8494700 ],
	[ 'DCU',   'Crimmitschau',                8011325, 12.3929860, 50.8150680 ],
	[ 'WCZ',   'Crivitz',                     8011326, 11.6450710, 53.5725180 ],
	[ 'UKSO',  'Crossen Ort',                 8011312, 11.9819000, 50.9747150 ],
	[ 'UKS',   'Crossen a d Elster',          8010196, 11.9840640, 50.9657300 ],
	[ 'DCN',   'Cunnertswalde',               8011331, 13.7055020, 51.1623660 ],
	[ 'UCF',   'Cursdorf',                    8011332, 11.1320220, 50.5718710 ],
	[ 'ACV',   'Cuxhaven',                    8001352, 8.70343100, 53.8609000 ],
	[ 'FCOE',  'Cölbe',                      8000065, 8.78736500, 50.8481590 ],
	[ 'EDAD',  'Daaden',                      8007077, 7.96364200, 50.7404690 ],
	[ 'BDAB',  'Dabendorf',                   8011334, 13.4372900, 52.2373320 ],
	[ 'MDA',   'Dachau Bahnhof',              8001354, 11.4442600, 48.2546520 ],
	[ 'MDAS',  'Dachau Stadt',                8001355, 11.4397610, 48.2666610 ],
	[ 'UDA',   'Dachrieden',                  8011335, 10.4431660, 51.2691870 ],
	[ 'UDW',   'Dachwig',                     8011336, 10.8496860, 51.0724360 ],
	[ 'ADBK',  'Dagebüll Kirche',            8077770, 8.72948500, 54.7302830 ],
	[ 'ADM',   'Dagebüll Mole',              8007769, 8.69098900, 54.7299090 ],
	[ 'EDHL',  'Dahl',                        8001357, 7.52789800, 51.3033770 ],
	[ 'EDAB',  'Dahlbruch',                   8001358, 8.05345600, 50.9704320 ],
	[ 'KDAM',  'Dahlem(Eifel)',               8001359, 6.55038200, 50.3857520 ],
	[ 'LDA',   'Dahlen(Sachs)',               8011339, 12.9842530, 51.3509720 ],
	[ 'ADL',   'Dahlenburg',                  8001360, 10.7088040, 53.1692660 ],
	[ 'EDAK',  'Dahlerbrück',                8001362, 7.51700100, 51.2518600 ],
	[ 'BDT',   'Dahlewitz',                   8011340, 13.4195790, 52.3266180 ],
	[ 'SDA',   'Dahn',                        8079085, 7.77128300, 49.1545560 ],
	[ 'SDAS',  'Dahn Süd',                   8079081, 7.77720800, 49.1485570 ],
	[ 'KDAL',  'Dalheim',                     8001365, 6.17820900, 51.1490080 ],
	[ 'RDL',   'Dallau',                      8001366, 9.18755000, 49.3880780 ],
	[ 'BDL',   'Dallgow-Döberitz',           8080260, 13.0590370, 52.5435540 ],
	[ 'ADB',   'Dannenberg Ost',              8001372, 11.1177340, 53.1049970 ],
	[ 'WDWE',  'Dannenwalde(Gransee)',        8011344, 13.1808010, 53.0797560 ],
	[ 'MDAR',  'Darching',                    8001373, 11.7777570, 47.8706510 ],
	[ 'LDAR',  'Darlingerode',                8011346, 10.7330370, 51.8490800 ],
	[ 'FD',    'Darmstadt Hbf',               8000068, 8.62963600, 49.8725030 ],
	[ 'FDN',   'Darmstadt Nord',              8001375, 8.65431100, 49.8921360 ],
	[ 'FDO',   'Darmstadt Ost',               8001376, 8.67386700, 49.8747430 ],
	[ 'FDS',   'Darmstadt Süd',              8001377, 8.63658600, 49.8554260 ],
	[ 'FDAL',  'Darmstadt TU-Lichtwiese',     8001386, 8.68752700, 49.8610450 ],
	[ 'FDA',   'Darmstadt-Arheilgen',         8001378, 8.64534300, 49.9130140 ],
	[ 'FDE',   'Darmstadt-Eberstadt',         8001379, 8.62582000, 49.8139220 ],
	[ 'FDK',   'Darmstadt-Kranichstein',      8001380, 8.67935900, 49.9068260 ],
	[ 'FWX',   'Darmstadt-Wixhausen',         8006528, 8.64775100, 49.9302480 ],
	[ 'MDAG',  'Dasing',                      8001382, 11.0521650, 48.3862430 ],
	[ 'KDAT',  'Dattenfeld(Sieg)',            8001384, 7.54625200, 50.8091600 ],
	[ 'ADH',   'Dauenhof',                    8001387, 9.68065900, 53.8524590 ],
	[ 'SDF',   'Daufenbach',                  8001388, 6.63991100, 49.8759690 ],
	[ 'FDSU',  'Dausenau',                    8001389, 7.75821200, 50.3268660 ],
	[ 'EDVB',  'Davensberg',                  8001390, 7.59814600, 51.8179430 ],
	[ 'HDEH',  'Dedenhausen',                 8001392, 10.2387300, 52.4322150 ],
	[ 'HDED',  'Dedensen-Gümmer',            8001393, 9.52125200, 52.4070490 ],
	[ 'EDED',  'Dedinghausen',                8001394, 8.39828100, 51.6723590 ],
	[ 'ADZB',  'Deezbüll',                   8079022, 8.81827400, 54.7769700 ],
	[ 'NDG',   'Deggendorf Hbf',              8001397, 12.9497270, 48.8394400 ],
	[ 'RDM',   'Deidesheim',                  8001399, 8.19263400, 49.4083490 ],
	[ 'NDE',   'Deining(Oberpf)',             8001400, 11.5155720, 49.2039960 ],
	[ 'ADS',   'Deinste',                     8070349, 9.44256800, 53.5319000 ],
	[ 'ADS K', 'Deinste',                     8070349, 9.44256800, 53.5319000 ],
	[ 'MDS',   'Deisenhofen',                 8001404, 11.5835970, 48.0195390 ],
	[ 'TDLM',  'Deißlingen Mitte',           8001405, 8.61158600, 48.1083740 ],
	[ 'LDLO',  'Delitzsch ob Bf',             8080280, 12.3463900, 51.5197030 ],
	[ 'LDL',   'Delitzsch unt Bf',            8010076, 12.3452180, 51.5252270 ],
	[ 'SDE',   'Dellfeld',                    8001406, 7.46916900, 49.2277820 ],
	[ 'SDEO',  'Dellfeld Ort',                8001407, 7.47816200, 49.2388690 ],
	[ 'HD',    'Delmenhorst',                 8000070, 8.62975800, 53.0527920 ],
	[ 'DDT',   'Demitz-Thumitz',              8011354, 14.2409020, 51.1418370 ],
	[ 'LDK',   'Demker',                      8011355, 11.8547330, 52.5181780 ],
	[ 'WDM',   'Demmin',                      8011356, 13.0539540, 53.9011400 ],
	[ 'SDBO',  'Densborn',                    8001414, 6.60040600, 50.1239180 ],
	[ 'RDZ',   'Denzlingen',                  8001415, 7.88143400, 48.0686250 ],
	[ 'KDEA',  'Dernau',                      8001417, 7.04152700, 50.5296480 ],
	[ 'KDEB',  'Dernbach(Westerw)',           8001418, 7.78369300, 50.4572250 ],
	[ 'HDBG',  'Derneburg(Han)',              8000071, 10.1437190, 52.0968510 ],
	[ 'LDAD',  'Dessau Adria',                8011362, 12.3144190, 51.8211890 ],
	[ 'LD',    'Dessau Hbf',                  8010077, 12.2349450, 51.8398650 ],
	[ 'LDS',   'Dessau Süd',                 8011361, 12.2364550, 51.8021960 ],
	[ 'LDAL',  'Dessau-Alten',                8011363, 12.1933400, 51.8255410 ],
	[ 'LDMO',  'Dessau-Mosigkau',             8011364, 12.1485460, 51.8140770 ],
	[ 'LDWA',  'Dessau-Waldersee',            8070259, 12.2705660, 51.8365640 ],
	[ 'EDTM',  'Detmold',                     8001420, 8.87285900, 51.9407450 ],
	[ 'NDEB',  'Dettelbach Bahnhof',          8001421, 10.0903590, 49.7881460 ],
	[ 'TDH',   'Dettenhausen',                8085015, 9.09343700, 48.6067050 ],
	[ 'TDTUF', 'Dettingen Freibad',           8001424, 9.35125700, 48.5231740 ],
	[ 'TDTUG', 'Dettingen Gsaidt',            8001426, 9.35804000, 48.5140610 ],
	[ 'TDTUL', 'Dettingen Lehen',             8001422, 9.33689600, 48.5292160 ],
	[ 'FDET',  'Dettingen(Main)',             8001427, 9.03680700, 50.0425560 ],
	[ 'TDT',   'Dettingen(Teck)',             8001428, 9.45487800, 48.6164090 ],
	[ 'TDTU',  'Dettingen-Mitte',             8070679, 9.34463000, 48.5278170 ],
	[ 'HDEM',  'Dettum',                      8001429, 10.6607570, 52.1567210 ],
	[ 'LDB',   'Deuben(Zeitz)',               8010078, 12.0689130, 51.1105300 ],
	[ 'NDN',   'Deuerling',                   8001430, 11.9149180, 49.0416400 ],
	[ 'EDEU',  'Deuten',                      8001432, 6.97079000, 51.7130870 ],
	[ 'LDTZ',  'Deutzen',                     8011371, 12.4195420, 51.1144300 ],
	[ 'NDIE',  'Diebach',                     8001435, 9.83766000, 50.1286830 ],
	[ 'FDI',   'Dieburg',                     8000362, 8.83979500, 49.9036900 ],
	[ 'RBTD',  'Diedelsheim',                 8070012, 8.67447200, 49.0393470 ],
	[ 'MDID',  'Diedorf(Schwab)',             8001439, 10.7768230, 48.3560900 ],
	[ 'FDHM',  'Dienheim',                    8001448, 8.35714000, 49.8413540 ],
	[ 'HDIP',  'Diepholz',                    8001443, 8.38033400, 52.6047710 ],
	[ 'KDI',   'Dieringhausen',               8000363, 7.54248300, 50.9854200 ],
	[ 'LDI',   'Dieskau',                     8011376, 12.0521670, 51.4503250 ],
	[ 'NDT',   'Dietersheim',                 8001450, 10.5431030, 49.5568820 ],
	[ 'MDRD',  'Dietmannsried',               8001454, 10.2904810, 47.8128660 ],
	[ 'RDB',   'Dietzelbach',                 8007335, 7.76338200, 47.8593730 ],
	[ 'FDZ',   'Dietzenbach Bahnhof',         8001456, 8.78554100, 50.0080640 ],
	[ 'FDZM',  'Dietzenbach Mitte',           8001455, 8.78899000, 50.0172460 ],
	[ 'FDZS',  'Dietzenbach-Steinberg',       8001459, 8.79262700, 50.0252400 ],
	[ 'UDN',   'Dietzhausen',                 8011378, 10.5969000, 50.5994370 ],
	[ 'FDIZ',  'Diez',                        8001457, 8.01962000, 50.3701270 ],
	[ 'FDIO',  'Diez Ost',                    8001458, 8.03858700, 50.3760440 ],
	[ 'MDIN',  'Dießen',                     8001447, 11.1075400, 47.9508180 ],
	[ 'FDBT',  'Dillbrecht',                  8001460, 8.20377000, 50.8018210 ],
	[ 'FDIL',  'Dillenburg',                  8000074, 8.29408800, 50.7348830 ],
	[ 'MDIL',  'Dillingen(Donau)',            8001463, 10.4891670, 48.5812550 ],
	[ 'SDL',   'Dillingen(Saar)',             8000075, 6.72215000, 49.3527100 ],
	[ 'EDGD',  'Dingden',                     8001465, 6.60787200, 51.7702320 ],
	[ 'MDIF',  'Dingolfing',                  8001466, 12.4868700, 48.6416060 ],
	[ 'MDKB',  'Dinkelsbühl Bf',             8070352, 10.3288560, 49.0688510 ],
	[ 'MDKS',  'Dinkelscherben',              8001468, 10.5866750, 48.3426380 ],
	[ 'EDIN',  'Dinslaken',                   8001469, 6.73803000, 51.5674580 ],
	[ 'DDP',   'Dippoldiswalde',              8011382, 13.6646030, 50.8910930 ],
	[ 'SDIR',  'Dirmingen',                   8001470, 7.01237700, 49.4153860 ],
	[ 'HDBR',  'Dissen-Bad Rothenfelde',      8001471, 8.18529800, 52.1119200 ],
	[ 'TDIH',  'Distelhausen',                8001472, 9.68350800, 49.5982330 ],
	[ 'LDT',   'Ditfurt',                     8011383, 11.1867280, 51.8334820 ],
	[ 'DDIF',  'Dittersbach',                 8011385, 13.0688420, 50.9268370 ],
	[ 'DDF',   'Dittersdorf',                 8011386, 12.9786150, 50.7513900 ],
	[ 'TDM',   'Dittigheim',                  8001474, 9.67491200, 49.6079640 ],
	[ 'TDI',   'Ditzingen',                   8001476, 9.06705000, 48.8236110 ],
	[ 'BDKO',  'Doberlug-Kirchhain',          8010079, 13.5642410, 51.6205760 ],
	[ 'BDKU',  'Doberlug-Kirchhain',          8010079, 13.5642410, 51.6205760 ],
	[ 'LDOB',  'Doberschütz',                8011387, 12.7457850, 51.4922370 ],
	[ 'LDF',   'Dodendorf',                   8011388, 11.6130860, 52.0489520 ],
	[ 'AKTKD', 'Dodenhof',                    8007148, 9.93969200, 53.8444090 ],
	[ 'RDRN',  'Dogern',                      8001491, 8.16735600, 47.6088870 ],
	[ 'DDO',   'Dohna(Sachs)',                8011398, 13.8555650, 50.9611880 ],
	[ 'HDOG',  'Dollbergen',                  8001492, 10.1816570, 52.4171530 ],
	[ 'ADR',   'Dollern',                     8001493, 9.55808000, 53.5454250 ],
	[ 'MDO',   'Dollnstein',                  8001495, 11.0790090, 48.8714250 ],
	[ 'NDB',   'Dombühl',                    8000365, 10.2985230, 49.2521100 ],
	[ 'LDN',   'Domnitz(Saalkr)',             8011402, 11.8399730, 51.6352250 ],
	[ 'WDS',   'Domsühl',                    8011403, 11.7658690, 53.4853720 ],
	[ 'RDO',   'Donaueschingen',              8000077, 8.49891900, 47.9477860 ],
	[ 'RDOA', 'Donaueschingen Allmendshofen', 8001479, 8.50172000, 47.9405630 ],
	[ 'RDOF', 'Donaueschingen Aufen',         8001482, 8.47562000, 47.9633560 ],
	[ 'RDOG', 'Donaueschingen Grüningen',    8001483, 8.47182400, 47.9830520 ],
	[
		'RDOM', 'Donaueschingen Mitte/Siedlung', 8001485, 8.48895500,
		47.9525410
	],
	[ 'MDT',   'Donauwörth',       8000078, 10.7714430, 48.7140260 ],
	[ 'WMK',   'Dorf Mecklenburg',  8012321, 11.4713430, 53.8429320 ],
	[ 'DDCH',  'Dorfchemnitz',      8011405, 12.8399390, 50.6659970 ],
	[ 'MDFN',  'Dorfen Bahnhof',    8001499, 12.1596860, 48.2670480 ],
	[ 'HDMK',  'Dorfmark',          8001502, 9.77130500, 52.8991390 ],
	[ 'NDP',   'Dorfprozelten',     8001503, 9.38216000, 49.7793770 ],
	[ 'FDH',   'Dorheim(Wetterau)', 8001504, 8.79051000, 50.3527020 ],
	[ 'KDO',   'Dormagen',          8001506, 6.81483700, 51.0994950 ],
	[ 'KDBW',  'Dormagen Chempark', 8001507, 6.83817100, 51.0770450 ],
	[ 'KDBWN', 'Dormagen Chempark', 8001507, 6.83817100, 51.0770450 ],
	[ 'UDG',   'Dornburg(Saale)',   8011406, 11.6754990, 51.0086130 ],
	[ 'TDS',   'Dornstetten',       8001512, 8.49495500, 48.4721060 ],
	[ 'EDRN',  'Dorsten',           8006709, 6.97050000, 51.6582740 ],
	[ 'FDW',   'Dortelweil',        8001514, 8.75114500, 50.2075030 ],
	[ 'EDO',   'Dortmund Hbf',      8000080, 7.45929000, 51.5178960 ],
	[ 'EDO N', 'Dortmund Hbf',      8000080, 7.45929000, 51.5178960 ],
	[
		'EDKK', 'Dortmund Knappschaftskrankenhaus',
		8001517, 7.53745800, 51.5187680
	],
	[ 'EDMB',  'Dortmund Möllerbrücke',    8001518, 7.45170600, 51.5071570 ],
	[ 'EDWH',  'Dortmund Signal Iduna Park', 8001522, 7.45757300, 51.4907280 ],
	[ 'EDST',  'Dortmund Stadthaus',         8001520, 7.46876400, 51.5078280 ],
	[ 'EDTP',  'Dortmund Tierpark',          8001521, 7.46199500, 51.4781930 ],
	[ 'EDUV',  'Dortmund Universität',      8004419, 7.41770800, 51.4927400 ],
	[ 'EDW',   'Dortmund West',              8003946, 7.43893800, 51.5096520 ],
	[ 'EDAP',  'Dortmund-Aplerbeck',         8001523, 7.55318900, 51.4901510 ],
	[ 'EDAU',  'Dortmund-Aplerbeck Süd',    8001524, 7.54998200, 51.4844370 ],
	[ 'EDAM',  'Dortmund-Asseln Mitte',      8001526, 7.58383900, 51.5262190 ],
	[ 'EDBA',  'Dortmund-Barop',             8001527, 7.43129800, 51.4769540 ],
	[ 'EDBK',  'Dortmund-Brackel',           8001529, 7.55008300, 51.5207570 ],
	[ 'EDBH',  'Dortmund-Bövinghausen',     8001528, 7.32747700, 51.5190360 ],
	[ 'EDD',   'Dortmund-Derne',             8001530, 7.52882200, 51.5677160 ],
	[ 'EDDP',  'Dortmund-Dorstfeld',         8000081, 7.42486400, 51.5093760 ],
	[ 'EDDPH', 'Dortmund-Dorstfeld',         8000081, 7.42486400, 51.5093760 ],
	[ 'EDDPT', 'Dortmund-Dorstfeld',         8000081, 7.42486400, 51.5093760 ],
	[ 'EDDS',  'Dortmund-Dorstfeld Süd',    8004230, 7.42001700, 51.5006320 ],
	[ 'EDGM',  'Dortmund-Germania',          8001540, 7.36372800, 51.4981240 ],
	[ 'EDOH',  'Dortmund-Huckarde',          8001505, 7.40235300, 51.5326230 ],
	[ 'EDHU',  'Dortmund-Huckarde Nord',     8001532, 7.41509500, 51.5336670 ],
	[ 'EDH',   'Dortmund-Hörde',            8000961, 7.50002900, 51.4877820 ],
	[ 'EDKD',  'Dortmund-Kirchderne',        8001533, 7.51010500, 51.5470750 ],
	[ 'EDKH',  'Dortmund-Kirchhörde',       8001534, 7.45776400, 51.4642410 ],
	[ 'EDK',   'Dortmund-Kley',              8004269, 7.36537400, 51.4894670 ],
	[ 'EDKR',  'Dortmund-Kruckel',           8001536, 7.41552900, 51.4583320 ],
	[ 'EDKU',  'Dortmund-Kurl',              8001537, 7.58529100, 51.5569790 ],
	[ 'EDKO',  'Dortmund-Körne',            8001535, 7.51537000, 51.5134300 ],
	[ 'EDWK',  'Dortmund-Körne West',       8003916, 7.50240900, 51.5099390 ],
	[ 'EDLH',  'Dortmund-Löttringhausen',   8001538, 7.44722800, 51.4516550 ],
	[ 'EDLS',  'Dortmund-Lütgendortmund',   8001516, 7.33417700, 51.5007350 ],
	[
		'EDLN', 'Dortmund-Lütgendortmund Nord', 8001539, 7.34240100,
		51.5085230
	],
	[ 'EDMR',  'Dortmund-Marten',            8001541, 7.37440800, 51.5144620 ],
	[ 'EDMS',  'Dortmund-Marten Süd',       8001542, 7.38747900, 51.5079840 ],
	[ 'EDMG',  'Dortmund-Mengede',           8001543, 7.37437400, 51.5703450 ],
	[ 'EDOO',  'Dortmund-Nette/Oestrich',    8001519, 7.37773100, 51.5614950 ],
	[ 'EDOP',  'Dortmund-Oespel',            8004288, 7.38381100, 51.4883970 ],
	[ 'EDRA',  'Dortmund-Rahm',              8001544, 7.39525200, 51.5257280 ],
	[ 'EDSH',  'Dortmund-Scharnhorst',       8001515, 7.53656400, 51.5383730 ],
	[ 'EDSM',  'Dortmund-Somborn',           8001549, 7.35008400, 51.4960100 ],
	[ 'EDSO',  'Dortmund-Sölde',            8001545, 7.58920500, 51.4954600 ],
	[ 'EDOF',  'Dortmund-Westerfilde',       8001525, 7.38021300, 51.5483340 ],
	[ 'EDWI',  'Dortmund-Wickede',           8001546, 7.62466000, 51.5339300 ],
	[ 'EDWW',  'Dortmund-Wickede West',      8003936, 7.60721500, 51.5294550 ],
	[ 'EDOL',  'Dortmund-Wischlingen',       8001531, 7.41286300, 51.5192900 ],
	[ 'ADO',   'Dorum(Weserm)',              8001547, 8.57580100, 53.6887430 ],
	[ 'WDOW',  'Dossow(Prign)',              8011408, 12.5208860, 53.1212090 ],
	[ 'NDM',   'Dottenheim',                 8001548, 10.5225730, 49.5474960 ],
	[ 'TDOD',  'Dotternhausen-Dormettingen', 8029358, 8.78111900, 48.2284550 ],
	[ 'BDF',   'Drahnsdorf',                 8011409, 13.5812500, 51.9153910 ],
	[ 'LDRG',  'Drahtzug',                   8017005, 11.1246360, 51.6634470 ],
	[ 'BDR',   'Drebkau',                    8011414, 14.2231300, 51.6550840 ],
	[ 'LDAH',  'Drei Annen Hohne',           8017006, 10.7267660, 51.7701160 ],
	[ 'FBUS',  'Dreieich-Buchschlag',        8001236, 8.66120400, 50.0221130 ],
	[ 'FBUSS', 'Dreieich-Buchschlag',        8001236, 8.66120400, 50.0221130 ],
	[ 'FDCH',  'Dreieich-Dreieichenhain',    8001554, 8.70869300, 49.9984680 ],
	[ 'FGOZ',  'Dreieich-Götzenhain',       8002315, 8.73126600, 49.9945020 ],
	[ 'FOFF',  'Dreieich-Offenthal',         8004653, 8.74964000, 49.9818510 ],
	[ 'FSPO',  'Dreieich-Sprendlingen',      8005636, 8.68874000, 50.0152010 ],
	[ 'FWED',  'Dreieich-Weibelfeld',        8079151, 8.70092200, 50.0070840 ],
	[ 'FOHS',  'Dreikirchen',                8004538, 7.95838400, 50.4498650 ],
	[ 'LDD',   'Dreileben-Drackenstedt',     8011415, 11.3415590, 52.1438520 ],
	[ 'EDRS',  'Drensteinfurt',              8001558, 7.73360900, 51.7991580 ],
	[ 'DBPL',  'Dresden Bischofsplatz',      8011416, 13.7462480, 51.0723350 ],
	[ 'DKTF',  'Dresden Flughafen',          8011399, 13.7659930, 51.1246650 ],
	[ 'DHFR',  'Dresden Freiberger Straße', 8011431, 13.7195900, 51.0479770 ],
	[ 'DGRS',  'Dresden Grenzstraße',       8011417, 13.7777370, 51.1282980 ],
	[ 'DH',    'Dresden Hbf',                8010085, 13.7320350, 51.0405630 ],
	[ 'DIG',   'Dresden Industriegelände',  8011418, 13.7627720, 51.0874560 ],
	[ 'DM',    'Dresden Mitte',              8013444, 13.7241090, 51.0561680 ],
	[ 'DCT',   'Dresden-Cotta',              8011419, 13.6832980, 51.0621570 ],
	[ 'DD',    'Dresden-Dobritz',            8011420, 13.8084770, 51.0116140 ],
	[ 'DF',    'Dresden-Friedrichstadt',     8013475, 13.7081510, 51.0560340 ],
	[ 'DKE',   'Dresden-Kemnitz',            8011421, 13.6689190, 51.0730840 ],
	[ 'DKT',   'Dresden-Klotzsche',          8010088, 13.7891100, 51.1146670 ],
	[ 'DN',    'Dresden-Neustadt',           8010089, 13.7407010, 51.0658990 ],
	[ 'DNSH',  'Dresden-Niedersedlitz',      8011422, 13.8283990, 50.9996540 ],
	[ 'DPS',   'Dresden-Pieschen',           8011423, 13.7255270, 51.0818590 ],
	[ 'DPL',   'Dresden-Plauen',             8013476, 13.7031700, 51.0296300 ],
	[ 'DRK',   'Dresden-Reick',              8011424, 13.7905140, 51.0213170 ],
	[ 'DSTT',  'Dresden-Stetzsch',           8011425, 13.6508690, 51.0808480 ],
	[ 'DSTH',  'Dresden-Strehlen',           8011426, 13.7618610, 51.0306770 ],
	[ 'DTR',   'Dresden-Trachau',            8011427, 13.7027920, 51.0900810 ],
	[ 'DZSW',  'Dresden-Zschachwitz',        8011428, 13.8449300, 50.9896520 ],
	[ 'HDRY',  'Dreye',                      8001561, 8.87110300, 53.0184250 ],
	[ 'LDM',   'Drohndorf-Mehringen',        8011433, 11.5156480, 51.7216920 ],
	[ 'WDU',   'Ducherow',                   8011438, 13.7960210, 53.7661350 ],
	[ 'KDUK',  'Duckterath',                 8001566, 7.10349600, 50.9848150 ],
	[ 'SDUW',  'Dudweiler',                  8001570, 7.02735100, 49.2772990 ],
	[ 'EDEF',  'Duisburg Entenfang',         8005272, 6.81342200, 51.3771230 ],
	[ 'EDG',   'Duisburg Hbf',               8000086, 6.77590300, 51.4297850 ],
	[ 'EDBI',  'Duisburg-Bissingheim',       8001599, 6.80806700, 51.3921750 ],
	[ 'EDBU',  'Duisburg-Buchholz',          8001600, 6.77540600, 51.3829190 ],
	[ 'EDGR',  'Duisburg-Großenbaum',       8001602, 6.77747000, 51.3647740 ],
	[ 'EDHD',  'Duisburg-Hochfeld Süd',     8001605, 6.75340800, 51.4090000 ],
	[ 'EDHP',  'Duisburg-Hochfeld Süd',     8001605, 6.75340800, 51.4090000 ],
	[ 'EDMO',  'Duisburg-Meiderich Ost',     8001607, 6.80078900, 51.4688550 ],
	[ 'EDME',  'Duisburg-Meiderich Süd',    8000367, 6.78019100, 51.4688310 ],
	[ 'EDOM',  'Duisburg-Obermeiderich',     8001608, 6.82123200, 51.4687920 ],
	[ 'EDRM',  'Duisburg-Rahm',              8001609, 6.77992400, 51.3468350 ],
	[ 'EDRU',  'Duisburg-Ruhrort',           8001611, 6.73601500, 51.4572800 ],
	[ 'EDSL',  'Duisburg-Schlenk',           8001596, 6.77320600, 51.4017810 ],
	[ 'EDWD',  'Duisburg-Wedau',             8001612, 6.80357500, 51.3992530 ],
	[ 'EDWDP', 'Duisburg-Wedau',             8001612, 6.80357500, 51.3992530 ],
	[ 'MDUH',  'Durach',                     8001614, 10.3437970, 47.6964520 ],
	[ 'RDRM',  'Durmersheim',                8001616, 8.27263100, 48.9289040 ],
	[ 'RDUN',  'Durmersheim Nord',           8070170, 8.28058100, 48.9377960 ],
	[ 'FDTH',  'Dutenhofen(Wetzlar)',        8001618, 8.59890500, 50.5644500 ],
	[ 'TDU',   'Dußlingen',                 8001617, 9.05844400, 48.4524080 ],
	[ 'DDE',   'Döbeln Hbf',                8010080, 13.0949880, 51.1265680 ],
	[ 'LDO',   'Döberitz',                  8011390, 12.3684620, 52.5243330 ],
	[ 'RDGN',  'Döggingen',                 8001480, 8.44110700, 47.8936540 ],
	[ 'NDAU',  'Döhlau',                    8001481, 11.6559660, 49.9613920 ],
	[ 'UDST',  'Döllstädt',                8010081, 10.8133980, 51.0848860 ],
	[ 'NDOE',  'Dörfles-Esbach',            8001484, 10.9977560, 50.2827510 ],
	[ 'HDPH',  'Dörpen',                    8001486, 7.35450700, 52.9705680 ],
	[ 'UDOE',  'Dörrberg',                  8011397, 10.7986710, 50.7353510 ],
	[ 'HDVD',  'Dörverden',                 8001489, 9.24633400, 52.8464070 ],
	[ 'KDUL',  'Dülken',                    8001571, 6.33793000, 51.2571490 ],
	[ 'EDUL',  'Dülmen',                    8000083, 7.29576500, 51.8276760 ],
	[ 'EDULH', 'Dülmen',                    8000083, 7.29576500, 51.8276760 ],
	[ 'KDN',   'Düren',                     8000084, 6.48245100, 50.8095170 ],
	[ 'KDN P', 'Düren',                     8000084, 6.48245100, 50.8095170 ],
	[ 'KDNS',  'Düren Annakirmesplatz',     8007818, 6.47425900, 50.7962370 ],
	[ 'KDNG',  'Düren Im Großen Tal',      8007836, 6.47431000, 50.8330200 ],
	[ 'KDNR',  'Düren Renkerstraße',       8007832, 6.48949300, 50.7702760 ],
	[ 'KKBR',  'Düren-Kuhbrücke',          8007833, 6.48675200, 50.7833120 ],
	[ 'KLED',  'Düren-Lendersdorf',         8007819, 6.49047000, 50.7748330 ],
	[ 'RDBG',  'Dürrenbüchig',             8001576, 8.64818100, 49.0239520 ],
	[ 'NDW',   'Dürrenwaid Bahnhof',        8070805, 11.5169340, 50.3571820 ],
	[ 'MDHR',  'Dürrnhaar',                 8001578, 11.7366070, 47.9939540 ],
	[ 'DRR',   'Dürrröhrsdorf',            8010091, 14.0073800, 51.0281380 ],
	[ 'KDFF',  'Düsseldorf Flughafen',      8000082, 6.78683600, 51.2920090 ],
	[ 'KDFFH', 'Düsseldorf Flughafen',      8000082, 6.78683600, 51.2920090 ],
	[
		'KDF', 'Düsseldorf Flughafen Terminal', 8001580, 6.76697900,
		51.2785170
	],
	[ 'KDFS', 'Düsseldorf Friedrichstadt',   8001579, 6.78899000, 51.2121150 ],
	[ 'KD',   'Düsseldorf Hbf',              8000085, 6.79431900, 51.2199620 ],
	[ 'KDV',  'Düsseldorf Volksgarten',      8001581, 6.79197800, 51.2101380 ],
	[ 'KDVS', 'Düsseldorf Völklinger Str.', 8001603, 6.76043100, 51.2102080 ],
	[ 'KDW',  'Düsseldorf Wehrhahn',         8001582, 6.79817300, 51.2284470 ],
	[ 'KDBE', 'Düsseldorf-Benrath',          8001584, 6.87893100, 51.1622930 ],
	[ 'KDBH', 'Düsseldorf-Bilk',             8001585, 6.77557800, 51.2079940 ],
	[ 'KDD',  'Düsseldorf-Derendorf',        8001586, 6.79451200, 51.2476240 ],
	[ 'KDDH', 'Düsseldorf-Derendorf',        8001586, 6.79451200, 51.2476240 ],
	[ 'KDE',  'Düsseldorf-Eller',            8001587, 6.85192700, 51.2026700 ],
	[ 'KDEM', 'Düsseldorf-Eller Mitte',      8001308, 6.83860700, 51.2020580 ],
	[ 'KDES', 'Düsseldorf-Eller Süd',       8001588, 6.83612800, 51.1980720 ],
	[ 'KDFL', 'Düsseldorf-Flingern',         8001598, 6.81017900, 51.2263670 ],
	[ 'KDGA', 'Düsseldorf-Garath',           8001589, 6.89767500, 51.1436260 ],
	[ 'KDGE', 'Düsseldorf-Gerresheim',       8001590, 6.86393300, 51.2203610 ],
	[ 'KDHA', 'Düsseldorf-Hamm',             8001597, 6.74033500, 51.2107700 ],
	[ 'KDHL', 'Düsseldorf-Hellerhof',        8004920, 6.90827700, 51.1330360 ],
	[ 'KDOB', 'Düsseldorf-Oberbilk',         8001591, 6.80867800, 51.2080470 ],
	[ 'KDR',  'Düsseldorf-Rath',             8001592, 6.82106300, 51.2641240 ],
	[ 'KDRM', 'Düsseldorf-Rath Mitte',       8001593, 6.80839800, 51.2611360 ],
	[ 'KDRH', 'Düsseldorf-Reisholz',         8001594, 6.86095300, 51.1807820 ],
	[ 'KDU',  'Düsseldorf-Unterrath',        8001595, 6.78878300, 51.2767320 ],
	[ 'KDZ',  'Düsseldorf-Zoo',              8001583, 6.79692400, 51.2369620 ],
	[ 'WDT',  'Dütschow',                    8011442, 11.6785650, 53.4019400 ],
	[ 'NEE',  'Ebelsbach-Eltmann',            8001619, 10.6696140, 49.9826720 ],
	[ 'NEBH', 'Ebenhausen(Unterfr)',          8001620, 10.1380400, 50.1313050 ],
	[ 'MEBS', 'Ebenhausen-Schäftlarn',       8001621, 11.4536080, 47.9786860 ],
	[ 'MEBH', 'Ebenhofen',                    8001622, 10.6184790, 47.8148180 ],
	[ 'NED',  'Ebensfeld',                    8001623, 10.9547250, 50.0687310 ],
	[ 'REA',  'Eberbach',                     8000369, 8.98415200, 49.4657680 ],
	[ 'NEBM', 'Ebermannstadt',                8001627, 11.1868730, 49.7768010 ],
	[ 'MEBM', 'Ebermergen',                   8001628, 10.7109600, 48.7562100 ],
	[ 'NEB',  'Ebern',                        8001629, 10.7967190, 50.0941630 ],
	[ 'TEC',  'Ebersbach(Fils)',              8001632, 9.52658200, 48.7161200 ],
	[ 'DEB',  'Ebersbach(Sachs)',             8010092, 14.5788020, 51.0043780 ],
	[ 'MEG',  'Ebersberg(Oberbay)',           8001634, 11.9702430, 48.0749700 ],
	[ 'DEBR', 'Ebersbrunn',                   8011446, 12.4432150, 50.6513730 ],
	[ 'NEC',  'Ebersdorf(b Coburg)',          8001636, 11.0646430, 50.2242710 ],
	[ 'WE',   'Eberswalde Hbf',               8010093, 13.7970620, 52.8340210 ],
	[ 'RET',  'Ebertsheim',                   8001638, 8.10823700, 49.5640040 ],
	[ 'NEG',  'Ebing',                        8001640, 10.9138460, 50.0015350 ],
	[ 'REBR', 'Ebringen',                     8001643, 7.76818000, 47.9603600 ],
	[ 'HEBS', 'Ebstorf(Uelzen)',              8001645, 10.4169500, 53.0171920 ],
	[ 'AECH', 'Echem',                        8001646, 10.5371980, 53.3370060 ],
	[ 'MEC',  'Eching',                       8001647, 11.6167540, 48.3029920 ],
	[ 'TETD', 'Echterdingen',                 8001650, 9.16916400, 48.6921520 ],
	[ 'FEZL', 'Echzell',                      8001648, 8.89131200, 50.3907190 ],
	[ 'UEK',  'Eckardtsleben',                8011449, 10.6821230, 51.0660930 ],
	[ 'UEC',  'Eckartsberga(Thür)',          8011450, 11.5545500, 51.1078370 ],
	[ 'TEI',  'Eckartshausen-Ilshofen',       8001651, 9.93664500, 49.1523170 ],
	[ 'AEC',  'Eckernförde',                 8001654, 9.83511500, 54.4676000 ],
	[ 'NEMN', 'Eckersmühlen',                8001655, 11.1379470, 49.2154720 ],
	[ 'FED',  'Eddersheim',                   8001659, 8.45674100, 50.0394920 ],
	[ 'TED',  'Edelfingen',                   8001660, 9.74311300, 49.5130250 ],
	[ 'REK',  'Edenkoben',                    8001663, 8.14062000, 49.2820530 ],
	[ 'FGRF', 'Edermünde-Grifte',            8002374, 9.44885500, 51.2099580 ],
	[ 'REH',  'Edesheim(Pfalz)',              8001665, 8.13907500, 49.2637360 ],
	[ 'SEE',  'Ediger-Eller',                 8001666, 7.13959800, 50.1046970 ],
	[ 'FEDI', 'Edingen(Wetzlar)',             8001668, 8.32282300, 50.6321660 ],
	[ 'DKR',  'Edle Krone',                   8011451, 13.5836320, 50.9500150 ],
	[ 'MEDL', 'Edling',                       8001669, 12.1632340, 48.0584790 ],
	[ 'UEFT', 'Effelder(Thür)',              8011453, 11.0758490, 50.3798750 ],
	[ 'FEF',  'Effolderbach',                 8001670, 9.00748300, 50.3381920 ],
	[ 'REF',  'Efringen-Kirchen',             8001671, 7.56391800, 47.6556190 ],
	[ 'FEGB', 'Egelsbach',                    8001672, 8.65346200, 49.9691700 ],
	[ 'NEGE', 'Egersdorf',                    8001674, 10.8873850, 49.4646380 ],
	[ 'HEGT', 'Egestorf(Deister)',            8001675, 9.51448500, 52.2785850 ],
	[ 'MEGF', 'Eggenfelden',                  8001677, 12.7486690, 48.4039560 ],
	[ 'MEFM', 'Eggenfelden Mitte',            8001676, 12.7670680, 48.4062150 ],
	[ 'REG',  'Eggenstein Bf',                8007173, 8.39794100, 49.0756710 ],
	[ 'LEGD', 'Eggersdorf',                   8011455, 11.6959480, 51.9751310 ],
	[ 'WEGS', 'Eggesin',                      8011456, 14.0730460, 53.6818250 ],
	[ 'RUEG', 'Eggingen',                     8070866, 8.39665300, 47.6937310 ],
	[ 'MEGK', 'Egglkofen',                    8001678, 12.4459560, 48.3957620 ],
	[ 'MEGM', 'Eggmühl',                     8001679, 12.1821920, 48.8364970 ],
	[ 'NEO',  'Eggolsheim',                   8001680, 11.0366620, 49.7749600 ],
	[ 'MEGL', 'Eglharting',                   8001682, 11.8642910, 48.0823480 ],
	[ 'MELG', 'Egling',                       8001683, 10.9757220, 48.1905410 ],
	[ 'TEH',  'Ehingen(Donau)',               8001684, 9.72434000, 48.2856770 ],
	[ 'EELB', 'Ehlenbruch',                   8001686, 8.74124300, 51.9812700 ],
	[ 'HELH', 'Ehlershausen',                 8001687, 10.0295960, 52.5236090 ],
	[ 'TEHN', 'Ehningen(b Böblingen)',       8001689, 8.94426000, 48.6626820 ],
	[ 'KEHR', 'Ehr',                          8001690, 7.57132400, 50.1757200 ],
	[ 'SEG',  'Ehrang',                       8000370, 6.68580800, 49.8020290 ],
	[ 'SEGO', 'Ehrang Ort',                   8001688, 6.68826100, 49.8094130 ],
	[ 'FEGN', 'Ehringen',                     8001691, 9.15461900, 51.3795280 ],
	[ 'EERI', 'Ehringhausen(Kr Lippstadt)',   8001692, 8.44926000, 51.6628130 ],
	[ 'FEHR', 'Ehringshausen(Kr Wetzlar)',    8001694, 8.38384100, 50.5950660 ],
	[ 'FEHH', 'Ehringshausen(Oberhess)',      8001693, 9.10186200, 50.7087800 ],
	[ 'DEIB', 'Eibau',                        8010094, 14.6461600, 50.9865010 ],
	[ 'EEHS', 'Eichen(Kr Siegen)',            8001700, 7.97793400, 50.9738640 ],
	[ 'MEIC', 'Eichenau(Oberbay)',            8001702, 11.3282770, 48.1793240 ],
	[ 'HEBG', 'Eichenberg',                   8000090, 9.92148200, 51.3748230 ],
	[ 'FEIZ', 'Eichenzell',                   8001704, 9.69471700, 50.4940120 ],
	[ 'EEHG', 'Eichhagen',                    8001706, 7.83687100, 51.0591670 ],
	[ 'REM',  'Eicholzheim',                  8001707, 9.29031700, 49.4324390 ],
	[ 'LEST', 'Eichstedt(Altm)',              8011460, 11.8548950, 52.6748500 ],
	[ 'RE',   'Eichstetten am Kaiserstuhl',   8007295, 7.74802100, 48.0929010 ],
	[ 'MEB',  'Eichstätt Bahnhof',           8001708, 11.1636500, 48.8698790 ],
	[ 'MEST', 'Eichstätt Stadt',             8001709, 11.1796020, 48.8932960 ],
	[ 'BEIW', 'Eichwalde',                    8080340, 13.6153980, 52.3713520 ],
	[ 'LEF',  'Eickendorf',                   8011462, 11.6768780, 51.9467520 ],
	[ 'LEG',  'Eilenburg',                    8010095, 12.6370040, 51.4519660 ],
	[ 'LEGO', 'Eilenburg Ost',                8010161, 12.6677720, 51.4634240 ],
	[ 'LEGOB', 'Eilenburg Ost',              8010161, 12.6677720, 51.4634240 ],
	[ 'KEIL',  'Eilendorf',                  8001712, 6.15436700, 50.7855610 ],
	[ 'LEI',   'Eilsleben(b Magdeburg)',     8010096, 11.2152140, 52.1502370 ],
	[ 'HEIV',  'Eilvese',                    8001713, 9.42814700, 52.5452150 ],
	[ 'REI',   'Eimeldingen',                8001715, 7.59560000, 47.6279480 ],
	[ 'HEB',   'Einbeck Salzderhelden',      8005264, 9.92277500, 51.7981690 ],
	[ 'AEF',   'Einfeld',                    8001718, 9.99792300, 54.1293730 ],
	[ 'DED',   'Einsiedel',                  8011466, 12.9730140, 50.7727860 ],
	[ 'DEDH',  'Einsiedel Hp Gymnasium',     8011464, 12.9706110, 50.7829920 ],
	[ 'SEF',   'Einsiedlerhof',              8001720, 7.66222700, 49.4310020 ],
	[ 'SEI',   'Einöd(Saar)',               8000371, 7.32191600, 49.2666630 ],
	[ 'UEI',   'Eisenach',                   8010097, 10.3319860, 50.9769220 ],
	[ 'UEIP',  'Eisenach Opelwerke Hp',      8010105, 10.2834910, 50.9793340 ],
	[ 'UEIW',  'Eisenach West',              8011468, 10.3047400, 50.9789020 ],
	[ 'SEMA',  'Eisenbach-Matzenbach',       8001727, 7.45621200, 49.4947210 ],
	[ 'REIS',  'Eisenberg(Pfalz)',           8001728, 8.07058200, 49.5544830 ],
	[ 'REISO', 'Eisenberg(Pfalz)',           8001728, 8.07058200, 49.5544830 ],
	[ 'REISW', 'Eisenberg(Pfalz)',           8001728, 8.07058200, 49.5544830 ],
	[ 'NEHM',  'Eisenheim',                  8070856, 10.1534260, 49.8694120 ],
	[ 'BEHS',  'Eisenhüttenstadt',          8011471, 14.6584350, 52.1479800 ],
	[ 'MEZT',  'Eisenärzt',                 8001725, 12.6383010, 47.7962730 ],
	[ 'EEFD',  'Eiserfeld(Sieg)',            8001729, 7.98707100, 50.8472990 ],
	[ 'UED',   'Eisfeld',                    8011472, 10.9046370, 50.4177950 ],
	[ 'LETM',  'Eisfelder Talmühle',        8017007, 10.8129560, 51.6204080 ],
	[ 'TEF',   'Eislingen(Fils)',            8001731, 9.70514700, 48.6964940 ],
	[ 'REIW',  'Eiswoog',                    8001732, 7.98356200, 49.5165780 ],
	[ 'MEI',   'Eitensheim',                 8001734, 11.3192590, 48.8159790 ],
	[ 'KEIT',  'Eitorf',                     8001736, 7.44732600, 50.7736190 ],
	[ 'LELD',  'Elend',                      8017008, 10.6901290, 51.7459700 ],
	[ 'NELF',  'Elfershausen-Trimberg',      8001742, 9.96910900, 50.1404800 ],
	[ 'UELG',  'Elgersburg',                 8011476, 10.8499050, 50.7060540 ],
	[ 'DLD',   'Ellefeld',                   8011477, 12.3843820, 50.4880030 ],
	[ 'TBME',  'Ellental',                   8001746, 9.12374400, 48.9552880 ],
	[ 'AELA',  'Ellerau',                    8007050, 9.92337400, 53.7501440 ],
	[ 'TELL',  'Ellhofen',                   8001747, 9.31603500, 49.1499520 ],
	[ 'NEL',   'Ellingen(Bay)',              8001749, 10.9596930, 49.0662280 ],
	[ 'UER',   'Ellrich',                    8011480, 10.6694440, 51.5798040 ],
	[ 'TEL',   'Ellwangen',                  8001751, 10.1296810, 48.9641210 ],
	[ 'MELZ',  'Ellzee',                     8001752, 10.3383710, 48.3421400 ],
	[ 'WELM',  'Elmenhorst',                 8011481, 13.0740140, 54.2102020 ],
	[ 'AEL',   'Elmshorn',                   8000092, 9.65940800, 53.7540250 ],
	[ 'TELP',  'Elpersheim',                 8001754, 9.87342700, 49.4730940 ],
	[ 'HELS',  'Elsfleth',                   8001760, 8.46402600, 53.2341030 ],
	[ 'BEZ',   'Elsholz',                    8011482, 12.9549110, 52.2040500 ],
	[ 'LEK',   'Elsnigk(Anh)',               8011484, 12.0585180, 51.7906710 ],
	[ 'BETN',  'Elstal',                     8080370, 13.0001140, 52.5474900 ],
	[ 'LELT',  'Elster(Elbe)',               8011486, 12.8277050, 51.8323310 ],
	[ 'UELB',  'Elsterberg',                 8011487, 12.1674870, 50.6135470 ],
	[ 'UELK',  'Elsterberg-Kunstseidenwerk', 8011488, 12.1597980, 50.6050240 ],
	[ 'BEW',   'Elsterwerda',                8010099, 13.5164280, 51.4596770 ],
	[ 'BEB',   'Elsterwerda-Biehla',         8010100, 13.5192710, 51.4722270 ],
	[ 'NEF',   'Eltersdorf',                 8001762, 10.9963810, 49.5537820 ],
	[ 'FELT',  'Eltville',                   8001763, 8.12153000, 50.0275620 ],
	[ 'UEX',   'Elxleben',                   8011489, 10.9467880, 51.0431830 ],
	[ 'FELZ',  'Elz(Limburg/Lahn)',          8001764, 8.03845800, 50.4142940 ],
	[ 'FELS',  'Elz(Limburg/Lahn) Süd',     8001765, 8.03222300, 50.4087090 ],
	[ 'RELZ',  'Elzach',                     8001766, 8.07089100, 48.1711940 ],
	[ 'HELZ',  'Elze(Han)',                  8000093, 9.74689400, 52.1201470 ],
	[ 'HEA',   'Emden Außenhafen',          8001767, 7.18617900, 53.3444690 ],
	[ 'HE',    'Emden Hbf',                  8001768, 7.19517600, 53.3690360 ],
	[ 'KEMM',  'Emmelshausen',               8001770, 7.56049400, 50.1576730 ],
	[ 'REMM',  'Emmendingen',                8001771, 7.84751100, 48.1194540 ],
	[ 'EEM',   'Emmerich',                   8001773, 6.25648000, 51.8341750 ],
	[ 'HEMK',  'Emmerke',                    8001775, 9.86620100, 52.1623650 ],
	[ 'HEMT',  'Emmerthal',                  8001777, 9.38285600, 52.0464130 ],
	[ 'EEMP',  'Empel-Rees',                 8001780, 6.41671200, 51.7984740 ],
	[ 'HEMP',  'Empelde',                    8001781, 9.66898200, 52.3401570 ],
	[ 'EEDT',  'Emsdetten',                  8001782, 7.53152800, 52.1767500 ],
	[ 'NEK',   'Emskirchen',                 8001783, 10.7104120, 49.5550300 ],
	[ 'TEN',   'Endersbach',                 8001785, 9.37022800, 48.8131530 ],
	[ 'REN',   'Endingen am Kaiserstuhl',    8007285, 7.70191800, 48.1442500 ],
	[ 'TEND',  'Endingen(Württ)',           8029356, 8.83688000, 48.2573840 ],
	[ 'KENG',  'Engeln',                     8070368, 7.15685300, 50.4249450 ],
	[ 'KENL',  'Engelskirchen',              8001789, 7.40768100, 50.9867190 ],
	[ 'RENG',  'Engen',                      8001790, 8.77278600, 47.8563470 ],
	[ 'KENR',  'Engers',                     8000094, 7.54682700, 50.4259800 ],
	[ 'MEGH',  'Engertsham',                 8001792, 13.3586960, 48.4739180 ],
	[ 'TKL',   'Engstingen',                 8070456, 9.29241900, 48.3922710 ],
	[ 'TENG',  'Engstlatt',                  8001794, 8.87521900, 48.2971190 ],
	[ 'SENK',  'Enkenbach',                  8000372, 7.89950100, 49.4899330 ],
	[ 'EENP',  'Ennepetal',                  8001795, 7.34353300, 51.3047780 ],
	[ 'SEN',   'Ensdorf(Saar)',              8001799, 6.77601500, 49.3028740 ],
	[ 'FENS',  'Enspel',                     8001801, 7.88235300, 50.6164130 ],
	[ 'TENT',  'Entringen',                  8001802, 8.96300700, 48.5522910 ],
	[ 'TEZ',   'Enzberg',                    8001803, 8.79980400, 48.9338830 ],
	[ 'MENW',  'Enzisweiler',                8001806, 9.66542900, 47.5641420 ],
	[ 'EEPE',  'Epe(Westf)',                 8001808, 7.03008700, 52.1834620 ],
	[ 'SEP',   'Eppelborn',                  8001812, 6.96718900, 49.4086570 ],
	[ 'FEPP',  'Eppelsheim(Rheinhess)',      8001813, 8.16288200, 49.7000630 ],
	[ 'FER',   'Eppertshausen',              8001814, 8.84236000, 49.9453680 ],
	[ 'REP',   'Eppingen',                   8000373, 8.91466300, 49.1360010 ],
	[ 'REPW',  'Eppingen West',              8079077, 8.90475900, 49.1326740 ],
	[ 'FEP',   'Eppstein',                   8001815, 8.38764300, 50.1398330 ],
	[ 'FEPB',  'Eppstein-Bremthal',          8001816, 8.36407900, 50.1413960 ],
	[ 'FERO',  'Erbach(Odenw)',              8001817, 8.98982700, 49.6567120 ],
	[ 'FERN',  'Erbach(Odenw) Nord',         8001811, 8.98996300, 49.6695840 ],
	[ 'FERB',  'Erbach(Rheingau)',           8001818, 8.09464600, 50.0232690 ],
	[ 'TER',   'Erbach(Württ)',             8001820, 9.89483300, 48.3259020 ],
	[ 'LER',   'Erdeborn',                   8011496, 11.6369650, 51.4687990 ],
	[ 'MER',   'Erding',                     8001825, 11.9120630, 48.3034600 ],
	[ 'TERD',  'Erdmannhausen',              8001827, 9.29940500, 48.9482290 ],
	[ 'DEA',   'Erdmannsdorf-Augustusburg',  8011497, 13.0839400, 50.8211500 ],
	[ 'MEWG',  'Erdweg',                     8001829, 11.3033050, 48.3337440 ],
	[ 'KEST',  'Erftstadt',                  8003671, 6.83295500, 50.8070930 ],
	[ 'UE  P', 'Erfurt Hbf',                 8010101, 11.0384990, 50.9725510 ],
	[ 'UEN',   'Erfurt Nord',                8010102, 11.0292770, 51.0033570 ],
	[ 'UEO',   'Erfurt Ost',                 8011500, 11.0437700, 51.0145420 ],
	[ 'UEBI',  'Erfurt-Bischleben',          8011502, 10.9884390, 50.9337680 ],
	[ 'UEGI',  'Erfurt-Gispersleben',        8011503, 11.0002770, 51.0221290 ],
	[ 'TEG',   'Ergenzingen',                8001833, 8.80985700, 48.4895340 ],
	[ 'MERB',  'Ergoldsbach',                8001835, 12.2018740, 48.6938680 ],
	[ 'EERG',  'Ergste',                     8001836, 7.57753400, 51.4247050 ],
	[ 'TEK',   'Eriskirch',                  8001838, 9.52667200, 47.6284020 ],
	[ 'KERZ',  'Erkelenz',                   8001839, 6.32172000, 51.0765640 ],
	[ 'NERK',  'Erkersreuth',                8001840, 12.1414940, 50.1866240 ],
	[ 'BERK',  'Erkner',                     8013477, 13.7514570, 52.4283590 ],
	[ 'KER',   'Erkrath',                    8001841, 6.90241200, 51.2204580 ],
	[ 'KERN',  'Erkrath-Nord',               8001842, 6.91064000, 51.2292780 ],
	[ 'DERA',  'Erla',                       8011505, 12.7869400, 50.5198150 ],
	[ 'DERB',  'Erlabrunn(Erzgeb)',          8011506, 12.7204990, 50.4709060 ],
	[ 'NER',   'Erlangen',                   8001844, 11.0019080, 49.5958950 ],
	[ 'NERS', 'Erlangen Paul-Gossen-Straße', 8001846, 10.9993900, 49.5792930 ],
	[ 'NERH', 'Erlangen-Bruck',               8001845, 10.9972610, 49.5706650 ],
	[ 'DER',  'Erlau(Sachs)',                 8011507, 12.9430350, 51.0086300 ],
	[ 'NERL', 'Erlenbach(Main)',              8001848, 9.15443600, 49.8036330 ],
	[ 'EEK',  'Erndtebrück',                 8001851, 8.25531700, 50.9912340 ],
	[ 'MERG', 'Ernsgaden',                    8001853, 11.5732920, 48.7333090 ],
	[ 'FERH', 'Ernsthausen',                  8001854, 8.73161700, 50.9793010 ],
	[ 'UERN', 'Ernstthal am Rennsteig',       8011512, 11.1643120, 50.4965110 ],
	[ 'KERP', 'Erpel(Rhein)',                 8001858, 7.24159400, 50.5820640 ],
	[ 'RERO', 'Erpolzheim',                   8001860, 8.21069700, 49.4883260 ],
	[ 'TERS', 'Ersingen',                     8001861, 8.63856000, 48.9306570 ],
	[ 'TERW', 'Ersingen West',                8079090, 8.63394100, 48.9314330 ],
	[ 'FEZS', 'Erzhausen',                    8001864, 8.65080700, 49.9507310 ],
	[ 'RERZ', 'Erzingen(Baden)',              8001865, 8.43012300, 47.6595410 ],
	[ 'TERZ', 'Erzingen(Württ)',             8029357, 8.81570900, 48.2554090 ],
	[ 'FES',  'Eschborn',                     8001870, 8.56097100, 50.1436180 ],
	[ 'FESS', 'Eschborn Süd',                8001871, 8.57848700, 50.1335630 ],
	[ 'HESD', 'Eschede',                      8001872, 10.2301350, 52.7407840 ],
	[ 'RESN', 'Eschelbronn',                  8007443, 8.86779600, 49.3239820 ],
	[ 'NESU', 'Eschenau(Mittelfr)',           8001875, 11.1986180, 49.5753850 ],
	[ 'TESU', 'Eschenau(b Heilbronn)',        8001874, 9.40273500, 49.1437850 ],
	[ 'NESB', 'Eschenbach(b Markt Erlbach)',  8001877, 10.6716360, 49.4822340 ],
	[ 'MECH', 'Eschenlohe',                   8001880, 11.1879450, 47.6017450 ],
	[ 'NESD', 'Escherndorf-Vogelburg',        8070857, 10.1657910, 49.8667400 ],
	[ 'FEN',  'Eschhofen',                    8001883, 8.10492000, 50.3935860 ],
	[ 'FEG',  'Eschwege',                     8001884, 10.0425860, 51.1917540 ],
	[ 'FONH', 'Eschwege-Niederhone',          8001895, 10.0080730, 51.1962910 ],
	[ 'KE',   'Eschweiler Hbf',               8001886, 6.25193700, 50.8135320 ],
	[ 'KET',  'Eschweiler Talbahnhof',        8001888, 6.26320300, 50.8147590 ],
	[ 'KEN',  'Eschweiler-Nothberg',          8001889, 6.29384600, 50.8128270 ],
	[ 'KESJ', 'Eschweiler-St.Jöris',         8001917, 6.20138700, 50.8345020 ],
	[ 'KWEI', 'Eschweiler-Weisweiler',        8001893, 6.32031800, 50.8241740 ],
	[ 'KEW',  'Eschweiler-West',              8001887, 6.25172100, 50.8177120 ],
	[ 'HESO', 'Esens(Ostfriesl)',             8001890, 7.61621100, 53.6362140 ],
	[ 'HEKP', 'Espelkamp',                    8001894, 8.61335800, 52.3786880 ],
	[ 'FMHF', 'Espenau-Mönchehof',           8004060, 9.45595500, 51.3906740 ],
	[ 'EE',   'Essen Hbf',                    8000098, 7.01479300, 51.4513550 ],
	[ 'EESA', 'Essen Stadtwald',              8001896, 7.02329600, 51.4228530 ],
	[ 'EESD', 'Essen Süd',                   8001897, 7.02309800, 51.4392950 ],
	[ 'EENW', 'Essen West',                   8001898, 6.97979800, 51.4544970 ],
	[ 'HESN', 'Essen(Oldb)',                  8001899, 7.94543700, 52.7238820 ],
	[ 'EEAL', 'Essen-Altenessen',             8001900, 7.00725200, 51.4843700 ],
	[ 'EEBE', 'Essen-Bergeborbeck',           8001901, 6.97711100, 51.4803960 ],
	[ 'EEBB', 'Essen-Borbeck',                8001902, 6.94846100, 51.4731030 ],
	[ 'EEBS', 'Essen-Borbeck Süd',           8005031, 6.95392200, 51.4616730 ],
	[ 'EEDL', 'Essen-Dellwig',                8001903, 6.92226900, 51.4879230 ],
	[ 'EEDO', 'Essen-Dellwig Ost',            8001904, 6.92721100, 51.4876040 ],
	[ 'EEIB', 'Essen-Eiberg',                 8001905, 7.10969100, 51.4418140 ],
	[ 'EEFO', 'Essen-Frohnhausen',            8001906, 6.96528500, 51.4551130 ],
	[ 'EEGE', 'Essen-Gerschede',              8001907, 6.94330900, 51.4830360 ],
	[ 'EEHH', 'Essen-Holthausen',             8006514, 7.07264900, 51.4177110 ],
	[ 'EEHT', 'Essen-Horst',                  8006194, 7.10274100, 51.4312140 ],
	[ 'EEHU', 'Essen-Hügel',                 8001908, 7.00824300, 51.4045010 ],
	[ 'EEKN', 'Essen-Kray Nord',              8001910, 7.08047600, 51.4694300 ],
	[ 'EEKS', 'Essen-Kray Süd',              8001911, 7.07465500, 51.4580550 ],
	[ 'EEKU', 'Essen-Kupferdreh',             8001912, 7.08024700, 51.3909450 ],
	[ 'EEST', 'Essen-Steele',                 8000099, 7.07555200, 51.4506840 ],
	[ 'EESO', 'Essen-Steele Ost',             8001913, 7.08856100, 51.4442010 ],
	[ 'EEWD', 'Essen-Werden',                 8001915, 6.99784500, 51.3868280 ],
	[ 'EEKB', 'Essen-Zollverein Nord',        8001909, 7.04674400, 51.4936090 ],
	[ 'EEUE', 'Essen-Überruhr',              8001914, 7.06871600, 51.4285410 ],
	[ 'TE',   'Esslingen(Neckar)',            8001920, 9.30008000, 48.7388100 ],
	[ 'TEME', 'Esslingen-Mettingen',          8001921, 9.27583000, 48.7470830 ],
	[ 'TEZL', 'Esslingen-Zell',               8006642, 9.35938900, 48.7243280 ],
	[ 'MESG', 'Esting',                       8001996, 11.3173220, 48.2121960 ],
	[ 'HETL', 'Etelsen',                      8001924, 9.12374500, 52.9992030 ],
	[ 'UEH',  'Ettenhausen',                  8011519, 10.2322510, 50.8745630 ],
	[ 'NET',  'Etterzhausen',                 8001925, 11.9780310, 49.0306090 ],
	[ 'RETT', 'Ettlingen Stadt',              8007007, 8.40910600, 48.9386170 ],
	[ 'RETL', 'Ettlingen West',               8001926, 8.38787800, 48.9471820 ],
	[ 'EEZB', 'Etzbach',                      8001928, 7.69026400, 50.7812820 ],
	[ 'NEW',  'Etzelwang',                    8001929, 11.5864080, 49.5255250 ],
	[ 'REZB', 'Etzenbach',                    8007334, 7.74888900, 47.8667700 ],
	[ 'NEZ',  'Etzenricht',                   8001932, 12.0982910, 49.6288170 ],
	[ 'RETZ', 'Etzenrot',                     8007008, 8.45762300, 48.9142090 ],
	[ 'UET',  'Etzleben',                     8011520, 11.1811280, 51.2580770 ],
	[ 'TEU',  'Eubigheim',                    8001933, 9.53801500, 49.5017320 ],
	[ 'NEU',  'Euerdorf',                     8001935, 10.0276330, 50.1495350 ],
	[ 'KEU',  'Euskirchen',                   8000100, 6.79219300, 50.6577600 ],
	[ 'KZU',  'Euskirchen Zuckerfabrik',      8006673, 6.81325600, 50.6568700 ],
	[ 'KGBU', 'Euskirchen-Großbüllesheim',  8002402, 6.81618800, 50.6867470 ],
	[ 'KKRW', 'Euskirchen-Kreuzweingarten',   8003440, 6.79605500, 50.6130540 ],
	[ 'KKUH', 'Euskirchen-Kuchenheim',        8003462, 6.83447800, 50.6556020 ],
	[ 'KSTZ', 'Euskirchen-Stotzheim',         8005748, 6.81077300, 50.6338590 ],
	[ 'AEU',  'Eutin',                        8001941, 10.6101230, 54.1353430 ],
	[ 'TET',  'Eutingen im Gäu',             8000101, 8.78223600, 48.4799520 ],
	[ 'TEB',  'Eutingen(Baden)',              8001942, 8.74377200, 48.9098460 ],
	[ 'LEU',  'Eutzsch',                      8011522, 12.6384660, 51.8275340 ],
	[ 'TEY',  'Eyach',                        8001946, 8.78310100, 48.4462880 ],
	[ 'HETR', 'Eystrup',                      8001949, 9.23139000, 52.7833690 ],
	[ 'NEN',  'Eßleben',                     8001919, 10.0852250, 49.9431010 ],
	[ 'FFAN', 'Fachingen(Lahn)',              8001950, 7.99256600, 50.3617810 ],
	[ 'AFK',  'Fahrenkrug',                   8001953, 10.2531590, 53.9439620 ],
	[ 'RFN',  'Fahrnau',                      8001954, 7.83942500, 47.6615600 ],
	[ 'DFU',  'Falkenau(Sachs)Hp',            8011528, 13.1184020, 50.8546850 ],
	[ 'DFUS', 'Falkenau(Sachs)Süd',          8011529, 13.1102630, 50.8493500 ],
	[ 'LF',   'Falkenberg(Elster)',           8010103, 13.2476850, 51.5836200 ],
	[ 'LF  O', 'Falkenberg(Elster)', 8010103, 13.2476850, 51.5836200 ],
	[ 'LF  U', 'Falkenberg(Elster)', 8010103, 13.2476850, 51.5836200 ],
	[ 'WFBG',  'Falkenberg(Mark)',   8011531, 13.9599850, 52.8081760 ],
	[
		'WFAP', 'Falkenhagen Gewerbepark Prignitz',
		8017346, 12.2147540, 53.2057520
	],
	[ 'BFKS', 'Falkensee',                   8013479, 13.0896360, 52.5597720 ],
	[ 'DFA',  'Falkenstein(Vogtl)',          8010106, 12.3616980, 50.4792350 ],
	[ 'HF',   'Fallersleben',                8001957, 10.7173250, 52.4234960 ],
	[ 'BFS',  'Fangschleuse',                8011533, 13.8249260, 52.4067250 ],
	[ 'MFCH', 'Farchant',                    8001961, 11.1148600, 47.5309700 ],
	[ 'MFP',  'Fasanenpark',                 8001963, 11.6093780, 48.0797130 ],
	[ 'NFCH', 'Faulbach(Main)',              8001964, 9.43761400, 49.7869320 ],
	[ 'TFAU', 'Faurndau',                    8001965, 9.61604700, 48.7108070 ],
	[ 'TFV',  'Favoritepark',                8001967, 9.18023300, 48.9092090 ],
	[ 'ABUF', 'Fehmarn-Burg',                8001274, 11.1889800, 54.4435910 ],
	[ 'NFZ',  'Feilitzsch',                  8001969, 11.9340340, 50.3643240 ],
	[ 'MFA',  'Feldafing',                   8001970, 11.2902240, 47.9469380 ],
	[ 'RFB',  'Feldberg-Bärental',          8001971, 8.09829400, 47.8714440 ],
	[ 'AFEB', 'Felde',                       8001977, 9.94701800, 54.3098470 ],
	[ 'EFEL', 'Feldhausen',                  8001972, 6.97321600, 51.6149530 ],
	[ 'MFK',  'Feldkirchen(b München)',     8001973, 11.7321030, 48.1518460 ],
	[ 'TFE',  'Fellbach',                    8001974, 9.26997800, 48.8200490 ],
	[ 'FABL', 'Felsberg-Altenbrunslar',      8000520, 9.44546200, 51.1652270 ],
	[ 'FGEF', 'Felsberg-Gensungen',          8002236, 9.43563000, 51.1311220 ],
	[ 'FWON', 'Felsberg-Wolfershausen',      8006546, 9.45006000, 51.1865520 ],
	[ 'BFLZ', 'Ferch-Lienewitz',             8013480, 12.9640730, 52.3035530 ],
	[ 'WFDF', 'Ferdinandshof',               8011536, 13.8819130, 53.6600870 ],
	[ 'LFMW', 'Fermerswalde',                8011537, 13.1735890, 51.6429980 ],
	[ 'EFER', 'Ferndorf(Siegen)',            8001976, 8.00922700, 50.9594530 ],
	[ 'NFT',  'Feucht',                      8001978, 11.2042070, 49.3819470 ],
	[ 'NFTO', 'Feucht Ost',                  8001988, 11.2205020, 49.3760320 ],
	[ 'NFTM', 'Feucht-Moosbach',             8002520, 11.2609010, 49.3879130 ],
	[ 'MFWG', 'Feuchtwangen Bf',             8070601, 10.3240170, 49.1687210 ],
	[ 'EFEU', 'Feudingen',                   8001980, 8.32933700, 50.9407970 ],
	[ 'TFI',  'Fichtenberg',                 8001982, 9.70076300, 48.9873460 ],
	[ 'TFIL', 'Filderstadt',                 8001984, 9.21770900, 48.6764930 ],
	[ 'FFI',  'Filsen',                      8001983, 7.58350900, 50.2388940 ],
	[ 'BFIH', 'Finkenheerd',                 8011540, 14.5695950, 52.2494190 ],
	[ 'BFIN', 'Finkenkrug',                  8011541, 13.0512550, 52.5696630 ],
	[ 'EFP',  'Finnentrop',                  8000102, 7.96456300, 51.1730480 ],
	[ 'MFNS', 'Finningerstraße',            8001985, 10.0262280, 48.3899930 ],
	[ 'BFW',  'Finsterwalde(Niederlausitz)', 8011542, 13.7103880, 51.6370010 ],
	[ 'NFIH', 'Fischbach(Nürnberg)',        8001989, 11.1740700, 49.4133400 ],
	[ 'SFC',  'Fischbach-Camphausen',        8001990, 7.03113200, 49.3047440 ],
	[ 'SFWB', 'Fischbach-Weierbach',         8001991, 7.40467100, 49.7389010 ],
	[ 'MFBU', 'Fischbachau',                 8001992, 11.9340510, 47.7056050 ],
	[ 'MFN',  'Fischen',                     8001995, 10.2717170, 47.4565910 ],
	[ 'NFHA', 'Fischhaus',                   8070806, 13.4408260, 48.6554030 ],
	[ 'MFIN', 'Fischhausen-Neuhaus',         8001998, 11.8741340, 47.7061940 ],
	[ 'NFD',  'Fladungen',                   8002001, 10.1506910, 50.5195510 ],
	[ 'LFG',  'Flechtingen',                 8011544, 11.2613520, 52.3479680 ],
	[ 'LFL',  'Fleetmark',                   8011545, 11.3786930, 52.7908020 ],
	[ 'RFL',  'Flehingen',                   8002005, 8.78272700, 49.0845950 ],
	[ 'AF',   'Flensburg',                   8000103, 9.43652600, 54.7740390 ],
	[ 'FFD',  'Flieden',                     8002010, 9.57661600, 50.4213820 ],
	[ 'AFT',  'Flintbek',                    8002011, 10.0629130, 54.2433490 ],
	[ 'MFLI', 'Flintsbach',                  8002012, 12.1280240, 47.7242520 ],
	[ 'RFLO', 'Flomersheim',                 8002014, 8.33380100, 49.5139580 ],
	[ 'DFM',  'Floßmühle',                 8011548, 13.1810820, 50.7587570 ],
	[ 'DFL',  'Flöha',                      8010108, 13.0751520, 50.8543550 ],
	[ 'DFLP', 'Flöha-Plaue',                8010128, 13.0850070, 50.8444890 ],
	[ 'FFH',  'Flörsheim(Main)',            8002013, 8.43101300, 50.0172110 ],
	[ 'LFDE', 'Fohrde',                      8011550, 12.4628200, 52.4841480 ],
	[ 'RFCH', 'Forbach(Schwarzw)',           8002022, 8.36149100, 48.6803990 ],
	[ 'NFO',  'Forchheim(Oberfr)',           8002024, 11.0698590, 49.7170700 ],
	[ 'RFM',  'Forchheim(b Karlsruhe)',      8002023, 8.33893400, 48.9647850 ],
	[ 'TFB',  'Fornsbach',                   8002026, 9.64249800, 48.9754450 ],
	[ 'BFO',  'Forst(Lausitz)',              8010111, 14.6376280, 51.7388820 ],
	[ 'KFOS', 'Forsthaus',                   8002027, 6.50349800, 51.3034120 ],
	[ 'MFOS', 'Forsting',                    8002028, 12.0914480, 48.0818640 ],
	[ 'NFH',  'Forth',                       8002029, 11.2214570, 49.5916980 ],
	[ 'NFHB', 'Frahelsbruck',                8007344, 13.0274540, 49.1911450 ],
	[ 'FFRK', 'Frankenberg(Eder)',           8000104, 8.78918100, 51.0545650 ],
	[ 'DFK',  'Frankenberg(Sachs)',          8011553, 13.0431910, 50.9112330 ],
	[ 'DFKS', 'Frankenberg(Sachs) Süd',     8011554, 13.0363780, 50.9027840 ],
	[ 'FFRG', 'Frankenberg-Goßberg',        8002033, 8.79932600, 51.0649980 ],
	[ 'FVI',  'Frankenberg-Viermünden',     8006082, 8.83307000, 51.1009370 ],
	[ 'RFST', 'Frankenstein(Pfalz)',         8002036, 7.96980200, 49.4388670 ],
	[ 'DFRS', 'Frankenstein(Sachs)',         8011556, 13.2282540, 50.9025200 ],
	[ 'RFT',  'Frankenthal Hbf',             8000332, 8.34970200, 49.5355670 ],
	[ 'RFTS', 'Frankenthal Süd',            8002025, 8.34955800, 49.5226490 ],
	[ 'FFT',  'Frankfurt Hbf (tief)',        8098105, 8.66413700, 50.1074070 ],
	[ 'FSP',  'Frankfurt am Main - Stadion', 8002040, 8.63324700, 50.0682280 ],
	[
		'FFLF', 'Frankfurt(M) Flughafen Fernbf', 8070003, 8.57018500,
		50.0531670
	],
	[
		'FFLU', 'Frankfurt(M) Flughafen Regionalbf',
		8070004, 8.57125100, 50.0512190
	],
	[ 'FFGA', 'Frankfurt(M)Galluswarte',     8006690, 8.64472000, 50.1040300 ],
	[ 'FHAU', 'Frankfurt(M)Hauptwache',      8006692, 8.67894700, 50.1139260 ],
	[ 'FKON', 'Frankfurt(M)Konstablerwache', 8004429, 8.68709800, 50.1146230 ],
	[ 'FLBF', 'Frankfurt(M)Lokalbahnhof',    8002038, 8.69302500, 50.1021710 ],
	[ 'FMUL', 'Frankfurt(M)Mühlberg',       8002034, 8.70150400, 50.1016090 ],
	[ 'FOST', 'Frankfurt(M)Ostendstraße',   8002058, 8.69698700, 50.1125620 ],
	[ 'FSTL', 'Frankfurt(M)Stresemannallee', 8002059, 8.67124800, 50.0944380 ],
	[ 'FFTA', 'Frankfurt(M)Taunusanlage',    8006691, 8.66886400, 50.1135650 ],
	[ 'FF',   'Frankfurt(Main)Hbf',          8000105, 8.66378900, 50.1071450 ],
	[ 'FFME', 'Frankfurt(Main)Messe',        8079632, 8.64337400, 50.1120040 ],
	[ 'FFO',  'Frankfurt(Main)Ost',          8002039, 8.70864000, 50.1125740 ],
	[ 'FFS',  'Frankfurt(Main)Süd',         8002041, 8.68645700, 50.0993650 ],
	[ 'FFW',  'Frankfurt(Main)West',         8002042, 8.63933500, 50.1188640 ],
	[ 'BFP',  'Frankfurt(Oder)',             8010113, 14.5464960, 52.3364160 ],
	[
		'BFPN',  'Frankfurt(Oder)-Neuberesinchen',
		8011557, 14.5460500,
		52.3223290
	],
	[ 'BFRS',  'Frankfurt(Oder)-Rosengarten', 8011559, 14.4726310, 52.3377690 ],
	[ 'FFBK',  'Frankfurt-Berkersheim',       8002043, 8.69782700, 50.1764860 ],
	[ 'FFES',  'Frankfurt-Eschersheim',       8002045, 8.65543100, 50.1585830 ],
	[ 'FFBS',  'Frankfurt-Frankfurter Berg',  8002044, 8.67655100, 50.1702660 ],
	[ 'FGM',   'Frankfurt-Griesheim',         8002046, 8.60639400, 50.0943340 ],
	[ 'FHOE',  'Frankfurt-Höchst',           8000106, 8.54237000, 50.1026340 ],
	[ 'FFAW',  'Frankfurt-Höchst Farbwerke', 8002051, 8.52873200, 50.0985580 ],
	[ 'FLS',   'Frankfurt-Louisa',            8002047, 8.67036900, 50.0839560 ],
	[ 'FLSS',  'Frankfurt-Louisa',            8002047, 8.67036900, 50.0839560 ],
	[ 'FFMK',  'Frankfurt-Mainkur',           8002048, 8.76743700, 50.1346030 ],
	[ 'FFND',  'Frankfurt-Nied',              8002049, 8.57073400, 50.1025190 ],
	[ 'FNI',   'Frankfurt-Niederrad',         8002050, 8.63707500, 50.0812830 ],
	[ 'FNI S', 'Frankfurt-Niederrad',         8002050, 8.63707500, 50.0812830 ],
	[ 'FRH',   'Frankfurt-Rödelheim',        8002052, 8.60702600, 50.1246150 ],
	[ 'FSIN',  'Frankfurt-Sindlingen',        8002053, 8.51225900, 50.0874970 ],
	[ 'FSINO', 'Frankfurt-Sindlingen',        8002053, 8.51225900, 50.0874970 ],
	[ 'FSO',   'Frankfurt-Sossenheim',        8002054, 8.55352600, 50.1150740 ],
	[ 'FULB',  'Frankfurt-Unterliederbach',   8007158, 8.52802400, 50.1079110 ],
	[ 'FFZH',  'Frankfurt-Zeilsheim',         8002055, 8.50601100, 50.0901240 ],
	[ 'LFA',   'Frankleben',                  8011560, 11.9375820, 51.3095610 ],
	[ 'RFS',   'Frauenalb-Schielberg',        8007010, 8.44049200, 48.8372940 ],
	[ 'NFU',   'Frauenau',                    8002057, 13.3000480, 48.9876530 ],
	[ 'BFR',   'Frauenhain',                  8011563, 13.5036360, 51.3842230 ],
	[ 'KFKO',  'Frechen-Königsdorf',         8002389, 6.77784600, 50.9365010 ],
	[ 'LFK',   'Freckleben',                  8011564, 11.5441300, 51.7023650 ],
	[ 'HFRE',  'Freden(Leine)',               8002063, 9.89900600, 51.9277870 ],
	[ 'BFD',   'Fredersdorf(b Berlin)',       8080440, 13.7606280, 52.5262120 ],
	[ 'TFG',   'Freiberg(Neckar)',            8002065, 9.19779600, 48.9301070 ],
	[ 'DFR',   'Freiberg(Sachs)',             8010115, 13.3441410, 50.9087250 ],
	[ 'RFK',   'Freiburg Klinikum',           8002077, 7.84275500, 48.0055620 ],
	[ 'RFMU',  'Freiburg Messe/Universität', 8000453, 7.83266800, 48.0129180 ],
	[ 'RFW',   'Freiburg West',               8002066, 7.81288200, 48.0273260 ],
	[ 'RF',    'Freiburg(Breisgau) Hbf',      8000107, 7.84117000, 47.9976970 ],
	[ 'RFHE',  'Freiburg-Herdern',            8002067, 7.85097300, 48.0082370 ],
	[ 'RFLT',  'Freiburg-Littenweiler',       8002068, 7.89513300, 47.9816720 ],
	[ 'RFSG',  'Freiburg-St Georgen',         8002069, 7.80300600, 47.9754960 ],
	[ 'RFWI',  'Freiburg-Wiehre',             8002070, 7.85412700, 47.9824130 ],
	[ 'RFZ',   'Freiburg-Zähringen',         8002071, 7.86373400, 48.0243630 ],
	[ 'EFRE',  'Freienohl',                   8002073, 8.16948400, 51.3664220 ],
	[ 'UFO',   'Freienorla',                  8011567, 11.5401390, 50.7713820 ],
	[ 'MFHD',  'Freihalden',                  8002074, 10.5022000, 48.3847040 ],
	[ 'NFRE',  'Freihung',                    8002076, 11.9028790, 49.6272210 ],
	[ 'NFR',   'Freihöls',                   8002075, 12.0203160, 49.4013700 ],
	[ 'MFL',   'Freilassing',                 8000108, 12.9771930, 47.8369160 ],
	[ 'MFLH',  'Freilassing-Hofham',          8002085, 12.9680670, 47.8314490 ],
	[ 'FFRH',  'Freimersheim(Rheinh)',        8000340, 8.08650800, 49.7107770 ],
	[ 'RFHM',  'Freinsheim',                  8000374, 8.20519200, 49.5014930 ],
	[ 'MFR',   'Freising',                    8002078, 11.7445390, 48.3951950 ],
	[ 'DFCO',  'Freital-Coßmannsdorf',       8011568, 13.6249520, 50.9768760 ],
	[ 'DFD',   'Freital-Deuben',              8011569, 13.6464320, 50.9993580 ],
	[ 'DFH',   'Freital-Hainsberg',           8010116, 13.6379380, 50.9888980 ],
	[ 'DHG',   'Freital-Hainsberg',           8010116, 13.6379380, 50.9888980 ],
	[ 'DHGW',  'Freital-Hainsberg West',      8011570, 13.6227140, 50.9810830 ],
	[ 'DPA',   'Freital-Potschappel',         8013445, 13.6625520, 51.0138940 ],
	[ 'HFST',  'Frellstedt',                  8002080, 10.9099940, 52.2137490 ],
	[ 'AFF',   'Frelsdorf',                   8007804, 8.90128300, 53.5013050 ],
	[ 'MFRD',  'Fremdingen Bf',               8070392, 10.4602870, 48.9712780 ],
	[ 'SFF',   'Fremersdorf',                 8002083, 6.64786700, 49.4100830 ],
	[ 'LFZ',   'Frenz',                       8011571, 11.8989330, 51.7491940 ],
	[ 'AFN',   'Fresenburg',                  8002086, 10.3905840, 53.8425990 ],
	[ 'WFD',   'Fretzdorf',                   8011572, 12.5398850, 53.0693020 ],
	[ 'NFM',   'Freudenberg-Kirschfurt',      8002089, 9.31798100, 49.7437550 ],
	[ 'TFS',   'Freudenstadt Hbf',            8000110, 8.42880300, 48.4603220 ],
	[ 'TFSI', 'Freudenstadt Industriegebiet', 8002087, 8.43494100, 48.4649670 ],
	[ 'TFSZ', 'Freudenstadt Schulzentrum',    8002090, 8.42141900, 48.4674060 ],
	[ 'TFSS', 'Freudenstadt Stadt',           8002091, 8.41069400, 48.4675660 ],
	[ 'EFBU', 'Freusburg Siedlung',           8002092, 7.89725300, 50.8159830 ],
	[ 'UFB B', 'Freyburg(Unstrut)',           8011573, 11.7673130, 51.2090790 ],
	[ 'NFY',   'Freyung Bf',                  8002094, 13.5483510, 48.8028430 ],
	[ 'TFKH',  'Frickenhausen',               8007446, 9.35801000, 48.5953690 ],
	[ 'TFKHK', 'Frickenhausen Kelterstraße', 8090022, 9.36447900, 48.5920570 ],
	[ 'FFRN',  'Frickhofen',                  8002095, 8.03067600, 50.5049080 ],
	[ 'TFD',   'Fridingen(b Tuttlingen)',     8002096, 8.93606000, 48.0318220 ],
	[ 'MFDF',  'Fridolfing',                  8002097, 12.7996890, 47.9842030 ],
	[ 'FGS',   'Friedberg Süd',              8002105, 8.74764600, 50.3202790 ],
	[ 'MFDB',  'Friedberg(Augsburg)',         8002099, 10.9824870, 48.3520430 ],
	[ 'FFG',   'Friedberg(Hess)',             8000111, 8.76205600, 50.3326060 ],
	[ 'FFN',   'Friedelhausen',               8002100, 8.71096100, 50.6716070 ],
	[ 'FFRD',  'Friedensdorf(Lahn)',          8002101, 8.56074700, 50.8574590 ],
	[
		'BFDF', 'Friedersdorf(Königs Wusterhausen)',
		8011574, 13.7865180, 52.2895630
	],
	[ 'DFW',  'Friedewald(Kr Dresden) Bad',   8011575, 13.6624220, 51.1379480 ],
	[ 'DFWH', 'Friedewald(Kr Dresden)Hp',     8011576, 13.6518730, 51.1313010 ],
	[ 'HFRI', 'Friedland(Han)',               8002102, 9.91474600, 51.4215620 ],
	[ 'KFWH', 'Friedrich Wilhelmshütte',     8002104, 7.15938200, 50.8020440 ],
	[ 'UFR',  'Friedrichroda',                8011578, 10.5766850, 50.8621510 ],
	[ 'FFRI', 'Friedrichsdorf(Taunus)',       8002108, 8.64477600, 50.2524900 ],
	[ 'EFFD', 'Friedrichsfeld(Niederrhein)',  8002109, 6.64549900, 51.6284860 ],
	[ 'AFRG', 'Friedrichsgabe',               8079024, 9.98886000, 53.7288760 ],
	[ 'TFFL', 'Friedrichshafen Flughafen',    8002120, 9.52371400, 47.6722130 ],
	[ 'TFH',  'Friedrichshafen Hafen',        8002110, 9.48281900, 47.6512080 ],
	[ 'TFLA', 'Friedrichshafen Landratsamt',  8002122, 9.45198800, 47.6571460 ],
	[ 'TFOS', 'Friedrichshafen Ost',          8002030, 9.50201800, 47.6517060 ],
	[ 'TF',   'Friedrichshafen Stadt',        8000112, 9.47390000, 47.6532240 ],
	[ 'TFF',  'Friedrichshafen-Fischbach',    8002111, 9.41738300, 47.6724810 ],
	[ 'TKLU', 'Friedrichshafen-Kluftern',     8003345, 9.40951500, 47.6881490 ],
	[ 'TMAN', 'Friedrichshafen-Manzell',      8003850, 9.42915600, 47.6643200 ],
	[ 'LFH',  'Friedrichshöhe',              8017009, 10.9376180, 51.6396260 ],
	[ 'AFRD', 'Friedrichsruh',                8002113, 10.3396710, 53.5281220 ],
	[ 'WFRR', 'Friedrichsruhe(Meck)',         8011582, 11.7390880, 53.5248020 ],
	[ 'KFGN', 'Friedrichssegen',              8002114, 7.65084000, 50.3126190 ],
	[ 'AFD',  'Friedrichstadt',               8002115, 9.07925800, 54.3774870 ],
	[ 'RFRT', 'Friedrichstal b Freudenstadt', 8002126, 8.37692600, 48.4818050 ],
	[ 'RFTL', 'Friedrichstal(Baden)',         8002116, 8.47427800, 49.1012990 ],
	[ 'SFI',  'Friedrichsthal(Saar)',         8002117, 7.08913000, 49.3200610 ],
	[ 'SFIM', 'Friedrichsthal(Saar) Mitte',   8002132, 7.09391600, 49.3271600 ],
	[ 'NFSB', 'Friedrichsthal(b Bayreuth)',   8002118, 11.6278330, 49.9625980 ],
	[ 'WFRK', 'Friesack(Mark)',               8011585, 12.5875420, 52.7607120 ],
	[ 'RFH',  'Friesenheim(Baden)',           8002123, 7.86294800, 48.3815890 ],
	[ 'KFRI', 'Frimmersdorf',                 8002127, 6.56647500, 51.0457010 ],
	[ 'FFZ',  'Fritzlar',                     8002129, 9.28208900, 51.1252230 ],
	[ 'LFB',  'Frohburg',                     8011588, 12.5592880, 51.0691590 ],
	[ 'TFR',  'Frommern',                     8002133, 8.87212200, 48.2440340 ],
	[ 'FFRL', 'Fronhausen(Lahn)',             8002134, 8.69865100, 50.7063330 ],
	[ 'LFE',  'Frose',                        8010119, 11.3748430, 51.7936360 ],
	[ 'EFRM', 'Frömern',                     8002130, 7.73592900, 51.4992630 ],
	[ 'EFOE', 'Fröndenberg',                 8000113, 7.76219800, 51.4712540 ],
	[ 'UFT',  'Fröttstädt',                 8010118, 10.5730190, 50.9303570 ],
	[ 'FFU',  'Fulda',                        8000115, 9.68397700, 50.5547230 ],
	[ 'FIH',  'Fuldatal-Ihringshausen',       8003053, 9.52607000, 51.3485910 ],
	[ 'RFU',  'Furschenbach',                 8007005, 8.13517800, 48.5797670 ],
	[ 'NFW',  'Furth i Wald',                 8002159, 12.8388110, 49.3098120 ],
	[ 'MFU',  'Furth(b Deisenhofen)',         8002161, 11.5932810, 48.0355210 ],
	[ 'DFBE', 'Fährbrücke',                 8011524, 12.6197220, 50.6501240 ],
	[ 'SFOE', 'Föhren',                      8002018, 6.76753100, 49.8570990 ],
	[ 'NFOE', 'Förbau',                      8002019, 11.9106850, 50.2075190 ],
	[ 'LFD',  'Förderstedt',                 8011549, 11.6337570, 51.9035170 ],
	[ 'UF',   'Förtha(Eisenach)',            8010110, 10.2620070, 50.9388530 ],
	[ 'NFDF', 'Förtschendorf',               8002020, 11.3501280, 50.3929010 ],
	[ 'FFUR', 'Fürfurt',                     8002137, 8.25313800, 50.4304920 ],
	[ 'WF',   'Fürstenberg(Havel)',          8010399, 13.1392730, 53.1867840 ],
	[ 'NFUE', 'Fürsteneck',                  8070809, 13.4699220, 48.7184310 ],
	[ 'MFB',  'Fürstenfeldbruck',            8002141, 11.2621480, 48.1716560 ],
	[ 'FFNW', 'Fürstenwald',                 8002145, 9.35956700, 51.3803590 ],
	[ 'BFUS', 'Fürstenwalde Süd',           8011591, 14.0866090, 52.3418950 ],
	[ 'BFUW', 'Fürstenwalde(Spree)',         8010120, 14.0596400, 52.3668580 ],
	[ 'MFZL', 'Fürstenzell',                 8002146, 13.3338170, 48.5131800 ],
	[ 'NFWS', 'Fürth Westvorstadt',          8002149, 10.9713950, 49.4687990 ],
	[ 'NF',   'Fürth(Bay)Hbf',               8000114, 10.9899880, 49.4697070 ],
	[ 'RFUE', 'Fürth(Odenw)',                8002150, 8.78100300, 49.6485340 ],
	[ 'NFBB', 'Fürth-Burgfarrnbach',         8002152, 10.9236270, 49.4910330 ],
	[ 'NFDB', 'Fürth-Dambach',               8002153, 10.9701960, 49.4607400 ],
	[ 'NFKL', 'Fürth-Unterfarrnbach',        8002154, 10.9671910, 49.4831880 ],
	[ 'NFUB', 'Fürth-Unterfarrnbach',        8002154, 10.9671910, 49.4831880 ],
	[ 'NFUF', 'Fürth-Unterfürberg',         8002155, 10.9575320, 49.4749140 ],
	[ 'MFSN', 'Füssen',                      8002156, 10.6978130, 47.5704970 ],
	[ 'MGAL', 'Gablingen',                    8002162, 10.8507520, 48.4634170 ],
	[ 'WGA',  'Gadebusch',                    8011592, 11.1214850, 53.7040660 ],
	[ 'RGG',  'Gaggenau Bf',                  8002167, 8.31997700, 48.8057720 ],
	[ 'RDAI', 'Gaggenau Mercedes-Benz Werk',  8006733, 8.32747600, 48.7980380 ],
	[ 'TGAW', 'Gaildorf West',                8002168, 9.75389200, 49.0038220 ],
	[ 'MGH',  'Gaimersheim',                  8002171, 11.3697900, 48.7987890 ],
	[ 'MGAI', 'Gaißach',                     8002173, 11.5754010, 47.7374670 ],
	[ 'SGSZ', 'Galgenschanze',                8002175, 7.74412400, 49.4354900 ],
	[ 'TGAM', 'Gamburg(Tauber)',              8002177, 9.59558000, 49.6982970 ],
	[ 'TGMT', 'Gammertingen',                 8007229, 9.21714900, 48.2506990 ],
	[ 'TGME', 'Gammertingen Europastraße',   8070382, 9.21045200, 48.2429440 ],
	[ 'HGKE', 'Ganderkesee',                  8002179, 8.54277700, 53.0352510 ],
	[ 'UGSM', 'Gangloffsömmern',             8011594, 10.9548560, 51.1914730 ],
	[ 'EGAR', 'Garbeck',                      8002180, 7.83990300, 51.3214590 ],
	[ 'FGA',  'Garbenteich',                  8002182, 8.74527300, 50.5402880 ],
	[ 'MGA',  'Garching(Alz)',                8002184, 12.5729900, 48.1303710 ],
	[ 'LGA',  'Gardelegen',                   8011596, 11.4045360, 52.5183760 ],
	[ 'AGD',  'Garding',                      8002185, 8.78378300, 54.3270140 ],
	[ 'WGFZ', 'Garftitz',                     8011597, 13.6378470, 54.3777100 ],
	[ 'MGP',  'Garmisch-Partenkirchen',       8002187, 11.0970130, 47.4914520 ],
	[
		'MGPH', 'Garmisch-Partenkirchen Hausberg',
		8002188, 11.0923430, 47.4834870
	],
	[ 'MGS',   'Gars(Inn)',                   8002189, 12.2985500, 48.1475400 ],
	[ 'LGAL',  'Gatersleben',                 8011599, 11.2913620, 51.8281110 ],
	[ 'FGAL',  'Gau Algesheim',               8000375, 8.01606500, 49.9614320 ],
	[ 'FGBM',  'Gau Bickelheim',              8002191, 8.02029100, 49.8402920 ],
	[ 'TGRN',  'Gaubüttelbrunn',             8002195, 9.85458400, 49.6343190 ],
	[ 'RGBA',  'Gausbach',                    8002197, 8.36237200, 48.6867530 ],
	[ 'TGSF',  'Gauselfingen',                8007227, 9.16421900, 48.2758210 ],
	[ 'MGT',   'Gauting',                     8002198, 11.3761460, 48.0706580 ],
	[ 'UGBH',  'Gebra(Hainleite)',            8011602, 10.5953880, 51.4271550 ],
	[ 'HGEE',  'Geeste',                      8002203, 7.31204400, 52.5980940 ],
	[ 'AGTH',  'Geestenseth',                 8007805, 8.85837300, 53.5067320 ],
	[ 'LGG',   'Geestgottberg',               8010121, 11.7369570, 52.9557430 ],
	[ 'UGB',   'Gehlberg',                    8011603, 10.7693510, 50.6837680 ],
	[ 'NGET',  'Geigant',                     8002205, 12.6814240, 49.3233540 ],
	[ 'KGEK',  'Geilenkirchen',               8002206, 6.12451800, 50.9610390 ],
	[ 'KGKK',  'Geilenkirchen',               8002206, 6.12451800, 50.9610390 ],
	[ 'KGEH',  'Geilhausen',                  8002207, 7.63866700, 50.7715700 ],
	[ 'MGLG',  'Geiselhöring',               8002209, 12.3920770, 48.8223920 ],
	[ 'MGIB',  'Geisenbrunn',                 8002210, 11.3248470, 48.1091570 ],
	[ 'MGHS',  'Geisenhausen',                8002211, 12.2483270, 48.4739600 ],
	[ 'FGSM',  'Geisenheim',                  8002212, 7.96880400, 49.9859730 ],
	[ 'DGEI',  'Geising',                     8011609, 13.7860640, 50.7606990 ],
	[ 'RGSN',  'Geisingen',                   8002214, 8.65395100, 47.9213420 ],
	[ 'RGA',   'Geisingen-Aulfingen',         8002200, 8.66161100, 47.8864080 ],
	[ 'RGHA',  'Geisingen-Hausen',            8002204, 8.67860200, 47.9124450 ],
	[ 'RGK',   'Geisingen-Kirchen',           8002213, 8.67434500, 47.9050620 ],
	[ 'RGL',   'Geisingen-Leipferdingen',     8002215, 8.65468700, 47.8691730 ],
	[ 'TG',    'Geislingen(Steige)',          8002218, 9.84194100, 48.6193580 ],
	[ 'TGW',   'Geislingen(Steige)West',      8002217, 9.82190900, 48.6307660 ],
	[ 'MGEU',  'Geitau',                      8002220, 11.9664030, 47.6938870 ],
	[ 'LGH',   'Geithain',                    8010122, 12.6974550, 51.0582170 ],
	[ 'WGE',   'Gelbensande',                 8011611, 12.3048090, 54.1986960 ],
	[ 'KGE',   'Geldern',                     8002222, 6.31933600, 51.5132890 ],
	[ 'FGEL',  'Gelnhausen',                  8000117, 9.18927800, 50.1963430 ],
	[ 'EG',    'Gelsenkirchen Hbf',           8000118, 7.10245500, 51.5049030 ],
	[ 'EGZO',  'Gelsenkirchen Zoo',           8002223, 7.11110400, 51.5376860 ],
	[ 'EGBU',  'Gelsenkirchen-Buer Nord',     8002224, 7.05059300, 51.5872450 ],
	[ 'EGBS',  'Gelsenkirchen-Buer Süd',     8002225, 7.04015600, 51.5490850 ],
	[ 'EGHS',  'Gelsenkirchen-Hassel',        8002226, 7.06657100, 51.6108580 ],
	[ 'EGRO',  'Gelsenkirchen-Rotthausen',    8002227, 7.08900900, 51.4926420 ],
	[ 'MGE',   'Geltendorf',                  8000119, 11.0377360, 48.1057760 ],
	[ 'TGEM',  'Gemmingen',                   8002228, 8.98464800, 49.1512950 ],
	[ 'TGEW',  'Gemmingen West',              8071001, 8.97758500, 49.1544420 ],
	[ 'NGM',   'Gemünden(Main)',             8000120, 9.69989400, 50.0500180 ],
	[ 'MGKG',  'Genderkingen',                8002233, 10.8851590, 48.6958400 ],
	[ 'MGND',  'Gendorf',                     8002234, 12.7210980, 48.1794840 ],
	[ 'RGB',   'Gengenbach',                  8002235, 8.01019200, 48.4046590 ],
	[ 'SGN',   'Gennweiler',                  8002238, 7.04998400, 49.3699790 ],
	[ 'FGHO',  'Gensingen-Horrweiler',        8000121, 7.93818800, 49.8982600 ],
	[ 'LGN',   'Genthin',                     8010123, 12.1571030, 52.4032200 ],
	[ 'NGE',   'Georgensgmünd',              8002237, 11.0166140, 49.1838360 ],
	[ 'UG',    'Gera Hbf',                    8010125, 12.0770920, 50.8834210 ],
	[ 'UGOT',  'Gera Ost',                    8011617, 12.0927910, 50.8492030 ],
	[ 'UGS',   'Gera Süd',                   8010126, 12.0764430, 50.8711590 ],
	[ 'UGLB',  'Gera-Langenberg',             8011619, 12.0472000, 50.9169710 ],
	[ 'UGLW',  'Gera-Liebschwitz',            8011620, 12.0807910, 50.8384290 ],
	[ 'UGZ',   'Gera-Zwötzen',               8011623, 12.0821810, 50.8500500 ],
	[ 'UGBG',  'Geraberg',                    8011624, 10.8571960, 50.7155930 ],
	[ 'TGES',  'Geradstetten',                8002240, 9.43975300, 48.8052030 ],
	[ 'TGEH',  'Gerhausen',                   8002242, 9.80622700, 48.3997200 ],
	[ 'LGE',   'Gerichshain',                 8011626, 12.5874440, 51.3538800 ],
	[ 'TGLH',  'Gerlachsheim',                8002243, 9.71061200, 49.5808860 ],
	[ 'MGLH',  'Gerlenhofen',                 8002244, 10.0372820, 48.3513320 ],
	[ 'MUG',   'Germering-Unterpfaffenhofen', 8006006, 11.3640230, 48.1288700 ],
	[ 'RGE',   'Germersheim Bahnhof',         8000376, 8.36487000, 49.2256380 ],
	[ 'RGEM',  'Germersheim Mitte/Rhein',     8002239, 8.37930500, 49.2198760 ],
	[ 'RGES',  'Germersheim Süd/Nolte',      8002241, 8.37375500, 49.2083410 ],
	[ 'MGLD',  'Gernlinden',                  8002247, 11.3003780, 48.2127650 ],
	[ 'LGDE',  'Gernrode(Harz)',              8010127, 11.1490830, 51.7297650 ],
	[ 'UNDO',  'Gernrode-Niederorschel',      8012492, 10.4165330, 51.3832240 ],
	[ 'RGS',   'Gernsbach Bf',                8002248, 8.33671400, 48.7683070 ],
	[ 'RGSD',  'Gernsbach Mitte',             8002250, 8.33904200, 48.7630860 ],
	[ 'FGHM',  'Gernsheim',                   8002249, 8.49020000, 49.7535980 ],
	[ 'TGN',   'Geroldshausen',               8002251, 9.90399400, 49.6869410 ],
	[ 'SGR',   'Gerolstein',                  8000123, 6.66037200, 50.2240060 ],
	[ 'DGD',   'Gersdorf(Görlitz)',          8011628, 14.8542500, 51.1252120 ],
	[ 'FGFD',  'Gersfeld(Rhön)',             8002254, 9.91484700, 50.4494130 ],
	[ 'TGSN',  'Gerstetten',                  8007075, 10.0226620, 48.6248360 ],
	[ 'MGHF',  'Gersthofen',                  8002256, 10.8611930, 48.4230200 ],
	[ 'UGT',   'Gerstungen',                  8011629, 10.0650410, 50.9646650 ],
	[ 'FGTB',  'Gertenbach',                  8002259, 9.80470900, 51.3797320 ],
	[ 'LGWS',  'Gerwisch',                    8011630, 11.7420950, 52.1775870 ],
	[ 'EGK',   'Geseke',                      8002262, 8.51029200, 51.6452300 ],
	[ 'MGHN',  'Gessertshausen',              8002263, 10.7323820, 48.3337150 ],
	[ 'FGGB',  'Gettenau-Bingenheim',         8002265, 8.88579600, 50.3791910 ],
	[ 'AGF',   'Gettorf',                     8002266, 9.97867800, 54.4098930 ],
	[ 'EGVH',  'Gevelsberg Hbf',              8002267, 7.33976000, 51.3243990 ],
	[ 'KGVW',  'Gevelsberg West',             8002268, 7.31384500, 51.3172760 ],
	[ 'KGVK',  'Gevelsberg-Kipp',             8002509, 7.32717200, 51.3199300 ],
	[ 'EGVA',  'Gevelsberg-Knapp',            8001943, 7.37788400, 51.3369640 ],
	[ 'TGB',   'Giengen(Brenz)',              8002272, 10.2369940, 48.6200230 ],
	[ 'LGI',   'Giersleben',                  8011632, 11.5686590, 51.7648360 ],
	[ 'FG',    'Gießen',                     8000124, 8.66146200, 50.5790590 ],
	[ 'FEKW',  'Gießen Erdkauter Weg',       8001826, 8.68324100, 50.5713040 ],
	[ 'FLST',  'Gießen Licher Str',          8003674, 8.69724200, 50.5816670 ],
	[ 'FGOG',  'Gießen Oswaldsgarten',       8002269, 8.66913800, 50.5883550 ],
	[ 'HGI',   'Gifhorn',                     8000185, 10.5452840, 52.4561550 ],
	[ 'HGIS',  'Gifhorn Stadt',               8002274, 10.5429400, 52.4797740 ],
	[ 'MGCH',  'Gilching-Argelsried',         8002275, 11.2995980, 48.1056740 ],
	[ 'TGI',   'Gingen(Fils)',                8002278, 9.78782600, 48.6610390 ],
	[ 'FGIR',  'Girod',                       8002280, 7.90293600, 50.4543290 ],
	[ 'HGT',   'Gittelde/Bad Grund(Harz)',    8002281, 10.2030250, 51.7873370 ],
	[ 'EGBO',  'Gladbeck Ost',                8002283, 6.99481300, 51.5755310 ],
	[ 'EGBW',  'Gladbeck West',               8000125, 6.97638900, 51.5749220 ],
	[ 'EZK',   'Gladbeck-Zweckel',            8002284, 6.98442400, 51.5902700 ],
	[ 'SGM',   'Glan-Münchweiler',           8002286, 7.44484800, 49.4701760 ],
	[ 'NGLW',  'Glanzstoffwerke',             8002287, 9.15219400, 49.8285710 ],
	[ 'DGHU',  'Glashütte(Sachs)',           8011636, 13.7823780, 50.8511020 ],
	[ 'DGLA',  'Glaubitz(Riesa)',             8011637, 13.3654350, 51.3175620 ],
	[ 'FGBG',  'Glauburg-Glauberg',           8002288, 8.99601600, 50.3137520 ],
	[ 'FSTM',  'Glauburg-Stockheim',          8000347, 9.01012300, 50.3270560 ],
	[ 'DGL',   'Glauchau(Sachs)',             8010129, 12.5486460, 50.8285240 ],
	[ 'DGLS',  'Glauchau-Schönbörnchen',    8010130, 12.5006710, 50.8210570 ],
	[ 'KGL',   'Glesch',                      8002290, 6.58963300, 50.9712610 ],
	[ 'DGLO',  'Glossen (b Oschatz)',         8070199, 12.9954800, 51.2428390 ],
	[ 'WGF',   'Glöwen',                     8011641, 12.0839280, 52.9035120 ],
	[ 'UGL',   'Glückauf',                   8011643, 10.8283670, 51.3897010 ],
	[ 'AGST',  'Glückstadt',                 8002293, 9.42832000, 53.7886060 ],
	[ 'MGMD',  'Gmund(Tegernsee)',            8007631, 11.7352960, 47.7496420 ],
	[ 'LGND',  'Gnadau',                      8010084, 11.7811500, 51.9795990 ],
	[ 'AGNB',  'Gnarrenburg',                 8007114, 9.00809900, 53.3812360 ],
	[ 'AGNBN', 'Gnarrenburg Nord',            8070036, 9.01540300, 53.3932870 ],
	[ 'WGNV',  'Gnevkow',                     8011646, 13.1746700, 53.7928960 ],
	[ 'KGO',   'Goch',                        8002296, 6.16086200, 51.6818240 ],
	[ 'RGOM',  'Gochsheim(Baden)',            8007143, 8.74469500, 49.1094110 ],
	[ 'HGOH',  'Godelheim',                   8002299, 9.35687100, 51.7351230 ],
	[ 'RGOR',  'Godramstein',                 8002300, 8.07602800, 49.2068500 ],
	[ 'AGK',   'Gokels',                      8002319, 9.47008100, 54.1187550 ],
	[ 'LGM',   'Goldbeck(Osterburg)',         8011665, 11.8581490, 52.7160600 ],
	[ 'TGOL',  'Goldberg(Württ)',            8005201, 9.02043000, 48.6969100 ],
	[ 'HGOL',  'Goldenstedt(Oldb)',           8002320, 8.39457900, 52.8006110 ],
	[ 'FGDH',  'Goldhausen',                  8002321, 7.87306400, 50.4614200 ],
	[ 'TGL',   'Goldshöfe',                  8000380, 10.1282540, 48.8942210 ],
	[ 'BGM',   'Gollmitz(Niederlausitz)',     8011667, 13.8838340, 51.7033350 ],
	[ 'BGOL',  'Golm',                        8013481, 12.9718640, 52.4097740 ],
	[ 'WGOL',  'Golzow(Eberswalde)',          8011671, 13.8269750, 52.9140130 ],
	[ 'BGZ',   'Golzow(Oderbruch)',           8011672, 14.5118100, 52.5625310 ],
	[ 'BGO',   'Golßen(Niederlausitz)',      8011668, 13.5747730, 51.9742720 ],
	[ 'TGOM',  'Gomadingen',                  8070400, 9.39213600, 48.3991210 ],
	[ 'LGO',   'Gommern',                     8011673, 11.8387800, 52.0740020 ],
	[ 'RGOS',  'Gondelsheim Schloßstadion',  8070011, 8.66286700, 49.0657370 ],
	[ 'RGO',   'Gondelsheim(Baden)',          8002326, 8.66028100, 49.0597040 ],
	[ 'BGOR',  'Gorgast',                     8011674, 14.5506440, 52.5631300 ],
	[ 'NGG',   'Gosberg',                     8002329, 11.1094800, 49.7047000 ],
	[ 'HGS',   'Goslar',                      8000130, 10.4214360, 51.9115730 ],
	[ 'UGO',   'Gotha',                       8010136, 10.7125680, 50.9390700 ],
	[ 'UGOS',  'Gotha Ost',                   8011678, 10.7208690, 50.9618810 ],
	[ 'RGH',   'Gottenheim',                  8002334, 7.72783200, 48.0516530 ],
	[ 'NGZ',   'Gotteszell',                  8002335, 12.9834350, 48.9581310 ],
	[ 'RG',    'Gottmadingen',                8002337, 8.77543000, 47.7374010 ],
	[ 'DKH',   'Goßdorf-Kohlmühle',         8011676, 14.1646550, 50.9411700 ],
	[ 'FGOF',  'Goßfelden',                  8002332, 8.73824900, 50.8684140 ],
	[ 'NGOD',  'Goßmannsdorf',               8002333, 10.0255940, 49.6849590 ],
	[ 'WGM',   'Graal-Müritz',               8012583, 12.2453870, 54.2487770 ],
	[ 'WGMW',  'Graal-Müritz Koppelweg',     8012584, 12.2371670, 54.2458900 ],
	[ 'MGRL',  'Graben(Lechfeld)Gewerbepark', 8002346, 10.8524110, 48.1991480 ],
	[ 'RGN',   'Graben-Neudorf',              8000131, 8.49063000, 49.1617970 ],
	[ 'RGNN',  'Graben-Neudorf Nord',         8002345, 8.49409600, 49.1779580 ],
	[ 'WGRB',  'Grabow(Meckl)',               8011681, 11.5642010, 53.2829020 ],
	[ 'MGRA',  'Grafenaschau',                8002343, 11.1374000, 47.6670290 ],
	[ 'NGFU',  'Grafenau',                    8002344, 13.3933270, 48.8561680 ],
	[ 'NGFW',  'Grafenwiesen',                8007339, 12.8778250, 49.2026350 ],
	[ 'MGB',   'Grafing Bahnhof',             8002347, 11.9404230, 48.0432260 ],
	[ 'MGRS',  'Grafing Stadt',               8002348, 11.9627580, 48.0472170 ],
	[ 'NGFA',  'Grafling-Arzting',            8002349, 12.9733220, 48.8896450 ],
	[ 'MGF',   'Grafrath',                    8002351, 11.1532590, 48.1320960 ],
	[ 'WGR',   'Grambow',                     8011689, 14.3474570, 53.4173810 ],
	[ 'WGRA',  'Gransee',                     8011691, 13.1671200, 53.0010760 ],
	[ 'DGFL',  'Grauschwitz Flocke',          8070660, 13.0678760, 51.2372910 ],
	[ 'FGSN',  'Grebenstein',                 8002358, 9.42053300, 51.4472380 ],
	[ 'WGW',   'Greifswald',                  8010139, 13.3702620, 54.0929230 ],
	[ 'WGWS',  'Greifswald Süd',             8011694, 13.3966560, 54.0764430 ],
	[ 'UGR',   'Greiz',                       8010140, 12.1945220, 50.6532870 ],
	[ 'UGRD',  'Greiz-Dölau',                8011697, 12.1847760, 50.6300290 ],
	[ 'RGRZ',  'Grenzach',                    8002365, 7.65950600, 47.5509000 ],
	[ 'LGPN',  'Greppin',                     8011699, 12.2979690, 51.6453580 ],
	[ 'UGN',   'Greußen',                    8011700, 10.9413030, 51.2293400 ],
	[ 'EGRV',  'Greven',                      8002369, 7.59934100, 52.0898290 ],
	[ 'KGRB',  'Grevenbroich',                8000133, 6.58044700, 51.0937010 ],
	[ 'WGV',   'Grevesmühlen',               8010141, 11.1847120, 53.8574680 ],
	[ 'WGBN',  'Grieben(Meckl)',              8011702, 11.0685690, 53.8512330 ],
	[ 'LGB',   'Griebo',                      8011703, 12.5229770, 51.8805760 ],
	[ 'UGRI',  'Griefstedt',                  8084070, 11.1364710, 51.2302290 ],
	[ 'UGRIB', 'Griefstedt',                  8084070, 11.1364710, 51.2302290 ],
	[ 'MGRI',  'Griesen(Oberbay)',            8017041, 10.9461200, 47.4782170 ],
	[ 'RGSS',  'Grießen(Baden)',             8002373, 8.39600300, 47.6284320 ],
	[ 'LGRI',  'Grimma ob Bf',                8011705, 12.7141310, 51.2300760 ],
	[ 'WGI',   'Grimmen',                     8011707, 13.0340250, 54.1097390 ],
	[ 'UGM',   'Grimmenthal',                 8010142, 10.4505120, 50.5329530 ],
	[ 'DGO',   'Grobau',                      8011709, 11.9439050, 50.4323020 ],
	[ 'RGM',   'Grombach',                    8002380, 8.99690200, 49.2261450 ],
	[ 'EGRN',  'Gronau(Westf)',               8000382, 7.02243600, 52.2151070 ],
	[ 'MGDF',  'Gronsdorf',                   8002383, 11.6986190, 48.1184010 ],
	[ 'LGRL',  'Groß Ammensleben',           8011714, 11.5254170, 52.2356460 ],
	[ 'WGB',   'Groß Brütz',                8011718, 11.2514390, 53.6530880 ],
	[ 'HGDN',  'Groß Düngen',               8002405, 10.0200770, 52.0977300 ],
	[ 'FGER',  'Groß Gerau',                 8000136, 8.48621500, 49.9249340 ],
	[ 'FDG',   'Groß Gerau-Dornberg',        8002386, 8.49470900, 49.9122790 ],
	[ 'FDOH',  'Groß Gerau-Dornheim',        8001511, 8.49365600, 49.8775070 ],
	[ 'FGKA',  'Groß Karben',                8002388, 8.75352800, 50.2318400 ],
	[ 'WGKW',  'Groß Kiesow',                8011723, 13.4806170, 54.0137210 ],
	[ 'LGZ',   'Groß Kreutz',                8011725, 12.7763350, 52.4107610 ],
	[ 'BTPI',  'Groß Köris',                8013109, 13.6508070, 52.1596070 ],
	[ 'WGLS',  'Groß Laasch',                8011726, 11.5341390, 53.3464810 ],
	[ 'WGLI',  'Groß Lüsewitz',             8011729, 12.3392210, 54.0734070 ],
	[ 'WGP',   'Groß Pankow',                8011730, 12.0474210, 53.1230140 ],
	[ 'WGQ',   'Groß Quassow',               8011731, 13.0038450, 53.3148230 ],
	[ 'FGRO',  'Groß Rohrheim',              8002391, 8.47685700, 49.7140660 ],
	[ 'WGS',   'Groß Schwaß',               8011735, 12.0461200, 54.0770260 ],
	[ 'BGSK',  'Groß Schönebeck',           8011734, 13.5375160, 52.9042870 ],
	[ 'FKLU',  'Groß-Umstadt Klein-Umstadt', 8003315, 8.93863500, 49.8943670 ],
	[ 'FGRU',  'Groß-Umstadt Mitte',         8002393, 8.92417100, 49.8652130 ],
	[ 'FWH',   'Groß-Umstadt Wiebelsbach',   8000384, 8.94085400, 49.8334250 ],
	[ 'NGRS',  'Großarmschlag',              8002399, 13.3759210, 48.8857230 ],
	[ 'FGAU',  'Großauheim(Kr Hanau)',       8002400, 8.94390200, 50.1070540 ],
	[ 'BGSBS', 'Großbeeren',                 8011740, 13.2847700, 52.3506730 ],
	[ 'DGR',   'Großbothen',                 8010144, 12.7590330, 51.1844550 ],
	[ 'HGBW',  'Großburgwedel',              8002403, 9.85853500, 52.5068200 ],
	[ 'LGD',   'Großdeuben',                 8011745, 12.3831930, 51.2323520 ],
	[ 'FGRB',  'Großen Buseck',              8002409, 8.78299900, 50.6057400 ],
	[ 'FGL',   'Großen Linden',              8002410, 8.66199800, 50.5278510 ],
	[ 'AGSA',  'Großenaspe',                 8007060, 9.96982900, 53.9809740 ],
	[ 'AGRO',  'Großenbrode',                8002411, 11.0807790, 54.3663100 ],
	[ 'UGG',   'Großengottern',              8011746, 10.5560410, 51.1445030 ],
	[ 'DGC',   'Großenhain Cottb Bf',        8011749, 13.5239160, 51.2916360 ],
	[ 'HGRK',  'Großenkneten',               8002412, 8.24113600, 52.9450570 ],
	[ 'FGLR',  'Großenlüder',               8002413, 9.55000100, 50.5929360 ],
	[ 'UGFA',  'Großfurra',                  8011750, 10.8028150, 51.3988820 ],
	[ 'NGRG',  'Großgeschaidt',              8002416, 11.1722040, 49.5650310 ],
	[ 'DGRT',  'Großharthau',                8011751, 14.0876460, 51.1021240 ],
	[ 'MGHD',  'Großhelfendorf',             8002420, 11.7812600, 47.9460600 ],
	[ 'UGH',   'Großheringen',               8010145, 11.6577450, 51.1059810 ],
	[ 'MGOI',  'Großhesselohe Isartalbf',    8002422, 11.5309450, 48.0710680 ],
	[ 'MGK',   'Großkarolinenfeld',          8002424, 12.0848240, 47.8888270 ],
	[ 'LGC',   'Großkorbetha',               8010146, 12.0221710, 51.2673180 ],
	[ 'FGK',   'Großkrotzenburg',            8002425, 8.98279200, 50.0877260 ],
	[ 'LGKL',  'Großkugel',                  8011752, 12.1644110, 51.4187200 ],
	[ 'LGL',   'Großlehna',                  8011753, 12.1688180, 51.3048060 ],
	[ 'UGNH',  'Großneuhausen',              8011754, 11.2861630, 51.1645160 ],
	[ 'LGP',   'Großpösna',                 8011755, 12.4888390, 51.2667090 ],
	[ 'UGRU',  'Großrudestedt',              8011759, 11.0910930, 51.0956500 ],
	[ 'BGR',   'Großräschen',               8011756, 14.0148980, 51.5914880 ],
	[ 'DGRF',  'Großröhrsdorf',             8011758, 14.0175570, 51.1487430 ],
	[ 'UGC',   'Großschwabhausen',           8011762, 11.4819340, 50.9369580 ],
	[ 'DGAU',  'Großschönau(Sachs)',        8011761, 14.6654500, 50.8925560 ],
	[ 'LGS',   'Großsteinberg',              8011763, 12.6374150, 51.2505860 ],
	[ 'NGRW',  'Großwalbur',                 8002432, 10.8492820, 50.3271900 ],
	[ 'LGWU',  'Großwudicke',                8011766, 12.2311280, 52.5904350 ],
	[ 'NGUF',  'Grub am Forst',               8002434, 11.0258580, 50.2275230 ],
	[ 'MGRB',  'Grub(Oberbay)',               8002435, 11.7825590, 48.1645230 ],
	[ 'NGRU',  'Grub(Oberpf)',                8002436, 12.6816530, 49.3578560 ],
	[ 'KGUH',  'Gruiten',                     8000138, 7.01054600, 51.2145590 ],
	[ 'KGUI',  'Gruiten',                     8000138, 7.01054600, 51.2145590 ],
	[ 'TGC',   'Grunbach',                    8002448, 9.42002900, 48.8103600 ],
	[ 'BGRU',  'Grunow(Niederlausitz)',       8010150, 14.3788430, 52.1650740 ],
	[ 'MGFL',  'Gräfelfing',                 8002339, 11.4255710, 48.1197740 ],
	[ 'NGFG',  'Gräfenberg',                 8002340, 11.2504230, 49.6415600 ],
	[ 'NG',    'Gräfendorf',                 8002341, 9.73716200, 50.1182790 ],
	[ 'LG',    'Gräfenhainichen',            8011683, 12.4600370, 51.7247310 ],
	[ 'UGD',   'Gräfenroda',                 8010137, 10.8330070, 50.7588940 ],
	[ 'UGTA',  'Gräfentonna',                8011687, 10.7336170, 51.0897340 ],
	[ 'FGRK',  'Gräveneck',                  8002342, 8.25075700, 50.4519050 ],
	[ 'FGR',   'Grävenwiesbach',             8000132, 8.45855300, 50.3822390 ],
	[ 'MGRZ',  'Gröbenzell',                 8002377, 11.3741070, 48.1949190 ],
	[ 'LGOH',  'Gröbers',                    8011711, 12.1168260, 51.4325020 ],
	[ 'DGT',   'Gröditz(Riesa)',             8011712, 13.4395420, 51.4114680 ],
	[ 'RGZ',   'Grötzingen',                 8000381, 8.49294100, 49.0059750 ],
	[ 'RGZK',  'Grötzingen Krappmühlenweg', 8007861, 8.51217800, 49.0057820 ],
	[ 'RGZO',  'Grötzingen Oberausstraße',  8079057, 8.50404900, 49.0052600 ],
	[ 'DGN',   'Grüna(Sachs)Hp',             8011770, 12.7985140, 50.8114170 ],
	[ 'DGBA',  'Grünbach(Vogtl)',            8011773, 12.3728150, 50.4398950 ],
	[ 'FGRG',  'Grünberg(Oberhess)',         8002439, 8.95993100, 50.5965890 ],
	[ 'EGNO',  'Grünebach Ort',              8002441, 7.90235000, 50.7771430 ],
	[ 'EGNH',  'Grünebacherhütte',          8002442, 7.89154600, 50.7816560 ],
	[ 'WGRG',  'Grüneberg',                  8011776, 13.2130230, 52.8678000 ],
	[ 'DGRB',  'Grünhainichen-Borstendorf',  8011777, 13.1634430, 50.7746220 ],
	[ 'TGRS',  'Grünsfeld',                  8002447, 9.74544700, 49.6049330 ],
	[ 'RGR',   'Grünstadt',                  8000137, 8.16796200, 49.5643840 ],
	[ 'RGRN',  'Grünstadt Nord',             8002444, 8.17078100, 49.5733550 ],
	[ 'TGRW',  'Grüntal-Wittlensweiler',     8002445, 8.46074700, 48.4753990 ],
	[ 'NSDT',  'Gstadt(Wanderbahn)',          8070669, 12.9440430, 49.0643570 ],
	[ 'BGU',   'Guben',                       8010357, 14.7067750, 51.9572030 ],
	[ 'KGU',   'Gummersbach',                 8002462, 7.56631000, 51.0236320 ],
	[ 'NGPA',  'Gumpenried-Asbach',           8070599, 13.0009930, 49.0718320 ],
	[ 'MGUF',  'Gundelfingen(Bay)',           8002466, 10.3771860, 48.5487790 ],
	[ 'RGDN',  'Gundelfingen(Breisgau)',      8002465, 7.87418500, 48.0440250 ],
	[ 'NGD',   'Gundelsdorf',                 8002467, 11.3014550, 50.2799170 ],
	[ 'NGU',   'Gundelshausen',               8002468, 12.0035530, 48.9448800 ],
	[ 'RGUN',  'Gundelsheim(Neckar)',         8002470, 9.15787000, 49.2829330 ],
	[ 'FGUH',  'Gundersheim(Rheinhess)',      8002473, 8.19659600, 49.6901670 ],
	[ 'FGUB',  'Guntersblum',                 8002474, 8.35125700, 49.7919800 ],
	[ 'NGUN',  'Gunzenhausen',                8000385, 10.7554630, 49.1204440 ],
	[ 'TGSS',  'Gussenstadt',                 8007074, 9.95762300, 48.6399010 ],
	[ 'KGUS',  'Gustorf',                     8002477, 6.57001100, 51.0671730 ],
	[ 'RGTF',  'Gutach Freilichtmuseum',      8002480, 8.19857200, 48.2716770 ],
	[ 'RGTA',  'Gutach(Breisgau)',            8002478, 7.98849300, 48.1133250 ],
	[ 'DGF',   'Gutenfürst',                 8011790, 11.9609160, 50.4187970 ],
	[ 'UGU',   'Guthmannshausen',             8011791, 11.3657030, 51.1323680 ],
	[ 'FGX',   'Guxhagen',                    8002484, 9.48215900, 51.2043220 ],
	[ 'TGT',   'Gärtringen',                 8002165, 8.90911300, 48.6411220 ],
	[ 'TGFD',  'Gäufelden',                  8002166, 8.85030800, 48.5596610 ],
	[ 'FGOE',  'Göbelnrod',                  8002301, 8.92144800, 50.5976310 ],
	[ 'AGH',   'Göhrde',                     8002304, 10.8511180, 53.1677490 ],
	[ 'WGO',   'Göhren(Rügen)',             8011651, 13.7377040, 54.3459610 ],
	[ 'FGLD',  'Göllheim-Dreisen',           8070257, 8.01644400, 49.5993760 ],
	[ 'RGOE',  'Gölshausen',                 8002307, 8.72471500, 49.0449040 ],
	[ 'RGOI',  'Gölshausen Industriegebiet', 8002306, 8.73987900, 49.0518030 ],
	[ 'TGO',   'Göppingen',                  8000127, 9.65196900, 48.7000270 ],
	[ 'LGOR',  'Görden',                     8011654, 12.5039510, 52.4278810 ],
	[ 'DG',    'Görlitz',                    8010131, 14.9790800, 51.1467670 ],
	[ 'DGRA',  'Görlitz-Rauschwalde',        8012869, 14.9360100, 51.1490780 ],
	[ 'DGWH',  'Görlitz-Weinhübel',         8011656, 14.9702710, 51.1286640 ],
	[ 'UGSB',  'Görsbach',                   8011657, 10.9417920, 51.4557330 ],
	[ 'NGOE',  'Görschnitz',                 8002312, 11.7003150, 49.9573060 ],
	[ 'HG',    'Göttingen',                  8000128, 9.92607200, 51.5368150 ],
	[ 'LGOE',  'Götz',                       8011662, 12.7259830, 52.4112240 ],
	[ 'DGZ',   'Gößnitz',                   8010134, 12.4293010, 50.8932000 ],
	[ 'TGU',   'Gültstein',                  8070604, 8.88155800, 48.5774940 ],
	[ 'MGKF',  'Gündlkofen',                 8002457, 12.0336420, 48.5261590 ],
	[ 'LGBG',  'Güntersberge',               8017011, 10.9856690, 51.6442310 ],
	[ 'MGNZ',  'Günzach',                    8002458, 10.4395650, 47.8195990 ],
	[ 'MGZB',  'Günzburg',                   8000139, 10.2786560, 48.4603350 ],
	[ 'LGSN',  'Güsen(b Genthin)',           8010151, 11.9778620, 52.3348900 ],
	[ 'LGT',   'Güsten',                     8010152, 11.6018570, 51.7933840 ],
	[ 'WG',    'Güstrow',                    8010153, 12.1728360, 53.8005970 ],
	[ 'LGK',   'Güterglück',                8010154, 11.9863890, 51.9934740 ],
	[ 'LGK O', 'Güterglück',                8010154, 11.9863890, 51.9934740 ],
	[ 'EGLO',  'Gütersloh Hbf',              8002461, 8.38507100, 51.9069410 ],
	[ 'KHAN',  'Haan',                        8002490, 6.99801800, 51.1881200 ],
	[ 'MHR',   'Haar',                        8002491, 11.7311500, 48.1114130 ],
	[ 'UHSN',  'Haarhausen',                  8011792, 10.9057150, 50.8674370 ],
	[ 'KHAC',  'Hachenburg',                  8002494, 7.82289500, 50.6640010 ],
	[ 'FHAD',  'Hadamar',                     8002495, 8.04345300, 50.4471880 ],
	[ 'AHNU',  'Hademarschen',                8002496, 9.41447500, 54.1228090 ],
	[ 'LHD',   'Hadmersleben',                8011794, 11.3244460, 52.0073600 ],
	[ 'AHAF',  'Haffkrug',                    8002504, 10.7426820, 54.0541890 ],
	[ 'WHK',   'Hagebök',                    8011797, 11.6148820, 53.9612600 ],
	[ 'NHA',   'Hagelstadt',                  8002506, 12.2148290, 48.8958590 ],
	[ 'EHG',   'Hagen Hbf',                   8000142, 7.46024900, 51.3627470 ],
	[ 'HHGH',  'Hagen(Han)',                  8002507, 9.40894600, 52.5736900 ],
	[ 'EHGI',  'Hagen-Heubing',               8002512, 7.42308700, 51.3523180 ],
	[ 'EHGO',  'Hagen-Oberhagen',             8002514, 7.47879200, 51.3511140 ],
	[ 'EHGV',  'Hagen-Vorhalle',              8000977, 7.43372600, 51.3882240 ],
	[ 'EHGW',  'Hagen-Wehringhausen',         8006712, 7.45276700, 51.3535830 ],
	[ 'EHWB',  'Hagen-Westerbauer',           8004440, 7.39739200, 51.3417810 ],
	[ 'RHGB',  'Hagenbach',                   8002515, 8.25322300, 49.0162800 ],
	[ 'NHBH',  'Hagenbüchach',               8002517, 10.7677990, 49.5363470 ],
	[ 'NHBU',  'Hagenbüchach',               8002517, 10.7677990, 49.5363470 ],
	[ 'WHL',   'Hagenow Land',                8010156, 11.2156950, 53.4135820 ],
	[ 'WH',    'Hagenow Stadt',               8011798, 11.1849900, 53.4294370 ],
	[ 'DHW',   'Hagenwerder',                 8011799, 14.9602280, 51.0701170 ],
	[ 'NHAG',  'Haidenaab-Göppmannsbühl',   8002523, 11.8200450, 49.8857770 ],
	[ 'THKP',  'Haidkapelle',                 8070414, 9.26172800, 48.3611570 ],
	[ 'FHG',   'Haiger',                      8000386, 8.22065700, 50.7413520 ],
	[ 'FHGO',  'Haiger Obertor',              8002524, 8.20196100, 50.7412080 ],
	[ 'THGL',  'Haigerloch',                  8070415, 8.80130100, 48.3702000 ],
	[ 'THGLH', 'Haigerloch',                  8070415, 8.80130100, 48.3702000 ],
	[ 'FHME',  'Hailer-Meerholz',             8002526, 9.15066500, 50.1896710 ],
	[ 'FHDT',  'Hainburg Hainstadt',          8002531, 8.93813500, 50.0781130 ],
	[ 'DHND',  'Hainewalde',                  8011801, 14.7044630, 50.9066080 ],
	[ 'DHA',   'Hainichen',                   8011802, 13.1190570, 50.9680950 ],
	[ 'RHAI',  'Hainstadt(Baden)',            8002529, 9.32688400, 49.5430580 ],
	[ 'FHAI',  'Haitz-Höchst',               8002532, 9.22682100, 50.2086340 ],
	[ 'BHB',   'Halbe',                       8011805, 13.7018550, 52.1083840 ],
	[ 'LHB',   'Halberstadt',                 8010157, 11.0734520, 51.8993090 ],
	[ 'LHBO',  'Halberstadt Oststr',          8011808, 11.0654360, 51.8850110 ],
	[ 'LHBS',  'Halberstadt-Spiegelsberge',   8011809, 11.0483070, 51.8825810 ],
	[ 'RHAM',  'Halbmeil',                    8002533, 8.27045400, 48.2907490 ],
	[ 'LHL',   'Haldensleben',                8010158, 11.4061060, 52.2850340 ],
	[ 'EHAD',  'Haldern(Rheinl)',             8002536, 6.45583200, 51.7725580 ],
	[ 'HHAL',  'Halen',                       8002537, 7.94504400, 52.3391220 ],
	[ 'MHLF',  'Halfing',                     8070801, 12.2792750, 47.9529440 ],
	[ 'MHMO',  'Hallbergmoos',                8002534, 11.7143340, 48.3091670 ],
	[ 'LDBR',  'Halle Dessauer Brücke',      8080560, 11.9825350, 51.5001230 ],
	[ 'LHME',  'Halle Messe',                 8010155, 12.0280410, 51.4547600 ],
	[ 'LRO',   'Halle Rosengarten',           8080570, 11.9827870, 51.4468630 ],
	[ 'LSBR',  'Halle Steintorbrücke',       8080580, 11.9868930, 51.4903660 ],
	[ 'LSUE',  'Halle Südstadt',             8080590, 11.9509250, 51.4479590 ],
	[ 'LWN',   'Halle Wohnstadt Nord',        8080600, 11.9648100, 51.5171460 ],
	[ 'LZO',   'Halle Zoo',                   8080610, 11.9703460, 51.5036510 ],
	[ 'LHNZ',  'Halle Zscherbener Straße',   8080620, 11.9210560, 51.4733140 ],
	[ 'LH',    'Halle(Saale)Hbf',             8010159, 11.9870850, 51.4775090 ],
	[ 'LH  G', 'Halle(Saale)Hbf Gl. 13a',     8098159, 11.9878680, 51.4784610 ],
	[ 'LHG',   'Halle(Saale)Hbf Gl. 13a',     8098159, 11.9878680, 51.4784610 ],
	[ 'EHWS', 'Halle(W) Gerry-Weber-Stadion', 8080630, 8.34379700, 52.0616430 ],
	[ 'EHAL', 'Halle(Westf)',                 8002539, 8.35772900, 52.0572950 ],
	[ 'LHAD', 'Halle-Ammendorf',              8010162, 11.9878320, 51.4241820 ],
	[ 'LHADB', 'Halle-Ammendorf',      8010162, 11.9878320, 51.4241820 ],
	[ 'LHN',   'Halle-Neustadt',       8010160, 11.9206320, 51.4800560 ],
	[ 'LHNI',  'Halle-Nietleben',      8011813, 11.9084510, 51.4878250 ],
	[ 'LHSS',  'Halle-Silberhöhe',    8013448, 11.9668010, 51.4455460 ],
	[ 'LHT',   'Halle-Trotha',         8011814, 11.9621700, 51.5238980 ],
	[ 'LHTS',  'Halle-Trotha',         8011814, 11.9621700, 51.5238980 ],
	[ 'NHAL',  'Hallstadt(b Bamberg)', 8002542, 10.8854540, 49.9295510 ],
	[ 'AHKS',  'Halstenbek',           8002545, 9.83909200, 53.6303770 ],
	[ 'EHLT',  'Haltern am See',       8000145, 7.18436600, 51.7376680 ],
	[ 'RHL',   'Haltingen',            8002546, 7.61168300, 47.6128370 ],
	[ 'AAI',   'Hamburg Airport',      8002547, 10.0066460, 53.6323500 ],
	[ 'AAW',   'Hamburg Alte Wöhr',   8000512, 10.0354150, 53.5979300 ],
	[ 'ABTS',  'Hamburg Berliner Tor', 8000908, 10.0246300, 53.5528700 ],
	[ 'ABTSB', 'Hamburg Berliner Tor', 8000908, 10.0246300, 53.5528700 ],
	[ 'ABTSL', 'Hamburg Berliner Tor', 8000908, 10.0246300, 53.5528700 ],
	[ 'ABWM', 'Hamburg Billwerder-Moorfleet', 8000971, 10.0966580, 53.5155890 ],
	[ 'ABWD', 'Hamburg Burgwedel',            8007046, 9.90849600, 53.6476140 ],
	[ 'ADF',  'Hamburg Dammtor',              8002548, 9.98956600, 53.5607510 ],
	[ 'ADST', 'Hamburg Dammtor',              8002548, 9.98956600, 53.5607510 ],
	[ 'ADT',  'Hamburg Diebsteich',           8001438, 9.93426000, 53.5685690 ],
	[ 'AEGS', 'Hamburg Elbgaustraße',        8001739, 9.89373800, 53.6025750 ],
	[ 'AFBG', 'Hamburg Friedrichsberg',       8002106, 10.0574330, 53.5763280 ],
	[ 'AHSB', 'Hamburg Hasselbrook',          8002628, 10.0561290, 53.5647110 ],
	[ 'AHSF', 'Hamburg Hasselbrook',          8002628, 10.0561290, 53.5647110 ],
	[ 'AH',   'Hamburg Hbf',                  8002549, 10.0069090, 53.5527360 ],
	[ 'AHS',  'Hamburg Hbf (S-Bahn)',         8098549, 10.0079210, 53.5528090 ],
	[ 'AHPS', 'Hamburg Hochkamp',             8002873, 9.84207600, 53.5613700 ],
	[ 'AHCH', 'Hamburg Hoheneichen',          8002946, 10.0676480, 53.6354780 ],
	[ 'AHST', 'Hamburg Holstenstraße',       8002550, 9.94974100, 53.5617620 ],
	[ 'AJUS', 'Hamburg Jungfernstieg',        8003137, 9.99388300, 53.5521940 ],
	[ 'AFB',  'Hamburg Klein Flottbek',       8003312, 9.86112200, 53.5581690 ],
	[
		'AKWS',  'Hamburg Kornweg(Klein Borstel)',
		8003410, 10.0538410,
		53.6323810
	],
	[ 'AKS',   'Hamburg Königstraße',       8006706, 9.94408800, 53.5477960 ],
	[ 'ALAS',  'Hamburg Landungsbrücken',    8003518, 9.97128100, 53.5461320 ],
	[ 'ALASK', 'Hamburg Landungsbrücken',    8003518, 9.97128100, 53.5461320 ],
	[ 'ALAN',  'Hamburg Landwehr',            8003519, 10.0380210, 53.5611990 ],
	[ 'AML',   'Hamburg Mittlerer Landweg',   8004048, 10.1311220, 53.4981720 ],
	[ 'ANWS',  'Hamburg Neuwiedenthal',       8006750, 9.87743400, 53.4730590 ],
	[ 'ARES',  'Hamburg Reeperbahn',          8006705, 9.95766800, 53.5496680 ],
	[ 'ARP',   'Hamburg Rübenkamp',          8005207, 10.0330830, 53.6059680 ],
	[ 'ASHS',  'Hamburg Stadthausbrücke',    8005663, 9.98480400, 53.5494650 ],
	[ 'AWCH',  'Hamburg Wandsbeker Chaussee', 8006198, 10.0599750, 53.5697340 ],
	[ 'AALH',  'Hamburg-Allermöhe',          8000779, 10.1587350, 53.4903560 ],
	[ 'AA',    'Hamburg-Altona',              8002553, 9.93517500, 53.5526950 ],
	[ 'AAS',   'Hamburg-Altona(S)',           8098553, 9.93455400, 53.5518550 ],
	[ 'ABAF',  'Hamburg-Bahrenfeld',          8000780, 9.91077800, 53.5600600 ],
	[ 'ABAP',  'Hamburg-Barmbek',             8000805, 10.0441640, 53.5874580 ],
	[ 'ABG',   'Hamburg-Bergedorf',           8002554, 10.2061710, 53.4898320 ],
	[ 'ABG S', 'Hamburg-Bergedorf',           8002554, 10.2061710, 53.4898320 ],
	[ 'AB',    'Hamburg-Blankenese',          8001007, 9.81460700, 53.5643640 ],
	[ 'AE',    'Hamburg-Eidelstedt',          8002555, 9.90709700, 53.5958870 ],
	[ 'AEN',   'Hamburg-Eidelstedt',          8002555, 9.90709700, 53.5958870 ],
	[ 'AEST',  'Hamburg-Eidelstedt',          8002555, 9.90709700, 53.5958870 ],
	[ 'AENZ',  'Hamburg-Eidelstedt Zentrum',  8007044, 9.90152200, 53.6103750 ],
	[ 'AFIB',  'Hamburg-Fischbek',            8002556, 9.81956100, 53.4747310 ],
	[ 'AHAB',  'Hamburg-Hammerbrook',         8004266, 10.0236100, 53.5466100 ],
	[ 'AHAR',  'Hamburg-Harburg',             8000147, 9.99170100, 53.4559080 ],
	[ 'AHRF',  'Hamburg-Harburg Rathaus',     8004267, 9.98046300, 53.4606940 ],
	[ 'AHRS',  'Hamburg-Harburg(S)',          8098147, 9.99145400, 53.4569600 ],
	[ 'AHFS',  'Hamburg-Heimfeld',            8006749, 9.96318700, 53.4654810 ],
	[ 'AHOW',  'Hamburg-Hörgensweg',         8002909, 9.90362700, 53.6172830 ],
	[ 'AIS',   'Hamburg-Iserbrook',           8003088, 9.81404900, 53.5766060 ],
	[ 'ALST',  'Hamburg-Langenfelde',         8003541, 9.93092000, 53.5796920 ],
	[ 'ANTB',  'Hamburg-Nettelnburg',         8004241, 10.1814080, 53.4878880 ],
	[ 'ANR',   'Hamburg-Neugraben',           8002557, 9.85204800, 53.4741430 ],
	[ 'ANRS',  'Hamburg-Neugraben',           8002557, 9.85204800, 53.4741430 ],
	[ 'AOPS',  'Hamburg-Ohlsdorf',            8004661, 10.0319680, 53.6208730 ],
	[ 'AOH',   'Hamburg-Othmarschen',         8004719, 9.88596700, 53.5592330 ],
	[ 'APB',   'Hamburg-Poppenbüttel',       8004862, 10.0940340, 53.6521830 ],
	[ 'ARAL',  'Hamburg-Rahlstedt',           8002558, 10.1543960, 53.6048570 ],
	[ 'ARI',   'Hamburg-Rissen',              8005106, 9.75705700, 53.5832160 ],
	[ 'ARIS',  'Hamburg-Rissen',              8005106, 9.75705700, 53.5832160 ],
	[ 'AROP',  'Hamburg-Rothenburgsort',      8005191, 10.0439530, 53.5384760 ],
	[ 'AHROO', 'Hamburg-Rothenburgsort',      8005191, 10.0439530, 53.5384760 ],
	[ 'ASLS',  'Hamburg-Schnelsen',           8007045, 9.90661600, 53.6341240 ],
	[ 'ASTL',  'Hamburg-Stellingen',          8002559, 9.91833600, 53.5898430 ],
	[ 'ASTS',  'Hamburg-Stellingen',          8002559, 9.91833600, 53.5898430 ],
	[ 'ASST',  'Hamburg-Sternschanze',        8070146, 9.96720400, 53.5637190 ],
	[ 'ASDF',  'Hamburg-Sülldorf',           8005785, 9.79751900, 53.5811220 ],
	[ 'ATK',   'Hamburg-Tiefstack',           8005870, 10.0655910, 53.5312250 ],
	[ 'AOW',   'Hamburg-Tonndorf',            8006197, 10.1230500, 53.5863850 ],
	[ 'AVLS',  'Hamburg-Veddel',              8006062, 10.0133130, 53.5217030 ],
	[ 'AWN',   'Hamburg-Wandsbek',            8002560, 10.0772240, 53.5699710 ],
	[ 'AWBS',  'Hamburg-Wellingsbüttel',     8006319, 10.0828250, 53.6413270 ],
	[ 'AWFS',  'Hamburg-Wilhelmsburg',        8002561, 10.0070060, 53.4989360 ],
	[ 'HHM',   'Hameln',                      8000148, 9.37590600, 52.1018500 ],
	[ 'EHM',   'Hamm(Westf)',                 8000149, 7.80782100, 51.6780780 ],
	[ 'AHAM',  'Hammah',                      8002565, 9.36872800, 53.6121430 ],
	[ 'NHG',   'Hammelburg',                  8002567, 9.88296600, 50.1200410 ],
	[ 'NHGO',  'Hammelburg Ost',              8002568, 9.90211100, 50.1158890 ],
	[ 'WHAM',  'Hammelspring',                8011815, 13.4357440, 53.0702280 ],
	[ 'MHAU',  'Hammerau',                    8002570, 12.9461340, 47.7958830 ],
	[ 'RHST',  'Hammerstein',                 8070419, 7.64414800, 47.6902950 ],
	[ 'DHUW',  'Hammerunterwiesenthal',       8011817, 13.0087220, 50.4410910 ],
	[ 'EHK',   'Hamminkeln',                  8002571, 6.60174500, 51.7351040 ],
	[ 'FH',    'Hanau Hbf',                   8000150, 8.92900000, 50.1209530 ],
	[ 'FH  N', 'Hanau Hbf',                   8000150, 8.92900000, 50.1209530 ],
	[ 'FH  S', 'Hanau Hbf',                   8000150, 8.92900000, 50.1209530 ],
	[ 'FKAH',  'Hanau Klein-Auheim',          8003311, 8.93428800, 50.1007340 ],
	[ 'FHN',   'Hanau Nord',                  8002572, 8.92584800, 50.1414330 ],
	[ 'FHW',   'Hanau West',                  8002573, 8.90881800, 50.1319490 ],
	[ 'FHWB',  'Hanau-Wilhelmsbad',           8002574, 8.88325000, 50.1438720 ],
	[ 'AHAN',  'Handeloh',                    8002575, 9.84471100, 53.2416930 ],
	[ 'THFT',  'Hanfertal',                   8007235, 9.23565200, 48.0997670 ],
	[ 'KHIBM', 'Hangelar Mitte',              8070076, 7.16595800, 50.7602010 ],
	[ 'BHGB',  'Hangelsberg',                 8011818, 13.9209160, 52.4002710 ],
	[ 'FHMD',  'Hann Münden',                8006707, 9.65827200, 51.4125820 ],
	[ 'HAMI',  'Hannover Anderten-Misburg',   8000578, 9.86110900, 52.3691610 ],
	[ 'HHBI',  'Hannover Bismarckstr.',       8002580, 9.76972800, 52.3564560 ],
	[ 'HLGF',  'Hannover Flughafen',          8002589, 9.69910500, 52.4587250 ],
	[ 'HH',    'Hannover Hbf',                8000152, 9.74102100, 52.3767610 ],
	[ 'HKWA', 'Hannover Karl-Wiechert-Allee', 8070086, 9.80811600, 52.3744170 ],
	[ 'HHML', 'Hannover Messe/Laatzen',       8003487, 9.79286300, 52.3168990 ],
	[ 'HHBO', 'Hannover-Bornum',              8002581, 9.67953800, 52.3502460 ],
	[ 'HKL',  'Hannover-Kleefeld',            8002584, 9.79061000, 52.3736070 ],
	[ 'HLEG', 'Hannover-Ledeburg',            8079097, 9.69111700, 52.4087870 ],
	[ 'HLEI', 'Hannover-Leinhausen',          8002585, 9.67630000, 52.3968530 ],
	[ 'HLI R', 'Hannover-Linden/Fischerhof', 8002586, 9.72311400, 52.3526360 ],
	[ 'HHN',   'Hannover-Nordstadt',         8079095, 9.71776300, 52.3938450 ],
	[ 'HVIN',  'Hannover-Vinnhorst',         8006089, 9.70772900, 52.4240430 ],
	[ 'NHAP',  'Happurg',                    8002578, 11.4683550, 49.5000520 ],
	[ 'AHA',   'Harblek',                    8002592, 8.96264600, 54.3619710 ],
	[ 'MHRG',  'Harburg(Schwab)',            8002593, 10.6984550, 48.7788980 ],
	[ 'HHRD',  'Hardegsen',                  8002594, 9.82603200, 51.6590200 ],
	[ 'NHHF',  'Hardhof',                    8002596, 10.7847260, 49.4969250 ],
	[ 'HHAR',  'Haren(Ems)',                 8002598, 7.30142800, 52.7851230 ],
	[ 'UH',    'Harra',                      8011820, 11.6860060, 50.4184760 ],
	[ 'UHNO',  'Harra Nord',                 8011821, 11.6746920, 50.4291700 ],
	[ 'UHRS',  'Harras(Thür)',              8011822, 10.8580720, 50.4129810 ],
	[ 'NH',    'Harsdorf',                   8002605, 11.5662730, 50.0277620 ],
	[ 'AHFD',  'Harsefeld',                  8007843, 9.49865700, 53.4500620 ],
	[ 'HHRS',  'Harsum',                     8002607, 9.96569700, 52.2064960 ],
	[ 'DHST',  'Hartenstein',                8011823, 12.6586530, 50.6518330 ],
	[ 'NHAR',  'Hartershofen',               8002609, 10.2422380, 49.4167620 ],
	[ 'MHHS',  'Harthaus',                   8002610, 11.3878670, 48.1335020 ],
	[ 'DHMU',  'Hartmannmühle',             8011825, 13.7924180, 50.7783840 ],
	[ 'NHS',   'Hartmannshof',               8002612, 11.5545620, 49.4988580 ],
	[ 'FHAX',  'Harxheim-Zell',              8070253, 8.13788500, 49.6407400 ],
	[ 'LHZG',  'Harzgerode',                 8017012, 11.1426410, 51.6434600 ],
	[ 'HHSB',  'Hasbergen',                  8002615, 7.95396700, 52.2416970 ],
	[ 'RRZB',  'Haselbrunn',                 8077771, 8.97530900, 47.7445300 ],
	[ 'RHS',   'Haslach',                    8002621, 8.08797500, 48.2800400 ],
	[ 'NHCH',  'Hasloch(Main)',              8002622, 9.48212500, 49.7893350 ],
	[ 'AHLH',  'Hasloh',                     8007048, 9.91990600, 53.6945690 ],
	[ 'AHLF',  'Haslohfurth',                8079025, 9.98676000, 53.7445680 ],
	[ 'MHMR',  'Haspelmoor',                 8002623, 11.0987840, 48.2232630 ],
	[ 'SHSS',  'Hassel(Saar)',               8002625, 7.17130900, 49.2633230 ],
	[ 'FHL',   'Hasselborn',                 8002627, 8.49533600, 50.4065930 ],
	[ 'LHAF',  'Hasselfelde',                8017013, 10.8509030, 51.6876990 ],
	[ 'HHAS',  'Haste',                      8002634, 9.38909700, 52.3796560 ],
	[ 'FHAT',  'Hattenheim',                 8002635, 8.05680000, 50.0136630 ],
	[ 'FHAS',  'Hattersheim(Main)',          8002637, 8.48963800, 50.0678790 ],
	[ 'KHAT',  'Hattert',                    8002638, 7.77588600, 50.6761300 ],
	[ 'EHTM',  'Hattingen(R) Mitte',         8002640, 7.18053800, 51.3971980 ],
	[ 'EHAT',  'Hattingen(Ruhr)',            8002639, 7.16986500, 51.4009110 ],
	[ 'HHTF',  'Hattorf',                    8002641, 10.2359990, 51.6462230 ],
	[ 'SHZ',   'Hatzenport',                 8002643, 7.41350800, 50.2276780 ],
	[ 'THAU',  'Haubersbronn',               8007192, 9.55007200, 48.8243300 ],
	[ 'THAM',  'Haubersbronn Mitte',         8070078, 9.54900100, 48.8308730 ],
	[ 'SHAM',  'Hauenstein Mitte',           8002648, 7.84956400, 49.1991690 ],
	[ 'SHAU',  'Hauenstein(Pfalz)',          8002649, 7.83025200, 49.2013900 ],
	[ 'FNK',   'Haunetal-Neukirchen',        8004297, 9.69254600, 50.7708380 ],
	[ 'MHPH',  'Haupeltshofen',              8002651, 10.3824300, 48.1804670 ],
	[ 'SHPT',  'Hauptstuhl',                 8002655, 7.49094900, 49.4019740 ],
	[ 'RHA',   'Hausach',                    8000333, 8.18166500, 48.2849240 ],
	[ 'KHAD',  'Hausen (b Düren)',          8007828, 6.49121200, 50.6525760 ],
	[ 'THAT',  'Hausen i Tal',               8002656, 9.02757400, 48.0804080 ],
	[ 'UHAU',  'Hausen(Eichsfeld)',          8011834, 10.3791670, 51.3825230 ],
	[ 'MHNS',  'Hausen(Schwab)',             8002664, 10.4825170, 48.1010040 ],
	[ 'FHS',   'Hausen(Taunus)',             8007847, 8.50724400, 50.3077490 ],
	[ 'RHSN',  'Hausen-Raitbach',            8002666, 7.84604100, 47.6793100 ],
	[ 'THSS',  'Hausen-Starzeln',            8007225, 9.06804700, 48.3017440 ],
	[ 'MHHM',  'Hausham',                    8002667, 11.8402570, 47.7504120 ],
	[ 'EHBK',  'Havixbeck',                  8002670, 7.40771100, 51.9667130 ],
	[ 'NHT',   'Haßfurt',                   8002630, 10.5099980, 50.0333230 ],
	[ 'RHLO',  'Haßloch(Pfalz)',            8002632, 8.25339600, 49.3719560 ],
	[ 'RHAS',  'Haßmersheim',               8002633, 9.15412900, 49.3040300 ],
	[ 'MHEF',  'Hebertsfelden',              8002671, 12.8185330, 48.4164960 ],
	[ 'MHSN',  'Hebertshausen',              8006189, 11.4554870, 48.2911060 ],
	[ 'THCH',  'Hechingen',                  8002673, 8.96877500, 48.3596010 ],
	[ 'THIL',  'Hechingen Landesbahn',       8082673, 8.96815500, 48.3590520 ],
	[ 'AHEN',  'Hechthausen',                8002674, 9.22807100, 53.6387160 ],
	[ 'RGCH',  'Heddesheim/Hirschberg',      8002430, 8.63374600, 49.5094080 ],
	[ 'FHED',  'Hedemünden',                8002677, 9.76214400, 51.3921640 ],
	[ 'NHED',  'Hedersdorf',                 8002678, 11.3387050, 49.5693440 ],
	[ 'LHEW',  'Hedersleben-Wedderstedt',    8011838, 11.2507710, 51.8446880 ],
	[ 'EHE P', 'Heessen',                    8002680, 7.83155100, 51.7091950 ],
	[ 'EHEG',  'Heggen',                     8002682, 7.96323800, 51.1535170 ],
	[ 'RHGN',  'Hegne',                      8002683, 9.09957200, 47.7060370 ],
	[ 'AHI',   'Heide(Holst)',               8000155, 9.10102900, 54.1935630 ],
	[ 'RH',    'Heidelberg Hbf',             8000156, 8.67544200, 49.4035670 ],
	[ 'RHBO',  'Heidelberg Orthopädie',     8002684, 8.77491300, 49.4099950 ],
	[ 'RHKA',  'Heidelberg-Altstadt',        8002685, 8.72088700, 49.4152370 ],
	[
		'RHKM', 'Heidelberg-Kirchheim/Rohrbach', 8002686, 8.67538300,
		49.3793890
	],
	[
		'RHBP', 'Heidelberg-Pfaffengrund/Wieblingen',
		8002687, 8.64157000, 49.4119290
	],
	[
		'RSR', 'Heidelberg-Schlierbach/Ziegelhausen',
		8005366, 8.76056400, 49.4153090
	],
	[
		'RHBF',  'Heidelberg-Weststadt/Südstadt',
		8002681, 8.68874900,
		49.3983240
	],
	[ 'RHI',  'Heidelsheim',              8002688, 8.64948300, 49.1016100 ],
	[ 'RHIO', 'Heidelsheim Nord',         8070010, 8.64525200, 49.1051130 ],
	[ 'DHD',  'Heidenau',                 8010163, 13.8578870, 50.9818590 ],
	[ 'DHDS', 'Heidenau Süd',            8011843, 13.8747170, 50.9716960 ],
	[ 'DHDG', 'Heidenau-Großsedlitz',    8011844, 13.8948770, 50.9608220 ],
	[ 'THD',  'Heidenheim',               8002689, 10.1566420, 48.6801700 ],
	[ 'THDV', 'Heidenheim Voithwerk',     8070005, 10.1560770, 48.6694820 ],
	[ 'THDM', 'Heidenheim-Mergelstetten', 8002690, 10.1609760, 48.6532790 ],
	[ 'THDS', 'Heidenheim-Schnaitheim',   8002691, 10.1587600, 48.7082810 ],
	[ 'FHEI', 'Heidesheim(Rheinhess)',    8002692, 8.11131800, 49.9970230 ],
	[ 'HHEI', 'Heidkrug',                 8002694, 8.68019500, 53.0570930 ],
	[ 'NHEI', 'Heigenbrücken',           8002696, 9.36394300, 50.0272320 ],
	[ 'UHT',  'Heilbad Heiligenstadt',    8011849, 10.1238450, 51.3770670 ],
	[
		'TBCB', 'Heilbr.-Böckingen Berufsschulzentrum',
		8079631, 9.18232800, 49.1404270
	],
	[ 'TH  A', 'Heilbronn Finanzamt',     8070791, 9.23501000, 49.1405270 ],
	[ 'TH  F', 'Heilbronn Friedensplatz', 8070792, 9.22877600, 49.1413130 ],
	[
		'THSTR', 'Heilbronn Hans-Rießer-Straße',
		8072723, 9.21956500,
		49.1626030
	],
	[ 'TH  H', 'Heilbronn Harmonie', 8070172, 9.22300600, 49.1415860 ],
	[
		'TH  W', 'Heilbronn Harmonie/Hafenmarktpassage',
		8071172, 9.22243600, 49.1427020
	],
	[
		'TH  O', 'Heilbronn Harmonie/Kunsthalle',
		8072172, 9.22259900,
		49.1424860
	],
	[
		'TH  B', 'Heilbronn Hauptbahnhof/Willy-Brandt-Pl.',
		8070171, 9.20835600, 49.1425940
	],
	[ 'TH',    'Heilbronn Hbf',            8000157, 9.20771500, 49.1433060 ],
	[ 'THSTI', 'Heilbronn Industrieplatz', 8002723, 9.21788600, 49.1553210 ],
	[ 'TNSK',  'Heilbronn Kaufland',       8002726, 9.22468700, 49.1700760 ],
	[
		'TH  P', 'Heilbronn Neckar-Turm/K.-S.-Pl',
		8070174, 9.21375800,
		49.1426560
	],
	[ 'TH  U', 'Heilbronn Pfühlpark', 8070793, 9.24138200, 49.1399560 ],
	[ 'TH  R', 'Heilbronn Rathaus',    8070173, 9.21906000, 49.1419440 ],
	[ 'THST',  'Heilbronn Sülmertor', 8002699, 9.22059800, 49.1516010 ],
	[
		'THSTS', 'Heilbronn Technisches Schulzentrum',
		8072722, 9.22149000, 49.1486670
	],
	[ 'TH  T', 'Heilbronn Theater',          8002722, 9.22215000, 49.1462730 ],
	[ 'TTPS',  'Heilbronn Trappensee',       8002700, 9.25257000, 49.1402820 ],
	[ 'WHDM',  'Heiligendamm',               8011846, 11.8428630, 54.1416770 ],
	[ 'WHEG',  'Heiligengrabe',              8011848, 12.3405370, 53.1496800 ],
	[ 'MHEI',  'Heiligenstatt(Obb)',         8002703, 12.6095850, 48.2133590 ],
	[ 'RHN',   'Heiligenstein(Pfalz)',       8002704, 8.39372600, 49.2856600 ],
	[ 'NHE',   'Heilsbronn',                 8002705, 10.7910530, 49.3459500 ],
	[ 'KHE',   'Heimbach (Eifel)',           8007829, 6.47350000, 50.6365150 ],
	[ 'SHB',   'Heimbach(Nahe)',             8002707, 7.23104700, 49.6176760 ],
	[ 'SHBO',  'Heimbach(Nahe)Ort',          8007887, 7.25198200, 49.6132120 ],
	[ 'MHMK',  'Heimenkirch',                8002710, 9.90210000, 47.6289090 ],
	[ 'KHEH',  'Heimersheim',                8002711, 7.17440900, 50.5474500 ],
	[ 'MHEM',  'Heimstetten',                8002715, 11.7596590, 48.1587550 ],
	[ 'FHEB',  'Heinebach',                  8002716, 9.66442300, 51.0457390 ],
	[ 'KHEBK', 'Heinsberg Kreishaus',        8002725, 6.10894000, 51.0617740 ],
	[ 'KHEB',  'Heinsberg(Rheinl)',          8002721, 6.09888100, 51.0650370 ],
	[ 'KDRN',  'Heinsberg-Dremmen',          8001557, 6.15251500, 51.0456830 ],
	[ 'KHEBH', 'Heinsberg-Horst',            8002719, 6.18230300, 51.0288410 ],
	[ 'KOB',   'Heinsberg-Oberbruch',        8004519, 6.13508400, 51.0530720 ],
	[ 'KHEBP', 'Heinsberg-Porselen',         8002720, 6.17448200, 51.0406150 ],
	[ 'KHEBR', 'Heinsberg-Randerath',        8002718, 6.18244900, 51.0162440 ],
	[ 'AHWA',  'Heinschenwalde',             8007807, 8.97291300, 53.4987280 ],
	[ 'SHZH',  'Heinzenhausen',              8002724, 7.60690200, 49.6257030 ],
	[ 'RHE',   'Heitersheim',                8002727, 7.64619400, 47.8798590 ],
	[ 'UHD',   'Heldrungen',                 8011852, 11.1831860, 51.3021710 ],
	[ 'BHEL',  'Helenesee',                  8011853, 14.4782190, 52.2787580 ],
	[ 'NHB',   'Helmbrechts',                8002733, 11.7243510, 50.2338000 ],
	[ 'DHLF',  'Helmsdorf(Pirna)',           8011855, 14.0464910, 51.0342050 ],
	[ 'RHSM',  'Helmsheim',                  8002734, 8.65133600, 49.0857500 ],
	[ 'RHM',   'Helmstadt(Baden)',           8007444, 8.97513000, 49.3200890 ],
	[ 'HHLM',  'Helmstedt',                  8000159, 11.0105530, 52.2220860 ],
	[ 'EHEP',  'Helpup',                     8002737, 8.71472500, 51.9773800 ],
	[ 'EHMD',  'Hemmerde',                   8002745, 7.80336400, 51.5539420 ],
	[ 'SHEM',  'Hemmersdorf(Saar)',          8002746, 6.61456900, 49.3539980 ],
	[ 'THMG',  'Hemmingen',                  8007327, 9.03169600, 48.8677830 ],
	[ 'AHEM',  'Hemmoor',                    8000815, 9.16580300, 53.6840810 ],
	[ 'RHCH',  'Hemsbach',                   8002748, 8.64872200, 49.5908690 ],
	[ 'NHD',   'Henfenfeld',                 8002751, 11.3865500, 49.5014120 ],
	[ 'KHES',  'Hennef im Siegbogen',        8002775, 7.31328800, 50.7731560 ],
	[ 'KHEN',  'Hennef(Sieg)',               8002753, 7.28459200, 50.7733320 ],
	[ 'EHNE',  'Hennen',                     8002754, 7.64684700, 51.4371550 ],
	[ 'DHRF',  'Hennersdorf(Sachs)',         8011856, 13.0709190, 50.7917510 ],
	[ 'BHND',  'Hennigsdorf(b Berlin)',      8013483, 13.2054540, 52.6382570 ],
	[ 'AUB',   'Henstedt-Ulzburg',           8007053, 9.98218200, 53.7951210 ],
	[ 'FHP',   'Heppenheim(Bergstr)',        8002757, 8.63337900, 49.6415530 ],
	[ 'THT',   'Herbertingen',               8000160, 9.41460400, 48.0639450 ],
	[ 'THTO',  'Herbertingen Ort',           8002760, 9.43339700, 48.0535700 ],
	[ 'MHEH',  'Herbertshofen',              8002761, 10.8480270, 48.5295280 ],
	[ 'RHRB',  'Herblingen',                 8002762, 8.66412700, 47.7170030 ],
	[ 'RHZ',   'Herbolzheim(Breisg)',        8002763, 7.76763800, 48.2238660 ],
	[ 'THZ',   'Herbolzheim(Jagst)',         8002764, 9.25982400, 49.2814940 ],
	[ 'FHRB',  'Herborn(Dillkr)',            8000161, 8.30814000, 50.6844050 ],
	[ 'THC',   'Herbrechtingen',             8002766, 10.1703340, 48.6256340 ],
	[ 'KHEC',  'Herchen',                    8002768, 7.52134900, 50.7712690 ],
	[ 'EHCK',  'Herdecke',                   8002769, 7.43261900, 51.4048060 ],
	[ 'EHF',   'Herdorf',                    8002770, 7.95307400, 50.7783010 ],
	[ 'EHFD',  'Herford',                    8000162, 8.66364300, 52.1196090 ],
	[ 'MHGZ',  'Hergatz',                    8000387, 9.82738200, 47.6468100 ],
	[ 'FHER',  'Hergershausen',              8002773, 8.91657500, 49.9368020 ],
	[ 'UHRH',  'Heringen(Helme)',            8011860, 10.8752550, 51.4514980 ],
	[ 'WHFN',  'Heringsdorf Neuhof',         8087026, 14.1482590, 53.9527650 ],
	[ 'DHN',   'Herlasgrün',                8010166, 12.2354240, 50.5709360 ],
	[ 'UHER',  'Herleshausen Hp',            8013548, 10.1716610, 51.0026420 ],
	[ 'THMA',  'Hermaringen',                8002776, 10.2583310, 48.5945840 ],
	[ 'THMT',  'Hermentingen',               8007231, 9.21746700, 48.2008450 ],
	[ 'DHS',   'Hermsdorf(Dresden)',         8011861, 13.8153510, 51.1655450 ],
	[ 'UHK',   'Hermsdorf-Klosterlausnitz',  8011862, 11.8586260, 50.9037790 ],
	[ 'EHER',  'Herne',                      8000164, 7.21783000, 51.5436520 ],
	[ 'EHBO',  'Herne-Börnig',              8002779, 7.26835000, 51.5547890 ],
	[ 'NHER',  'Heroldsberg',                8002782, 11.1499140, 49.5287570 ],
	[ 'NHEN',  'Heroldsberg Nord',           8002783, 11.1468040, 49.5445820 ],
	[ 'KHER',  'Herrath',                    8002784, 6.36739900, 51.1043160 ],
	[ 'THE',   'Herrenberg',                 8002785, 8.86266200, 48.5939910 ],
	[ 'THE Z', 'Herrenberg',                 8002785, 8.86266200, 48.5939910 ],
	[ 'TZWE',  'Herrenberg Zwerchweg',       8002786, 8.86766100, 48.5849690 ],
	[ 'BHE',   'Herrensee',                  8011863, 13.8865770, 52.5299280 ],
	[ 'THL',   'Herrlingen',                 8002789, 9.89773000, 48.4177310 ],
	[ 'THH',   'Herrlishöfen',              8079099, 9.80846500, 48.1394400 ],
	[ 'WHB',   'Herrnburg',                  8011864, 10.7600080, 53.8377070 ],
	[ 'MHI',   'Herrsching',                 8002792, 11.1705710, 47.9988490 ],
	[ 'NHL',   'Hersbruck(l Pegnitz)',       8002793, 11.4351430, 49.5004620 ],
	[ 'NHR',   'Hersbruck(r Pegnitz)',       8002794, 11.4238260, 49.5100730 ],
	[ 'RHRT',  'Herten(Baden)',              8002797, 7.73966300, 47.5495070 ],
	[ 'EHDT',  'Hervest-Dorsten',            8000165, 6.97416700, 51.6719100 ],
	[ 'RHXB',  'Herxheim am Berg',           8002798, 8.19004400, 49.5094910 ],
	[ 'HHBS',  'Herzberg Schloß',           8002800, 10.3328040, 51.6544950 ],
	[ 'LHZW',  'Herzberg(Elster)',           8011867, 13.2027860, 51.6794460 ],
	[ 'HHB',   'Herzberg(Harz)',             8000166, 10.3299230, 51.6438610 ],
	[ 'WHE',   'Herzberg(Mark)',             8010167, 12.9783910, 52.9053610 ],
	[ 'EHEZ',  'Herzebrock',                 8002801, 8.23626800, 51.8802250 ],
	[ 'AHZH',  'Herzhorn',                   8079605, 9.48388400, 53.7835370 ],
	[ 'KHEZ',  'Herzogenrath',               8002806, 6.09448600, 50.8709160 ],
	[ 'KMKW',  'Herzogenrath-Alt-Merkstein', 8002804, 6.10099900, 50.8854340 ],
	[
		'KMK', 'Herzogenrath-August-Schmidt-Platz',
		8002816, 6.11950400, 50.8869620
	],
	[ 'AHOF',  'Hesedorf',                    8007808, 9.19504800, 53.4727150 ],
	[ 'RHBA',  'Heselbach',                   8002808, 8.39896700, 48.5366890 ],
	[ 'HHES',  'Hesepe',                      8000167, 7.96759900, 52.4392210 ],
	[ 'EHLN',  'Hesseln',                     8002810, 8.31195600, 52.0683970 ],
	[ 'FKAI',  'Hesseneck Kailbach',          8003144, 9.07748200, 49.5393380 ],
	[ 'FSCH',  'Hesseneck Schöllenbach',     8005393, 9.06745700, 49.5659240 ],
	[ 'HHSO',  'Hessisch Oldendorf',          8002812, 9.24361400, 52.1668730 ],
	[ 'UHET',  'Hetschburg',                  8011869, 11.2982050, 50.9128020 ],
	[ 'FHH',   'Hettenhausen',                8002814, 9.81465700, 50.4483970 ],
	[ 'THTN',  'Hettingen(Hohenz)',           8007230, 9.22929800, 48.2173640 ],
	[ 'LHE',   'Hettstedt',                   8010168, 11.5132310, 51.6369450 ],
	[ 'DHZF',  'Hetzdorf(Flöhatal)',         8011870, 13.1276950, 50.8403130 ],
	[ 'SHR',   'Hetzerath',                   8002817, 6.79838500, 49.8781340 ],
	[ 'LHR',   'Heudeber-Danstedt',           8010169, 10.8664950, 51.9047400 ],
	[ 'MHEU',  'Heufeld',                     8002820, 11.9673800, 47.8711950 ],
	[ 'MHFM',  'Heufeldmühle',               8002821, 11.9343560, 47.8775510 ],
	[ 'FHEU',  'Heusenstamm',                 8002822, 8.80220200, 50.0600690 ],
	[ 'HHIS',  'Hiddenhausen-Schweicheln',    8002824, 8.66823900, 52.1584400 ],
	[ 'EHIB',  'Hilchenbach',                 8002826, 8.10714600, 50.9922600 ],
	[ 'UHN',   'Hildburghausen',              8011871, 10.7178280, 50.4251330 ],
	[ 'KHI',   'Hilden',                      8000388, 6.92200600, 51.1670200 ],
	[ 'KHIS',  'Hilden Süd',                 8002828, 6.93736600, 51.1636820 ],
	[ 'HHI',   'Hildesheim Hbf',              8000169, 9.95349700, 52.1606260 ],
	[ 'HHIO',  'Hildesheim Ost',              8002830, 9.96316900, 52.1465510 ],
	[ 'EHIL',  'Hillnhütten',                8002835, 8.07131700, 50.9727780 ],
	[ 'RHLT',  'Hilpertsau',                  8002837, 8.34868300, 48.7398950 ],
	[ 'NHP',   'Hilpoltstein',                8002838, 11.1841460, 49.1887730 ],
	[ 'HHIL',  'Hilter',                      8002839, 8.15230100, 52.1352560 ],
	[ 'AHPF',  'Himmelpforten',               8002843, 9.31046500, 53.6233010 ],
	[ 'RHIM',  'Himmelreich',                 8002844, 7.99135600, 47.9586160 ],
	[ 'NHIS',  'Himmelstadt',                 8002845, 9.80821400, 49.9234380 ],
	[ 'MHRS',  'Hinrichssegen',               8002850, 11.9506580, 47.8744160 ],
	[ 'SHWP',  'Hinterweidenthal',            8002847, 7.74767600, 49.2015680 ],
	[ 'SHWO',  'Hinterweidenthal Ort',        8079088, 7.75056800, 49.1974980 ],
	[ 'SHW',   'Hinterweidenthal Ost',        8079147, 7.77304700, 49.2031320 ],
	[ 'RHIZ',  'Hinterzarten',                8002848, 8.10603300, 47.9062780 ],
	[ 'THI',   'Hirsau',                      8002852, 8.73679000, 48.7340590 ],
	[ 'NHI',   'Hirschaid',                   8002853, 10.9910640, 49.8195950 ],
	[ 'DHE',   'Hirschfelde',                 8011878, 14.8910180, 50.9433880 ],
	[ 'MHFN',  'Hirschfelden',                8002856, 10.3622650, 48.2895310 ],
	[ 'RHO',   'Hirschhorn(Neckar)',          8002857, 8.89605500, 49.4426680 ],
	[ 'SHIH',  'Hirschhorn(Pfalz)',           8002858, 7.68100800, 49.5155880 ],
	[ 'AHIF',  'Hittfeld',                    8002864, 9.97452500, 53.4037120 ],
	[ 'AHZ',   'Hitzacker',                   8002865, 11.0381990, 53.1391580 ],
	[ 'KHO',   'Hochdahl',                    8002868, 6.94441900, 51.2188320 ],
	[ 'KHOM',  'Hochdahl-Millrath',           8002869, 6.96668400, 51.2165010 ],
	[ 'THF',   'Hochdorf(b Horb)',            8000389, 8.72405200, 48.4824850 ],
	[ 'THO',   'Hochhausen(Tauber)',          8002871, 9.63323500, 49.6638120 ],
	[ 'FHM',   'Hochheim(Main)',              8002872, 8.35039800, 50.0042530 ],
	[ 'KHOK',  'Hochneukirch',                8000390, 6.46631600, 51.1032930 ],
	[ 'SHY',   'Hochspeyer',                  8002875, 7.90424400, 49.4439930 ],
	[ 'NHM',   'Hochstadt-Marktzeuln',        8002878, 11.1725940, 50.1531390 ],
	[ 'RHOS',  'Hochstetten',                 8007201, 8.41577000, 49.1335710 ],
	[ 'RHOSG', 'Hochstetten Grenzstraße',    8079042, 8.41572300, 49.1295500 ],
	[ 'SHS',   'Hochstetten(Nahe)',           8002880, 7.51096200, 49.7986620 ],
	[ 'SHST',  'Hochstätten(Pfalz)',         8002879, 7.82909600, 49.7633420 ],
	[ 'MHWG',  'Hochwang',                    8002881, 10.2980070, 48.3891210 ],
	[ 'RHK',   'Hockenheim',                  8002883, 8.53738500, 49.3174140 ],
	[ 'UHR',   'Hockeroda',                   8010170, 11.4342820, 50.5977200 ],
	[ 'HHOD',  'Hodenhagen',                  8002884, 9.59505600, 52.7665640 ],
	[ 'NHO',   'Hof Hbf',                     8002924, 11.9230670, 50.3077430 ],
	[ 'RHOF',  'Hof(Münstertal)',            8007336, 7.77265400, 47.8571220 ],
	[ 'NHON',  'Hof-Neuhof',                  8002927, 11.9047110, 50.3215380 ],
	[ 'SHFD',  'Hofeld',                      8002929, 7.15975500, 49.5119220 ],
	[ 'THOF',  'Hofen(b Aalen)',              8002930, 10.1144070, 48.8726920 ],
	[ 'RHFF',  'Hoffenheim',                  8002931, 8.83841100, 49.2720370 ],
	[ 'KHOF',  'Hoffnungsthal',               8002932, 7.19651300, 50.9113630 ],
	[ 'FHFG',  'Hofgeismar',                  8002933, 9.39546100, 51.4991860 ],
	[ 'FHMM',  'Hofgeismar-Hümme',           8003015, 9.40196500, 51.5429230 ],
	[ 'FHOR',  'Hofheim (Ried)',              8002934, 8.40897000, 49.6594670 ],
	[ 'FHF',   'Hofheim(Taunus)',             8002935, 8.44384200, 50.0844710 ],
	[ 'KHOG',  'Hohegrete',                   8002939, 7.64247900, 50.7648500 ],
	[ 'BHOW',  'Hohen Neuendorf West',        8080710, 13.2713420, 52.6723980 ],
	[ 'BHN',   'Hohen Neuendorf(b Berlin)',   8080720, 13.2870910, 52.6690720 ],
	[ 'MHOB',  'Hohenbrunn',                  8002940, 11.6988720, 48.0465720 ],
	[ 'WHOD',  'Hohendorf',                   8011889, 13.7302680, 54.0272700 ],
	[ 'UHOO',  'Hohenebra Ort',               8011891, 10.8091720, 51.3061460 ],
	[ 'HHEP',  'Hoheneggelsen',               8002944, 10.1978200, 52.2001770 ],
	[ 'DHOF',  'Hohenfichte',                 8011892, 13.1339810, 50.8220640 ],
	[ 'BHL',   'Hohenleipisch',               8011894, 13.5649690, 51.4927560 ],
	[ 'UHOL',  'Hohenleuben',                 8011895, 12.0363990, 50.7031610 ],
	[ 'EHOG',  'Hohenlimburg',                8002953, 7.57168600, 51.3488540 ],
	[ 'MHPG',  'Hohenpeißenberg',            8002954, 10.9992510, 47.7887950 ],
	[ 'LHRA',  'Hohenroda',                   8011900, 12.4214340, 51.4990260 ],
	[ 'MHSL',  'Hohenschäftlarn',            8002955, 11.4575130, 47.9912990 ],
	[ 'NHOH',  'Hohenstadt(Mittelfr)',        8002956, 11.4914650, 49.5183390 ],
	[ 'DHO',   'Hohenstein-Ernstthal',        8011904, 12.7065640, 50.7985480 ],
	[ 'FHSU',  'Hohensülzen',                8002958, 8.21417300, 49.6217880 ],
	[ 'LHM',   'Hohenthurm',                  8011905, 12.0978810, 51.5123590 ],
	[ 'NHWN',  'Hohenwarth',                  8007342, 12.9431610, 49.2053890 ],
	[ 'NHWNC', 'Hohenwarth Campingplatz',     8070160, 12.9244480, 49.2048340 ],
	[ 'AHWT',  'Hohenwestedt',                8002959, 9.65416100, 54.0865890 ],
	[ 'LHWU',  'Hohenwulsch',                 8010172, 11.5951360, 52.6673190 ],
	[ 'DRDFH', 'Hohndorf Mitte',              8017422, 12.6757250, 50.7430480 ],
	[ 'WHOL',  'Holdorf(Meckl)',              8011908, 11.0657010, 53.7348000 ],
	[ 'HHDF',  'Holdorf(Oldb)',               8002962, 8.13836700, 52.5749710 ],
	[ 'AHES',  'Holm-Seppensen',              8002967, 9.87000800, 53.2848120 ],
	[ 'AKTKH', 'Holstentherme',               8007203, 9.94607700, 53.8399350 ],
	[ 'HHOL',  'Holtensen/Linderte',          8002969, 9.65322100, 52.2719530 ],
	[ 'WHO',   'Holthusen',                   8010173, 11.3648090, 53.5558310 ],
	[ 'LHZ',   'Holzdorf(Elster)',            8011909, 13.1141370, 51.7802910 ],
	[ 'UHF',   'Holzdorf(b Weimar)',          8011910, 11.2759200, 50.9421860 ],
	[ 'THZG',  'Holzgerlingen Bf',            8085010, 9.00694500, 48.6375250 ],
	[ 'THZGB', 'Holzgerlingen Buch',          8085011, 9.02476800, 48.6266960 ],
	[ 'THZGN', 'Holzgerlingen Nord',          8085009, 9.00963400, 48.6478570 ],
	[ 'DHU',   'Holzhau',                     8011912, 13.5916710, 50.7341080 ],
	[ 'DHUS',  'Holzhau Skilift',             8017218, 13.5733900, 50.7339080 ],
	[ 'EHOZ',  'Holzhausen(Kr Siegen)',       8002976, 8.13549500, 50.7393220 ],
	[ 'HHZH',  'Holzhausen-Heddinghausen',    8002978, 8.54585400, 52.2890970 ],
	[ 'KHOZ',  'Holzheim(b Neuss)',           8002979, 6.66462600, 51.1656530 ],
	[ 'MHO',   'Holzkirchen',                 8002980, 11.6972340, 47.8843840 ],
	[ 'HHZM',  'Holzminden',                  8000391, 9.45374300, 51.8202680 ],
	[ 'EHZW',  'Holzwickede',                 8000392, 7.61964700, 51.5047670 ],
	[ 'SHO',   'Homburg(Saar)Hbf',            8000176, 7.33703500, 49.3280820 ],
	[ 'KHOR',  'Honrath',                     8002988, 7.25288200, 50.9105890 ],
	[ 'LHGT',  'Hopfgarten(Sachs)',           8011914, 12.6626930, 51.1055740 ],
	[ 'UHP',   'Hopfgarten(Weimar)',          8011915, 11.2205910, 50.9842620 ],
	[ 'EHOP',  'Hoppecke',                    8002992, 8.64005900, 51.3780590 ],
	[ 'BHPG',  'Hoppegarten(Mark)',           8080750, 13.6729560, 52.5181220 ],
	[ 'BHPN',  'Hoppegarten(Mark)',           8080750, 13.6729560, 52.5181220 ],
	[ 'MHOP',  'Hoppingen',                   8002994, 10.6531980, 48.8038170 ],
	[ 'SHPS',  'Hoppstädten(Nahe)',          8002995, 7.19501100, 49.6155270 ],
	[ 'THB',   'Horb',                        8000177, 8.68898200, 48.4414710 ],
	[ 'THBH',  'Horb-Heiligenfeld',           8002998, 8.66015100, 48.4677960 ],
	[ 'BHR',   'Horka',                       8010174, 14.9020880, 51.3039850 ],
	[ 'EHBM',  'Horn-Bad Meinberg',           8003000, 8.95509200, 51.8815180 ],
	[ 'RHBG',  'Hornberg(Schwarzw)',          8003001, 8.23294000, 48.2118950 ],
	[ 'AHOG',  'Horneburg',                   8003002, 9.57655000, 53.5086770 ],
	[ 'WHOR',  'Hornstorf',                   8010176, 11.5346730, 53.9066880 ],
	[ 'KHR',   'Horrem',                      8000178, 6.71349700, 50.9162490 ],
	[ 'AHOT',  'Horst(Holst)',                8003003, 9.64515600, 53.8045960 ],
	[ 'BHC',   'Hosena',                      8010171, 14.0161050, 51.4547060 ],
	[ 'BHW',   'Hoyerswerda',                 8010177, 14.2314070, 51.4327880 ],
	[ 'HHOY',  'Hoykenkamp',                  8003008, 8.59868300, 53.0697990 ],
	[ 'RHAR',  'Hubacker',                    8003010, 8.13569100, 48.5073980 ],
	[ 'BHUB',  'Hubertushöhe',               8011923, 13.9651510, 52.2338700 ],
	[ 'KHUS',  'Huchem-Stammeln',             8007817, 6.45337000, 50.8525190 ],
	[ 'WHU',   'Huckstorf',                   8011924, 12.1160260, 53.9844800 ],
	[ 'HHUD',  'Hude',                        8000522, 8.46095600, 53.1094290 ],
	[ 'MHUF',  'Hufschlag',                   8003023, 12.6649410, 47.8755990 ],
	[ 'MHUG',  'Huglfing',                    8003024, 11.1405520, 47.7767360 ],
	[ 'RHU',   'Hugstetten',                  8003025, 7.78392900, 48.0482470 ],
	[ 'THUB',  'Hulb',                        8003022, 8.98264400, 48.6792670 ],
	[ 'RHUM',  'Hummelberg',                  8070020, 8.52680700, 49.0098100 ],
	[ 'DHUN',  'Hundsgrün',                  8011928, 12.2114520, 50.3662560 ],
	[ 'FHUN',  'Hundstadt',                   8007848, 8.46906300, 50.3709080 ],
	[ 'FHUG',  'Hungen',                      8000400, 8.89279000, 50.4780550 ],
	[ 'HHUL',  'Huntlosen',                   8003030, 8.26652000, 52.9908170 ],
	[ 'AY',    'Husby',                       8003032, 9.57550500, 54.7643720 ],
	[ 'AHM',   'Husum',                       8000181, 9.05502600, 54.4722710 ],
	[ 'RHTT',  'Huttenheim',                  8003033, 8.47263600, 49.1971620 ],
	[ 'RHUB',  'Huzenbach',                   8003034, 8.39127600, 48.5826250 ],
	[ 'BHAH',  'Hähnichen',                  8011795, 14.8567260, 51.3641190 ],
	[ 'FHAE',  'Hähnlein-Alsbach',           8002498, 8.60666400, 49.7393500 ],
	[ 'HHAE',  'Hämelerwald',                8002499, 10.1106010, 52.3547040 ],
	[ 'LHMT',  'Hämerten',                   8011796, 11.9717700, 52.5990240 ],
	[ 'FHHF',  'Häuserhof',                  8002501, 8.93915900, 50.4185940 ],
	[ 'FHET',  'Höchst Hetschbach',          8002813, 8.98319500, 49.8075960 ],
	[ 'FMGR',  'Höchst Mümling-Grumbach',   8004125, 8.98563800, 49.7716690 ],
	[ 'FHT',   'Höchst(Odenw)',              8000172, 8.98854900, 49.7944990 ],
	[ 'MHDT',  'Höchstädt(Donau)',          8002888, 10.5662180, 48.6183090 ],
	[ 'THOE',  'Höfen(Enz) Bf',              8002891, 8.58104000, 48.7985600 ],
	[ 'THON',  'Höfen(Enz) Nord',            8070279, 8.58172400, 48.8077090 ],
	[ 'THFG',  'Höfingen',                   8002892, 9.02531500, 48.8149860 ],
	[ 'MHSB',  'Höhenkirchen-Siegertsbrunn', 8002894, 11.7192260, 48.0184650 ],
	[ 'SHMB',  'Höhmühlbach',               8002895, 7.52602800, 49.2438930 ],
	[ 'NHTL',  'Höllenthal',                 8002898, 11.6838180, 50.3638000 ],
	[ 'MHRK',  'Höllriegelskreuth',          8002899, 11.5097520, 48.0434520 ],
	[ 'MHPF',  'Höpfling',                   8002908, 12.6511620, 47.8112260 ],
	[ 'RHOR',  'Hörden',                     8002910, 8.34519000, 48.7815230 ],
	[ 'MHLK',  'Hörlkofen',                  8002912, 11.9423410, 48.2425910 ],
	[ 'MHPD',  'Hörpolding',                 8002914, 12.5682610, 47.9641380 ],
	[ 'UHL',   'Hörschel Hp',                8013547, 10.2332710, 51.0077950 ],
	[ 'UHOS',  'Hörselgau',                  8087061, 10.5778660, 50.9233830 ],
	[ 'HHTL',  'Hörstel',                    8002915, 7.59155700, 52.2956860 ],
	[ 'EHOM',  'Hörstmar(Lippe)',            8002916, 8.84497800, 52.0125020 ],
	[ 'NHOE',  'Hösbach',                    8002918, 9.22900800, 49.9997130 ],
	[ 'EHOS',  'Hösel',                      8002919, 6.89323100, 51.3415210 ],
	[ 'EHOV',  'Hövelhof',                   8002920, 8.66168500, 51.8239910 ],
	[ 'EHVR',  'Hövelriege',                 8002921, 8.64206700, 51.8651230 ],
	[ 'HHXR',  'Höxter Rathaus',             8002923, 9.38191800, 51.7726040 ],
	[ 'KBA',   'Hückelhoven-Baal',           8000677, 6.27414900, 51.0334570 ],
	[ 'RHFH',  'Hüffenhardt',                8007439, 9.08680400, 49.2911320 ],
	[ 'RHFM',  'Hüfingen Mitte',             8003014, 8.49051100, 47.9299130 ],
	[ 'FHUE',  'Hünfeld',                    8003016, 9.76245300, 50.6732710 ],
	[ 'KKAS',  'Hürth-Kalscheuren',          8003160, 6.91022300, 50.8756710 ],
	[ 'THTT',  'Hütten',                     8070219, 9.64246200, 48.3709980 ],
	[ 'AHTB',  'Hüttenbusch',                8007119, 8.96215400, 53.2732960 ],
	[ 'UHUE',  'Hüttengrund',                8011925, 11.1977110, 50.3811530 ],
	[ 'SHT',   'Hüttingen',                  8003021, 6.58500800, 49.9674180 ],
	[ 'RIB',   'Ibach',                       8003035, 8.16273900, 48.4551160 ],
	[ 'HI',    'Ibbenbüren',                 8003036, 7.72148600, 52.2768670 ],
	[ 'HESH',  'Ibbenbüren-Esch',            8001867, 7.65596800, 52.2997460 ],
	[ 'HLGG',  'Ibbenbüren-Laggenbeck',      8003491, 7.78096200, 52.2648600 ],
	[ 'MIHN',  'Ichenhausen',                 8003038, 10.3021380, 48.3701870 ],
	[ 'MIC',   'Icking',                      8003039, 11.4366470, 47.9532490 ],
	[ 'SIDO',  'Idar-Oberstein',              8003040, 7.32123000, 49.6993680 ],
	[ 'FIST',  'Idstein(Taunus)',             8003041, 8.25726400, 50.2159900 ],
	[ 'MSTA',  'Iffeldorf',                   8005672, 11.3290190, 47.7820640 ],
	[ 'SIG',   'Igel',                        8003042, 6.55067900, 49.7073700 ],
	[ 'NIDF',  'Igensdorf',                   8003044, 11.2345300, 49.6201220 ],
	[ 'TIH',   'Igersheim',                   8003045, 9.81253500, 49.4934250 ],
	[ 'RIR',   'Ihringen',                    8003052, 7.64877700, 48.0404100 ],
	[ 'LIB',   'Ilberstedt',                  8011929, 11.6509220, 51.8068620 ],
	[ 'LIF',   'Ilfeld',                      8017014, 10.7895340, 51.5784150 ],
	[ 'LIFB',  'Ilfeld Bad',                  8080998, 10.7853330, 51.5952000 ],
	[ 'LIFN',  'Ilfeld Neanderklinik',        8070776, 10.7885300, 51.5834140 ],
	[ 'LIFS',  'Ilfeld Schreiberwiese',       8080990, 10.7871370, 51.5735490 ],
	[ 'MILT',  'Illertissen',                 8003057, 10.0999420, 48.2228280 ],
	[ 'NILL',  'Illesheim',                   8003058, 10.3826480, 49.4797310 ],
	[ 'SILG',  'Illingen(Saar)',              8003059, 7.04896600, 49.3764220 ],
	[ 'TIL',   'Illingen(Württ)',            8003060, 8.92116200, 48.9565880 ],
	[ 'UI',    'Ilmenau',                     8010178, 10.9230860, 50.6844810 ],
	[ 'UIB',   'Ilmenau Bad',                 8011931, 10.9089660, 50.6813480 ],
	[ 'UIP',   'Ilmenau Pörlitzer Höhe',    8011935, 10.9227530, 50.6946990 ],
	[ 'UIR',   'Ilmenau-Roda',                8011932, 10.8891110, 50.6972280 ],
	[ 'LIG',   'Ilsenburg',                   8011933, 10.6831030, 51.8690040 ],
	[ 'UIM',   'Immelborn',                   8011934, 10.2804150, 50.7932350 ],
	[ 'RIM',   'Immendingen',                 8000182, 8.72953600, 47.9360070 ],
	[ 'RIMM',  'Immendingen Mitte',           8003061, 8.73516200, 47.9371090 ],
	[ 'RIMZ',  'Immendingen Zimmern',         8003066, 8.71405100, 47.9328760 ],
	[ 'FIM',   'Immenhausen',                 8003062, 9.46439700, 51.4269020 ],
	[ 'NIM',   'Immenreuth',                  8003063, 11.8696600, 49.9113440 ],
	[ 'HIMS',  'Immensen-Arpke',              8003064, 10.0844790, 52.3913560 ],
	[ 'MIMS',  'Immenstadt',                  8003065, 10.2139990, 47.5592030 ],
	[ 'SIM',   'Imsweiler',                   8003070, 7.80797600, 49.5976560 ],
	[ 'KING',  'Ingelbach',                   8003073, 7.72621400, 50.6889030 ],
	[ 'FIL',   'Ingelheim',                   8003075, 8.05371600, 49.9762770 ],
	[ 'MIH',   'Ingolstadt Hbf',              8000183, 11.4373370, 48.7445410 ],
	[ 'MIN',   'Ingolstadt Nord',             8003076, 11.4329330, 48.7730870 ],
	[ 'MINI',  'Inningen',                    8003079, 10.8688760, 48.3113360 ],
	[ 'WIM',   'Inselstadt Malchow',          8012296, 12.4238080, 53.4820100 ],
	[ 'RIN',   'Insheim',                     8003080, 8.15213200, 49.1576240 ],
	[ 'NI',    'Iphofen',                     8003081, 10.2556220, 49.6966030 ],
	[ 'NIP',   'Ipsheim',                     8003083, 10.4857640, 49.5255000 ],
	[ 'DIR',   'Irfersgrün',                 8011937, 12.4096020, 50.6085470 ],
	[ 'NIR',   'Irrenlohe',                   8003086, 12.1013760, 49.3627760 ],
	[ 'EIL',   'Iserlohn',                    8000186, 7.69160800, 51.3732940 ],
	[ 'EILH',  'Iserlohnerheide',             8003090, 7.69221000, 51.3998610 ],
	[ 'HIHG',  'Isernhagen',                  8003091, 9.80384200, 52.4860910 ],
	[ 'MIS',   'Ismaning',                    8003092, 11.6794890, 48.2260120 ],
	[ 'TIP',   'Ispringen',                   8003094, 8.67222000, 48.9144270 ],
	[ 'EIAV',  'Isselhorst-Avenwedde',        8003096, 8.43852400, 51.9399760 ],
	[ 'RIT',   'Istein',                      8003098, 7.54294300, 47.6608890 ],
	[ 'RITB',  'Ittersbach Bahnhof',          8007014, 8.51104500, 48.8691540 ],
	[ 'RITBR', 'Ittersbach Rathaus',          8090001, 8.50982400, 48.8659020 ],
	[ 'NIL',   'Ittling',                     8003100, 12.6379980, 48.8849090 ],
	[ 'RITL',  'Ittlingen',                   8003101, 8.93458000, 49.1871190 ],
	[ 'AIZ',   'Itzehoe',                     8003102, 9.51028700, 53.9238730 ],
	[ 'TIT',   'Itzelberg',                   8003103, 10.1363000, 48.7306810 ],
	[ 'WJAB',  'Jabel(Meckl)',                8011939, 12.5475590, 53.5452630 ],
	[ 'BJF',   'Jacobsdorf(Mark)',            8011940, 14.3550370, 52.3326260 ],
	[ 'WJS',   'Jagdschloß',                 8011947, 13.6198720, 54.3764790 ],
	[ 'TJZ',   'Jagstzell',                   8003111, 10.0988190, 49.0312390 ],
	[ 'DJD',   'Jahnsdorf(Erzgeb)',           8011948, 12.8575110, 50.7549460 ],
	[ 'KJW',   'Jakobwüllesheim',            8071022, 6.56520900, 50.7667050 ],
	[ 'AJHH',  'Jarrenwisch',                 8003115, 8.96289600, 54.2120810 ],
	[ 'WJAS',  'Jasnitz',                     8011951, 11.3740580, 53.3863890 ],
	[ 'WJK',   'Jatznick',                    8010179, 13.9376710, 53.6030620 ],
	[ 'LJEB',  'Jeber-Bergfrieden',           8011952, 12.3496990, 51.9846370 ],
	[ 'RJ',    'Jechtingen',                  8007288, 7.61062400, 48.1198440 ],
	[ 'WJER',  'Jeeser',                      8011953, 13.2588020, 54.1645480 ],
	[ 'UJP',   'Jena Paradies',               8011956, 11.5874610, 50.9248560 ],
	[ 'UJS',   'Jena Saalbf',                 8011058, 11.5937830, 50.9369200 ],
	[ 'UJW',   'Jena West',                   8011957, 11.5778480, 50.9232860 ],
	[ 'UGW',   'Jena-Göschwitz',             8010133, 11.5935370, 50.8839420 ],
	[ 'UJZ',   'Jena-Zwätzen',               8011958, 11.6208750, 50.9554870 ],
	[ 'LJES',  'Jesewitz(Leipzig)',           8011959, 12.5450140, 51.4198860 ],
	[ 'LJN',   'Jessen(Elster)',              8011960, 12.9547220, 51.7927870 ],
	[ 'MJEB',  'Jettenbach',                  8003122, 12.3668200, 48.1714280 ],
	[ 'MJET',  'Jettingen',                   8003123, 10.4454730, 48.3991260 ],
	[ 'HJ',    'Jever',                       8003124, 7.89298000, 53.5687150 ],
	[ 'LJZ',   'Jeßnitz(Anh)',               8011961, 12.2773530, 51.6825520 ],
	[ 'WJT',   'Joachimsthal',                8011962, 13.7494730, 52.9803800 ],
	[ 'WWLS',  'Joachimsthal Kaiserbahnhof',  8013279, 13.7550160, 52.9639520 ],
	[ 'DJA',   'Jocketa',                     8011963, 12.1701030, 50.5552970 ],
	[ 'RJO',   'Jockgrim Bf',                 8003125, 8.27227200, 49.0922890 ],
	[ 'DJ',    'Johanngeorgenstadt',          8011967, 12.7287360, 50.4375960 ],
	[ 'NJS',   'Jossa',                       8003129, 9.60417800, 50.2325060 ],
	[ 'MJUL',  'Julbach',                     8003136, 12.9580250, 48.2508950 ],
	[ 'TJUH',  'Jungingen(Hohenz)',           8007223, 9.03812300, 48.3261870 ],
	[ 'TJNU',  'Jungnau',                     8007234, 9.21366400, 48.1391610 ],
	[ 'MJGS',  'Jägerhaus',                  8003106, 11.0877020, 47.6667820 ],
	[ 'SJF',   'Jägersfreude',               8003108, 7.00497000, 49.2657580 ],
	[ 'BJW',   'Jänschwalde',                8011944, 14.5007610, 51.8662730 ],
	[ 'BJWO',  'Jänschwalde Ost',            8011945, 14.5412480, 51.8778170 ],
	[ 'LJV',   'Jävenitz',                   8011946, 11.4930670, 52.5196640 ],
	[ 'RJL',   'Jöhlingen',                  8003127, 8.57522400, 49.0281800 ],
	[ 'RJLB',  'Jöhlingen',                  8003127, 8.57522400, 49.0281800 ],
	[ 'RJLW',  'Jöhlingen West',             8079058, 8.56997500, 49.0309390 ],
	[ 'DJZ',   'Jößnitz',                   8011966, 12.1398270, 50.5376180 ],
	[ 'AJ',    'Jübek',                      8000334, 9.40543800, 54.5587820 ],
	[ 'KJUC',  'Jüchen',                     8003130, 6.50092300, 51.0971130 ],
	[ 'KJ',    'Jülich',                     8000188, 6.36797700, 50.9193810 ],
	[ 'KJSU',  'Jülich Forschungszentrum',   8007815, 6.39224400, 50.8985940 ],
	[ 'KJB',   'Jülich-Broich',              8007801, 6.34210400, 50.9472370 ],
	[ 'KJND',  'Jülich-Nord',                8007802, 6.36658700, 50.9288990 ],
	[ 'KJSE',  'Jülich-Selgersdorf',         8007814, 6.40829000, 50.8902290 ],
	[ 'KJU',   'Jünkerath',                  8003135, 6.58093900, 50.3447690 ],
	[ 'BJUE',  'Jüterbog',                   8010182, 13.0543530, 51.9975090 ],
	[ 'KKAI',  'Kaarst IKEA',                 8000438, 6.62988100, 51.2170230 ],
	[ 'KKMI',  'Kaarst Mitte/Holzbüttgen',   8000432, 6.61724600, 51.2195040 ],
	[ 'KKAA',  'Kaarster Bahnhof',            8003141, 6.60727400, 51.2225510 ],
	[ 'KKSE',  'Kaarster See',                8000430, 6.59397700, 51.2266890 ],
	[ 'BKAB',  'Kablow',                      8011981, 13.7213510, 52.3000670 ],
	[ 'FKLPK', 'Kahl Kopp/Heide',             8070164, 9.01577000, 50.0791450 ],
	[ 'FKLM',  'Kahl(Main)',                  8003143, 9.00546800, 50.0768700 ],
	[ 'FKLP',  'Kahl(Main)',                  8003143, 9.00546800, 50.0768700 ],
	[ 'UKA',   'Kahla(Thür)',                8011985, 11.5891040, 50.8089260 ],
	[ 'MKAI',  'Kainzenbad',                  8003146, 11.1167230, 47.4829810 ],
	[ 'SKAI',  'Kaisersesch',                 8003148, 7.12957300, 50.2321020 ],
	[ 'SKL',   'Kaiserslautern Hbf',          8000189, 7.76871600, 49.4361370 ],
	[ 'SKLP',  'Kaiserslautern Pfaffwerk',    8003150, 7.75124800, 49.4347140 ],
	[ 'SKLW',  'Kaiserslautern West',         8003151, 7.74981200, 49.4475350 ],
	[ 'NKAL',  'Kalchreuth',                  8003154, 11.1399930, 49.5584420 ],
	[ 'KKAK',  'Kaldenkirchen',               8000190, 6.20322500, 51.3271840 ],
	[ 'KKAB',  'Kalenborn(Westerw)',          8070018, 7.31272100, 50.6155350 ],
	[ 'KKAL',  'Kall',                        8003158, 6.55728300, 50.5384930 ],
	[ 'WKAR',  'Kalsow',                      8011995, 11.5783500, 53.9256990 ],
	[ 'NKCK',  'Kalteneck',                   8070807, 13.4530110, 48.6893850 ],
	[ 'AKTKS', 'Kaltenkirchen Süd',          8007204, 9.97306500, 53.8235880 ],
	[ 'AKTK',  'Kaltenkirchen(Holst)',        8007054, 9.96682500, 53.8344170 ],
	[ 'EKAL',  'Kalthof(Kr Iserlohn)',        8003166, 7.67236400, 51.4250590 ],
	[ 'EKAM',  'Kamen',                       8003168, 7.66100000, 51.5852240 ],
	[ 'EKME',  'Kamen-Methler',               8003169, 7.61305600, 51.5673790 ],
	[ 'DKA',   'Kamenz(Sachs)',               8011988, 14.0921920, 51.2737810 ],
	[ 'FKMP',  'Kamp-Bornhofen',              8003170, 7.61825100, 50.2279880 ],
	[ 'RKD',   'Kandel',                      8003172, 8.19802500, 49.0791400 ],
	[ 'RKA',   'Kandern',                     8070450, 7.65690500, 47.7134910 ],
	[ 'SKAZ',  'Kanzem',                      8003173, 6.57366600, 49.6693590 ],
	[ 'RKPD',  'Kapellen-Drusweiler',         8003175, 8.03075400, 49.1056210 ],
	[ 'KKAW',  'Kapellen-Wevelinghoven',      8003174, 6.62106100, 51.1297950 ],
	[ 'LKPB',  'Kapen Biosphärenreservat',   8070260, 12.3366900, 51.8164830 ],
	[ 'RKPP',  'Kappelrodeck',                8007004, 8.11609400, 48.5934040 ],
	[ 'RKPO',  'Kappelrodeck Ost',            8077004, 8.12583400, 48.5869250 ],
	[ 'RKPW',  'Kapsweyer',                   8007859, 8.02217700, 49.0388780 ],
	[ 'WKAB',  'Karlsburg',                   8011991, 13.6098020, 53.9824470 ],
	[ 'RKF',   'Karlsdorf',                   8003181, 8.54787200, 49.1444840 ],
	[ 'WKH',   'Karlshagen',                  8011992, 13.8314300, 54.1167550 ],
	[ 'RKAB',  'Karlsruhe Albtalbf',          8079045, 8.39611000, 48.9937070 ],
	[ 'RKV',   'Karlsruhe Bahnhofsvorplatz',  8079041, 8.39958700, 48.9943460 ],
	[ 'RKDT',  'Karlsruhe Durlacher Tor',     8079125, 8.41788000, 49.0088150 ],
	[ 'RKEF',  'Karlsruhe Entenfang',         8079126, 8.35950400, 49.0106660 ],
	[ 'RK',    'Karlsruhe Hbf',               8000191, 8.40218100, 48.9935150 ],
	[
		'RKMAK', 'Karlsruhe Marktplatz (Kaiserstraße)',
		8079035, 8.40455500, 49.0095540
	],
	[ 'RKMT',  'Karlsruhe Mühlburger Tor', 8079144, 8.38672800, 49.0104570 ],
	[ 'RKW',   'Karlsruhe West',            8003183, 8.36295100, 49.0021590 ],
	[ 'RKWU',  'Karlsruhe West',            8003183, 8.36295100, 49.0021590 ],
	[ 'RKDU',  'Karlsruhe-Durlach',         8003184, 8.46282200, 49.0023280 ],
	[ 'RKDUA', 'Karlsruhe-Durlach',         8003184, 8.46282200, 49.0023280 ],
	[ 'RKHA',  'Karlsruhe-Hagsfeld',        8003185, 8.45364500, 49.0259380 ],
	[
		'RKSR',  'Karlsruhe-Kniel. Rheinbergstr.',
		8079128, 8.33661300,
		49.0350150
	],
	[ 'RKIN',  'Karlsruhe-Knielingen',        8003186, 8.34117100, 49.0266950 ],
	[ 'RKMG',  'Karlsruhe-Mühlburg',         8003187, 8.35112600, 49.0145570 ],
	[ 'RKNEK', 'Karlsruhe-Neureut Kirchfeld', 8079047, 8.38883500, 49.0529120 ],
	[ 'NKA',   'Karlstadt(Main)',             8003189, 9.76814800, 49.9628990 ],
	[ 'MKH',   'Karpfham',                    8003191, 13.1873940, 48.4079900 ],
	[ 'UKF B', 'Karsdorf',                    8011993, 11.6557660, 51.2806880 ],
	[ 'WKT',   'Karstädt',                   8011994, 11.7386180, 53.1606840 ],
	[ 'SKU',   'Karthaus',                    8000402, 6.59685400, 49.7103400 ],
	[ 'KKBA',  'Kasbach',                     8070019, 7.26003100, 50.5856440 ],
	[ 'KKBB',  'Kasbach Brauerei Steffens',   8070021, 7.25910500, 50.5919640 ],
	[ 'FK',    'Kassel Hbf',                  8000193, 9.48950100, 51.3182600 ],
	[ 'FKKVG', 'Kassel Hbf (tief)',           8098193, 9.48978700, 51.3181960 ],
	[ 'FKH',   'Kassel-Harleshausen',         8003196, 9.45225000, 51.3321780 ],
	[ 'FKJK',  'Kassel-Jungfernkopf',         8003197, 9.46286900, 51.3389180 ],
	[ 'FKKD',  'Kassel-Kirchditmold',         8003198, 9.45220400, 51.3245610 ],
	[ 'FKOZ',  'Kassel-Oberzwehren',          8003199, 9.45402800, 51.2763480 ],
	[ 'FKW',   'Kassel-Wilhelmshöhe',        8003200, 9.44689800, 51.3131140 ],
	[ 'MKAT',  'Kastl(Oberbay)',              8003205, 12.7128560, 48.1923270 ],
	[ 'AKAD',  'Katharinenheerd',             8003207, 8.83048900, 54.3341630 ],
	[ 'AKTO',  'Kating',                      8003208, 8.87228100, 54.3260300 ],
	[ 'HKAT',  'Katlenburg',                  8003209, 10.0997400, 51.6861580 ],
	[ 'SKTS',  'Kattenes',                    8003211, 7.43921100, 50.2543270 ],
	[ 'EKV',   'Kattenvenne',                 8003212, 7.86028100, 52.1132730 ],
	[ 'FKFT',  'Katzenfurt',                  8003213, 8.34318900, 50.6159470 ],
	[ 'UKH',   'Katzhütte',                  8011999, 11.0611100, 50.5610650 ],
	[ 'NKG',   'Katzwang',                    8003214, 11.0425430, 49.3553720 ],
	[ 'SKW',   'Katzweiler',                  8003215, 7.70093500, 49.5000820 ],
	[ 'FKAU',  'Kaub',                        8003216, 7.76819700, 50.0836350 ],
	[ 'MKFB',  'Kaufbeuren',                  8000194, 10.6294960, 47.8754320 ],
	[ 'MKFG',  'Kaufering',                   8000195, 10.8545950, 48.0808350 ],
	[ 'UKL',   'Kaulsdorf(Saale)',            8012000, 11.4336420, 50.6113410 ],
	[ 'WKV',   'Kavelstorf(Kr Rostock)',      8012002, 12.1978210, 54.0070810 ],
	[ 'RKL',   'Kehl',                        8003218, 7.80655600, 48.5766580 ],
	[ 'TKEH',  'Kehlen',                      8003220, 9.54818400, 47.6830310 ],
	[ 'AKI',   'Keitum',                      8003222, 8.36896900, 54.8888140 ],
	[ 'FKE',   'Kelkheim',                    8007161, 8.44766300, 50.1372840 ],
	[ 'FKHO',  'Kelkheim-Hornau',             8007162, 8.44454000, 50.1470200 ],
	[ 'FKEM',  'Kelkheim-Münster',           8007160, 8.46168700, 50.1248740 ],
	[ 'MKMZ',  'Kellmünz',                   8003227, 10.1246160, 48.1202860 ],
	[ 'FKCH',  'Kelsterbach',                 8003228, 8.52947900, 50.0624900 ],
	[ 'NKNN',  'Kemnath-Neustadt',            8003229, 11.8622620, 49.8439060 ],
	[ 'KKEM',  'Kempen(Niederrhein)',         8000409, 6.42554900, 51.3675640 ],
	[ 'MKP',   'Kempten(Allgäu)Hbf',         8000197, 10.3176100, 47.7117450 ],
	[ 'MKPO',  'Kempten(Allgäu)Ost',         8003230, 10.3320500, 47.7312930 ],
	[ 'DKAU',  'Kemtau',                      8012004, 12.9539210, 50.7429440 ],
	[ 'SKEN',  'Kennelgarten',                8003232, 7.73301300, 49.4409980 ],
	[ 'WKEN',  'Kenz',                        8012005, 12.7410130, 54.3298750 ],
	[ 'RKN',   'Kenzingen',                   8003233, 7.76409400, 48.1944510 ],
	[ 'FKB',   'Kerkerbach',                  8003235, 8.13588200, 50.4019620 ],
	[ 'BKE',   'Kerkwitz',                    8012006, 14.6275670, 51.9095780 ],
	[ 'NKCH',  'Kersbach',                    8003238, 11.0595440, 49.6849870 ],
	[ 'FKES',  'Kestert',                     8003241, 7.64897800, 50.1870650 ],
	[ 'EKG',   'Kettwig',                     8000198, 6.95374700, 51.3633750 ],
	[ 'EKGS',  'Kettwig Stausee',             8003245, 6.93914500, 51.3566080 ],
	[ 'KKEV',  'Kevelaer',                    8003247, 6.25222700, 51.5810080 ],
	[ 'TKBI',  'Kiebingen',                   8003248, 8.97374500, 48.4793690 ],
	[ 'UKIE',  'Kiebitzhöhe',                8012007, 11.2035550, 51.1810280 ],
	[ 'MKI',   'Kiefersfelden',               8003249, 12.1904730, 47.6099070 ],
	[ 'AK',    'Kiel Hbf',                    8000199, 10.1319760, 54.3149850 ],
	[ 'AKSL',  'Kiel Schulen am Langsee',     8003251, 10.1569650, 54.3072050 ],
	[ 'AKE',   'Kiel-Elmschenhagen',          8003477, 10.1804140, 54.2871420 ],
	[ 'AKH',   'Kiel-Hassee CITTI-PARK',      8003474, 10.0985960, 54.3105690 ],
	[ 'AKRU',  'Kiel-Russee',                 8003253, 10.0702120, 54.3100400 ],
	[ 'TKLR',  'Killer',                      8007224, 9.06082800, 48.3156840 ],
	[ 'MKIG',  'Kinding(Altmühltal)',        8003256, 11.3775010, 48.9926940 ],
	[ 'SKIB',  'Kindsbach',                   8003257, 7.61283600, 49.4193710 ],
	[ 'FKGS',  'Kirch Göns',                 8003262, 8.66686900, 50.4733730 ],
	[ 'WKJ',   'Kirch-Jesar',                 8012009, 11.2633210, 53.4485960 ],
	[ 'MKAG',  'Kirchanschöring',            8003263, 12.8315170, 47.9534150 ],
	[ 'TKIM',  'Kirchberg(Murr)',             8003266, 9.32905600, 48.9391610 ],
	[ 'HKDF',  'Kirchdorf(Deister)',          8003267, 9.49193600, 52.2898520 ],
	[ 'NKIR',  'Kirchehrenbach',              8003268, 11.1416410, 49.7354440 ],
	[ 'EKIR',  'Kirchen',                     8000427, 7.88050900, 50.8065760 ],
	[ 'NKL',   'Kirchenlaibach',              8000201, 11.7763250, 49.8699040 ],
	[ 'NKO',   'Kirchenlamitz Ost',           8003270, 11.9859650, 50.1654960 ],
	[ 'TKI',   'Kirchentellinsfurt',          8003272, 9.13948000, 48.5287490 ],
	[ 'FKIH',  'Kirchhain(Bz Kassel)',        8000435, 8.92139900, 50.8237790 ],
	[ 'HKHW',  'Kirchhammelwarden',           8003276, 8.47523300, 53.3056550 ],
	[ 'TKM',   'Kirchheim(Neckar)',           8003278, 9.15090300, 49.0376460 ],
	[ 'TKT',   'Kirchheim(Teck)',             8003280, 9.44392700, 48.6442580 ],
	[ 'TKTO',  'Kirchheim(Teck)-Ötlingen',   8003282, 9.41629100, 48.6577640 ],
	[ 'TKTS',  'Kirchheim(Teck)Süd',         8003283, 9.45178800, 48.6402610 ],
	[ 'TKU',   'Kirchheim(Unterfr)',          8003284, 9.85771300, 49.6567490 ],
	[ 'RKH',   'Kirchheim(Weinstr)',          8003285, 8.18145200, 49.5371630 ],
	[ 'FKIR',  'Kirchheimbolanden',           8000652, 8.01652600, 49.6685450 ],
	[ 'HKHN',  'Kirchhorsten',                8003286, 9.11978300, 52.3078750 ],
	[ 'EKHU',  'Kirchhundem',                 8003287, 8.07810300, 51.0860680 ],
	[ 'HKLG',  'Kirchlengern',                8003288, 8.64377800, 52.1967550 ],
	[ 'LKIM',  'Kirchmöser',                 8012011, 12.4222060, 52.3752350 ],
	[ 'UKI',   'Kirchscheidungen',            8012012, 11.6625700, 51.2447000 ],
	[ 'MKO',   'Kirchseeon',                  8003290, 11.8872550, 48.0709000 ],
	[ 'MKO H', 'Kirchseeon',                  8003290, 11.8872550, 48.0709000 ],
	[ 'MKW',   'Kirchweidach',                8084066, 12.6484750, 48.0929990 ],
	[ 'HKI',   'Kirchweyhe',                  8003292, 8.84723600, 52.9837650 ],
	[ 'RKZ',   'Kirchzarten',                 8003293, 7.95913200, 47.9679360 ],
	[ 'SKI',   'Kirkel',                      8003294, 7.22660100, 49.2862450 ],
	[ 'SKR',   'Kirn',                        8003295, 7.46458900, 49.7857690 ],
	[ 'RKBG',  'Kirnbach-Grün',              8007104, 8.10590700, 48.3619300 ],
	[ 'SKRS',  'Kirnsulzbach',                8003298, 7.43547700, 49.7623240 ],
	[ 'RKBV',  'Kirschbaumwasen',             8003289, 8.35568400, 48.6230550 ],
	[ 'MKIS',  'Kissing',                     8003299, 10.9595530, 48.3009220 ],
	[ 'NKN',   'Kitzingen',                   8000479, 10.1552140, 49.7324970 ],
	[ 'TKG',   'Kißlegg',                    8000203, 9.88192100, 47.7935330 ],
	[ 'DNK K', 'Klaffenbach Hp',              8017421, 12.9037510, 50.7722860 ],
	[ 'MKLA',  'Klais',                       8003302, 11.2385890, 47.4830320 ],
	[ 'BKLD',  'Klandorf',                    8012015, 13.5559570, 52.8779380 ],
	[ 'AKX',   'Klanxbüll',                  8003303, 8.67645400, 54.8619970 ],
	[ 'BKDF',  'Klasdorf Glashütte',         8012016, 13.5437110, 52.0213830 ],
	[ 'AKC',   'Klecken',                     8003309, 9.92892200, 53.3662070 ],
	[ 'WKB',   'Klein Bünzow',               8012021, 13.6224400, 53.9236570 ],
	[ 'FKGE',  'Klein Gerau',                 8003313, 8.51674000, 49.9198490 ],
	[ 'FKWO',  'Klein Winternheim-Ober Olm',  8003316, 8.20709700, 49.9396190 ],
	[ 'MKHN',  'Kleinberghofen',              8003317, 11.2754780, 48.3540450 ],
	[ 'KKLE',  'Kleinenbroich',               8003321, 6.55197200, 51.1956620 ],
	[ 'HKSI',  'Kleinensiel',                 8003323, 8.47600600, 53.4447360 ],
	[ 'DKFR',  'Kleinforst Rosensee',         8017344, 13.1049990, 51.2899210 ],
	[ 'UKFA',  'Kleinfurra',                  8012033, 10.7631960, 51.4174070 ],
	[ 'NKGM',  'Kleingemünden',              8003329, 9.68770400, 50.0629910 ],
	[ 'NKLH',  'Kleinheubach',                8003324, 9.20747600, 49.7214230 ],
	[ 'UKJ',   'Kleinjena',                   8012034, 11.7812790, 51.1802650 ],
	[ 'RKES',  'Kleinkems',                   8003325, 7.52466200, 47.6861290 ],
	[ 'MKKZ',  'Kleinkötz',                  8003326, 10.2884970, 48.4116590 ],
	[ 'FKO',   'Kleinostheim',                8003314, 9.07225200, 50.0026450 ],
	[ 'DKRD',  'Kleinröhrsdorf',             8012036, 13.9900520, 51.1341750 ],
	[ 'DKMA',  'Kleinschirma',                8012037, 13.2818170, 50.9025810 ],
	[ 'RKBA',  'Kleinsteinbach',              8003331, 8.55490000, 48.9667450 ],
	[ 'NKT',   'Kleinwallstadt',              8003334, 9.16816800, 49.8749100 ],
	[ 'KKLV',  'Kleve',                       8000205, 6.14622400, 51.7897340 ],
	[ 'LKK',   'Klieken',                     8012040, 12.3717780, 51.8945300 ],
	[ 'BKG',   'Klinge',                      8012043, 14.5182710, 51.7436080 ],
	[ 'NKM',   'Klingenberg(Main)',           8003337, 9.17654900, 49.7814190 ],
	[ 'DKC',   'Klingenberg-Colmnitz',        8012044, 13.5010140, 50.9259700 ],
	[ 'NKNB',  'Klingenbrunn',                8003338, 13.3361800, 48.9446980 ],
	[ 'DKN',   'Klingenthal',                 8012045, 12.4626770, 50.3571630 ],
	[
		'HBKM',  'Klinikum Bremen-Nord/Beckedorf',
		8007893, 8.59520600,
		53.1852540
	],
	[ 'LKLM',  'Klitschmar',               8012046, 12.2288950, 51.5083060 ],
	[ 'TBR',   'Kloster Bronnbach',        8001193, 9.54351600, 49.7151440 ],
	[ 'KKLM',  'Kloster Marienthal',       8003340, 7.66852800, 50.7386470 ],
	[ 'HKOE',  'Kloster Oesede',           8004627, 8.11162600, 52.2005910 ],
	[ 'DKLB',  'Klosterbuch',              8012053, 13.0040600, 51.1576220 ],
	[ 'BKLF',  'Klosterfelde',             8012054, 13.4881310, 52.7913760 ],
	[ 'MKLF',  'Klosterlechfeld',          8003342, 10.8326300, 48.1553930 ],
	[ 'LKM',   'Klostermansfeld',          8010191, 11.4919040, 51.5746820 ],
	[ 'RKLB',  'Klosterreichenbach',       8003343, 8.39900800, 48.5266270 ],
	[ 'SKT',   'Klotten',                  8003344, 7.20326200, 50.1653280 ],
	[ 'LKD H', 'Kläden(Stendal)',         8012014, 11.6548360, 52.6378140 ],
	[ 'LKNF',  'Knautnaundorf',            8012059, 12.2729450, 51.2471320 ],
	[ 'HKNE',  'Knesebeck',                8003348, 10.6902670, 52.6778120 ],
	[ 'TKNK',  'Knittlingen-Kleinvillars', 8003332, 8.74453600, 48.9934440 ],
	[ 'RKG',   'Knöringen-Essingen',      8003349, 8.14826500, 49.2381700 ],
	[ 'SKG',   'Kobern-Gondorf',           8003350, 7.46075000, 50.3007180 ],
	[ 'KKO',   'Koblenz Hbf',              8000206, 7.58834500, 50.3509290 ],
	[ 'KKSM',  'Koblenz Stadtmitte',       8003341, 7.58998500, 50.3577140 ],
	[ 'KKOE',  'Koblenz-Ehrenbreitstein',  8003351, 7.61020200, 50.3617460 ],
	[ 'SGS',   'Koblenz-Güls',            8002454, 7.54917100, 50.3403050 ],
	[ 'KKOL',  'Koblenz-Lützel',          8003352, 7.59160700, 50.3674870 ],
	[ 'SKOW',  'Koblenz-Moselweiß',       8003354, 7.56064600, 50.3494630 ],
	[ 'MKCH',  'Kochel',                   8003355, 11.3709870, 47.6606500 ],
	[ 'BKOD',  'Kodersdorf',               8012061, 14.9162320, 51.2595540 ],
	[ 'KKOS',  'Kohlscheid',               8003395, 6.07448500, 50.8317280 ],
	[ 'TKOS',  'Kohlstetten',              8070458, 9.33243800, 48.4007630 ],
	[ 'MKMR',  'Kolbermoor',               8003397, 12.0641470, 47.8519260 ],
	[ 'BKOW',  'Kolkwitz',                 8012083, 14.2501690, 51.7577300 ],
	[ 'BKOS',  'Kolkwitz Süd',            8012084, 14.2421790, 51.7469130 ],
	[ 'RKLR',  'Kollmarsreute',            8003398, 7.88707400, 48.0982710 ],
	[ 'RKNA',  'Kollnau',                  8003399, 7.97384200, 48.1011510 ],
	[ 'RKO',   'Konstanz',                 8003400, 9.17731200, 47.6587540 ],
	[ 'RKOF',  'Konstanz-Fürstenberg',    8003404, 9.16284700, 47.6774790 ],
	[ 'RKOP',  'Konstanz-Petershausen',    8003401, 9.17346800, 47.6740920 ],
	[ 'RKOW',  'Konstanz-Wollmatingen',    8003416, 9.14733100, 47.6824530 ],
	[ 'SKZ',   'Konz',                     8003402, 6.57329400, 49.6953880 ],
	[ 'SKZM',  'Konz Mitte',               8003403, 6.57375700, 49.7002400 ],
	[ 'SKU W', 'Konz Mitte',               8003403, 6.57375700, 49.7002400 ],
	[ 'FKOB',  'Korbach',                  8000210, 8.87322900, 51.2787120 ],
	[ 'FKBS',  'Korbach Süd',             8003406, 8.87881500, 51.2702640 ],
	[ 'SKDL',  'Kordel',                   8003407, 6.63493300, 49.8363670 ],
	[ 'RKOR',  'Kork',                     8003408, 7.87479700, 48.5700190 ],
	[ 'TKO',   'Korntal',                  8003409, 9.12116800, 48.8264160 ],
	[ 'TKO G', 'Korntal Gymnasium',        8007855, 9.11235300, 48.8310570 ],
	[ 'TKH',   'Kornwestheim Pbf',         8003411, 9.17996400, 48.8622190 ],
	[ 'KKOI',  'Korschenbroich',           8003412, 6.51188600, 51.1956500 ],
	[ 'WKO',   'Koserow',                  8012086, 13.9992750, 54.0453350 ],
	[ 'NKMG',  'Kothmaißling',            8003413, 12.7293670, 49.2429120 ],
	[ 'KKOH',  'Kottenheim',               8003415, 7.24890600, 50.3489740 ],
	[ 'UKR',   'Kraftsdorf',               8012088, 11.9308550, 50.8780750 ],
	[ 'BFIK',  'Kraftwerk Finkenheerd',    8012089, 14.5756540, 52.2632280 ],
	[ 'EKRG',  'Kraghammer',               8003420, 7.87376200, 51.1091340 ],
	[ 'UKD',   'Kranichfeld',              8012092, 11.2032250, 50.8563350 ],
	[ 'WKG',   'Kratzeburg',               8012093, 12.9416270, 53.4278030 ],
	[ 'KNKR',  'Krauthausen',              8007816, 6.42327000, 50.8786620 ],
	[ 'EKRD',  'Kredenbach',               8003424, 8.04277600, 50.9632570 ],
	[ 'KKR',   'Krefeld Hbf',              8000211, 6.56988500, 51.3257170 ],
	[ 'KHB', 'Krefeld-Hohenbudberg Chempark', 8002941, 6.66446000, 51.3735290 ],
	[ 'KKRL',  'Krefeld-Linn',          8003426, 6.62966800, 51.3373050 ],
	[ 'KKRLF', 'Krefeld-Linn',          8003426, 6.62966800, 51.3373050 ],
	[ 'KKRO',  'Krefeld-Oppum',         8000212, 6.61009000, 51.3297490 ],
	[ 'KKRX',  'Krefeld-Uerdingen',     8003427, 6.64577800, 51.3572780 ],
	[ 'HK',    'Kreiensen',             8000213, 9.96779800, 51.8514230 ],
	[ 'SKRB',  'Kreimbach-Kaulbach',    8003429, 7.63129600, 49.5514900 ],
	[ 'BKRM',  'Kremmen',               8012096, 13.0402310, 52.7533470 ],
	[ 'AKM',   'Krempe',                8003430, 9.48175700, 53.8341110 ],
	[ 'AKHD',  'Kremperheide',          8003431, 9.48037700, 53.8811780 ],
	[ 'LKNZ',  'Krensitz',              8012097, 12.4619700, 51.4904490 ],
	[ 'TKN',   'Kressbronn',            8003432, 9.59885400, 47.5942390 ],
	[ 'DKRO',  'Kretscham-Rothensehma', 8012098, 12.9882450, 50.4672100 ],
	[ 'SKK',   'Kreuz Konz',            8003434, 6.57686600, 49.7037980 ],
	[ 'KKUZ',  'Kreuzau Bahnhof',       8007820, 6.48840900, 50.7507500 ],
	[ 'KKUZE', 'Kreuzau-Eifelstraße',  8007830, 6.49194000, 50.7427980 ],
	[ 'KKRZ',  'Kreuzberg(Ahr)',        8003436, 6.97855700, 50.5064420 ],
	[ 'MKZ',   'Kreuzstraße',          8003438, 11.7590140, 47.9164940 ],
	[ 'EKT',   'Kreuztal',              8000214, 7.99169600, 50.9560290 ],
	[ 'ELTF',  'Kreuztal-Littfeld',     8003716, 7.98714200, 51.0071900 ],
	[ 'FKRI',  'Kriftel',               8003442, 8.47544800, 50.0822800 ],
	[ 'DKRP',  'Krippen',               8012105, 14.1604250, 50.9130820 ],
	[ 'NK',    'Kronach',               8003446, 11.3201150, 50.2396120 ],
	[ 'FKRS',  'Kronberg Süd',         8087063, 8.52918300, 50.1733040 ],
	[ 'FKRO',  'Kronberg(Taunus)',      8003447, 8.51687400, 50.1799190 ],
	[ 'AKRH',  'Kronshagen',            8003479, 10.0831550, 54.3312110 ],
	[ 'WKRP',  'Kronskamp',             8012109, 12.3153870, 53.9335560 ],
	[ 'SKRO',  'Kronweiler',            8003452, 7.26241600, 49.6555880 ],
	[ 'KKRF',  'Kruft',                 8003455, 7.33859800, 50.3905410 ],
	[ 'MKRS',  'Krumbach(Schw)Schule',  8001179, 10.3611650, 48.2354200 ],
	[ 'MKRB',  'Krumbach(Schwab)',      8003457, 10.3586190, 48.2475900 ],
	[ 'DKRU',  'Krumhermsdorf',         8012113, 14.2073480, 50.9929630 ],
	[ 'LKRP',  'Krumpa',                8012114, 11.8546360, 51.2894370 ],
	[ 'AKRS',  'Krupunder',             8003460, 9.86776200, 53.6158230 ],
	[ 'UKPR',  'Krölpa-Ranis',         8012107, 11.5433200, 50.6771180 ],
	[ 'WKR',   'Kröpelin',             8012108, 11.7915730, 54.0691370 ],
	[ 'DKU',   'Kubschütz',            8012115, 14.5096340, 51.1657260 ],
	[ 'TKUC',  'Kuchen',                8003461, 9.80340000, 48.6405230 ],
	[ 'NKU',   'Kulmbach',              8003476, 11.4518890, 50.1098220 ],
	[ 'WKUM',  'Kummerow(Stralsund)',   8012127, 12.8846160, 54.2983310 ],
	[ 'BKUM',  'Kummersdorf(Storkow)',  8012129, 13.8741260, 52.2750640 ],
	[ 'BPA',   'Kunersdorf',            8012605, 14.1883640, 51.7686400 ],
	[ 'AKUP',  'Kupfermühle',          8003478, 10.3267950, 53.7624460 ],
	[ 'RKU',   'Kuppenheim',            8003480, 8.25611200, 48.8341280 ],
	[ 'DAG',  'Kurort Altenberg(Erzgebirge)', 8011019, 13.7536340, 50.7662980 ],
	[ 'DKJ',  'Kurort Jonsdorf',              8012131, 14.7066100, 50.8538550 ],
	[ 'DKJH', 'Kurort Jonsdorf Hst',          8012132, 14.7256680, 50.8621510 ],
	[ 'DKOW', 'Kurort Oberwiesenthal',        8012134, 12.9719810, 50.4211780 ],
	[ 'DKOY', 'Kurort Oybin',                 8012135, 14.7455770, 50.8436620 ],
	[ 'DKON', 'Kurort Oybin-Niederdorf',      8012136, 14.7536240, 50.8621660 ],
	[ 'DRAT', 'Kurort Rathen',                8012138, 14.0753410, 50.9568160 ],
	[ 'SKUS', 'Kusel',                        8003481, 7.41032900, 49.5382820 ],
	[ 'AKTH', 'Kutenholz',                    8007844, 9.30996100, 53.4703790 ],
	[ 'MKUN', 'Kutzenhausen',                 8003483, 10.6963380, 48.3347750 ],
	[ 'LKYA', 'Kyhna',                        8012141, 12.2659280, 51.5110180 ],
	[ 'SKY',  'Kyllburg',                     8003484, 6.59702700, 50.0419300 ],
	[ 'WKY',  'Kyritz',                       8012142, 12.3909450, 52.9424910 ],
	[ 'FKAE', 'Kälberau',                    8007276, 9.09144500, 50.0909110 ],
	[ 'LKF',  'Kämmereiforst',               8011983, 12.5407930, 51.4763000 ],
	[ 'NKI',  'Köditz',                      8003356, 11.8481090, 50.3288880 ],
	[ 'NKOE', 'Köfering',                    8003357, 12.2087500, 48.9317160 ],
	[ 'UKOE', 'Kölleda',                     8012064, 11.2449060, 51.1802740 ],
	[ 'KBP',  'Köln Airport-Businesspark',   8003370, 7.04445100, 50.9102820 ],
	[ 'KKFS', 'Köln Frankfurter Straße',    8003358, 7.05126200, 50.9152190 ],
	[ 'KKP', 'Köln Geldernstr./Parkgürtel', 8003360, 6.94141300, 50.9685510 ],
	[ 'KKHR',  'Köln Hansaring',            8003392, 6.95256500, 50.9491310 ],
	[ 'KK',    'Köln Hbf',                  8000207, 6.95872900, 50.9430300 ],
	[ 'KKDZ',  'Köln Messe/Deutz',          8003368, 6.97500100, 50.9408740 ],
	[ 'KKDZB', 'Köln Messe/Deutz Gl. 9-10', 8083368, 6.97464100, 50.9412990 ],
	[ 'KKDT',  'Köln Messe/Deutz Gl.11-12', 8073368, 6.97406700, 50.9417210 ],
	[ 'KSTP',  'Köln Steinstraße',         8003379, 7.05717300, 50.8955580 ],
	[ 'KKS',   'Köln Süd',                 8003361, 6.93805900, 50.9273000 ],
	[ 'KKTR',  'Köln Trimbornstr',          8003320, 6.99673400, 50.9358570 ],
	[ 'KKV',   'Köln Volkhovener Weg',      8003362, 6.89324100, 51.0142510 ],
	[ 'KKW',   'Köln West',                 8003363, 6.93438900, 50.9436650 ],
	[ 'KKBL',  'Köln-Blumenberg',           8079140, 6.88192100, 51.0374140 ],
	[ 'KKBH',  'Köln-Buchforst',            8003364, 7.00432700, 50.9534870 ],
	[ 'KKC',   'Köln-Chorweiler',           8003365, 6.89782400, 51.0211260 ],
	[ 'KKCN',  'Köln-Chorweiler Nord',      8003366, 6.89277200, 51.0281260 ],
	[ 'KKDB',  'Köln-Dellbrück',           8003367, 7.07012400, 50.9814370 ],
	[ 'KKER',  'Köln-Ehrenfeld',            8000208, 6.91727600, 50.9515330 ],
	[ 'KKERP', 'Köln-Ehrenfeld',            8000208, 6.91727600, 50.9515330 ],
	[ 'KKH',   'Köln-Holweide',             8003369, 7.04123500, 50.9762700 ],
	[ 'KKL',   'Köln-Longerich',            8003371, 6.90155700, 50.9977360 ],
	[ 'KKM',   'Köln-Mülheim',             8000209, 7.01329500, 50.9579860 ],
	[
		'KKMT', 'Köln-Müngersdorf Technologiepark',
		8003375, 6.88820100, 50.9483940
	],
	[ 'KKN',   'Köln-Nippes',             8003372, 6.94160500, 50.9586660 ],
	[ 'KKN P', 'Köln-Nippes',             8003372, 6.94160500, 50.9586660 ],
	[ 'KKSH',  'Köln-Stammheim',          8003310, 7.00209500, 50.9900700 ],
	[ 'KKWW',  'Köln-Weiden West',        8003383, 6.81513700, 50.9409000 ],
	[ 'KKWO',  'Köln-Worringen',          8003373, 6.85171900, 51.0523780 ],
	[ 'KFKB',  'Köln/Bonn Flughafen',     8003330, 7.11930200, 50.8789010 ],
	[ 'WKP',   'Kölpinsee',               8012065, 14.0229050, 54.0352900 ],
	[ 'RKOE',  'Köndringen',              8003374, 7.80292500, 48.1374580 ],
	[ 'BKW',   'Königs Wusterhausen',     8010193, 13.6314720, 52.2966350 ],
	[ 'TKB',   'Königsbach(Baden)',       8003376, 8.60893100, 48.9625840 ],
	[ 'LKB',   'Königsborn',              8012066, 11.7562680, 52.1340110 ],
	[ 'TKS',   'Königsbronn',             8003378, 10.1161350, 48.7395180 ],
	[ 'DKB',   'Königsbrück',            8012067, 13.9002310, 51.2602040 ],
	[ 'RKHS',  'Königschaffhausen',       8007286, 7.65806900, 48.1371900 ],
	[ 'TKF',   'Königshofen(Baden)',      8003381, 9.72466900, 49.5460220 ],
	[ 'FKHN',  'Königshofen(Kahl)',       8007281, 9.20598600, 50.0588470 ],
	[ 'HKOL',  'Königslutter',            8003382, 10.8124890, 52.2571660 ],
	[ 'EKSO',  'Königsstollen',           8003385, 7.93398900, 50.7765270 ],
	[ 'DKOH',  'Königstein(Sächs Schw)', 8012072, 14.0788990, 50.9194450 ],
	[ 'FKOE',  'Königstein(Taunus)',      8007164, 8.46869300, 50.1779170 ],
	[ 'KKOW',  'Königswinter',            8003386, 7.19359200, 50.6786380 ],
	[ 'KKOWF', 'Königswinter Fähre',     8070029, 7.19257200, 50.6727650 ],
	[
		'KKOWA', 'Königswinter, Clem.-August-Str.',
		8070074, 7.18924200, 50.6768880
	],
	[ 'UKZ',  'Könitz(Thür)',            8012075, 11.4871680, 50.6601590 ],
	[ 'LKO',  'Könnern',                  8010194, 11.7799050, 51.6740690 ],
	[ 'FKP',  'Köppern',                  8007849, 8.64692100, 50.2696150 ],
	[ 'FKRL', 'Körle',                    8003388, 9.51313700, 51.1715880 ],
	[ 'LK',   'Köthen',                   8010195, 11.9893580, 51.7519290 ],
	[ 'DKTW', 'Köttewitz',                8012079, 13.8597040, 50.9451430 ],
	[ 'LKTU', 'Kötzschau',                8012080, 12.1239040, 51.3044630 ],
	[ 'SKV',  'Kövenig',                  8003394, 7.11954300, 49.9811860 ],
	[ 'UKU',  'Kühnhausen',               8010198, 10.9780690, 51.0363710 ],
	[ 'LKUH', 'Kühren',                   8012117, 12.8331960, 51.3493410 ],
	[ 'FKWB', 'Külte-Wetterburg',         8003467, 9.07113800, 51.3968210 ],
	[ 'EKUE', 'Künsebeck',                8003469, 8.38422700, 52.0369360 ],
	[ 'EKNT', 'Küntrop',                  8003470, 7.81479600, 51.2933990 ],
	[ 'NKUE', 'Küps',                     8003472, 11.2683370, 50.1958860 ],
	[ 'DKUR', 'Kürbitz',                  8010040, 12.0697710, 50.4627240 ],
	[ 'BKI',  'Küstrin-Kietz',            8010189, 14.6079090, 52.5684810 ],
	[ 'NLB',  'Laaber',                    8003485, 11.8840560, 49.0700220 ],
	[ 'WLA',  'Laage(Meckl)',              8012143, 12.3396080, 53.9195990 ],
	[ 'MLBW', 'Laberweinting',             8003488, 12.3152370, 48.7968390 ],
	[ 'RLD',  'Ladenburg',                 8003489, 8.60280300, 49.4742420 ],
	[ 'ELAG', 'Lage(Lippe)',               8000215, 8.80119900, 51.9917420 ],
	[ 'MLLF', 'Lagerlechfeld',             8003490, 10.8443700, 48.1833730 ],
	[ 'RLSW', 'Lahr(Schwarzw)',            8003494, 7.83473400, 48.3404360 ],
	[ 'NLCK', 'Laineck',                   8003495, 11.6159070, 49.9593510 ],
	[ 'WLD',  'Lalendorf',                 8010199, 12.3864210, 53.7550040 ],
	[ 'NLAM', 'Lam',                       8007345, 13.0510030, 49.1915550 ],
	[ 'RLBP', 'Lambrecht(Pfalz)',          8003497, 8.07439100, 49.3733360 ],
	[ 'RLSH', 'Lambsheim',                 8003498, 8.28347600, 49.5118630 ],
	[ 'FLP',  'Lampertheim',               8003503, 8.47848900, 49.5982150 ],
	[ 'SLAO', 'Lampertsmühle-Otterbach',  8003504, 7.72940800, 49.4836620 ],
	[ 'BLW',  'Lampertswalde',             8012145, 13.6803790, 51.3084730 ],
	[ 'WLAK', 'Lancken',                   8012146, 13.6078850, 54.5180320 ],
	[ 'MLDI', 'Landau(Isar)',              8003506, 12.6950620, 48.6828900 ],
	[ 'RLA',  'Landau(Pfalz)Hbf',          8000216, 8.12620400, 49.1977410 ],
	[ 'RLAD', 'Landau(Pfalz)Süd',         8003507, 8.11383600, 49.1895140 ],
	[ 'RLW',  'Landau(Pfalz)West',         8003508, 8.10705200, 49.1957480 ],
	[ 'MLLS', 'Landsberg(L)Schule',        8005389, 10.8696410, 48.0541790 ],
	[ 'MLL',  'Landsberg(Lech)',           8003512, 10.8717010, 48.0472740 ],
	[ 'LLBG', 'Landsberg(b. Halle/Saale)', 8012147, 12.1667120, 51.5328990 ],
	[
		'LLAS',  'Landsberg(b. Halle/Saale) Süd',
		8012148, 12.1723150,
		51.5043960
	],
	[ 'MLA',   'Landshut(Bay)Hbf',            8000217, 12.1359300, 48.5474920 ],
	[ 'MLAS',  'Landshut(Bay)Süd',           8003514, 12.1407280, 48.5239380 ],
	[ 'SLD',   'Landstuhl',                   8003515, 7.56593100, 49.4162870 ],
	[ 'SLWR',  'Landsweiler-Reden',           8003516, 7.11931600, 49.3522460 ],
	[ 'FLGS',  'Lang Göns',                  8003520, 8.66709100, 50.4979390 ],
	[ 'NLG',   'Langdorf',                    8003521, 13.1613920, 49.0206620 ],
	[ 'DLAB',  'Langebrück(Sachs)',          8012150, 13.8410720, 51.1267510 ],
	[ 'ALAL',  'Langeln(Holst)',              8007137, 9.86210500, 53.7918330 ],
	[ 'HLNG',  'Langelsheim',                 8003522, 10.3431730, 51.9301200 ],
	[ 'FLG',   'Langen(Hess)',                8003523, 8.65678700, 49.9936120 ],
	[ 'FLGF',  'Langen-Flugsicherung',        8003526, 8.65867100, 50.0052300 ],
	[ 'TLR',   'Langenargen',                 8003524, 9.54483700, 47.5994910 ],
	[ 'TLL',   'Langenau(Württ)',            8003525, 10.1259880, 48.4933330 ],
	[ 'MLB',   'Langenbach(Oberbay)',         8003528, 11.8528540, 48.4380970 ],
	[ 'RLBD',  'Langenbrand',                 8003532, 8.35547300, 48.7022720 ],
	[ 'ULF',   'Langendorf',                  8012155, 11.9593220, 51.1814510 ],
	[ 'LLGS',  'Langeneichstädt',            8012156, 11.7558050, 51.3472860 ],
	[ 'KLA',   'Langenfeld(Rhld)',            8003540, 6.93827800, 51.1026770 ],
	[ 'KLAB',  'Langenfeld(Rhld)-Berghausen', 8003539, 6.92368400, 51.1175100 ],
	[ 'HLGM',  'Langenhagen Mitte',           8003545, 9.72542700, 52.4402790 ],
	[ 'HLGH',  'Langenhagen Pferdemarkt',     8003542, 9.73588200, 52.4509930 ],
	[ 'HKAW',  'Langenhagen-Kaltenweide',     8003165, 9.73634200, 52.4800850 ],
	[ 'FLAH',  'Langenhahn',                  8003543, 7.91463300, 50.5875350 ],
	[ 'ALG',   'Langenhorn(Schlesw)',         8003544, 8.94641300, 54.6859340 ],
	[ 'SLN',   'Langenlonsheim',              8000585, 7.89988700, 49.9013720 ],
	[ 'ALGM',  'Langenmoor',                  8007065, 9.66374600, 53.7724410 ],
	[ 'ULAO',  'Langenorla Ost',              8012159, 11.5927040, 50.7304090 ],
	[ 'ULAW',  'Langenorla West',             8012160, 11.5796630, 50.7418770 ],
	[ 'NLP',   'Langenprozelten',             8003548, 9.66138400, 50.0615720 ],
	[ 'FSLB',  'Langenselbold',               8003550, 9.05768200, 50.1620680 ],
	[ 'LLAG',  'Langenstein',                 8012161, 10.9792750, 51.8604570 ],
	[ 'RLSB',  'Langensteinbach Bahnhof',     8007013, 8.50312000, 48.9152560 ],
	[ 'MLNW',  'Langenwang(Schwab)',          8003551, 10.2760320, 47.4365880 ],
	[ 'LLWD',  'Langenweddingen',             8012162, 11.5324040, 52.0455540 ],
	[ 'DLW',   'Langenwolmsdorf',             8012163, 14.1536690, 51.0362510 ],
	[ 'DLWM',  'Langenwolmsdorf Mitte',       8012164, 14.1273310, 51.0386050 ],
	[ 'NLZ',   'Langenzenn',                  8003552, 10.8018560, 49.4969430 ],
	[ 'KLAW',  'Langerwehe',                  8003553, 6.35346700, 50.8179090 ],
	[ 'WLG',   'Langhagen',                   8010201, 12.4252170, 53.6809360 ],
	[ 'NLGU',  'Langlau',                     8003554, 10.8593520, 49.1187430 ],
	[ 'MLQU',  'Langquaid(b Eggmühl)',       8070812, 12.0534770, 48.8210580 ],
	[ 'FLF',   'Langsdorf(Oberhess)',         8003558, 8.85699000, 50.4949540 ],
	[ 'HLGW',  'Langwedel',                   8000586, 9.19498100, 52.9778810 ],
	[ 'MLAW',  'Langweid(Lech)',              8003560, 10.8479660, 48.4904470 ],
	[ 'HLAT',  'Lathen',                      8003563, 7.32257400, 52.8607490 ],
	[ 'NLDF',  'Laubendorf',                  8003567, 10.7526960, 49.4943650 ],
	[ 'SLAU',  'Laubenheim(Nahe)',            8003568, 7.89721500, 49.9187990 ],
	[ 'ULCH',  'Laucha(Unstrut)',             8012167, 11.6784420, 51.2220580 ],
	[ 'BLH',   'Lauchhammer',                 8012169, 13.7432420, 51.4745690 ],
	[ 'TLH',   'Lauchheim',                   8003569, 10.2365630, 48.8688850 ],
	[ 'RLAU',  'Lauchringen',                 8004552, 8.32219300, 47.6290880 ],
	[ 'RLAC',  'Lauchringen West',            8003562, 8.30810200, 47.6327750 ],
	[ 'TL',    'Lauda',                       8000221, 9.70951200, 49.5653850 ],
	[ 'NLK',   'Laudenbach am Main',          8003573, 9.17912600, 49.7425280 ],
	[ 'RLCH',  'Laudenbach(Bergstr)',         8003571, 8.64453900, 49.6120760 ],
	[ 'TLC',   'Laudenbach(Württ)',          8003572, 9.92310000, 49.4554210 ],
	[ 'ALUB',  'Lauenbrück',                 8003576, 9.56371000, 53.1970300 ],
	[ 'ALAU',  'Lauenburg(Elbe)',             8003577, 10.5675860, 53.3695550 ],
	[ 'HLFO',  'Lauenförde-Beverungen',      8003578, 9.39266700, 51.6584700 ],
	[ 'DLST',  'Lauenstein(Sachs)',           8012170, 13.8143980, 50.7865650 ],
	[ 'NLLW',  'Lauf West',                   8003587, 11.2776290, 49.5006590 ],
	[ 'NLL',   'Lauf(links Pegnitz)',         8003580, 11.2859760, 49.5070970 ],
	[ 'NLR',   'Lauf(rechts Pegnitz)',        8003581, 11.2778320, 49.5125520 ],
	[ 'NLA',   'Laufach',                     8003582, 9.27769200, 50.0106700 ],
	[ 'MLF',   'Laufen(Oberbay)',             8003584, 12.9223630, 47.9336530 ],
	[ 'RLFG',  'Laufenburg(Baden)',           8003585, 8.05831200, 47.5634080 ],
	[ 'RLBO',  'Laufenburg(Baden)Ost',        8003586, 8.07369100, 47.5661630 ],
	[ 'TLN',   'Lauffen(Neckar)',             8003588, 9.14613600, 49.0765140 ],
	[ 'MLIG',  'Lauingen',                    8003589, 10.4249660, 48.5745660 ],
	[ 'TLM',   'Laupheim Stadt',              8003591, 9.87839400, 48.2333040 ],
	[ 'TLW',   'Laupheim West',               8003592, 9.84785400, 48.2300080 ],
	[ 'FLBG',  'Laurenburg(Lahn)',            8003593, 7.90576600, 50.3295520 ],
	[ 'ULA',   'Lauscha(Thür)',              8012171, 11.1603020, 50.4733140 ],
	[ 'BLA',   'Lauta(Nl)',                   8012175, 14.0931470, 51.4472330 ],
	[ 'RLBA',  'Lautenbach(Baden)',           8003594, 8.11606700, 48.5194830 ],
	[ 'DLR',   'Lauter(Sachs)',               8012176, 12.7490280, 50.5680510 ],
	[ 'WLAM',  'Lauterbach Mole',             8012177, 13.5031180, 54.3422190 ],
	[ 'FLAU',  'Lauterbach(Hess)Nord',        8000222, 9.40805500, 50.6436060 ],
	[ 'WLAU',  'Lauterbach(Rügen)',          8017345, 13.5007540, 54.3452150 ],
	[ 'LLSB',  'Lauterbach-Steinbach',        8012178, 12.6193870, 51.1750360 ],
	[ 'SLKG',  'Lauterecken-Grumbach',        8000547, 7.59071000, 49.6537090 ],
	[ 'LLSG',  'Laußig(Düben)',             8012173, 12.6396130, 51.5407420 ],
	[ 'DLZ',   'Laußnitz',                   8012174, 13.8796530, 51.2482500 ],
	[ 'SLCH',  'Lebach',                      8000563, 6.90723100, 49.4083320 ],
	[ 'SLCJ',  'Lebach-Jabach',               8007868, 6.89156100, 49.4071690 ],
	[ 'HLEE',  'Leer(Ostfriesl)',             8000225, 7.46528300, 53.2316500 ],
	[ 'HLST',  'Leese-Stolzenau',             8000335, 9.11012700, 52.5094690 ],
	[ 'ELGD',  'Legden',                      8003608, 7.08850500, 52.0349330 ],
	[ 'ULE',   'Legefeld',                    8012180, 11.2882620, 50.9269080 ],
	[ 'RLT',   'Legelshurst',                 8003609, 7.91354900, 48.5585500 ],
	[ 'SLE',   'Lehmen',                      8003611, 7.45523000, 50.2847460 ],
	[ 'DLH',   'Lehndorf(Altenburg)',         8010202, 12.4258060, 50.9378270 ],
	[ 'FLEH',  'Lehnheim',                    8003612, 8.99209400, 50.6067690 ],
	[ 'BLEN',  'Lehnitz',                     8081722, 13.2632240, 52.7417020 ],
	[ 'HLER',  'Lehrte',                      8000226, 9.97459900, 52.3767220 ],
	[ 'KLEL',  'Leichlingen',                 8003616, 7.00525100, 51.1075210 ],
	[ 'HLFG',  'Leiferde(b Gifhorn)',         8003617, 10.4279370, 52.4564530 ],
	[ 'ELEI',  'Leimstruth',                  8003621, 8.31278900, 50.9906580 ],
	[ 'UL',    'Leinefelde',                  8010203, 10.3292960, 51.3887520 ],
	[ 'TLF',   'Leinfelden',                  8003622, 9.14286600, 48.6965060 ],
	[ 'TLG',   'Leingarten',                  8003623, 9.12196700, 49.1450320 ],
	[ 'TLGM',  'Leingarten Mitte',            8071003, 9.11274200, 49.1456090 ],
	[ 'TLGO',  'Leingarten Ost',              8070157, 9.13089000, 49.1442130 ],
	[ 'TLGW',  'Leingarten West',             8003624, 9.10565400, 49.1459930 ],
	[ 'MLEH',  'Leipheim',                    8003627, 10.2153690, 48.4501710 ],
	[ 'LSTG',  'Leipzig Allee-Center',        8013070, 12.2917480, 51.3191580 ],
	[ 'LACF',  'Leipzig Anger-Crottendorf',   8010008, 12.4194670, 51.3345340 ],
	[ 'LLB',   'Leipzig Bayerischer Bahnhof', 8012184, 12.3816580, 51.3292670 ],
	[ 'LCZ',   'Leipzig Coppiplatz',          8080840, 12.3660240, 51.3670740 ],
	[ 'LGRA',  'Leipzig Grünauer Allee',     8011771, 12.3030060, 51.3209050 ],
	[ 'LL',    'Leipzig Hbf',                 8010205, 12.3833360, 51.3465490 ],
	[ 'LL  T', 'Leipzig Hbf (tief)',          8098205, 12.3804280, 51.3456960 ],
	[ 'LKRS',  'Leipzig Karlsruher Str',      8010186, 12.2788680, 51.3172210 ],
	[ 'LMDR',  'Leipzig MDR',                 8012187, 12.3863180, 51.3200670 ],
	[ 'LLMK',  'Leipzig Markt',               8012186, 12.3746120, 51.3406400 ],
	[ 'LNW',   'Leipzig Messe',               8012478, 12.3892780, 51.3961450 ],
	[ 'LNW H', 'Leipzig Messe',               8012478, 12.3892780, 51.3961450 ],
	[ 'LMIA',  'Leipzig Miltitzer Allee',     8012344, 12.2673450, 51.3153530 ],
	[ 'LLN',   'Leipzig Nord',                8012196, 12.4010600, 51.3641620 ],
	[ 'LSEL',  'Leipzig Olbrichtstraße',     8012181, 12.3535000, 51.3698870 ],
	[ 'LSVS',  'Leipzig Slevogtstraße',      8012204, 12.3444160, 51.3729440 ],
	[
		'LLVD',  'Leipzig Völkerschlachtdenkmal',
		8012343, 12.4064400,
		51.3188130
	],
	[ 'LEW', 'Leipzig Werkstättenstraße', 8011495, 12.4567600, 51.3402730 ],
	[
		'LLWP', 'Leipzig Wilhelm-Leuschner-Platz',
		8012202, 12.3753940, 51.3353960
	],
	[ 'LLC',   'Leipzig-Connewitz',         8010206, 12.3857910, 51.3002580 ],
	[ 'LE',    'Leipzig-Engelsdorf',        8011491, 12.4776340, 51.3439460 ],
	[ 'LE  H', 'Leipzig-Engelsdorf',        8011491, 12.4776340, 51.3439460 ],
	[ 'LLG',   'Leipzig-Gohlis',            8012188, 12.3745330, 51.3628610 ],
	[ 'LLH',   'Leipzig-Heiterblick',       8012190, 12.4599790, 51.3693390 ],
	[ 'LHSN',  'Leipzig-Holzhausen',        8011913, 12.4614480, 51.3060410 ],
	[ 'LLK',   'Leipzig-Knauthain',         8012192, 12.3090950, 51.2781810 ],
	[ 'LLEL',  'Leipzig-Leutzsch',          8010207, 12.3033370, 51.3537720 ],
	[ 'LLWZ',  'Leipzig-Liebertwolkwitz',   8012228, 12.4692480, 51.2839700 ],
	[ 'LLIN',  'Leipzig-Lindenau',          8012236, 12.3214830, 51.3337560 ],
	[ 'LLA',   'Leipzig-Lützschena',       8012285, 12.2930910, 51.3900570 ],
	[ 'LMIZ',  'Leipzig-Miltitz',           8012355, 12.2550300, 51.3253160 ],
	[ 'LLMH',  'Leipzig-Möckern',          8012193, 12.3522710, 51.3644310 ],
	[ 'LMLK',  'Leipzig-Mölkau',           8012375, 12.4598200, 51.3252380 ],
	[ 'LLPD',  'Leipzig-Paunsdorf',         8010208, 12.4443380, 51.3443000 ],
	[ 'LLPDH', 'Leipzig-Paunsdorf',         8010208, 12.4443380, 51.3443000 ],
	[ 'LLP',   'Leipzig-Plagwitz',          8010209, 12.3220800, 51.3280400 ],
	[ 'LRMF',  'Leipzig-Rückmarsdorf',     8012817, 12.2826680, 51.3418710 ],
	[ 'LSEH',  'Leipzig-Sellerhausen',      8080930, 12.4246660, 51.3451780 ],
	[ 'LLST',  'Leipzig-Stötteritz',       8012194, 12.4114280, 51.3245120 ],
	[ 'LLT',   'Leipzig-Thekla',            8012195, 12.4309450, 51.3715450 ],
	[ 'LLW',   'Leipzig-Wahren',            8012197, 12.3216690, 51.3806700 ],
	[ 'LFLU',  'Leipzig/Halle Flughafen',   8012183, 12.2234260, 51.4233380 ],
	[ 'DLS',   'Leisnig',                   8012198, 12.9383890, 51.1603250 ],
	[ 'ALE',   'Leitstade',                 8003628, 10.9127830, 53.1691430 ],
	[ 'ULL',   'Leißling',                 8012199, 11.9098240, 51.1854840 ],
	[ 'ELBK',  'Lembeck',                   8003630, 7.02548000, 51.7512440 ],
	[ 'HLMF',  'Lemförde',                 8003632, 8.36161000, 52.4601630 ],
	[ 'ELGO',  'Lemgo',                     8003633, 8.89469600, 52.0224000 ],
	[ 'ELGL',  'Lemgo-Lüttfeld',           8003634, 8.91070000, 52.0209650 ],
	[ 'HLEM',  'Lemmie',                    8003635, 9.60857200, 52.2851040 ],
	[ 'ELSN',  'Lendringsen',               8003638, 7.82661700, 51.4103980 ],
	[ 'HBST',  'Lengede-Broistedt',         8001188, 10.3206950, 52.1970220 ],
	[ 'DRAU',  'Lengefeld-Rauenstein',      8012201, 13.2026760, 50.7305830 ],
	[ 'DLFD',  'Lengenfeld(Vogtl)',         8012203, 12.3732590, 50.5731210 ],
	[ 'MLWG',  'Lengenwang',                8003639, 10.6012140, 47.6973990 ],
	[ 'ELEN',  'Lengerich(Westf)',          8003640, 7.87845900, 52.1757850 ],
	[ 'MLG',   'Lenggries',                 8003643, 11.5735390, 47.6803950 ],
	[ 'HLGL',  'Lenglern',                  8003644, 9.87119500, 51.5884280 ],
	[ 'EA',    'Lennestadt-Altenhundem',    8000532, 8.07151700, 51.1041320 ],
	[ 'EGVB',  'Lennestadt-Grevenbrück',   8002370, 8.01797700, 51.1417810 ],
	[ 'EMEG',  'Lennestadt-Meggen',         8003939, 8.06577800, 51.1224530 ],
	[ 'ALS',   'Lensahn',                   8003649, 10.8904510, 54.2193100 ],
	[ 'ALFD',  'Lentföhrden',              8007056, 9.88983500, 53.8769090 ],
	[ 'TLE',   'Leonberg',                  8003652, 9.00385300, 48.7996460 ],
	[ 'RLEO',  'Leopoldshafen Leopoldstr.', 8007174, 8.40109900, 49.0971930 ],
	[ 'ELEO',  'Leopoldstal',               8003655, 8.97118200, 51.8444970 ],
	[ 'HLED',  'Leschede',                  8003656, 7.30596100, 52.3976440 ],
	[ 'ELE',   'Letmathe',                  8000227, 7.61839700, 51.3628380 ],
	[ 'ELED',  'Letmathe Dechenhöhle',     8003657, 7.64415400, 51.3654650 ],
	[ 'BLTS',  'Letschin',                  8012205, 14.3474470, 52.6327250 ],
	[ 'ELET',  'Lette(Kr Coesfeld)',        8003658, 7.18699800, 51.8924950 ],
	[ 'HLT',   'Letter',                    8003659, 9.63948000, 52.3938980 ],
	[ 'HLTA',  'Letter',                    8003659, 9.63948000, 52.3938980 ],
	[ 'ULBN',  'Leubingen',                 8012207, 11.1533200, 51.2050990 ],
	[ 'KLEU',  'Leubsdorf(Rhein)',          8003660, 7.28635000, 50.5470390 ],
	[ 'DLEU',  'Leubsdorf(Sachs)',          8012208, 13.1413100, 50.8018500 ],
	[ 'FBFS',  'Leun/Braunfels',            8001132, 8.36690200, 50.5399150 ],
	[ 'LLWN',  'Leuna Werke Nord',          8012211, 12.0005390, 51.3213350 ],
	[ 'LLWS',  'Leuna Werke Süd',          8012212, 12.0066370, 51.3065990 ],
	[ 'ULEU',  'Leutenberg',                8012213, 11.4478580, 50.5648190 ],
	[ 'MLSH',  'Leuterschach',              8003663, 10.5812210, 47.7456410 ],
	[ 'KLET',  'Leutesdorf(Rhein)',         8003665, 7.39206700, 50.4476820 ],
	[ 'BLE',   'Leuthen(Cottbus)',          8012215, 14.2561080, 51.6950790 ],
	[ 'TLK',   'Leutkirch',                 8000336, 10.0158360, 47.8261670 ],
	[ 'KBAY',  'Leverkusen Chempark',       8000832, 6.99667500, 51.0114090 ],
	[ 'KLMH',  'Leverkusen Mitte',          8006713, 6.99166100, 51.0315140 ],
	[ 'KLMI',  'Leverkusen Mitte',          8006713, 6.99166100, 51.0315140 ],
	[ 'KLK',   'Leverkusen-Küppersteg',    8003668, 6.98811900, 51.0458220 ],
	[ 'KLKH',  'Leverkusen-Küppersteg',    8003668, 6.98811900, 51.0458220 ],
	[ 'KLRH',  'Leverkusen-Rheindorf',      8003672, 6.96346400, 51.0642650 ],
	[ 'KLS',   'Leverkusen-Schlebusch',     8003669, 7.01512800, 51.0316160 ],
	[ 'FLI',   'Lich(Oberhess)',            8003673, 8.82195900, 50.5145780 ],
	[ 'DLIG',  'Lichtenberg(Erzgeb)',       8012220, 13.4037540, 50.8401790 ],
	[ 'NLF',   'Lichtenfels',               8000228, 11.0594720, 50.1464520 ],
	[ 'ULIH',  'Lichtenhain(a d Bergbahn)', 8012222, 11.1323710, 50.5920840 ],
	[
		'DLTSS', 'Lichtenstein Ernst-Schneller-Siedlung',
		8017404, 12.6258580, 50.7644660
	],
	[ 'DLGL', 'Lichtenstein Gewerbegebiet', 8017405, 12.6321050, 50.7752850 ],
	[
		'DLTSH', 'Lichtenstein Hartensteiner Straße',
		8017406, 12.6361900, 50.7460700
	],
	[ 'DLTS',  'Lichtenstein(Sachs)',      8012223, 12.6264120, 50.7576770 ],
	[ 'DLI',   'Lichtentanne(Sachs)',      8012224, 12.4196640, 50.6993500 ],
	[ 'ULIT',  'Lichtentanne(Thür)',      8012225, 11.4816060, 50.5243770 ],
	[ 'NLH',   'Lichtenthal',              8003676, 13.2464660, 49.0087620 ],
	[ 'WLBT',  'Liebenthal(Prignitz)',     8012226, 12.3935940, 53.1513130 ],
	[ 'FLIE',  'Lieblos',                  8003681, 9.14402000, 50.2071040 ],
	[ 'FLDB',  'Liederbach',               8007159, 8.48646500, 50.1185730 ],
	[ 'FLDS',  'Liederbach-Süd',          8070041, 8.50167800, 50.1154190 ],
	[ 'WLI',   'Lietzow(Rügen)',          8010210, 13.5100020, 54.4809650 ],
	[ 'DLIM',  'Limbach(Vogtl)',           8012231, 12.2531500, 50.5870710 ],
	[ 'SLB',   'Limbach(b Homburg,Saar)',  8003684, 7.27912700, 49.3121480 ],
	[ 'FLIS',  'Limburg Süd',             8003680, 8.09611200, 50.3824980 ],
	[ 'FL',    'Limburg(Lahn)',            8000229, 8.06234200, 50.3841190 ],
	[ 'RLI',   'Limburgerhof',             8003687, 8.39074700, 49.4242730 ],
	[ 'DLM',   'Limmritz(Sachs)',          8012232, 13.0497440, 51.1178850 ],
	[ 'LLI',   'Linda(Elster)',            8012233, 13.0851760, 51.8530560 ],
	[ 'RLID',  'Lindach',                  8003690, 9.00646000, 49.4169180 ],
	[ 'MLI',   'Lindau Hbf',               8000230, 9.68046900, 47.5443410 ],
	[ 'MLIA',  'Lindau-Aeschach',          8003692, 9.68466000, 47.5596200 ],
	[ 'BLNG',  'Lindenberg(Mark)',         8012237, 14.1117050, 52.2036250 ],
	[ 'FLHN',  'Lindenholzhausen',         8003696, 8.13337200, 50.3775650 ],
	[ 'KLD',   'Lindern',                  8003697, 6.20746700, 50.9968420 ],
	[ 'HLH',   'Lindhorst(Schaumb-Lippe)', 8003699, 9.28886700, 52.3543200 ],
	[ 'WLDW',  'Lindow(Mark)',             8012239, 12.9814170, 52.9615860 ],
	[ 'HLWL',  'Lindwedel',                8003700, 9.68902200, 52.6109430 ],
	[ 'HLIG',  'Lingen(Ems)',              8003701, 7.32173100, 52.5198670 ],
	[ 'RLF',   'Lingenfeld',               8003702, 8.34952300, 49.2525840 ],
	[ 'RLING', 'Linkenheim Rathaus',       8079018, 8.40824800, 49.1231880 ],
	[ 'KLIN',  'Linnich Bhf',              8007803, 6.27614100, 50.9826790 ],
	[ 'KLIT',  'Linnich-Tetz',             8007806, 6.32288200, 50.9642150 ],
	[ 'HLBU',  'Linsburg',                 8003705, 9.32563800, 52.6009660 ],
	[ 'TLSH',  'Linsenhofen',              8007447, 9.37153100, 48.5798670 ],
	[ 'KLI',   'Linz(Rhein)',              8003708, 7.27603200, 50.5693350 ],
	[ 'ELPP',  'Lippstadt',                8000571, 8.34878500, 51.6706870 ],
	[ 'FLIH',  'Lispenhausen',             8003711, 9.76678700, 50.9902470 ],
	[ 'KLIS',  'Lissendorf',               8003713, 6.61515800, 50.3184890 ],
	[ 'ELIS',  'Listerscheid',             8003715, 7.84949500, 51.1081430 ],
	[ 'LLO',   'Lobstädt',                8012241, 12.4487320, 51.1359970 ],
	[ 'MLCH',  'Lochham',                  8003720, 11.4308900, 48.1282470 ],
	[ 'NLOR',  'Lohgarten-Roth',           8003734, 11.0959500, 49.2435670 ],
	[ 'MLH',   'Lohhof',                   8003735, 11.5808130, 48.2879370 ],
	[ 'DLO',   'Lohmen',                   8012249, 13.9879040, 50.9890600 ],
	[ 'HLON',  'Lohne(Oldb)',              8003738, 8.22929200, 52.6653260 ],
	[ 'SLOH',  'Lohnweiler',               8003739, 7.59967000, 49.6357990 ],
	[ 'NLO',   'Lohr Bahnhof',             8003740, 9.58071500, 50.0044090 ],
	[ 'ULHO',  'Loitsch-Hohenleuben',      8012252, 12.0486480, 50.7342150 ],
	[ 'FLOL',  'Lollar',                   8000234, 8.70174000, 50.6479360 ],
	[ 'TLON',  'Lonsee',                   8003748, 9.91737700, 48.5449670 ],
	[ 'MLOH',  'Loppenhausen',             8003749, 10.3909070, 48.1625110 ],
	[ 'FLOR',  'Lorch(Rhein)',             8003751, 7.81284300, 50.0403000 ],
	[ 'TLO',   'Lorch(Württ)',            8003752, 9.69576100, 48.7979060 ],
	[ 'FLON',  'Lorchhausen',              8003753, 7.78140300, 50.0538350 ],
	[ 'FLB',   'Lorsbach',                 8003754, 8.42285300, 50.1148900 ],
	[ 'FLO',   'Lorsch',                   8003755, 8.56626200, 49.6590930 ],
	[ 'BLOS',  'Lottschesee',              8012255, 13.4985010, 52.8153980 ],
	[ 'HLOX',  'Loxstedt',                 8003760, 8.65430100, 53.4746530 ],
	[ 'RLOS',  'Loßburg-Rodt',            8003758, 8.45318700, 48.4180570 ],
	[ 'BLU',   'Lubolz',                   8012257, 13.8213510, 51.9624160 ],
	[ 'BSNZ',  'Luckaitztal',              8012897, 14.0017040, 51.6850470 ],
	[ 'BUK',   'Luckau-Uckro',             8010353, 13.6078400, 51.8521210 ],
	[ 'LLUC',  'Luckenau',                 8012259, 12.0779020, 51.0939930 ],
	[ 'BLD',   'Luckenwalde',              8012260, 13.1604090, 52.0905900 ],
	[ 'NLHM',  'Ludersheim',               8003762, 11.3238560, 49.3921660 ],
	[ 'FFL',   'Ludwigsau-Friedlos',       8002103, 9.74332500, 50.8968790 ],
	[ 'TLU',   'Ludwigsburg',              8000235, 9.18542000, 48.8918620 ],
	[ 'NLS',   'Ludwigschorgast',          8003763, 11.5572520, 50.1216240 ],
	[ 'BLF',   'Ludwigsfelde',             8010215, 13.2673190, 52.2980980 ],
	[ 'BSTH',  'Ludwigsfelde-Struveshof',  8012253, 13.2321520, 52.3171810 ],
	[ 'RLU',   'Ludwigshafen(Bodensee)',   8003764, 9.05319300, 47.8156510 ],
	[ 'RL',    'Ludwigshafen(Rh)Hbf',      8000236, 8.43340200, 49.4779870 ],
	[ 'RL  T', 'Ludwigshafen(Rh)Hbf',      8000236, 8.43340200, 49.4779870 ],
	[
		'RLBM',  'Ludwigshafen(Rhein) BASF Mitte',
		8000308, 8.43207300,
		49.5100380
	],
	[
		'RLBN', 'Ludwigshafen(Rhein) BASF Nord', 8087060, 8.42776800,
		49.5201000
	],
	[
		'RLBS', 'Ludwigshafen(Rhein) BASF Süd', 8002056, 8.43896000,
		49.4939710
	],
	[ 'RLSM', 'Ludwigshafen(Rhein) Mitte',  8003759, 8.45215200, 49.4790050 ],
	[ 'RLUM', 'Ludwigshafen-Mundenheim',    8003765, 8.42109200, 49.4615720 ],
	[ 'RLO',  'Ludwigshafen-Oggersheim',    8003766, 8.38152300, 49.4931880 ],
	[ 'RLUR', 'Ludwigshafen-Rheingönheim', 8003767, 8.40949300, 49.4474710 ],
	[ 'NLUD', 'Ludwigshöhe',               8003768, 11.2487830, 49.4995690 ],
	[ 'WL',   'Ludwigslust',                8010216, 11.4944910, 53.3346710 ],
	[ 'NLUS', 'Ludwigsstadt',               8003770, 11.3829890, 50.4865830 ],
	[ 'NLT',  'Ludwigsthal',                8003771, 13.2378150, 49.0595990 ],
	[ 'NLU',  'Luhe',                       8003794, 12.1394630, 49.5799200 ],
	[ 'NLW',  'Luhe-Wildenau',              8003795, 12.1269090, 49.5987310 ],
	[ 'SLU',  'Luisenthal(Saar)',           8003796, 6.90421400, 49.2495950 ],
	[ 'ALU',  'Lunden',                     8003798, 9.03074600, 54.3312310 ],
	[ 'HLUN', 'Lunestedt',                  8003799, 8.73508500, 53.4390840 ],
	[ 'LEL',  'Lutherstadt Eisleben',       8012279, 11.5507990, 51.5181940 ],
	[
		'LWET', 'Lutherstadt Wittenberg Altstadt',
		8012280, 12.6414310, 51.8637670
	],
	[ 'LW', 'Lutherstadt Wittenberg Hbf', 8010222, 12.6622850, 51.8678110 ],
	[
		'LWND', 'Lutherstadt Wittenberg-Labetz', 8013275, 12.6941920,
		51.8714560
	],
	[
		'LWP', 'Lutherstadt Wittenberg-Piesteritz',
		8012282, 12.5967750, 51.8718620
	],
	[ 'HLTT',  'Lutten',                      8003800, 8.34397700, 52.7681810 ],
	[ 'ELUT',  'Lutum',                       8003804, 7.22701500, 51.9826680 ],
	[ 'DL',    'Löbau(Sachs)',               8010212, 14.6719410, 51.0994470 ],
	[ 'RLOE',  'Löcherberg',                 8003721, 8.17224800, 48.4346670 ],
	[ 'WLK',   'Löcknitz',                   8010213, 14.2154170, 53.4561000 ],
	[ 'HLOD',  'Lödingsen',                  8003722, 9.79102700, 51.5891960 ],
	[ 'SLF',   'Löf',                        8003723, 7.44351200, 50.2305690 ],
	[ 'RLGN',  'Löffingen',                  8003724, 8.34180000, 47.8834340 ],
	[ 'FLOE',  'Löhnberg',                   8003726, 8.27430700, 50.5093470 ],
	[ 'HL',    'Löhne(Westf)',               8000233, 8.71350000, 52.1966530 ],
	[ 'RLRD',  'Lörrach Dammstraße',        8003736, 7.65522400, 47.5977130 ],
	[ 'RLR',   'Lörrach Hbf',                8003729, 7.66542000, 47.6140530 ],
	[ 'RLRS',  'Lörrach Museum/Burghof',     8003737, 7.66119600, 47.6079610 ],
	[ 'RLRW',  'Lörrach Schwarzwaldstraße', 8003743, 7.67256900, 47.6246830 ],
	[ 'RBRM',  'Lörrach-Brombach/Hauingen',  8001191, 7.69520700, 47.6376110 ],
	[ 'RHAG',  'Lörrach-Haagen/Messe',       8002489, 7.68089300, 47.6332330 ],
	[ 'RLST',  'Lörrach-Stetten',            8003730, 7.65903200, 47.6014180 ],
	[ 'RLFB',  'Lörzenbach-Fahrenbach',      8003731, 8.76444100, 49.6386780 ],
	[ 'KLO',   'Lövenich',                   8003732, 6.83444000, 50.9429320 ],
	[ 'KLOV',  'Lövenich',                   8003732, 6.83444000, 50.9429320 ],
	[ 'WLO',   'Löwenberg(Mark)',            8010214, 13.1900550, 52.8968010 ],
	[ 'TLOE',  'Löwental',                   8003733, 9.49924100, 47.6613980 ],
	[ 'DLN',   'Lößnitz ob Bf',             8012245, 12.7487690, 50.6248730 ],
	[ 'DLNU',  'Lößnitz unt Bf',            8012246, 12.7244600, 50.6111080 ],
	[ 'DLOE',  'Lößnitzgrund',              8012247, 13.6537650, 51.1218630 ],
	[ 'HLBB',  'Lübbecke(Westf)',            8003772, 8.60573200, 52.3063410 ],
	[ 'BLB',   'Lübben(Spreewald)',          8010217, 13.8771820, 51.9397370 ],
	[ 'BLN',   'Lübbenau(Spreewald)',        8010220, 13.9609000, 51.8621690 ],
	[ 'HLBR',  'Lübberstedt',                8003773, 8.78510400, 53.3433580 ],
	[ 'ALB',   'Lübeck Flughafen',           8003781, 10.6974840, 53.8041290 ],
	[ 'AL',    'Lübeck Hbf',                 8000237, 10.6698210, 53.8675470 ],
	[ 'ALHS',  'Lübeck Hochschulstadtteil',  8003785, 10.6889020, 53.8309830 ],
	[ 'ALSJ',  'Lübeck St Jürgen',          8003774, 10.7029420, 53.8423210 ],
	[ 'ALD A', 'Lübeck-Dänischburg IKEA',   8003786, 10.7355810, 53.9112020 ],
	[ 'ALKR',  'Lübeck-Kücknitz',           8003776, 10.8188900, 53.9249520 ],
	[
		'ALTK', 'Lübeck-Travem. Skandinavienkai',
		8006704, 10.8540290, 53.9507870
	],
	[ 'ALTH',  'Lübeck-Travemünde Hafen',  8003777, 10.8655870, 53.9587590 ],
	[ 'ALTS',  'Lübeck-Travemünde Strand', 8003778, 10.8756040, 53.9647950 ],
	[ 'WLOW',  'Lüblow(Meckl)',             8012262, 11.4643460, 53.4110420 ],
	[ 'LLBS',  'Lübs(Magdeburg)',           8012263, 11.9351700, 52.0202110 ],
	[ 'WLST',  'Lübstorf',                  8012264, 11.4113160, 53.7288810 ],
	[ 'HLN',   'Lüchtringen',               8003780, 9.42720800, 51.7909280 ],
	[ 'ELS',   'Lüdenscheid',               8003782, 7.62871700, 51.2203520 ],
	[ 'WLF',   'Lüdersdorf(Meckl)',         8012268, 10.8151430, 53.8329240 ],
	[ 'ELDH',  'Lüdinghausen',              8003783, 7.43131200, 51.7623860 ],
	[ 'HLUE',  'Lügde',                     8003784, 9.25083000, 51.9592940 ],
	[ 'ALBG',  'Lüneburg',                  8000238, 10.4198900, 53.2496560 ],
	[ 'ALBGW', 'Lüneburg',                  8000238, 10.4198900, 53.2496560 ],
	[ 'ELUE',  'Lünen Hbf',                 8000239, 7.52948500, 51.6171290 ],
	[ 'ELRN',  'Lünern',                    8003788, 7.76077100, 51.5433700 ],
	[ 'WLW',   'Lüssow(Meckl)',             8012269, 12.1378600, 53.8437240 ],
	[ 'FLUE',  'Lütter',                    8003790, 9.76553600, 50.4809000 ],
	[ 'ELUZ',  'Lützel',                    8003791, 8.17436400, 50.9670450 ],
	[ 'WLTW',  'Lützow',                    8012274, 11.1804300, 53.6559680 ],
	[ 'AMSB',  'Maasbüll(b Niebüll)',      8079021, 8.81274200, 54.7544500 ],
	[ 'LMAC',  'Machern(Sachs)',             8012284, 12.6277570, 51.3576280 ],
	[ 'LMGH',  'Magdeburg Hasselbachplatz',  8080660, 11.6253220, 52.1223950 ],
	[ 'LM',    'Magdeburg Hbf',              8010224, 11.6268910, 52.1303490 ],
	[ 'LMHR',  'Magdeburg Herrenkrug',       8013455, 11.6763790, 52.1454500 ],
	[ 'LMTW', 'Magdeburg SKET Industriepark', 8013485, 11.6382770, 52.0975450 ],
	[ 'LMSO', 'Magdeburg Südost',            8012287, 11.6699770, 52.0701900 ],
	[ 'LMB',  'Magdeburg-Buckau',             8013456, 11.6300400, 52.1092040 ],
	[ 'LMGE', 'Magdeburg-Eichenweiler',       8012289, 11.6579820, 52.1664480 ],
	[ 'LMN',  'Magdeburg-Neustadt',           8010226, 11.6417030, 52.1488430 ],
	[ 'LMR',  'Magdeburg-Rothensee',          8010086, 11.6479150, 52.1867560 ],
	[ 'LMRH', 'Magdeburg-Rothensee',          8010086, 11.6479150, 52.1867560 ],
	[ 'LMSA', 'Magdeburg-Salbke',             8012291, 11.6564470, 52.0807450 ],
	[ 'LMS',  'Magdeburg-Sudenburg',          8012292, 11.5971360, 52.1204260 ],
	[ 'TMAG', 'Magstadt',                     8003807, 8.96545400, 48.7361060 ],
	[ 'BMAH', 'Mahlow',                       8080970, 13.4079320, 52.3605400 ],
	[ 'LMW',  'Mahlwinkel',                   8012295, 11.7888240, 52.3937300 ],
	[ 'TMAI', 'Maichingen',                   8003808, 8.96992100, 48.7223310 ],
	[ 'TMIN', 'Maichingen Nord',              8003834, 8.97925700, 48.7273600 ],
	[ 'RMKI', 'Maikammer-Kirrweiler',         8003809, 8.14717700, 49.3055800 ],
	[ 'FMAS', 'Mainaschaff',                  8003810, 9.08573900, 49.9824050 ],
	[ 'FZH',  'Mainhausen Zellhausen',        8006646, 8.96994600, 50.0161570 ],
	[ 'NML',  'Mainleus',                     8003813, 11.3795250, 50.0998120 ],
	[ 'NMRH', 'Mainroth',                     8003814, 11.3192850, 50.1206610 ],
	[ 'FHD',  'Maintal Ost',                  8002877, 8.83671400, 50.1423400 ],
	[ 'FBMR', 'Maintal West',                 8000996, 8.80529600, 50.1409870 ],
	[ 'FMZ',  'Mainz Hbf',                    8000240, 8.25872000, 50.0011170 ],
	[ 'FMN',  'Mainz Nord',                   8003815, 8.24685200, 50.0200660 ],
	[ 'FMS',  'Mainz Römisches Theater',     8003816, 8.27756500, 49.9934650 ],
	[ 'FMB',  'Mainz-Bischofsheim',           8000241, 8.35811700, 49.9928180 ],
	[ 'FMB P', 'Mainz-Bischofsheim',      8000241, 8.35811700, 49.9928180 ],
	[ 'FMGO',  'Mainz-Gonsenheim',        8003817, 8.21447800, 49.9977560 ],
	[ 'FMG',   'Mainz-Gustavsburg',       8003818, 8.31419700, 49.9943190 ],
	[ 'FMK',   'Mainz-Kastel',            8000615, 8.28317400, 50.0065800 ],
	[ 'FML',   'Mainz-Laubenheim',        8003819, 8.31418300, 49.9612330 ],
	[ 'FMMB',  'Mainz-Marienborn',        8003820, 8.22297200, 49.9602830 ],
	[ 'FMM',   'Mainz-Mombach',           8003821, 8.22937000, 50.0227750 ],
	[ 'MMA',   'Maisach',                 8003824, 11.2563930, 48.2141470 ],
	[ 'WMA',   'Malchin',                 8010227, 12.7610410, 53.7434170 ],
	[ 'MMAG',  'Malching(Oberbay)',       8003828, 11.2190640, 48.2154500 ],
	[ 'MMD',   'Mallersdorf',             8003830, 12.2568980, 48.7680980 ],
	[ 'TMAL',  'Malmsheim',               8003831, 8.90450500, 48.7717550 ],
	[ 'RMS',   'Malsch',                  8003832, 8.32358500, 48.8895060 ],
	[ 'RMSU',  'Malsch Süd',             8003833, 8.31623400, 48.8875910 ],
	[ 'FMFH',  'Malsfeld',                8000243, 9.53483300, 51.0976050 ],
	[ 'FBEF',  'Malsfeld-Beiseförth',    8000859, 9.55313000, 51.0830760 ],
	[ 'DMAL',  'Malter',                  8012298, 13.6543430, 50.9235950 ],
	[ 'MMAM',  'Mammendorf',              8004204, 11.1746180, 48.2168260 ],
	[ 'FMAN',  'Mandern',                 8003836, 9.20615500, 51.1255430 ],
	[ 'UMCH',  'Manebach',                8012299, 10.8625010, 50.6802910 ],
	[ 'NMDF',  'Manndorf',                8003839, 10.8342240, 50.0383950 ],
	[ 'RMSM',  'Mannheim ARENA/Maimarkt', 8003841, 8.51635800, 49.4597860 ],
	[ 'RMR A', 'Mannheim ARENA/Maimarkt', 8003841, 8.51635800, 49.4597860 ],
	[ 'RMHH',  'Mannheim Handelshafen',   8006508, 8.45391700, 49.4926230 ],
	[ 'RM',    'Mannheim Hbf',            8000244, 8.46892100, 49.4793540 ],
	[ 'RMFS', 'Mannheim-Friedrichsfeld Süd', 8003842, 8.57238200, 49.4381440 ],
	[ 'RMKL', 'Mannheim-Käfertal',           8003843, 8.50377200, 49.5015580 ],
	[ 'RMLB', 'Mannheim-Luzenberg',           8006509, 8.47777500, 49.5172010 ],
	[ 'RMN',  'Mannheim-Neckarau',            8003844, 8.49479200, 49.4555450 ],
	[ 'RMNS', 'Mannheim-Neckarstadt',         8006511, 8.45956600, 49.5036330 ],
	[ 'RMA',  'Mannheim-Rheinau',             8003845, 8.53494400, 49.4240910 ],
	[ 'RMSE', 'Mannheim-Seckenheim',          8003847, 8.53810700, 49.4509620 ],
	[ 'RMW',  'Mannheim-Waldhof',             8003848, 8.48260300, 49.5256610 ],
	[
		'RMBO', 'Marbach Ost (Villingen-Schwenningen)',
		8003857, 8.47588400, 48.0336830
	],
	[
		'RMBW', 'Marbach West(Villingen-Schwenningen)',
		8003854, 8.46915400, 48.0312860
	],
	[ 'TMB',  'Marbach(Neckar)',             8003853, 9.26445200, 48.9436850 ],
	[ 'TMBM', 'Marbach(b Münsingen)',       8070481, 9.42230400, 48.3837160 ],
	[ 'TGRA', 'Marbach-Grafeneck',           8003851, 9.43117100, 48.3958560 ],
	[ 'EMHD', 'Marbeck-Heiden',              8003855, 6.90606700, 51.8094040 ],
	[ 'FMBS', 'Marburg Süd',                8003856, 8.76243100, 50.7944670 ],
	[ 'FMBG', 'Marburg(Lahn)',               8000337, 8.77501400, 50.8192720 ],
	[ 'MMRN', 'Maria Rain',                  8003859, 10.4802750, 47.6325520 ],
	[ 'EMV',  'Maria Veen',                  8003860, 7.09816700, 51.8392660 ],
	[ 'LMBN', 'Marienborn',                  8012302, 11.1232690, 52.1979040 ],
	[ 'HMAR', 'Marienhafe',                  8003866, 7.27073100, 53.5208930 ],
	[ 'KMAH', 'Marienheide',                 8070483, 7.53198200, 51.0811230 ],
	[ 'RMAD', 'Markdorf(Baden)',             8003871, 9.38864000, 47.7168160 ],
	[ 'LMAR', 'Marke',                       8012305, 12.2570280, 51.7411000 ],
	[ 'RMAR', 'Markelfingen',                8003872, 9.00277200, 47.7393640 ],
	[ 'TMA',  'Markelsheim',                 8003873, 9.83541800, 49.4782640 ],
	[ 'LMA',  'Markkleeberg',                8012308, 12.3726150, 51.2790290 ],
	[ 'LMAN', 'Markkleeberg Nord',           8012304, 12.3722040, 51.2879980 ],
	[ 'LGW',  'Markkleeberg-Gaschwitz',      8011598, 12.3792200, 51.2500760 ],
	[ 'LMAG', 'Markkleeberg-Großstädteln', 8010228, 12.3761290, 51.2622190 ],
	[ 'LMKS', 'Markranstädt',               8012311, 12.2247600, 51.3071800 ],
	[ 'UML',  'Marksuhl',                    8012312, 10.2245890, 50.9083500 ],
	[ 'NMB',  'Markt Bibart',                8003876, 10.4254660, 49.6460890 ],
	[ 'NMER', 'Markt Erlbach',               8003878, 10.6584490, 49.4926750 ],
	[ 'MIDR', 'Markt Indersdorf',            8003072, 11.3784460, 48.3523910 ],
	[ 'MSB',  'Markt Schwaben',              8003879, 11.8620930, 48.1936060 ],
	[ 'NMT',  'Marktbreit',                  8003881, 10.1460920, 49.6638040 ],
	[ 'MMK',  'Marktl',                      8003883, 12.8524780, 48.2566950 ],
	[ 'NMH',  'Marktleuthen',                8003884, 12.0131700, 50.1308030 ],
	[ 'MMO',  'Marktoberdorf',               8003885, 10.6142300, 47.7792150 ],
	[ 'MMOS', 'Marktoberdorf Schule',        8003877, 10.6099970, 47.7740990 ],
	[ 'NMR',  'Marktredwitz',                8000247, 12.0825830, 50.0045960 ],
	[ 'NMSG', 'Marktschorgast',              8003887, 11.6535300, 50.0907940 ],
	[ 'EMAM', 'Marl Mitte',                  8003888, 7.09957500, 51.6538370 ],
	[ 'EMHM', 'Marl-Hamm',                   8003890, 7.13142200, 51.6829720 ],
	[ 'EMSI', 'Marl-Sinsen',                 8003891, 7.17348200, 51.6677480 ],
	[ 'UMAH', 'Marlishausen',                8012314, 11.0100560, 50.8195040 ],
	[ 'FMHM', 'Marnheim',                    8003893, 8.03914100, 49.6230210 ],
	[ 'BMQU', 'Marquardt',                   8012315, 12.9716270, 52.4588810 ],
	[ 'EMAR', 'Marsberg',                    8003896, 8.85490400, 51.4628890 ],
	[ 'TMAR', 'Marstetten-Aitrach',          8003897, 10.0801660, 47.9439390 ],
	[ 'WMTF', 'Martensdorf',                 8012316, 12.9302520, 54.3009180 ],
	[ 'NMLZ', 'Martinlamitz',                8003898, 11.9505150, 50.2155270 ],
	[ 'UMT',  'Martinroda',                  8012317, 10.8809430, 50.7331450 ],
	[ 'SMSO', 'Martinstein',                 8003899, 7.53662500, 49.8039780 ],
	[ 'SMSW', 'Martinstein',                 8003899, 7.53662500, 49.8039780 ],
	[ 'MMSZ', 'Martinszell(Allgäu)',        8003901, 10.2737770, 47.6292070 ],
	[ 'NMX',  'Marxgrün',                   8003903, 11.6865680, 50.3549780 ],
	[ 'RMX',  'Marxzell',                    8007009, 8.44735100, 48.8633280 ],
	[ 'MMZG', 'Marzling',                    8003905, 11.8001080, 48.4104010 ],
	[ 'AMA',  'Maschen',                     8003906, 10.0656620, 53.4038150 ],
	[ 'TMSM', 'Maselheim',                   8079119, 9.87761400, 48.1332490 ],
	[ 'EMAN', 'Massen',                      8003909, 7.64371100, 51.5417760 ],
	[ 'MMSG', 'Massing',                     8003910, 12.6081660, 48.3940060 ],
	[ 'MMTZ', 'Matzing',                     8003912, 12.5923900, 47.9355270 ],
	[ 'TMAU', 'Maubach',                     8003913, 9.41999000, 48.9261320 ],
	[ 'RMAU', 'Mauer(b Heidelberg)',         8003915, 8.79554500, 49.3358020 ],
	[ 'TMBS', 'Maulbronn Stadt/Kloster',     8003918, 8.80269100, 48.9965460 ],
	[ 'TMW',  'Maulbronn West',              8087080, 8.78153600, 48.9837450 ],
	[ 'TMWA', 'Maulbronn West',              8087080, 8.78153600, 48.9837450 ],
	[ 'RMLG', 'Maulburg',                    8003920, 7.78066200, 47.6443740 ],
	[ 'NMSM', 'Mausheim',                    8003921, 11.7662090, 49.1215870 ],
	[ 'NMAU', 'Mauthaus',                    8070804, 11.4945020, 50.3234040 ],
	[ 'RMAX', 'Maxau',                       8084068, 8.30773600, 49.0359660 ],
	[ 'NMXH', 'Maxhütte-Haidhof',           8003922, 12.1078180, 49.1980190 ],
	[
		'RMAL',  'Maximiliansau Eisenbahnstraße',
		8003923, 8.29881400,
		49.0371430
	],
	[ 'RMAW', 'Maximiliansau West',       8084067, 8.29179700, 49.0389340 ],
	[ 'RMAI', 'Maximiliansau-Im Rüsten', 8003911, 8.27942100, 49.0348800 ],
	[ 'KMYO', 'Mayen Ost',                8000248, 7.23893900, 50.3295940 ],
	[ 'KMYW', 'Mayen West',               8003924, 7.21389400, 50.3283730 ],
	[ 'KMAY', 'Mayschoß',                8003926, 7.02046300, 50.5172330 ],
	[ 'KMCH', 'Mechernich',               8003927, 6.64229600, 50.5913670 ],
	[ 'UME',  'Mechterstädt',            8012320, 10.5213670, 50.9437780 ],
	[ 'AMDH', 'Meckelfeld',               8003929, 10.0297110, 53.4243800 ],
	[ 'TMK',  'Meckenbeuren',             8003930, 9.55839300, 47.6997600 ],
	[ 'KMCP', 'Meckenheim Industriepark', 8003937, 7.02722400, 50.6439170 ],
	[ 'KKOF', 'Meckenheim Kottenforst',   8003414, 7.02268300, 50.6624120 ],
	[ 'KMCK', 'Meckenheim(Bz Köln)',     8003931, 7.01475700, 50.6274460 ],
	[ 'RMK',  'Meckesheim',               8003932, 8.81283600, 49.3206580 ],
	[ 'BMZ',  'Medewitz(Mark)',           8012322, 12.3918290, 52.0607060 ],
	[ 'NMEE', 'Meeder',                   8003938, 10.9068420, 50.3156560 ],
	[ 'DMA',  'Meerane',                  8012323, 12.4572470, 50.8509750 ],
	[ 'KMBO', 'Meerbusch-Osterath',       8004694, 6.62598100, 51.2690170 ],
	[ 'AMSS', 'Meeschensee',              8079026, 9.97963000, 53.7542220 ],
	[ 'DMEH', 'Mehltheuer',               8010229, 12.0370910, 50.5443120 ],
	[ 'EMHO', 'Mehrhoog',                 8003943, 6.51825000, 51.7389650 ],
	[ 'HMEI', 'Meine',                    8003947, 10.5358120, 52.3813530 ],
	[ 'DMS',  'Meinersdorf(Erzgeb)',      8012324, 12.8881750, 50.7230060 ],
	[ 'HMRS', 'Meinersen',                8003949, 10.3211140, 52.4491880 ],
	[ 'EMZH', 'Meinerzhagen',             8003950, 7.63411600, 51.1081440 ],
	[ 'UM',   'Meiningen',                8010230, 10.4212050, 50.5740700 ],
	[ 'LMEI', 'Meinsdorf',                8010231, 12.2563690, 51.9031910 ],
	[ 'MMEI', 'Meitingen',                8003952, 10.8480500, 48.5459970 ],
	[ 'LME',  'Meitzendorf',              8012328, 11.5589670, 52.2093940 ],
	[ 'DME',  'Meißen',                  8012326, 13.4825220, 51.1629570 ],
	[ 'DMEA', 'Meißen Altstadt',         8012318, 13.4734010, 51.1593030 ],
	[ 'DMT',  'Meißen Triebischtal',     8012327, 13.4625290, 51.1524720 ],
	[ 'FMLB', 'Melbach',                  8003953, 8.81142300, 50.3791480 ],
	[ 'WMCH', 'Melchow',                  8012329, 13.6943750, 52.7748710 ],
	[ 'AMF',  'Meldorf',                  8003954, 9.08008500, 54.0877710 ],
	[ 'HMEL', 'Melle',                    8003956, 8.34322100, 52.2092570 ],
	[ 'UMEL', 'Mellenbach-Glasbach',      8012330, 11.1102810, 50.6032500 ],
	[ 'HMDF', 'Mellendorf',               8003957, 9.74450100, 52.5481990 ],
	[ 'UMEN', 'Mellingen(Thür)',         8012332, 11.3943180, 50.9500940 ],
	[ 'NME',  'Mellrichstadt Bf',         8003959, 10.3070390, 50.4247820 ],
	[ 'AME',  'Melsdorf',                 8003960, 10.0308300, 54.3127540 ],
	[ 'FMLS', 'Melsungen',                8003961, 9.54607900, 51.1260020 ],
	[
		'FMBB', 'Melsungen Bartenwetzerbrücke', 8003971, 9.54883900,
		51.1321770
	],
	[ 'FRFH',  'Melsungen-Röhrenfurth',      8005125, 9.54837200, 51.1543770 ],
	[ 'FRFHW', 'Melsungen-Röhrenfurth',      8005125, 9.54837200, 51.1543770 ],
	[ 'MM',    'Memmingen',                   8000249, 10.1868530, 47.9855810 ],
	[ 'KMD',   'Menden(Rheinl)',              8003966, 7.14954900, 50.7799170 ],
	[ 'EMED',  'Menden(Sauerland)',           8003967, 7.79208400, 51.4352710 ],
	[ 'EMEU',  'Menden(Sauerland)Süd',       8003965, 7.80780400, 51.4283330 ],
	[ 'KNME',  'Mendig',                      8004393, 7.29100700, 50.3696580 ],
	[ 'TMG',   'Mengen',                      8003969, 9.33654700, 48.0537010 ],
	[ 'FMGH',  'Mengeringhausen',             8003970, 8.98976300, 51.3602040 ],
	[ 'UMGH',  'Mengersgereuth-Hämmern',     8012333, 11.1182990, 50.3928920 ],
	[ 'UMHO',  'Mengersgereuth-Hämmern Ost', 8012334, 11.1277450, 50.3894710 ],
	[ 'RMZN',  'Menzingen(Baden)',            8007145, 8.77506700, 49.1362330 ],
	[ 'HMEP',  'Meppen',                      8003978, 7.29801500, 52.6960210 ],
	[ 'MMEG',  'Merching',                    8003979, 10.9793970, 48.2457690 ],
	[ 'SMER',  'Merchweiler',                 8003980, 7.06554700, 49.3560290 ],
	[ 'MMR',   'Mering',                      8003982, 10.9882910, 48.2626980 ],
	[ 'MSAF',  'Mering-St Afra',              8004008, 10.9712020, 48.2742820 ],
	[ 'EMES',  'Mersch(Westf)',               8003986, 7.73741200, 51.7621120 ],
	[ 'LMG',   'Merseburg',                   8010232, 11.9905510, 51.3568890 ],
	[ 'LMGB',  'Merseburg Bergmannsring',     8012339, 11.9896510, 51.3373710 ],
	[ 'KMES',  'Merten(Sieg)',                8003987, 7.38565700, 50.7704800 ],
	[ 'RME',   'Mertesheim',                  8003988, 8.13392300, 49.5691950 ],
	[ 'MMTG',  'Mertingen Bahnhof',           8003989, 10.8251800, 48.6604850 ],
	[ 'KMEZ',  'Merzenich',                   8003990, 6.51805100, 50.8400320 ],
	[ 'SMZG',  'Merzig(Saar)',                8003992, 6.63419200, 49.4364190 ],
	[ 'SMZM',  'Merzig(Saar) Stadtmitte',     8003991, 6.63522600, 49.4434780 ],
	[ 'HNMU',  'Mesch Neue Mühle',           8070734, 8.52084900, 52.2638400 ],
	[ 'EMSD',  'Meschede',                    8003993, 8.27905300, 51.3496030 ],
	[ 'FMES',  'Messel',                      8003996, 8.74596900, 49.9217180 ],
	[ 'EMSN',  'Messinghausen',               8003998, 8.67977500, 51.3931920 ],
	[ 'EMTE',  'Metelen Land',                8004001, 7.25417300, 52.1624940 ],
	[ 'FMET',  'Mettenheim',                  8004003, 8.33416600, 49.7399060 ],
	[ 'SMT',   'Mettlach',                    8004004, 6.59831500, 49.4954760 ],
	[ 'KME',   'Mettmann Stadtwald',          8004005, 6.98695100, 51.2510190 ],
	[ 'KMEW',  'Mettmann Zentrum',            8004007, 6.97981300, 51.2486560 ],
	[ 'TME',   'Metzingen(Württ)',           8004009, 9.29015600, 48.5397250 ],
	[ 'TNHU',  'Metzingen-Neuhausen',         8070678, 9.30710600, 48.5326470 ],
	[ 'UMEU',  'Meuselbach-Schwarzmühle',    8012346, 11.0792140, 50.5814120 ],
	[ 'WME',   'Meyenburg',                   8012348, 12.2471610, 53.3110960 ],
	[ 'LMF',   'Meßdorf',                    8012342, 11.5467710, 52.7098990 ],
	[ 'NMI',   'Michelau(Oberfr)',            8004011, 11.1162450, 50.1549800 ],
	[ 'TMIC',  'Michelau(Württ)',            8007194, 9.53525600, 48.8619130 ],
	[ 'NMIK',  'Michelaubrück',              8004013, 9.76767900, 50.1167120 ],
	[ 'FMIC',  'Michelbach(Unterfr)',         8007277, 9.10449600, 50.0998140 ],
	[
		'FMICH', 'Michelbach(Unterfr) Herrnmühle',
		8070165, 9.11829800,
		50.0997830
	],
	[ 'FMI',   'Michelstadt',                8004017, 9.00145300, 49.6848580 ],
	[ 'BMIP',  'Michendorf',                 8010233, 13.0306880, 52.3163440 ],
	[ 'TMST',  'Miedelsbach-Steinenberg',    8007193, 9.53913000, 48.8436200 ],
	[ 'MMIB',  'Miesbach',                   8004019, 11.8306570, 47.7904430 ],
	[ 'SRAM',  'Miesenbach',                 8007482, 7.54837300, 49.4563680 ],
	[ 'KMIE',  'Miesenheim',                 8004020, 7.40759800, 50.4040430 ],
	[ 'LMST',  'Mieste',                     8012351, 11.2047710, 52.4837500 ],
	[ 'LMT',   'Miesterhorst',               8012352, 11.1201780, 52.4662510 ],
	[ 'EMIL',  'Millingen(b Rees)',          8004024, 6.40001200, 51.8094570 ],
	[ 'KMIL',  'Millingen(b Rheinb)',        8004023, 6.55637300, 51.5601540 ],
	[ 'NMLT',  'Miltach',                    8004026, 12.7683000, 49.1639620 ],
	[ 'NM',    'Miltenberg',                 8000640, 9.24846700, 49.7064810 ],
	[ 'LMI',   'Miltern',                    8012354, 11.9366240, 52.5633440 ],
	[ 'WMI',   'Miltzow',                    8012358, 13.2010080, 54.1992630 ],
	[ 'NMIM',  'Mimberg',                    8004028, 11.2745640, 49.3528140 ],
	[ 'MMAH',  'Mindelaltheim',              8004030, 10.4079050, 48.4559780 ],
	[ 'MMH',   'Mindelheim',                 8000338, 10.5016260, 48.0449170 ],
	[ 'HM',    'Minden(Westf)',              8000252, 8.93472800, 52.2901380 ],
	[ 'WMIR',  'Mirow',                      8012361, 12.8207590, 53.2704300 ],
	[ 'WMIS',  'Mistorf',                    8012362, 12.1230440, 53.8804970 ],
	[ 'FMGD',  'Mittel Gründau',            8004037, 9.11981800, 50.2307980 ],
	[ 'DMHD',  'Mittelherwigsdorf',          8010234, 14.7412800, 50.9227940 ],
	[ 'DMST',  'Mitteloelsnitz',             8012366, 12.7066650, 50.7180310 ],
	[ 'UMSK',  'Mittelschmalkalden',         8012367, 10.4000550, 50.7177140 ],
	[ 'NMSN',  'Mittelsinn',                 8004040, 9.62342300, 50.1911950 ],
	[ 'MMW',   'Mittenwald',                 8004043, 11.2657050, 47.4400300 ],
	[ 'MMIG',  'Mittergars',                 8004046, 12.3329900, 48.1501610 ],
	[ 'DMW',   'Mittweida',                  8012369, 12.9598630, 50.9875450 ],
	[ 'BMX',   'Mixdorf',                    8012370, 14.3948020, 52.1977800 ],
	[ 'TMO',   'Mochenwangen',               8004049, 9.63790100, 47.8725710 ],
	[ 'LMRN',  'Mockrehna',                  8012371, 12.8195040, 51.5056060 ],
	[ 'KMO',   'Moers',                      8000644, 6.64153500, 51.4511470 ],
	[ 'WMOI',  'Moidentin',                  8012384, 11.4819180, 53.8060710 ],
	[ 'TMON',  'Monbach-Neuhausen',          8004077, 8.72832800, 48.7991660 ],
	[ 'SML',   'Monreal',                    8004078, 7.15305500, 50.2963570 ],
	[ 'FMSH',  'Monsheim',                   8000663, 8.20816200, 49.6336660 ],
	[ 'FMT',   'Montabaur',                  8000667, 7.82533300, 50.4448340 ],
	[ 'FMTN',  'Montabaur',                  8000667, 7.82533300, 50.4448340 ],
	[ 'SMON',  'Monzingen',                  8004080, 7.58867300, 49.7934660 ],
	[ 'AMBH',  'Moorbekhalle',               8079023, 9.99174400, 53.7171550 ],
	[ 'SMBT',  'Moosbachtal',                8079265, 7.75495900, 49.1659540 ],
	[ 'MMB',   'Moosburg',                   8004084, 11.9303820, 48.4703300 ],
	[ 'MMRI',  'Moosrain',                   8007630, 11.7205500, 47.7675740 ],
	[ 'DMO',   'Moritzburg',                 8012387, 13.6834350, 51.1555870 ],
	[ 'NMOU',  'Morlesau',                   8004090, 9.79906600, 50.1171460 ],
	[ 'AMM',   'Morsum',                     8004093, 8.43246400, 54.8721420 ],
	[ 'RMOW',  'Mosbach West',               8004095, 9.13404200, 49.3467700 ],
	[ 'RMO',   'Mosbach(Baden)',             8004094, 9.14365500, 49.3525600 ],
	[ 'RNZ',   'Mosbach-Neckarelz',          8000264, 9.11309300, 49.3484840 ],
	[ 'DML',   'Mosel',                      8012388, 12.4813990, 50.7835980 ],
	[ 'SMK',   'Moselkern',                  8004096, 7.37135700, 50.1954830 ],
	[ 'EMUD',  'Mudersbach',                 8004099, 7.95165100, 50.8274760 ],
	[ 'RMU',   'Muggensturm',                8004178, 8.27429300, 48.8768050 ],
	[ 'RMU B', 'Muggensturm Badesee',        8004192, 8.28661300, 48.8799960 ],
	[ 'NMS',   'Muhr a See',                 8000534, 10.7204930, 49.1543600 ],
	[ 'DMUL',  'Mulda(Sachs)',               8012407, 13.4131530, 50.8089990 ],
	[ 'DMBH',  'Muldenberg Floßplatz',      8000273, 12.3990340, 50.4156900 ],
	[ 'DMH',   'Muldenhütten',              8012408, 13.3889080, 50.9055940 ],
	[ 'LMD',   'Muldenstein',                8012409, 12.3540470, 51.6677870 ],
	[ 'AMS',   'Mulsum-Essel',               8007809, 9.30707300, 53.4987450 ],
	[ 'TMU',   'Munderkingen',               8004182, 9.64567100, 48.2378720 ],
	[ 'HMS',   'Munster(Örtze)',            8004183, 10.0964870, 52.9933120 ],
	[ 'RMRG',  'Murg(Baden)',                8004184, 8.01872500, 47.5534520 ],
	[ 'MMU',   'Murnau',                     8004185, 11.1926280, 47.6822660 ],
	[ 'MUO',   'Murnau Ort',                 8004186, 11.1956600, 47.6788340 ],
	[ 'TMT',   'Murrhardt',                  8004188, 9.57777000, 48.9827570 ],
	[ 'RMCH',  'Mußbach',                   8004189, 8.16852900, 49.3719600 ],
	[ 'LMAE',  'Mägdesprung',               8017015, 11.1326530, 51.6703750 ],
	[ 'TMGK',  'Mägerkingen',               8070480, 9.22193200, 48.2875250 ],
	[ 'TML',   'Möckmühl',                 8004050, 9.35797900, 49.3211070 ],
	[ 'LMGI',  'Mögelin',                   8012373, 12.3298150, 52.5600890 ],
	[ 'TMOE',  'Mögglingen(Gmünd)',        8004053, 9.96031600, 48.8252890 ],
	[ 'TMHB',  'Möhringen Bahnhof',         8004068, 8.77079600, 47.9581510 ],
	[ 'TMHR',  'Möhringen Rathaus',         8004067, 8.76337300, 47.9572370 ],
	[ 'AMLN',  'Mölln(Lauenb)',             8004057, 10.6832090, 53.6244140 ],
	[ 'WMOE',  'Mölln(Meckl)',              8012376, 13.0845070, 53.5859390 ],
	[ 'FMOE',  'Mömbris-Mensengesäß',     8007279, 9.16621800, 50.0703090 ],
	[ 'FMOES', 'Mömbris-Strötzbach',       8070166, 9.15622800, 50.0794710 ],
	[ 'KM',    'Mönchengladbach Hbf',       8000253, 6.44611100, 51.1965830 ],
	[ 'KMGE',  'Mönchengladbach-Genhausen', 8004061, 6.32904000, 51.1480810 ],
	[ 'KML',   'Mönchengladbach-Lürrip',   8001745, 6.47242800, 51.1996250 ],
	[ 'KMR',  'Mönchengladbach-Rheindahlen', 8004063, 6.35789400, 51.1507120 ],
	[ 'WMN',  'Mönchhagen',                  8012377, 12.2253360, 54.1435700 ],
	[ 'NMOE', 'Mönchröden',                 8004064, 11.0576130, 50.3022270 ],
	[ 'FMF',  'Mörfelden',                   8004065, 8.56538400, 49.9790000 ],
	[ 'LMGN', 'Möringen(Altm)',              8012378, 11.7488490, 52.5816610 ],
	[ 'RMOE', 'Mörlenbach',                  8004066, 8.73098700, 49.5972990 ],
	[ 'LMOS', 'Möser',                       8012381, 11.7846200, 52.2189810 ],
	[ 'TMS',  'Mössingen',                   8004070, 9.04653000, 48.4043090 ],
	[ 'MMTN', 'Möttingen',                   8004071, 10.5978320, 48.8068060 ],
	[ 'LMCH', 'Mücheln(Geiseltal)',          8012390, 11.8044370, 51.3076410 ],
	[ 'LMCZ', 'Mücheln(Geiseltal) Stadt',    8012392, 11.8137710, 51.3038550 ],
	[ 'FMCK', 'Mücke(Hess)',                 8004100, 9.02903500, 50.6171000 ],
	[ 'SMD',  'Müden(Mosel)',                8004101, 7.33939300, 50.1848600 ],
	[ 'DMUE', 'Mügeln Bf',                   8070695, 13.0597970, 51.2364620 ],
	[ 'DMUES', 'Mügeln Stadt',              8070696, 13.0478450, 51.2385930 ],
	[ 'TM',    'Mühlacker',                 8000339, 8.84610100, 48.9531920 ],
	[ 'TMRO',  'Mühlacker Rößlesweg',     8004103, 8.86014300, 48.9563400 ],
	[ 'LMUA',  'Mühlanger',                 8012393, 12.7482120, 51.8557120 ],
	[ 'DMHL',  'Mühlbach(Pirna)',           8012394, 13.8183380, 50.9141160 ],
	[ 'MMF',   'Mühldorf(Oberbay)',         8000258, 12.5196380, 48.2482080 ],
	[ 'HMLN',  'Mühlen(Oldb)',              8004105, 8.20851200, 52.6196920 ],
	[ 'TMUE',  'Mühlen(b Horb)',            8004104, 8.72680200, 48.4499410 ],
	[ 'BMM',   'Mühlenbeck-Mönchmühle',   8080980, 13.3868440, 52.6546050 ],
	[ 'UMH',   'Mühlhausen(Thür)',         8010235, 10.4740410, 51.2091930 ],
	[ 'RMH',   'Mühlhausen(b Engen)',       8004107, 8.80439100, 47.8136580 ],
	[ 'FMH',   'Mühlheim(Main)',            8004112, 8.83764600, 50.1192770 ],
	[ 'FMHD',  'Mühlheim(Main)-Dietesheim', 8070088, 8.85799800, 50.1205190 ],
	[ 'TMUL',  'Mühlheim(b Tuttlingen)',    8004111, 8.88555200, 48.0293640 ],
	[ 'NMST',  'Mühlstetten',               8004115, 11.0079600, 49.1514910 ],
	[ 'FNR',   'Mühltal',                   8004350, 8.70331800, 49.8322030 ],
	[ 'TMRN',  'Mühringen',                 8070494, 8.76016900, 48.4203280 ],
	[ 'EMLR',  'Mülheim(Ruhr)Hbf',          8000259, 6.88651000, 51.4313420 ],
	[ 'EMRY',  'Mülheim(Ruhr)Styrum',       8000687, 6.85263600, 51.4492030 ],
	[ 'EMRW',  'Mülheim(Ruhr)West',         8004122, 6.87140400, 51.4396540 ],
	[ 'RML',   'Müllheim(Baden)',           8004124, 7.59933200, 47.8097430 ],
	[ 'BMR',   'Müllrose',                  8012400, 14.4342460, 52.2420460 ],
	[ 'NMBG',  'Münchberg',                 8004126, 11.7906670, 50.1890430 ],
	[ 'BMB',   'Müncheberg(Mark)',          8010236, 14.1003320, 52.5247270 ],
	[ 'HMHZ',  'Münchehof(Harz)',           8004127, 10.1886540, 51.8483060 ],
	[
		'MMDN', 'München Donnersbergerbrücke', 8004128, 11.5365370,
		48.1426230
	],
	[
		'MFHB', 'München Flughafen Besucherpark',
		8004167, 11.7641850, 48.3520950
	],
	[ 'MFHM',  'München Flughafen Terminal', 8004168, 11.7859700, 48.3537280 ],
	[ 'MFHT',  'München Flughafen Terminal', 8004168, 11.7859700, 48.3537280 ],
	[ 'MHAB',  'München Hackerbrücke',      8004129, 11.5485720, 48.1419690 ],
	[ 'MHAR',  'München Harras',             8004130, 11.5363110, 48.1177470 ],
	[ 'MH',    'München Hbf',                8000261, 11.5583350, 48.1402320 ],
	[ 'MHT',   'München Hbf (tief)',         8098263, 11.5604930, 48.1411720 ],
	[ 'MH  N', 'München Hbf Gl.27-36',       8098261, 11.5567080, 48.1415290 ],
	[ 'MH  S', 'München Hbf Gl.5-10',        8098262, 11.5553710, 48.1400940 ],
	[ 'MHP',   'München Heimeranplatz',      8005419, 11.5315000, 48.1329610 ],
	[ 'MHPW',  'München Heimeranplatz',      8005419, 11.5315000, 48.1329610 ],
	[ 'MMHG',  'München Hirschgarten',       8004179, 11.5192450, 48.1435400 ],
	[ 'MIT',   'München Isartor',            8004131, 11.5832340, 48.1342020 ],
	[ 'MKA',   'München Karlsplatz',         8004132, 11.5656190, 48.1394520 ],
	[ 'MLEF',  'München Leienfelsstr.',      8004133, 11.4285240, 48.1545380 ],
	[ 'MLEU',  'München Leuchtenbergring',   8004134, 11.6159860, 48.1342500 ],
	[ 'MMP',   'München Marienplatz',        8004135, 11.5753860, 48.1370480 ],
	[ 'MOP',   'München Ost',                8000262, 11.6049710, 48.1274400 ],
	[ 'MRP',   'München Rosenheimer Platz',  8004136, 11.5930490, 48.1291680 ],
	[ 'MSW',   'München Siemenswerke',       8004137, 11.5327990, 48.0945030 ],
	[ 'MMAR',  'München St.Martin-Str.',     8004138, 11.5957850, 48.1185430 ],
	[ 'UMU',   'München(Bad Berka)',         8012401, 11.2545960, 50.8700510 ],
	[ 'MMAL',  'München-Allach',             8004140, 11.4680360, 48.1899320 ],
	[ 'MMAU',  'München-Aubing',             8004141, 11.4133090, 48.1559680 ],
	[ 'MBAL',  'München-Berg am Laim',       8004142, 11.6332950, 48.1340010 ],
	[ 'MDFG',  'München-Daglfing',           8004143, 11.6493300, 48.1496220 ],
	[ 'MEGS',  'München-Englschalking',      8004144, 11.6483350, 48.1569150 ],
	[ 'MFAS',  'München-Fasanerie',          8004145, 11.5259240, 48.1978110 ],
	[ 'MFG',   'München-Fasangarten',        8004146, 11.6060090, 48.0927460 ],
	[ 'MFE',   'München-Feldmoching',        8004147, 11.5413180, 48.2138130 ],
	[ 'MFHH',  'München-Freiham',            8004181, 11.4101120, 48.1400000 ],
	[ 'MGI',   'München-Giesing',            8004148, 11.5963460, 48.1108030 ],
	[ 'MJK',   'München-Johanneskirchen',    8004149, 11.6460580, 48.1676380 ],
	[ 'MKFS',  'München-Karlsfeld',          8004150, 11.4595680, 48.2111790 ],
	[ 'ML',    'München-Laim',               8004151, 11.5036690, 48.1443710 ],
	[ 'MLW',   'München-Langwied',           8004152, 11.4325080, 48.1631120 ],
	[ 'MLO',   'München-Lochhausen',         8004153, 11.4078950, 48.1765050 ],
	[ 'MMT',   'München-Mittersendling',     8004154, 11.5363540, 48.1078240 ],
	[ 'MMCH',  'München-Moosach',            8004155, 11.5062370, 48.1802580 ],
	[ 'MNA',   'München-Neuaubing',          8004156, 11.4221970, 48.1417060 ],
	[ 'MNPS',  'München-Neuperlach Süd',    8006696, 11.6451750, 48.0886850 ],
	[ 'MOZ',   'München-Obermenzing',        8004157, 11.4781170, 48.1642230 ],
	[ 'MP',    'München-Pasing',             8004158, 11.4618720, 48.1498520 ],
	[ 'MP  S', 'München-Pasing',             8004158, 11.4618720, 48.1498520 ],
	[ 'MPER',  'München-Perlach',            8004159, 11.6312080, 48.0934260 ],
	[ 'MRI P', 'München-Riem',               8004160, 11.6780490, 48.1439830 ],
	[ 'MSN',   'München-Solln',              8004161, 11.5269540, 48.0799210 ],
	[ 'MTR',   'München-Trudering',          8004162, 11.6633750, 48.1260660 ],
	[ 'MAUG',  'München-Untermenzing',       8004139, 11.4727920, 48.1776730 ],
	[ 'MWKR',  'München-Westkreuz',          8004163, 11.4439400, 48.1490260 ],
	[ 'FMHN',  'Münchhausen',                8004164, 8.71867100, 50.9641960 ],
	[ 'TMCG',  'Münchingen',                 8007325, 9.09621800, 48.8552360 ],
	[ 'TMCR',  'Münchingen Rührberg',       8070220, 9.09585300, 48.8497960 ],
	[ 'MMST',  'Münchsmünster',             8004165, 11.6874090, 48.7583420 ],
	[ 'SMUE',  'Münchweiler(Alsenz)',        8087062, 7.88793900, 49.5506060 ],
	[ 'SMR',   'Münchweiler(Rodalb)',        8004166, 7.70041700, 49.2213550 ],
	[ 'NMUE',  'Münnerstadt',                8004169, 10.1886340, 50.2500780 ],
	[ 'TMN',   'Münsingen',                  8070495, 9.49043200, 48.4096370 ],
	[ 'ENHF',  'Münster(W)Zentrum Nord',     8004173, 7.63847000, 51.9843200 ],
	[ 'EMST',  'Münster(Westf)Hbf',          8000263, 7.63571500, 51.9565660 ],
	[ 'EMSTP', 'Münster(Westf)Hbf',          8000263, 7.63571500, 51.9565660 ],
	[ 'FMTR',  'Münster(b Dieburg)',         8004171, 8.85388500, 49.9236780 ],
	[ 'EABT',  'Münster-Albachten',          8000462, 7.52819700, 51.9145760 ],
	[ 'EAML',  'Münster-Amelsbüren',        8000569, 7.59889700, 51.8836620 ],
	[ 'EHIT',  'Münster-Hiltrup',            8002841, 7.65428100, 51.9047550 ],
	[ 'ENBE',  'Münster-Häger',             8004426, 7.56234100, 52.0220620 ],
	[ 'EMSR',  'Münster-Roxel',              8004190, 7.52612600, 51.9464110 ],
	[ 'SMSA',  'Münster-Sarmsheim',          8004172, 7.89803300, 49.9473880 ],
	[ 'ESPR',  'Münster-Sprakel',            8005635, 7.61998200, 52.0415130 ],
	[ 'RUM',   'Münstertal(Schwarzwald)',    8007337, 7.78195100, 47.8549150 ],
	[ 'RMZH',  'Münzesheim',                 8007142, 8.71600700, 49.1260800 ],
	[ 'RMZO',  'Münzesheim Ost',             8007146, 8.72621500, 49.1214920 ],
	[ 'SMLB',  'Mürlenbach',                 8004174, 6.60154800, 50.1487820 ],
	[ 'AMUE',  'Müssen',                     8004177, 10.5611280, 53.4994640 ],
	[ 'NNAB',  'Nabburg',                     8004191, 12.1807010, 49.4471670 ],
	[ 'LNHM',  'Nachterstedt-Hoym',           8012410, 11.3330250, 51.8029080 ],
	[ 'FNAC',  'Nackenheim',                  8004193, 8.34188500, 49.9191060 ],
	[ 'TNA',   'Nagold',                      8004196, 8.72777400, 48.5556440 ],
	[ 'TNA M', 'Nagold Stadtmitte',           8004201, 8.72850200, 48.5512750 ],
	[ 'TNAI',  'Nagold-Iselshausen',          8004202, 8.72589000, 48.5315400 ],
	[ 'TNAS',  'Nagold-Steinberg',            8004195, 8.73264300, 48.5420150 ],
	[ 'NNIL',  'Naila',                       8004198, 11.7122000, 50.3296360 ],
	[ 'SNAB',  'Namborn',                     8004199, 7.14627700, 49.5239220 ],
	[ 'KNAM',  'Namedy',                      8004200, 7.36176800, 50.4571460 ],
	[ 'KNAMN', 'Namedy',                      8004200, 7.36176800, 50.4571460 ],
	[ 'LNA',   'Narsdorf',                    8010238, 12.7130230, 51.0091410 ],
	[ 'DNA',   'Nassau(Erzgeb)',              8012412, 13.4857660, 50.7696010 ],
	[ 'FNAS',  'Nassau(Lahn)',                8004206, 7.80069100, 50.3114800 ],
	[ 'MNBN',  'Nassenbeuren',                8004207, 10.5037970, 48.0780660 ],
	[ 'WNAS',  'Nassenheide',                 8012413, 13.2391980, 52.8169190 ],
	[ 'HNAH',  'Natrup-Hagen',                8004208, 7.91075200, 52.2098490 ],
	[ 'BNAU',  'Nauen',                       8010239, 12.8855590, 52.6126960 ],
	[ 'LNAU',  'Nauendorf(Saalkr)',           8012414, 11.8845030, 51.6085150 ],
	[ 'FNU',   'Nauheim(b Gr.Gerau)',         8004210, 8.44992900, 49.9421370 ],
	[ 'UNM',   'Naumburg(Saale)Hbf',          8010240, 11.7969840, 51.1630710 ],
	[ 'UNMO',  'Naumburg(Saale)Ost',          8012415, 11.8238950, 51.1555250 ],
	[ 'UNRO',  'Naumburg-Roßbach',           8012429, 11.7795300, 51.1706490 ],
	[ 'DNAO',  'Naundorf (b Oschatz)',        8070691, 13.1014720, 51.2597800 ],
	[ 'LNH',   'Naunhof',                     8012416, 12.5942420, 51.2770860 ],
	[ 'KNEA',  'Neanderthal',                 8004213, 6.95325000, 51.2278200 ],
	[ 'DNEB',  'Nebitzschen',                 8070698, 13.0157410, 51.2391870 ],
	[ 'UNE',   'Nebra',                       8012417, 11.5701260, 51.2834400 ],
	[ 'WNL',   'Nechlin',                     8012418, 13.9028800, 53.4409270 ],
	[ 'RNBH',  'Neckarbischofsheim Helmhof',  8007435, 8.99562100, 49.2783760 ],
	[ 'RNHF',  'Neckarbischofsheim Nord',     8077434, 8.94227400, 49.3070980 ],
	[ 'RNHS',  'Neckarbischofsheim Stadt',    8007434, 8.96368600, 49.2960350 ],
	[ 'RNB',   'Neckarburken',                8004215, 9.16372100, 49.3783830 ],
	[ 'RNM',   'Neckargemünd',               8000265, 8.78842500, 49.3936780 ],
	[ 'RNMA',  'Neckargemünd Altstadt',      8004217, 8.80295400, 49.3923910 ],
	[ 'RNA',   'Neckargerach',                8004216, 9.07470400, 49.3979060 ],
	[
		'RNH', 'Neckarhausen bei Neckarsteinach',
		8004218, 8.87970300, 49.4169540
	],
	[ 'RNT',   'Neckarsteinach',             8004219, 8.84142900, 49.4049090 ],
	[ 'TN',    'Neckarsulm',                 8004220, 9.22006800, 49.1889730 ],
	[ 'TN  A', 'Neckarsulm',                 8004220, 9.22006800, 49.1889730 ],
	[ 'TN  M', 'Neckarsulm Mitte',           8004232, 9.22294300, 49.1934100 ],
	[ 'TNSN',  'Neckarsulm Nord',            8004238, 9.22867900, 49.2020960 ],
	[ 'TN  S', 'Neckarsulm Süd',            8004226, 9.22074300, 49.1803280 ],
	[ 'RNEZ',  'Neckarzimmern',              8004222, 9.13757700, 49.3165630 ],
	[ 'SNF',   'Neef',                       8004223, 7.13941800, 50.0910530 ],
	[ 'ANEZ',  'Neetzendorf',                8004227, 10.7605760, 53.1637840 ],
	[ 'WNA',   'Neetzka',                    8012421, 13.5008380, 53.5335180 ],
	[ 'ENHH',  'Neheim-Hüsten',             8004228, 7.97006600, 51.4380030 ],
	[ 'TNEH',  'Nehren',                     8004229, 9.06688000, 48.4239540 ],
	[ 'RNFL',  'Neidenfels',                 8079146, 8.04523600, 49.3862010 ],
	[ 'RNST',  'Neidenstein',                8007441, 8.89015200, 49.3202370 ],
	[ 'LNI',   'Neinstedt',                  8012423, 11.0848930, 51.7523680 ],
	[ 'TNL',   'Nellmersbach',               8004233, 9.41540100, 48.9033680 ],
	[ 'KNEM',  'Nemmenich',                  8004234, 6.68146600, 50.6880510 ],
	[ 'LNDG',  'Nemsdorf-Göhrendorf',       8012424, 11.6592270, 51.3583810 ],
	[ 'TNED',  'Nendingen(b Tuttlingen)',    8004235, 8.85404800, 48.0095770 ],
	[ 'LNS',   'Nennhausen',                 8012425, 12.5027900, 52.5999100 ],
	[ 'SNE',   'Nennig',                     8004236, 6.37585100, 49.5387380 ],
	[ 'DNGM',  'Nennigmühle',               8012426, 13.2531680, 50.6910910 ],
	[ 'RNN',   'Nenzingen',                  8077772, 8.96472800, 47.8413480 ],
	[ 'MNSG',  'Nersingen',                  8004239, 10.1180030, 48.4301410 ],
	[ 'MNEW',  'Nesselwang',                 8004240, 10.5044190, 47.6239440 ],
	[ 'KNEH',  'Nettersheim',                8004242, 6.62937600, 50.4903980 ],
	[ 'WNED',  'Netzeband',                  8012428, 12.6281030, 52.9955560 ],
	[ 'LNKA',  'Netzkater',                  8017016, 10.7896130, 51.6024030 ],
	[ 'DNZU',  'Netzschkau',                 8012430, 12.2442750, 50.6114040 ],
	[ 'FNIS',  'Neu Isenburg',               8004246, 8.66560900, 50.0530520 ],
	[ 'FNIU',  'Neu Isenburg',               8004246, 8.66560900, 50.0530520 ],
	[ 'WNPG',  'Neu Pudagla',                8017349, 14.0651980, 54.0003360 ],
	[ 'ANSJ',  'Neu St Jürgen',             8007120, 8.95891900, 53.2554750 ],
	[ 'WNWO',  'Neu Wokern',                 8012436, 12.5009160, 53.7600330 ],
	[ 'ANWF',  'Neu Wulmstorf',              8004247, 9.78843200, 53.4730460 ],
	[ 'FNAP',  'Neu-Anspach',                8007850, 8.51473000, 50.3009620 ],
	[ 'RMF',   'Neu-Edingen/Friedrichsfeld', 8000631, 8.58012500, 49.4486700 ],
	[ 'MNM',   'Neu-Ulm',                    8006730, 10.0048230, 48.3930390 ],
	[ 'ENBM',  'Neubeckum',                  8004251, 8.02136000, 51.8019510 ],
	[ 'ENBMP', 'Neubeckum',                  8004251, 8.02136000, 51.8019510 ],
	[ 'MNB',   'Neubiberg',                  8004252, 11.6602220, 48.0758470 ],
	[ 'WN',    'Neubrandenburg',             8010241, 13.2614650, 53.5618310 ],
	[ 'SNBR',  'Neubrücke(Nahe)',           8004253, 7.17270100, 49.6060660 ],
	[ 'WNB',   'Neubukow',                   8012438, 11.6777630, 54.0307790 ],
	[ 'MNBD',  'Neuburg(Donau)',             8004254, 11.1783700, 48.7272180 ],
	[ 'MNBK',  'Neuburg(Kammel)',            8004256, 10.3655360, 48.3025570 ],
	[ 'RNBU',  'Neuburg(Rhein)',             8004257, 8.23821700, 48.9921290 ],
	[ 'NNAE',  'Neubäu',                    8004250, 12.4364740, 49.2398610 ],
	[ 'TND',   'Neudenau',                   8004258, 9.27082000, 49.2883670 ],
	[ 'UND',   'Neudietendorf',              8010242, 10.9096850, 50.9138980 ],
	[ 'DNDF',  'Neudorf(Erzgeb)',            8012442, 12.9740400, 50.4780300 ],
	[ 'HNPL',  'Neudorf-Platendorf',         8004260, 10.6075400, 52.5487020 ],
	[ 'UNS',   'Neue Schenke',               8012443, 11.6376300, 50.8753880 ],
	[ 'RNBG',  'Neuenburg(Baden)',           8089119, 7.56275600, 47.8114830 ],
	[ 'TNE',   'Neuenbürg(Enz)',            8004265, 8.60085700, 48.8491470 ],
	[ 'TNEE', 'Neuenbürg(Enz) Eyachbrücke', 8070278, 8.57787100, 48.8172000 ],
	[ 'TNEB', 'Neuenbürg(Enz) Freibad',      8070276, 8.59033000, 48.8369420 ],
	[ 'TNES', 'Neuenbürg(Enz) Süd',         8004264, 8.59886400, 48.8445720 ],
	[ 'NNDU', 'Neuendettelsau',               8004268, 10.7823720, 49.2826750 ],
	[ 'BNG',  'Neuenhagen(b Berlin)',         8081020, 13.7004940, 52.5204530 ],
	[ 'HNKO', 'Neuenkirchen(Oldb)',           8004271, 8.05957400, 52.5084340 ],
	[ 'NNE',  'Neuenmarkt-Wirsberg',          8000267, 11.5810610, 50.0936760 ],
	[ 'ENRA', 'Neuenrade',                    8004273, 7.79439000, 51.2847730 ],
	[ 'TNN',  'Neuenstein',                   8004276, 9.58545400, 49.2059450 ],
	[ 'MNFR', 'Neufahrn(Niederbay)',          8000688, 12.1904600, 48.7298840 ],
	[ 'MNF',  'Neufahrn(b Freising)',         8004279, 11.6612610, 48.3216360 ],
	[ 'TNEF', 'Neuffen',                      8007448, 9.37407900, 48.5585560 ],
	[ 'TNFH', 'Neufra(Hohenz)',               8007228, 9.18665300, 48.2460260 ],
	[ 'DNF',  'Neugersdorf',                  8012454, 14.6116350, 50.9866360 ],
	[ 'MNGH', 'Neugilching',                  8004249, 11.2886660, 48.0989660 ],
	[ 'UNHR', 'Neuhaus am Rennweg',           8087081, 11.1366910, 50.5065430 ],
	[ 'NNP',  'Neuhaus(Pegnitz)',             8004284, 11.5517090, 49.6266530 ],
	[ 'UNHI', 'Neuhaus-Igelshieb',            8012452, 11.1461070, 50.5010510 ],
	[ 'RNHN', 'Neuhausen Bad Bf',             8004289, 8.61218600, 47.6826150 ],
	[ 'BNH',  'Neuhausen(Cottbus)',           8012456, 14.4126600, 51.6870300 ],
	[ 'MNHL', 'Neuhausen(b Landshut)',        8026358, 11.9960390, 48.6187640 ],
	[ 'FNF',  'Neuhof(Kr Fulda)',             8004295, 9.62022400, 50.4548180 ],
	[ 'BNE',  'Neuhof(b Zossen)',             8012458, 13.4795820, 52.1396740 ],
	[ 'LNK',  'Neukieritzsch',                8010243, 12.4128360, 51.1507740 ],
	[ 'DNKO', 'Neukirch(Lausitz)Ost',         8012460, 14.3220470, 51.0907500 ],
	[ 'DNKW', 'Neukirch(Lausitz)West',        8010400, 14.2699770, 51.0843440 ],
	[ 'MNK',  'Neukirchen(Inn)',              8004298, 13.3701030, 48.5176790 ],
	[ 'NNS',  'Neukirchen(b Sulzb)',          8000269, 11.6195400, 49.5243260 ],
	[ 'DNK',  'Neukirchen-Klaffenbach',       8012462, 12.8936040, 50.7710310 ],
	[ 'LNWY', 'Neukirchen-Wyhra',             8012463, 12.5335360, 51.0878460 ],
	[ 'ANL',  'Neukloster(Kr Stade)',         8004302, 9.63972100, 53.4812570 ],
	[ 'RNL',  'Neulußheim',                  8004304, 8.53007500, 49.2921990 ],
	[ 'DNM',  'Neumark(Sachs)',               8010244, 12.3528280, 50.6601710 ],
	[ 'NNT',  'Neumarkt(Oberpf)',             8004305, 11.4569870, 49.2732210 ],
	[ 'MNR',  'Neumarkt-St Veit',             8000720, 12.5030750, 48.3613180 ],
	[ 'UNME', 'Neumühle(Elster)',            8012465, 12.1703310, 50.7022230 ],
	[ 'AN',   'Neumünster',                  8000271, 9.97981600, 54.0757520 ],
	[ 'ANSW', 'Neumünster Stadtwald',        8007790, 9.96286300, 54.0834300 ],
	[ 'ANM',  'Neumünster Süd AKN',         8007062, 9.98304200, 54.0598150 ],
	[ 'LN',   'Neundorf(Anh)',                8012467, 11.5937600, 51.8246980 ],
	[ 'UNH',  'Neunhofen',                    8012468, 11.7144400, 50.7243450 ],
	[ 'RNK',  'Neunkirch',                    8004308, 8.49538400, 47.6891510 ],
	[ 'NNKS', 'Neunkirchen a Sand',           8004310, 11.3220500, 49.5204050 ],
	[ 'ENK',  'Neunkirchen(Kr Siegen)',       8004313, 8.00610100, 50.7847010 ],
	[
		'SNKW',  'Neunkirchen(Saar)-Wellesweiler',
		8004312, 7.22678700,
		49.3495600
	],
	[ 'SNK',   'Neunkirchen(Saar)Hbf',       8000272, 7.17665500, 49.3532910 ],
	[ 'DNOE',  'Neuoelsnitz',                8010245, 12.7234370, 50.7195140 ],
	[ 'BNP',   'Neupetershain',              8012469, 14.1617030, 51.6063240 ],
	[ 'WNRR',  'Neuruppin Rheinsberger Tor', 8010175, 12.8107990, 52.9295700 ],
	[ 'WNR',   'Neuruppin West',             8010246, 12.7938880, 52.9262440 ],
	[ 'WNRW',  'Neuruppin West',             8010246, 12.7938880, 52.9262440 ],
	[ 'DNP',   'Neusalza-Spremberg',         8012470, 14.5262470, 51.0342510 ],
	[ 'NNEU',  'Neuses(b Kronach)',          8004319, 11.3068430, 50.2171530 ],
	[ 'NNSG',  'Neusorg',                    8004321, 11.9719870, 49.9338440 ],
	[ 'KNAL',  'Neuss Allerheiligen',        8004335, 6.75679300, 51.1424660 ],
	[ 'KNAK',  'Neuss Am Kaiser',            8004320, 6.69752900, 51.2203520 ],
	[ 'KN',    'Neuss Hbf',                  8000274, 6.68452700, 51.2043510 ],
	[ 'KN  O', 'Neuss Hbf',                  8000274, 6.68452700, 51.2043510 ],
	[ 'KN  W', 'Neuss Hbf',                  8000274, 6.68452700, 51.2043510 ],
	[ 'KNRC',  'Neuss Rheinparkcenter',      8004316, 6.71715300, 51.2061750 ],
	[ 'KNSD',  'Neuss Süd',                 8004317, 6.69029000, 51.1857840 ],
	[ 'HNRU',  'Neustadt am Rübenberge',    8004322, 9.45527700, 52.5033250 ],
	[ 'NNA',   'Neustadt(Aisch)Bahnhof',     8004323, 10.5880320, 49.5768760 ],
	[ 'NNAM',  'Neustadt(Aisch)Mitte',       8004336, 10.6093060, 49.5742020 ],
	[ 'MND',   'Neustadt(Donau)',            8004326, 11.7632970, 48.8001850 ],
	[ 'WNS',   'Neustadt(Dosse)',            8010248, 12.4506670, 52.8526770 ],
	[ 'ANT',   'Neustadt(Holst)',            8004327, 10.8084900, 54.1040020 ],
	[ 'ANN',   'Neustadt(Holst)Gbf',         8099507, 10.7954310, 54.0962280 ],
	[ 'FNSM',  'Neustadt(Kr Marburg)',       8004328, 9.12064300, 50.8504470 ],
	[ 'UNU',   'Neustadt(Orla)',             8012472, 11.7576210, 50.7347900 ],
	[ 'DNE',   'Neustadt(Sachs)',            8010249, 14.2132190, 51.0213380 ],
	[ 'RNSS',  'Neustadt(Schwarzw)',         8004331, 8.21088300, 47.9101980 ],
	[ 'NNW',   'Neustadt(Waldnaab)',         8004332, 12.1683370, 49.7259180 ],
	[ 'RND',   'Neustadt(Weinstr) Süd',     8004306, 8.15706100, 49.3415530 ],
	[ 'RN',    'Neustadt(Weinstr)Hbf',       8000275, 8.14075700, 49.3495530 ],
	[ 'NNU',   'Neustadt(b Coburg)',         8004325, 11.1213910, 50.3328130 ],
	[ 'RNBO',  'Neustadt-Böbig',            8004489, 8.15831300, 49.3542450 ],
	[ 'WNG',   'Neustadt-Glewe',             8012474, 11.5937790, 53.3776400 ],
	[ 'TNHO',  'Neustadt-Hohenacker',        8004333, 9.32471500, 48.8593120 ],
	[ 'NNSP',  'Neustift(b Passau)',         8084074, 13.3944150, 48.5668150 ],
	[ 'WNT',   'Neustrelitz Hbf',            8010250, 13.0746030, 53.3592550 ],
	[ 'MNES',  'Neusäß',                   8004318, 10.8335200, 48.3943920 ],
	[ 'DNZ',   'Neusörnewitz',              8012471, 13.5527670, 51.1475530 ],
	[ 'BNTB',  'Neutrebbin',                 8012475, 14.2370360, 52.6763270 ],
	[ 'KNE',   'Neuwied',                    8000276, 7.47313200, 50.4314660 ],
	[ 'TNW',   'Neuwirtshaus(Porscheplatz)', 8004338, 9.15250500, 48.8338240 ],
	[ 'BNZ',   'Neuzelle',                   8012479, 14.6488660, 52.0987970 ],
	[ 'MNN',   'Neuötting',                 8004315, 12.6904320, 48.2611580 ],
	[ 'FND',   'Nidda',                      8000277, 8.99888100, 50.4114490 ],
	[ 'FHWD',  'Nidderau',                   8000158, 8.88023300, 50.2308260 ],
	[ 'FHWR',  'Nidderau',                   8000158, 8.88023300, 50.2308260 ],
	[ 'FECH',  'Nidderau-Eichen',            8001701, 8.91749100, 50.2559470 ],
	[ 'FWIN',  'Nidderau-Windecken',         8006465, 8.87606900, 50.2250560 ],
	[ 'KNID',  'Nideggen-Brück',            8007825, 6.46578000, 50.6897540 ],
	[ 'ANB',   'Niebüll',                   8004343, 8.83457200, 54.7896050 ],
	[ 'ANBN',  'Niebüll neg',               8074343, 8.83295900, 54.7895500 ],
	[ 'ANB A', 'Niebüll, Sylt Shuttle',     8085311, 8.83578600, 54.7845600 ],
	[ 'SNID',  'Niedaltdorf',                8004344, 6.59405300, 49.3435390 ],
	[ 'FNFD',  'Nieder Flörsheim-Dalsheim', 8004345, 8.20427400, 49.6569010 ],
	[ 'FNO',   'Nieder Ohmen',               8004348, 9.03413200, 50.6453790 ],
	[ 'FNOL',  'Nieder Olm',                 8004349, 8.20496000, 49.9055290 ],
	[ 'FNRW',  'Nieder Wöllstadt',          8004353, 8.76735700, 50.2802910 ],
	[ 'DNDR',  'Niederau',                   8012482, 13.5604740, 51.1763330 ],
	[ 'KTUM',  'Niederau-Tuchmühle',        8007834, 6.48800900, 50.7640710 ],
	[ 'TNB',   'Niederbiegen',               8004363, 9.62095800, 47.8306260 ],
	[ 'DNBO',  'Niederbobritzsch',           8012483, 13.4406370, 50.9013890 ],
	[ 'FNCH',  'Niederbrechen',              8004364, 8.15985600, 50.3595980 ],
	[ 'KND',   'Niederdollendorf',           8004366, 7.18097700, 50.6950780 ],
	[ 'DNIE',  'Niederdorf(Erzgeb)',         8013459, 12.7823410, 50.7283080 ],
	[ 'FNIE',  'Niederdorfelden',            8004367, 8.80903400, 50.1931660 ],
	[ 'ENDR',  'Niederdreisbach',            8007079, 7.92251100, 50.7555160 ],
	[ 'ENID',  'Niederdresselndorf',         8004369, 8.13639400, 50.7212120 ],
	[ 'FNIB',  'Niedererbach',               8004373, 7.97687000, 50.4250750 ],
	[ 'WNW',   'Niederfinow',                8012485, 13.9289480, 52.8306680 ],
	[ 'LNF',   'Niedergörsdorf',            8012487, 12.9789310, 51.9679300 ],
	[ 'FNHD',  'Niederhadamar',              8004376, 8.03706900, 50.4327600 ],
	[ 'FNDH',  'Niederheimbach',             8004379, 7.80550500, 50.0360130 ],
	[ 'FNH',   'Niederhöchstadt',           8004380, 8.54723700, 50.1541980 ],
	[ 'ENDV',  'Niederhövels',              8004381, 7.78852500, 50.7862910 ],
	[ 'FNJ',   'Niederjosbach',              8004382, 8.35101700, 50.1498070 ],
	[ 'KNL',   'Niederlahnstein',            8000278, 7.59950300, 50.3163900 ],
	[ 'BNDL',  'Niederlehme',                8012489, 13.6525260, 52.3019760 ],
	[ 'MNLH',  'Niederlindhart',             8004391, 12.2378460, 48.7625120 ],
	[ 'SNDL',  'Niederlinxweiler',           8004392, 7.16069500, 49.4322010 ],
	[ 'FNMI',  'Niedermittlau',              8004395, 9.10926400, 50.1786090 ],
	[ 'SNDM',  'Niedermohr',                 8004396, 7.47158800, 49.4584290 ],
	[ 'LNR',   'Niederndodeleben',           8012490, 11.5026630, 52.1299760 ],
	[ 'FNSD',  'Niedernhausen(Taunus)',      8004400, 8.31287900, 50.1596970 ],
	[ 'DNOW',  'Niederoderwitz',             8012491, 14.7244140, 50.9523000 ],
	[ 'UNP',   'Niederpöllnitz',            8012493, 11.9570800, 50.7663600 ],
	[ 'MNRU',  'Niederraunau',               8004401, 10.3745030, 48.2213440 ],
	[ 'MNRO',  'Niederroth',                 8004404, 11.3900410, 48.3209350 ],
	[ 'UNIW',  'Niedersachswerfen',          8012494, 10.7638900, 51.5450670 ],
	[
		'LNDH', 'Niedersachswerfen Herkulesmarkt',
		8080992, 10.7685530, 51.5421650
	],
	[
		'LNDI', 'Niedersachswerfen Ilfelder Straße',
		8080991, 10.7698980, 51.5606740
	],
	[ 'LNDS',  'Niedersachswerfen Ost',    8017017, 10.7687310, 51.5494390 ],
	[ 'FNDS',  'Niederscheld(Dillkr)Süd', 8004405, 8.30330000, 50.7177310 ],
	[ 'ENDN',  'Niederschelden',           8004406, 7.96550900, 50.8392480 ],
	[ 'ENDO',  'Niederschelden Nord',      8004407, 7.97065700, 50.8441870 ],
	[ 'DNSL',  'Niederschlag',             8012496, 13.0144180, 50.4639640 ],
	[ 'DNDS',  'Niederschlottwitz',        8012497, 13.8109790, 50.8895780 ],
	[ 'UNSK',  'Niederschmalkalden',       8012498, 10.3759070, 50.7167240 ],
	[ 'FNS',   'Niederselters',            8004409, 8.23008400, 50.3326760 ],
	[ 'UNI',   'Niederspier',              8012500, 10.8482310, 51.2901030 ],
	[ 'FNIH',  'Niedersteinbach',          8007278, 9.14856200, 50.0865960 ],
	[ 'TNI',   'Niederstetten',            8004412, 9.91507900, 49.4035730 ],
	[ 'TNS',   'Niederstotzingen',         8004413, 10.2364600, 48.5326040 ],
	[ 'UNTA',  'Niedertrebra',             8012502, 11.5792460, 51.0643430 ],
	[ 'FNL',   'Niederwalgern',            8004417, 8.70837900, 50.7365980 ],
	[ 'FNWF',  'Niederwalluf',             8004418, 8.15915800, 50.0366500 ],
	[ 'DNI',   'Niederwartha',             8012503, 13.6059220, 51.0946320 ],
	[ 'FNDW',  'Niederweimar',             8004420, 8.73366500, 50.7567710 ],
	[ 'DNR',   'Niederwiesa',              8010253, 13.0228520, 50.8626160 ],
	[ 'UNWL',  'Niederwillingen',          8012504, 11.0387090, 50.7754570 ],
	[ 'RNID',  'Niederwinden',             8004423, 8.02296000, 48.1397800 ],
	[ 'DNWZ',  'Niederwürschnitz',        8012505, 12.7541060, 50.7182240 ],
	[ 'FNIZ',  'Niederzeuzheim',           8004424, 8.03968700, 50.4682250 ],
	[ 'KNZS',  'Niederzissen',             8070501, 7.22319700, 50.4612250 ],
	[ 'DNZW',  'Niederzwönitz',           8012499, 12.8221300, 50.6461910 ],
	[ 'TNF',   'Niefern',                  8004425, 8.76975500, 48.9202810 ],
	[ 'LNM',   'Niemberg',                 8012506, 12.0998690, 51.5520620 ],
	[ 'LNB',   'Nienburg(Saale)',          8012507, 11.7615330, 51.8379510 ],
	[ 'HNBG',  'Nienburg(Weser)',          8000279, 9.21775300, 52.6455660 ],
	[ 'LNHG',  'Nienhagen(Halberst)',      8010254, 11.1700560, 51.9512040 ],
	[ 'FNIR',  'Nierstein',                8004432, 8.34281000, 49.8720020 ],
	[ 'KNIK',  'Nieukerk',                 8004433, 6.37558600, 51.4580810 ],
	[ 'KNIV',  'Nievenheim',               8004434, 6.78211700, 51.1237170 ],
	[ 'FNIV',  'Nievern',                  8004435, 7.68187600, 50.3373850 ],
	[ 'TNK',   'Niklashausen',             8004437, 9.61391600, 49.7016990 ],
	[ 'RNIM',  'Nimburg(Baden)',           8007294, 7.76007900, 48.1055340 ],
	[ 'FERW',  'Nistertal-Bad Marienberg', 8001819, 7.90058000, 50.6321140 ],
	[ 'SNI',   'Nittel',                   8004438, 6.44094200, 49.6542640 ],
	[ 'SNON',  'Nohen',                    8004444, 7.24208500, 49.6396480 ],
	[ 'SNO',   'Nohfelden',                8079083, 7.13944300, 49.5856880 ],
	[ 'UNOH',  'Nohra(Weimar)',            8012511, 11.2673040, 50.9692220 ],
	[ 'UNA',   'Nohra(Wipper)',            8012512, 10.6984780, 51.4430370 ],
	[ 'MNHN',  'Nonnenhorn',               8004446, 9.61267600, 47.5751180 ],
	[ 'ENOB',  'Nordbögge',               8004448, 7.74220000, 51.6157090 ],
	[ 'HND',   'Norddeich',                8004449, 7.16082400, 53.6215790 ],
	[ 'HNDM',  'Norddeich Mole',           8007768, 7.15880600, 53.6243150 ],
	[ 'HNN',   'Norden',                   8000800, 7.21891300, 53.5881960 ],
	[ 'MNOD',  'Nordendorf',               8004451, 10.8373060, 48.5934340 ],
	[ 'HNO',   'Nordenham',                8004452, 8.48739200, 53.4838110 ],
	[ 'ANDM',  'Norderstedt Mitte',        8079027, 9.99237800, 53.7076870 ],
	[ 'NNOH',  'Nordhalben Bf',            8004455, 11.5178380, 50.3683590 ],
	[ 'ANH',   'Nordhastedt',              8004456, 9.18351500, 54.1683830 ],
	[ 'UN',    'Nordhausen',               8010256, 10.7892490, 51.4929200 ],
	[ 'LNHNB', 'Nordhausen Bahnhofsplatz', 8070777, 10.7893180, 51.4939540 ],
	[
		'LNHH',  'Nordhausen Hesseröder Straße',
		8070732, 10.7772040,
		51.5019620
	],
	[ 'LNHN', 'Nordhausen Nord', 8017020, 10.7884090, 51.4939320 ],
	[
		'LNHR', 'Nordhausen Ricarda-Huch-Straße',
		8070733, 10.7807080, 51.5147010
	],
	[ 'LNHKS', 'Nordhausen Schurzfell',    8070902, 10.7768520, 51.5216670 ],
	[ 'LNHA',  'Nordhausen-Altentor',      8017018, 10.7789520, 51.5080430 ],
	[ 'LNHK',  'Nordhausen-Krimderode',    8017019, 10.7739860, 51.5292570 ],
	[ 'UNSA',  'Nordhausen-Salza',         8012516, 10.7731400, 51.5151110 ],
	[ 'TNO',   'Nordheim(Württ)',         8004458, 9.14881100, 49.1093840 ],
	[ 'ANZ',   'Nordholz',                 8004460, 8.62137000, 53.7787430 ],
	[ 'ANDS',  'Nordsode',                 8007116, 8.98028800, 53.3328370 ],
	[ 'HNOS',  'Nordstemmen',              8000282, 9.78888100, 52.1663940 ],
	[ 'ENOW',  'Nordwalde',                8004461, 7.46164100, 52.0773920 ],
	[ 'KNO',   'Norf',                     8004462, 6.73164500, 51.1604120 ],
	[ 'SNOR',  'Norheim',                  8004463, 7.81229100, 49.8088070 ],
	[ 'RNO',   'Norsingen',                8004464, 7.72619600, 47.9392500 ],
	[ 'HN',    'Northeim(Han)',            8000283, 9.98661800, 51.7031390 ],
	[ 'ANF',   'Nortorf',                  8004466, 9.85258500, 54.1666300 ],
	[ 'WNOS',  'Nossentin',                8012517, 12.4521770, 53.5215940 ],
	[ 'EAPH',  'Nottuln-Appelhülsen',     8000595, 7.42633400, 51.8921390 ],
	[ 'TNUF',  'Nufringen',                8004490, 8.88979600, 48.6202780 ],
	[ 'NNBS',  'Nußberg-Schönau',        8070668, 12.9650090, 49.0706820 ],
	[ 'DNB',   'Nöbdenitz',               8012509, 12.2806570, 50.8789060 ],
	[ 'MNL',   'Nördlingen',              8000280, 10.4978630, 48.8508410 ],
	[ 'HNTH',  'Nörten-Hardenberg',       8004441, 9.93309600, 51.6281840 ],
	[ 'DNUN',  'Nünchritz',               8012523, 13.3919700, 51.3026490 ],
	[ 'NSTD',  'Nürnberg Frankenstadion', 8004493, 11.1300440, 49.4307950 ],
	[
		'NND', 'Nürnberg Frankenstadion Sonderbahnsteig',
		8098493, 11.1274790, 49.4317610
	],
	[ 'NN',    'Nürnberg Hbf',               8000284, 11.0829890, 49.4456160 ],
	[ 'NNRO',  'Nürnberg Nordost',           8004469, 11.1061150, 49.4739750 ],
	[ 'NNO',   'Nürnberg Ost',               8004471, 11.1208850, 49.4638110 ],
	[ 'NNOS',  'Nürnberg Ostring',           8004470, 11.1199350, 49.4541290 ],
	[ 'NNRS',  'Nürnberg Rothenburger Str.', 8004473, 11.0553380, 49.4454000 ],
	[ 'NDTH',  'Nürnberg-Dutzendteich',      8004476, 11.1173780, 49.4370700 ],
	[ 'NDHF',  'Nürnberg-Dürrenhof',        8004442, 11.0975300, 49.4480390 ],
	[ 'NNES',  'Nürnberg-Eibach',            8004477, 11.0480580, 49.4098000 ],
	[ 'NNER',  'Nürnberg-Erlenstegen',       8004478, 11.1372930, 49.4720610 ],
	[ 'NGLH',  'Nürnberg-Gleißhammer',      8005304, 11.1112840, 49.4444370 ],
	[ 'NNLH',  'Nürnberg-Laufamholz',        8004480, 11.1684770, 49.4629480 ],
	[ 'NNMO',  'Nürnberg-Mögeldorf',        8004481, 11.1338660, 49.4592130 ],
	[ 'NNRH',  'Nürnberg-Rehhof',            8004491, 11.1547540, 49.4626250 ],
	[ 'NNRE',  'Nürnberg-Reichelsdorf',      8004483, 11.0384930, 49.3821510 ],
	[ 'NNRF',  'Nürnberg-Reichelsdorf',      8004483, 11.0384930, 49.3821510 ],
	[ 'NNSR',  'Nürnberg-Sandreuth',         8004484, 11.0546500, 49.4295850 ],
	[ 'NNSW',  'Nürnberg-Schweinau',         8004485, 11.0454030, 49.4343770 ],
	[ 'NNST',  'Nürnberg-Stein',             8004486, 11.0181710, 49.4255520 ],
	[ 'NNSE',  'Nürnberg-Steinbühl',        8004487, 11.0682000, 49.4428360 ],
	[ 'NNSN',  'Nürnberg-Steinbühl',        8004487, 11.0682000, 49.4428360 ],
	[ 'TNU',   'Nürtingen',                  8004488, 9.34264800, 48.6279970 ],
	[ 'TNU R', 'Nürtingen-Roßdorf',         8090021, 9.34571300, 48.6085730 ],
	[ 'TNUV',  'Nürtingen-Vorstadt',         8090020, 9.34007200, 48.6203340 ],
	[ 'ANTZ',  'Nützen',                     8007055, 9.91674900, 53.8636630 ],
	[ 'FORA',  'Ober Ramstadt',               8004497, 8.74337000, 49.8320290 ],
	[ 'FOW',   'Ober Widdersheim',            8004499, 8.93383600, 50.4295110 ],
	[ 'ROA',   'Oberachern',                  8007002, 8.07918500, 48.6140500 ],
	[ 'ROAB',  'Oberachern Bindfadenfabrik',  8007003, 8.09326800, 48.6034640 ],
	[ 'TOAI',  'Oberaichen',                  8004496, 9.12733500, 48.7051930 ],
	[ 'MOA',   'Oberammergau',                8004503, 11.0570780, 47.5995450 ],
	[ 'NOA',   'Oberasbach',                  8004504, 10.9642470, 49.4166810 ],
	[ 'MOU',   'Oberau',                      8004506, 11.1392720, 47.5592730 ],
	[ 'MOD',   'Oberaudorf',                  8004507, 12.1752620, 47.6527900 ],
	[ 'SOH',   'Oberbettingen-Hillesheim',    8004513, 6.63833700, 50.2829290 ],
	[ 'SOG',   'Oberbillig',                  8004514, 6.51163400, 49.7101620 ],
	[ 'FOBA',  'Oberbimbach',                 8004515, 9.56372600, 50.5790180 ],
	[ 'TOBB',  'Oberboihingen',               8004517, 9.36413500, 48.6479280 ],
	[ 'FOB',   'Oberbrechen',                 8004518, 8.18780100, 50.3544980 ],
	[ 'NON',   'Oberdachstetten',             8004521, 10.4219480, 49.4185210 ],
	[
		'ROBE', 'Oberderdingen-Flehingen Industrie',
		8079078, 8.77500700, 49.0839680
	],
	[ 'TOLC',  'Oberelchingen',             8004525, 10.0830240, 48.4475730 ],
	[ 'FOSN',  'Oberelsungen',              8004526, 9.25092900, 51.3763230 ],
	[ 'KOE',   'Obererbach',                8004527, 7.65939300, 50.7199110 ],
	[ 'TOES',  'Oberesslingen',             8004528, 9.32726700, 48.7298760 ],
	[ 'NOB',   'Oberferrieden',             8004529, 11.3334290, 49.3314770 ],
	[ 'ROGI',  'Obergimpern',               8007437, 9.04401900, 49.2554040 ],
	[ 'MOGS',  'Obergries',                 8004531, 11.5635330, 47.7075370 ],
	[ 'MOGB',  'Obergriesbach',             8004532, 11.0797600, 48.4219260 ],
	[ 'UOGR',  'Obergrunstedt',             8012524, 11.2707460, 50.9555950 ],
	[ 'NOH',   'Oberhaid',                  8004533, 10.8176370, 49.9294680 ],
	[ 'ROHD',  'Oberharmersbach Dorf',      8007105, 8.12440700, 48.3733080 ],
	[ 'ROHR',  'Oberharmersbach-Riersbach', 8007106, 8.14051200, 48.3807890 ],
	[ 'EOB',   'Oberhausen Hbf',            8000286, 6.85158800, 51.4748780 ],
	[ 'EOHT',  'Oberhausen-Holten',         8004540, 6.81045500, 51.5345740 ],
	[ 'EOS',   'Oberhausen-Osterfeld Süd', 8004541, 6.88513400, 51.4998890 ],
	[ 'EOS P', 'Oberhausen-Osterfeld Süd', 8004541, 6.88513400, 51.4998890 ],
	[ 'EOSD',  'Oberhausen-Sterkrade',      8004542, 6.84354300, 51.5120860 ],
	[ 'UOF',   'Oberhof(Thür)',            8012525, 10.7094050, 50.6842130 ],
	[ 'LOH',   'Oberholz',                  8012526, 12.5064220, 51.2577960 ],
	[ 'ROB',   'Oberkirch',                 8004545, 8.07689000, 48.5290310 ],
	[ 'ROBK',  'Oberkirch-Köhlersiedlung', 8004546, 8.08943700, 48.5248450 ],
	[ 'TON',   'Oberkochen',                8004549, 10.1076540, 48.7823590 ],
	[ 'NOKP',  'Oberkotzau',                8000287, 11.9322040, 50.2663890 ],
	[ 'ROK',   'Oberkrozingen',             8007331, 7.71588400, 47.9105410 ],
	[ 'KOL',   'Oberlahnstein',             8004550, 7.60396400, 50.2999260 ],
	[ 'UOLA',  'Oberlauscha',               8012527, 11.1562650, 50.4849530 ],
	[ 'TOL',   'Oberlenningen',             8004553, 9.47077400, 48.5543850 ],
	[ 'DOBL',  'Oberlichtenau',             8012528, 12.9592760, 50.9079140 ],
	[ 'MOLH',  'Oberlindhart',              8004554, 12.2179080, 48.7554090 ],
	[ 'SOW',   'Oberlinxweiler',            8004555, 7.15111600, 49.4507070 ],
	[ 'KOM',   'Obermaubach',               8007823, 6.44696700, 50.7139860 ],
	[ 'SOBM',  'Obermohr',                  8004557, 7.50141200, 49.4562530 ],
	[ 'NOBN',  'Obernau',                   8004558, 9.13608800, 49.9345370 ],
	[ 'NOE',   'Obernburg-Elsenfeld',       8004560, 9.15422200, 49.8407380 ],
	[ 'TOB',   'Oberndorf(Neckar)',         8004563, 8.57551400, 48.2956690 ],
	[ 'EOBW',  'Oberndorf(Wittgenstein)',   8004564, 8.30016700, 50.9522390 ],
	[ 'FOBH',  'Obernhof(Lahn)',            8004567, 7.85300100, 50.3158880 ],
	[ 'DOZ',   'Oberoderwitz',              8010259, 14.7085690, 50.9660280 ],
	[ 'DOZO',  'Oberoderwitz Oberdorf',     8012530, 14.6787180, 50.9738310 ],
	[ 'MOMN',  'Oberottmarshausen',         8004571, 10.8518340, 48.2358680 ],
	[ 'UORO',  'Oberrohn',                  8012533, 10.2141080, 50.8498610 ],
	[ 'DOH',   'Oberrothenbach',            8012534, 12.4757760, 50.7638830 ],
	[ 'ROBL',  'Oberrotweil',               8007290, 7.62089900, 48.0898420 ],
	[ 'UOR',   'Oberröblingen',            8012532, 11.2970690, 51.4411360 ],
	[ 'ROSC',  'Oberschefflenz',            8004577, 9.27885000, 49.4169250 ],
	[ 'MOSM',  'Oberschleißheim',          8004580, 11.5578300, 48.2572260 ],
	[ 'DOSC',  'Oberschlottwitz',           8012535, 13.8144930, 50.8705500 ],
	[ 'BOB',   'Obersdorf',                 8012537, 14.1678620, 52.5369660 ],
	[ 'NOBS',  'Obersinn',                  8004583, 9.61779800, 50.2090190 ],
	[ 'MOSF',  'Oberstaufen',               8004584, 10.0252850, 47.5542060 ],
	[ 'MOF',   'Oberstdorf',                8004585, 10.2780970, 47.4110320 ],
	[ 'NOT',   'Obertraubling',             8004592, 12.1699960, 48.9675370 ],
	[ 'FOTS',  'Obertshausen(Kr Of)',       8004593, 8.85341700, 50.0722260 ],
	[ 'ROT',   'Obertsrot',                 8004594, 8.34753000, 48.7458060 ],
	[ 'FOU',   'Oberursel(Taunus)',         8004596, 8.58940900, 50.1994230 ],
	[ 'FOUS',  'Oberursel-Stierstadt',      8087064, 8.58469400, 50.1856880 ],
	[
		'FWN', 'OberurselWeißkirchen/Steinbach',
		8006304, 8.58691800, 50.1732460
	],
	[ 'DOG',   'Obervogelgesang',             8012540, 13.9899190, 50.9497970 ],
	[ 'UOB',   'Oberweimar',                  8012541, 11.3545180, 50.9663060 ],
	[ 'UOW',   'Oberweißbach-Deesbach',      8012542, 11.1355210, 50.5792390 ],
	[ 'NOBW',  'Oberwerrn',                   8004453, 10.1538040, 50.0703420 ],
	[ 'FOBW',  'Oberwesel',                   8004601, 7.73154200, 50.1044600 ],
	[ 'ROD',   'Oberwinden',                  8004603, 8.04458300, 48.1525290 ],
	[ 'KOWI',  'Oberwinter',                  8004604, 7.20769600, 50.6113560 ],
	[ 'TOBZ',  'Oberzell',                    8004605, 9.57447500, 47.7517270 ],
	[ 'KOZS',  'Oberzissen',                  8070507, 7.20021600, 50.4550670 ],
	[ 'ROOE',  'Oberöwisheim',               8007141, 8.68623200, 49.1400600 ],
	[ 'MOBG',  'Obing',                       8070803, 12.4031560, 47.9987790 ],
	[ 'UOFM',  'Obstfelderschmiede',          8010260, 11.1337840, 50.6036220 ],
	[ 'NOK',   'Ochenbruck',                  8004609, 11.2538310, 49.3628390 ],
	[ 'NOF',   'Ochsenfurt',                  8000818, 10.0717760, 49.6630430 ],
	[ 'TOC',   'Ochsenhausen',                8079093, 9.94736700, 48.0710690 ],
	[ 'LOL',   'Ochtmersleben',               8012546, 11.3811050, 52.1444420 ],
	[ 'EOP',   'Ochtrup',                     8004613, 7.18403600, 52.2016160 ],
	[ 'FOCK',  'Ockenheim',                   8004614, 7.96544100, 49.9505520 ],
	[ 'RODH',  'Odenheim Bf',                 8007138, 8.74638800, 49.1790200 ],
	[ 'RODW',  'Odenheim West',               8070099, 8.73649200, 49.1822720 ],
	[ 'BOD',   'Oderin',                      8012549, 13.7269230, 52.0749160 ],
	[ 'LOE',   'Oebisfelde',                  8010261, 10.9838520, 52.4392750 ],
	[ 'DOR',   'Oederan',                     8012550, 13.1751490, 50.8572840 ],
	[ 'BOEG',  'Oegeln',                      8012551, 14.2707230, 52.1727830 ],
	[ 'LOEH',  'Oehna',                       8012552, 13.0482010, 51.9330500 ],
	[ 'EOEL',  'Oelde',                       8004626, 8.14259900, 51.8291120 ],
	[ 'DOE B', 'Oelsnitz Bahnhofstraße',     8017408, 12.6981350, 50.7275240 ],
	[ 'DOE',   'Oelsnitz(Erzgeb)',            8012553, 12.6939330, 50.7341780 ],
	[ 'DOV',   'Oelsnitz(Vogtl)',             8012554, 12.1590000, 50.4132300 ],
	[ 'AOE',   'Oerel',                       8007810, 9.03247000, 53.4941560 ],
	[ 'NOER',  'Oerlenbach',                  8004629, 10.1309210, 50.1432780 ],
	[ 'EOER',  'Oerlinghausen',               8004630, 8.66601600, 51.9787740 ],
	[ 'WOE',   'Oertzenhof',                  8012555, 13.5731190, 53.5180830 ],
	[ 'HOES',  'Oesede',                      8004628, 8.06431700, 52.2087290 ],
	[ 'FOE',   'Oestrich-Winkel',             8004635, 8.01890000, 50.0026590 ],
	[ 'MOET',  'Oettingen(Bay)',              8070508, 10.6001220, 48.9450500 ],
	[ 'EOVP',  'Oeventrop',                   8004642, 8.13208100, 51.3920200 ],
	[ 'ROU',   'Offenau',                     8004643, 9.16529300, 49.2464140 ],
	[ 'FOKL',  'Offenbach(Main) Kaiserlei',   8070092, 8.73837700, 50.1053320 ],
	[ 'FOLM',  'Offenbach(Main) Ledermuseum', 8070091, 8.75048500, 50.1059890 ],
	[ 'FOMP',  'Offenbach(Main) Marktplatz',  8070090, 8.76363300, 50.1058550 ],
	[ 'FO',    'Offenbach(Main)Hbf',          8000349, 8.76074300, 50.0992640 ],
	[ 'FOO',   'Offenbach(Main)Ost',          8004645, 8.78437500, 50.1027650 ],
	[ 'FOBI',  'Offenbach-Bieber',            8004647, 8.80836700, 50.0905470 ],
	[ 'FOWH',  'Offenbach-Waldhof',           8004640, 8.82893800, 50.0816910 ],
	[ 'RO',    'Offenburg',                   8000290, 7.94672300, 48.4764750 ],
	[ 'ROKS',  'Offenburg Kreisschulzentrum', 8004639, 7.95519200, 48.4597840 ],
	[ 'TOFS',  'Offenhausen',                 8070509, 9.37029200, 48.3996280 ],
	[ 'HOFN',  'Offensen(Kr North)',          8004652, 9.67981700, 51.5888860 ],
	[ 'MOFF',  'Offingen',                    8004654, 10.3760030, 48.4818460 ],
	[ 'ROFH',  'Oftersheim',                  8004658, 8.57901300, 49.3735050 ],
	[ 'MOH',   'Ohlstadt',                    8004662, 11.2180660, 47.6340910 ],
	[ 'FOK',   'Okarben',                     8004664, 8.75335000, 50.2526640 ],
	[ 'HOK',   'Oker',                        8004665, 10.4781460, 51.9048790 ],
	[ 'DOL',   'Olbernhau',                   8012558, 13.3367740, 50.6562550 ],
	[ 'DOLW',  'Olbernhau West',              8012571, 13.3211530, 50.6602510 ],
	[ 'DOGT',  'Olbernhau-Grünthal',         8012559, 13.3648540, 50.6498440 ],
	[ 'DODN',  'Olbersdorf Niederdorf',       8012560, 14.7812190, 50.8811750 ],
	[ 'DODO',  'Olbersdorf Oberdorf',         8012561, 14.7677240, 50.8715480 ],
	[ 'UOL',   'Olbersleben-Ellersleben',     8012562, 11.3329300, 51.1441980 ],
	[ 'MOL',   'Olching',                     8004667, 11.3356020, 48.2099950 ],
	[ 'AOL',   'Oldenburg(Holst)',            8004669, 10.8828380, 54.2838240 ],
	[ 'HOLD',  'Oldenburg(Oldb)',             8000291, 8.22271300, 53.1443230 ],
	[ 'HOLW',  'Oldenburg-Wechloy',           8004670, 8.17815600, 53.1518040 ],
	[ 'HOLB',  'Oldenbüttel',                8004668, 8.81046600, 53.2834320 ],
	[ 'EOLT',  'Oldentrup',                   8079069, 8.59081400, 52.0102790 ],
	[ 'EOLP',  'Olpe',                        8004674, 7.84144700, 51.0277380 ],
	[ 'EOLS',  'Olsberg',                     8004676, 8.48420600, 51.3604950 ],
	[ 'SOU',   'Olsbrücken',                 8004677, 7.65275900, 49.5380710 ],
	[ 'KOPL',  'Opladen',                     8000853, 7.00877500, 51.0661750 ],
	[ 'KOPLM', 'Opladen',                     8000853, 7.00877500, 51.0661750 ],
	[ 'ROP',   'Oppenau',                     8004679, 8.15976100, 48.4719990 ],
	[ 'AOPD',  'Oppendorf Bahnhof',           8079607, 10.2083190, 54.3259610 ],
	[ 'FOPP',  'Oppenheim',                   8004680, 8.35807800, 49.8575600 ],
	[ 'TOP',   'Oppenweiler(Württ)',         8004681, 9.46278500, 48.9815180 ],
	[ 'UOG',   'Oppurg',                      8012563, 11.6505080, 50.7060680 ],
	[ 'LOR',   'Oranienbaum(Anh)',            8012564, 12.3904050, 51.8009190 ],
	[ 'BOR',   'Oranienburg',                 8013487, 13.2496130, 52.7536530 ],
	[ 'UO',    'Orlamünde',                  8010264, 11.5448990, 50.7756610 ],
	[ 'RORW',  'Orschweier',                  8004683, 7.79028100, 48.2741920 ],
	[ 'BORT',  'Ortrand',                     8012565, 13.7649480, 51.3736330 ],
	[ 'DOT',   'Oschatz',                     8013461, 13.1040930, 51.3116600 ],
	[ 'DOT K', 'Oschatz Körnerstr',          8070686, 13.1116480, 51.3001020 ],
	[ 'DOT L', 'Oschatz Lichtstr',            8070685, 13.1095480, 51.3025170 ],
	[ 'DOTS',  'Oschatz Südbf',              8070688, 13.1101740, 51.2941730 ],
	[ 'LO',    'Oschersleben(Bode)',          8010266, 11.2268400, 52.0307260 ],
	[ 'HOHT',  'Osnabrück Altstadt',         8004689, 8.04590200, 52.2809350 ],
	[ 'HO',    'Osnabrück Hbf',              8000294, 8.06178100, 52.2728510 ],
	[ 'HO  O', 'Osnabrück Hbf',              8000294, 8.06178100, 52.2728510 ],
	[ 'HO  U', 'Osnabrück Hbf',              8000294, 8.06178100, 52.2728510 ],
	[ 'HSUN',  'Osnabrück-Sutthausen',       8004690, 8.02141300, 52.2318070 ],
	[ 'EBRO',  'Ostbevern',                   8001183, 7.80928700, 52.0701170 ],
	[ 'LOB',   'Osterburg',                   8012568, 11.7603860, 52.7876680 ],
	[ 'TO',    'Osterburken',                 8000295, 9.42269200, 49.4296570 ],
	[ 'NOS',   'Osterhofen(Nby)',             8004700, 13.0187050, 48.6954740 ],
	[ 'MOSH',  'Osterhofen(Oberbay)',         8004701, 11.9868810, 47.6876550 ],
	[ 'HOSS',  'Osterholz-Scharmbeck',        8004702, 8.79743400, 53.2227760 ],
	[ 'MOM',   'Ostermünchen',               8004703, 12.0415880, 47.9421480 ],
	[ 'LOST',  'Osternienburg',               8012570, 12.0305900, 51.7835180 ],
	[ 'HOTL',  'Osterode am Harz Leege',      8004705, 10.2730270, 51.7170590 ],
	[ 'HOTM',  'Osterode am Harz Mitte',      8004704, 10.2454430, 51.7260380 ],
	[ 'AOSD',  'Ostersode',                   8070214, 8.97537700, 53.3146580 ],
	[ 'KOSS',  'Osterspai',                   8004706, 7.61507400, 50.2450710 ],
	[ 'AODT',  'Osterstedt',                  8004707, 9.57545500, 54.1022190 ],
	[ 'LOT',   'Osterteich',                  8017021, 11.1606910, 51.7206140 ],
	[ 'HOTW',  'Osterwald',                   8004709, 9.63654400, 52.0973440 ],
	[ 'LON',   'Osterweddingen',              8012572, 11.5759210, 52.0491350 ],
	[ 'NOMR',  'Ostheim v Rhön',             8004711, 10.2316210, 50.4559260 ],
	[ 'FOS',   'Ostheim(Kr Hanau)',           8004713, 8.90338100, 50.2191000 ],
	[ 'FOM',   'Ostheim(b Butzbach)',         8004712, 8.67531900, 50.4065980 ],
	[ 'FOHF',  'Osthofen',                    8004714, 8.32598800, 49.7054230 ],
	[ 'TOR',   'Ostrach Bahnhof',             8070628, 9.37882200, 47.9463190 ],
	[ 'DOU',   'Ostrau',                      8012576, 13.1664050, 51.2002940 ],
	[ 'WBI',   'Ostseebad Binz',              8011191, 13.6005070, 54.4048190 ],
	[
		'WKBM', 'Ostseebad Kühlungsborn Mitte', 8012585, 11.7534400,
		54.1416150
	],
	[ 'WKBO', 'Ostseebad Kühlungsborn Ost',  8012586, 11.7598270, 54.1475630 ],
	[ 'WKBW', 'Ostseebad Kühlungsborn West', 8012587, 11.7271670, 54.1464960 ],
	[ 'HOTT', 'Ottbergen',                    8004720, 9.30490900, 51.7109900 ],
	[ 'ROTU', 'Ottenau',                      8004722, 8.33831400, 48.7928770 ],
	[ 'DOF',  'Ottendorf(Mittweida)',         8012593, 12.9528560, 50.9351170 ],
	[ 'DOK',  'Ottendorf-Okrilla Hp',         8012594, 13.8362840, 51.1867950 ],
	[ 'DON',  'Ottendorf-Okrilla Nord',       8012595, 13.8349450, 51.1961240 ],
	[ 'DOS',  'Ottendorf-Okrilla Süd',       8012596, 13.8249530, 51.1776700 ],
	[ 'MONH', 'Ottenhofen(Oberbay)',          8004723, 11.8793850, 48.2181340 ],
	[ 'NOBE', 'Ottenhofen-Bergel',            8004724, 10.3559760, 49.4557900 ],
	[ 'ROTT', 'Ottenhöfen',                  8007006, 8.15104100, 48.5668670 ],
	[ 'ROTW', 'Ottenhöfen West',             8007015, 8.14263600, 48.5678730 ],
	[ 'NOTS', 'Ottensoos',                    8004725, 11.3396830, 49.5077500 ],
	[ 'MOTF', 'Otterfing',                    8004726, 11.6821210, 47.9113870 ],
	[ 'AOF',  'Otterndorf',                   8004727, 8.89398900, 53.8059840 ],
	[ 'AOBG', 'Ottersberg(Han)',              8004728, 9.13315000, 53.0968530 ],
	[ 'LOTW', 'Otterwisch',                   8012597, 12.6017930, 51.2003280 ],
	[ 'MOTG', 'Otting',                       8004730, 12.7035930, 47.9287100 ],
	[ 'MOTW', 'Otting-Weilheim',              8004731, 10.8189350, 48.8808720 ],
	[ 'MOBR', 'Ottobrunn',                    8004733, 11.6777950, 48.0636920 ],
	[ 'SOTW', 'Ottweiler(Saar)',              8000875, 7.16613300, 49.4023370 ],
	[ 'FLE',  'Otzberg Lengfeld',             8003641, 8.90273700, 49.8394530 ],
	[ 'HOTZ', 'Otze',                         8004735, 10.0171140, 52.4876170 ],
	[ 'LOV',  'Ovelgünne',                   8012599, 11.2694300, 52.1418070 ],
	[ 'KOV',  'Overath',                      8004739, 7.28881700, 50.9327300 ],
	[ 'TOW',  'Owen(Teck)',                   8004740, 9.44776000, 48.5869960 ],
	[ 'AOS',  'Owschlag',                     8004741, 9.59051600, 54.3925950 ],
	[ 'MOYM', 'Oy-Mittelberg',                8004742, 10.4581310, 47.6461520 ],
	[ 'UOM',  'Oßmannstedt',                 8012567, 11.4259310, 51.0193030 ],
	[ 'EPD',  'Paderborn Hbf',                8000297, 8.74050500, 51.7129790 ],
	[ 'EPDK', 'Paderborn Kasseler Tor',       8004744, 8.76126000, 51.7161610 ],
	[ 'EPDN', 'Paderborn Nord',               8004745, 8.75895400, 51.7280700 ],
	[ 'ESNS', 'Paderborn-Schloss Neuhaus',    8005370, 8.72084500, 51.7493790 ],
	[ 'KPFF', 'Paffendorf',                   8004746, 6.60699800, 50.9616910 ],
	[ 'MPD',  'Paindorf',                     8004747, 11.4872630, 48.4426800 ],
	[ 'SPZ',  'Palzem',                       8004748, 6.37192600, 49.5650640 ],
	[ 'NPK',  'Pankofen',                     8004749, 12.8994250, 48.7996410 ],
	[ 'APF',  'Pansdorf',                     8004750, 10.7030560, 53.9810340 ],
	[ 'HPAP', 'Papenburg(Ems)',               8004751, 7.38670800, 53.0897060 ],
	[ 'WPF',  'Papendorf',                    8012603, 12.1373180, 54.0366040 ],
	[ 'UPM',  'Papiermühle(Stadtr)',         8012604, 11.7904590, 50.8852350 ],
	[ 'MPP',  'Pappenheim',                   8004753, 10.9640280, 48.9264050 ],
	[ 'WPM',  'Parchim',                      8010267, 11.8312650, 53.4303200 ],
	[ 'WPA',  'Parkentin',                    8012609, 11.9789830, 54.0812560 ],
	[ 'NPB',  'Parsberg',                     8004755, 11.7233550, 49.1643550 ],
	[ 'NPAR', 'Partenstein',                  8004756, 9.52399000, 50.0383790 ],
	[ 'WP',   'Pasewalk',                     8010268, 13.9888750, 53.5153530 ],
	[ 'WPO',  'Pasewalk Ost',                 8012610, 14.0093120, 53.5095700 ],
	[ 'NPA',  'Passau Hbf',                   8000298, 13.4507760, 48.5736320 ],
	[ 'WPS',  'Passow(Uckermark)',            8012611, 14.1013700, 53.1487020 ],
	[ 'NPAD', 'Patersdorf',                   8070665, 12.9934090, 49.0133940 ],
	[ 'WPAU', 'Paulinenaue',                  8012614, 12.7132700, 52.6758920 ],
	[ 'WPAUO', 'Paulinenaue',              8012614, 12.7132700, 52.6758920 ],
	[ 'UPA',   'Paulinzella',              8012615, 11.1059600, 50.7011060 ],
	[ 'NPE',   'Pechbrunn',                8004758, 12.1659560, 49.9695360 ],
	[ 'WPD',   'Peenemünde',              8012617, 13.7730840, 54.1387620 ],
	[ 'LPG',   'Pegau',                    8010269, 12.2410460, 51.1659660 ],
	[ 'NPZ',   'Pegnitz',                  8004759, 11.5475470, 49.7583410 ],
	[ 'HP',    'Peine',                    8004760, 10.2321450, 52.3189420 ],
	[ 'MPTN',  'Peiting Nord',             8004764, 10.9266700, 47.8015650 ],
	[ 'MPTO',  'Peiting Ost',              8004765, 10.9366920, 47.7929550 ],
	[ 'BPO',   'Peitz Ost',                8012621, 14.4494220, 51.8439790 ],
	[ 'MPEI',  'Peiß',                    8004761, 11.7765950, 47.9601020 ],
	[ 'LPE',   'Peißen',                  8012619, 12.0596420, 51.5008140 ],
	[ 'MPBG',  'Peißenberg',              8004762, 11.0602790, 47.7974960 ],
	[ 'MPBN',  'Peißenberg Nord',         8004763, 11.0773040, 47.8156800 ],
	[ 'MPZ',   'Penzberg',                 8004767, 11.3718750, 47.7492490 ],
	[ 'MPRM',  'Perkam',                   8004770, 12.4373880, 48.8575540 ],
	[ 'SPE',   'Perl',                     8004771, 6.36932100, 49.4731630 ],
	[ 'WPB',   'Perleberg',                8012622, 11.8523220, 53.0712550 ],
	[ 'LPB',   'Petergrube',               8012623, 12.5033480, 51.0984020 ],
	[ 'NPET',  'Petersaurach',             8004774, 10.7454330, 49.3036560 ],
	[ 'NPEN',  'Petersaurach Nord',        8004797, 10.7390970, 49.3184010 ],
	[ 'BPEN',  'Petershagen Nord',         8081150, 13.7894810, 52.5288490 ],
	[ 'WPE',   'Petershagen(Uckerm)',      8012627, 14.2523490, 53.2399770 ],
	[ 'HLAD',  'Petershagen-Lahde',        8004777, 9.00981300, 52.3680320 ],
	[ 'MPE',   'Petershausen(Obb)',        8004775, 11.4698810, 48.4134500 ],
	[ 'LPRO',  'Petersroda',               8012629, 12.2854080, 51.5696910 ],
	[ 'DPFH',  'Pfaffenhain',              8012633, 12.8224850, 50.7500910 ],
	[ 'MPFH',  'Pfaffenhausen',            8004780, 10.4518250, 48.1177940 ],
	[ 'MPF',   'Pfaffenhofen(Ilm)',        8004781, 11.5118840, 48.5224330 ],
	[ 'SPF',   'Pfalzel',                  8004784, 6.68302000, 49.7803190 ],
	[ 'MPKI',  'Pfarrkirchen',             8004786, 12.9381690, 48.4291950 ],
	[ 'FPD',   'Pfeddersheim',             8004788, 8.27965400, 49.6346340 ],
	[ 'MPFT',  'Pfettrach',                8026355, 12.0661130, 48.5744990 ],
	[ 'TPF',   'Pflaumloch',               8004796, 10.4369250, 48.8490300 ],
	[ 'TPH',   'Pforzheim Hbf',            8000299, 8.70309900, 48.8941520 ],
	[ 'TPHM',  'Pforzheim Maihälden',     8004804, 8.67815800, 48.8933910 ],
	[ 'TPW',   'Pforzheim-Weißenstein',   8004801, 8.67644900, 48.8651470 ],
	[ 'NPD',   'Pfreimd',                  8004803, 12.1674530, 49.4857910 ],
	[ 'MPFD',  'Pfronten-Ried',            8004806, 10.5610260, 47.5835910 ],
	[ 'MPFS',  'Pfronten-Steinach',        8004807, 10.5745720, 47.5661110 ],
	[ 'MPFW',  'Pfronten-Weißbach',       8004809, 10.5577360, 47.5957010 ],
	[ 'TPU',   'Pfullendorf',              8070630, 9.25572800, 47.9228800 ],
	[ 'FPU',   'Pfungstadt',               8004816, 8.60703300, 49.8062230 ],
	[ 'TPG',   'Pfäffingen',              8004778, 8.96470100, 48.5321670 ],
	[ 'RPB',   'Philippsburg(Baden)',      8004813, 8.45402300, 49.2316210 ],
	[ 'WPH',   'Philippshagen',            8012634, 13.7070420, 54.3476620 ],
	[ 'SPI',   'Philippsheim',             8004814, 6.62569300, 49.9534350 ],
	[ 'MPI',   'Piding',                   8004815, 12.9115300, 47.7595430 ],
	[ 'BPIL',  'Pillgram',                 8012636, 14.3985320, 52.3368980 ],
	[ 'AP',    'Pinneberg',                8004819, 9.79760800, 53.6551790 ],
	[ 'APS',   'Pinneberg',                8004819, 9.79760800, 53.6551790 ],
	[ 'WPIN',  'Pinnow(Uckermark)',        8012637, 14.0887420, 53.0653420 ],
	[ 'NPI',   'Pinzberg',                 8004820, 11.0970960, 49.6988090 ],
	[ 'DPK',   'Pirk',                     8012639, 12.0766120, 50.4274220 ],
	[ 'SPS',   'Pirmasens Hbf',            8004822, 7.59843200, 49.2056450 ],
	[ 'SPSN',  'Pirmasens Nord',           8000876, 7.60440100, 49.2592180 ],
	[ 'DPI',   'Pirna',                    8010272, 13.9288810, 50.9626230 ],
	[ 'DPIC',  'Pirna-Copitz',             8012640, 13.9338720, 50.9681100 ],
	[ 'DPIN',  'Pirna-Copitz Nord',        8012641, 13.9353610, 50.9776110 ],
	[ 'MPTH',  'Pittenhart',               8072764, 12.3763410, 47.9867620 ],
	[ 'WPZ',   'Plaaz',                    8010273, 12.3377160, 53.8404570 ],
	[ 'KPL',   'Plaidt',                   8004826, 7.39363800, 50.3952040 ],
	[ 'MPL',   'Planegg',                  8004827, 11.4135560, 48.1053030 ],
	[ 'WPLM',  'Plate(Meckl)',             8012643, 11.5070240, 53.5532050 ],
	[ 'NPL',   'Plattling',                8000301, 12.8639400, 48.7796190 ],
	[ 'UPL',   'Plaue(Thür)',             8010274, 10.9086980, 50.7783930 ],
	[ 'DPM',   'Plauen(Vogtl) Mitte',      8017442, 12.1477800, 50.4935840 ],
	[ 'DP',    'Plauen(Vogtl) ob Bf',      8010275, 12.1294190, 50.5061630 ],
	[ 'DSRB',  'Plauen(Vogtl)-Straßberg', 8010336, 12.0923120, 50.4802120 ],
	[ 'DPW',   'Plauen(Vogtl)West',        8012646, 12.1134390, 50.4944120 ],
	[ 'NPLF',  'Pleinfeld',                8004835, 10.9773690, 49.1062800 ],
	[ 'BP',    'Plessa',                   8012650, 13.6168470, 51.4708510 ],
	[ 'EPLT',  'Plettenberg',              8004838, 7.86891300, 51.2319300 ],
	[ 'TP',    'Plochingen',               8000302, 9.41081000, 48.7130800 ],
	[ 'APLN',  'Plön',                    8004841, 10.4225620, 54.1594790 ],
	[ 'TPL',   'Plüderhausen',            8004842, 9.59585300, 48.7966840 ],
	[ 'WPSW',  'Plüschow',                8012651, 11.2858450, 53.8370640 ],
	[ 'DPF',   'Pockau-Lengefeld',         8010277, 13.2265850, 50.7071320 ],
	[ 'MPKG',  'Pocking',                  8004845, 13.3131640, 48.4062220 ],
	[ 'HPOG',  'Poggenhagen',              8004851, 9.45397200, 52.4673070 ],
	[ 'NPOI',  'Poikam',                   8004853, 12.0138360, 48.9315080 ],
	[ 'MPO',   'Poing',                    8004854, 11.8094380, 48.1713290 ],
	[ 'NPMH',  'Pommelsbrunn',             8004858, 11.5136150, 49.5014630 ],
	[ 'SPOM',  'Pommern(Mosel)',           8004859, 7.26983600, 50.1692980 ],
	[ 'DPOM',  'Pommritz',                 8012660, 14.5747000, 51.1590150 ],
	[ 'DPO',   'Ponitz',                   8012661, 12.4166640, 50.8577780 ],
	[ 'NPOP',  'Poppenhausen',             8004865, 10.1387860, 50.1004770 ],
	[ 'DPSC',  'Porschdorf(Pirna)',        8012662, 14.1385760, 50.9431840 ],
	[ 'UPF',   'Porstendorf',              8012663, 11.6454890, 50.9769930 ],
	[ 'HPTH',  'Porta Westfalica',         8004868, 8.92025300, 52.2434230 ],
	[ 'KPR',   'Porz(Rhein)',              8004869, 7.06472400, 50.8829070 ],
	[ 'KPRH',  'Porz(Rhein)',              8004869, 7.06472400, 50.8829070 ],
	[ 'KPW',   'Porz-Wahn',                8004873, 7.07926600, 50.8581330 ],
	[ 'WPOW',  'Posewald',                 8012665, 13.5284120, 54.3681070 ],
	[ 'WPWK',  'Posewald',                 8012665, 13.5284120, 54.3681070 ],
	[ 'MPH',   'Possenhofen',              8004874, 11.3064750, 47.9619600 ],
	[ 'NPOH',  'Postbauer-Heng',           8004875, 11.3588490, 49.3089210 ],
	[ 'BPDC',  'Potsdam Charlottenhof',    8010280, 13.0364960, 52.3928000 ],
	[ 'BGBS',  'Potsdam Griebnitzsee',     8080530, 13.1287130, 52.3944390 ],
	[ 'BPD',   'Potsdam Hbf',              8012666, 13.0667820, 52.3917040 ],
	[
		'BDW', 'Potsdam Medienstadt Babelsberg', 8011430, 13.1222840,
		52.3826590
	],
	[ 'BWP',   'Potsdam Park Sanssouci',    8010377, 13.0145120, 52.3941080 ],
	[ 'BPDP',  'Potsdam Pirschheide',       8010279, 13.0112430, 52.3726670 ],
	[ 'BBAB',  'Potsdam-Babelsberg',        8080070, 13.0928710, 52.3913910 ],
	[ 'BRC',   'Potsdam-Rehbrücke',        8012733, 13.0982320, 52.3582980 ],
	[ 'EPRA',  'Praest',                    8004878, 6.34553400, 51.8218620 ],
	[ 'LPT',   'Pratau',                    8010281, 12.6359640, 51.8432560 ],
	[ 'APZ',   'Preetz',                    8004879, 10.2757520, 54.2339410 ],
	[ 'LPZH',  'Premnitz Nord',             8012668, 12.3334940, 52.5359680 ],
	[ 'LPZS',  'Premnitz Zentrum',          8012669, 12.3431380, 52.5291360 ],
	[ 'WPL',   'Prenzlau',                  8010282, 13.8665320, 53.3216080 ],
	[ 'NPS',   'Pressath',                  8004880, 11.9391420, 49.7640700 ],
	[ 'NPR',   'Pressig-Rothenkirchen',     8004881, 11.3108240, 50.3488380 ],
	[ 'NPRE',  'Pretzfeld',                 8004882, 11.1700510, 49.7573060 ],
	[ 'LPRZ',  'Pretzier(Altm)',            8012673, 11.2645400, 52.8364360 ],
	[ 'LPH',   'Pretzsch',                  8010283, 12.7878140, 51.7180100 ],
	[ 'EPRN',  'Preußen',                  8004883, 7.53969200, 51.5881500 ],
	[ 'WPI',   'Priemerburg',               8010284, 12.2230220, 53.7959790 ],
	[ 'MPR',   'Prien a Chiemsee',          8004885, 12.3466150, 47.8555130 ],
	[ 'DPR',   'Priestewitz',               8010285, 13.5091200, 51.2506020 ],
	[ 'BPOT',  'Priort',                    8013489, 12.9713740, 52.5163670 ],
	[ 'APD',   'Prisdorf',                  8004888, 9.76021600, 53.6752910 ],
	[ 'UPZ',   'Prittitz',                  8012675, 11.9373310, 51.1584100 ],
	[ 'LPI',   'Pritzerbe',                 8012676, 12.4586520, 52.4995810 ],
	[ 'WPRZ',  'Pritzier',                  8012677, 11.0835600, 53.3649710 ],
	[ 'WPR',   'Pritzwalk',                 8010287, 12.1845180, 53.1457590 ],
	[ 'WPRH',  'Pritzwalk Hainholz',        8074703, 12.205920,  53.170082 ],
	[ 'WPRW',  'Pritzwalk West',            8017347, 12.1642630, 53.1446100 ],
	[ 'APSH',  'Probsteierhagen',           8007318, 10.2929910, 54.3651390 ],
	[ 'UPR',   'Probstzella',               8010288, 11.3835680, 50.5282310 ],
	[ 'LPR',   'Profen',                    8012682, 12.2109330, 51.1304580 ],
	[ 'WPRA',  'Prora',                     8012683, 13.5640570, 54.4449860 ],
	[ 'WPRO',  'Prora Ost',                 8012684, 13.5745150, 54.4300600 ],
	[ 'NPM',   'Prosselsheim',              8070858, 10.1235670, 49.8645180 ],
	[ 'LPRL',  'Prödel',                   8012678, 11.9133420, 52.0376400 ],
	[ 'DPRO',  'Prösen',                   8012679, 13.4883940, 51.4350580 ],
	[ 'BPW',   'Prösen Ost',               8012681, 13.5005320, 51.4252990 ],
	[ 'DPRW',  'Prösen West',              8012680, 13.4702210, 51.4249610 ],
	[ 'MPM',   'Puchheim',                  8004893, 11.3530610, 48.1721790 ],
	[ 'KPUL',  'Pulheim',                   8004898, 6.79705100, 50.9980430 ],
	[ 'MPUL',  'Pullach',                   8004899, 11.5218480, 48.0589800 ],
	[ 'MPU',   'Pulling(b Freising)',       8004900, 11.7070840, 48.3633900 ],
	[ 'DPUL',  'Pulsnitz',                  8012685, 14.0137950, 51.1881620 ],
	[ 'DPUS',  'Pulsnitz Süd',             8012686, 14.0075140, 51.1807310 ],
	[ 'NPU',   'Puschendorf',               8004901, 10.8281770, 49.5207620 ],
	[ 'WPUB',  'Putbus',                    8010401, 13.4809700, 54.3567640 ],
	[ 'APU',   'Puttgarden',                8004903, 11.2267210, 54.5003700 ],
	[ 'DPT',   'Putzkau',                   8012688, 14.2357700, 51.1031240 ],
	[ 'WPOE',  'Pölchow',                  8012654, 12.1211270, 54.0110310 ],
	[ 'NPG',   'Pölling',                  8004847, 11.4136850, 49.2882820 ],
	[ 'APN',   'Pönitz(Holst)',            8004848, 10.6711570, 54.0456540 ],
	[ 'LPOE',  'Pönitz(Leipzig)',          8012656, 12.5144320, 51.4085360 ],
	[ 'NPOE',  'Pösing',                   8004849, 12.5429000, 49.2291460 ],
	[ 'UPS',   'Pößneck ob Bf',           8012657, 11.5883380, 50.6902930 ],
	[ 'UPSU',  'Pößneck unt Bf',          8012658, 11.6068720, 50.7005360 ],
	[ 'KQ',    'Quadrath-Ichendorf',        8004907, 6.68616500, 50.9378590 ],
	[ 'HQ',    'Quakenbrück',              8000304, 7.94781900, 52.6739430 ],
	[ 'LQB',   'Quedlinburg',               8010290, 11.1530010, 51.7852680 ],
	[ 'LQQ',   'Quedlinburg-Quarmbeck',     8012690, 11.1264020, 51.7530290 ],
	[ 'EQL',   'Quelle',                    8004908, 8.46076800, 52.0004870 ],
	[ 'EQL O', 'Quelle',                    8004908, 8.46076800, 52.0004870 ],
	[ 'EQL W', 'Quelle',                    8004908, 8.46076800, 52.0004870 ],
	[ 'EQLK',  'Quelle-Kupferheide',        8004905, 8.47639700, 51.9941010 ],
	[ 'LQ',    'Querfurt',                  8010291, 11.6036970, 51.3869190 ],
	[ 'AQB',   'Quickborn',                 8007049, 9.90475900, 53.7311300 ],
	[ 'AQBD',  'Quickborn Süd',            8007064, 9.90747000, 53.7230840 ],
	[ 'AQBS',  'Quickborner Straße',       8079028, 9.98981800, 53.7344260 ],
	[ 'SQS',   'Quierschied',               8004909, 7.05938600, 49.3248550 ],
	[ 'SQI',   'Quint',                     8004910, 6.70469700, 49.8259880 ],
	[ 'DRAB',  'Rabenau',                   8012694, 13.6348750, 50.9632270 ],
	[ 'LRAK',  'Rackith(Elbe)',             8012696, 12.6807390, 51.8026790 ],
	[ 'LRK',   'Rackwitz(Leipzig)',         8012697, 12.3751300, 51.4403180 ],
	[ 'ARH',   'Radbruch',                  8004913, 10.2896180, 53.3178730 ],
	[ 'BRAD',  'Raddusch',                  8012698, 14.0323540, 51.8158580 ],
	[ 'DRAG',  'Radeberg',                  8012699, 13.9125390, 51.1117520 ],
	[ 'DRB',   'Radebeul Ost',              8010292, 13.6801630, 51.0982940 ],
	[ 'DRB B', 'Radebeul Ost',              8010292, 13.6801630, 51.0982940 ],
	[ 'DRBK',  'Radebeul-Kötzschenbroda',  8010293, 13.6286930, 51.1076150 ],
	[ 'DRBN',  'Radebeul-Naundorf',         8013490, 13.5991010, 51.1103360 ],
	[ 'DRBT',  'Radebeul-Weintraube',       8012700, 13.6560170, 51.1030020 ],
	[ 'DRBZ',  'Radebeul-Zitzschewig',      8012701, 13.6068090, 51.1143050 ],
	[ 'DRDB',  'Radeburg',                  8012702, 13.7277180, 51.2098800 ],
	[ 'MRDD',  'Radersdorf',                8004914, 11.1622690, 48.5144190 ],
	[ 'LRA',   'Radis',                     8012704, 12.5041830, 51.7547040 ],
	[ 'NRA',   'Radldorf(Niederbay)',       8004917, 12.4430700, 48.8746660 ],
	[ 'RRZ',   'Radolfzell',                8000880, 8.96898400, 47.7358730 ],
	[ 'ERAE',  'Raestrup-Everswinkel',      8004918, 7.86754700, 51.9658670 ],
	[ 'LRH',   'Raguhn',                    8012707, 12.2708940, 51.7083910 ],
	[ 'HRAH',  'Rahden(Kr Lübbecke)',      8004919, 8.62383600, 52.4329020 ],
	[ 'MRN',   'Rain',                      8004922, 10.9275140, 48.6961790 ],
	[ 'NRAF',  'Raindorf',                  8004923, 10.8461880, 49.5042390 ],
	[ 'ARS',   'Raisdorf',                  8004924, 10.2436940, 54.2809370 ],
	[ 'ARSW',  'Raisdorf',                  8004924, 10.2436940, 54.2809370 ],
	[ 'MRAG',  'Raisting',                  8004925, 11.1141650, 47.9120760 ],
	[ 'NRAH',  'Raitersaich',               8004926, 10.8435490, 49.3748980 ],
	[ 'WRAK',  'Rakow',                     8012710, 13.0459420, 54.0481560 ],
	[ 'WRMB',  'Rambin(Rügen)',            8012711, 13.2078130, 54.3534290 ],
	[ 'MRMB',  'Ramerberg',                 8004928, 12.1467040, 48.0196400 ],
	[ 'SRCH',  'Rammelsbach',               8004929, 7.44407500, 49.5421310 ],
	[ 'MRAM',  'Rammingen(Bay)',            8004927, 10.5880650, 48.0530220 ],
	[ 'TRM',   'Rammingen(Württ)',         8004930, 10.1910840, 48.5124670 ],
	[ 'RRBI',  'Ramsbach Birkhof',          8004931, 8.14567000, 48.4883390 ],
	[ 'RRBH',  'Ramsbach Höfle',           8004932, 8.13936100, 48.4948640 ],
	[ 'NRAB',  'Ramsberg',                  8004933, 10.9253780, 49.1118410 ],
	[ 'RRN',   'Ramsen',                    8004935, 8.02113000, 49.5349710 ],
	[ 'NRSL',  'Ramsenthal',                8004936, 11.5933340, 50.0079280 ],
	[ 'SRAS',  'Ramstein',                  8004938, 7.55671500, 49.4487550 ],
	[ 'TRGD',  'Rangendingen',              8070520, 8.89299900, 48.3814750 ],
	[ 'BRSF',  'Rangsdorf',                 8012713, 13.4308900, 52.2939480 ],
	[ 'FRAN',  'Ranstadt',                  8004942, 8.98313400, 50.3567300 ],
	[ 'RRA',   'Rastatt',                   8000306, 8.21562300, 48.8604830 ],
	[ 'RRAB',  'Rastatt Beinle',            8004944, 8.22506500, 48.8521480 ],
	[ 'HRST',  'Rastede',                   8004945, 8.19101100, 53.2446000 ],
	[ 'WRW',   'Rastow',                    8012716, 11.4308590, 53.4581560 ],
	[ 'LRW',   'Rathenow',                  8010296, 12.3548400, 52.5996400 ],
	[ 'DRD',   'Rathmannsdorf(Kr Pirna)',   8012719, 14.1308380, 50.9270420 ],
	[ 'KRAO',  'Ratingen Ost',              8004948, 6.86356200, 51.2951850 ],
	[ 'ARF',   'Ratzeburg',                 8004952, 10.7406330, 53.6982150 ],
	[ 'MRA',   'Raubling',                  8004955, 12.1101490, 47.7885060 ],
	[ 'URAU',  'Rauenstein(Thür)',         8012723, 11.0474860, 50.4122530 ],
	[ 'ERMA',  'Raumland-Markhausen',       8004960, 8.36824200, 51.0339540 ],
	[ 'RRMZ',  'Raumünzach',               8004961, 8.35140800, 48.6448460 ],
	[ 'DRU',   'Raun',                      8012724, 12.2930060, 50.2597220 ],
	[ 'FRA',   'Raunheim',                  8004962, 8.45449800, 50.0096880 ],
	[ 'TRB',   'Ravensburg',                8004965, 9.60610000, 47.7844810 ],
	[ 'MRH',   'Rebdorf-Hofmühle',         8004966, 11.1694570, 48.8922150 ],
	[ 'KREC',  'Rech',                      8004967, 7.03651400, 50.5154270 ],
	[ 'DRBG',  'Rechenberg',                8012727, 13.5599020, 50.7339310 ],
	[ 'TRC',   'Rechtenstein',              8004968, 9.55090400, 48.2399930 ],
	[ 'HRFD',  'Rechterfeld',               8004970, 8.39129100, 52.8386850 ],
	[ 'NRDF',  'Reckendorf',                8004971, 10.8340380, 50.0193940 ],
	[ 'ERFE',  'Reckenfeld',                8004972, 7.56475300, 52.1336960 ],
	[ 'ERE',   'Recklinghausen Hbf',        8000307, 7.20349000, 51.6163590 ],
	[ 'ERES',  'Recklinghausen Süd',       8000887, 7.19575400, 51.5629650 ],
	[ 'SRWH',  'Reckweilerhof',             8004975, 7.60915100, 49.6073330 ],
	[ 'WRDL',  'Reddelich',                 8012729, 11.8495310, 54.0852410 ],
	[ 'NRCH',  'Rednitzhembach',            8004978, 11.0633630, 49.3038770 ],
	[ 'NRZ',   'Redwitz(Rodach)',           8004979, 11.2072880, 50.1688310 ],
	[ 'NREG',  'Regen',                     8004981, 13.1364650, 48.9686250 ],
	[ 'NRH',   'Regensburg Hbf',            8000309, 12.0996170, 49.0116720 ],
	[ 'NBWH',  'Regensburg-Burgweinting',   8001298, 12.1467130, 48.9904250 ],
	[ 'NRPF',  'Regensburg-Prüfening',     8004983, 12.0492970, 49.0120570 ],
	[ 'NRPH',  'Regensburg-Prüfening',     8004983, 12.0492970, 49.0120570 ],
	[ 'NRGF',  'Regenstauf',                8004987, 12.1251420, 49.1221570 ],
	[ 'LRB',   'Regis-Breitingen',          8012731, 12.4260390, 51.0835480 ],
	[ 'NRU',   'Rehau',                     8004988, 12.0324570, 50.2505560 ],
	[ 'LRF',   'Rehfeld(Falkenberg)',       8012734, 13.1533310, 51.5797260 ],
	[ 'BRE',   'Rehfelde',                  8012735, 13.9228030, 52.5284180 ],
	[ 'WRA',   'Rehna',                     8012737, 11.0497470, 53.7742630 ],
	[ 'SRW',   'Rehweiler',                 8004993, 7.44058100, 49.4851600 ],
	[ 'NREK',  'Reichelsdorfer Keller',     8004994, 11.0401660, 49.3679220 ],
	[ 'FRHM',  'Reichelsheim(Wett)',        8004995, 8.87457800, 50.3601450 ],
	[ 'RRU',   'Reichenau(Baden)',          8004997, 9.12596100, 47.6893460 ],
	[ 'TRF',   'Reichenbach(Fils)',         8004999, 9.46373300, 48.7079710 ],
	[ 'DRCH',  'Reichenbach(Oberlausitz)',  8012738, 14.7963620, 51.1354720 ],
	[ 'DRC',   'Reichenbach(Vogtl) ob Bf',  8012739, 12.2931200, 50.6277770 ],
	[ 'RRBA',  'Reichenbach(b. Ettlingen)', 8007012, 8.47955300, 48.9204820 ],
	[ 'TRCB',  'Reichenberg(Unterfr)',      8005002, 9.91289000, 49.7311290 ],
	[ 'NREI',  'Reichenschwand',            8005005, 11.3734410, 49.5149700 ],
	[ 'MRCH',  'Reichersbeuern',            8005007, 11.6359840, 47.7746380 ],
	[ 'MRS',   'Reichertshausen(Ilm)',      8005008, 11.5102030, 48.4711970 ],
	[ 'TRL',   'Reicholzheim',              8005011, 9.52754300, 49.7285140 ],
	[ 'DRF',   'Reifland-Wünschendorf',    8012740, 13.1944860, 50.7404370 ],
	[ 'RRIN',  'Reihen',                    8005013, 8.92059100, 49.2164310 ],
	[ 'SREI',  'Reil',                      8005014, 7.11294900, 50.0251690 ],
	[ 'RRHM',  'Reilsheim',                 8005015, 8.77883600, 49.3539660 ],
	[ 'ARBK',  'Reinbek',                   8005016, 10.2533350, 53.5083950 ],
	[ 'ARD',   'Reinfeld(Holst)',           8005019, 10.4945370, 53.8304300 ],
	[ 'URN',  'Reinhardsbrunn-Friedrichroda', 8012742, 10.5627280, 50.8634980 ],
	[ 'FREI', 'Reinheim(Odenw)',              8005020, 8.83568900, 49.8298060 ],
	[ 'ARE',  'Reinsbüttel',                 8005023, 8.90664700, 54.1812060 ],
	[ 'URD',  'Reinsdorf(Artern)',            8010124, 11.2860510, 51.3422700 ],
	[ 'URDN', 'Reinsdorf(bei Nebra)',         8012743, 11.6014640, 51.2979970 ],
	[ 'TRTT', 'Reinstetten',                  8079094, 9.93981000, 48.1090470 ],
	[ 'RRSH', 'Reisen(Hess)',                 8005026, 8.72001500, 49.5779700 ],
	[ 'FRSK', 'Reiskirchen(Kr Gi)',           8005027, 8.83093000, 50.5978320 ],
	[ 'EREK', 'Reken',                        8005030, 7.04995600, 51.8018460 ],
	[ 'KRE',  'Remagen',                      8000310, 7.22977900, 50.5772150 ],
	[ 'KR',   'Remscheid Hbf',                8005033, 7.19998300, 51.1772350 ],
	[ 'KRG',  'Remscheid-Güldenwerth',       8005034, 7.16303000, 51.1691980 ],
	[ 'KRL',  'Remscheid-Lennep',             8000311, 7.25283300, 51.1907240 ],
	[ 'KRLU', 'Remscheid-Lüttringhausen',    8005035, 7.24272800, 51.2153230 ],
	[ 'RR',   'Renchen',                      8005037, 8.00713800, 48.5926600 ],
	[ 'AR',   'Rendsburg',                    8000312, 9.67113400, 54.3022620 ],
	[ 'TRX',  'Renningen',                    8000313, 8.93235000, 48.7751210 ],
	[ 'TRXS', 'Renningen Süd',               8005001, 8.93202700, 48.7626740 ],
	[ 'UREN', 'Rennsteig',                    8012749, 10.8351380, 50.6152490 ],
	[ 'SRE',  'Rentrisch',                    8005044, 7.07906500, 49.2597700 ],
	[ 'NREN', 'Rentweinsdorf',                8005045, 10.8138550, 50.0604480 ],
	[ 'URH',  'Rentwertshausen',              8012750, 10.4322840, 50.4551590 ],
	[ 'URM',  'Rentzschmühle',               8012751, 12.1578130, 50.5750070 ],
	[ 'HRTN', 'Rethen(Leine)',                8005047, 9.81949600, 52.2858070 ],
	[ 'NREZ', 'Retzbach-Zellingen',           8005049, 9.81421400, 49.9051520 ],
	[ 'URR',  'Reurieth',                     8012756, 10.6535190, 50.4597910 ],
	[ 'WRST', 'Reuterstadt Stavenhagen',      8012758, 12.9142000, 53.7069190 ],
	[ 'NRT',  'Reuth(b Erbendorf)',           8005050, 12.1184380, 49.8400390 ],
	[ 'DRTH', 'Reuth(b Plauen,Vogtl)',        8012759, 11.9543370, 50.4758590 ],
	[ 'TRE',  'Reutlingen Hbf',               8000314, 9.20911600, 48.4960790 ],
	[ 'TREW', 'Reutlingen West',              8005052, 9.20185000, 48.4926130 ],
	[ 'TREB', 'Reutlingen-Betzingen',         8005053, 9.17544200, 48.4962100 ],
	[ 'TRES', 'Reutlingen-Sondelfingen',      8005054, 9.23691500, 48.5151320 ],
	[ 'LRE',  'Reußen',                      8012757, 12.1343460, 51.5032010 ],
	[ 'ERHA', 'Rhade',                        8005055, 6.94809100, 51.7512700 ],
	[ 'ERDW', 'Rheda-Wiedenbrück',           8000315, 8.28665000, 51.8570230 ],
	[ 'KRBA', 'Rheinbach',                    8005058, 6.94751300, 50.6292130 ],
	[ 'KRBL', 'Rheinbach Römerkanal',        8005057, 6.96791100, 50.6282840 ],
	[ 'KRBE', 'Rheinberg(Rheinl)',            8005059, 6.59194400, 51.5423820 ],
	[ 'KRBR', 'Rheinbrohl',                   8005062, 7.33342700, 50.4894930 ],
	[ 'HR',   'Rheine',                       8000316, 7.43425500, 52.2762990 ],
	[ 'HMSU', 'Rheine-Mesum',                 8004000, 7.48561300, 52.2231340 ],
	[ 'RRH',  'Rheinfelden(Baden)',           8005064, 7.78420900, 47.5569230 ],
	[ 'KRH',  'Rheinhausen',                  8000317, 6.70648400, 51.3935070 ],
	[ 'KRHO', 'Rheinhausen Ost',              8005065, 6.72410800, 51.4018730 ],
	[ 'WRH',  'Rheinsberg(Mark)',             8012760, 12.8999930, 53.0928580 ],
	[ 'RRHH', 'Rheinsheim',                   8005067, 8.41596600, 49.2291560 ],
	[ 'RRW',  'Rheinweiler',                  8005068, 7.53164300, 47.7095320 ],
	[
		'RRZU',  'Rheinzabern Alte Römerstraße',
		8005072, 8.27305700,
		49.1093660
	],
	[ 'RRZA',  'Rheinzabern Bf',            8005069, 8.27416600, 49.1195370 ],
	[ 'RRZM',  'Rheinzabern Rappengasse',   8005071, 8.27329100, 49.1148360 ],
	[ 'KRHE',  'Rhens',                     8005070, 7.62048400, 50.2815190 ],
	[ 'KRY',   'Rheydt Hbf',                8000318, 6.43956400, 51.1630270 ],
	[ 'KRY P', 'Rheydt Hbf',                8000318, 6.43956400, 51.1630270 ],
	[ 'KRYO',  'Rheydt-Odenkirchen',        8005073, 6.44616900, 51.1378470 ],
	[ 'KRHD',  'Rhöndorf',                 8005074, 7.21021400, 50.6578760 ],
	[ 'WRIO',  'Ribnitz-Damgarten Ost',     8012762, 12.4870150, 54.2510160 ],
	[ 'WRI',   'Ribnitz-Damgarten West',    8012763, 12.4369650, 54.2391760 ],
	[ 'RRIH',  'Richen(b Eppingen)',        8005077, 8.93655400, 49.1678460 ],
	[ 'ARL',   'Rickling',                  8005080, 10.1683180, 53.9990580 ],
	[ 'FRID',  'Ried',                      8005083, 9.76976500, 50.4592380 ],
	[ 'MRDU',  'Riederau',                  8005086, 11.0971530, 47.9825810 ],
	[ 'TRI',   'Riedlingen',                8005087, 9.48492700, 48.1495950 ],
	[ 'FRIE',  'Riedrode',                  8005089, 8.49595000, 49.6474880 ],
	[ 'FGE',   'Riedstadt-Goddelau',        8000126, 8.48918700, 49.8332300 ],
	[ 'FLW',   'Riedstadt-Wolfskehlen',     8003605, 8.49309800, 49.8539370 ],
	[ 'RROP',  'Riegel am Kaiserstuhl Ort', 8007284, 7.74994300, 48.1540550 ],
	[ 'RRP',   'Riegel-Malterd.NE',         8007299, 7.77072800, 48.1520210 ],
	[ 'RRL',   'Riegel-Malterdingen',       8005090, 7.77085000, 48.1519690 ],
	[ 'RRIE',  'Riehen',                    8005091, 7.65201400, 47.5831570 ],
	[ 'RRID',  'Riehen Niederholz',         8005093, 7.63347000, 47.5694630 ],
	[ 'NRCK',  'Rieneck',                   8005092, 9.66413800, 50.0916640 ],
	[ 'DR',    'Riesa',                     8010297, 13.2877340, 51.3096540 ],
	[ 'SRI',   'Rieschweiler',              8005094, 7.50743800, 49.2447470 ],
	[ 'ARY',   'Rieseby',                   8005095, 9.82048900, 54.5413580 ],
	[ 'HRIE',  'Rieste',                    8005096, 8.01061300, 52.4847200 ],
	[ 'URIE',  'Riestedt',                  8012766, 11.3798560, 51.4840210 ],
	[ 'TRH',   'Rietheim(Württ)',          8005097, 8.78263600, 48.0390080 ],
	[ 'BRI',   'Rietschen',                 8012767, 14.7838870, 51.3986240 ],
	[ 'RRIM',  'Rimbach',                   8005098, 8.75729600, 49.6273480 ],
	[ 'URGS',  'Ringleben-Gebesee',         8012769, 10.9579930, 51.1040960 ],
	[ 'RRI',   'Ringsheim',                 8005101, 7.77303700, 48.2487260 ],
	[ 'ERIK',  'Rinkerode',                 8005102, 7.68938700, 51.8443830 ],
	[ 'RBTR',  'Rinklingen',                8079059, 8.67387400, 49.0367100 ],
	[ 'RRIT',  'Rinnthal',                  8005103, 7.92791800, 49.2170750 ],
	[ 'HRIN',  'Rinteln',                   8005104, 9.07781500, 52.1989360 ],
	[ 'RRB',   'Rippberg',                  8005105, 9.29118900, 49.6247220 ],
	[ 'URI',   'Ritschenhausen',            8012770, 10.4295060, 50.5128630 ],
	[ 'HRTH',  'Ritterhude',                8005107, 8.75388900, 53.1836330 ],
	[ 'SRC',   'Rockenhausen',              8005111, 7.81727000, 49.6283850 ],
	[ 'SROA',  'Rodalben',                  8005113, 7.63171200, 49.2392380 ],
	[ 'FRB',   'Rodenbach(Dillkr)',         8005116, 8.20526300, 50.7739910 ],
	[ 'FROD',  'Rodenbach(b Hanau)',        8004402, 9.01256000, 50.1472670 ],
	[ 'HRDK',  'Rodenkirchen(Oldb)',        8005119, 8.45479400, 53.3998410 ],
	[ 'DROW',  'Rodewisch',                 8012775, 12.3953370, 50.5286530 ],
	[ 'FDU',   'Rodgau-Dudenhofen',         8001567, 8.88448200, 50.0106610 ],
	[ 'FHHN',  'Rodgau-Hainhausen',         8002528, 8.87561100, 50.0402200 ],
	[ 'FJUE',  'Rodgau-Jügesheim',         8003131, 8.87895700, 50.0259840 ],
	[ 'FNRO',  'Rodgau-Nieder Roden',       8004351, 8.87121500, 49.9974420 ],
	[ 'FROL',  'Rodgau-Rollwald',           8005156, 8.84654500, 49.9879850 ],
	[ 'FWEK',  'Rodgau-Weiskirchen',        8006293, 8.87782800, 50.0525730 ],
	[ 'FRO',   'Rodheim v d Höhe',         8005120, 8.69580300, 50.2676040 ],
	[ 'NROD',  'Roding',                    8005121, 12.5157400, 49.2144800 ],
	[ 'LROD',  'Rodleben',                  8012777, 12.2147990, 51.8983570 ],
	[ 'WRGT',  'Roggentin',                 8012785, 12.2130860, 54.0734940 ],
	[ 'UROH',  'Rohr(Thür)',               8012787, 10.5158390, 50.5715880 ],
	[ 'MRBI',  'Rohrbach(Ilm)',             8000256, 11.5731770, 48.6058550 ],
	[ 'MROH',  'Rohrbach(Oberbay)',         8005145, 12.5514070, 48.2981590 ],
	[ 'RRST',  'Rohrbach(Pfalz)',           8005146, 8.14152000, 49.1380170 ],
	[ 'SRO',   'Rohrbach(Saar)',            8000319, 7.15739500, 49.2767370 ],
	[ 'MRFD',  'Rohrenfeld',                8005149, 11.2598090, 48.7211940 ],
	[ 'TRO',   'Roigheim',                  8005151, 9.34183100, 49.3608330 ],
	[ 'KROI',  'Roisdorf',                  8005152, 7.01614000, 50.7531810 ],
	[ 'LROI',  'Roitzsch(Bitterf)',         8012788, 12.2645400, 51.5711670 ],
	[ 'KROL',  'Rolandseck',                8005153, 7.20683500, 50.6313800 ],
	[ 'NRON',  'Rollhofen',                 8005154, 11.3355240, 49.5437160 ],
	[ 'TROM',  'Rommelshausen',             8005157, 9.31934400, 48.8155400 ],
	[ 'KROM',  'Rommerskirchen',            8005159, 6.69959000, 51.0399330 ],
	[ 'DRON',  'Ronneburg(Thür)',          8010301, 12.1817200, 50.8595550 ],
	[ 'HRBG',  'Ronnenberg',                8005160, 9.65178600, 52.3230730 ],
	[ 'FRON',  'Ronshausen',                8005161, 9.85442500, 50.9460160 ],
	[ 'FROS',  'Rosbach v d Höhe',         8005163, 8.70080000, 50.2986690 ],
	[ 'KROS',  'Rosbach(Sieg)',             8005164, 7.60876700, 50.7967680 ],
	[ 'NRNU',  'Rosenau(b Grafenau)',       8005166, 13.4084660, 48.8741320 ],
	[ 'TRBG',  'Rosenberg(Baden)',          8005168, 9.47142500, 49.4575830 ],
	[ 'EHW',   'Rosendahl-Holtwick',        8002972, 7.12256800, 51.9983910 ],
	[ 'MRO',   'Rosenheim',                 8000320, 12.1192020, 47.8500180 ],
	[ 'MROS',  'Rosenheim Hochschule',      8005173, 12.1041780, 47.8663040 ],
	[ 'WROW',  'Rosenwinkel',               8012792, 12.3431970, 53.0381940 ],
	[ 'WR',    'Rostock Hbf',               8010304, 12.1310790, 54.0782460 ],
	[ 'WRHO',  'Rostock Holbeinplatz',      8012805, 12.0994660, 54.0933000 ],
	[ 'WRHP',  'Rostock Parkstraße',       8012801, 12.1078900, 54.0852430 ],
	[ 'WRTF',  'Rostock Thierfelder Str.',  8079629, 12.0999100, 54.0778770 ],
	[ 'WRB',   'Rostock-Bramow',            8012803, 12.0905480, 54.1017460 ],
	[ 'WEV',   'Rostock-Evershagen',        8011523, 12.0685070, 54.1235520 ],
	[ 'WRK',   'Rostock-Kassebohm',         8012806, 12.1633160, 54.0794250 ],
	[ 'WLH',   'Rostock-Lichtenhagen',      8012221, 12.0708660, 54.1524030 ],
	[ 'WLKL',  'Rostock-Lütten Klein',     8012271, 12.0649850, 54.1382220 ],
	[ 'WRMA',  'Rostock-Marienehe',         8012807, 12.0800720, 54.1117740 ],
	[ 'WGMS',  'Rostock-Torfbrücke',       8012582, 12.2277350, 54.2417580 ],
	[ 'TRS',   'Rot am See',                8005179, 10.0303360, 49.2493930 ],
	[ 'RRM',   'Rot-Malsch',                8005181, 8.65221000, 49.2433850 ],
	[ 'TRY',   'Rotenbach(Enz)',            8070277, 8.57890300, 48.8301630 ],
	[ 'FROF',  'Rotenburg a.d. Fulda',      8005182, 9.73334400, 50.9978550 ],
	[ 'AROG',  'Rotenburg(Wümme)',         8000321, 9.39009800, 53.1123490 ],
	[ 'FRTN',  'Rotenhain',                 8005184, 7.89337500, 50.6016210 ],
	[ 'NRO',   'Roth',                      8005185, 11.0825080, 49.2412870 ],
	[ 'NROT',  'Rothenburg ob der Tauber',  8005190, 10.1907000, 49.3766900 ],
	[ 'NRBG',  'Rothenbürg',               8005189, 11.7731250, 50.3105650 ],
	[ 'UROT',  'Rothenstein(Saale)',        8012811, 11.6092230, 50.8511480 ],
	[ 'MRT',   'Rott(Inn)',                 8005194, 12.1361330, 47.9881710 ],
	[ 'TRR',   'Rottenacker',               8005195, 9.69436400, 48.2348440 ],
	[ 'URTB',  'Rottenbach',                8010305, 11.1698160, 50.6893430 ],
	[ 'TRT',   'Rottenburg(Neckar)',        8005197, 8.93554800, 48.4724300 ],
	[ 'NRTD',  'Rottendorf',                8005198, 10.0290940, 49.7919710 ],
	[ 'NRHN',  'Rottershausen',             8005199, 10.1663330, 50.1664410 ],
	[ 'TR',    'Rottweil',                  8000322, 8.63929500, 48.1653040 ],
	[ 'TRG',   'Rottweil Göllsdorf',       8005200, 8.65107800, 48.1600100 ],
	[ 'TRNF',  'Rottweil Neufra',           8004280, 8.67042000, 48.1268240 ],
	[ 'TRSA',  'Rottweil Saline',           8005202, 8.64560900, 48.1487100 ],
	[ 'SROB',  'Roßbach(Pfalz)',           8005172, 7.62325400, 49.5721120 ],
	[ 'UROS',  'Roßla',                    8012796, 11.0654870, 51.4628810 ],
	[ 'LR',    'Roßlau(Elbe)',             8010302, 12.2372620, 51.8846120 ],
	[ 'NRL',   'Roßtal',                   8005177, 10.8986320, 49.4006940 ],
	[ 'NRW',   'Roßtal Wegbrücke',        8005178, 10.8854140, 49.3947780 ],
	[ 'TRU',   'Rudersberg',                8007196, 9.53071600, 48.8818640 ],
	[ 'TRUN',  'Rudersberg Nord',           8070079, 9.53416100, 48.8876130 ],
	[ 'TRUO',  'Rudersberg-Oberndorf',      8007625, 9.54369900, 48.8917220 ],
	[ 'ERUD',  'Rudersdorf(Siegen)',        8005205, 8.14408300, 50.8391250 ],
	[ 'UR',    'Rudolstadt(Thür)',         8010306, 11.3391560, 50.7179970 ],
	[ 'URS',   'Rudolstadt-Schwarza',       8010307, 11.3281990, 50.6911190 ],
	[ 'BRU',   'Ruhland',                   8010308, 13.8700040, 51.4553190 ],
	[ 'BRUZ',  'Ruhlsdorf-Zerpenschleuse',  8012821, 13.5415110, 52.8432150 ],
	[ 'NRUF',  'Ruhmannsfelden',            8070664, 12.9915100, 48.9894130 ],
	[ 'MRPD',  'Ruhpolding',                8005222, 12.6490330, 47.7622510 ],
	[ 'MRUS',  'Ruhstorf',                  8005223, 13.3349490, 48.4336470 ],
	[ 'KRUM',  'Rumeln',                    8005225, 6.67597900, 51.3981130 ],
	[ 'EROL',  'Rummenohl',                 8005227, 7.52830600, 51.2778090 ],
	[ 'FRUK',  'Runkel',                    8005229, 8.15937000, 50.4052840 ],
	[ 'DRUG',  'Ruppertsgrün',             8012823, 12.1763920, 50.5750230 ],
	[ 'NRST',  'Rupprechtstegen',           8005231, 11.4804830, 49.5974370 ],
	[ 'SRUB',  'Ruschberg',                 8007886, 7.28618500, 49.6229090 ],
	[ 'ARWD',  'Ruschwedel',                8007845, 9.56004600, 53.4462160 ],
	[ 'TRUT',  'Rutesheim',                 8005236, 8.95955000, 48.7900170 ],
	[ 'WRU',   'Ruthenbeck',                8012824, 11.7111680, 53.5452450 ],
	[ 'LRI',   'Rätzlingen',               8012705, 11.1234090, 52.4090350 ],
	[ 'LRN',   'Röblingen am See',         8010299, 11.6685350, 51.4626030 ],
	[ 'NRTL',  'Rödental',                 8004633, 11.0313080, 50.2883660 ],
	[ 'NRTM',  'Rödental Mitte',           8005122, 11.0506720, 50.2957360 ],
	[ 'FORD',  'Rödermark-Ober Roden',     8000285, 8.82896100, 49.9736220 ],
	[ 'FUCH',  'Rödermark-Urberach',       8006031, 8.79815900, 49.9751370 ],
	[ 'DRDF',  'Rödlitz-Hohndorf',         8012781, 12.6540330, 50.7422520 ],
	[ 'MRMS',  'Röhrmoos',                 8005127, 11.4447700, 48.3333180 ],
	[ 'NRBH',  'Röhrnbach',                8070810, 13.5261340, 48.7370530 ],
	[ 'FROH',  'Rönshausen',               8005131, 9.74373000, 50.4784510 ],
	[ 'BRGT',  'Röntgental',               8081210, 13.5137990, 52.6487980 ],
	[ 'NROE',  'Röslau',                   8005133, 11.9940910, 50.0750970 ],
	[ 'KROE',  'Rösrath',                  8005134, 7.18266200, 50.9015490 ],
	[ 'KRST',  'Rösrath-Stümpen',         8005143, 7.15927000, 50.8986650 ],
	[ 'RRT',   'Röt',                      8005135, 8.39735600, 48.5554650 ],
	[ 'RROE',  'Rötenbach(Baden)',         8005136, 8.29005700, 47.8928300 ],
	[ 'HROT',  'Rötgesbüttel',            8005137, 10.5243200, 52.4161730 ],
	[ 'MRTA',  'Röthenbach(Allgäu)',      8005138, 9.95354300, 47.6206180 ],
	[ 'NRTH',  'Röthenbach(Oberpf)',       8005139, 11.9955830, 49.6235430 ],
	[ 'NRP',   'Röthenbach(Pegnitz)',      8005140, 11.2311040, 49.4794000 ],
	[ 'NRPE',  'Röthenbach-Seespitze',     8005142, 11.2614900, 49.4915240 ],
	[ 'NRPG',  'Röthenbach-Steinberg',     8005141, 11.2463570, 49.4833830 ],
	[ 'WRV',   'Rövershagen',              8010300, 12.2474460, 54.1755680 ],
	[ 'FRS',   'Rückersbacher Schlucht',   8005208, 9.05718600, 50.0196280 ],
	[ 'BRO',   'Rückersdorf',              8012816, 13.5742810, 51.5673580 ],
	[ 'NRUE',  'Rückersdorf(Mfr)',         8005209, 11.2317880, 49.4912020 ],
	[ 'FRDH',  'Rüdesheim(Rhein)',         8005213, 7.91541800, 49.9768900 ],
	[ 'WRZ',   'Rüdnitz',                  8012819, 13.6363400, 52.7177040 ],
	[ 'RRZH',  'Rülzheim Bf',              8005217, 8.29044600, 49.1608710 ],
	[ 'RRZD',  'Rülzheim Freizeitzentrum', 8005214, 8.27936500, 49.1515900 ],
	[ 'RRMM',  'Rümmingen',                8070524, 7.64070900, 47.6429260 ],
	[ 'KRUN',  'Ründeroth',                8005218, 7.46513200, 50.9950770 ],
	[ 'NRLB',  'Rüsselbach',               8005219, 11.2317710, 49.6087380 ],
	[ 'FRUE',  'Rüsselsheim',              8005220, 8.41358300, 49.9916390 ],
	[ 'FRUO',  'Rüsselsheim Opelwerk',     8005221, 8.40037300, 49.9880000 ],
	[ 'NSL',   'Saal(Donau)',               8005238, 11.9331950, 48.9024200 ],
	[ 'FSB',   'Saalburg(Taunus)',          8007851, 8.58649200, 50.2836090 ],
	[ 'US',    'Saalfeld(Saale)',           8010309, 11.3749870, 50.6503160 ],
	[ 'SSH',   'Saarbrücken Hbf',          8000323, 6.99102100, 49.2410650 ],
	[ 'SSO',   'Saarbrücken Ost',          8005241, 7.01878800, 49.2304250 ],
	[ 'SSB',   'Saarbrücken-Burbach',      8005243, 6.95708600, 49.2421670 ],
	[ 'SSAB',  'Saarburg(Bz Trier)',        8005245, 6.55703400, 49.6064550 ],
	[ 'SSLB',  'Saarhölzbach',             8005246, 6.60750000, 49.5164410 ],
	[ 'SSLS',  'Saarlouis Hbf',             8005247, 6.75016900, 49.3278300 ],
	[ 'BSAM',  'Saarmund',                  8081220, 13.1390050, 52.3235530 ],
	[ 'FSAA',  'Saasen',                    8005249, 8.88177400, 50.5940800 ],
	[ 'WSAA',  'Saatel',                    8012827, 12.7726800, 54.3003710 ],
	[ 'NSA',   'Sachsen(b Ansbach)',        8005250, 10.6614980, 49.2929900 ],
	[ 'LSAD',  'Sachsendorf(Calbe)',        8012830, 11.8655170, 51.8700540 ],
	[ 'BSAH',  'Sachsenhausen(Nordb)',      8012831, 13.2518670, 52.7722690 ],
	[ 'TSA',   'Sachsenheim',               8005253, 9.06315800, 48.9612920 ],
	[ 'WSAG',  'Sagard',                    8012832, 13.5649560, 54.5243790 ],
	[ 'ASAG',  'Sagehorn',                  8005256, 9.02239400, 53.0840500 ],
	[ 'TSAL',  'Salach',                    8005258, 9.73718300, 48.6893980 ],
	[ 'RSLM',  'Salem',                     8004029, 9.29720000, 47.7576730 ],
	[ 'MSAL',  'Sallach',                   8005259, 12.3605410, 48.8112700 ],
	[ 'SSMT',  'Salmtal',                   8005260, 6.83925400, 49.9216840 ],
	[ 'HSAL',  'Salzbergen',                8005262, 7.35052600, 52.3232500 ],
	[ 'HSB',   'Salzgitter-Bad',            8005265, 10.3723350, 52.0498240 ],
	[ 'HSI',   'Salzgitter-Immendorf',      8005269, 10.4418910, 52.1501010 ],
	[ 'HSL',   'Salzgitter-Lebenstedt',     8005270, 10.3324900, 52.1511550 ],
	[ 'HSRI',  'Salzgitter-Ringelheim',     8000325, 10.3148300, 52.0381580 ],
	[ 'HST',   'Salzgitter-Thiede',         8005274, 10.4936090, 52.1805530 ],
	[ 'HSW',   'Salzgitter-Watenstedt',     8005275, 10.4073980, 52.1501680 ],
	[ 'ESZK',  'Salzkotten',                8005276, 8.60048900, 51.6728750 ],
	[ 'LSW',   'Salzwedel',                 8010310, 11.1620350, 52.8581130 ],
	[ 'WSAM',  'Samtens',                   8012835, 13.2901770, 54.3541160 ],
	[ 'NSND',  'Sand(Niederbay)',           8005279, 12.6726420, 48.8971430 ],
	[ 'HSAN',  'Sande',                     8005282, 8.03151900, 53.4897960 ],
	[ 'ESDB',  'Sandebeck',                 8005283, 8.98695400, 51.8183710 ],
	[ 'HSAB',  'Sanderbusch',               8005285, 8.01477700, 53.5072470 ],
	[ 'LSL',   'Sandersleben(Anh)',         8010311, 11.5600200, 51.6790630 ],
	[ 'WSAF',  'Sandförde',                8012839, 13.9712730, 53.5639810 ],
	[ 'WSAN',  'Sandhagen(b Bad Dob)',      8012840, 11.7409090, 54.0527850 ],
	[ 'HSAK',  'Sandkrug',                  8005287, 8.25499300, 53.0544270 ],
	[ 'ASDW',  'Sandwehle',                 8005288, 8.75848200, 54.3257490 ],
	[ 'USG',   'Sangerhausen',              8010312, 11.2945150, 51.4798910 ],
	[ 'WSTZ',  'Sanitz(b Rostock)',         8012841, 12.3765880, 54.0750600 ],
	[ 'ESCI',  'Sanssouci',                 8005289, 7.87884400, 51.3536650 ],
	[ 'FLSR',  'Sarnau',                    8005291, 8.75604500, 50.8711960 ],
	[ 'WSAW',  'Sarnow',                    8012842, 12.2298710, 53.1172800 ],
	[ 'HSRD',  'Sarstedt',                  8005292, 9.84259200, 52.2326000 ],
	[ 'RSAS',  'Sasbach am Kaiserstuhl',    8007287, 7.62034500, 48.1387490 ],
	[ 'ESAS',  'Sassenroth',                8005293, 7.91524800, 50.7715690 ],
	[ 'WSZ',   'Sassnitz',                  8012843, 13.6379090, 54.5162840 ],
	[ 'TSAT',  'Satteldorf',                8005297, 10.0781550, 49.1784430 ],
	[ 'KSA',   'Satzvey',                   8005298, 6.71323700, 50.6228590 ],
	[ 'MSR',   'Sauerlach',                 8005299, 11.6547740, 47.9740610 ],
	[ 'MSGB',  'Saulgrub',                  8005302, 11.0253970, 47.6660900 ],
	[ 'FSLH',  'Saulheim',                  8004352, 8.15424900, 49.8738070 ],
	[ 'SSU',   'Schafbrücke',              8005306, 7.04923700, 49.2279400 ],
	[ 'MSFL',  'Schaftlach',                8005311, 11.6841230, 47.7954710 ],
	[ 'RSAI',  'Schaidt(Pfalz)',            8007857, 8.07977600, 49.0612380 ],
	[ 'MSCA',  'Schalchen',                 8005312, 12.5709820, 48.0590710 ],
	[ 'USCK',  'Schalkau',                  8012852, 11.0017310, 50.4005540 ],
	[ 'USKM',  'Schalkau Mitte',            8012854, 11.0086870, 50.3966180 ],
	[ 'ESMU',  'Schalksmühle',             8005316, 7.53275100, 51.2405880 ],
	[ 'TSKS',  'Schalkstetten',             8007072, 9.91133000, 48.6117980 ],
	[ 'RSAL',  'Schallstadt',               8005317, 7.75388800, 47.9559470 ],
	[ 'ESCA',  'Schameder',                 8005319, 8.29310200, 50.9975840 ],
	[ 'HSDL',  'Schandelah',                8005320, 10.6854030, 52.2672260 ],
	[ 'ASAZ',  'Scharbeutz',                8005321, 10.7457620, 54.0187430 ],
	[ 'DSS',   'Scharfenstein',             8012853, 13.0560070, 50.7028270 ],
	[ 'ESMD',  'Scharmede',                 8005322, 8.64524000, 51.7117900 ],
	[ 'WST',   'Scharstorf',                8012856, 12.2458470, 53.9700790 ],
	[ 'MSC',   'Schechen',                  8005327, 12.1267240, 47.9270510 ],
	[ 'ASL',   'Scheeßel',                 8005330, 9.49696300, 53.1658250 ],
	[ 'SSD',   'Scheidt(Saar)',             8005332, 7.05708300, 49.2440180 ],
	[ 'TSK',   'Schelklingen',              8005333, 9.73526700, 48.3716990 ],
	[ 'TSX',   'Schemmerberg',              8005334, 9.82903100, 48.1892320 ],
	[ 'RSZL',  'Schenkenzell',              8005335, 8.37188700, 48.3084250 ],
	[ 'TSEP',  'Scheppach',                 8005329, 9.43427800, 49.1618000 ],
	[ 'HSCD',  'Scherfede',                 8005336, 9.04794000, 51.5247380 ],
	[ 'ESCF',  'Scheuerfeld(Sieg)',         8005338, 7.83663600, 50.7918630 ],
	[ 'KSEV',  'Scheven',                   8005339, 6.59227000, 50.5596620 ],
	[ 'HSCI',  'Schieder',                  8005340, 9.15247500, 51.9224000 ],
	[ 'HSCB',  'Schierbrok',                8005343, 8.57900400, 53.0847090 ],
	[ 'LSCR',  'Schierke',                  8017022, 10.6780040, 51.7650730 ],
	[ 'MSLG',  'Schierling',                8070811, 12.1426630, 48.8318510 ],
	[ 'LSIS',  'Schierstedt',               8012862, 11.5211950, 51.7515260 ],
	[ 'RSD',   'Schifferstadt',             8000326, 8.36494500, 49.3929100 ],
	[ 'RSDS',  'Schifferstadt Süd',        8005345, 8.37731400, 49.3740890 ],
	[ 'SSWL',  'Schiffweiler',              8005346, 7.12934000, 49.3633710 ],
	[ 'RSCL',  'Schiltach',                 8005350, 8.33509300, 48.2912180 ],
	[ 'RSCM',  'Schiltach Mitte',           8005347, 8.34476600, 48.2912840 ],
	[ 'FSBN',  'Schimborn',                 8007280, 9.18681100, 50.0577640 ],
	[ 'DSWK',  'Schirgiswalde-Kirschau',    8012864, 14.4263450, 51.0805100 ],
	[ 'NSG',   'Schirnding',                8005352, 12.2287490, 50.0773000 ],
	[ 'LSD',   'Schkeuditz',                8012865, 12.2221690, 51.4023900 ],
	[ 'LSDW',  'Schkeuditz West',           8012863, 12.1956670, 51.4029100 ],
	[ 'LSP',   'Schkopau',                  8012867, 11.9918740, 51.3889600 ],
	[ 'HSCL',  'Schladen(Harz)',            8005355, 10.5501340, 52.0223640 ],
	[ 'KSLA',  'Schladern(Sieg)',           8005356, 7.59226400, 50.8070060 ],
	[ 'TSLT',  'Schlatt(Hohenz)',           8007222, 9.02520300, 48.3435440 ],
	[ 'TSLB',  'Schlechtbach',              8007195, 9.52636100, 48.8725490 ],
	[ 'BSFE',  'Schleife',                  8012870, 14.5310340, 51.5357000 ],
	[ 'ASW',   'Schleswig',                 8005362, 9.53814000, 54.4994570 ],
	[ 'RSG',   'Schliengen',                8005364, 7.56893700, 47.7615980 ],
	[
		'FSBA', 'Schlierbach(Schwalm-Eder-Kr.)', 8005365, 9.20144500,
		50.9687830
	],
	[ 'MSCS',  'Schliersee',                  8005367, 11.8595860, 47.7355810 ],
	[ 'ESHO',  'Schloß Holte',               8005369, 8.61057600, 51.9085420 ],
	[ 'RSLU',  'Schluchsee',                  8005371, 8.17712600, 47.8168680 ],
	[ 'FSUE',  'Schlüchtern',                8000891, 9.51003900, 50.3411770 ],
	[ 'BSHN',  'Schmachtenhagen',             8010319, 13.3367990, 52.7753090 ],
	[ 'USM',   'Schmalkalden',                8010315, 10.4405040, 50.7201810 ],
	[ 'USMS',  'Schmalkalden-Fachhochschule', 8012881, 10.4634870, 50.7164220 ],
	[ 'FSMU',  'Schmalnau',                   8005374, 9.78784700, 50.4560130 ],
	[ 'KSMI',  'Schmidtheim',                 8005378, 6.55208600, 50.4132390 ],
	[ 'TSHM',  'Schmiechen',                  8005379, 9.72038000, 48.3623560 ],
	[ 'TSHA',  'Schmiechen Albbahn',          8070974, 9.71528900, 48.3648970 ],
	[ 'MSCN',  'Schmiechen(Schwab)',          8005381, 10.9780870, 48.2130460 ],
	[ 'DSMI',  'Schmilka-Hirschmühle',       8012888, 14.2284190, 50.8899180 ],
	[ 'WSCM',  'Schmollensee',                8012892, 14.0772460, 53.9822720 ],
	[ 'DSML',  'Schmölln(Ol)',               8012890, 14.2279570, 51.1197550 ],
	[ 'DSM',   'Schmölln(Thür)',            8012889, 12.3548990, 50.8983190 ],
	[ 'NSAW',  'Schnabelwaid',                8000328, 11.5956600, 49.8104530 ],
	[ 'NSMA',  'Schnaittach Markt',           8005383, 11.3444400, 49.5569780 ],
	[ 'NSCB',  'Schneeberg im Odenwald',      8005386, 9.25080100, 49.6410990 ],
	[ 'BSB',   'Schneeberg(Mark)',            8012895, 14.3299170, 52.1645580 ],
	[ 'HSCG',  'Schnega',                     8000440, 10.8903860, 52.8690580 ],
	[ 'FSNH',  'Schneidhain',                 8007163, 8.45214000, 50.1727390 ],
	[ 'NSNE',  'Schnelldorf',                 8005388, 10.1784830, 49.1943250 ],
	[ 'ASDN',  'Schneverdingen',              8005390, 9.79886800, 53.1105700 ],
	[ 'NSY',   'Schney',                      8005391, 11.0736230, 50.1662020 ],
	[ 'NSNI',  'Schnitzmühle',               8070670, 12.9151580, 49.0704090 ],
	[ 'SSOF',  'Schoden-Ockfen',              8005392, 6.58097000, 49.6363770 ],
	[ 'MSDF',  'Schondorf(Bay)',              8005417, 11.0898470, 48.0528480 ],
	[ 'MSGU',  'Schongau',                    8005418, 10.9024590, 47.8123270 ],
	[ 'NSGN',  'Schonungen',                  8005400, 10.3049130, 50.0492040 ],
	[ 'RSCH',  'Schopfheim',                  8005420, 7.82267400, 47.6479700 ],
	[ 'RSCW',  'Schopfheim West',             8005425, 7.80171500, 47.6455410 ],
	[ 'TSPF',  'Schopfloch(b Freudenstadt)',  8005421, 8.54775400, 48.4537110 ],
	[ 'SSCP',  'Schopp',                      8005423, 7.68731700, 49.3588670 ],
	[ 'TSF',   'Schorndorf',                  8005424, 9.52631000, 48.8071500 ],
	[ 'TSFH',  'Schorndorf-Hammerschlag',     8007191, 9.53456600, 48.8076050 ],
	[ 'HHDM',  'Schortens-Heidmühle',        8002695, 7.94636700, 53.5421580 ],
	[ 'TSCH',  'Schrezheim',                  8005431, 10.1178800, 48.9511250 ],
	[ 'MSHN',  'Schrobenhausen',              8005432, 11.2592370, 48.5652670 ],
	[ 'TSZG',  'Schrozberg',                  8005433, 9.97490400, 49.3469160 ],
	[ 'ESCT',  'Schutzbach',                  8007080, 7.90387800, 50.7584910 ],
	[ 'WSN',   'Schwaan',                     8010322, 12.1178940, 53.9391880 ],
	[ 'NSC',   'Schwabach',                   8005439, 11.0353510, 49.3261950 ],
	[ 'NSCL',  'Schwabach-Limbach',           8005440, 11.0444220, 49.3382330 ],
	[ 'MSHH',  'Schwabhausen(b Dachau)',      8005442, 11.3647580, 48.3005170 ],
	[ 'MSMN',  'Schwabmünchen',              8005444, 10.7682910, 48.1786880 ],
	[ 'TSWA',  'Schwabsberg',                 8005445, 10.1388930, 48.9251900 ],
	[ 'NSAI',  'Schwaig',                     8005451, 11.2004420, 49.4714940 ],
	[ 'TSWO',  'Schwaigern Ost',              8070156, 9.06916400, 49.1405440 ],
	[ 'TSWG',  'Schwaigern(Württ)',          8005453, 9.05644000, 49.1383660 ],
	[ 'TSWW',  'Schwaigern(Württ) West',     8071002, 9.04247200, 49.1388130 ],
	[ 'TSWK',  'Schwaikheim',                 8005454, 9.35494300, 48.8683400 ],
	[ 'FSTS',  'Schwalbach(Taunus)Limes',     8005455, 8.52797000, 50.1543540 ],
	[ 'FSLN',  'Schwalbach(Taunus)Nord',      8005456, 8.53477700, 50.1598600 ],
	[ 'USWL',  'Schwallungen',                8012929, 10.3465140, 50.6893850 ],
	[ 'FWRA',  'Schwalmstadt-Wiera',          8006401, 9.13642100, 50.8819370 ],
	[ 'NSCH',  'Schwandorf',                  8000027, 12.1042190, 49.3261390 ],
	[ 'WSAH',  'Schwanheide',                 8012933, 10.6899930, 53.4281560 ],
	[ 'BSHE',  'Schwante',                    8012934, 13.0917330, 52.7346830 ],
	[ 'HSWS',  'Schwarmstedt',                8005457, 9.62475400, 52.6788800 ],
	[ 'USCG',  'Schwarzburg',                 8012937, 11.1810310, 50.6428170 ],
	[ 'NSBS',  'Schwarzenbach(Saale)',        8005466, 11.9358870, 50.2203740 ],
	[ 'NSW',   'Schwarzenbach(b Pressath)',   8005465, 11.9929010, 49.7247020 ],
	[ 'ASWA',  'Schwarzenbek',                8005468, 10.4847360, 53.5037330 ],
	[ 'RSW',   'Schwarzenberg',               8006715, 8.38385100, 48.5986720 ],
	[ 'DSCH',  'Schwarzenberg Hp',            8012938, 12.7864510, 50.5323680 ],
	[ 'DSC',   'Schwarzenberg(Erzg)',         8010323, 12.7868240, 50.5451190 ],
	[ 'DSCN',  'Schwarzenberg-Neuwelt',       8012939, 12.7657260, 50.5543790 ],
	[ 'NSDO',  'Schwarzenfeld(Opf)',          8005469, 12.1306370, 49.3927510 ],
	[ 'BSRO',  'Schwarzheide Ost',            8012941, 13.8907990, 51.4736490 ],
	[ 'BSKL',  'Schwarzkollm',                8012942, 14.1335660, 51.4431870 ],
	[ 'WSC',   'Schwedt(Oder)',               8012943, 14.2905070, 53.0630690 ],
	[ 'WSCT',  'Schwedt(Oder)Mitte',          8012944, 14.2715880, 53.0683230 ],
	[ 'SSWE',  'Schweich(DB)',                8005476, 6.74033500, 49.8310620 ],
	[ 'RSHF',  'Schweighofen',                8007860, 7.99922400, 49.0326860 ],
	[ 'DSKH',  'Schweikershain',              8012946, 12.9552220, 51.0373760 ],
	[ 'NS',    'Schweinfurt Hbf',             8000032, 10.2129190, 50.0353130 ],
	[ 'NSMT',  'Schweinfurt Mitte',           8005479, 10.2287860, 50.0401730 ],
	[ 'NSST',  'Schweinfurt Stadt',           8005481, 10.2442970, 50.0468080 ],
	[ 'DSU',   'Schweinsburg-Culten',         8012947, 12.3695880, 50.7871400 ],
	[ 'NSWF',  'Schweinsdorf',                8005485, 10.2270200, 49.4006900 ],
	[ 'KSWE',  'Schwelm',                     8000033, 7.28968100, 51.2905260 ],
	[ 'KSWW',  'Schwelm West',                8005488, 7.26961900, 51.2856460 ],
	[ 'MSWN',  'Schwenningen(Bay)',           8005489, 10.6428950, 48.6564600 ],
	[ 'RSCV',  'Schwenningen(Neckar)',        8005490, 8.53586200, 48.0597700 ],
	[ 'WSWN',  'Schwenzin',                   8012949, 12.6120180, 53.5361870 ],
	[ 'KSH',   'Schweppenburg-Heilbrunnen',   8071495, 7.30921800, 50.4660370 ],
	[ 'WS',    'Schwerin Hbf',                8010324, 11.4074550, 53.6347390 ],
	[ 'WSMI',  'Schwerin Mitte',              8012940, 11.4053340, 53.6269110 ],
	[ 'WSS',   'Schwerin Süd',               8012951, 11.3766360, 53.5742730 ],
	[ 'WSGN',  'Schwerin-Görries',           8010325, 11.3849350, 53.6093730 ],
	[ 'WSGR',  'Schwerin-Görries',           8010325, 11.3849350, 53.6093730 ],
	[ 'WSL',   'Schwerin-Lankow',             8012953, 11.3695360, 53.6566560 ],
	[ 'WSMH',  'Schwerin-Margaretenhof',      8012960, 11.3609730, 53.6585520 ],
	[ 'WSWZ',  'Schwerin-Warnitz',            8012954, 11.3455650, 53.6617000 ],
	[ 'WWST',  'Schwerin-Wüstmark',          8013354, 11.3996270, 53.5840450 ],
	[ 'ESRT',  'Schwerte(Ruhr)',              8000037, 7.55896000, 51.4422810 ],
	[ 'DSWOP', 'Schweta Bf',                  8070693, 13.0782250, 51.2407700 ],
	[ 'DSWO',  'Schweta Gasth',               8070692, 13.0845580, 51.2452260 ],
	[ 'RSZ',   'Schwetzingen',                8005494, 8.57867900, 49.3834340 ],
	[ 'TSBD',  'Schwieberdingen',             8007326, 9.07139600, 48.8705790 ],
	[ 'MSDG',  'Schwindegg',                  8005495, 12.2496990, 48.2731930 ],
	[ 'TSG',   'Schwäbisch Gmünd',          8000329, 9.78779500, 48.8010110 ],
	[ 'TSHL',  'Schwäbisch Hall',            8005449, 9.73335900, 49.1082100 ],
	[ 'TSHT',  'Schwäbisch Hall-Hessental',  8000330, 9.76737300, 49.0967320 ],
	[ 'RSST',  'Schwörstadt',                8005497, 7.87032800, 47.5910190 ],
	[ 'FSK',   'Schöllkrippen',              8007283, 9.24421400, 50.0858390 ],
	[ 'TSCS',  'Schömberg Stausee',          8072211, 8.77133500, 48.2112900 ],
	[ 'TSCB',  'Schömberg(b Balingen)',      8029359, 8.75850300, 48.2057430 ],
	[ 'DSN',   'Schöna',                     8012898, 14.2347190, 50.8759030 ],
	[ 'USU',   'Schönau(Hörsel)',           8012899, 10.4297790, 50.9452200 ],
	[ 'ASCB',  'Schönberg(Holstein)',        8070532, 10.3758350, 54.3874220 ],
	[ 'WSBG',  'Schönberg(Meckl)',           8012902, 10.9278700, 53.8533800 ],
	[ 'DSB',   'Schönberg(Vogtl)',           8010317, 11.9612590, 50.5284270 ],
	[ 'ASCS',  'Schönberger Strand',         8070533, 10.4127980, 54.4107360 ],
	[ 'BSBD',  'Schönborn(Doberl)',          8012903, 13.4680480, 51.6020080 ],
	[ 'LSBS',  'Schönebeck Süd',            8081260, 11.7373050, 52.0067520 ],
	[ 'LSB',   'Schönebeck(Elbe)',           8010318, 11.7331570, 52.0187940 ],
	[ 'LSBE',  'Schönebeck-Bad Salzelmen',   8012907, 11.7236270, 51.9983640 ],
	[ 'LSBF',  'Schönebeck-Felgeleben',      8013465, 11.7571480, 52.0007470 ],
	[ 'LSBO',  'Schönebeck-Frohse',          8081270, 11.7073840, 52.0339170 ],
	[ 'DSCK',  'Schöneck(Vogtl)',            8012908, 12.3433570, 50.3959880 ],
	[ 'DSCF',  'Schöneck(Vogtl) Ferienpark', 8000343, 12.3470440, 50.3895700 ],
	[ 'FBHM',  'Schöneck-Büdesheim',        8001248, 8.84360000, 50.2149510 ],
	[ 'FKIL',  'Schöneck-Kilianstädten',    8003255, 8.84042000, 50.2017870 ],
	[ 'FOBD',  'Schöneck-Oberdorfelden',     8004523, 8.82338500, 50.1961490 ],
	[ 'BSL',   'Schönerlinde',               8012910, 13.4286330, 52.6521820 ],
	[ 'HSWO',  'Schönewörde',               8005405, 10.6348990, 52.6281780 ],
	[ 'BSOE',  'Schönfließ(Mark) Dorf',     8012914, 14.4728140, 52.4370280 ],
	[ 'BSNF',  'Schönfließ(b Oranienburg)', 8081290, 13.3394190, 52.6650750 ],
	[ 'MSNG',  'Schöngeising',               8005406, 11.1920510, 48.1473700 ],
	[ 'LSH',   'Schönhausen(Elbe)',          8010321, 12.0400800, 52.5912540 ],
	[ 'ASCK',  'Schönkirchen Bf',            8007314, 10.2293290, 54.3328730 ],
	[ 'RSOM',  'Schönmünzach',              8005409, 8.36935400, 48.6053450 ],
	[ 'WSCN',  'Schönow(Angerm)',            8012918, 14.1538140, 53.1849460 ],
	[ 'USCS',  'Schönstedt',                 8012919, 10.5858230, 51.1207520 ],
	[ 'NSOE',  'Schönwald(Oberfr)',          8005412, 12.0966470, 50.1990550 ],
	[ 'BSWH',  'Schönwalde(Barnim)',         8081300, 13.4323760, 52.6801060 ],
	[ 'BSCH',  'Schönwalde(Spreewald)',      8012923, 13.7777230, 51.9907970 ],
	[ 'HSPP',  'Schöppenstedt',              8005413, 10.7720470, 52.1406920 ],
	[ 'ESHM',  'Schötmar',                   8005415, 8.75495100, 52.0699350 ],
	[ 'ASC',   'Schülldorf',                 8005435, 9.74780400, 54.2988630 ],
	[ 'USP',   'Schüptitz',                  8012927, 12.0296650, 50.7231690 ],
	[ 'HSTT',  'Schüttorf',                  8005436, 7.22061000, 52.3168400 ],
	[ 'DSEB',  'Sebnitz(Sachs)',              8012959, 14.2725630, 50.9759520 ],
	[ 'FSN',   'Sechshelden',                 8005498, 8.25266100, 50.7488920 ],
	[ 'KSEC',  'Sechtem',                     8005499, 6.95745400, 50.7957110 ],
	[ 'RSE',   'Seckach',                     8000042, 9.33846900, 49.4411570 ],
	[ 'BSE',   'Seddin',                      8013492, 12.9854520, 52.2918400 ],
	[ 'BSEO',  'Sedlitz Ost',                 8010183, 14.0552520, 51.5531010 ],
	[ 'USE',   'Seebach(Mühlhausen)',        8012961, 10.5211930, 51.1700120 ],
	[ 'WAB',   'Seebad Ahlbeck',              8012962, 14.1878590, 53.9354780 ],
	[ 'WHF',   'Seebad Heringsdorf',          8012963, 14.1695860, 53.9498360 ],
	[ 'USB',   'Seebergen',                   8012965, 10.7927020, 50.9292700 ],
	[ 'RSEE',  'Seebrugg',                    8005502, 8.19111500, 47.8035160 ],
	[ 'BSEE',  'Seefeld(Mark)',               8012966, 13.6759870, 52.6182940 ],
	[ 'MSH',   'Seefeld-Hechendorf',          8005504, 11.1987300, 48.0413700 ],
	[ 'MSEG',  'Seeg',                        8005505, 10.6139810, 47.6552670 ],
	[ 'BSFD',  'Seegefeld',                   8081586, 13.1168100, 52.5524800 ],
	[ 'LSNA',  'Seehausen(Altm)',             8012967, 11.7435150, 52.8857750 ],
	[ 'WSEE',  'Seehausen(Uckermark)',        8012968, 13.8842010, 53.2213670 ],
	[ 'MSEB',  'Seeleiten-Berggeist',         8005506, 11.1658300, 47.6709840 ],
	[ 'BSLO',  'Seelow(Mark)',                8012973, 14.3944130, 52.5381980 ],
	[ 'BGSW',  'Seelow-Gusow',                8011788, 14.3514620, 52.5593030 ],
	[ 'WSEV',  'Seelvitz',                    8012974, 13.5612810, 54.3676110 ],
	[ 'HS',    'Seelze',                      8005507, 9.59431400, 52.3916750 ],
	[ 'DSRH',  'Seerhausen',                  8012975, 13.2400790, 51.2702710 ],
	[ 'HSSN',  'Seesen',                      8000043, 10.1738980, 51.8872630 ],
	[ 'MSE',   'Seeshaupt',                   8005508, 11.2870300, 47.8227830 ],
	[ 'SSE',   'Sehlem(Kr Wittlich)',         8005510, 6.82342100, 49.9069590 ],
	[ 'DSEH',  'Sehma',                       8012976, 12.9938050, 50.5354530 ],
	[ 'HSEN',  'Sehnde',                      8005511, 9.96252800, 52.3180750 ],
	[ 'MSBD',  'Seiboldsdorf',                8005512, 12.6369880, 47.8529670 ],
	[ 'DSFS',  'Seifersdorf',                 8012977, 13.6476010, 50.9399670 ],
	[ 'DSFH',  'Seifhennersdorf',             8012979, 14.6137060, 50.9357980 ],
	[ 'DSEN',  'Seitschen',                   8012981, 14.3253320, 51.1537670 ],
	[ 'NSN',   'Selb Nord',                   8005516, 12.1346050, 50.1789150 ],
	[ 'NSS',   'Selb Stadt',                  8005517, 12.1263050, 50.1742160 ],
	[ 'NSP',   'Selb-Plößberg',             8005518, 12.1198840, 50.1889480 ],
	[ 'NSLZ',  'Selbitz',                     8005520, 11.7484050, 50.3164760 ],
	[ 'KSHS',  'Selhausen',                   8007835, 6.43935600, 50.8656950 ],
	[
		'NSLIM', 'Seligenstadt Mainschleifenbahn',
		8070859, 10.1020300,
		49.8570080
	],
	[ 'FSEL',  'Seligenstadt(Hess)',        8005522, 8.96747200, 50.0414600 ],
	[ 'NSLI',  'Seligenstadt(b Würzburg)', 8005523, 10.1024540, 49.8542600 ],
	[ 'WSIN',  'Sellin(Rügen) Ost',        8012983, 13.6976620, 54.3713440 ],
	[ 'WSIW',  'Sellin(Rügen) West',       8070258, 13.6809130, 54.3758920 ],
	[ 'ASLL',  'Sellstedt',                 8007811, 8.72305700, 53.5155290 ],
	[ 'ESEM',  'Selm',                      8005525, 7.45340600, 51.7066440 ],
	[ 'ESEB',  'Selm-Beifang',              8005526, 7.45460900, 51.6936720 ],
	[ 'USEL',  'Seltendorf',                8012984, 11.0640950, 50.3868970 ],
	[ 'MSED',  'Senden',                    8005532, 10.0505020, 48.3240160 ],
	[ 'BSN',   'Senftenberg',               8010327, 14.0039050, 51.5269410 ],
	[ 'ESEL',  'Sennelager',                8005534, 8.71370400, 51.7702400 ],
	[ 'ESES',  'Sennestadt',                8005535, 8.56747700, 51.9405820 ],
	[ 'TSE',   'Sennfeld',                  8005536, 9.38051800, 49.3787620 ],
	[ 'WSES',  'Serams',                    8012986, 13.5821280, 54.3779760 ],
	[ 'SSER',  'Serrig',                    8005539, 6.56998100, 49.5771320 ],
	[ 'TSER',  'Sersheim',                  8005540, 9.01850800, 48.9589160 ],
	[ 'NSF',   'Seubersdorf',               8005543, 11.6281230, 49.1676480 ],
	[ 'FSG',   'Seulberg',                  8005544, 8.64600500, 50.2419060 ],
	[ 'NSE',   'Seulbitz',                  8005545, 11.8687710, 50.2098200 ],
	[ 'NSYB',  'Seybothenreuth',            8005547, 11.7055420, 49.8944170 ],
	[ 'RSIB',  'Siebeldingen-Birkweiler',   8005551, 8.04256500, 49.2092700 ],
	[ 'ESIH',  'Siedlinghausen',            8005555, 8.47383500, 51.2577610 ],
	[ 'PQSI',  'Siegburg Bahnhof',          8075556, 7.20310000, 50.7934750 ],
	[ 'KSIB',  'Siegburg/Bonn',             8005556, 7.20302600, 50.7939150 ],
	[ 'RSGB',  'Siegelsbach',               8007438, 9.08738600, 49.2712270 ],
	[ 'NSDF',  'Siegelsdorf',               8005557, 10.8755190, 49.5063500 ],
	[ 'ESIE',  'Siegen',                    8000046, 8.01650800, 50.8759390 ],
	[ 'EHTG',  'Siegen-Geisweid',           8003018, 8.01435200, 50.9155810 ],
	[ 'ESW',   'Siegen-Weidenau',           8003020, 8.02984200, 50.8959660 ],
	[ 'MSGD',  'Siegsdorf',                 8005559, 12.6460060, 47.8218270 ],
	[ 'ASID',  'Sierksdorf',                8005561, 10.7691080, 54.0685230 ],
	[ 'SSBG',  'Siersburg',                 8005562, 6.66536200, 49.3616960 ],
	[ 'KSIH',  'Siershahn',                 8000060, 7.77138000, 50.4858570 ],
	[ 'TSY',   'Siglingen',                 8005566, 9.30533600, 49.2974350 ],
	[ 'TSIG',  'Sigmaringen',               8000069, 9.22185100, 48.0869840 ],
	[ 'TSID',  'Sigmaringendorf',           8005568, 9.26093500, 48.0689010 ],
	[ 'TSIH',  'Sigmaringendorf',           8005568, 9.26093500, 48.0689010 ],
	[ 'ESIL',  'Silbach',                   8005569, 8.48112400, 51.2236700 ],
	[ 'USI',   'Silberhausen',              8012993, 10.3424100, 51.3194250 ],
	[ 'LSIB',  'Silberhütte NE',           8017023, 11.0916860, 51.6290920 ],
	[ 'DSBS',  'Silberstraße',             8012996, 12.5496150, 50.6620540 ],
	[ 'MSBI',  'Simbach(Inn)',              8000072, 13.0230120, 48.2627260 ],
	[ 'NSHU',  'Simmelsdorf-Hüttenbach',   8005572, 11.3416710, 49.5984590 ],
	[ 'FSMH',  'Simtshausen',               8005573, 8.70485600, 50.9369180 ],
	[ 'TSI',   'Sindelfingen',              8005574, 8.99907500, 48.7038910 ],
	[ 'KSID',  'Sindorf',                   8005575, 6.68110600, 50.9037070 ],
	[ 'KSIU',  'Sindorf',                   8005575, 6.68110600, 50.9037070 ],
	[ 'RSII',  'Singen Industriegebiet',    8079616, 8.87213100, 47.7594500 ],
	[ 'RSIS',  'Singen Landesgartenschau',  8005560, 8.82704600, 47.7607370 ],
	[ 'RSI',   'Singen(Hohentwiel)',        8000073, 8.84038300, 47.7584380 ],
	[ 'USGN',  'Singen(Thür)',             8012998, 11.0672630, 50.7278040 ],
	[ 'FSL',   'Singlis',                   8005576, 9.32377300, 51.0586050 ],
	[ 'FSI',   'Sinn',                      8005577, 8.32493200, 50.6498270 ],
	[ 'RSMM',  'Sinsheim Museum/Arena',     8070097, 8.89993200, 49.2412390 ],
	[ 'RSM',   'Sinsheim(Elsenz) Hbf',      8005578, 8.87510000, 49.2503530 ],
	[ 'RSZM',  'Sinzheim',                  8005587, 8.15842900, 48.7598800 ],
	[ 'RSZN',  'Sinzheim Nord',             8005588, 8.16979200, 48.7708190 ],
	[ 'KSIZ',  'Sinzig(Rhein)',             8005580, 7.25827900, 50.5469820 ],
	[ 'NSIH',  'Sinzing',                   8005581, 12.0376530, 48.9907960 ],
	[ 'RSIN',  'Sipplingen',                8005582, 9.09552400, 47.7955870 ],
	[ 'USDF',  'Sitzendorf-Unterweißbach', 8013000, 11.1553990, 50.6273130 ],
	[ 'ESOT',  'Soest',                     8000076, 8.10458900, 51.5784190 ],
	[ 'DSOL',  'Sohl',                      8013002, 12.2828080, 50.2751310 ],
	[ 'DSOH',  'Sohland',                   8013003, 14.4319260, 51.0537380 ],
	[ 'KSGR',  'Solingen Grünewald',       8005597, 7.07900400, 51.1638990 ],
	[ 'KSO',   'Solingen Hbf',              8000087, 7.00418700, 51.1607660 ],
	[ 'KSM',   'Solingen Mitte',            8005598, 7.08871600, 51.1657400 ],
	[ 'KSV',   'Solingen Vogelpark',        8006714, 6.99239800, 51.1667110 ],
	[ 'KSS',   'Solingen-Schaberg',         8005590, 7.12818200, 51.1632060 ],
	[ 'USOL',  'Sollstedt',                 8013004, 10.5298480, 51.4136730 ],
	[ 'FSOL',  'Solms',                     8005592, 8.40669300, 50.5455850 ],
	[ 'MSO',   'Solnhofen',                 8005593, 10.9939830, 48.8919870 ],
	[ 'LSK',   'Solpke',                    8013005, 11.2941780, 52.5004160 ],
	[ 'ASON',  'Soltau Nord',               8005594, 9.86101300, 53.0013640 ],
	[ 'HSO',   'Soltau(Han)',               8000088, 9.83110900, 52.9830170 ],
	[ 'HSDK',  'Soltendieck',               8000445, 10.7614160, 52.8742090 ],
	[ 'ESON',  'Sondern',                   8005600, 7.84257800, 51.0730850 ],
	[ 'TSOD',  'Sondernach',                8005601, 9.61884900, 48.3669600 ],
	[ 'RSOH',  'Sondernheim',               8005602, 8.36027200, 49.1949810 ],
	[ 'USH',   'Sondershausen',             8010329, 10.8491930, 51.3700540 ],
	[ 'USO',   'Sonneberg(Thür)Hbf',       8013008, 11.1688480, 50.3550780 ],
	[ 'USON',  'Sonneberg(Thür)Nord',      8013009, 11.2075500, 50.3654780 ],
	[ 'USOO',  'Sonneberg(Thür)Ost',       8013010, 11.2012930, 50.3522520 ],
	[ 'USOW',  'Sonneberg(Thür)West',      8013011, 11.1590710, 50.3680310 ],
	[ 'MSHM',  'Sontheim(Schwab)',          8005607, 10.3453720, 48.0121720 ],
	[ 'TSON',  'Sontheim-Brenz',            8005608, 10.2848630, 48.5593240 ],
	[ 'MSF',   'Sonthofen',                 8005609, 10.2723440, 47.5132410 ],
	[ 'FSON',  'Sontra',                    8005610, 9.93093400, 51.0721530 ],
	[ 'LSPH',  'Sophienhof',                8017040, 10.7901970, 51.6412340 ],
	[ 'LSOR',  'Sorge',                     8017024, 10.6970940, 51.6932910 ],
	[ 'AS',    'Sottrum',                   8005613, 9.25003000, 53.1012420 ],
	[ 'MSY',   'Soyen',                     8005614, 12.2097440, 48.1080850 ],
	[ 'TSP',   'Spaichingen',               8005616, 8.74014700, 48.0689870 ],
	[ 'TSPM',  'Spaichingen Mitte',         8005617, 8.73042500, 48.0785020 ],
	[ 'ASPS',  'Sparrieshoop',              8007066, 9.68520700, 53.7812940 ],
	[ 'KSPA',  'Spay',                      8005622, 7.64547300, 50.2555440 ],
	[ 'DSPR',  'Spechtritz',                8013015, 13.6388170, 50.9526350 ],
	[ 'FSPE',  'Speele',                    8005623, 9.56355900, 51.3774580 ],
	[ 'SSPE',  'Speicher',                  8005624, 6.61591100, 49.9291840 ],
	[ 'NSKN',  'Speikern',                  8005625, 11.3369920, 49.5286390 ],
	[ 'RSP',   'Speyer Hbf',                8005628, 8.42794900, 49.3241190 ],
	[ 'RSPN',  'Speyer Nord-West',          8005626, 8.41926300, 49.3335920 ],
	[ 'KSPI',  'Spich',                     8005629, 7.11491600, 50.8267270 ],
	[ 'NSPU',  'Spiegelau',                 8005630, 13.3592600, 48.9177230 ],
	[ 'RSPG',  'Spielberg',                 8079048, 8.47462600, 48.8976520 ],
	[ 'WSP',   'Sponholz',                  8013017, 13.3664010, 53.5638540 ],
	[ 'WSPO',  'Spornitz',                  8013018, 11.7109760, 53.4123510 ],
	[ 'BSP',   'Spremberg',                 8010330, 14.3974980, 51.5747570 ],
	[ 'FSPR',  'Sprendlingen(Rheinhess)',   8005637, 7.98179500, 49.8589470 ],
	[ 'FSPRN', 'Sprendlingen(Rheinhess)',   8005637, 7.98179500, 49.8589470 ],
	[ 'FSPRS', 'Sprendlingen(Rheinhess)',   8005637, 7.98179500, 49.8589470 ],
	[ 'HSPR',  'Springe',                   8005638, 9.55623800, 52.2151500 ],
	[ 'ASP',   'Sprötze',                  8005640, 9.81224500, 53.3094290 ],
	[ 'MSAB',  'St Alban',                  8005639, 11.1053590, 47.9641330 ],
	[ 'KB  M', 'St Augustin Markt',         8070025, 7.18789200, 50.7766580 ],
	[ 'DEG',   'St Egidien',                8010331, 12.6225560, 50.7895680 ],
	[ 'RSGO',  'St Georgen(Schwarzw)',      8005644, 8.34195500, 48.1238130 ],
	[ 'FSGO',  'St Goar',                   8005645, 7.71458700, 50.1501550 ],
	[ 'FSGH',  'St Goarshausen',            8005646, 7.71424600, 50.1560350 ],
	[ 'RSIG',  'St Ilgen-Sandhausen',       8005648, 8.66871500, 49.3412680 ],
	[ 'SSI',   'St Ingbert',                8005649, 7.11081400, 49.2747630 ],
	[ 'MKL',   'St Koloman',                8005652, 11.8829650, 48.2437470 ],
	[ 'MMG',   'St Mang',                   8005653, 10.3255390, 47.7088990 ],
	[ 'ASD',   'St Michaelisdonn',          8005655, 9.11800600, 53.9896200 ],
	[ 'MOTN',  'St Ottilien',               8005656, 11.0483900, 48.0945440 ],
	[ 'SSTO',  'St Thomas',                 8005658, 6.60107600, 50.0697880 ],
	[ 'SSWD',  'St Wendel',                 8005659, 7.16529300, 49.4669520 ],
	[ 'AST',   'Stade',                     8000089, 9.47700800, 53.5961430 ],
	[ 'DWH',   'Stadt Wehlen(Sachs)',       8013022, 14.0322420, 50.9537180 ],
	[ 'FSTA',  'Stadtallendorf',            8005661, 9.01527800, 50.8254320 ],
	[ 'HSHG',  'Stadthagen',                8005662, 9.18942600, 52.3328370 ],
	[ 'USTM',  'Stadtilm',                  8013023, 11.0708170, 50.7669560 ],
	[ 'HSDF',  'Stadtoldendorf',            8005665, 9.62051900, 51.8810020 ],
	[ 'NSPO',  'Stadtprozelten',            8005666, 9.41097900, 49.7835950 ],
	[ 'USR',   'Stadtroda',                 8013025, 11.7227920, 50.8682160 ],
	[ 'FST',   'Staffel',                   8005668, 8.04595000, 50.3995300 ],
	[ 'RST',   'Stahringen',                8077773, 8.97627500, 47.7876630 ],
	[ 'SSTB',  'Stambach',                  8005673, 7.45662300, 49.2391710 ],
	[ 'NSM',   'Stammbach',                 8005674, 11.7048940, 50.1546330 ],
	[ 'LSBU',  'Stapelburg',                8013432, 10.6717210, 51.9002810 ],
	[ 'MST',   'Starnberg',                 8005676, 11.3436700, 47.9959630 ],
	[ 'MSNO',  'Starnberg Nord',            8005675, 11.3473860, 48.0059750 ],
	[ 'DSTU',  'Stauchitz',                 8013029, 13.2119200, 51.2429140 ],
	[ 'SSTH',  'Staudernheim',              8005678, 7.69310300, 49.7805820 ],
	[ 'RSTF',  'Staufen',                   8007332, 7.72834300, 47.8850270 ],
	[ 'RSTS',  'Staufen Süd',              8007333, 7.72968100, 47.8776350 ],
	[ 'LSF',   'Staßfurt',                 8010332, 11.5878980, 51.8512580 ],
	[ 'HSTF',  'Stederdorf(Kr Uelzen)',     8005682, 10.5927020, 52.9074280 ],
	[ 'NSWH',  'Stegenwaldhaus',            8005686, 11.7968090, 50.3162600 ],
	[ 'WHDS',  'Steilküste/Wittenbeck',    8011847, 11.7937710, 54.1447680 ],
	[ 'MSTN',  'Stein(Traun)',              8005687, 12.5461240, 47.9853540 ],
	[ 'DSTI',  'Steina',                    8013033, 13.0226570, 51.1033590 ],
	[ 'RSNA',  'Steinach(Baden)',           8005688, 8.05646900, 48.2989920 ],
	[ 'USTN',  'Steinach(Thür)',           8013034, 11.1586440, 50.4327240 ],
	[ 'USTA',  'Steinach(Thür)Süd',       8013036, 11.1667810, 50.4230510 ],
	[
		'NSTN', 'Steinach(b Rothenburg ob der Tauber)',
		8000091, 10.2735350, 49.4532180
	],
	[ 'SSTA', 'Steinalben',              8005689, 7.65148400, 49.3162470 ],
	[ 'FSA',  'Steinau(Straße)',        8005690, 9.44316200, 50.3143490 ],
	[ 'NSD',  'Steinbach am Wald',       8005692, 11.3829220, 50.4416480 ],
	[ 'USTH', 'Steinbach-Hallenberg',    8013037, 10.5580860, 50.6931630 ],
	[ 'MSA',  'Steinebach',              8005699, 11.2068120, 48.0611840 ],
	[ 'FSFZ', 'Steinefrenz',             8005700, 7.93888800, 50.4484200 ],
	[ 'RSTN', 'Steinen',                 8005701, 7.74156100, 47.6416040 ],
	[ 'LSR',  'Steinerne Renne',         8017025, 10.7270110, 51.8167000 ],
	[ 'HSFD', 'Steinfeld(Oldb)',         8005703, 8.19815100, 52.5927970 ],
	[ 'RSFL', 'Steinfeld(Pfalz)',        8007858, 8.03936900, 49.0446750 ],
	[ 'LSFD', 'Steinfeld(Stendal)',      8013039, 11.7286170, 52.6147340 ],
	[ 'EBGO', 'Steinfurt-Borghorst',     8001096, 7.39753900, 52.1187370 ],
	[ 'EBFT', 'Steinfurt-Burgsteinfurt', 8000062, 7.32934000, 52.1473840 ],
	[ 'EGRK', 'Steinfurt-Grottenkamp',   8005712, 7.37592100, 52.1232490 ],
	[ 'ESTG', 'Steinhagen(Westf)',       8005704, 8.42078700, 52.0174190 ],
	[
		'ESBS',  'Steinhagen(Westf) Bielef. Str.',
		8005702, 8.43645300,
		52.0114160
	],
	[ 'WSNB',  'Steinhausen-Neuburg',        8013040, 11.5963340, 53.9423190 ],
	[ 'FSHM',  'Steinheim(Main)',            8005706, 8.90685200, 50.1213690 ],
	[ 'HSTM',  'Steinheim(Westf)',           8005708, 9.08844700, 51.8681770 ],
	[ 'MSHG',  'Steinhöring',               8005709, 12.0312840, 48.0834870 ],
	[ 'DSPH',  'Steinpleis',                 8010333, 12.3940740, 50.7089760 ],
	[ 'RSS',   'Steinsfurt',                 8005714, 8.90797800, 49.2358220 ],
	[ 'RSTE',  'Steinweiler',                8005713, 8.13069600, 49.1208440 ],
	[ 'SSTW',  'Steinwenden',                8005715, 7.52478500, 49.4541750 ],
	[ 'NSTW',  'Steinwiesen Bf',             8005716, 11.4622460, 50.2924410 ],
	[ 'ASTE',  'Stelle',                     8005717, 10.1090230, 53.3876990 ],
	[ 'LS',    'Stendal',                    8010334, 11.8544120, 52.5947230 ],
	[ 'LSV',   'Stendal Vorbf',              8013046, 11.8712900, 52.5958360 ],
	[ 'LSS',   'Stendal-Stadtsee',           8010335, 11.8367280, 52.6068370 ],
	[ 'DSTN',  'Stenn',                      8013047, 12.4416350, 50.6787580 ],
	[ 'FSTZ',  'Sterbfritz',                 8005720, 9.62541700, 50.3128680 ],
	[ 'WSE',   'Sternfeld',                  8013051, 13.1504200, 53.8247750 ],
	[ 'LSTH',  'Sternhaus-Haferfeld',        8017026, 11.1325860, 51.6985950 ],
	[ 'LSTE',  'Sternhaus-Ramberg',          8017027, 11.1274980, 51.6903110 ],
	[ 'FSZH',  'Sterzhausen',                8005722, 8.70869800, 50.8615540 ],
	[ 'TSTT',  'Stetten (b. Haigerloch)',    8070548, 8.81274100, 48.3534150 ],
	[ 'TSHG',  'Stetten am Heuchelberg',     8005724, 9.01472600, 49.1369130 ],
	[ 'TSTD',  'Stetten(Donau)',             8005723, 8.87235400, 48.0228140 ],
	[ 'MSTS',  'Stetten(Schwab)',            8005725, 10.4360400, 48.0276630 ],
	[ 'TSTE',  'Stetten-Beinstein',          8005726, 9.35245000, 48.8119240 ],
	[ 'RSF',   'Stettfeld(Baden)',           8007134, 8.64374000, 49.1789060 ],
	[ 'LSTI',  'Stiege',                     8017028, 10.8811910, 51.6607980 ],
	[ 'ESKA',  'Stift Keppel-Allenbach',     8005731, 8.09223000, 50.9779610 ],
	[ 'RSTK',  'Stockach NE',                8077774, 9.00573100, 47.8500900 ],
	[ 'NSOK',  'Stockau',                    8005734, 11.6667180, 49.9195760 ],
	[ 'MSD',   'Stockdorf',                  8005735, 11.4008450, 48.0932580 ],
	[ 'FSTH',  'Stockhausen(Lahn)',          8005736, 8.32536500, 50.5405360 ],
	[ 'NSTH',  'Stockheim(Oberfr)',          8005737, 11.2821330, 50.3068220 ],
	[ 'NSTU',  'Stockheim(Unterfr)',         8005738, 10.2712290, 50.4599520 ],
	[ 'FSTK',  'Stockstadt(Main)',           8005739, 9.06336900, 49.9766270 ],
	[ 'FSTR',  'Stockstadt(Rhein)',          8005740, 8.47244000, 49.8094330 ],
	[ 'KST G', 'Stolberg(Rheinl)Gbf',        8099506, 6.22488000, 50.7975550 ],
	[ 'KST',   'Stolberg(Rheinl)Hbf',        8000348, 6.21747800, 50.7944800 ],
	[ 'KST P', 'Stolberg(Rheinl)Hbf',        8000348, 6.21747800, 50.7944800 ],
	[ 'KST B', 'Stolberg(Rheinl)Hbf Gl.27',  8098348, 6.21900900, 50.7945260 ],
	[ 'KST E', 'Stolberg(Rheinl)Hbf Gl.44',  8098349, 6.21843900, 50.7948000 ],
	[ 'KSTT',  'Stolberg-Altstadt',          8005741, 6.23053800, 50.7642590 ],
	[ 'KSTM',  'Stolberg-Mühlener Bahnhof', 8005745, 6.22389800, 50.7735890 ],
	[ 'KSTR',  'Stolberg-Rathaus',           8005743, 6.22984500, 50.7685540 ],
	[ 'KSTS',  'Stolberg-Schneidmühle',     8005744, 6.21901200, 50.7849040 ],
	[
		'DSTOS', 'Stollberg Schlachthofstraße', 8017415, 12.7787820,
		50.7142290
	],
	[ 'DSTO',  'Stollberg(Sachs)',            8010337, 12.7735490, 50.7093100 ],
	[ 'DSTL',  'Stolpen',                     8013057, 14.0872500, 51.0370510 ],
	[ 'KSOM',  'Stommeln',                    8005746, 6.75246600, 51.0180920 ],
	[ 'BSTW',  'Storkow(Mark)',               8013058, 13.9209000, 52.2516320 ],
	[ 'TSGZ',  'Storzingen',                  8005747, 9.12708500, 48.1348810 ],
	[ 'USHM',  'Stotternheim',                8013061, 11.0483240, 51.0523510 ],
	[ 'WSR',   'Stralsund Hbf',               8010338, 13.0773210, 54.3086260 ],
	[ 'WSRR',  'Stralsund Rügendamm',        8013062, 13.1075220, 54.3053220 ],
	[ 'WSRB',  'Stralsund-Grünhufe',         8011778, 13.0439300, 54.3042980 ],
	[ 'WSB',   'Strasburg(Uckerm)',           8010339, 13.7452720, 53.5151010 ],
	[ 'NST',   'Straubing',                   8000095, 12.5740940, 48.8769780 ],
	[ 'NSTT',  'Straubing-Ost',               8006745, 12.5922480, 48.8764070 ],
	[ 'BST',   'Strausberg',                  8010341, 13.8336110, 52.5322040 ],
	[ 'BSTN',  'Strausberg Nord',             8013064, 13.9084760, 52.5901460 ],
	[ 'BSTR',  'Strausberg Stadt',            8081420, 13.8881330, 52.5769800 ],
	[ 'BHGM',  'Strausberg-Hegermühle',      8080680, 13.8666070, 52.5483750 ],
	[ 'USF',   'Straußfurt',                 8010342, 10.9875070, 51.1631440 ],
	[ 'MSMS',  'Straß-Moos',                 8005749, 11.0503150, 48.7113210 ],
	[ 'LSTR',  'Straßberg(Harz)',            8017029, 11.0437810, 51.6202090 ],
	[ 'LSGL',  'Straßberg-Glasebach',        8084109, 11.0493580, 51.6182150 ],
	[ 'TSTR',  'Straßberg-Winterlingen',     8005750, 9.08771800, 48.1787470 ],
	[ 'NSK',   'Straßkirchen',               8005752, 12.7207460, 48.8336150 ],
	[ 'WSTK',  'Strohkirchen',                8013069, 11.3184630, 53.3983860 ],
	[ 'NSU',   'Strullendorf',                8005760, 10.9616700, 49.8455500 ],
	[ 'ESTU',  'Struthütten',                8005761, 7.97330900, 50.7814400 ],
	[ 'FSY',   'Stryck',                      8005762, 8.62939800, 51.2824720 ],
	[ 'HSUB',  'Stubben',                     8005763, 8.78051900, 53.4057930 ],
	[ 'WSBB',  'Stubbenfelde',                8087027, 14.0335150, 54.0280740 ],
	[ 'TSBH',  'Stubersheim',                 8007071, 9.92037700, 48.5937920 ],
	[ 'LSTF',  'Stumsdorf',                   8010343, 12.0668590, 51.6162340 ],
	[ 'TSEB',  'Stuttgart Ebitzweg',          8005766, 9.23170100, 48.8039380 ],
	[ 'TSFS',  'Stuttgart Feuersee',          8006699, 9.16627300, 48.7727680 ],
	[ 'TFL',   'Stuttgart Flughafen/Messe',   8005768, 9.19263000, 48.6906480 ],
	[ 'TS',    'Stuttgart Hbf',               8000096, 9.18163500, 48.7840840 ],
	[ 'TS  T', 'Stuttgart Hbf (tief)',        8098096, 9.17980800, 48.7829990 ],
	[ 'TSNS',  'Stuttgart Neckarpark',        8006743, 9.24159500, 48.7921730 ],
	[ 'TSN',   'Stuttgart Nord',              8005767, 9.18802600, 48.8037690 ],
	[ 'TSNR',  'Stuttgart Nord',              8005767, 9.18802600, 48.8037690 ],
	[ 'TSNU',  'Stuttgart Nürnberger Str.',  8004357, 9.23485800, 48.8064230 ],
	[ 'TSS',   'Stuttgart Schwabstr.',        8006698, 9.15695900, 48.7702550 ],
	[ 'TSMI',  'Stuttgart Stadtmitte',        8006700, 9.17292500, 48.7762290 ],
	[ 'TSUN',  'Stuttgart Universität',      8006513, 9.10539800, 48.7458370 ],
	[ 'TSC',   'Stuttgart-Bad Cannstatt',     8005769, 9.21753100, 48.8013770 ],
	[ 'TSFE',  'Stuttgart-Feuerbach',         8005770, 9.16938200, 48.8136730 ],
	[ 'TSZ F', 'Stuttgart-Feuerbach',         8005770, 9.16938200, 48.8136730 ],
	[ 'TSM',   'Stuttgart-Münster',          8005771, 9.21586000, 48.8207240 ],
	[ 'TSOM',  'Stuttgart-Obertürkheim',     8005772, 9.26788900, 48.7620130 ],
	[ 'TSRO',  'Stuttgart-Rohr',              8005773, 9.10832800, 48.7179020 ],
	[ 'TSSM',  'Stuttgart-Sommerrain',        8005774, 9.24832700, 48.8152700 ],
	[ 'TSU',   'Stuttgart-Untertürkheim',    8005775, 9.25056900, 48.7797510 ],
	[ 'TSUH',  'Stuttgart-Untertürkheim',    8005775, 9.25056900, 48.7797510 ],
	[ 'TSU P', 'Stuttgart-Untertürkheim',    8005775, 9.25056900, 48.7797510 ],
	[ 'TSV',   'Stuttgart-Vaihingen',         8005776, 9.11322600, 48.7262790 ],
	[ 'TSZAH', 'Stuttgart-Zazenhausen',       8005777, 9.19953900, 48.8360340 ],
	[ 'TSZ',   'Stuttgart-Zuffenhausen',      8005778, 9.16673900, 48.8294150 ],
	[ 'TSOS',  'Stuttgart-Österfeld',        8005779, 9.11677400, 48.7376510 ],
	[ 'RSTU',  'Stühlingen',                 8005764, 8.45136800, 47.7470300 ],
	[ 'UST',   'Stützerbach',                8013071, 10.8579150, 50.6394790 ],
	[ 'WSBN',  'Subzin-Liessow',              8013072, 12.3476230, 53.8919190 ],
	[ 'ASU',   'Suchsdorf',                   8005781, 10.0912640, 54.3496050 ],
	[ 'HSUD',  'Suderburg',                   8005780, 10.4327900, 52.9048920 ],
	[ 'ASUP',  'Suerhop',                     8005788, 9.85515400, 53.3159030 ],
	[ 'USL',   'Suhl',                        8010345, 10.6828260, 50.6051450 ],
	[ 'USLH',  'Suhl-Heinrichs',              8013077, 10.6384540, 50.6020980 ],
	[ 'WSU',   'Sukow(b Schwerin)',           8013079, 11.5595580, 53.5547850 ],
	[ 'TSUM',  'Sulmingen',                   8079100, 9.86319200, 48.1519370 ],
	[ 'TSUL',  'Sulz(Neckar)',                8005791, 8.63674800, 48.3664850 ],
	[ 'MSBH',  'Sulzbach(Inn)',               8005793, 13.3820170, 48.4546890 ],
	[ 'NSUZ',  'Sulzbach(Main)',              8005794, 9.14653100, 49.9179730 ],
	[ 'TSBM',  'Sulzbach(Murr)',              8005795, 9.50040900, 48.9994610 ],
	[ 'SSZ',   'Sulzbach(Saar)',              8005796, 7.05506200, 49.2995610 ],
	[ 'SSZA',  'Sulzbach(Saar)Altenwald',     8005797, 7.07887600, 49.3120780 ],
	[ 'FSZ',   'Sulzbach(Taunus)',            8005798, 8.52798900, 50.1298330 ],
	[ 'FSZN',  'Sulzbach(Taunus)Nord',        8005799, 8.51819500, 50.1393990 ],
	[ 'NSR',   'Sulzbach-Rosenberg',          8005800, 11.7392770, 49.4994780 ],
	[ 'NSRH',  'Sulzbach-Rosenberg Hütte',   8005801, 11.7752990, 49.4890360 ],
	[ 'MSUG',  'Sulzberg',                    8005802, 10.3639350, 47.6752140 ],
	[ 'RSFD',  'Sulzfeld(Baden)',             8005805, 8.85254400, 49.1081730 ],
	[ 'KODE',  'Swisttal-Odendorf',           8004616, 6.87976400, 50.6511620 ],
	[ 'HSYK',  'Syke',                        8005809, 8.80978600, 52.9161600 ],
	[ 'ESYL',  'Sylbach',                     8005810, 8.76552900, 52.0268840 ],
	[ 'DSY',   'Syrau',                       8013080, 12.0853130, 50.5447690 ],
	[ 'ESYH',  'Sythen',                      8005811, 7.22652600, 51.7717600 ],
	[ 'USAE',  'Sättelstädt',               8012826, 10.4803380, 50.9459140 ],
	[ 'LSOL',  'Söllichau',                  8013001, 12.6540310, 51.6334560 ],
	[ 'RSLA',  'Söllingen Kapellenstraße',  8070865, 8.54961800, 48.9839560 ],
	[ 'RSLR',  'Söllingen Reetzstr.',        8007866, 8.54079300, 48.9910530 ],
	[ 'RSL',   'Söllingen(b Karlsr)',        8005585, 8.54354300, 48.9877540 ],
	[ 'RSLV',  'Söllingen(b Karlsr)',        8005585, 8.54354300, 48.9877540 ],
	[ 'USD',   'Sömmerda',                   8010328, 11.1275320, 51.1651860 ],
	[ 'ASOE',  'Sörup',                      8005586, 9.66991200, 54.7166620 ],
	[ 'ASUE',  'Süderbrarup',                8005782, 9.77090700, 54.6374090 ],
	[ 'ASDD',  'Süderdeich',                 8005783, 8.91124700, 54.1981850 ],
	[ 'ANBS',  'Süderlügum',                8005789, 8.88932700, 54.8709970 ],
	[ 'WSLT',  'Sülstorf',                   8013073, 11.3880390, 53.5139980 ],
	[ 'TSUE',  'Sülzbach',                   8005786, 9.34045800, 49.1485500 ],
	[ 'TSUS',  'Sülzbach Schule',            8005792, 9.35145700, 49.1450630 ],
	[ 'USUE',  'Sülzenbrücken',             8013074, 10.8958730, 50.8873910 ],
	[ 'NSUE',  'Sünching',                   8005787, 12.3567690, 48.8841590 ],
	[ 'TSD',   'Süßen',                     8005790, 9.76028000, 48.6836410 ],
	[ 'STB',   'Taben',                       8005812, 6.60031600, 49.5527470 ],
	[ 'MTCH',  'Tacherting',                  8005813, 12.5673360, 48.0787470 ],
	[ 'TTM',   'Tamm(Württ)',                8005820, 9.12582800, 48.9216050 ],
	[ 'LTH',   'Tangerhütte',                8013083, 11.8099430, 52.4338690 ],
	[ 'LTM',   'Tangermünde',                8013084, 11.9699570, 52.5457410 ],
	[ 'LTMW',  'Tangermünde West',           8013085, 11.9604540, 52.5477360 ],
	[ 'DTA',   'Tanndorf',                    8013087, 12.8483930, 51.1614660 ],
	[ 'ATAK',  'Tanneneck',                   8007051, 9.94329700, 53.7553270 ],
	[ 'TTA',   'Tannheim(Württ)',            8005823, 10.0969200, 47.9949550 ],
	[ 'UTA',   'Tannroda',                    8013089, 11.2471490, 50.8624460 ],
	[ 'WTA',   'Tantow',                      8013090, 14.3479260, 53.2692750 ],
	[ 'MTPF',  'Tapfheim',                    8005824, 10.6940780, 48.6792080 ],
	[ 'ATP',   'Tarp',                        8005825, 9.39859900, 54.6648150 ],
	[ 'ATAT',  'Tating',                      8005826, 8.70951200, 54.3228470 ],
	[ 'DTB',   'Taubenheim(Spree)',           8013092, 14.4806370, 51.0422000 ],
	[ 'TTB',   'Tauberbischofsheim',          8005827, 9.65829400, 49.6236320 ],
	[ 'MTA',   'Tauberfeld',                  8005828, 11.2756910, 48.8192380 ],
	[ 'LTC',   'Taucha(Leipzig)',             8013093, 12.4857240, 51.3794590 ],
	[ 'MTU',   'Taufkirchen',                 8005831, 11.6092520, 48.0515520 ],
	[ 'LTNH',  'Tautenhain',                  8013095, 12.6795300, 51.0898390 ],
	[ 'MTE',   'Tegernsee',                   8007632, 11.7573940, 47.7136890 ],
	[ 'LTE',   'Teicha',                      8013097, 11.9591800, 51.5544550 ],
	[ 'BT',    'Teichland',                   8012445, 14.4238130, 51.8186130 ],
	[ 'MTO',   'Teisendorf',                  8005833, 12.8344520, 47.8493970 ],
	[ 'NTEN',  'Teisnach',                    8070666, 12.9942680, 49.0393750 ],
	[ 'NTRS',  'Teisnach Rohde&Schwarz',      8005839, 12.9921500, 49.0319300 ],
	[ 'ETEL',  'Telgte',                      8005834, 7.78087600, 51.9811930 ],
	[ 'BTL',   'Teltow',                      8013100, 13.3004410, 52.3882820 ],
	[ 'BTLS',  'Teltow Stadt',                8080450, 13.2766230, 52.3969060 ],
	[ 'STS',   'Temmels',                     8005835, 6.46252300, 49.6884790 ],
	[ 'WT',    'Templin',                     8010347, 13.4914810, 53.1123450 ],
	[ 'WTV',   'Templin Stadt',               8010117, 13.5092410, 53.1171310 ],
	[ 'RTMU',  'Teningen-Mundingen',          8005836, 7.82440800, 48.1287770 ],
	[ 'WTHN',  'Teschenhagen',                8013104, 13.3742330, 54.3893670 ],
	[ 'WTOW',  'Teschow',                     8013105, 11.6379590, 53.9943540 ],
	[ 'WTI',   'Tessin',                      8013106, 12.4626140, 54.0320170 ],
	[ 'WTIW',  'Tessin West',                 8079604, 12.4425700, 54.0344360 ],
	[ 'WTE',   'Teterow',                     8010348, 12.5779660, 53.7684370 ],
	[ 'UTEU',  'Teuchern',                    8010349, 12.0165420, 51.1338580 ],
	[ 'DTF',   'Teufelsmühle',               8013537, 14.7517920, 50.8532980 ],
	[ 'LTT',   'Teutschenthal',               8013110, 11.7827380, 51.4643580 ],
	[ 'LTTO',  'Teutschenthal Ost',           8013111, 11.8198210, 51.4657490 ],
	[ 'LTL',   'Thale Hbf',                   8013112, 11.0310480, 51.7460470 ],
	[ 'LTLM',  'Thale Musestieg',             8013125, 11.0468800, 51.7514340 ],
	[ 'STWF',  'Thaleischweiler-Fröschen',   8005843, 7.57814100, 49.2613740 ],
	[ 'TTL',   'Thalfingen(b Ulm)',           8005845, 10.0478530, 48.4329820 ],
	[ 'DTL',   'Thalheim (b Oschatz)',        8070690, 13.0897380, 51.2810570 ],
	[ 'DTAL',  'Thalheim(Erzgeb)',            8013113, 12.8493450, 50.6965980 ],
	[ 'MTMA',  'Thann-Matzbach',              8005852, 12.0474600, 48.2665100 ],
	[ 'NTAS',  'Thansüß',                   8005855, 11.9378450, 49.6222650 ],
	[ 'DTH',   'Tharandt',                    8013114, 13.5921110, 50.9828720 ],
	[ 'RTG',   'Thayngen',                    8005856, 8.70430000, 47.7455020 ],
	[ 'STN',   'Theisbergstegen',             8005857, 7.44837300, 49.5189780 ],
	[ 'LT',    'Theißen',                    8013115, 12.1066260, 51.0904290 ],
	[ 'UTH',   'Themar',                      8010350, 10.6175210, 50.5067150 ],
	[ 'DWIE',  'Thermalbad Wiesenbad',        8013116, 13.0449580, 50.6191450 ],
	[ 'ATHS',  'Thesdorf',                    8005858, 9.81383700, 53.6443720 ],
	[ 'TTI',   'Thiergarten(Hohenz)',         8007867, 9.09562900, 48.0854130 ],
	[ 'BTHR',  'Thyrow',                      8013123, 13.2596340, 52.2472280 ],
	[ 'NTHM',  'Thüngersheim',               8005864, 9.84029800, 49.8779850 ],
	[ 'KTH',   'Thür',                       8005865, 7.27708000, 50.3588080 ],
	[ 'ATB',   'Tiebensee',                   8005867, 9.01922900, 54.2194870 ],
	[ 'DTFN',  'Tiefenau',                    8013124, 13.4139040, 51.3906890 ],
	[ 'NTFB',  'Tiefenbach(b Passau)',        8026544, 13.4230800, 48.6150200 ],
	[ 'LTF',   'Tiefenbachmühle',            8017030, 10.8135150, 51.6360870 ],
	[ 'RTI',   'Tiengen(Hochrhein)',          8005871, 8.27200300, 47.6354710 ],
	[ 'ATIM',  'Timmendorferstrand',          8005874, 10.7622700, 53.9942120 ],
	[ 'RTIT',  'Titisee',                     8005876, 8.15506900, 47.9034020 ],
	[ 'MWSL',  'Tittmoning-Wiesmühl',        8006422, 12.7448980, 48.0239090 ],
	[ 'LTG',   'Torgau',                      8010351, 12.9911340, 51.5630360 ],
	[ 'WTO',   'Torgelow',                    8013131, 14.0087580, 53.6346200 ],
	[ 'ATM',   'Tornesch',                    8005887, 9.71497000, 53.6973130 ],
	[ 'ATST',  'Tostedt',                     8005888, 9.73201300, 53.2720460 ],
	[ 'STT',   'Traben-Trarbach',             8005889, 7.12072200, 49.9515650 ],
	[ 'NTB',   'Trabitz',                     8005890, 11.8946210, 49.8014670 ],
	[ 'FTH',   'Trais-Horloff',               8005891, 8.91096900, 50.4505900 ],
	[ 'RT',    'Trasadingen',                 8005892, 8.43680400, 47.6652380 ],
	[ 'WTH',   'Trassenheide',                8013132, 13.8685170, 54.0813780 ],
	[ 'WTM',   'Trassenmoor',                 8013133, 13.8678100, 54.0910460 ],
	[ 'MTRD',  'Traundorf',                   8005893, 12.6398790, 47.8383730 ],
	[ 'MTRT',  'Traunreut',                   8005894, 12.5897680, 47.9650680 ],
	[ 'MTS',   'Traunstein',                  8000116, 12.6388010, 47.8697270 ],
	[ 'MTSK',  'Traunstein Klinikum',         8005873, 12.6334420, 47.8745570 ],
	[ 'BTN',   'Trebbin',                     8013137, 13.2303820, 52.2176180 ],
	[ 'LTRL',  'Treben-Lehma',                8013138, 12.4409470, 51.0469350 ],
	[ 'NTG',   'Trebgast',                    8005895, 11.5521120, 50.0659790 ],
	[ 'LTB',   'Trebitz(Elbe)',               8013139, 12.7589540, 51.7538030 ],
	[ 'LTRB',  'Trebitz(Könnern)',           8013140, 11.7630920, 51.7049910 ],
	[ 'BTZ',   'Trebnitz(Mark)',              8013141, 14.2165040, 52.5382620 ],
	[ 'FTRE',  'Trechtingshausen',            8005896, 7.85235900, 50.0090420 ],
	[ 'STK',   'Treis-Karden',                8003179, 7.29963500, 50.1798360 ],
	[ 'MTL',   'Treuchtlingen',               8000122, 10.9081590, 48.9612670 ],
	[ 'DTRE',  'Treuen',                      8013144, 12.3018590, 50.5479350 ],
	[ 'BTZN',  'Treuenbrietzen',              8013145, 12.8579110, 52.0919190 ],
	[ 'BTZS',  'Treuenbrietzen Süd',         8013146, 12.8809160, 52.0806090 ],
	[ 'FTS',   'Treysa',                      8000129, 9.18567300, 50.9106610 ],
	[ 'HTRI',  'Triangel',                    8005901, 10.5782400, 52.5095060 ],
	[ 'RTR',   'Triberg',                     8005902, 8.23680600, 48.1400040 ],
	[ 'UTB',   'Triebes',                     8013150, 12.0233060, 50.6880440 ],
	[ 'NTRI',  'Triefenried',                 8005903, 13.0526860, 48.9696690 ],
	[ 'STR',   'Trier Hbf',                   8000134, 6.65245300, 49.7568460 ],
	[ 'STRS',  'Trier Süd',                  8005905, 6.63688300, 49.7446630 ],
	[ 'NTF',   'Triesdorf',                   8005907, 10.6791440, 49.2009190 ],
	[ 'UTR',   'Triptis',                     8010352, 11.8721730, 50.7408820 ],
	[ 'TTRA',  'Trochtelfingen ALB-GOLD',     8007147, 9.24591600, 48.3288510 ],
	[ 'TTRF',  'Trochtelfingen(Hohenz)',      8070557, 9.24626800, 48.3075420 ],
	[ 'TTO',   'Trochtelfingen(b Bopfingen)', 8005908, 10.4018230, 48.8383650 ],
	[ 'KT',    'Troisdorf',                   8000135, 7.15089200, 50.8139220 ],
	[ 'KTR',   'Trompet',                     8005910, 6.66910700, 51.4134890 ],
	[ 'UTRO',  'Tromsdorf',                   8013152, 11.4812680, 51.1184950 ],
	[ 'TTR',   'Trossingen Bahnhof',          8005911, 8.58515400, 48.0876640 ],
	[ 'TTR H', 'Trossingen Bahnhof',          8005911, 8.58515400, 48.0876640 ],
	[ 'TTRS',  'Trossingen Stadt',            8007646, 8.63154700, 48.0740370 ],
	[ 'MTSB',  'Trostberg',                   8005912, 12.5556460, 48.0247370 ],
	[ 'MTUL',  'Tulling',                     8005924, 12.0600490, 48.0828650 ],
	[ 'TTU',   'Tuttlingen',                  8000163, 8.79854200, 47.9805790 ],
	[ 'TTUG',  'Tuttlingen Gänsäcker',      8005946, 8.78123300, 47.9646630 ],
	[ 'TTUN',  'Tuttlingen Nord',             8000456, 8.82373700, 47.9926050 ],
	[ 'TTUS',  'Tuttlingen Schulen',          8005925, 8.80116600, 47.9873350 ],
	[ 'TTUZ',  'Tuttlingen Zentrum',          8079056, 8.80943500, 47.9856150 ],
	[ 'MTZ',   'Tutzing',                     8005927, 11.2728900, 47.9071420 ],
	[ 'FTW',   'Twiste',                      8005928, 8.96401100, 51.3362600 ],
	[ 'HT',    'Twistringen',                 8005929, 8.64483200, 52.7918800 ],
	[ 'MTG',   'Töging(Inn)',                8005883, 12.5948700, 48.2590150 ],
	[ 'ATG',   'Tönning',                    8005885, 8.93760100, 54.3141390 ],
	[ 'UTP',   'Töppeln',                    8013129, 12.0061610, 50.8908550 ],
	[ 'TT',    'Tübingen Hbf',               8000141, 9.05540700, 48.5158110 ],
	[ 'TTW',   'Tübingen West',              8005916, 9.03824900, 48.5200450 ],
	[ 'TTD',   'Tübingen-Derendingen',       8005917, 9.05059000, 48.5034860 ],
	[ 'TTLU',  'Tübingen-Lustnau',           8005918, 9.09487600, 48.5240480 ],
	[ 'MTFD',  'Türkenfeld',                 8005920, 11.0772770, 48.1047250 ],
	[ 'MTHB',  'Türkheim(Bay)Bf',            8000144, 10.6174390, 48.0456900 ],
	[ 'STM',   'Türkismühle',               8000154, 7.11461500, 49.5803580 ],
	[ 'MTLG',  'Tüßling',                   8005923, 12.5887010, 48.2123190 ],
	[ 'EUBD',  'Ubbedissen',                  8005930, 8.63757900, 51.9884470 ],
	[ 'RUO',   'Ubstadt Ort',                 8007133, 8.62555300, 49.1567480 ],
	[ 'RUOS',  'Ubstadt Salzbrunnenstr',      8085003, 8.63302500, 49.1551900 ],
	[ 'RUOU',  'Ubstadt Uhlandstr.',          8070098, 8.62882700, 49.1627130 ],
	[ 'RUW',   'Ubstadt-Weiher',              8005931, 8.62333500, 49.1670210 ],
	[ 'LUS',   'Uchtspringe',                 8013158, 11.5922430, 52.5436740 ],
	[ 'UUD',   'Uder',                        8013159, 10.0621490, 51.3670420 ],
	[ 'LUEB',  'Uebigau',                     8013160, 13.2965190, 51.5854210 ],
	[ 'WUM',   'Ueckermünde',                8013162, 14.0540800, 53.7339230 ],
	[ 'WUMH',  'Ueckermünde Stadthafen',     8013156, 14.0522330, 53.7362020 ],
	[ 'HU',    'Uelzen',                      8000168, 10.5530530, 52.9697810 ],
	[ 'NU',    'Uffenheim',                   8005947, 10.2428870, 49.5512640 ],
	[ 'MUF',   'Uffing a Staffelsee',         8005948, 11.1589540, 47.7201500 ],
	[ 'TUH',   'Uhingen',                     8005949, 9.58552800, 48.7086050 ],
	[ 'RUDM',  'Uhldingen-Mühlhofen',        8004595, 9.24841900, 47.7369970 ],
	[ 'FUR',   'Uhlerborn',                   8005950, 8.14258400, 50.0106730 ],
	[ 'UUS',   'Uhlstädt',                   8013164, 11.4626620, 50.7416420 ],
	[ 'BUD',   'Uhsmannsdorf',                8013165, 14.8943090, 51.3281370 ],
	[ 'DUD',   'Ulbersdorf',                  8013168, 14.2198010, 50.9556210 ],
	[ 'TU',    'Ulm Hbf',                     8000170, 9.98222700, 48.3994370 ],
	[ 'TUO',   'Ulm Ost',                     8005952, 9.99463100, 48.4071590 ],
	[ 'TUDT',  'Ulm-Donautal',                8005954, 9.94035500, 48.3663400 ],
	[ 'TU  F', 'Ulm-Söflingen',              8005955, 9.95884900, 48.4027260 ],
	[ 'AUBS',  'Ulzburg Süd',                8007052, 9.97289200, 53.7734600 ],
	[ 'MURB',  'Umrathshausen Bf',            8005961, 12.3206360, 47.8187720 ],
	[ 'MURO',  'Umrathshausen Ort',           8005962, 12.3269660, 47.8057410 ],
	[ 'RUN',   'Unadingen',                   8005963, 8.39788600, 47.8811660 ],
	[ 'NUDF',  'Undorf',                      8005966, 11.9391380, 49.0271400 ],
	[ 'NUND',  'Unfriedsdorf',                8005967, 11.7525780, 50.1995370 ],
	[ 'FUNG',  'Ungedanken',                  8005968, 9.21897100, 51.1246560 ],
	[ 'KUN',   'Unkel',                       8005970, 7.21967800, 50.6029920 ],
	[ 'EUN',   'Unna',                        8000171, 7.69285800, 51.5389820 ],
	[ 'EUNW',  'Unna West',                   8003925, 7.67643100, 51.5389800 ],
	[ 'EUK',   'Unna-Königsborn',            8005971, 7.68780800, 51.5532800 ],
	[ 'FUKO',  'Unnau-Korb',                  8005972, 7.88882900, 50.6541680 ],
	[ 'MUAG',  'Unterammergau',               8005975, 11.0300510, 47.6174640 ],
	[ 'NUA',   'Unterasbach',                 8005976, 10.9853900, 49.4166910 ],
	[ 'MUA',   'Unteraschau',                 8005977, 12.6978080, 47.9229560 ],
	[ 'TUE',   'Unterelchingen',              8005983, 10.1001910, 48.4529890 ],
	[ 'MUFG',  'Unterföhring',               8005986, 11.6467720, 48.1903100 ],
	[ 'RUG',   'Untergimpern',                8007436, 9.01196400, 49.2690210 ],
	[ 'MUGR',  'Untergrainau',                8017042, 11.0428210, 47.4811170 ],
	[ 'TUG',   'Untergriesheim',              8005989, 9.22277900, 49.2651040 ],
	[ 'RURB',  'Untergrombach',               8005990, 8.54829000, 49.0876510 ],
	[ 'MUH',   'Unterhaching',                8005991, 11.6123590, 48.0649620 ],
	[ 'RUH',   'Unterharmersbach',            8007103, 8.08996600, 48.3541390 ],
	[ 'MUHN',  'Unterhausen(Bay)',            8005993, 11.1002880, 48.7167730 ],
	[ 'NUT',   'Unterheckenhofen',            8005995, 11.0561540, 49.2135170 ],
	[ 'TUJM',  'Unterjesingen Mitte',         8006002, 8.98173600, 48.5246810 ],
	[ 'TUJS',  'Unterjesingen Sandäcker',    8006003, 8.98826100, 48.5233060 ],
	[ 'TUK',   'Unterkochen',                 8005997, 10.1264930, 48.8150080 ],
	[ 'UUTL',  'Unterlemnitz',                8010354, 11.6238410, 50.4693420 ],
	[ 'TUL',   'Unterlenningen',              8005998, 9.46055500, 48.5652550 ],
	[ 'UUZ',   'Unterloquitz',                8013171, 11.3919750, 50.5804460 ],
	[ 'HUNL',  'Unterlüß',                  8006001, 10.2999060, 52.8343150 ],
	[ 'KUM',   'Untermaubach-Schlagstein',    8007822, 6.46044800, 50.7268530 ],
	[ 'UUM',   'Untermaßfeld',               8013172, 10.4154750, 50.5366330 ],
	[ 'DUN',   'Unterneudorf',                8013173, 12.9746100, 50.4936930 ],
	[ 'TURB',  'Unterreichenbach',            8006008, 8.71128400, 48.8268580 ],
	[ 'MUSM',  'Unterschleißheim',           8006688, 11.5686280, 48.2737000 ],
	[ 'NUST',  'Untersteinach(Bayr)',         8006016, 11.6898620, 49.9688840 ],
	[
		'NUS', 'Untersteinach(b Stadtsteinach)', 8006017, 11.5281220,
		50.1298460
	],
	[ 'SUSZ', 'Untersulzbach',     8006019, 7.66365400, 49.5225370 ],
	[ 'UUW',  'Unterwellenborn',   8013174, 11.4350730, 50.6592530 ],
	[ 'DUW',  'Unterwiesenthal',   8013175, 12.9891180, 50.4277600 ],
	[ 'RUOE', 'Unteröwisheim Bf', 8007140, 8.66898600, 49.1463420 ],
	[
		'RUOEL', 'Unteröwisheim M.-Luther-Str.',
		8079149, 8.66202000,
		49.1464840
	],
	[ 'AUP',  'Uphusum',                8006026, 8.86282100, 54.8385940 ],
	[ 'TUA',  'Urbach(b Schorndorf)',   8006030, 9.57373400, 48.8049560 ],
	[ 'KURF', 'Urft',                   8006032, 6.58017300, 50.5123690 ],
	[ 'SURM', 'Urmersbach',             8007357, 7.13185000, 50.2559120 ],
	[ 'KUR',  'Urmitz',                 8006035, 7.50907200, 50.4026130 ],
	[ 'KURR', 'Urmitz Rheinbrücke',    8006036, 7.52792300, 50.4183910 ],
	[ 'MURS', 'Urschalling',            8006037, 12.3386900, 47.8358150 ],
	[ 'TURS', 'Urspring',               8006039, 9.89456900, 48.5501440 ],
	[ 'SUZD', 'Usch-Zendscheid',        8005342, 6.60294700, 50.1026590 ],
	[ 'FUSI', 'Usingen',                8007852, 8.52725400, 50.3309230 ],
	[ 'HUS',  'Uslar',                  8006041, 9.65524000, 51.6544810 ],
	[ 'FUS',  'Usseln',                 8006043, 8.67014000, 51.2805420 ],
	[ 'MUTG', 'Utting',                 8006048, 11.0939690, 48.0227410 ],
	[ 'WUTZ', 'Utzedel',                8013177, 13.1162220, 53.8607240 ],
	[ 'NVA',  'Vach',                   8006052, 10.9861460, 49.5175720 ],
	[ 'UVA',  'Vachdorf',               8013179, 10.5385330, 50.5293370 ],
	[ 'MVAD', 'Vachendorf',             8006717, 12.3218800, 47.8268140 ],
	[ 'LVA',  'Vahldorf',               8013180, 11.4997640, 52.2523890 ],
	[ 'TV',   'Vaihingen(Enz)',         8006053, 8.95763200, 48.9481180 ],
	[ 'KVA',  'Vallendar',              8006054, 7.60982100, 50.3996450 ],
	[ 'HVA',  'Varel(Oldb)',            8006056, 8.15018700, 53.3990980 ],
	[ 'AVF',  'Vastorf',                8006058, 10.5555580, 53.1990490 ],
	[ 'MVS',  'Vaterstetten',           8006059, 11.7643800, 48.1041090 ],
	[ 'HVEC', 'Vechelde',               8006060, 10.3597600, 52.2572120 ],
	[ 'HVCH', 'Vechta',                 8006061, 8.28036700, 52.7289040 ],
	[ 'HVCS', 'Vechta-Stoppelmarkt',    8087020, 8.29357800, 52.7491460 ],
	[ 'BVLZ', 'Vehlefanz',              8013183, 13.1148270, 52.7223320 ],
	[ 'UVF',  'Veilsdorf',              8013184, 10.8137630, 50.4153300 ],
	[ 'NVE',  'Veitshöchheim',         8006065, 9.87619600, 49.8314320 ],
	[ 'EVLR', 'Velbert Rosenhügel',    8006064, 7.10172500, 51.3001240 ],
	[ 'ELBG', 'Velbert-Langenberg',     8003529, 7.12237700, 51.3547640 ],
	[ 'ENV',  'Velbert-Neviges',        8004340, 7.09048400, 51.3131590 ],
	[ 'ENIR', 'Velbert-Nierenhof',      8004430, 7.13415400, 51.3723760 ],
	[ 'NVN',  'Velden(b Hersbruck)',    8006067, 11.5183330, 49.6108080 ],
	[ 'WV',   'Velgast',                8010355, 12.8031370, 54.2773160 ],
	[ 'FNV',  'Vellmar-Niedervellmar',  8004415, 9.47843800, 51.3518510 ],
	[ 'FOV',  'Vellmar-Obervellmar',    8004597, 9.45247500, 51.3596790 ],
	[ 'FVOE', 'Vellmar-Osterberg/EKZ',  8006068, 9.46079600, 51.3542600 ],
	[ 'BVLT', 'Velten(Mark)',           8013185, 13.1720340, 52.6848890 ],
	[ 'WVE',  'Ventschow',              8013186, 11.5800160, 53.7872080 ],
	[ 'HV',   'Verden(Aller)',          8006076, 9.23785500, 52.9208180 ],
	[ 'TVRD', 'Veringendorf',           8007233, 9.19910800, 48.1602790 ],
	[ 'TVRS', 'Veringenstadt',          8007232, 9.21082200, 48.1814120 ],
	[ 'HVWH', 'Vernawahlshausen',       8006078, 9.61444200, 51.6295290 ],
	[ 'BV',   'Vetschau',               8013188, 14.0810230, 51.7897590 ],
	[ 'KVET', 'Vettweiß',              8006079, 6.60261600, 50.7430720 ],
	[ 'NVIC', 'Viechtach',              8070561, 12.8892550, 49.0788630 ],
	[ 'HVBG', 'Vienenburg',             8000364, 10.5621740, 51.9550340 ],
	[ 'DVR',  'Vierenstraße',          8013190, 12.9677970, 50.4669020 ],
	[ 'MESH', 'Vierkirchen-Esterhofen', 8001922, 11.4451080, 48.3611180 ],
	[ 'UVU',  'Viernau',                8013191, 10.5589080, 50.6671060 ],
	[ 'KV',   'Viersen',                8000174, 6.40389600, 51.2549470 ],
	[ 'UVI',  'Vieselbach',             8013192, 11.1378660, 50.9929710 ],
	[ 'RVL',  'Villingen(Schwarzw)',    8000366, 8.46526100, 48.0580220 ],
	[
		'RVLE', 'Villingen-Schwenningen Eisstadion',
		8000356, 8.52855300, 48.0527720
	],
	[
		'RVLH', 'Villingen-Schwenningen Hammerstatt',
		8000393, 8.54692200, 48.0601750
	],
	[ 'FVR',   'Villmar',                     8006083, 8.18688500, 50.3956200 ],
	[ 'MVSB',  'Vilsbiburg',                  8006084, 12.3475000, 48.4473840 ],
	[ 'NVK',   'Vilseck',                     8006085, 11.8010580, 49.6156290 ],
	[ 'NVI',   'Vilshofen(Niederbay)',        8006086, 13.1908670, 48.6295510 ],
	[ 'LVG',   'Vinzelberg',                  8013194, 11.6719600, 52.5691850 ],
	[ 'HVIS',  'Visselhövede',               8006090, 9.56664200, 52.9800590 ],
	[ 'HVLO',  'Vlotho',                      8006091, 8.86419000, 52.1718000 ],
	[ 'EVD',   'Voerde(Niederrhein)',         8006098, 6.68881300, 51.5975410 ],
	[ 'WVOG',  'Vogelsang(Gransee)',          8013198, 13.3856870, 53.0377120 ],
	[ 'SVO',   'Vogelweh',                    8006100, 7.70601100, 49.4385350 ],
	[ 'MVG',   'Vohburg',                     8006101, 11.6073500, 48.7391250 ],
	[ 'DVO',   'Voigtsgrün',                 8013201, 12.4265410, 50.6340180 ],
	[ 'UVO',   'Voigtstedt',                  8013202, 11.3068240, 51.3916320 ],
	[ 'HVOL',  'Voldagsen',                   8006104, 9.58267700, 52.1016810 ],
	[ 'NVOLA', 'Volkach-Astheim',             8070860, 10.2170330, 49.8643450 ],
	[ 'FVA',   'Volkmarsen',                  8006107, 9.11722600, 51.4075670 ],
	[ 'EVOK',  'Volkringhausen',              8006109, 7.87221400, 51.3598890 ],
	[ 'HVOP',  'Volpriehausen',               8006112, 9.73782200, 51.6609670 ],
	[ 'HVHP',  'Vorhop',                      8006116, 10.6563840, 52.6480400 ],
	[ 'EVRD',  'Vormwald',                    8006117, 8.14309400, 50.9804210 ],
	[ 'EVRO',  'Vormwald Dorf',               8006118, 8.12721500, 50.9899290 ],
	[ 'NV',    'Vorra(Pegnitz)',              8006120, 11.4945020, 49.5639210 ],
	[ 'AVSL',  'Voßloch',                    8007068, 9.73586800, 53.7906020 ],
	[ 'FEDN',  'Vöhl-Ederbringhausen',       8001664, 8.87180300, 51.1295680 ],
	[ 'FHZN',  'Vöhl-Herzhausen',            8002802, 8.88499800, 51.1812240 ],
	[ 'FSLM',  'Vöhl-Schmittlotheim',        8005382, 8.90026100, 51.1568380 ],
	[ 'FTHA',  'Vöhl-Thalitter',             8006093, 8.89503300, 51.2174420 ],
	[ 'MVRN',  'Vöhringen',                  8006094, 10.0836280, 48.2790880 ],
	[ 'HVOE',  'Vöhrum',                     8006095, 10.1673250, 52.3357310 ],
	[ 'SVL',   'Völklingen',                 8000175, 6.84815600, 49.2490910 ],
	[ 'HELV',  'Völksen/Eldagsen',           8001741, 9.62652800, 52.2118750 ],
	[ 'FWAB',  'Wabern(Bz Kassel)',           8000368, 9.35804000, 51.1031340 ],
	[ 'RWCH',  'Wachenheim(Pfalz)',           8006125, 8.19115200, 49.4393000 ],
	[ 'FWAM',  'Wachenheim-Mölsheim',        8006126, 8.16843900, 49.6353620 ],
	[ 'TWHF',  'Wackershofen',                8006135, 9.69711500, 49.1372490 ],
	[ 'NWAF',  'Waffenbrunn',                 8006134, 12.6750320, 49.2615410 ],
	[ 'FWFK',  'Waggonfabrik',                8006136, 8.23510800, 50.0149150 ],
	[ 'RWG',   'Waghäusel',                  8006137, 8.50831300, 49.2481860 ],
	[ 'MWGN',  'Waging',                      8006138, 12.7270850, 47.9316170 ],
	[ 'EWAL',  'Wahlbach(Kr Siegen)',         8006139, 8.05378300, 50.7584160 ],
	[ 'FWHM',  'Wahlheim',                    8000327, 8.09992000, 49.7191050 ],
	[ 'LWH',   'Wahlitz',                     8013205, 11.7888680, 52.1091770 ],
	[ 'AWAH',  'Wahlstedt',                   8007273, 10.2295750, 53.9612230 ],
	[ 'RWW',   'Wahlwies',                    8077775, 8.96522700, 47.8141760 ],
	[ 'HWAZ',  'Wahrenholz',                  8006144, 10.6069540, 52.6080020 ],
	[ 'TWN',   'Waiblingen',                  8000180, 9.29988200, 48.8261240 ],
	[ 'RWB',   'Waibstadt',                   8007442, 8.91935400, 49.3009410 ],
	[ 'NWA',   'Waigolshausen',               8006147, 10.1160270, 49.9672930 ],
	[ 'AWK',   'Wakendorf',                   8006148, 10.3659560, 53.8662660 ],
	[ 'BWA',   'Walddrehna',                  8013210, 13.6172490, 51.7727230 ],
	[ 'TWG',   'Waldenburg(Württ)',          8006154, 9.65869900, 49.2025370 ],
	[ 'NWDH',  'Waldershof',                  8006155, 12.0572670, 49.9827200 ],
	[ 'SWAB',  'Waldfischbach',               8006156, 7.65203500, 49.2885550 ],
	[ 'TWHS',  'Waldhausen(b Geislingen)',    8007073, 9.90772300, 48.6353080 ],
	[ 'TWY',   'Waldhausen(b Schorndorf)',    8006157, 9.63792700, 48.7891850 ],
	[ 'DWA',   'Waldheim',                    8010359, 13.0140330, 51.0753440 ],
	[ 'RWA',   'Waldkirch',                   8006159, 7.95724500, 48.0956910 ],
	[ 'DWK',   'Waldkirchen(Erzgeb)',         8013212, 13.0905710, 50.7627140 ],
	[ 'NWKN',  'Waldkirchen(Niederbay.)',     8006160, 13.6065800, 48.7371640 ],
	[ 'MWKG',  'Waldkraiburg',                8006164, 12.4080220, 48.2029530 ],
	[ 'NWLM',  'Waldmünchen',                8006163, 12.6960070, 49.3778860 ],
	[ 'RWU',   'Waldshut',                    8006167, 8.21952600, 47.6213680 ],
	[ 'RWU S', 'Waldshut',                    8006167, 8.21952600, 47.6213680 ],
	[ 'SWL',   'Walhausen(Saar)',             8006170, 7.12937400, 49.5588000 ],
	[ 'TWH',   'Walheim(Württ)',             8006171, 9.15211800, 49.0109410 ],
	[ 'HWKD',  'Walkenried',                  8006172, 10.6088140, 51.5848760 ],
	[ 'FWA',   'Wallau(Lahn)',                8000187, 8.47001000, 50.9228980 ],
	[ 'FWF',   'Walldorf(Hess)',              8006175, 8.58081100, 50.0013390 ],
	[ 'UWD',   'Walldorf(Werra)',             8013215, 10.3908430, 50.6176030 ],
	[ 'RWDN',  'Walldürn',                   8006176, 9.36754200, 49.5780230 ],
	[ 'NWLD',  'Wallersdorf',                 8006181, 12.7434640, 48.7406440 ],
	[ 'FWAH',  'Wallertheim',                 8006183, 8.04945800, 49.8326480 ],
	[ 'MWHN',  'Walleshausen',                8006184, 10.9809950, 48.1502180 ],
	[ 'UWAL',  'Wallhausen(Helme)',           8013217, 11.2042370, 51.4618830 ],
	[ 'TWAL',  'Wallhausen(Württ)',          8006145, 10.0631170, 49.2091510 ],
	[ 'LWWZ',  'Wallwitz(Saalkr)',            8013220, 11.9210790, 51.5817580 ],
	[ 'MWKN',  'Walpertskirchen',             8006190, 11.9704210, 48.2608720 ],
	[ 'KWAP',  'Walporzheim',                 8006191, 7.07992000, 50.5339240 ],
	[ 'UWL',   'Walschleben',                 8013221, 10.9559580, 51.0678810 ],
	[ 'WWL',   'Walsleben',                   8013222, 12.6790270, 52.9470390 ],
	[ 'HWSR',  'Walsrode',                    8006193, 9.60090600, 52.8648550 ],
	[ 'UWN',   'Waltershausen',               8013223, 10.5637430, 50.9007300 ],
	[ 'USNT',  'Waltershausen Schnepfenthal', 8013224, 10.5762110, 50.8839740 ],
	[ 'UWNS',  'Waltershausen Schnepfenthal', 8013224, 10.5762110, 50.8839740 ],
	[ 'UWA',   'Wandersleben',                8013226, 10.8524980, 50.9066660 ],
	[ 'BWAZ',  'Wandlitz',                    8013227, 13.4661500, 52.7448230 ],
	[ 'BWAS',  'Wandlitzsee',                 8013228, 13.4740250, 52.7559670 ],
	[ 'TWW',   'Wangen(Allgäu)',             8006200, 9.83057300, 47.6892270 ],
	[ 'UWG',   'Wangen(Unstrut)',             8013240, 11.5452930, 51.2715050 ],
	[ 'EWAN',  'Wanne-Eickel Hbf',            8000192, 7.16578300, 51.5312560 ],
	[ 'TWAN',  'Wannweil',                    8006203, 9.15044900, 48.5123150 ],
	[ 'LWAN',  'Wansleben am See',            8013230, 11.7467640, 51.4624170 ],
	[ 'HWAR',  'Warburg(Westf)',              8000196, 9.16384500, 51.4929530 ],
	[ 'WWR',   'Waren(Müritz)',              8010361, 12.6806780, 53.5215120 ],
	[ 'EWAF',  'Warendorf',                   8006206, 7.98446400, 51.9500910 ],
	[ 'EWEM',  'Warendorf-Einen-Müssingen',  8006207, 7.89477400, 51.9614000 ],
	[ 'WWAH',  'Warenshof',                   8013232, 12.6454190, 53.5307880 ],
	[ 'DWAB',  'Warmbad',                     8013235, 13.0640310, 50.6684950 ],
	[ 'WWM',   'Warnemünde',                 8013236, 12.0912710, 54.1768520 ],
	[ 'WWMW',  'Warnemünde Werft',           8013237, 12.0856380, 54.1693200 ],
	[ 'MWGU',  'Warngau',                     8006210, 11.7094720, 47.8335700 ],
	[ 'WWAN',  'Warnitz(Uckermark)',          8013238, 13.8766840, 53.1820310 ],
	[ 'TWV',   'Warthausen',                  8006212, 9.80166100, 48.1299150 ],
	[ 'TWVH',  'Warthausen',                  8006212, 9.80166100, 48.1299150 ],
	[ 'AWA',   'Wasbek',                      8006213, 9.89801600, 54.0755810 ],
	[ 'RWR',   'Wasenweiler',                 8006215, 7.68712600, 48.0468340 ],
	[ 'TWA',   'Wasseralfingen',              8006217, 10.1036450, 48.8586150 ],
	[ 'MWBG',  'Wasserburg(Bodensee)',        8006218, 9.63906400, 47.5719030 ],
	[ 'MWSG',  'Wasserburg(Günz)',           8006219, 10.2697070, 48.4383770 ],
	[ 'MWSB',  'Wasserburg(Inn)Bf',           8006220, 12.1852300, 48.0615630 ],
	[ 'SWAS',  'Wasserliesch',                8006222, 6.53721600, 49.7084670 ],
	[ 'UWTL',  'Wasserthaleben',              8013244, 10.8899800, 51.2586840 ],
	[ 'MWTD',  'Wassertrüdingen',            8070567, 10.6074340, 49.0437920 ],
	[ 'MWAS',  'Wasserzell(b Eichstätt)',    8006224, 11.1679700, 48.8753470 ],
	[ 'UWS',   'Wasungen',                    8013245, 10.3592870, 50.6628950 ],
	[ 'EWAT',  'Wattenscheid',                8006226, 7.13952100, 51.4732140 ],
	[ 'EWHP',  'Wattenscheid-Höntrop',       8006227, 7.15353500, 51.4598940 ],
	[ 'NWAS',  'Watzelsteg',                  8007341, 12.8998470, 49.2069390 ],
	[ 'FWST',  'Watzenborn-Steinberg',        8006229, 8.72343500, 50.5455000 ],
	[ 'FWCK',  'Weckesheim',                  8006232, 8.84367300, 50.3595590 ],
	[ 'HWED',  'Weddel(Braunschw)',           8006233, 10.6234940, 52.2691180 ],
	[ 'AWL',   'Wedel(Holst)',                8006236, 9.70516100, 53.5819950 ],
	[ 'HWEE',  'Weener',                      8006237, 7.34309500, 53.1632710 ],
	[ 'DWSN',  'Weesenstein',                 8013247, 13.8628850, 50.9363580 ],
	[ 'HWEZ',  'Weetzen',                     8000342, 9.63537600, 52.2983510 ],
	[ 'KWEE',  'Weeze',                       8006240, 6.19797600, 51.6242940 ],
	[ 'LWF',   'Wefensleben',                 8013248, 11.1552050, 52.1769400 ],
	[ 'FWGA',  'Wega',                        8006241, 9.17555100, 51.1281920 ],
	[ 'KWEG',  'Wegberg',                     8006243, 6.28128900, 51.1451790 ],
	[ 'LWEG',  'Wegeleben',                   8010364, 11.1685510, 51.8715830 ],
	[ 'LWST',  'Wegenstedt',                  8013250, 11.2088820, 52.3870750 ],
	[ 'AWHD',  'Wehdel',                      8007812, 8.80654900, 53.5123640 ],
	[ 'SWE',   'Wehr(Mosel)',                 8006252, 6.37682200, 49.5864640 ],
	[ 'RBN',   'Wehr-Brennet',                8001174, 7.91052500, 47.5809200 ],
	[ 'HWEH',  'Wehrden',                     8087065, 9.38255200, 51.7096140 ],
	[ 'FRSA',  'Wehretal-Reichensachsen',     8005003, 9.98597700, 51.1540960 ],
	[ 'FWEH',  'Wehrheim',                    8007853, 8.56703000, 50.2963480 ],
	[ 'MWBH',  'Weibhausen',                  8006255, 12.6924760, 47.8985730 ],
	[ 'MWEI',  'Weichering',                  8006256, 11.3304090, 48.7206450 ],
	[ 'DWEI',  'Weickersdorf(Sachs)',         8013253, 14.1511220, 51.1109060 ],
	[ 'NWGR',  'Weickersgrüben',             8006257, 9.78254600, 50.1070670 ],
	[ 'UWE',   'Weida',                       8010365, 12.0618460, 50.7856420 ],
	[ 'UWEA',  'Weida Altstadt',              8013254, 12.0584570, 50.7678700 ],
	[ 'UWEM',  'Weida Mitte',                 8013251, 12.0556130, 50.7765060 ],
	[ 'NWDO',  'Weiden(Oberpf)',              8000204, 12.1538460, 49.6704900 ],
	[ 'MWDB',  'Weidenbach',                  8006258, 12.3472860, 48.2542150 ],
	[ 'NWBE',  'Weidenberg',                  8006259, 11.7232670, 49.9436120 ],
	[ 'RWD',   'Weidenthal',                  8006261, 7.99491200, 49.4174940 ],
	[ 'NWDG',  'Weiding',                     8006264, 12.7769950, 49.2557220 ],
	[ 'NWHR',  'Weiherhammer',                8006266, 12.0618290, 49.6312530 ],
	[ 'NWHF',  'Weiherhof',                   8006267, 10.9284880, 49.4599260 ],
	[ 'TWM',   'Weikersheim',                 8006269, 9.90571800, 49.4784630 ],
	[ 'RW',    'Weil am Rhein',               8006272, 7.60841900, 47.5939730 ],
	[ 'RWEI',  'Weil am Rhein Ost',           8006273, 7.63478000, 47.5906290 ],
	[ 'RWGA',  'Weil am Rhein-Gartenstadt',   8000143, 7.61628400, 47.5887070 ],
	[ 'RWPF', 'Weil am Rhein-Pfädlistraße', 8000146, 7.62649300, 47.5890150 ],
	[ 'TW',   'Weil der Stadt',               8006271, 8.87280600, 48.7554830 ],
	[ 'TWEI', 'Weil im Schönbuch Röte',     8085013, 9.04989800, 48.6209500 ],
	[ 'TWEIT', 'Weil im Schönbuch Troppel', 8085012, 9.04272200, 48.6202160 ],
	[
		'TWEIU', 'Weil im Schönbuch Untere Halde',
		8085014, 9.06279600,
		48.6204400
	],
	[ 'MWLB', 'Weilbach(Unterallg)',     8006279, 10.4296230, 48.1259960 ],
	[ 'NWE',  'Weilbach(Unterfr)',       8006274, 9.21316500, 49.6686830 ],
	[ 'FWG',  'Weilburg',                8000218, 8.26794900, 50.4863680 ],
	[ 'KWLB', 'Weiler (Brohltal)',       8071906, 7.25850200, 50.4590340 ],
	[ 'TWEL', 'Weiler(Rems)',            8006277, 9.50199100, 48.8003010 ],
	[ 'KWES', 'Weilerswist',             8006280, 6.84507800, 50.7502930 ],
	[ 'KDEK', 'Weilerswist-Derkum',      8001416, 6.81683000, 50.7049640 ],
	[ 'MWH',  'Weilheim(Oberbay)',       8000220, 11.1428600, 47.8453630 ],
	[ 'TWLH', 'Weilheim(Württ)',        8006281, 8.77595600, 48.0251060 ],
	[ 'TSWF', 'Weilimdorf',              8006268, 9.09432800, 48.8220800 ],
	[ 'UWM',  'Weimar',                  8010366, 11.3264580, 50.9914870 ],
	[ 'UWMB', 'Weimar Berkaer Bf',       8013256, 11.3136860, 50.9806260 ],
	[ 'UWMT', 'Weimar West',             8013266, 11.3115610, 50.9880830 ],
	[ 'DWEW', 'Weinböhla Hp',           8013267, 13.5615490, 51.1590980 ],
	[ 'TWEB', 'Weingarten Berg',         8087067, 9.61687600, 47.8168520 ],
	[ 'RWGT', 'Weingarten(Baden)',       8006287, 8.52122400, 49.0591010 ],
	[ 'RWE',  'Weinheim(Bergstr)',       8000377, 8.66535100, 49.5533020 ],
	[ 'RLUE', 'Weinheim-Lützelsachsen', 8003792, 8.64950100, 49.5273850 ],
	[ 'TWR',  'Weinsberg',               8006289, 9.28702400, 49.1479970 ],
	[ 'TWRW', 'Weinsberg West',          8006290, 9.27313900, 49.1511620 ],
	[
		'TELI', 'Weinsberg/Ellhofen Gewerbegebiet',
		8006294, 9.30555200, 49.1487580
	],
	[ 'DWS',  'Weischlitz',                  8010367, 12.0605170, 50.4481050 ],
	[ 'WWSN', 'Weisen',                      8013258, 11.7875050, 53.0255460 ],
	[ 'RWSB', 'Weisenbach',                  8006291, 8.35526300, 48.7275320 ],
	[ 'RWSS', 'Weisenheim(Sand)',            8006292, 8.24987400, 49.5139310 ],
	[ 'FWI',  'Weiterstadt',                 8006306, 8.57938500, 49.9097060 ],
	[ 'DWX',  'Weixdorf',                    8013268, 13.8066400, 51.1504710 ],
	[ 'DWXB', 'Weixdorf Bad',                8013269, 13.8020030, 51.1401160 ],
	[ 'RWZ',  'Weizen',                      8070569, 8.47651400, 47.7688320 ],
	[ 'MWZH', 'Weizern-Hopferau',            8006309, 10.6204600, 47.6145930 ],
	[ 'LWG',  'Weißandt-Gölzau',           8013259, 12.0287650, 51.6696700 ],
	[ 'TWSN', 'Weißenau',                   8006296, 9.59438300, 47.7659750 ],
	[ 'NWG',  'Weißenburg(Bay)',            8006298, 10.9653900, 49.0296730 ],
	[ 'UW',   'Weißenfels',                 8010368, 11.9709260, 51.2046150 ],
	[ 'UWWE', 'Weißenfels West',            8013261, 11.9439640, 51.1944820 ],
	[ 'MWSH', 'Weißenhorn',                 8006299, 10.1531570, 48.3057950 ],
	[ 'MAES', 'Weißenhorn-Eschach',         8006305, 10.1350930, 48.3009990 ],
	[ 'NWEO', 'Weißenohe',                  8006300, 11.2496410, 49.6292830 ],
	[ 'KWEH', 'Weißenthurm',                8006303, 7.45098800, 50.4211770 ],
	[ 'WWES', 'Weißer See',                 8070946, 12.9489260, 53.2830340 ],
	[ 'DWRO', 'Weißes Roß',                8013263, 13.6616180, 51.1066280 ],
	[ 'BWW',  'Weißwasser(Oberlausitz)',    8010370, 14.6380270, 51.5054420 ],
	[ 'FWZ',  'Welgesheim-Zotzenheim',       8006312, 7.95665300, 49.8785750 ],
	[ 'FWES', 'Welkers',                     8006313, 9.72253800, 50.4809960 ],
	[ 'LWL',  'Wellen(Magdeburg)',           8013271, 11.4321380, 52.1361630 ],
	[ 'SWN',  'Wellen(Mosel)',               8006315, 6.44132200, 49.6726600 ],
	[ 'HWLL', 'Wellendorf',                  8006316, 8.14015700, 52.1811730 ],
	[ 'BWZ',  'Wellmitz',                    8013272, 14.7148960, 52.0646440 ],
	[ 'EWSE', 'Welschen Ennest',             8006320, 8.00361000, 51.0419700 ],
	[ 'RWEL', 'Welschingen-Neuhausen',       8006321, 8.76921600, 47.8340300 ],
	[ 'EWVE', 'Welver',                      8006323, 7.95665300, 51.6162530 ],
	[ 'SWRR', 'Wemmetsweiler Rathaus',       8000378, 7.08593600, 49.3695210 ],
	[ 'AWE',  'Wendisch Evern',              8006330, 10.4627810, 53.2176410 ],
	[ 'BSH',  'Wendisch-Rietz',              8012855, 14.0096520, 52.2068260 ],
	[ 'TWD',  'Wendlingen(Neckar)',          8006331, 9.37301100, 48.6729610 ],
	[ 'TWEN', 'Wennedach',                   8079101, 9.90274600, 48.1193980 ],
	[ 'HWSN', 'Wennigsen(Deister)',          8006336, 9.57216700, 52.2796280 ],
	[ 'BWSD', 'Wensickendorf',               8013278, 13.3866850, 52.7549730 ],
	[ 'BWR',  'Werbig',                      8010371, 14.4072780, 52.5646220 ],
	[ 'BWRO', 'Werbig',                      8010371, 14.4072780, 52.5646220 ],
	[ 'BWRU', 'Werbig',                      8010371, 14.4072780, 52.5646220 ],
	[ 'DWR',  'Werdau',                      8010372, 12.3670860, 50.7261650 ],
	[ 'DWND', 'Werdau Nord',                 8013280, 12.3715210, 50.7436760 ],
	[ 'BWE',  'Werder(Havel)',               8010373, 12.9261890, 52.3929390 ],
	[ 'EWHL', 'Werdohl',                     8006339, 7.75754400, 51.2594850 ],
	[ 'FWDF', 'Werdorf',                     8006340, 8.41719100, 50.5928900 ],
	[ 'EWER', 'Werl',                        8006342, 7.91413600, 51.5580730 ],
	[ 'TWER', 'Wernau(Neckar)',              8006346, 9.41389800, 48.6942470 ],
	[ 'NWRB', 'Wernberg',                    8006347, 12.1462260, 49.5389310 ],
	[ 'EWRN', 'Werne a d Lippe',             8006348, 7.62293400, 51.6692500 ],
	[ 'BWER', 'Werneuchen',                  8013285, 13.7383100, 52.6374560 ],
	[ 'NWFH', 'Wernfeld',                    8006349, 9.72552900, 50.0260650 ],
	[ 'LWD',  'Wernigerode',                 8010374, 10.7888050, 51.8402540 ],
	[ 'LWDE', 'Wernigerode Elmowerk',        8013286, 10.7692640, 51.8387910 ],
	[ 'LWDK', 'Wernigerode Hochschule Harz', 8017033, 10.7656870, 51.8262170 ],
	[ 'LWDT', 'Wernigerode Westerntor',      8017034, 10.7802560, 51.8339600 ],
	[ 'LWDH', 'Wernigerode-Hasserode',       8017032, 10.7432190, 51.8200980 ],
	[ 'UWH',  'Wernshausen',                 8010375, 10.3536060, 50.7212400 ],
	[ 'MWHA', 'Wertach-Haslach',             8006353, 10.4603690, 47.6289720 ],
	[ 'TWT',  'Wertheim',                    8000231, 9.51309500, 49.7620250 ],
	[ 'TWTB', 'Wertheim-Bestenheid',         8006354, 9.49993200, 49.7861820 ],
	[ 'UWTH', 'Werther',                     8013291, 10.7419100, 51.4699320 ],
	[ 'EWES', 'Wesel',                       8000242, 6.62713400, 51.6558400 ],
	[ 'EWFK', 'Wesel Feldmark',              8006356, 6.61630800, 51.6766580 ],
	[ 'WWE',  'Wesenberg',                   8013293, 12.9627460, 53.2867020 ],
	[ 'AWBU', 'Wesselburen',                 8006357, 8.93271800, 54.2071790 ],
	[ 'HWES', 'Wesseln',                     8006358, 10.0342060, 52.0815430 ],
	[ 'EWBH', 'Westbarthausen',              8006360, 8.23264200, 52.0969750 ],
	[ 'EWBV', 'Westbevern',                  8006361, 7.74370200, 52.0309840 ],
	[ 'MWDF', 'Westendorf',                  8006363, 10.8433700, 48.5718450 ],
	[ 'FWBG', 'Westerburg',                  8000245, 7.96697800, 50.5576420 ],
	[ 'MWM',  'Westerham',                   8006366, 11.8284820, 47.9038920 ],
	[ 'HWTH', 'Westerhausen',                8006367, 8.27862500, 52.2363240 ],
	[ 'AWLA', 'Westerland(Sylt)',            8006369, 8.31092500, 54.9068390 ],
	[
		'AWLAU', 'Westerland(Sylt), Sylt Shuttle',
		8030918, 8.31363500,
		54.9047380
	],
	[ 'HOCH', 'Westerstede-Ocholt',           8004610, 7.88646800, 53.2021660 ],
	[ 'TWSH', 'Westerstetten',                8006373, 9.94928100, 48.5201950 ],
	[ 'DWES', 'Westewitz-Hochweitzschen',     8013295, 13.0278510, 51.1376160 ],
	[ 'TWX',  'Westhausen',                   8006376, 10.1836530, 48.8814090 ],
	[ 'MWHS', 'Westheim(Schwab)',             8006378, 10.8182330, 48.3859910 ],
	[ 'EWSM', 'Westheim(Westf)',              8006379, 8.91025500, 51.4945890 ],
	[ 'NWL',  'Westheim-Langendorf',          8006380, 9.93274800, 50.1257750 ],
	[ 'EWN',  'Westönnen',                   8006383, 7.96095200, 51.5575290 ],
	[ 'FWT',  'Wetter(Hessen)',               8006385, 8.72914700, 50.9037150 ],
	[ 'EWET', 'Wetter(Ruhr)',                 8006386, 7.38591500, 51.3864130 ],
	[ 'LWZE', 'Wetterzeube',                  8013297, 12.0126420, 51.0083510 ],
	[ 'FWR',  'Wetzlar',                      8000383, 8.50381900, 50.5656310 ],
	[ 'MWS',  'Weßling(Oberbay)',            8006359, 11.2517680, 48.0773740 ],
	[ 'EWIC', 'Wickede(Ruhr)',                8006389, 7.86971300, 51.4932010 ],
	[ 'NWK',  'Wicklesgreuth',                8006390, 10.7114500, 49.3106890 ],
	[ 'KWIC', 'Wickrath',                     8006391, 6.41150500, 51.1327700 ],
	[ 'SWK',  'Wiebelskirchen',               8006392, 7.17566500, 49.3711350 ],
	[ 'AWMD', 'Wiemersdorf',                  8007059, 9.91648300, 53.9546280 ],
	[ 'HWRN', 'Wieren',                       8006402, 10.6558470, 52.8925880 ],
	[ 'DWIS', 'Wiesa(Erzgeb)',                8013310, 13.0236990, 50.6106400 ],
	[ 'NWU',  'Wiesau(Oberpf)',               8006403, 12.1912880, 49.9110130 ],
	[ 'FW',   'Wiesbaden Hbf',                8000250, 8.24373100, 50.0707910 ],
	[ 'FWO',  'Wiesbaden Ost',                8006404, 8.25629300, 50.0414120 ],
	[ 'FWB',  'Wiesbaden-Biebrich',           8000288, 8.23642300, 50.0488290 ],
	[ 'FWE',  'Wiesbaden-Erbenheim',          8006407, 8.29504400, 50.0544110 ],
	[ 'FWIG', 'Wiesbaden-Igstadt',            8006408, 8.32563500, 50.0825800 ],
	[ 'FWS',  'Wiesbaden-Schierstein',        8006409, 8.19460300, 50.0475900 ],
	[ 'BWSU', 'Wiesenau',                     8013305, 14.5839050, 52.2313210 ],
	[ 'BWG',  'Wiesenburg(Mark)',             8010376, 12.4312130, 52.0988250 ],
	[ 'DWSB', 'Wiesenburg(Sachs)',            8013307, 12.5667430, 50.6527050 ],
	[ 'FWIF', 'Wiesenfeld',                   8006413, 8.74937600, 51.0075190 ],
	[ 'NWDC', 'Wiesenfeld(b Coburg)',         8006414, 10.9117540, 50.3015550 ],
	[ 'RWI',  'Wiesental',                    8006417, 8.50239000, 49.2254580 ],
	[ 'NWIE', 'Wiesenthau',                   8006418, 11.1265210, 49.7132030 ],
	[ 'TWID', 'Wieslensdorf',                 8006416, 9.42211800, 49.1497850 ],
	[ 'RWS',  'Wiesloch-Walldorf',            8006421, 8.66414600, 49.2913530 ],
	[ 'MWSM', 'Wiesmühl(Alz)',               8006423, 12.5643120, 48.1059990 ],
	[ 'NWI',  'Wiesthal',                     8006426, 9.44105100, 50.0168330 ],
	[ 'MWBN', 'Wilburgstetten Bf',            8070620, 10.3971220, 49.0251620 ],
	[ 'RWIN', 'Wilchingen-Hallau',            8006430, 8.46386000, 47.6794480 ],
	[ 'BWI',  'Wildau',                       8081540, 13.6337790, 52.3199350 ],
	[ 'TWIB', 'Wildberg(Württ)',             8006432, 8.74294700, 48.6252800 ],
	[ 'FBOS', 'Wildeck-Bosserode',            8001106, 9.99300200, 50.9456970 ],
	[ 'FHNB', 'Wildeck-Hönebach',            8002903, 9.94424100, 50.9354320 ],
	[ 'FOBS', 'Wildeck-Obersuhl',             8004589, 10.0262290, 50.9506190 ],
	[ 'HWIH', 'Wildeshausen',                 8006436, 8.43142200, 52.8978200 ],
	[ 'TWL',  'Wilferdingen-Singen',          8006440, 8.57241500, 48.9538620 ],
	[ 'RWSW', 'Wilgartswiesen',               8006441, 7.88382300, 49.2094340 ],
	[ 'FWL',  'Wilhelmsdorf',                 8007854, 8.48080900, 50.3501460 ],
	[ 'HW',   'Wilhelmshaven Hbf',            8006445, 8.11490100, 53.5187950 ],
	[ 'BWHO', 'Wilhelmshorst',                8010378, 13.0674470, 52.3314860 ],
	[ 'FWUE', 'Wilhelmshütte(Lahn)',         8006446, 8.55088200, 50.8681430 ],
	[ 'NWHD', 'Wilhermsdorf',                 8006448, 10.7235950, 49.4824840 ],
	[ 'NWDM', 'Wilhermsdorf Mitte',           8007856, 10.7165470, 49.4799900 ],
	[ 'DWL',  'Wilischthal',                  8013312, 13.0565790, 50.7247240 ],
	[ 'DWI',  'Wilkau-Haßlau',               8010379, 12.5135780, 50.6754120 ],
	[ 'HWBD', 'Willebadessen',                8006449, 9.01165200, 51.6217570 ],
	[ 'FWLN', 'Willingen',                    8006453, 8.60363500, 51.2933420 ],
	[ 'FWLM', 'Willmenrod',                   8006454, 7.98575800, 50.5393290 ],
	[ 'NWIG', 'Willmering',                   8006455, 12.6700730, 49.2465730 ],
	[ 'TWLB', 'Willsbach',                    8006456, 9.35886800, 49.1424220 ],
	[ 'WWLD', 'Wilmersdorf(Angerm)',          8013313, 13.8924570, 53.1116280 ],
	[ 'FWTH', 'Wilsenroth',                   8006459, 8.03279100, 50.5311120 ],
	[ 'AWIR', 'Wilster',                      8006460, 9.38345600, 53.9262280 ],
	[ 'DWT',  'Wilthen',                      8010380, 14.3915020, 51.0932800 ],
	[ 'SWIG', 'Wiltingen(Saar)',              8006461, 6.59046200, 49.6626410 ],
	[ 'SWIN', 'Wincheringen',                 8006463, 6.40657800, 49.6084670 ],
	[ 'EWIL', 'Windelsbleiche',               8006466, 8.53137800, 51.9570070 ],
	[ 'RWND', 'Winden(Pfalz)',                8006468, 8.12247900, 49.0954520 ],
	[ 'NWB',  'Windischeschenbach',           8006472, 12.1651700, 49.7947470 ],
	[ 'NWIN', 'Windsbach',                    8006473, 10.8257160, 49.2496940 ],
	[ 'UWIR', 'Wingerode',                    8013315, 10.2405090, 51.3897070 ],
	[ 'AWG',  'Wingst',                       8006475, 9.09815800, 53.7450470 ],
	[ 'NWKH', 'Winkelhaid',                   8006476, 11.3010350, 49.3929460 ],
	[ 'TWI',  'Winnenden',                    8006479, 9.39229000, 48.8795830 ],
	[ 'SWI',  'Winningen(Mosel)',             8006481, 7.52320800, 50.3154240 ],
	[ 'HWIN', 'Winninghausen',                8006482, 9.43630500, 52.3233250 ],
	[ 'SWNW', 'Winnweiler',                   8006483, 7.85595500, 49.5705480 ],
	[ 'AWI',  'Winsen(Luhe)',                 8006484, 10.2076910, 53.3538390 ],
	[ 'TWIN', 'Winterbach(b Schorndorf)',     8006485, 9.48099400, 48.7984320 ],
	[ 'EWTB', 'Winterberg(Westf)',            8006486, 8.53240800, 51.1985850 ],
	[ 'NWN',  'Winterhausen',                 8006488, 10.0120720, 49.7084420 ],
	[ 'AWIM', 'Wintermoor',                   8006489, 9.82853600, 53.1861380 ],
	[ 'UWIP', 'Wipperdorf',                   8013318, 10.6610640, 51.4529580 ],
	[ 'KWIR', 'Wirges',                       8006498, 7.78521000, 50.4683960 ],
	[ 'FWIR', 'Wirtheim',                     8006499, 9.25892900, 50.2257840 ],
	[ 'WWI',  'Wismar',                       8010381, 11.4694330, 53.8968370 ],
	[ 'EWIN', 'Wissen(Sieg)',                 8006501, 7.73981400, 50.7828710 ],
	[ 'HWIS', 'Wissingen',                    8006503, 8.20504700, 52.2582110 ],
	[ 'EWIK', 'Wittbräucke',                 8006505, 7.44591000, 51.4201730 ],
	[ 'EWIT', 'Witten Hbf',                   8000251, 7.32944200, 51.4355440 ],
	[ 'EWIA', 'Witten-Annen Nord',            8006510, 7.37533700, 51.4478400 ],
	[ 'WW',   'Wittenberge',                  8010382, 11.7628710, 53.0031150 ],
	[ 'WWT',  'Wittenhagen',                  8013322, 13.0560500, 54.1840040 ],
	[ 'DWIM', 'Wittgensdorf Mitte',           8013324, 12.8697590, 50.8743860 ],
	[ 'DWIO', 'Wittgensdorf ob Bf',           8010383, 12.8413650, 50.8827710 ],
	[ 'TWIT', 'Wittighausen',                 8006517, 9.84624300, 49.6184060 ],
	[ 'HWTT', 'Wittingen',                    8000344, 10.7231740, 52.7272910 ],
	[ 'SWIH', 'Wittlich Hbf',                 8000379, 6.94355700, 49.9731210 ],
	[ 'RWL',  'Wittlingen',                   8070578, 7.64697600, 47.6566310 ],
	[ 'HWTM', 'Wittmund',                     8006520, 7.78882600, 53.5798680 ],
	[ 'WWK',  'Wittstock(Dosse)',             8010384, 12.4789110, 53.1606210 ],
	[ 'FWZN', 'Witzenhausen Nord',            8006524, 9.86307900, 51.3515560 ],
	[ 'MWIT', 'Witzighausen',                 8006493, 10.0978040, 48.3174430 ],
	[ 'DWIT', 'Witzschdorf',                  8013328, 13.0885230, 50.7752360 ],
	[ 'AWRT', 'Witzwort',                     8006527, 8.99855800, 54.3860970 ],
	[ 'UWOF', 'Woffleben',                    8013333, 10.7222130, 51.5555200 ],
	[ 'AWLF', 'Wohltorf',                     8006541, 10.2781840, 53.5205890 ],
	[ 'RWO',  'Wolfach',                      8006544, 8.22184900, 48.2936650 ],
	[ 'TWO',  'Wolfegg',                      8006545, 9.80866500, 47.8242640 ],
	[ 'LWO',  'Wolfen(Bitterfeld)',           8013335, 12.2795630, 51.6611590 ],
	[ 'HWOH', 'Wolfenbüttel',                8000255, 10.5323060, 52.1591260 ],
	[ 'HWOL', 'Wolfenbüttel',                8000255, 10.5323060, 52.1591260 ],
	[ 'LWOR', 'Wolferode',                    8013336, 11.5087520, 51.5122440 ],
	[ 'FWFG', 'Wolfgang(Kr Hanau)',           8006548, 8.95746900, 50.1231070 ],
	[ 'FWFH', 'Wolfhagen',                    8006549, 9.17862000, 51.3316950 ],
	[ 'MWO',  'Wolfratshausen',               8006550, 11.4272010, 47.9144240 ],
	[ 'HWOB', 'Wolfsburg Hbf',                8006552, 10.7877840, 52.4294980 ],
	[ 'UWOL', 'Wolfsgefärth',                8013334, 12.0731400, 50.8162770 ],
	[ 'NWM',  'Wolfsmünster',                8006554, 9.73489300, 50.0945080 ],
	[ 'SWFS', 'Wolfstein',                    8006555, 7.61028700, 49.5842800 ],
	[ 'WWO',  'Wolgast',                      8013339, 13.7690870, 54.0439490 ],
	[ 'WWOH', 'Wolgast Hafen',                8013340, 13.7799630, 54.0518450 ],
	[ 'WWOF', 'Wolgaster Fähre',             8013341, 13.7906240, 54.0563760 ],
	[ 'DWO',  'Wolkenstein',                  8013343, 13.0649650, 50.6527430 ],
	[ 'UWK',  'Wolkramshausen',               8010385, 10.7456630, 51.4400210 ],
	[ 'RWBB', 'Wollbach(Baden)',              8070579, 7.64863200, 47.6682110 ],
	[ 'LWLS', 'Wolmirstedt',                  8013344, 11.6356190, 52.2503590 ],
	[ 'AWOL', 'Wolterdingen(Han)',            8006559, 9.84580000, 53.0261220 ],
	[ 'BWOL', 'Woltersdorf/Nuthe-Urstromtal', 8013345, 13.1952810, 52.1173620 ],
	[ 'HWWI', 'Woltwiesche',                  8006561, 10.2789990, 52.2007540 ],
	[ 'FWOR', 'Worms Hbf',                    8000257, 8.35644800, 49.6349400 ],
	[ 'AWPW', 'Worpswede',                    8007122, 8.91551000, 53.2264870 ],
	[ 'AWRE', 'Wremen',                       8006570, 8.52127500, 53.6469870 ],
	[ 'BWRZ', 'Wriezen',                      8010386, 14.1402390, 52.7154330 ],
	[ 'AWST', 'Wrist',                        8006572, 9.74812800, 53.9323820 ],
	[ 'LWU',  'Wulfen(Anh)',                  8013357, 11.9221410, 51.8186810 ],
	[ 'EWUF', 'Wulfen(Westf)',                8006590, 7.01157800, 51.7191890 ],
	[ 'HWUL', 'Wulften',                      8006592, 10.1760260, 51.6594030 ],
	[ 'MWUH', 'Wullenstetten',                8006595, 10.0713310, 48.3139800 ],
	[ 'NHOB', 'Wunsiedel-Holenbrunn',         8000173, 12.0339280, 50.0511130 ],
	[ 'HWUN', 'Wunstorf',                     8000268, 9.45097600, 52.4222250 ],
	[ 'KW',   'Wuppertal Hbf',                8000266, 7.14954300, 51.2543630 ],
	[ 'KWBA', 'Wuppertal-Barmen',             8006596, 7.19515900, 51.2669720 ],
	[ 'KWLP', 'Wuppertal-Langerfeld',         8006607, 7.24229800, 51.2778660 ],
	[ 'KWO',  'Wuppertal-Oberbarmen',         8006719, 7.22148300, 51.2738390 ],
	[ 'KWRO', 'Wuppertal-Ronsdorf',           8006616, 7.21560000, 51.2264760 ],
	[ 'KWSO', 'Wuppertal-Sonnborn',           8006618, 7.09657500, 51.2405840 ],
	[ 'KWS',  'Wuppertal-Steinbeck',          8006619, 7.14063000, 51.2506790 ],
	[ 'KWU',  'Wuppertal-Unterbarmen',        8006620, 7.17121200, 51.2589290 ],
	[ 'KWV',  'Wuppertal-Vohwinkel',          8006718, 7.07159700, 51.2342590 ],
	[ 'KWZ', 'Wuppertal-Zoologischer Garten', 8006623, 7.10702000, 51.2434690 ],
	[ 'NWLZ', 'Wurlitz',                8006624, 11.9900100, 50.2531940 ],
	[ 'TWUM', 'Wurmlingen Mitte',       8006625, 8.77784200, 48.0017550 ],
	[ 'TWUN', 'Wurmlingen Nord',        8006626, 8.77538700, 48.0085280 ],
	[ 'UWCH', 'Wurzbach(Thür)',        8013360, 11.5431310, 50.4661720 ],
	[ 'LWZ',  'Wurzen',                 8013361, 12.7389720, 51.3644180 ],
	[ 'WWH',  'Wusterhausen(Dosse) NE', 8013363, 12.4567040, 52.8883510 ],
	[ 'BWUS', 'Wustermark',             8010389, 12.9397280, 52.5518510 ],
	[ 'LWUZ', 'Wusterwitz',             8013365, 12.3742500, 52.3851120 ],
	[ 'WRDN', 'Wustrau-Radensleben',    8012703, 12.8972650, 52.8572640 ],
	[ 'SWU',  'Wustweiler',             8006627, 7.03482400, 49.3988970 ],
	[ 'UWU',  'Wutha',                  8013366, 10.3965980, 50.9570990 ],
	[ 'WWU',  'Wutike',                 8013367, 12.3528540, 53.0043160 ],
	[ 'RWUT', 'Wutöschingen',          8006628, 8.36365400, 47.6620880 ],
	[ 'RWY',  'Wyhlen',                 8006629, 7.69091800, 47.5463280 ],
	[ 'MWAE', 'Wächterhof',            8006131, 11.7127310, 48.0335670 ],
	[ 'FWAE', 'Wächtersbach',          8006132, 9.29582800, 50.2539580 ],
	[ 'UWLH', 'Wölfershausen',         8013329, 10.4365880, 50.4915070 ],
	[ 'FWOE', 'Wölfersheim-Södel',    8006529, 8.81622000, 50.3973350 ],
	[ 'LWOZ', 'Wörlitz',               8013332, 12.4217320, 51.8378650 ],
	[ 'MWNS', 'Wörnitzstein',          8006533, 10.7144780, 48.7319770 ],
	[ 'FWRR', 'Wörrstadt',             8006534, 8.11471200, 49.8462510 ],
	[ 'FWOD', 'Wörsdorf',              8006535, 8.24932300, 50.2447520 ],
	[ 'MWTI', 'Wörth(Isar)',           8006537, 12.3329250, 48.6241820 ],
	[ 'NWOE', 'Wörth(Main)',           8006538, 9.15696000, 49.7934650 ],
	[ 'RWRT', 'Wörth(Rhein)',          8000254, 8.27314600, 49.0456780 ],
	[
		'RWRTL', 'Wörth(Rhein) Alte Bahnmeisterei',
		8079143, 8.26646500, 49.0486200
	],
	[ 'RWRTA', 'Wörth(Rhein) Badallee',      8079212, 8.24989100, 49.0559950 ],
	[ 'RWRTK', 'Wörth(Rhein) Badepark',      8079213, 8.24413000, 49.0585650 ],
	[ 'RWRTB', 'Wörth(Rhein) Bienwaldhalle', 8079142, 8.26087900, 49.0497800 ],
	[ 'RWRTP', 'Wörth(Rhein) Bürgerpark',   8079141, 8.25426700, 49.0508430 ],
	[ 'RWRD',  'Wörth(Rhein) Mozartstraße', 8006536, 8.25194400, 49.0551090 ],
	[ 'RWRTR', 'Wörth(Rhein) Rathaus',       8079211, 8.24980900, 49.0524230 ],
	[ 'RWRZ',  'Wörth(Rhein) Zügelstraße', 8006531, 8.26236300, 49.0529920 ],
	[ 'RWSN',  'Wössingen',                  8006539, 8.60512900, 49.0155080 ],
	[ 'RWSO',  'Wössingen Ost',              8070179, 8.60998100, 49.0157860 ],
	[ 'EWAP',  'Wülfrath-Aprath',            8006575, 7.07202300, 51.2678860 ],
	[ 'DWU',   'Wülknitz',                   8013348, 13.3892560, 51.3690210 ],
	[ 'UWF',   'Wünschendorf',               8010387, 12.0976720, 50.7976330 ],
	[ 'UWFN',  'Wünschendorf Nord',          8013349, 12.0779480, 50.8174380 ],
	[ 'BWUE',  'Wünsdorf-Waldstadt',         8013350, 13.4681450, 52.1655590 ],
	[ 'EWGD',  'Würgendorf',                 8006577, 8.14176600, 50.7600130 ],
	[ 'EWGT',  'Würgendorf (Ort)',           8006578, 8.12687500, 50.7569160 ],
	[ 'SWB',   'Würzbach(Saar)',             8006581, 7.19344100, 49.2441820 ],
	[ 'NWH',   'Würzburg Hbf',               8000260, 9.93578000, 49.8017960 ],
	[ 'NWS',   'Würzburg Süd',              8006582, 9.94350300, 49.7881930 ],
	[ 'NWZ',   'Würzburg-Zell',              8006586, 9.88459300, 49.8049380 ],
	[ 'DWD',   'Wüstenbrand',                8010388, 12.7564170, 50.8054830 ],
	[ 'WWSF',  'Wüstenfelde',                8013352, 13.1396100, 54.2302720 ],
	[ 'NWBZ',  'Wüstenselbitz',              8006588, 11.7095520, 50.2184240 ],
	[ 'HWUE',  'Wüsting',                    8006270, 8.33724800, 53.1181230 ],
	[ 'KX',    'Xanten',                      8006630, 6.44528700, 51.6596700 ],
	[ 'DZT',   'Zabeltitz',                   8013368, 13.5154000, 51.3498340 ],
	[ 'WZN',   'Zachun',                      8013370, 11.3244980, 53.5026530 ],
	[ 'LZA',   'Zahna',                       8013371, 12.7812110, 51.9199690 ],
	[ 'RZA',   'Zaisenhausen',                8006633, 8.81666400, 49.1047570 ],
	[ 'NZA',   'Zapfendorf',                  8006634, 10.9298940, 50.0182910 ],
	[ 'WZAR',  'Zarrendorf',                  8013373, 13.0800300, 54.2407470 ],
	[ 'BZS',   'Zeesen',                      8013376, 13.6351430, 52.2648630 ],
	[ 'WZE',   'Zehdenick(Mark)',             8013377, 13.3174820, 52.9793870 ],
	[ 'WZEN',  'Zehdenick-Neuhof',            8013378, 13.3457790, 53.0057000 ],
	[ 'NZ',    'Zeil',                        8006635, 10.5985190, 50.0051420 ],
	[ 'DZNH',  'Zeithain',                    8013381, 13.3445520, 51.3302060 ],
	[ 'LZ',    'Zeitz',                       8010390, 12.1314880, 51.0564520 ],
	[ 'RZLH',  'Zell(Harmersbach)',           8007101, 8.06470600, 48.3451000 ],
	[ 'RZ',    'Zell(Wiesental)',             8006641, 7.84914900, 47.7056260 ],
	[ 'FZR',   'Zell-Romrod',                 8006644, 9.19979700, 50.7271640 ],
	[ 'UZL',   'Zella-Mehlis',                8010391, 10.6741240, 50.6467210 ],
	[ 'UZLW',  'Zella-Mehlis West',           8013383, 10.6495350, 50.6585520 ],
	[ 'LZD',   'Zellendorf',                  8013384, 13.0668530, 51.8943100 ],
	[ 'NZLT',  'Zellerthal',                  8007338, 12.8651430, 49.1749340 ],
	[ 'WZP',   'Zempin',                      8013385, 13.9594470, 54.0659800 ],
	[ 'FZE',   'Zennern',                     8006647, 9.31772900, 51.1119830 ],
	[ 'BZEP',  'Zepernick(Bernau)',           8081560, 13.5336420, 52.6594490 ],
	[ 'FZEP',  'Zeppelinheim',                8006648, 8.60515300, 50.0365160 ],
	[ 'LZE',   'Zerbst/Anhalt',               8013389, 12.0889310, 51.9538210 ],
	[ 'KZE',   'Zerkall',                     8007824, 6.45393200, 50.6924390 ],
	[ 'BZF',   'Zernsdorf',                   8013392, 13.6933380, 52.2994040 ],
	[ 'WZIN',  'Zerrenthin',                  8013393, 14.0978950, 53.4993900 ],
	[ 'UZU',   'Zeulenroda unt Bf',           8013396, 12.0113510, 50.6593760 ],
	[ 'RZE',   'Zeutern Bf',                  8007135, 8.67752100, 49.1782510 ],
	[ 'RZEO',  'Zeutern Ost',                 8007136, 8.70336300, 49.1790870 ],
	[ 'RZES',  'Zeutern Sportplatz',          8079617, 8.67065000, 49.1779890 ],
	[ 'BZTH',  'Zeuthen',                     8081580, 13.6271730, 52.3489360 ],
	[ 'UZE',   'Zeutsch',                     8013398, 11.5082630, 50.7549270 ],
	[ 'LZI',   'Zielitz',                     8013402, 11.6802140, 52.2962930 ],
	[ 'LZIO',  'Zielitz Ort',                 8073410, 11.6763090, 52.2882850 ],
	[ 'FZB',   'Zierenberg',                  8006658, 9.30481300, 51.3651170 ],
	[ 'FZBR',  'Zierenberg-Rosental',         8006654, 9.29148300, 51.3676680 ],
	[ 'KZI',   'Zieverich',                   8006659, 6.62574000, 50.9492760 ],
	[ 'NZF',   'Zillendorf',                  8006660, 12.6732400, 49.3454770 ],
	[ 'BZIL',  'Ziltendorf',                  8013406, 14.6163350, 52.1995130 ],
	[ 'TZI',   'Zimmern(Main-Tauber)',        8006662, 9.79051000, 49.5953550 ],
	[ 'RZIM',  'Zimmern(b Seckach)',          8006661, 9.37197500, 49.4304110 ],
	[ 'FZM',   'Zimmersrode',                 8006663, 9.22519500, 51.0081440 ],
	[ 'WZ',    'Zinnowitz',                   8010392, 13.9033590, 54.0755640 ],
	[ 'NZI',   'Zirndorf',                    8006664, 10.9584680, 49.4438910 ],
	[ 'NZIK',  'Zirndorf Kneippallee',        8006666, 10.9453030, 49.4500290 ],
	[ 'WZIR',  'Zirtow-Leussow',              8013409, 12.8869200, 53.2810360 ],
	[ 'DZ',    'Zittau',                      8010393, 14.8057740, 50.9044610 ],
	[ 'DZH',   'Zittau Hp',                   8013410, 14.8169820, 50.8986710 ],
	[ 'DZS',   'Zittau Süd',                 8013411, 14.8147490, 50.8902380 ],
	[ 'DZV',   'Zittau Vorstadt',             8013412, 14.7918700, 50.8903640 ],
	[ 'DZL',   'Zoblitz',                     8013413, 14.7507410, 51.1235780 ],
	[
		'RVLZ', 'Zollhaus(Villingen-Schwenningen)',
		8006667, 8.50599700, 48.0408880
	],
	[ 'MZHP', 'Zollhaus-Petersthal',  8006670, 10.4180380, 47.6658250 ],
	[ 'MZO',  'Zorneding',            8006671, 11.8324560, 48.0896010 ],
	[ 'BZO',  'Zossen',               8010395, 13.4385710, 52.2189230 ],
	[ 'RZT',  'Zotzenbach',           8006672, 8.75322000, 49.6093670 ],
	[ 'DZSC', 'Zschaitz',             8013424, 13.1568250, 51.1688520 ],
	[ 'LZBN', 'Zscherben',            8013425, 11.8651250, 51.4676950 ],
	[ 'DZP',  'Zschopau',             8013427, 13.0659880, 50.7432420 ],
	[ 'DZPO', 'Zschopau Ost',         8013311, 13.0818780, 50.7445870 ],
	[ 'LZS',  'Zschortau',            8013428, 12.3615850, 51.4832660 ],
	[ 'RZHN', 'Zusenhofen',           8006678, 8.01846600, 48.5447280 ],
	[ 'RZUN', 'Zuzenhausen',          8006679, 8.82143900, 49.2973940 ],
	[ 'SZW',  'Zweibrücken Hbf',     8006680, 7.35664300, 49.2468050 ],
	[ 'LGDG', 'Zwenkau-Großdalzig',  8013447, 12.2711540, 51.2082640 ],
	[ 'DZWG', 'Zwickau Stadthalle',   8000292, 12.4980560, 50.7039200 ],
	[ 'DZWM', 'Zwickau Zentrum',      8000289, 12.4968930, 50.7155440 ],
	[ 'DZW',  'Zwickau(Sachs)Hbf',    8010397, 12.4747160, 50.7146680 ],
	[ 'DZWP', 'Zwickau-Pölbitz',     8013433, 12.4796620, 50.7372120 ],
	[ 'DZWS', 'Zwickau-Schedewitz',   8013434, 12.4950090, 50.7018510 ],
	[ 'NZWL', 'Zwiesel(Bay)',         8006684, 13.2263800, 49.0209410 ],
	[ 'NZWU', 'Zwieselau',            8006685, 13.2769370, 49.0067600 ],
	[ 'RZW',  'Zwingenberg(Baden)',   8006686, 9.04283000, 49.4160290 ],
	[ 'FZW',  'Zwingenberg(Bergstr)', 8006687, 8.60911900, 49.7259020 ],
	[ 'DZWO', 'Zwota',                8013437, 12.4277350, 50.3526210 ],
	[ 'DZWZ', 'Zwota-Zechenbach',     8013436, 12.3999870, 50.3511340 ],
	[ 'DZA',  'Zwotental',            8010398, 12.3638350, 50.3620700 ],
	[ 'DZI',  'Zwönitz',             8013435, 12.7978990, 50.6322320 ],
	[ 'LZBR', 'Zöberitz',            8013414, 12.0334580, 51.5046100 ],
	[ 'LZGL', 'Zörnigall',           8013418, 12.7315580, 51.8829350 ],
	[ 'BZUH', 'Zühlsdorf',           8013429, 13.4035350, 52.7326980 ],
	[ 'KZ',   'Zülpich',             8006674, 6.66247600, 50.6981740 ],
	[ 'WZS',  'Züssow',              8010396, 13.5481910, 53.9738790 ],
	[ 'TZU',  'Züttlingen',          8006676, 9.32911700, 49.2916570 ],
	[ 'TAPF', 'Äpfingen',            8079092, 9.85340900, 48.1526250 ],
	[ 'TOE',  'Öhringen Hbf',        8004623, 9.50270500, 49.2032140 ],
	[ 'TOEW', 'Öhringen West',       8004624, 9.48580400, 49.2001400 ],
	[ 'TCP',  'Öhringen-Cappel',     8004620, 9.52691900, 49.2019610 ],
	[ 'TOED', 'Ölbronn-Dürrn',      8004632, 8.75367700, 48.9858100 ],
	[ 'ROH',  'Ötigheim',            8004636, 8.24058200, 48.8885260 ],
	[ 'TOET', 'Ötisheim',            8004637, 8.81350800, 48.9665710 ],
	[ 'KUBP', 'Übach-Palenberg',     8005935, 6.09726500, 50.9243360 ],
	[ 'RUEM', 'Überlingen',          8005942, 9.16285300, 47.7691010 ],
	[ 'RUEB', 'Überlingen Therme',   8005937, 9.14564200, 47.7692690 ],
	[ 'RUEN', 'Überlingen-Nußdorf', 8005943, 9.18814400, 47.7548590 ],
	[ 'MUS',  'Übersee',             8005940, 12.4873380, 47.8220470 ],
	[ 'WUEK', 'Ückeritz',            8013161, 14.0498090, 54.0139180 ],
	[ 'KUD',  'Üdingen',             8007821, 6.48143700, 50.7281090 ],
	[ 'SUG',  'Ürzig(DB)',           8005945, 7.00480600, 49.9959330 ],

	[ 'XNTH',  '`t Harde' ],
	[ 'XBAAL', 'Aalter' ],
	[ 'XSA',   'Aarau' ],
	[ 'XSABO', 'Aarburg-Oftring' ],
	[ 'XFAH',  'Achiet' ],
	[ 'XSAA',  'Affoltern Albis' ],
	[ 'XFAG',  'Agde' ],
	[ 'XSAL',  'Aigle' ],
	[ 'XFAM',  'Aime-la-Plagne' ],
	[ 'XIAE',  'Airole' ],
	[ 'XSAI',  'Airolo' ],
	[ 'XFAX',  'Aix-en-Prov TGV' ],
	[ 'XFAI',  'Aix-les-Bains' ],
	[ 'XIAO',  'Alassio' ],
	[ 'XUAI',  'Alba Iulia' ],
	[ 'XIAT',  'Albate Camerlata' ],
	[ 'XIAB',  'Albenga' ],
	[ 'XFAL',  'Albertville' ],
	[ 'XFALN', 'Alencon' ],
	[ 'XFALE', 'Ales' ],
	[ 'XBAE',  'Alken BE' ],
	[ 'XNAL',  'Alkmaar' ],
	[ 'XAAH',  'Allerheiligenh' ],
	[ 'XNAO',  'Almelo' ],
	[ 'XNAOO', 'Almere Oostvaard' ],
	[ 'XNAR',  'Alphen a d Rijn' ],
	[ 'XSADF', 'Altdorf' ],
	[ 'XSAD',  'Altendorf' ],
	[ 'XAAL',  'Altenmarkt i.P.' ],
	[ 'XSAT',  'Altnau' ],
	[ 'XSAS',  'Altstätten SG' ],
	[ 'XFAE',  'Amberieu' ],
	[ 'XNAMV', 'Amersf Vathorst' ],
	[ 'XNAM',  'Amersfoort' ],
	[ 'XNAS',  'Amst Sloterdijk' ],
	[ 'XNAB',  'Amsterd Bijlmer' ],
	[ 'XNAC',  'Amsterdam C' ],
	[ 'XNAZ',  'Amsterdam Zuid' ],
	[ 'XNAA',  'Amsterdam-Amstel' ],
	[ 'XAAS',  'Amstetten' ],
	[ 'XSANF', 'Andelfingen' ],
	[ 'XSAN',  'Andermatt' ],
	[ 'XAAD',  'Andorf' ],
	[ 'XBAL',  'Angleur' ],
	[ 'XFANG', 'Angouleme' ],
	[ 'XBANS', 'Ans' ],
	[ 'XFAN',  'Antibes' ],
	[ 'XBAC',  'Antwerpen-Centr' ],
	[ 'XBAZ',  'Antwerpen-Zuid' ],
	[ 'XFAP',  'Apach' ],
	[ 'XNAE',  'Apeldoorn' ],
	[ 'XNAP',  'Appingedam' ],
	[ 'XUA',   'Arad' ],
	[ 'XSAB',  'Arbon' ],
	[ 'XSABS', 'Arbon S' ],
	[ 'XIAZ',  'Arezzo' ],
	[ 'XFAR',  'Argeles sur Mer' ],
	[ 'XFARL', 'Arles' ],
	[ 'XBAR',  'Arlon' ],
	[ 'XNAH',  'Arnhem' ],
	[ 'XAAR',  'Arnoldstein' ],
	[ 'XSAO',  'Arosa' ],
	[ 'XFAS',  'Arras' ],
	[ 'XFAY',  'Artenay' ],
	[ 'XSAG',  'Arth-Goldau' ],
	[ 'XFARV', 'Arvant' ],
	[ 'XTAS',  'As' ],
	[ 'XKA',   'Ashford' ],
	[ 'XKAI',  'Ashford Int' ],
	[ 'XBASS', 'Asse' ],
	[ 'XAAT',  'Attnang-Puchheim' ],
	[ 'XSAU',  'Au SG' ],
	[ 'XSAZ',  'Au ZH' ],
	[ 'XFAU',  'Aulnoye' ],
	[ 'XFAUM', 'Aumale' ],
	[ 'XFAUN', 'Auneau' ],
	[ 'XBAU',  'auvelais' ],
	[ 'XIAV',  'Aversa' ],
	[ 'XFAVN', 'Avesnes' ],
	[ 'XFAV',  'Avignon Centre' ],
	[ 'XFAVV', 'Avignon-TGV' ],
	[ 'XTBY',  'Babylon' ],
	[ 'XSBAE', 'Bäch' ],
	[ 'XABA',  'Bad Aussee' ],
	[ 'XABB',  'Bad Blumau' ],
	[ 'XABG',  'Bad Gastein' ],
	[ 'XABH',  'Bad Hofgastein' ],
	[ 'XAIS',  'Bad Ischl' ],
	[ 'XSRA',  'Bad Ragaz' ],
	[ 'XASBW', 'Bad Schall-Wall' ],
	[ 'XAVN',  'Bad Vigaun' ],
	[ 'XSZZ',  'Bad Zurzach' ],
	[ 'XSBA',  'Baden CH' ],
	[ 'XFBX',  'Baisieux' ],
	[ 'XSBAL', 'Balerna' ],
	[ 'XRBJ',  'Banova Jaruga' ],
	[ 'XFBH',  'Bantzenheim' ],
	[ 'XFBAY', 'Banyuls sur Mer' ],
	[ 'XEBS',  'Barcelona-S Andr' ],
	[ 'XNBA',  'Barendrecht' ],
	[ 'XFBD',  'Bar-le-Duc' ],
	[ 'XLBA',  'Bascharange-San' ],
	[ 'XSB',   'Basel SBB' ],
	[ 'XSBP',  'Basel SBB Dreisp' ],
	[ 'XSBJ',  'Basel St Johann' ],
	[ 'XSBD',  'Bassersdorf' ],
	[ 'XIBT',  'Battipaglia' ],
	[ 'XDBH',  'Baunhoej' ],
	[ 'XFBY',  'Bayonne' ],
	[ 'XBBE',  'Beernem' ],
	[ 'XMBS',  'Bekescsaba' ],
	[ 'XTBPB', 'Bela p Bezdezem' ],
	[ 'XFBF',  'Belfort' ],
	[ 'XFBA',  'Bellegarde (Ain)' ],
	[ 'XFBV',  'Belleville' ],
	[ 'XSBZ',  'Bellinzona' ],
	[ 'XSBEP', 'Belp' ],
	[ 'XLBUL', 'Belval-Lycee' ],
	[ 'XLBR',  'Belval-Redange' ],
	[ 'XLBUN', 'Belval-Universit' ],
	[ 'XLBS',  'Belvaux-Soleuvre' ],
	[ 'XTBP',  'Benesov n Plouc' ],
	[ 'XFBTR', 'Benestroff' ],
	[ 'XFBEF', 'Benfeld' ],
	[ 'XFBE',  'Bening' ],
	[ 'XJB',   'Beograd' ],
	[ 'XBBC',  'Berchem' ],
	[ 'XLBC',  'Berchem Hp LU' ],
	[ 'XSBRG', 'Berg CH' ],
	[ 'XNBZ',  'Bergen op Zoom' ],
	[ 'XFBER', 'Bergues' ],
	[ 'XSBN',  'Bergün/Bravuogn' ],
	[ 'XSBLG', 'Berlingen' ],
	[ 'XSBLS', 'Berlingen S' ],
	[ 'XSBE',  'Bern' ],
	[ 'XFBEY', 'Bernay' ],
	[ 'XTBU',  'Beroun' ],
	[ 'XFBTM', 'Berthelming' ],
	[ 'XLBG',  'Bertrange-Strass' ],
	[ 'XBBX',  'Bertrix' ],
	[ 'XFB',   'Besancon' ],
	[ 'XFBI',  'Besancon Viotte' ],
	[ 'XLXBB', 'Bettembg Gr FR' ],
	[ 'XLB',   'Bettembourg' ],
	[ 'XSBW',  'Bettwiesen' ],
	[ 'XLBZ',  'Betzdorf (LUX)' ],
	[ 'XIBVA', 'Bevera' ],
	[ 'XNBK',  'Beverwijk' ],
	[ 'XSBX',  'Bex' ],
	[ 'XFBZ',  'Beziers' ],
	[ 'XFBR',  'Biarritz' ],
	[ 'XSBC',  'Biasca' ],
	[ 'XSBBS', 'Biberist RBS' ],
	[ 'XSBB',  'Biberist RM' ],
	[ 'XABIA', 'Bichlbach-Almk' ],
	[ 'XABI',  'Bichlbach-Berw.' ],
	[ 'XSBL',  'Biel/Bienne' ],
	[ 'XBBA',  'Bierset-Awans' ],
	[ 'XTBI',  'Bilina' ],
	[ 'XDBL',  'Billum' ],
	[ 'XSBT',  'Bilten' ],
	[ 'XTBKN', 'Bily Kostel n.N.' ],
	[ 'XSBM',  'Birmensdorf' ],
	[ 'XABO',  'Bischofshofen' ],
	[ 'XFBLV', 'Blainville-D' ],
	[ 'XUBL',  'Blaj' ],
	[ 'XFBLM', 'Blanc Mesnil' ],
	[ 'XSBS',  'Blausee-Mitholz' ],
	[ 'XNBL',  'Blerick' ],
	[ 'XABD',  'Blindenmarkt' ],
	[ 'XABL',  'Bludenz' ],
	[ 'XABS',  'Böckstein' ],
	[ 'XNBD',  'Bodegraven' ],
	[ 'XSBOD', 'Bodio' ],
	[ 'XFBN',  'Boen' ],
	[ 'XABC',  'Böheimkirchen' ],
	[ 'XTBO',  'Bohumin' ],
	[ 'XPBOL', 'Boleslawiec' ],
	[ 'XFBOW', 'Bollwiller' ],
	[ 'XIBC',  'Bologna C' ],
	[ 'XIBZ',  'Bolzano/Bozen' ],
	[ 'XBBDL', 'Boondael/Boondaa' ],
	[ 'XFBJ',  'Bordeaux-St-J' ],
	[ 'XIBD',  'Bordighera' ],
	[ 'XIBOD', 'Borgo S Dalmazzo' ],
	[ 'XNBO',  'Born' ],
	[ 'XDBOP', 'Borup' ],
	[ 'XSBOH', 'Bottighofen' ],
	[ 'XDBV',  'Boulevarden' ],
	[ 'XFBB',  'Bourg-en-Bresse' ],
	[ 'XFBGS', 'Bourges' ],
	[ 'XFBM',  'Bourg-St Maurice' ],
	[ 'XFBZV', 'Bouzonville' ],
	[ 'XDBM',  'Bramming' ],
	[ 'XUBS',  'Brasov' ],
	[ 'XYB',   'Bratislava hl.st' ],
	[ 'XYBZ',  'Bratislava-Petra' ],
	[ 'XABR',  'Braunau a Inn' ],
	[ 'XTBE',  'Breclav' ],
	[ 'XTXBE', 'Breclav Gr AT' ],
	[ 'XNBR',  'Breda' ],
	[ 'XDBR',  'Bredebro' ],
	[ 'XAB',   'Bregenz' ],
	[ 'XABHF', 'Bregenz See' ],
	[ 'XFBRY', 'Breil sur Roya' ],
	[ 'XIBN',  'Brennero/Brenner' ],
	[ 'XIBCA', 'Brescia' ],
	[ 'XIBX',  'Bressan./Brixen' ],
	[ 'XBBS',  'Bressoux' ],
	[ 'XFBRT', 'Brest FR' ],
	[ 'XTBD',  'Breziny u Decina' ],
	[ 'XSBG',  'Brig' ],
	[ 'XABT',  'Brixen im Thale' ],
	[ 'XABX',  'Brixlegg' ],
	[ 'XTBR',  'Brno hl.n.' ],
	[ 'XDBN',  'Broens' ],
	[ 'XSBRH', 'Bronschhofen' ],
	[ 'XABM',  'Bruck a. d. Mur' ],
	[ 'XABK',  'Bruck a.d.Leitha' ],
	[ 'XABF',  'Bruck-Fusch' ],
	[ 'XSBRU', 'Brugg AG' ],
	[ 'XBBR',  'Brugge' ],
	[ 'XFBAH', 'Brumath' ],
	[ 'XIBB',  'Brunico/Bruneck' ],
	[ 'XSBNN', 'Brunnen' ],
	[ 'XBBME', 'Brux M Eurostar' ],
	[ 'XBBL',  'Bruxelles-Centr' ],
	[ 'XBBLX', 'Bruxelles-Lux' ],
	[ 'XBB',   'Bruxelles-Midi' ],
	[ 'XBBNL', 'Bruxelles-N-Aero' ],
	[ 'XBBN',  'Bruxelles-Nord' ],
	[ 'XSBU',  'Buchs SG' ],
	[ 'XUBN',  'Bucuresti Nord' ],
	[ 'XMBK',  'Budapest-Keleti' ],
	[ 'XMBN',  'Budapest-Nyugati' ],
	[ 'XNBP',  'Buitenpost' ],
	[ 'XSBH',  'Bülach' ],
	[ 'XFBG',  'Bully-Grenay' ],
	[ 'XDBU',  'Bur' ],
	[ 'XABU',  'Burgfried' ],
	[ 'XSBGL', 'Bürglen' ],
	[ 'XEBU',  'Burgos' ],
	[ 'XFBS',  'Busigny' ],
	[ 'XSBUS', 'Bussnang' ],
	[ 'XIBU',  'Busto Arsizio' ],
	[ 'XPBY',  'Bydgoszcz Gl' ],
	[ 'XICIG', 'C.Isarco/Gossens' ],
	[ 'XSCZ',  'Cadenazzo' ],
	[ 'XFCK',  'Calais Ville' ],
	[ 'XFFE',  'Calais-Frethun' ],
	[ 'XECM',  'Caldas de M.' ],
	[ 'XICTF', 'Campo d Tr/Freif' ],
	[ 'XFCA',  'Cannes' ],
	[ 'XFCB',  'Cannes la Bocca' ],
	[ 'XLCP',  'Capellen' ],
	[ 'XSCR',  'Capolago-Riva S' ],
	[ 'XFCAB', 'Carbonne' ],
	[ 'XFCN',  'Carcassonne' ],
	[ 'XICAR', 'Carimate' ],
	[ 'XFCNO', 'Carnoules' ],
	[ 'XICB',  'Casteld./Ehrenb.' ],
	[ 'XFCAN', 'Castelnaudary' ],
	[ 'XSCA',  'Castione-Arbedo' ],
	[ 'XFCAV', 'Cavaillon' ],
	[ 'XICTL', 'Centallo' ],
	[ 'XLCS',  'Cents-Hamm' ],
	[ 'XFCE',  'Cerbere' ],
	[ 'XTCC',  'Cernovice u Ch' ],
	[ 'XTCKA', 'Ceska Kamenice' ],
	[ 'XTC',   'Ceska Kubice' ],
	[ 'XTCL',  'Ceska Lipa hl.n.' ],
	[ 'XTCLS', 'Ceska Lipa Strel' ],
	[ 'XTTR',  'Ceska Trebova' ],
	[ 'XTCB',  'Ceske Budejovice' ],
	[ 'XTCV',  'Ceske Velenice' ],
	[ 'XFCM',  'Chalons en Champ' ],
	[ 'XFCS',  'Chalon-sur-Saone' ],
	[ 'XFCY',  'Chambery' ],
	[ 'XFCG',  'Champigneulles' ],
	[ 'XBCH',  'Charleroi-Sud' ],
	[ 'XFCAR', 'Chat Arnoux St A' ],
	[ 'XFCD',  'Chateau-du-Loir' ],
	[ 'XFCX',  'Chateauroux' ],
	[ 'XFCT',  'Chateau-Thierry' ],
	[ 'XBCL',  'Chatelet' ],
	[ 'XFCH',  'Chauny' ],
	[ 'XTCH',  'Cheb' ],
	[ 'XTCS',  'Cheb-Skalka' ],
	[ 'XFCSG', 'Chelles-Gournay' ],
	[ 'XFCGG', 'Chenay-Gagny' ],
	[ 'XBCE',  'Chenee' ],
	[ 'XFCHB', 'Cherbourg' ],
	[ 'XSCH',  'Chiasso' ],
	[ 'XICK',  'Chiusa/Klausen' ],
	[ 'XICU',  'Chiusi-Chianci.T' ],
	[ 'XTCD',  'Chodov' ],
	[ 'XPCJ',  'Chojnow' ],
	[ 'XTCO',  'Chomutov' ],
	[ 'XTCM',  'Chomutov Mesto' ],
	[ 'XTCY',  'Chotyne' ],
	[ 'XTCR',  'Chrastava' ],
	[ 'XTCA',  'Chrastava-And H' ],
	[ 'XTCHR', 'Chribska' ],
	[ 'XSC',   'Chur' ],
	[ 'XFCIG', 'Cintegabelle' ],
	[ 'XFCLE', 'Clermont-Ferrand' ],
	[ 'XFCL',  'Clerval' ],
	[ 'XLCV',  'Clervaux' ],
	[ 'XNCV',  'Coevorden' ],
	[ 'XFCLL', 'Collioure' ],
	[ 'XFC',   'Colmar' ],
	[ 'XFCQ',  'Combs la Ville-Q' ],
	[ 'XIC',   'Como S.G.' ],
	[ 'XFCP',  'Compiegne' ],
	[ 'XICGL', 'Conegliano' ],
	[ 'XFCF',  'Conflans-Jarny' ],
	[ 'XFCOM', 'Corbehem' ],
	[ 'XFCOE', 'Corbeil-Essones' ],
	[ 'XSCO',  'Cornaux' ],
	[ 'XFCOS', 'Cosne' ],
	[ 'XSCS',  'Cossonay' ],
	[ 'XFCOL', 'Coulommiers' ],
	[ 'XFCSN', 'Courcelles s N' ],
	[ 'XFCOU', 'Coutras' ],
	[ 'XFCR',  'Creil' ],
	[ 'XFCU',  'Culmont-Chalind' ],
	[ 'XFCZ',  'Culoz' ],
	[ 'XICUN', 'Cuneo' ],
	[ 'XUCU',  'Curtici' ],
	[ 'XPCD',  'Czechowice-Dzied' ],
	[ 'XPCW',  'Czerwiensk' ],
	[ 'XSDA',  'Dachsen' ],
	[ 'XSDS',  'Dagmersellen' ],
	[ 'XSDN',  'Däniken' ],
	[ 'XSDD',  'Davos Dorf' ],
	[ 'XSDP',  'Davos Platz' ],
	[ 'XFDX',  'Dax' ],
	[ 'XNDE',  'De Eschmarke' ],
	[ 'XMD',   'Debrecen' ],
	[ 'XTD',   'Decin hl.n.' ],
	[ 'XTDV',  'Decin vychod' ],
	[ 'XTD Z', 'Decin zapad.n.' ],
	[ 'XTDC',  'Decin-Certova V' ],
	[ 'XTDPR', 'Decin-Priper' ],
	[ 'XTDP',  'Decin-Prost Zleb' ],
	[ 'XNDD',  'Delden' ],
	[ 'XSDE',  'Delemont' ],
	[ 'XNDT',  'Delft' ],
	[ 'XNDZ',  'Delfzijl' ],
	[ 'XNDH',  'Den Haag C' ],
	[ 'XNDHH', 'Den Haag HS' ],
	[ 'XNDL',  'Den Helder' ],
	[ 'XBDL',  'Denderleeuw' ],
	[ 'XTDS',  'Desenice' ],
	[ 'XIDS',  'Desenzano G S' ],
	[ 'XIDE',  'Desio' ],
	[ 'XFDEE', 'Dettwiller' ],
	[ 'XUD',   'Deva' ],
	[ 'XNDV',  'Deventer' ],
	[ 'XYDN',  'DevinskaNovaVes' ],
	[ 'XIDM',  'Diano Marina' ],
	[ 'XFDM',  'Diemeringen' ],
	[ 'XBDBK', 'Diepenbeek' ],
	[ 'XSDH',  'Diessenhofen' ],
	[ 'XSDHS', 'Diessenhofen S' ],
	[ 'XSD',   'Dietlikon' ],
	[ 'XFDI',  'Dieulouard' ],
	[ 'XLDI',  'Differdange' ],
	[ 'XFD',   'Dijon' ],
	[ 'XFDN',  'Dijon PN' ],
	[ 'XLDR',  'Dippach-Reckange' ],
	[ 'XIDT',  'Dobbiaco/Toblach' ],
	[ 'XZD',   'Dobova' ],
	[ 'XZXDO', 'Dobova Gr HR' ],
	[ 'XDDS',  'Doestrup Sdrj' ],
	[ 'XTDK',  'Doksy' ],
	[ 'XFDO',  'Dole' ],
	[ 'XBDG',  'Dolhain-Gileppe' ],
	[ 'XTDH',  'Dolni Habartice' ],
	[ 'XTDD',  'Dolni Podluzi' ],
	[ 'XTDA',  'Dolni Poustevna' ],
	[ 'XTDL',  'Dolni Zleb' ],
	[ 'XTDZ',  'Dolni Zleb zast' ],
	[ 'XTDO',  'Domazlice' ],
	[ 'XTDI',  'Domina' ],
	[ 'XLDM',  'Dommeldange' ],
	[ 'XID',   'Domodossola' ],
	[ 'XNDO',  'Dordrecht' ],
	[ 'XADG',  'Dorfgastein' ],
	[ 'XADO',  'Dornbirn' ],
	[ 'XADS',  'Dornbirn-Schoren' ],
	[ 'XSDO',  'Dottikon-Din' ],
	[ 'XFDR',  'Dourges' ],
	[ 'XLDF',  'Drauffelt' ],
	[ 'XNDR',  'Dronten' ],
	[ 'XTDU',  'Duchcov' ],
	[ 'XRDS',  'Dugo Selo' ],
	[ 'XNDU',  'Duivendrecht' ],
	[ 'XFDK',  'Dunkerque' ],
	[ 'XDDY',  'Dyreby' ],
	[ 'XKEI',  'Ebbsfleet Int' ],
	[ 'XAEB',  'Eben im Pongau' ],
	[ 'XAEF',  'Ebenfurth' ],
	[ 'XFEH',  'Ebersheim' ],
	[ 'XBED',  'Ede BE' ],
	[ 'XNE',   'Ede Centrum' ],
	[ 'XNEW',  'Ede-Wageningen' ],
	[ 'XSEK',  'Effretikon' ],
	[ 'XSEG',  'Eglisau' ],
	[ 'XSEN',  'Egnach' ],
	[ 'XAEZ',  'Ehrwald(Zugsp.B)' ],
	[ 'XNEI',  'Eindhoven' ],
	[ 'XSES',  'Einsiedeln' ],
	[ 'XDEY',  'Ejby' ],
	[ 'XFEL',  'Elne' ],
	[ 'XAEL',  'Elsbethen' ],
	[ 'XSEB',  'Emmenbrücke' ],
	[ 'XBEN',  'Engis' ],
	[ 'XAEN',  'Enns' ],
	[ 'XNES',  'Enschede' ],
	[ 'XFE',   'Epernay' ],
	[ 'XFEI',  'Epierre-St L' ],
	[ 'XFEN',  'Epinal' ],
	[ 'XSE',   'Erlen' ],
	[ 'XSEM',  'Ermatingen' ],
	[ 'XSEMS', 'Ermatingen S' ],
	[ 'XBEQ',  'Erquelinnes' ],
	[ 'XFES',  'Erstein' ],
	[ 'XSEF',  'Erstfeld' ],
	[ 'XDE',   'Esbjerg' ],
	[ 'XAEU',  'Eschenau AT' ],
	[ 'XLEA',  'Esch-Sur-Alzette' ],
	[ 'XDES',  'Eskilstrup' ],
	[ 'XBES',  'Essen BE' ],
	[ 'XFETP', 'Etampes' ],
	[ 'XLET',  'Ettelbruck' ],
	[ 'XSEW',  'Etzwilen' ],
	[ 'XBEP',  'Eupen' ],
	[ 'XFEV',  'Evreux' ],
	[ 'XNEM',  'Eygelshov Markt' ],
	[ 'XAFS',  'Faak am See' ],
	[ 'XSFD',  'Faido' ],
	[ 'XFF',   'Faulquemont' ],
	[ 'XFFHL', 'Fegersheim Lipsh' ],
	[ 'XSFE',  'Fehraltorf' ],
	[ 'XAFK',  'Feldkirch' ],
	[ 'XAFT',  'Feldkirchen(Kär)' ],
	[ 'XAFX',  'Felixdorf' ],
	[ 'XMBF',  'Ferencvaros' ],
	[ 'XIFE',  'Ferrara' ],
	[ 'XAFB',  'Fieberbrunn' ],
	[ 'XEFI',  'Figueras' ],
	[ 'XSFI',  'Filisur' ],
	[ 'XIFLM', 'Finale Ligure M' ],
	[ 'XIFRS', 'Firenze S.M.N' ],
	[ 'XSFM',  'Flamatt' ],
	[ 'XEFL',  'Flassa' ],
	[ 'XAFG',  'Flaurling' ],
	[ 'XFFL',  'Flers' ],
	[ 'XAWFL', 'Floridsdorf' ],
	[ 'XSFU',  'Flüelen' ],
	[ 'XSFL',  'Flums' ],
	[ 'XAFC',  'Föderlach' ],
	[ 'XFFT',  'Fontaine' ],
	[ 'XFFA',  'Fontainebleau' ],
	[ 'XFFS',  'Fontan-Saorge' ],
	[ 'XFFB',  'Forbach' ],
	[ 'XBFM',  'Forest-Midi' ],
	[ 'XIFF',  'Fort./Franzensf.' ],
	[ 'XIF',   'Fossano' ],
	[ 'XFFLT', 'Fourchambault' ],
	[ 'XBFR',  'Fraipont' ],
	[ 'XAFA',  'Frankenmarkt' ],
	[ 'XTFA',  'Frant Lazne Auqa' ],
	[ 'XTF',   'Frantiskovy Lazn' ],
	[ 'XAFR',  'Frastanz' ],
	[ 'XSFA',  'Frauenfeld' ],
	[ 'XDF',   'Fredericia' ],
	[ 'XSFB',  'Freienbach CH' ],
	[ 'XSFF',  'Frenkendorf-Füll' ],
	[ 'XSF',   'Fribourg' ],
	[ 'XAF',   'Friesach' ],
	[ 'XDFV',  'Frisvardvej' ],
	[ 'XAFW',  'Fritzens-Wattens' ],
	[ 'XFFX',  'Frontenex' ],
	[ 'XFFD',  'Frouard' ],
	[ 'XSFR',  'Frutigen' ],
	[ 'XAFU',  'Fürnitz' ],
	[ 'XFFU',  'Futuroscope' ],
	[ 'XDGR',  'Gaarde' ],
	[ 'XFGN',  'Gagny' ],
	[ 'XFGAA', 'Gaillon-Aubevoye' ],
	[ 'XIGA',  'Gallarate' ],
	[ 'XSGM',  'Gampel-Steg' ],
	[ 'XFGD',  'Gandrange' ],
	[ 'XFGAN', 'Gannat' ],
	[ 'XAGD',  'Gänserndorf' ],
	[ 'XFGA',  'Gardanne' ],
	[ 'XPG',   'Gdansk Glowny' ],
	[ 'XPGOL', 'Gdansk Oliwa' ],
	[ 'XPGWR', 'Gdansk Wrzeszcz' ],
	[ 'XPGD',  'Gdynia Gl Os' ],
	[ 'XAGEI', 'Geinberg' ],
	[ 'XNLU',  'Geleen-Lutterade' ],
	[ 'XSGK',  'Gelterkinden' ],
	[ 'XIGF',  'Gemona Friuli' ],
	[ 'XSGE',  'Geneve' ],
	[ 'XSGEA', 'Geneve-Aeroport' ],
	[ 'XBGK',  'Genk' ],
	[ 'XIGP',  'Genova PP' ],
	[ 'XBGB',  'Gentbrugge' ],
	[ 'XBGD',  'Gent-Dampoort' ],
	[ 'XBGP',  'Gent-St-Pieters' ],
	[ 'XSGF',  'Gerlafingen' ],
	[ 'XAGE',  'Gerling/Pinzgau' ],
	[ 'XEG',   'Gerona(Viajeros)' ],
	[ 'XFGE',  'Gevrey' ],
	[ 'XAGB',  'Gießenbach' ],
	[ 'XSGNR', 'Gisikon-Root' ],
	[ 'XFGI',  'Gisors' ],
	[ 'XSGI',  'Giubiasco' ],
	[ 'XDGJ',  'Gjesing' ],
	[ 'XNGB',  'Glanerbrug' ],
	[ 'XSG',   'Glattbrugg' ],
	[ 'XSGA',  'Glattfelden' ],
	[ 'XAGL',  'Gloggnitz' ],
	[ 'XDGU',  'Glumsoe' ],
	[ 'XAGN',  'Gmünd NÖ' ],
	[ 'XPGN',  'Gniezno' ],
	[ 'XLGB',  'Goebelsmuhle' ],
	[ 'XAGA',  'Golling-Abtenau' ],
	[ 'XSGO',  'Goppenstein' ],
	[ 'XPGW',  'Gorzow Wlkp' ],
	[ 'XSGS',  'Göschenen' ],
	[ 'XSGG',  'Gossau SG' ],
	[ 'XSGL',  'Gottlieben' ],
	[ 'XAGT',  'Götzendorf' ],
	[ 'XAGZ',  'Götzis' ],
	[ 'XNG',   'Gouda' ],
	[ 'XBGY',  'Gouvy' ],
	[ 'XFGR',  'Graffenstaden' ],
	[ 'XAGR',  'Gramatneusiedl' ],
	[ 'XEGR',  'Granollers-Centr' ],
	[ 'XAGG',  'Gratw.-Gratkorn' ],
	[ 'XAG',   'Graz Hbf' ],
	[ 'XAGO',  'Graz Ost' ],
	[ 'XDGB',  'Gredstedbro' ],
	[ 'XSGRN', 'Grenchen Nord' ],
	[ 'XFG',   'Grenoble' ],
	[ 'XFGS',  'Gresy sur Isere' ],
	[ 'XFGZ',  'Gretz-Armainvill' ],
	[ 'XAGRB', 'Gries' ],
	[ 'XAGI',  'Gries/Pinzgau' ],
	[ 'XAGP',  'Griesk-Gallspach' ],
	[ 'XAGM',  'Gröbming' ],
	[ 'XBGR',  'Groenendaal' ],
	[ 'XNGR',  'Groningen' ],
	[ 'XAGS',  'Groß Schwechat' ],
	[ 'XDGA',  'Guldager' ],
	[ 'XAGK',  'Guntramsd-Kaiser' ],
	[ 'XAGUR', 'Gurten' ],
	[ 'XSGU',  'Güttingen' ],
	[ 'XMG',   'Györ' ],
	[ 'XBHA',  'Haaltert' ],
	[ 'XNHE',  'Haarlem' ],
	[ 'XNHLS', 'Haarl-Spaarnwoud' ],
	[ 'XSHW',  'Haeggenschwil-W' ],
	[ 'XAHU',  'Hagenau im Innkr' ],
	[ 'XFHD',  'Hagondange' ],
	[ 'XFHG',  'Haguenau' ],
	[ 'XAHM',  'Haiming' ],
	[ 'XAHT',  'Hall in Tirol' ],
	[ 'XAHL',  'Hallein' ],
	[ 'XAHE',  'Hallwang-Elixh.' ],
	[ 'XAHA',  'Hard-Fussach' ],
	[ 'XBHT',  'Hasselt' ],
	[ 'XAHI',  'Hatting' ],
	[ 'XSHL',  'Hauptwil' ],
	[ 'XAHAS', 'Haus' ],
	[ 'XFHA',  'Hayange' ],
	[ 'XFHZ',  'Hazebrouck' ],
	[ 'XDHED', 'Hedehusene' ],
	[ 'XDHEE', 'Hee' ],
	[ 'XSHR',  'Heerbrugg' ],
	[ 'XNHR',  'Heerenveen' ],
	[ 'XNH',   'Heerlen' ],
	[ 'XNHK',  'Heerlen d Kissel' ],
	[ 'XMXHY', 'Hegyeshal Gr AT' ],
	[ 'XMHY',  'Hegyeshalom' ],
	[ 'XAHP',  'Heiterw-Plansee' ],
	[ 'XNHM',  'Helmond' ],
	[ 'XFHE',  'Hendaye' ],
	[ 'XSHE',  'Hendschiken' ],
	[ 'XNHL',  'Hengelo' ],
	[ 'XFHB',  'Henin-Beaumont' ],
	[ 'XDHEN', 'Henne' ],
	[ 'XBHR',  'Herentals' ],
	[ 'XBHE',  'Hergenrath' ],
	[ 'XAHN',  'Hernals' ],
	[ 'XFHN',  'Herny' ],
	[ 'XFHH',  'Herrlisheim Colm' ],
	[ 'XBHL',  'Herstal' ],
	[ 'XBHZ',  'Herzele' ],
	[ 'XSHZ',  'Herzogenbuchsee' ],
	[ 'XAHB',  'Herzogenburg' ],
	[ 'XNHO',  'Hillegom' ],
	[ 'XNHI',  'Hilversum' ],
	[ 'XNHIS', 'Hilversum Sp' ],
	[ 'XDHM',  'Hjerm' ],
	[ 'XTHN',  'Hnevice' ],
	[ 'XFHC',  'Hochfelden' ],
	[ 'XAHF',  'Hochfilzen' ],
	[ 'XAHO',  'Hochzirl' ],
	[ 'XBHO',  'Hoeilaart' ],
	[ 'XDHT',  'Hoeje Taastrup' ],
	[ 'XNHH',  'Hoek v. Holland' ],
	[ 'XAHH',  'Hohenau' ],
	[ 'XAHS',  'Hohenems' ],
	[ 'XDHO',  'Holstebro' ],
	[ 'XFHM',  'Hombourg Ht' ],
	[ 'XNHD',  'Hoofddorp' ],
	[ 'XNHG',  'Hoogeveen' ],
	[ 'XNHS',  'Hoogezand-Sapp' ],
	[ 'XAHG',  'Hopfgarten' ],
	[ 'XAHGB', 'Hopfgarten / B' ],
	[ 'XSHG',  'Horgen' ],
	[ 'XSHB',  'Horn (Bodensee)' ],
	[ 'XSHBS', 'Horn(Bodensee) S' ],
	[ 'XTHB',  'Horni Blatna' ],
	[ 'XTHD',  'Horni Dvoriste' ],
	[ 'XTHK',  'Horni Kamenice' ],
	[ 'XTHP',  'Horni Podluzi' ],
	[ 'XTHPT', 'Horni Poustevna' ],
	[ 'XTHV',  'Horovice' ],
	[ 'XAHOG', 'Hörsching' ],
	[ 'XTHR',  'Hradek n. N.' ],
	[ 'XTHM',  'Hranice n Morave' ],
	[ 'XTHY',  'Hrebeny' ],
	[ 'XSHU',  'Hüntwangen-Wil' ],
	[ 'XAHUT', 'Hüttau' ],
	[ 'XBHU',  'Huy' ],
	[ 'XDHVD', 'Hviding' ],
	[ 'XDHYL', 'Hyllerslev' ],
	[ 'XPIL',  'Ilawa Glowna' ],
	[ 'XSIM',  'Immensee' ],
	[ 'XIIM',  'Imperia PM' ],
	[ 'XAIB',  'Imsterberg' ],
	[ 'XAIP',  'Imst-Pitztal' ],
	[ 'XBIM',  'Ingelmunster' ],
	[ 'XFIW',  'Ingwiller' ],
	[ 'XAI',   'Innsbruck Hbf' ],
	[ 'XAIH',  'Innsbruck Höttg' ],
	[ 'XAIW',  'Innsbruck Westbf' ],
	[ 'XPIW',  'Inowroclaw' ],
	[ 'XSIO',  'Interlaken Ost' ],
	[ 'XSI',   'Interlaken West' ],
	[ 'XAIZ',  'Inzing' ],
	[ 'XEIR',  'Irun' ],
	[ 'XFIS',  'Is sur Tille' ],
	[ 'XIIT',  'Iselle di Trasqu' ],
	[ 'XIXIT', 'Iselle Grenze CH' ],
	[ 'XRIG',  'Ivanic Grad' ],
	[ 'XTJP',  'Jablonne / P' ],
	[ 'XDJP',  'Janderup' ],
	[ 'XPJZ',  'Jankowa Zaganska' ],
	[ 'XTJU',  'Janovice n Uh' ],
	[ 'XAJD',  'Jedlersdorf' ],
	[ 'XTJL',  'Jedlova' ],
	[ 'XDJE',  'Jegum' ],
	[ 'XPJG',  'Jelenia Gora' ],
	[ 'XBJ',   'Jemelle' ],
	[ 'XAJB',  'Jenbach' ],
	[ 'XAJBZ', 'Jenbach Zillert' ],
	[ 'XZJ',   'Jesenice' ],
	[ 'XSJE',  'Jestetten' ],
	[ 'XFJM',  'Jeumont' ],
	[ 'XTJD',  'Jiretin pod Jedl' ],
	[ 'XTJI',  'Jirkov z.' ],
	[ 'XFJF',  'Joeuf' ],
	[ 'XFJY',  'Joigny' ],
	[ 'XAJ',   'Judenburg' ],
	[ 'XFJU',  'Juvisy' ],
	[ 'XTKA',  'Kadan' ],
	[ 'XSKI',  'Kaiseraugust' ],
	[ 'XFKH',  'Kalhausen' ],
	[ 'XAKAL', 'Kalsdorf' ],
	[ 'XAK',   'Kalwang' ],
	[ 'XNKM',  'Kampen Zuid' ],
	[ 'XSKA',  'Kandersteg' ],
	[ 'XAKP',  'Kapfenberg' ],
	[ 'XTKVD', 'Karlovy V dol.n.' ],
	[ 'XTKV',  'Karlovy Vary' ],
	[ 'XTKVV', 'Karlovy V-Dvory' ],
	[ 'XPKA',  'Katowice Osobowa' ],
	[ 'XLKT',  'Kautenbach' ],
	[ 'XSKH',  'Kehlhof' ],
	[ 'XMK',   'Kelebia' ],
	[ 'XMBL',  'Kelenföld' ],
	[ 'XAKM',  'Kematen/Tirol' ],
	[ 'XSKW',  'Kesswil' ],
	[ 'XNKE',  'Kesteren' ],
	[ 'XSKB',  'Kilchberg' ],
	[ 'XSKS',  'Killwangen-S' ],
	[ 'XAKB',  'Kindberg' ],
	[ 'XAKG',  'Kirchberg i.T.' ],
	[ 'XAKL',  'Kirchbichl' ],
	[ 'XAKIT', 'Kittsee' ],
	[ 'XAKIH', 'Kitz / Hahnenk' ],
	[ 'XAKI',  'Kitzbühel' ],
	[ 'XAKT',  'Klagenfurt Hbf' ],
	[ 'XTKY',  'Klatovy' ],
	[ 'XAKE',  'Kledering' ],
	[ 'XAKS',  'Klein Schwechat' ],
	[ 'XLKB',  'Kleinbettingen' ],
	[ 'XSKT',  'Kloten' ],
	[ 'XAKF',  'Knittelfeld' ],
	[ 'XSKO',  'Koblenz CH' ],
	[ 'XDKH',  'Koebenhavn H' ],
	[ 'XDKHL', 'Koebenhvs Lufthv' ],
	[ 'XDKG',  'Koege' ],
	[ 'XFKO',  'Kogenheim' ],
	[ 'XAKO',  'Kolbnitz' ],
	[ 'XDKO',  'Kolding' ],
	[ 'XTKI',  'Kolin' ],
	[ 'XMKO',  'Komarom' ],
	[ 'XPKN',  'Konin' ],
	[ 'XNKB',  'Koog Bloemwijk' ],
	[ 'XNKZ',  'Koog-Zaandijk' ],
	[ 'XMKR',  'Körmend' ],
	[ 'XDKS',  'Korsoer' ],
	[ 'XBKO',  'Kortenberg' ],
	[ 'XBKK',  'Kortrijk' ],
	[ 'XPK',   'Kostrzyn' ],
	[ 'XTKO',  'Kovarska' ],
	[ 'XPKR',  'Krakow Gl Osob' ],
	[ 'XTKRP', 'Kralovske Porici' ],
	[ 'XTKR',  'Kralupy n.Vl.' ],
	[ 'XAKA',  'Kranebitten' ],
	[ 'XZKJ',  'Kranj' ],
	[ 'XTKC',  'Kraslice' ],
	[ 'XTKP',  'Kraslice p Vlek' ],
	[ 'XTKCP', 'Kraslice Predm' ],
	[ 'XTKLP', 'Krasna Lipa' ],
	[ 'XTKLM', 'Krasna Lipa mest' ],
	[ 'XAKD',  'Krems(Donau)' ],
	[ 'XSKRB', 'Kreuzl.Bernrain' ],
	[ 'XSKR',  'Kreuzlingen' ],
	[ 'XSKL',  'Kreuzlingen Haf.' ],
	[ 'XAKK',  'Krichdorf a d Kr' ],
	[ 'XFKM',  'Krimmeri-Meinau' ],
	[ 'XTKM',  'Krimov' ],
	[ 'XNKA',  'Krommenie-As' ],
	[ 'XNKR',  'Kropswolde' ],
	[ 'XZKR',  'Krsko' ],
	[ 'XAKR',  'Krumpendorf' ],
	[ 'XPKZG', 'Krzewina Zgorzel' ],
	[ 'XPKY',  'Krzyz' ],
	[ 'XAKU',  'Kuchl' ],
	[ 'XAKN',  'Kufstein' ],
	[ 'XAKUN', 'Kundl' ],
	[ 'XPKU',  'Kunowice' ],
	[ 'XSKN',  'Küssnacht a R' ],
	[ 'XRKU',  'Kutina' ],
	[ 'XPKT',  'Kutno' ],
	[ 'XYKU',  'Kuty' ],
	[ 'XTKT',  'Kytlice' ],
	[ 'XFLBS', 'La Bastide S L' ],
	[ 'XFWBI', 'La Brigue' ],
	[ 'XFLAT', 'La Charite' ],
	[ 'XFGPL', 'La Plaine' ],
	[ 'XFLRY', 'La Roche s Yon' ],
	[ 'XFLST', 'La Souterraine' ],
	[ 'XALAA', 'Laa a d Thaya' ],
	[ 'XSLH',  'Lachen' ],
	[ 'XNZLW', 'Lage Zwaluwe' ],
	[ 'XALN',  'Lähn' ],
	[ 'XFLAE', 'L\'Aigle' ],
	[ 'XLLM',  'Lamadelaine' ],
	[ 'XALB',  'Lambach' ],
	[ 'XSLMC', 'Lamone-Cadempino' ],
	[ 'XALE',  'Landeck' ],
	[ 'XBLD',  'Landen' ],
	[ 'XNLG',  'Landgraaf' ],
	[ 'XSLQ',  'Landquart' ],
	[ 'XFLA',  'Landry' ],
	[ 'XBLO',  'Langdorp' ],
	[ 'XALA',  'Langen a.Arlberg' ],
	[ 'XSLT',  'Langenthal' ],
	[ 'XALK',  'Langkampfen' ],
	[ 'XSLL',  'Läufelfingen' ],
	[ 'XSLF',  'Laufen' ],
	[ 'XSLN',  'Laufenburg' ],
	[ 'XSLA',  'Lausanne' ],
	[ 'XSLAF', 'Lausanne-Flon' ],
	[ 'XSLS',  'Lausen' ],
	[ 'XALAH', 'Lauterach' ],
	[ 'XFLTG', 'Lauterbourg' ],
	[ 'XILVM', 'Laveno Mombello' ],
	[ 'XFLB',  'Le Bourget' ],
	[ 'XFLC',  'Le Creusot TGV' ],
	[ 'XFHV',  'Le Havre' ],
	[ 'XFLM',  'Le Mans' ],
	[ 'XFRVM', 'Le Raincy' ],
	[ 'XFTP',  'Le Treport Mers' ],
	[ 'XBLK',  'Lebbeke' ],
	[ 'XNLW',  'Leeuwarden' ],
	[ 'XPLE',  'Legnica' ],
	[ 'XALZ',  'Leibnitz' ],
	[ 'XNL',   'Leiden' ],
	[ 'XNLL',  'Leiden Lamme' ],
	[ 'XALT',  'Leithen' ],
	[ 'XNLY',  'Lelystad' ],
	[ 'XDLM',  'Lem' ],
	[ 'XALND', 'Lend' ],
	[ 'XSLW',  'Lengwil' ],
	[ 'XFLN',  'Lens' ],
	[ 'XSLB',  'Lenzburg' ],
	[ 'XALEZ', 'Lenzing' ],
	[ 'XALO',  'Leoben Hbf' ],
	[ 'XALG',  'Leogang' ],
	[ 'XBLB',  'Leopoldsburg' ],
	[ 'XALM',  'Lermoos' ],
	[ 'XFLE',  'Lerouville' ],
	[ 'XFLAC', 'Les Arcs' ],
	[ 'XFAO',  'Les-Aubrais-Orl' ],
	[ 'XZLB',  'Lesce-Bled' ],
	[ 'XLLD',  'Leudelange' ],
	[ 'XSLE',  'Leuk' ],
	[ 'XBLE',  'Leuven' ],
	[ 'XFLZ',  'Lezignan (Aude)' ],
	[ 'XTL',   'Liberec' ],
	[ 'XBLIG', 'Liege (G)' ],
	[ 'XALI',  'Lienz' ],
	[ 'XBLI',  'Liers' ],
	[ 'XSLI',  'Liestal' ],
	[ 'XALZN', 'Liezen' ],
	[ 'XFLI',  'Lille' ],
	[ 'XFLIE', 'Lille Europa' ],
	[ 'XILMN', 'Limone' ],
	[ 'XAL',   'Linz Hbf' ],
	[ 'XALW',  'Linz Wegscheid' ],
	[ 'XPLIL', 'Lipinki Luzyckie' ],
	[ 'XTLL',  'Lipova Sluknova' ],
	[ 'XZLJ',  'Litija' ],
	[ 'XTLM',  'Litomerice Mesto' ],
	[ 'XILI',  'Livorno Centrale' ],
	[ 'XZL',   'Ljubljana' ],
	[ 'XSLC',  'Locarno' ],
	[ 'XALH',  'Lochau-Hoerbranz' ],
	[ 'XDLF',  'Loeftgard' ],
	[ 'XMLO',  'Lököshaza' ],
	[ 'XFLNG', 'Longueau' ],
	[ 'XFLY',  'Longwy' ],
	[ 'XFLS',  'Lons-Le-Saunier' ],
	[ 'XALDF', 'Loosdorf' ],
	[ 'XFLR',  'Lorraine-Louv' ],
	[ 'XSLO',  'Lottstetten' ],
	[ 'XFLO',  'Lourches' ],
	[ 'XFL',   'Lourdes' ],
	[ 'XTLO',  'Lovosice' ],
	[ 'XPLU',  'Luban Slaski' ],
	[ 'XALU',  'Ludesch' ],
	[ 'XSL',   'Lugano' ],
	[ 'XTLS',  'Luh n Svatavou' ],
	[ 'XIL',   'Luino' ],
	[ 'XFLUQ', 'Lumes' ],
	[ 'XDLUN', 'Lundby' ],
	[ 'XDLD',  'Lunde DK' ],
	[ 'XDLU',  'Lunderskov' ],
	[ 'XFLUN', 'Lunel' ],
	[ 'XFLU',  'Luneville' ],
	[ 'XSLP',  'Lupfig' ],
	[ 'XALUU', 'Lustenau' ],
	[ 'XSLZ',  'Luterbach-Attish' ],
	[ 'XFLUB', 'Lutterbach' ],
	[ 'XFLT',  'Lutzelbourg' ],
	[ 'XLL',   'Luxembourg' ],
	[ 'XSLU',  'Luzern' ],
	[ 'XFLPD', 'Lyon Part-Dieu' ],
	[ 'XAL K', 'Lz-Kleinmünchen' ],
	[ 'XNMA',  'Maassluis' ],
	[ 'XNMT',  'Maastricht' ],
	[ 'XTMC',  'Machnin' ],
	[ 'XTMR',  'Machnin hrad' ],
	[ 'XFMCV', 'Macon Ville' ],
	[ 'XFMAL', 'Macon-Loche-TGV' ],
	[ 'XSMF',  'Maienfeld' ],
	[ 'XAMS',  'Maishfn-Saalbach' ],
	[ 'XTMV',  'Mala Velen' ],
	[ 'XPMA',  'Malbork' ],
	[ 'XPMAL', 'Malczyce' ],
	[ 'XAMO',  'Mallnitz-Oberv.' ],
	[ 'XVM',   'Malmö' ],
	[ 'XLMR',  'Mamer' ],
	[ 'XLMY',  'Mamer Lycee' ],
	[ 'XSMM',  'Mammern(Bodens)' ],
	[ 'XSMMS', 'Mammern(Bodens)S' ],
	[ 'XBMA',  'Manage' ],
	[ 'XSMB',  'Mannenbach' ],
	[ 'XSMBS', 'Mannenbach S' ],
	[ 'XLMN',  'Manternach' ],
	[ 'XAMG',  'Marchegg' ],
	[ 'XBMD',  'Marche-les-Dames' ],
	[ 'XBMP',  'Marchienne-au-P' ],
	[ 'XAMR',  'Marchtrenk' ],
	[ 'XZM',   'Maribor' ],
	[ 'XTMVE', 'Markvartice' ],
	[ 'XFMSS', 'Marle-sur-Serre' ],
	[ 'XBMR',  'Marloie' ],
	[ 'XFMVC', 'Marne la Vallee' ],
	[ 'XFMBL', 'Marseille Blanc' ],
	[ 'XFM',   'Marseille-St-Ch' ],
	[ 'XNMH',  'Martenshoek' ],
	[ 'XSMA',  'Martigny' ],
	[ 'XFMAG', 'Martigues' ],
	[ 'XSMW',  'Märwil' ],
	[ 'XAM',   'Matrei' ],
	[ 'XFMB',  'Maubeuge' ],
	[ 'XAMT',  'Mautern' ],
	[ 'XAMY',  'Mayrhofen' ],
	[ 'XBMCH', 'Mechelen' ],
	[ 'XUM',   'Medias' ],
	[ 'XSM',   'Meiringen' ],
	[ 'XAME',  'Melk' ],
	[ 'XSMS',  'Mels' ],
	[ 'XFMEL', 'Melun' ],
	[ 'XSME',  'Mendrisio' ],
	[ 'XFME',  'Menton' ],
	[ 'XSMEN', 'Menznau' ],
	[ 'XIMM',  'Merano/Meran' ],
	[ 'XBMER', 'Merchtem' ],
	[ 'XBME',  'Merelbeke' ],
	[ 'XLM',   'Mersch' ],
	[ 'XLMT',  'Mertert' ],
	[ 'XFMEH', 'Merxheim' ],
	[ 'XAMD',  'Messendorf' ],
	[ 'XFMZV', 'Metz-Ville' ],
	[ 'XFMU',  'Meuse' ],
	[ 'XLMC',  'Michelau' ],
	[ 'XAMI',  'Micheldorf' ],
	[ 'XDMF',  'Middelfart' ],
	[ 'XPMIE', 'Miekinia' ],
	[ 'XTMD',  'Mikulasovice d n' ],
	[ 'XIMB',  'Milano C' ],
	[ 'XIMG',  'Milano Greco P' ],
	[ 'XIMP',  'Milano PG' ],
	[ 'XBMM',  'Milmort' ],
	[ 'XTMM',  'Mimon' ],
	[ 'XAMN',  'Mining' ],
	[ 'XFMI',  'Miramas' ],
	[ 'XAMH',  'Mitterberghütten' ],
	[ 'XAMV',  'Mitterdf-Veitsch' ],
	[ 'XAMIX', 'Mixnitz-Bärensch' ],
	[ 'XTMB',  'Ml Boleslav hl n' ],
	[ 'XTMY',  'Mlyny (CZ)' ],
	[ 'XFMOD', 'Modane' ],
	[ 'XSMI',  'Möhlin' ],
	[ 'XBML',  'Mol' ],
	[ 'XSMOS', 'Mols' ],
	[ 'XFMH',  'Mommenheim' ],
	[ 'XFMC',  'Monaco-M.Carlo' ],
	[ 'XIMW',  'Monguelfo/Welsbg' ],
	[ 'XBMS',  'Mons' ],
	[ 'XFMD',  'Montbeliard' ],
	[ 'XFMN',  'Montelimar' ],
	[ 'XSMY',  'Monthey' ],
	[ 'XFMLV', 'Montlucon Ville' ],
	[ 'XFMOM', 'Montmelian' ],
	[ 'XFMND', 'Mont-Notre-Dame' ],
	[ 'XFMO',  'Montpellier' ],
	[ 'XSMO',  'Montreux' ],
	[ 'XIMOZ', 'Monza' ],
	[ 'XAMB',  'Moosbierbaum/H' ],
	[ 'XFMOR', 'Moret-Veneux' ],
	[ 'XSMG',  'Morges' ],
	[ 'XFMOH', 'Morhange' ],
	[ 'XCM',   'Moskva' ],
	[ 'XMMO',  'Mosonmagyarovar' ],
	[ 'XTMO',  'Most' ],
	[ 'XAMTZ', 'Mötz' ],
	[ 'XFMOU', 'Mouchard' ],
	[ 'XFMSA', 'Moulins-s-Allier' ],
	[ 'XBMN',  'Mouscron' ],
	[ 'XBMT',  'Moustier' ],
	[ 'XSMU',  'Moutier' ],
	[ 'XFMT',  'Moutiers-Salins' ],
	[ 'XFMG',  'Moyeuvre Grande' ],
	[ 'XSMH',  'Mühlehorn' ],
	[ 'XAMHM', 'Mühlheim' ],
	[ 'XAMM',  'Mühl-Möllbrücke' ],
	[ 'XBMU',  'Muizen' ],
	[ 'XFMVD', 'Mulhouse Dornach' ],
	[ 'XFMV',  'Mulhouse Ville' ],
	[ 'XSMBU', 'Münchenbuchsee' ],
	[ 'XFMUM', 'Mundolsheim' ],
	[ 'XBMZ',  'Munkzwalm' ],
	[ 'XLMB',  'Munsbach' ],
	[ 'XSMUS', 'Münsingen CH' ],
	[ 'XFMST', 'Munster FR' ],
	[ 'XAMW',  'Münster-Wiesing' ],
	[ 'XSMN',  'Münstlg-Scherz' ],
	[ 'XSMUO', 'Muolen' ],
	[ 'XSMR',  'Murg' ],
	[ 'XAMZ',  'Mürzzuschlag' ],
	[ 'XAMU',  'Musau' ],
	[ 'XFMUS', 'Mussidan' ],
	[ 'XSMT',  'Muttenz' ],
	[ 'XDNV',  'Naestved' ],
	[ 'XMNV',  'Nagymaros-Visegr' ],
	[ 'XBNA',  'Namur' ],
	[ 'XFNT',  'Nancois Tronvill' ],
	[ 'XFN',   'Nancy' ],
	[ 'XFNA',  'Nantes' ],
	[ 'XINAC', 'Napoli C' ],
	[ 'XFNB',  'Narbonne' ],
	[ 'XSN',   'Nebikon' ],
	[ 'XBN',   'Neerpelt' ],
	[ 'XTNJ',  'Nejdek' ],
	[ 'XTNJZ', 'Nejdek zast' ],
	[ 'XFNP',  'Nemours-St-Pierr' ],
	[ 'XAND',  'Nendeln' ],
	[ 'XANE',  'Nenzing' ],
	[ 'XBNE',  'Nessonvaux' ],
	[ 'XTNT',  'Nestedice' ],
	[ 'XTNM',  'Nestemice' ],
	[ 'XANF',  'Nettingsdorf' ],
	[ 'XSNC',  'Neuchatel' ],
	[ 'XBNC',  'Neufchateau' ],
	[ 'XFNE',  'Neufchateau' ],
	[ 'XSNE',  'Neuhausen CH' ],
	[ 'XSNK',  'Neukirch-Egnach' ],
	[ 'XANK',  'Neumarkt-Kallham' ],
	[ 'XANKD', 'Neumarkt-Köstend' ],
	[ 'XANG',  'Neuratting' ],
	[ 'XFNC',  'Nice Ville' ],
	[ 'XSNB',  'Niederbipp' ],
	[ 'XSNI',  'Niederglatt' ],
	[ 'XLNK',  'Niederkorn' ],
	[ 'XNNA',  'Nieuw Amsterdam' ],
	[ 'XNNS',  'Nieuwe Schans' ],
	[ 'XNNM',  'Nijmegen' ],
	[ 'XFNI',  'Nimes' ],
	[ 'XDNA',  'Noerre Alslev' ],
	[ 'XDNN',  'Noerre-Nebel' ],
	[ 'XDNP',  'Noerreport' ],
	[ 'XLNZ',  'Noertzange' ],
	[ 'XFNR',  'Nogent le Retrou' ],
	[ 'XFNO',  'Noisy-le-Sec' ],
	[ 'XFNDB', 'Notre Dame B' ],
	[ 'XRNG',  'Nova Gradiska' ],
	[ 'XRNK',  'Nova Kapela' ],
	[ 'XTNR',  'Nova Role' ],
	[ 'XTNRZ', 'Nova Role zast' ],
	[ 'XINV',  'Novara' ],
	[ 'XTNH',  'Nove Hamry' ],
	[ 'XTNHZ', 'Nove Hamry zast' ],
	[ 'XTNS',  'Nove Sedlo u Lok' ],
	[ 'XYNZ',  'Nove Zamky' ],
	[ 'XFNV',  'Noveant' ],
	[ 'XJNB',  'Novi Beograd' ],
	[ 'XJNS',  'Novi Sad' ],
	[ 'XRNV',  'Novska' ],
	[ 'XTNB',  'Novy Bor' ],
	[ 'XPND',  'Nowe Drezdenko' ],
	[ 'XFNY',  'Noyon' ],
	[ 'XDNE',  'Ny Ellebjerg' ],
	[ 'XDNY',  'Nyborg' ],
	[ 'XMNH',  'Nyiregyhaza' ],
	[ 'XDNK',  'Nykoebing F' ],
	[ 'XTN',   'Nymburk hl.n.' ],
	[ 'XAOA',  'Oberalm' ],
	[ 'XSOG',  'Oberburg' ],
	[ 'XSOB',  'Oberglatt' ],
	[ 'XAOB',  'Oberhofen' ],
	[ 'XLOK',  'Oberkorn' ],
	[ 'XFOM',  'Obermodern' ],
	[ 'XAOM',  'Obernberg-Alth' ],
	[ 'XSOR',  'Oberrieden' ],
	[ 'XSOT',  'Oberriet' ],
	[ 'XBOB',  'Obourg' ],
	[ 'XDOD',  'Odense' ],
	[ 'XDOG',  'Oelgod' ],
	[ 'XDKHO', 'Oerestad' ],
	[ 'XFOE',  'Oermingen' ],
	[ 'XDOP',  'Oesterport' ],
	[ 'XLOE',  'Oetrange' ],
	[ 'XDOB',  'Oksboel' ],
	[ 'XROK',  'Okucani' ],
	[ 'XNOD',  'Oldenzaal' ],
	[ 'XTOL',  'Oldrichov u N' ],
	[ 'XBOL',  'Olen' ],
	[ 'XIOM',  'Olivetta S Mich' ],
	[ 'XTO',   'Olomouc hl.n.' ],
	[ 'XTOV',  'Olovi' ],
	[ 'XSOL',  'Olten' ],
	[ 'XNOM',  'Ommen' ],
	[ 'XFO',   'Onville' ],
	[ 'XBO',   'Oostende' ],
	[ 'XPO',   'Opole Glowne' ],
	[ 'XSOP',  'Oppikon' ],
	[ 'XBOW',  'Opwijk' ],
	[ 'XFOR',  'Orange' ],
	[ 'XFOC',  'Orchies' ],
	[ 'XDOH',  'Orehoved' ],
	[ 'XFOL',  'Orleans' ],
	[ 'XIOV',  'Orvieto' ],
	[ 'XRO',   'Osijek' ],
	[ 'XNO',   'Oss' ],
	[ 'XSOM',  'Ostermundingen' ],
	[ 'XTOH',  'Ostrava hl.n.' ],
	[ 'XTOI',  'Ostrava-Svinov' ],
	[ 'XPOM',  'Oswiecim' ],
	[ 'XSOS',  'Othmarsingen' ],
	[ 'XAOE',  'Ötztal' ],
	[ 'XDOU',  'Outrup' ],
	[ 'XNOV',  'Overveen' ],
	[ 'XIPW',  'P.Gardena/Waidbr' ],
	[ 'XDPA',  'Padborg' ],
	[ 'XIPP',  'Padova' ],
	[ 'XFPS',  'Pagny-s-Moselle' ],
	[ 'XFPAN', 'Pantin' ],
	[ 'XTPAR', 'Pardubice' ],
	[ 'XFPMP', 'Paris Montparnas' ],
	[ 'XFPN',  'Paris Nord' ],
	[ 'XFPA',  'Paris-Austerlitz' ],
	[ 'XFPO',  'Paris-Est' ],
	[ 'XFPG',  'Paris-G-d-Lyon' ],
	[ 'XFPSL', 'Paris-St-Lazare' ],
	[ 'XAPD',  'Parndorf' ],
	[ 'XAPT',  'Paternion-Feistr' ],
	[ 'XAPA',  'Patsch' ],
	[ 'XFPU',  'Pau' ],
	[ 'XIPVI', 'Pavia' ],
	[ 'XAPG',  'Peggau-Deutschf' ],
	[ 'XFPTE', 'Peltre' ],
	[ 'XBP',   'Pepinster' ],
	[ 'XFPGX', 'Perigueux' ],
	[ 'XTPEK', 'Pernink' ],
	[ 'XFPE',  'Perpignan' ],
	[ 'XIPDG', 'Peschiera d Gard' ],
	[ 'XLP',   'Petange' ],
	[ 'XAPK',  'Peterskirchen' ],
	[ 'XFPTC', 'Petit Croix' ],
	[ 'XSPF',  'Pfäffikon SZ' ],
	[ 'XAPFW', 'Pfarrwerfen' ],
	[ 'XAPL',  'Pflach' ],
	[ 'XAPC',  'Pichl' ],
	[ 'XPPN',  'Piensk' ],
	[ 'XAPV',  'Pill-Vomperbach' ],
	[ 'XSXPT', 'Pino Grenze IT' ],
	[ 'XIPI',  'Pisa C' ],
	[ 'XTPLA', 'Plesna' ],
	[ 'XUPV',  'Ploiesti Vest' ],
	[ 'XTPZ',  'Plzen hl.n.' ],
	[ 'XAPN',  'Pöchlarn' ],
	[ 'XFPT',  'Poitiers' ],
	[ 'XTPI',  'Pomezi n O' ],
	[ 'XFPM',  'Pont-a-Mousson' ],
	[ 'XSPT',  'Pontresina' ],
	[ 'XFPXE', 'Pont-Ste-Maxence' ],
	[ 'XFPV',  'Pont-St-Vincent' ],
	[ 'XIPD',  'Pordenone' ],
	[ 'XFPR',  'Port Vendres' ],
	[ 'XEPB',  'Port-Bou' ],
	[ 'XAPW',  'Pörtschach a.W.' ],
	[ 'XTPO',  'Potucky' ],
	[ 'XTPOZ', 'Potucky zastavka' ],
	[ 'XFPSU', 'Pougues-les-Eaux' ],
	[ 'XPPG',  'Poznan Glowny' ],
	[ 'XTP',   'Praha hl.n.' ],
	[ 'XTPH',  'Praha-Holesovice' ],
	[ 'XTPM',  'Praha-Smichov' ],
	[ 'XTPV',  'Praha-Vrsovice' ],
	[ 'XAPM',  'Pram-Haag' ],
	[ 'XSPR',  'Pratteln' ],
	[ 'XUP',   'Predeal' ],
	[ 'XAPR',  'Pregarten' ],
	[ 'XTPR',  'Prerov' ],
	[ 'XAPRD', 'Prinzersdorf' ],
	[ 'XBPO',  'Profondsart' ],
	[ 'XPPRY', 'Przylep' ],
	[ 'XZP',   'Ptuj' ],
	[ 'XAPO',  'Puch-Oberalm' ],
	[ 'XAPZ',  'Pusarnitz' ],
	[ 'XBQ',   'Quevy' ],
	[ 'XFQ',   'Quimper' ],
	[ 'XARA',  'Radstadt' ],
	[ 'XSRF',  'Rafz' ],
	[ 'XARW',  'Rankweil' ],
	[ 'XSRZ',  'Ranzo-S-Abbondio' ],
	[ 'XARK',  'Rattenbg-Krams' ],
	[ 'XIREC', 'Re' ],
	[ 'XSRM',  'Rebstein-Marbach' ],
	[ 'XFRD',  'Reding' ],
	[ 'XERG',  'Redondela de Gal' ],
	[ 'XSRC',  'Reichenbach Kt' ],
	[ 'XSRE',  'Reichenburg' ],
	[ 'XFRS',  'Reims' ],
	[ 'XARE',  'Reith' ],
	[ 'XDRE',  'Rejsby' ],
	[ 'XARWL', 'Rekawinkel' ],
	[ 'XSRN',  'Rekingen AG' ],
	[ 'XFRF',  'Remelfing' ],
	[ 'XFRM',  'Remilly' ],
	[ 'XFRT',  'Remiremont' ],
	[ 'XFR',   'Rennes' ],
	[ 'XTRE',  'Retenice' ],
	[ 'XAREZ', 'Retz' ],
	[ 'XART',  'Reutte in Tirol' ],
	[ 'XARTS', 'Reutte Schulz.' ],
	[ 'XSRH',  'Rheineck' ],
	[ 'XSRD',  'Rheinfelden' ],
	[ 'XDRB',  'Ribe' ],
	[ 'XDRBN', 'Ribe Noerremark' ],
	[ 'XSRW',  'Richterswil' ],
	[ 'XARI',  'Ried i Innkreis' ],
	[ 'XARD',  'Riedenburg' ],
	[ 'XARZ',  'Rietz' ],
	[ 'XIRI',  'Rimini' ],
	[ 'XDRG',  'Ringkoebing' ],
	[ 'XDRI',  'Ringsted' ],
	[ 'XIRP',  'Rio di Pusteria' ],
	[ 'XSRB',  'Rivera-Bironico' ],
	[ 'XFRV',  'Rivesaltes' ],
	[ 'XFROA', 'Roanne' ],
	[ 'XIRL',  'Robilante' ],
	[ 'XIROV', 'Roccavione' ],
	[ 'XLRD',  'Rodange' ],
	[ 'XDR',   'Roedby F' ],
	[ 'XDRO',  'Roedby Faerge' ],
	[ 'XDRD',  'Roedekro' ],
	[ 'XDRN',  'Roenne' ],
	[ 'XFRSW', 'Roeschwoog' ],
	[ 'XSRO',  'Roggwil-Berg' ],
	[ 'XSRY',  'Roggwil-Wynau' ],
	[ 'XARH',  'Rohr-Bad Hall' ],
	[ 'XTRO',  'Rokycany' ],
	[ 'XIRM',  'Roma Termini' ],
	[ 'XSR',   'Romanshorn' ],
	[ 'XSRHF', 'Romanshorn (See)' ],
	[ 'XFRO',  'Rombas' ],
	[ 'XBRO',  'Ronet' ],
	[ 'XLRT',  'Roodt' ],
	[ 'XNRD',  'Roosendaal' ],
	[ 'XARP',  'Roppen' ],
	[ 'XSRS',  'Rorschach' ],
	[ 'XSRSH', 'Rorschach Hafen' ],
	[ 'XSRSS', 'Rorschach Hf S' ],
	[ 'XARB',  'Rosenbach' ],
	[ 'XAXRB', 'Rosenbach Gr SI' ],
	[ 'XDRK',  'Roskilde' ],
	[ 'XTRV',  'Rotava' ],
	[ 'XSRTB', 'Rothenburg' ],
	[ 'XSRTT', 'Rothenthurm' ],
	[ 'XSRR',  'Rothrist' ],
	[ 'XSRK',  'Rotkreuz' ],
	[ 'XNRL',  'Rotterd Lombardi' ],
	[ 'XNRN',  'Rotterd Noord G' ],
	[ 'XNRC',  'Rotterdam C' ],
	[ 'XNRS',  'RotterdamStadion' ],
	[ 'XTRN',  'Roudnice n Labem' ],
	[ 'XFROU', 'Rouffach' ],
	[ 'XIROT', 'Rovato' ],
	[ 'XIRR',  'Rovereto' ],
	[ 'XIRG',  'Rovigo' ],
	[ 'XARU',  'Rum' ],
	[ 'XJRU',  'Ruma' ],
	[ 'XTRU',  'Rumburk' ],
	[ 'XSRU',  'Rümlang' ],
	[ 'XSRP',  'Rupperswil' ],
	[ 'XSRL',  'Rüschlikon' ],
	[ 'XTRS',  'Rusova' ],
	[ 'XSRT',  'Rüthi SG' ],
	[ 'XTRY',  'Rybniste' ],
	[ 'XPR',   'Rzepin' ],
	[ 'XFSAC', 'S Avre l Chambre' ],
	[ 'XFSMV', 'S Michel Valloir' ],
	[ 'XASPS', 'S Peter-Seitenst' ],
	[ 'XISCI', 'S.Cand./Innichen' ],
	[ 'XASA',  'Saalfelden' ],
	[ 'XSSA',  'Safenwil' ],
	[ 'XFSZE', 'Saincaize' ],
	[ 'XFSAS', 'Saintes' ],
	[ 'XBSG',  'Saint-Ghislain' ],
	[ 'XSSZ',  'Salez-Sennwald' ],
	[ 'XAAI',  'Salzb Aiglhof' ],
	[ 'XASLF', 'Salzb Liefering' ],
	[ 'XASBA', 'Salzburg Aigen' ],
	[ 'XASB',  'Salzburg Hbf' ],
	[ 'XASBP', 'Salzburg Parsch' ],
	[ 'XASSA', 'Salzburg Sam' ],
	[ 'XASBS', 'Salzburg Süd' ],
	[ 'XASG',  'Salzburg-Gnigl' ],
	[ 'XSSD',  'Samedan' ],
	[ 'XSSMT', 'Samstagern' ],
	[ 'XISAR', 'San Remo' ],
	[ 'XLSC',  'Sandweiler-Cont' ],
	[ 'XFSN',  'Sanry sur Nied' ],
	[ 'XRXSJ', 'Sapjane Gr SI' ],
	[ 'XNSO',  'Sappemeer Oost' ],
	[ 'XSSR',  'Sargans' ],
	[ 'XFSB',  'Sarrebourg' ],
	[ 'XFSM',  'Sarreguemines' ],
	[ 'XFSI',  'Sarreinsming' ],
	[ 'XFSRI', 'Sathonay-Rilieux' ],
	[ 'XFSUD', 'Saumur' ],
	[ 'XFSV',  'Saverne' ],
	[ 'XISAV', 'Savona Letimbro' ],
	[ 'XAML',  'Sb Mülln-Altstdt' ],
	[ 'XASVZ', 'Schaan-Vaduz' ],
	[ 'XBS',   'Schaerbeek' ],
	[ 'XSS',   'Schaffhsn CH' ],
	[ 'XASFU', 'Schaftenau' ],
	[ 'XASH',  'Schärding' ],
	[ 'XAA',   'Scharnitz' ],
	[ 'XNSE',  'Scheemda' ],
	[ 'XNSC',  'Schiedam-Rott.W.' ],
	[ 'XLSL',  'Schifflange' ],
	[ 'XSSF',  'Schindellegi-F.' ],
	[ 'XNSP',  'Schiphol' ],
	[ 'XASL',  'Schladming' ],
	[ 'XASBL', 'Schönbichl' ],
	[ 'XASCH', 'Schönwies' ],
	[ 'XLSW',  'Schouweiler' ],
	[ 'XASN',  'Schruns' ],
	[ 'XSSBU', 'Schübelb-Buttiko' ],
	[ 'XBSU',  'Schulen' ],
	[ 'XASW',  'Schwarzach-St.V.' ],
	[ 'XASC',  'Schwaz' ],
	[ 'XFSWM', 'Schwindratzheim' ],
	[ 'XSSY',  'Schwyz' ],
	[ 'XSST',  'Scuol-Tarasp' ],
	[ 'XTSBZ', 'Sebuzin' ],
	[ 'XAS',   'Seefeld in Tirol' ],
	[ 'XASK',  'Seekirchen a W' ],
	[ 'XDSE',  'Sejstrup' ],
	[ 'XFSL',  'Selestat' ],
	[ 'XASZ',  'Selzthal' ],
	[ 'XISER', 'Seregno' ],
	[ 'XISGI', 'Sesto S Giovanni' ],
	[ 'XFSE',  'Sete' ],
	[ 'XSSV',  'Sevelen' ],
	[ 'XZSN',  'Sevnica' ],
	[ 'XNSH',  's-Hertogenbosch' ],
	[ 'XJSI',  'Sid' ],
	[ 'XSSW',  'Siebnen-Wangen' ],
	[ 'XSSH',  'Siegershausen' ],
	[ 'XPSIZ', 'Sieniawa Zarska' ],
	[ 'XFSIK', 'Sierck-les-Bains' ],
	[ 'XSSI',  'Sierre/Siders' ],
	[ 'XDSIG', 'Sig' ],
	[ 'XUSG',  'Sighisoara' ],
	[ 'XASIL', 'Sillian' ],
	[ 'XASLZ', 'Silz' ],
	[ 'XUSI',  'Simeria' ],
	[ 'XUSN',  'Sinaia' ],
	[ 'XSSN',  'Sion' ],
	[ 'XSSC',  'Sissach' ],
	[ 'XNSI',  'Sittard' ],
	[ 'XDSB',  'Skaerbaek' ],
	[ 'XDSJ',  'Skjern' ],
	[ 'XZSL',  'Skofja Loka' ],
	[ 'XDSGE', 'Slagelse' ],
	[ 'XRSL',  'Slavonski Brod' ],
	[ 'XPSLB', 'Slubice' ],
	[ 'XTSLN', 'Sluknov' ],
	[ 'XTSLZ', 'Sluknov Zastavka' ],
	[ 'XCSM',  'Smolensk' ],
	[ 'XNSK',  'Sneek' ],
	[ 'XTSO',  'Sokolov' ],
	[ 'XSSO',  'Solothurn' ],
	[ 'XFSO',  'Somain' ],
	[ 'XPSO',  'Sopot' ],
	[ 'XMS',   'Sopron' ],
	[ 'XDSOR', 'Soroe' ],
	[ 'XPSI',  'Sosnowiec Glowny' ],
	[ 'XBSP',  'Spa' ],
	[ 'XDSP',  'Spangsbjerg' ],
	[ 'XTSP',  'Spicak' ],
	[ 'XASS',  'Spielfeld-Straß' ],
	[ 'XSSP',  'Spiez' ],
	[ 'XASPP', 'Spital am Pyhrn' ],
	[ 'XASP',  'Spittal(Millst.)' ],
	[ 'XRS',   'Split' ],
	[ 'XJSM',  'Sr Mitrovica' ],
	[ 'XFSDD', 'St Dalmas Tende' ],
	[ 'XSSG',  'St Gallen' ],
	[ 'XSSGW', 'St Gallen Winkel' ],
	[ 'XSSGH', 'St Gallen-Haggen' ],
	[ 'XFJ',   'St Jory' ],
	[ 'XFSMA', 'St Malo' ],
	[ 'XAJO',  'St. Jodok' ],
	[ 'XSMZ',  'St. Moritz' ],
	[ 'XAAB',  'St.Anton a.Arlbg' ],
	[ 'XAAM',  'St.Anton i.M.' ],
	[ 'XASJ',  'St.Johann i.P.' ],
	[ 'XAJT',  'St.Johann i.T.' ],
	[ 'XSSM',  'St.Margrethen' ],
	[ 'XASE',  'St.Michael' ],
	[ 'XAP',   'St.Pölten Hbf' ],
	[ 'XASV',  'St.Valentin' ],
	[ 'XAVG',  'St.Veit a.d.Glan' ],
	[ 'XSSTA', 'Staad' ],
	[ 'XASU',  'Stadlau' ],
	[ 'XASRM', 'Stadt Rottenmann' ],
	[ 'XFSTA', 'Staffelfelden' ],
	[ 'XASI',  'Stainach-Irdning' ],
	[ 'XFSAR', 'St-Amour' ],
	[ 'XASTM', 'Stams' ],
	[ 'XASTS', 'Stans(b Schwaz)' ],
	[ 'XJSP',  'Stara Pazova' ],
	[ 'XTSR',  'Stara Role' ],
	[ 'XBSA',  'Statte' ],
	[ 'XFSA',  'St-Avold' ],
	[ 'XBSD',  'St-Denijs-B' ],
	[ 'XSSB',  'Steckborn' ],
	[ 'XSSBS', 'Steckborn S' ],
	[ 'XNSW',  'Steenwijk' ],
	[ 'XAST',  'Steinach i Tirol' ],
	[ 'XFSNG', 'Steinbourg' ],
	[ 'XASF',  'Steindorf-Straßw' ],
	[ 'XSSU',  'Steinebrunn' ],
	[ 'XSSK',  'Stein-Säckingen' ],
	[ 'XFSF',  'Stephansfeld' ],
	[ 'XSSE',  'Stettbach' ],
	[ 'XASY',  'Steyr' ],
	[ 'XFSGF', 'St-Germ-d-Fosses' ],
	[ 'XFSG',  'St-Gervais' ],
	[ 'XFSHT', 'St-Hilaire-au-T' ],
	[ 'XFJL',  'St-Jean-de-Luz' ],
	[ 'XFJMA', 'St-Jean-d-Maur' ],
	[ 'XFSTL', 'St-Louis' ],
	[ 'XSMC',  'St-Maurice' ],
	[ 'XASRA', 'Stockerau' ],
	[ 'XFPY',  'St-Pierre-d\'Alb' ],
	[ 'XFPDC', 'St-Pierre-d-C' ],
	[ 'XFPL',  'St-Pol-de-Leon' ],
	[ 'XFSP',  'St-Priest' ],
	[ 'XFSQ',  'St-Quentin' ],
	[ 'XFSR',  'St-Raphael-Vales' ],
	[ 'XFSTG', 'Strasbourg' ],
	[ 'XASTH', 'Straßhof' ],
	[ 'XASR',  'Straßwalchen' ],
	[ 'XISTA', 'Stresa' ],
	[ 'XRSV',  'Striziv Vrpolje' ],
	[ 'XDS',   'Struer' ],
	[ 'XPSKW', 'Strzelce Kraj W' ],
	[ 'XFSSL', 'St-Sulpice-Laur' ],
	[ 'XYST',  'Sturovo' ],
	[ 'XJST',  'Subotica' ],
	[ 'XTS',   'Sucha' ],
	[ 'XASUM', 'Summerau' ],
	[ 'XSSUS', 'Sursee' ],
	[ 'XFSVF', 'Survilliers Foss' ],
	[ 'XASBN', 'Süssenbrunn' ],
	[ 'XNSU',  'Susteren' ],
	[ 'XTSV',  'Svatava' ],
	[ 'XTSVZ', 'Svatava zast' ],
	[ 'XTSVO', 'Svor' ],
	[ 'XPSWB', 'Swiebodzin' ],
	[ 'XPSM',  'Swinoujscie C' ],
	[ 'XPSG',  'Szczecin Glowny' ],
	[ 'XPSU',  'Szczecin Gu.' ],
	[ 'XMSG',  'Szentgotthard' ],
	[ 'XMSB',  'Szob' ],
	[ 'XMXSB', 'Szob Gr SK' ],
	[ 'XMSN',  'Szolnok' ],
	[ 'XDKT',  'Taarnby' ],
	[ 'XTT',   'Tabor' ],
	[ 'XITG',  'Taggia' ],
	[ 'XBTA',  'Tamines' ],
	[ 'XFTA',  'Tarascon' ],
	[ 'XDTAM', 'Tarm' ],
	[ 'XITB',  'Tarvisio Boscov' ],
	[ 'XIXTB', 'Tarvisio Gr AT' ],
	[ 'XMTA',  'Tata' ],
	[ 'XMTB',  'Tatabanya' ],
	[ 'XATF',  'Taufkirchen Pram' ],
	[ 'XDTA',  'Taulov' ],
	[ 'XST',   'Taverne-Torric' ],
	[ 'XATR',  'Taxenbach-Rauris' ],
	[ 'XATX',  'Taxham' ],
	[ 'XPTC',  'Tczew' ],
	[ 'XSTE',  'Tecknau' ],
	[ 'XATP',  'Telfs-Pfaffenhfn' ],
	[ 'XFTE',  'Templeuve' ],
	[ 'XFTND', 'Tende' ],
	[ 'XATN',  'Tenneck' ],
	[ 'XTTV',  'Teplic v Cechach' ],
	[ 'XPTE',  'Terespol' ],
	[ 'XPXTE', 'Terespol Gr BY' ],
	[ 'XATW',  'Terfens-Weer' ],
	[ 'XFTG',  'Tergnier' ],
	[ 'XBTE',  'Testelt' ],
	[ 'XFTT',  'Teting' ],
	[ 'XFHP',  'TGV Hte Picardie' ],
	[ 'XSTW',  'Thalwil' ],
	[ 'XFTHV', 'Thionville' ],
	[ 'XSTH',  'Thun' ],
	[ 'XSTU',  'Thusis' ],
	[ 'XFTB',  'Tieffenbach' ],
	[ 'XBTI',  'Tienen' ],
	[ 'XNT',   'Tilburg' ],
	[ 'XDTM',  'Tim' ],
	[ 'XDTI',  'Tinglev' ],
	[ 'XATI',  'Tisis' ],
	[ 'XTTI',  'Tisova u N' ],
	[ 'XDTR',  'Tistrup' ],
	[ 'XDTB',  'Tjaereborg' ],
	[ 'XSTOA', 'Tobel-Affeltrang' ],
	[ 'XDTO',  'Toender' ],
	[ 'XDTON', 'Toender Nord' ],
	[ 'XDTP',  'Tommerup' ],
	[ 'XBTG',  'Tongeren' ],
	[ 'XITUP', 'Torino P Susa' ],
	[ 'XFTU',  'Toul' ],
	[ 'XFTO',  'Toulon' ],
	[ 'XFTM',  'Toulouse-Matabi' ],
	[ 'XFTC',  'Tourcoing' ],
	[ 'XBTO',  'Tournai' ],
	[ 'XFTOU', 'Tournan' ],
	[ 'XRT',   'Tovarnik' ],
	[ 'XATRN', 'Traun' ],
	[ 'XZT',   'Trbovlje' ],
	[ 'XTTRB', 'Trebusice' ],
	[ 'XATA',  'Treibach-Althf' ],
	[ 'XDTRK', 'Trekroner' ],
	[ 'XVTF',  'Trelleborg F' ],
	[ 'XITR',  'Trento' ],
	[ 'XITS',  'Treviso Centrale' ],
	[ 'XAT',   'Trieben' ],
	[ 'XATK',  'Trimmelkam-Ost.' ],
	[ 'XLTV',  'Troisvierges' ],
	[ 'XBT',   'Trooz' ],
	[ 'XATS',  'Tschagguns' ],
	[ 'XATU',  'Tulln' ],
	[ 'XATD',  'Tullnerfeld' ],
	[ 'XPTU',  'Tuplice' ],
	[ 'XPTUD', 'Tuplice Debinka' ],
	[ 'XSTG',  'Turgi' ],
	[ 'XPTY',  'Tychy' ],
	[ 'XFUC',  'Uckange' ],
	[ 'XIU',   'Udine' ],
	[ 'XNUI',  'Uitgeest' ],
	[ 'XDUF',  'Ulfborg' ],
	[ 'XAUH',  'Ulmerfeld-Hausme' ],
	[ 'XAU',   'Ulrichsbr-Füssen' ],
	[ 'XAUS',  'Unterberg-Stefbr' ],
	[ 'XSUT',  'Unterterzen' ],
	[ 'XAUM',  'Unzmarkt' ],
	[ 'XTUS',  'Usti n L-Strekov' ],
	[ 'XTU',   'Usti n.L. hl.n.' ],
	[ 'XTUZ',  'Usti n.L. zapad' ],
	[ 'XNU',   'Utrecht C' ],
	[ 'XSUW',  'Uttwil' ],
	[ 'XMV',   'Vac' ],
	[ 'XFVAR', 'Vaires' ],
	[ 'XDVAL', 'Valby' ],
	[ 'XIVO',  'Valdaora-Anters' ],
	[ 'XTVA',  'Valdek' ],
	[ 'XFVDR', 'Val-de-Reuil' ],
	[ 'XFVC',  'Valence' ],
	[ 'XFVCV', 'Valence-TGV' ],
	[ 'XFVA',  'Valenciennes' ],
	[ 'XNVB',  'Valkenburg (NL)' ],
	[ 'XDVA',  'Vamdrup' ],
	[ 'XAVA',  'Vandans' ],
	[ 'XFVN',  'Varangeville' ],
	[ 'XDVR',  'Varde' ],
	[ 'XDVRK', 'Varde Kaserne' ],
	[ 'XDVRN', 'Varde Nord' ],
	[ 'XDVRW', 'Varde Vest' ],
	[ 'XTSVD', 'Varns stare' ],
	[ 'XTVD',  'Varnsdorf' ],
	[ 'XTVK',  'Varnsdorf piv Ko' ],
	[ 'XNVK',  'Veenendaal K' ],
	[ 'XTVY',  'Vejprty' ],
	[ 'XAVE',  'Velden a.W.' ],
	[ 'XTVZ',  'Velke Zernoseky' ],
	[ 'XTVV',  'Velky Senov' ],
	[ 'XTVVZ', 'Velky Senov zast' ],
	[ 'XDVE',  'Vemb' ],
	[ 'XFVH',  'Vendenheim' ],
	[ 'XIVNM', 'Venezia Mestre' ],
	[ 'XIVNS', 'Venezia S.Lucia' ],
	[ 'XFVE',  'Venissieux' ],
	[ 'XNVL',  'Venlo' ],
	[ 'XIVT',  'Ventimiglia' ],
	[ 'XIVE',  'Vercelli' ],
	[ 'XIVNN', 'Vernante' ],
	[ 'XFVEA', 'Verneuil-sur-Avr' ],
	[ 'XFVEE', 'Vernieul l\'Etang' ],
	[ 'XFVNO', 'Vernon' ],
	[ 'XIVP',  'Verona PN' ],
	[ 'XBVC',  'Verviers-Central' ],
	[ 'XBVP',  'Verviers-Palais' ],
	[ 'XTVER', 'Vesele Rabstejn' ],
	[ 'XCV',   'Viazma' ],
	[ 'XDVSJ', 'Viby Sjaelland' ],
	[ 'XIVC',  'Vicenza' ],
	[ 'XFVI',  'Vienne' ],
	[ 'XFVVA', 'Vievola' ],
	[ 'XTVL',  'Vilemov Sluknova' ],
	[ 'XIVL',  'Villa Literno' ],
	[ 'XIVB',  'Villab./Niederdf' ],
	[ 'XAVH',  'Villach Hbf' ],
	[ 'XAVW',  'Villach Westbf' ],
	[ 'XFVD',  'Villars l Dombes' ],
	[ 'XFVDS', 'Villedieu-les-Po' ],
	[ 'XFVR',  'Villers-Cotter' ],
	[ 'XFVG',  'Villiers Bel Gon' ],
	[ 'XAV',   'Vils' ],
	[ 'XBVV',  'Vilvoorde' ],
	[ 'XRVI',  'Vinkovci' ],
	[ 'XIVS',  'Vipit./Sterzing' ],
	[ 'XDVY',  'Visby' ],
	[ 'XBV',   'Vise' ],
	[ 'XSVI',  'Visp' ],
	[ 'XFVV',  'Vitry-La-Ville' ],
	[ 'XFVF',  'Vitry-L-Francois' ],
	[ 'XFVT',  'Vittel' ],
	[ 'XNVD',  'Vlaardingen Cent' ],
	[ 'XNVT',  'Vleuten' ],
	[ 'XNVI',  'Vlissingen' ],
	[ 'XAVB',  'Vöcklabruck' ],
	[ 'XAVM',  'Vöcklamarkt' ],
	[ 'XIVOG', 'Voghera' ],
	[ 'XDV',   'Vojens' ],
	[ 'XTV',   'Vojtanov' ],
	[ 'XAVO',  'Volders-Baumk' ],
	[ 'XAVL',  'Völs' ],
	[ 'XDVB',  'Vordingborg' ],
	[ 'XDVM',  'Vroegum' ],
	[ 'XTVP',  'Vysoka Pec' ],
	[ 'XSWW',  'Wädenswil' ],
	[ 'XAWA',  'Wald Schoberpaß' ],
	[ 'XSWA',  'Walenstadt' ],
	[ 'XLWF',  'Walferdange' ],
	[ 'XSWS',  'Wallisellen' ],
	[ 'XAWV',  'Warmbad Villach' ],
	[ 'XPWC',  'Warszawa C' ],
	[ 'XPWW',  'Warszawa Wschod.' ],
	[ 'XPWZ',  'Warszawa Zachod' ],
	[ 'XAWBK', 'Wartberg a d Kr' ],
	[ 'XAWB',  'Wartberg i.Mürz.' ],
	[ 'XLW',   'Wasserbillig' ],
	[ 'XBWA',  'Waterloo' ],
	[ 'XBWM',  'Watermael' ],
	[ 'XLWK',  'Wecker' ],
	[ 'XNWT',  'Weert' ],
	[ 'XNWS',  'Weesp' ],
	[ 'XPWE',  'Wegliniec' ],
	[ 'XSW',   'Weinfelden' ],
	[ 'XBW',   'Welkenraedt' ],
	[ 'XAWE',  'Wels Hbf' ],
	[ 'XAWEN', 'Wendling' ],
	[ 'XAWRF', 'Werfen' ],
	[ 'XAWR',  'Wernstein' ],
	[ 'XBWT',  'Wespelaar-Tildon' ],
	[ 'XAWD',  'Westendorf AT' ],
	[ 'XSWE',  'Wettingen' ],
	[ 'XAWF',  'Wien F-J Bf' ],
	[ 'XAWIF', 'Wien Flughafen' ],
	[ 'XAWIE', 'Wien Hbf' ],
	[ 'XAWIO', 'Wien Hbf ARZ' ],
	[ 'XAWH',  'Wien Hütteldorf' ],
	[ 'XAWG',  'Wien Meidling' ],
	[ 'XAWMI', 'Wien Mitte' ],
	[ 'XAWNP', 'Wien Praterstern' ],
	[ 'XAWSG', 'Wien Simmering' ],
	[ 'XAWW',  'Wien Westbf' ],
	[ 'XAWNS', 'Wiener Neustadt' ],
	[ 'XAWP',  'Wien-Penzing' ],
	[ 'XSWI',  'Wil' ],
	[ 'XAWI',  'Wildon' ],
	[ 'XLWW',  'Wilwerwiltz' ],
	[ 'XFWI',  'Wilwisheim' ],
	[ 'XAWIG', 'Windischgarsten' ],
	[ 'XFWM',  'Wingen-sur-Moder' ],
	[ 'XNWI',  'Winschoten' ],
	[ 'XNWW',  'Winterswijk' ],
	[ 'XSWT',  'Winterthur' ],
	[ 'XFWBG', 'Wissembourg' ],
	[ 'XPWIT', 'Witnica' ],
	[ 'XSWB',  'Wittenbach' ],
	[ 'XFWT',  'Wittring' ],
	[ 'XNWO',  'Woerden' ],
	[ 'XSWO',  'Wohlen' ],
	[ 'XFWY',  'Woippy' ],
	[ 'XBWO',  'Wolfstee' ],
	[ 'XAWT',  'Wolfurt' ],
	[ 'XAWO',  'Wolkersdorf' ],
	[ 'XAWL',  'Wörgl' ],
	[ 'XNWM',  'Wormerveer' ],
	[ 'XPWR',  'Wroclaw Glowny' ],
	[ 'XPWRL', 'Wroclaw Lesnica' ],
	[ 'XPWRD', 'Wroclaw Now Dwor' ],
	[ 'XAY',   'Ybbs a.d.Donau' ],
	[ 'XSY',   'Yverdon' ],
	[ 'XBYG',  'Yves-Gomezee' ],
	[ 'XRZD',  'Zadar' ],
	[ 'XPZ',   'Zagan' ],
	[ 'XZZG',  'Zagorje' ],
	[ 'XRZ',   'Zagreb Gl.kol.' ],
	[ 'XNZA',  'Zandvoort a.Zee' ],
	[ 'XPZY',  'Zary' ],
	[ 'XPZS',  'Zasieki' ],
	[ 'XPZAW', 'Zawiercie' ],
	[ 'XPZA',  'Zbaszynek' ],
	[ 'XPZE',  'Zebrzydowa' ],
	[ 'XPZD',  'Zebrzydowice' ],
	[ 'XBZD',  'Zedelgem' ],
	[ 'XBZ',   'Zeebrugge' ],
	[ 'XTZRC', 'Zelezna Ruda C' ],
	[ 'XTZR',  'Zelezna Ruda M' ],
	[ 'XAZ',   'Zell am See' ],
	[ 'XAZZ',  'Zell am Ziller' ],
	[ 'XAZW',  'Zeltweg' ],
	[ 'XSZE',  'Zermatt' ],
	[ 'XFZ',   'Zetting' ],
	[ 'XNZV',  'Zevenaar' ],
	[ 'XPZG',  'Zgorzelec' ],
	[ 'XPZGM', 'Zgorzelec Miasto' ],
	[ 'XBZI',  'Zichem' ],
	[ 'XZZM',  'Zidani most' ],
	[ 'XSZB',  'Ziegelbrücke' ],
	[ 'XPZIG', 'Zielona Gora' ],
	[ 'XAZL',  'Zirl' ],
	[ 'XTFS',  'Zirovice-Seniky' ],
	[ 'XSZI',  'Zizers' ],
	[ 'XSZG',  'Zofingen' ],
	[ 'XBZO',  'Zolder' ],
	[ 'XSZU',  'Zug CH' ],
	[ 'XNZB',  'Zuidbroek' ],
	[ 'XEZM',  'Zumarraga' ],
	[ 'XSZN',  'Zürich Enge' ],
	[ 'XSZF',  'Zürich Flughafen' ],
	[ 'XSZH',  'Zürich HB' ],
	[ 'XSZW',  'Zürich Wiedikon' ],
	[ 'XSZWO', 'Zürich Wollishof' ],
	[ 'XSZA',  'Zürich-Altst.' ],
	[ 'XSZR',  'Zürich-Hardbr' ],
	[ 'XSZO',  'Zürich-Oerlikon' ],
	[ 'XSZP',  'Zürich-Opfikon' ],
	[ 'XSZS',  'Zürich-Stadelhof' ],
	[ 'XNZW',  'Zwijndrecht' ],
	[ 'XNZL',  'Zwolle' ],

);

sub get_stations {
	return @stations;
}

sub normalize {
	my ($val) = @_;

	$val =~ s{Ä}{Ae}g;
	$val =~ s{Ö}{Oe}g;
	$val =~ s{Ü}{Ue}g;
	$val =~ s{ä}{ae}g;
	$val =~ s{ö}{oe}g;
	$val =~ s{ß}{sz}g;
	$val =~ s{ü}{ue}g;

	return $val;
}

sub get_station {
	my ($name) = @_;

	my $ds100_match = firstval { $name eq $_->[0] } @stations;

	if ($ds100_match) {
		return ($ds100_match);
	}

	my $eva_match = firstval { defined $_->[2] and $name eq $_->[2] } @stations;

	if ($eva_match) {
		return ($eva_match);
	}

	return get_station_by_name($name);
}

sub get_station_by_location {
	my ( $lon, $lat, $num_matches ) = @_;

	$num_matches //= 10;

	my $geo = Geo::Distance->new();

	# we only use geolocations inside germany.
	# For these, this fast preprocessing step will let through all
	# coordinates inside a 60km radius (and a bunch which are farther out)
	my @candidates = grep {
		      $#{$_} >= 4
		  and abs( $_->[3] - $lon ) < 1
		  and abs( $_->[4] - $lat )
		  < 1
	} @stations;
	my @distances
	  = map { $geo->distance( 'kilometer', $lon, $lat, $_->[3], $_->[4] ) }
	  @candidates;
	my @station_map = pairwise { [ $a, $b ] } @candidates, @distances;

	@station_map = sort { $a->[1] <=> $b->[1] } @station_map;
	splice( @station_map, $num_matches );

	return @station_map;
}

sub get_station_by_name {
	my ($name) = @_;

	my $nname = lc($name);
	my $actual_match = firstval { $nname eq lc( $_->[1] ) } @stations;

	if ($actual_match) {
		return ($actual_match);
	}

	$nname = normalize($nname);
	$actual_match = firstval { $nname eq normalize( lc( $_->[1] ) ) } @stations;
	if ($actual_match) {
		return ($actual_match);
	}

	my @distances   = map { distance( $nname, $_->[1] ) } @stations;
	my $min_dist    = min(@distances);
	my @station_map = pairwise { [ $a, $b ] } @stations, @distances;

	my @substring_matches = grep { $_->[1] =~ m{$name}i } @stations;
	my @levenshtein_matches
	  = map { $_->[0] } grep { $_->[1] == $min_dist } @station_map;

	return uniq_by { $_->[0] } ( @substring_matches, @levenshtein_matches );
}

1;

__END__

=head1 NAME

Travel::Status::DE::IRIS::Stations - Station name to station code mapping

=head1 SYNOPSIS

    use Travel::Status::DE::IRIS::Stations;

    my $name = 'Essen Hbf';
    my @stations = Travel::Status::DE::IRIS::Stations::get_station_by_name(
      $name);

    if (@stations < 1) {
      # no matching stations
    }
    elsif (@stations > 1) {
      # too many matches
    }
    else {
      printf("Input '%s' matched station code %s (as '%s')\n",
        $name, @{$stations[0]});
    }

=head1 VERSION

version 1.09

=head1 DESCRIPTION

This module contains a list of Deutsche Bahn stations, and also some stations
outside of Germany which are served by Deutsche Bahn trains. It offers
several accessors to look up stations based on names or geolocation data and
can also simply dump all known stations.

Each of the following methods returns a list of array references. Each
array reference describes a single station and contains either two or
five elements:

=over

=item * The station code (also known as DS100 / "Druckschrift 100" /
"Richtlinie 100"). A short string used exclusively by Deutsche Bahn APIs. Note
that it may contain space characters.

=item * The station name

=item * The international station number (IBNR, "Internationale Bahnhofsnummer")

=item * The station's longitude

=item * The station's latitude

=back

=head1 METHODS

=over

=item Travel::Status::DE::IRIS::Stations::get_stations

Returns a list of all known stations, lexically sorted by station name.

=item Travel::Status::DE::IRIS::Stations::get_station(I<$in>)

Returns a list of stations matching I<$in>.

If a I<$in> is a valid station (either DS100 code or UIC/EVA number),
a single array reference describing the station is returned. Otherwise,
I<$in> is passed to get_station_by_name(I<$in>) (see below).

Note that DS100 code matching is case sensitive.

=item Travel::Status::DE::IRIS::Stations::get_station_by_location(I<$lon>, I<$lat>, I<$num_matches>)

Looks for stations which are close to longitude/latitude I<$lon>/I<$lat> and
returns the closest I<$num_matches> (defaults to 10) matches. Note that
stations which are located more than 70 kilometers away from I<$lon>/I<$lat>
may be ignored when computing the closest matches.

Note that location-based lookup is only supported for stations inside Germany,
since the station list data source does not provide geolocation data for
non-german stations.

=item Travel::Status::DE::IRIS::Stations::get_station_by_name(I<$name>)

Returns a list of stations where the station name matches I<$name>.

Matching happens in two steps: If a case-insensitive exact match exists, only
this one is returned. Otherwise, all stations whose name contains I<$name> as
a substring (also case-insensitive) and all stations whose name has a low
Levenshtein distance to I<$name> are returned.

This two-step behaviour makes sure that not-prefix-free stations can still be
matched directly. For instance, both "Essen-Steele" and "Essen-Steele Ost"
are valid station names, but "essen-steele" will only return "Essen-Steele".

=back

=head1 DIAGNOSTICS

None.

=head1 DEPENDENCIES

=over

=item * Geo::Distance(3pm)

=item * List::MoreUtils(3pm)

=item * List::Util(3pm)

=item * Text::LevenshteinXS(3pm)

=back

=head1 BUGS AND LIMITATIONS

There is no support for intelligent whitespaces (to also match "-" and similar)
yet.

=head1 SEE ALSO

Travel::Status::DE::IRIS(3pm).

=head1 AUTHOR

Station data: Copyright (C) 2016 by DB Station&Service AG, Europaplatz 1, 10557 Berlin, Germany

Lookup code: Copyright (C) 2014-2019 by Daniel Friesel E<lt>derf@finalrewind.orgE<gt>

=head1 LICENSE

This module is licensed under the same terms as Perl itself. Note that the
station data used by this module is also available under a CC-BY 4.0 license on
L<http://data.deutschebahn.com/dataset/data-haltestellen>.


