package Log::ger::Screen;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-03-10'; # DATE
our $DIST = 'Log-ger-Screen'; # DIST
our $VERSION = '0.001'; # VERSION

# IFUNBUILT
# use strict;
# use warnings;
# END IFUNBUILT

use Log::ger::Level::FromEnv;
use Log::ger::Output 'Screen';

sub import {
    my ($package, %per_target_conf) = @_;

    require Log::ger;
    my $caller = caller(0);
    Log::ger::_import_to($package, $caller, %per_target_conf);
}

1;
# ABSTRACT: Convenient packaging of Log::ger + Log::ger::Output::Screen + Log::ger::Level::FromEnv for one-liner

__END__

=pod

=encoding UTF-8

=head1 NAME

Log::ger::Screen - Convenient packaging of Log::ger + Log::ger::Output::Screen + Log::ger::Level::FromEnv for one-liner

=head1 VERSION

version 0.001

=head1 SYNOPSIS

Mostly in one-liners:

 % perl -MLog::ger::Screen -E'log_warn "blah..."; ...'

Set level from environment variable (see L<Log::ger::Level::FromEnv> for more
details:

 % TRACE=1 perl ...

=head1 DESCRIPTION

This is just a convenient packaging of:

 use Log::ger::Level::FromEnv;
 use Log::ger::Output 'Screen';
 use Log::ger; # in the caller's package

mostly for one-liner usage.

=head1 SEE ALSO

L<Log::ger::App>

L<Log::ger>

L<Log::ger::Level::FromEnv>

L<Log::ger::Output::Screen>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
