#! perl

use strict;
use warnings;
use utf8;

# Implementation of App::Music::ChordPro::Wx::PreferencesDialog_wxg details.

package App::Music::ChordPro::Wx::PreferencesDialog;

# App::Music::ChordPro::Wx::PreferencesDialog_wxg is generated by wxGlade and contains
# all UI associated code.

use base qw( App::Music::ChordPro::Wx::PreferencesDialog_wxg );

use Wx qw[:everything];
use Wx::Locale gettext => '_T';
use App::Packager;

# BUilt-in descriptions for some notation systems.
my $notdesc =
  { "common"	   => "C, D, E, F, G, A, B",
    "dutch"	   => "C, D, E, F, G, A, B",
    "german"	   => "C, ... A, Ais/B, H",
    "latin"	   => "Do, Re, Mi, Fa, Sol, ...",
    "scandinavian" => "C, ... A, A#/Bb, H",
    "solfege"	   => "Do, Re, Mi, Fa, So, ...",
    "solfège"	   => "Do, Re, Mi, Fa, So, ...",
    "nashville"	   => "1, 2, 3, ...",
    "roman"	   => "I, II, III, ...",
  };

sub get_configfile {
    my ( $self ) = @_;
    # warn("CF: ", $self->GetParent->{prefs_configfile} || "");
    $self->GetParent->{prefs_configfile} || ""
}

sub __set_properties {
    my ( $self ) = @_;
    $self->SUPER::__set_properties;
    my $parent = $self->GetParent;
    $self->{t_configfiledialog}->SetValue($parent->{prefs_configfile})
      if $parent->{prefs_configfile};
    $self->{t_pdfviewer}->SetValue($parent->{prefs_pdfviewer})
      if $parent->{prefs_pdfviewer};
    $self->{cb_skipstdcfg}->SetValue($parent->{prefs_skipstdcfg});

    my $ctl = $self->{ch_config};
    $ctl->Clear;
    for ( @{ $parent->stylelist } ) {
	my $t = ucfirst(lc($_));
	$t =~ s/_/ /g;
	$t =~ s/ (.)/" ".uc($1)/eg;
	$ctl->Append($t);
    }

    my $p = $parent->{prefs_cfgpreset};
    foreach ( @$p ) {
	my $t = ucfirst(lc($_));
	$t =~ s/_/ /g;
	$t =~ s/ (.)/" ".uc($1)/eg;
	my $n = $ctl->FindString($t);
	unless ( $n == wxNOT_FOUND ) {
	    $ctl->Check( $n, 1 );
	}
    }
    $self->_enablecustom;

    $ctl = $self->{ch_editfont};
    $ctl->SetSelection( $parent->{prefs_editfont} );
    $ctl = $self->{sp_editfont};
    $ctl->SetValue( $parent->{prefs_editsize} );

    $ctl = $self->{ch_notation};
    $ctl->Clear;
    my $n = 0;
    my $check = 0;
    for ( @{ $parent->notationlist } ) {
	my $s = ucfirst($_);
	$check = $n if $_ eq lc $parent->{prefs_notation};
	$s .= " (" . $notdesc->{lc($s)} .")" if $notdesc->{lc($s)};
	$ctl->Append($s);
	$ctl->SetClientData( $n, $_);
	$n++;
    }
    $ctl->SetSelection($check);

    $ctl = $self->{ch_transcode};
    $ctl->Clear;
    $ctl->Append("-----");
    $n = 1;
    for ( @{ $parent->notationlist } ) {
	my $s = ucfirst($_);
	$check = $n if $_ eq lc $parent->{prefs_xcode};
	$s .= " (" . $notdesc->{lc($s)} .")" if $notdesc->{lc($s)};
	$ctl->Append($s);
	$ctl->SetClientData( $n, $_);
	$n++;
    }
    $ctl->SetSelection($check);
}

sub _enablecustom {
    my ( $self ) = @_;
    my $ctl = $self->{ch_config};
    my $n = $ctl->IsChecked( $ctl->GetCount - 1 );
    for ( $self->{l_cfgfile}, $self->{t_configfiledialog}, $self->{b_configfiledialog} ) {
	$_->Enable($n);
    }
}

sub _enablexpose {
    my ( $self, $n ) = @_;
    for ( $self->{l_xpose},
	  $self->{l_xpose_from}, $self->{ch_xpose_from},
	  $self->{l_xpose_to}, $self->{ch_xpose_to},
	  $self->{rb_xpose_sharp}, $self->{rb_xpose_flat},
	) {
	$_->Enable($n);
    }
}

################ Event handlers ################

# Event handlers override the subs generated by wxGlade in the _wxg class.

sub OnChConfig {
    my ( $self, $event ) = @_;
    my @n = $self->{ch_config}->GetSelections;
    my $enablecustom;
    foreach ( @n ) {
	if ( $_ == $self->{ch_config}->GetCount - 1 ) {
	    $enablecustom++;
	}
    }
    $self->_enablecustom($enablecustom);
}

sub OnConfigFileDialog {
    my ( $self, $event ) = @_;
    my $fd = Wx::FileDialog->new
      ($self, _T("Choose config file"),
       "", $self->GetParent->{prefs_configfile} || "",
       "Config files (*.cfg,*.json)|*.cfg;*.json|All files|*.*",
       0|wxFD_OPEN,
       wxDefaultPosition);
    my $ret = $fd->ShowModal;
    if ( $ret == wxID_OK ) {
	my $file = $fd->GetPath;
	if ( -f $file ) {
	    $self->{t_configfiledialog}->SetValue($file);
	}
	else {
	    my $md = Wx::MessageDialog->new
	      ( $self,
		"Create new config $file?",
		"Creating a config file",
		wxYES_NO | wxICON_INFORMATION );
	    my $ret = $md->ShowModal;
	    $md->Destroy;
	    if ( $ret == wxID_YES ) {
		my $fd;
		if ( open( $fd, ">:utf8", $file )
		     and print $fd App::Music::ChordPro::Config::default_config()
		     and close($fd) ) {
		    $self->{t_configfiledialog}->SetValue($file);
		}
		else {
		    my $md = Wx::MessageDialog->new
		      ( $self,
			"Error creating $file: $!",
			"File open error",
			wxOK | wxICON_ERROR );
		    $md->ShowModal;
		    $md->Destroy;
		}
	    }
	}
    }
    $fd->Destroy;
}

#               C      D      E  F      G      A        B
my @xpmap = qw( 0 1  1 2 3  3 4  5 6  6 7 8  8 9 10 10 11 );
my @sfmap = qw( 0 7 -5 2 9 -3 4 -1 6 -6 1 8 -4 3 10 -2  5 );

sub OnAccept {
    my ( $self, $event ) = @_;

    my $ctl = $self->{ch_config};
    my $cnt = $ctl->GetCount;
    my @p;
    my $styles = $self->GetParent->stylelist;
    for ( my $n = 0; $n < $cnt; $n++ ) {
	next unless $ctl->IsChecked($n);
	push( @p, $styles->[$n] );
	if ( $n == $cnt - 1 ) {
	    $self->GetParent->{_cfgpresetfile} =
	      $self->GetParent->{prefs_configfile} =
		$self->{t_configfiledialog}->GetValue;
	}
    }

    $self->GetParent->{prefs_skipstdcfg} =
      $self->{cb_skipstdcfg}->IsChecked ? 1 : 0;

    $self->GetParent->{prefs_cfgpreset} = \@p;

    my $n = $self->{ch_notation}->GetSelection;
    if ( $n > 0 ) {
	$self->GetParent->{prefs_notation} =
	  $self->{ch_notation}->GetClientData($n);
    }
    else {
       	$self->GetParent->{prefs_notation} = "";
    }

    $self->GetParent->{prefs_pdfviewer} = $self->{t_pdfviewer}->GetValue;

    $n = $xpmap[$self->{ch_xpose_to}->GetSelection]
      - $xpmap[$self->{ch_xpose_from}->GetSelection];
    $n += 12 if $n < 0;
    $n = $n - 12 if $self->{rb_xpose_flat }->GetValue;
    $self->GetParent->{prefs_xpose} = $n;

    $n = $self->{ch_transcode}->GetSelection;
    if ( $n > 0 ) {
	$self->GetParent->{prefs_xcode} =
	  $self->{ch_transcode}->GetClientData($n);
    }
    else {
       	$self->GetParent->{prefs_xcode} = "";
    }

    $event->Skip;
}

sub OnCancel {
    my ( $self, $event ) = @_;
    $event->Skip;
}

sub OnSkipStdCfg {
    my ( $self, $event ) = @_;
    $event->Skip;
}

sub OnXposeFrom {
    my ( $self, $event ) = @_;
    $event->Skip;
}

sub OnXposeTo {
    my ( $self, $event ) = @_;
    my $sel = $self->{ch_xpose_to}->GetSelection;
    my $sf = $sfmap[$sel];
    if ( $sf < 0 ) {
	$self->{rb_xpose_flat }->SetValue(1);
	$self->{rb_xpose_sharp}->SetValue(0);
    }
    elsif ( $sf > 0 ) {
	$self->{rb_xpose_flat }->SetValue(0);
	$self->{rb_xpose_sharp}->SetValue(1);
    }
    else {
	$self->{rb_xpose_flat }->SetValue(0);
	$self->{rb_xpose_sharp}->SetValue(0);
    }
    $event->Skip;
}

sub OnXposeSharp {
    my ( $self, $event ) = @_;
    $self->{rb_xpose_flat }->SetValue(0);
    $event->Skip;
}

sub onXposeFlat {
    my ( $self, $event ) = @_;
    $self->{rb_xpose_sharp}->SetValue(0);
    $event->Skip;
}

sub OnChNotation {
    my ( $self, $event ) = @_;
    my $n = $self->{ch_notation}->GetSelection;
    $event->Skip;
}

sub OnChTranscode {
    my ( $self, $event ) = @_;
    my $n = $self->{ch_transcode}->GetSelection;
    $event->Skip;
}

sub OnChEditFont {
    my ($self, $event) = @_;
    my $p = $self->GetParent;
    my $n = $self->{ch_editfont}->GetSelection;
    my $ctl = $p->{t_source};
    my $font = $p->fonts->[$n]->{font};
    $font->SetPointSize($p->{prefs_editsize});
    $ctl->SetFont($font);
    $p->{prefs_editfont} = $n;
    $event->Skip;
}

sub OnSpEditFont {
    my ($self, $event) = @_;
    my $p = $self->GetParent;
    my $n = $self->{sp_editfont}->GetValue;
    my $ctl = $p->{t_source};
    my $font = $ctl->GetFont;
    $font->SetPointSize($n);
    $ctl->SetFont($font);
    $p->{prefs_editsize} = $n;
    $event->Skip;
}

1;
