( function($) {

	var state;
	var current_page;

	function update_summary ( page ) {
		var summary = '<h2 class="h4 text-center">' + page.summary.location_name + '</h2>';
		if ( page.summary.phase ) {
			summary += '<div class="h6 text-center">' + page.summary.phase + '</div>';
		}
		if ( page.summary.image ) {
			summary += '<div class="text-center"><img class="img-fluid rounded border-secondary mx-auto my-3" style="max-height: 30vh" src="/img/' + page.summary.image + '" alt=""></div>';
		}
		$( '#summary' ).html( summary );
	}

	function update_scores ( page ) {
		for ( var s of [ 'seduced', 'pussy', 'butt', 'oral', 'orgasm' ] ) {
			let score = page.scores[s];
			let score_text = ( score[1] === null ) ? score[0] : `${score[0]}/${score[1]}`;
			$( '#score-' + s ).html( score_text );
		}
		var trophies = '';
		for ( var t of page.scores.trophy ) {
			trophies += '<span data-bs-content="' + t + '">🏆</span>';
		}
		$( '#trophies' ).html( trophies );
		$( '#trophies span' ).popover( {
			placement: 'top',
			trigger: 'hover focus',
		} );
	}

	function render_page ( page ) {
		console.log( page );
		$( "#next_pages" ).html( "" );
		$( "#html" ).html( page.html );
		for ( var link of page.next_pages ) {
			let link_id = link[0];
			let link_desc = link[1];
			$( "#next_pages" ).append(
				'<button class="list-group-item list-group-item-action list-group-item-dark" x-data-page-id="' +
				link_id +
				'">' +
				link_desc +
				'</button>'
			);
		}
		state = page.state;
		current_page = page;
		update_scores( page );
		update_summary( page );
	}

	function get_page ( page_id ) {
		$.ajax( API + '/page/' + page_id, {
			method: 'POST',
			data: JSON.stringify( { "state": state } ),
			contentType: 'application/json',
			success: render_page,
			dataType: 'json',
		} );
	}

	// Load initial state...
	$( function () {
		$.get( API + '/state/init', {}, function ( data ) {
			state = data.state;
			get_page( 'main' );
		}, 'json' );
	} );

	// Make page links work...
	$( "#next_pages" ).on( "click", "button", function ( e ) {
		let page_id = $( this ).attr( "x-data-page-id" );
		get_page( page_id );
	} );

	// Save button
	$( "#save" ).on( "click", function ( e ) {
		let d = Date.now();
		let label = prompt( "Please enter a label for the bookmark", "Unlabelled" );
		let page = current_page;
		var store = [];
		let got = localStorage.getItem( STORAGE_KEY );
		if ( got ) store = JSON.parse( got );
		store.push( {
			"date": d,
			"label": label,
			"stored_data": page,
		} );
		localStorage.setItem( STORAGE_KEY, JSON.stringify( store ) );
		refresh_saved_games();
	} );

	function refresh_saved_games () {
		var store = [];
		let got = localStorage.getItem( STORAGE_KEY );
		if ( got ) store = JSON.parse( got );
		$( "#saved_games" ).html( "" );
		for (var i = store.length - 1; i >= 0; i--) {
			let g = store[i];
			let d = new Date( g.date );
			$( "#saved_games" ).append(
				'<li class="list-group-item list-group-item-secondary" x-data-saved-game-ix="' + i + '">' +
				'<div><strong>' + g.label + '</strong></div>' +
				'<div><small>Timestamp: ' + d.toISOString() + '</small></div>' +
				'<div><small><a class="text-secondary saved-game-go" href="#">Go to</a></small> &middot; ' +
				'<small><a class="text-danger saved-game-delete" href="#">Delete</a></small></div>' +
				'</li>'
			);
		}
	}

	$( "#saved_games" ).on( "click", ".saved-game-go", function ( e ) {
		let ix = $( this ).parents( "li" ).attr( "x-data-saved-game-ix" );
		if ( confirm( "Return to bookmark? Any progress you have made since then will be lost." ) ) {
			var store = [];
			let got = localStorage.getItem( STORAGE_KEY );
			if ( got ) store = JSON.parse( got );
			render_page( store[ix].stored_data );
		}
	} );

	$( "#saved_games" ).on( "click", ".saved-game-delete", function ( e ) {
		let ix = $( this ).parents( "li" ).attr( "x-data-saved-game-ix" );
		if ( confirm( "Remove this bookmark?" ) ) {
			var store = [];
			let got = localStorage.getItem( STORAGE_KEY );
			if ( got ) store = JSON.parse( got );
			store.splice( ix, 1 );
			localStorage.setItem( STORAGE_KEY, JSON.stringify( store ) );
			refresh_saved_games();
		}
	} );

	refresh_saved_games();

} )( jQuery );
