package Archive::Libarchive::Lib::Entry;

use strict;
use warnings;
use 5.020;

# ABSTRACT: Private class for Arcive::Libarchive
our $VERSION = '0.06'; # VERSION

# NOTE: This document is autogenerated from the template
# maint/tt/Code.pm.tt
# Please see maint/README.md for details on updating.


package
  Archive::Libarchive::Entry;

use Archive::Libarchive::Lib;

my $ffi = Archive::Libarchive::Lib->ffi;

$ffi->attach( acl_add_entry => ['archive_entry', 'int', 'int', 'int', 'int', 'string'] => 'int' );
$ffi->attach( acl_add_entry_w => ['archive_entry', 'int', 'int', 'int', 'int', 'wstring'] => 'int' );
$ffi->attach( acl_clear => ['archive_entry'] );
$ffi->attach( acl_count => ['archive_entry', 'int'] => 'int' );
$ffi->attach( acl_next => ['archive_entry', 'int', 'int*', 'int*', 'int*', 'int*', 'string*'] => 'int' );
$ffi->attach( acl_reset => ['archive_entry', 'int'] => 'int' );
$ffi->attach( atime => ['archive_entry'] => 'time_t' );
$ffi->attach( atime_is_set => ['archive_entry'] => 'int' );
$ffi->attach( atime_nsec => ['archive_entry'] => 'long' );
$ffi->attach( birthtime => ['archive_entry'] => 'time_t' );
$ffi->attach( birthtime_is_set => ['archive_entry'] => 'int' );
$ffi->attach( birthtime_nsec => ['archive_entry'] => 'long' );
$ffi->attach( clear => ['archive_entry'] );
$ffi->attach( copy_fflags_text => ['archive_entry', 'string'] => 'string' );
$ffi->attach( copy_fflags_text_w => ['archive_entry', 'wstring'] => 'wstring' );
$ffi->attach( copy_gname => ['archive_entry', 'string'] );
$ffi->attach( copy_gname_w => ['archive_entry', 'wstring'] );
$ffi->attach( copy_hardlink => ['archive_entry', 'string'] );
$ffi->attach( copy_hardlink_w => ['archive_entry', 'wstring'] );
$ffi->attach( copy_link => ['archive_entry', 'string'] );
$ffi->attach( copy_link_w => ['archive_entry', 'wstring'] );
$ffi->attach( copy_pathname => ['archive_entry', 'string'] );
$ffi->attach( copy_pathname_w => ['archive_entry', 'wstring'] );
$ffi->attach( copy_sourcepath => ['archive_entry', 'string'] );
$ffi->attach( copy_sourcepath_w => ['archive_entry', 'wstring'] );
$ffi->attach( copy_symlink => ['archive_entry', 'string'] );
$ffi->attach( copy_symlink_w => ['archive_entry', 'wstring'] );
$ffi->attach( copy_uname => ['archive_entry', 'string'] );
$ffi->attach( copy_uname_w => ['archive_entry', 'wstring'] );
$ffi->attach( ctime => ['archive_entry'] => 'time_t' );
$ffi->attach( ctime_is_set => ['archive_entry'] => 'int' );
$ffi->attach( ctime_nsec => ['archive_entry'] => 'long' );
$ffi->attach( dev => ['archive_entry'] => 'dev_t' );
$ffi->attach( dev_is_set => ['archive_entry'] => 'int' );
$ffi->attach( devmajor => ['archive_entry'] => 'dev_t' );
$ffi->attach( devminor => ['archive_entry'] => 'dev_t' );
$ffi->attach( fflags => ['archive_entry', 'ulong*', 'ulong*'] );
$ffi->attach( fflags_text => ['archive_entry'] => 'string' );
$ffi->attach( gid => ['archive_entry'] => 'sint64' );
$ffi->attach( gname => ['archive_entry'] => 'string' );
$ffi->attach( gname_utf8 => ['archive_entry'] => 'string_utf8' );
$ffi->attach( hardlink => ['archive_entry'] => 'string' );
$ffi->attach( hardlink_utf8 => ['archive_entry'] => 'string_utf8' );
$ffi->attach( ino => ['archive_entry'] => 'sint64' );
$ffi->attach( ino64 => ['archive_entry'] => 'sint64' );
$ffi->attach( ino_is_set => ['archive_entry'] => 'int' );
$ffi->attach( is_data_encrypted => ['archive_entry'] => 'int' );
$ffi->attach( is_encrypted => ['archive_entry'] => 'int' );
$ffi->attach( is_metadata_encrypted => ['archive_entry'] => 'int' );
$ffi->attach( mode => ['archive_entry'] => 'mode_t' );
$ffi->attach( mtime => ['archive_entry'] => 'time_t' );
$ffi->attach( mtime_is_set => ['archive_entry'] => 'int' );
$ffi->attach( mtime_nsec => ['archive_entry'] => 'long' );
$ffi->attach( nlink => ['archive_entry'] => 'uint' );
$ffi->attach( pathname => ['archive_entry'] => 'string' );
$ffi->attach( pathname_utf8 => ['archive_entry'] => 'string_utf8' );
$ffi->attach( perm => ['archive_entry'] => 'mode_t' );
$ffi->attach( rdev => ['archive_entry'] => 'dev_t' );
$ffi->attach( rdevmajor => ['archive_entry'] => 'dev_t' );
$ffi->attach( rdevminor => ['archive_entry'] => 'dev_t' );
$ffi->attach( set_atime => ['archive_entry', 'time_t', 'long'] );
$ffi->attach( set_birthtime => ['archive_entry', 'time_t', 'long'] );
$ffi->attach( set_ctime => ['archive_entry', 'time_t', 'long'] );
$ffi->attach( set_dev => ['archive_entry', 'dev_t'] );
$ffi->attach( set_devmajor => ['archive_entry', 'dev_t'] );
$ffi->attach( set_devminor => ['archive_entry', 'dev_t'] );
$ffi->attach( set_fflags => ['archive_entry', 'ulong', 'ulong'] );
$ffi->attach( set_gid => ['archive_entry', 'sint64'] );
$ffi->attach( set_gname => ['archive_entry', 'string'] );
$ffi->attach( set_gname_utf8 => ['archive_entry', 'string'] );
$ffi->attach( set_hardlink => ['archive_entry', 'string'] );
$ffi->attach( set_hardlink_utf8 => ['archive_entry', 'string'] );
$ffi->attach( set_ino => ['archive_entry', 'sint64'] );
$ffi->attach( set_ino64 => ['archive_entry', 'sint64'] );
$ffi->attach( set_is_data_encrypted => ['archive_entry', 'char'] );
$ffi->attach( set_is_metadata_encrypted => ['archive_entry', 'char'] );
$ffi->attach( set_link => ['archive_entry', 'string'] );
$ffi->attach( set_link_utf8 => ['archive_entry', 'string'] );
$ffi->attach( set_mode => ['archive_entry', 'mode_t'] );
$ffi->attach( set_mtime => ['archive_entry', 'time_t', 'long'] );
$ffi->attach( set_nlink => ['archive_entry', 'uint'] );
$ffi->attach( set_pathname => ['archive_entry', 'string'] );
$ffi->attach( set_pathname_utf8 => ['archive_entry', 'string'] );
$ffi->attach( set_perm => ['archive_entry', 'mode_t'] );
$ffi->attach( set_rdev => ['archive_entry', 'dev_t'] );
$ffi->attach( set_rdevmajor => ['archive_entry', 'dev_t'] );
$ffi->attach( set_rdevminor => ['archive_entry', 'dev_t'] );
$ffi->attach( set_size => ['archive_entry', 'sint64'] );
$ffi->attach( set_symlink => ['archive_entry', 'string'] );
$ffi->attach( set_symlink_utf8 => ['archive_entry', 'string'] );
$ffi->attach( set_uid => ['archive_entry', 'sint64'] );
$ffi->attach( set_uname => ['archive_entry', 'string'] );
$ffi->attach( set_uname_utf8 => ['archive_entry', 'string'] );
$ffi->attach( size => ['archive_entry'] => 'sint64' );
$ffi->attach( size_is_set => ['archive_entry'] => 'int' );
$ffi->attach( sourcepath => ['archive_entry'] => 'string' );
$ffi->attach( sourcepath_w => ['archive_entry'] => 'wstring' );
$ffi->attach( sparse_add_entry => ['archive_entry', 'sint64', 'sint64'] );
$ffi->attach( sparse_clear => ['archive_entry'] );
$ffi->attach( sparse_count => ['archive_entry'] => 'int' );
$ffi->attach( sparse_next => ['archive_entry', 'sint64*', 'sint64*'] => 'int' );
$ffi->attach( sparse_reset => ['archive_entry'] => 'int' );
$ffi->attach( strmode => ['archive_entry'] => 'string' );
$ffi->attach( symlink => ['archive_entry'] => 'string' );
$ffi->attach( symlink_utf8 => ['archive_entry'] => 'string_utf8' );
$ffi->attach( uid => ['archive_entry'] => 'sint64' );
$ffi->attach( uname => ['archive_entry'] => 'string' );
$ffi->attach( uname_utf8 => ['archive_entry'] => 'string_utf8' );
$ffi->attach( unset_atime => ['archive_entry'] );
$ffi->attach( unset_birthtime => ['archive_entry'] );
$ffi->attach( unset_ctime => ['archive_entry'] );
$ffi->attach( unset_mtime => ['archive_entry'] );
$ffi->attach( unset_size => ['archive_entry'] );
$ffi->attach( update_gname_utf8 => ['archive_entry', 'string'] => 'int' );
$ffi->attach( update_hardlink_utf8 => ['archive_entry', 'string'] => 'int' );
$ffi->attach( update_link_utf8 => ['archive_entry', 'string'] => 'int' );
$ffi->attach( update_pathname_utf8 => ['archive_entry', 'string'] => 'int' );
$ffi->attach( update_symlink_utf8 => ['archive_entry', 'string'] => 'int' );
$ffi->attach( update_uname_utf8 => ['archive_entry', 'string'] => 'int' );
$ffi->attach( xattr_clear => ['archive_entry'] );
$ffi->attach( xattr_count => ['archive_entry'] => 'int' );
$ffi->attach( xattr_reset => ['archive_entry'] => 'int' );

$ffi->ignore_not_found(1);

$ffi->attach( acl_from_text => ['archive_entry', 'string', 'int'] => 'int' );
$ffi->attach( acl_from_text_w => ['archive_entry', 'wstring', 'int'] => 'int' );
$ffi->attach( acl_to_text => ['archive_entry', 'ssize_t*', 'int'] => 'string' );
$ffi->attach( acl_to_text_w => ['archive_entry', 'ssize_t*', 'int'] => 'wstring' );
$ffi->attach( acl_types => ['archive_entry'] => 'int' );
$ffi->attach( set_symlink_type => ['archive_entry', 'int'] );
$ffi->attach( symlink_type => ['archive_entry'] => 'int' );

$ffi->ignore_not_found(0);

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Archive::Libarchive::Lib::Entry - Private class for Arcive::Libarchive

=head1 VERSION

version 0.06

=head1 SYNOPSIS

 % perldoc Archive::Libarchive

=head1 DESCRIPTION

This is a private class for L<Archive::Libarchive> see the main documentation for the public interface.

=head1 SEE ALSO

=over 4

=item L<Archive::Libarchive::Peek>

Provides an interface for listing and retrieving entries from an archive without extracting them to the local filesystem.

=item L<Archive::Libarchive::Extract>

Provides an interface for extracting arbitrary archives of any format/filter supported by C<libarchive>.

=item L<Archive::Libarchive::Unwrap>

Decompresses / unwraps files that have been compressed or wrapped in any of the filter formats supported by C<libarchive>

=item L<Archive::Libarchive>

This is the main top-level module for using C<libarchive> from
Perl.  It is the best place to start reading the documentation.
It pulls in the other classes and C<libarchive> constants so
that you only need one C<use> statement to effectively use
C<libarchive>.

=item L<Archive::Libarchive::API>

This contains the full and complete API for all of the L<Archive::Libarchive>
classes.  Because C<libarchive> has hundreds of methods, the main documentation
pages elsewhere only contain enough to be useful, and not to overwhelm.

=item L<Archive::Libarchive::Archive>

The base class of all archive classes.  This includes some common error
reporting functionality among other things.

=item L<Archive::Libarchive::ArchiveRead>

This class is used for reading from archives.

=item L<Archive::Libarchive::ArchiveWrite>

This class is for creating new archives.

=item L<Archive::Libarchive::DiskRead>

This class is for reading L<Archive::Libarchive::Entry> objects from disk
so that they can be written to L<Archive::Libarchive::ArchiveWrite> objects.

=item L<Archive::Libarchive::DiskWrite>

This class is for writing L<Archive::Libarchive::Entry> objects to disk
that have been written from L<Archive::Libarchive::ArchiveRead> objects.

=item L<Archive::Libarchive::Entry>

This class represents a file in an archive, or on disk.

=item L<Archive::Libarchive::EntryLinkResolver>

This class exposes the C<libarchive> link resolver API.

=item L<Archive::Libarchive::Match>

This class exposes the C<libarchive> match API.

=item L<Dist::Zilla::Plugin::Libarchive>

Build L<Dist::Zilla> based dist tarballs with libarchive instead of the built in L<Archive::Tar>.

=item L<Alien::Libarchive3>

If a suitable system C<libarchive> can't be found, then this
L<Alien> will be installed to provide it.

=item L<libarchive.org|http://libarchive.org/>

The C<libarchive> project home page.

=item L<https://github.com/libarchive/libarchive/wiki>

The C<libarchive> project wiki.

=item L<https://github.com/libarchive/libarchive/wiki/ManualPages>

Some of the C<libarchive> man pages are listed here.

=back

=head1 AUTHOR

Graham Ollis <plicease@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021,2022 by Graham Ollis.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
