#!/usr/bin/perl

use strict;
use warnings;

use Test::More;

use Metrics::Any '$metrics';
use Metrics::Any::Adapter 'Prometheus';

use Net::Prometheus;

$metrics->make_counter( metric =>
   name => "the_metric",
);

$metrics->inc_counter( metric => );

my $prom = Net::Prometheus->new;
like( $prom->render,
   qr/^the_metric 1/m,
   'Net::Prometheus->render contains metric'
);

done_testing;
