package API::MailboxOrg::API::Mail;

# ABSTRACT: MailboxOrg::API::Mail

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.0'; # VERSION

my %validators = (
    'add' => validation_for(
        params => {
            mail                   => { type => Str, optional => 0 },
            password               => { type => Str, optional => 0 },
            password_hash          => { type => Str, optional => 1 },
            plan                   => { type => Enum[qw(light standard premium)], optional => 0 },
            additional_mail_quota  => { type => Str, optional => 1 },
            additional_cloud_quota => { type => Str, optional => 1 },
            first_name             => { type => Str, optional => 0 },
            last_name              => { type => Str, optional => 0 },
            inboxsave              => { type => Str, optional => 0 },
            forwards               => { type => Str, optional => 0 },
            memo                   => { type => Str, optional => 1 },
            catchall               => { type => Str, optional => 1 },
            create_own_context     => { type => Str, optional => 1 },
            title                  => { type => Str, optional => 1 },
            birthday               => { type => Str, optional => 1 },
            position               => { type => Str, optional => 1 },
            department             => { type => Str, optional => 1 },
            company                => { type => Str, optional => 1 },
            street                 => { type => Str, optional => 1 },
            postal_code            => { type => Str, optional => 1 },
            city                   => { type => Str, optional => 1 },
            phone                  => { type => Str, optional => 1 },
            fax                    => { type => Str, optional => 1 },
            cell_phone             => { type => Str, optional => 1 },
            recover                => { type => Str, optional => 1 },
            skip_welcome_mail      => { type => Str, optional => 1 },

        },
    ),
    'del' => validation_for(
        params => {
            mail => { type => Str, optional => 0 },

        },
    ),
    'get' => validation_for(
        params => {
            mail => { type => Str, optional => 0 },

        },
    ),
    'list' => validation_for(
        params => {
            domain => { type => Str, optional => 0 },

        },
    ),
    'register' => validation_for(
        params => {
            token          => { type => Str, optional => 0 },
            mail           => { type => Str, optional => 0 },
            password       => { type => Str, optional => 0 },
            alternate_mail => { type => Str, optional => 1 },
            first_name     => { type => Str, optional => 0 },
            last_name      => { type => Str, optional => 0 },
            lang           => { type => Enum[qw(de en fr)], optional => 1 },

        },
    ),
    'set' => validation_for(
        params => {
            mail                   => { type => Str, optional => 0 },
            password               => { type => Str, optional => 1 },
            password_hash          => { type => Str, optional => 1 },
            plan                   => { type => Enum[qw(MAIL MAILXL MAILXXL MAILXXXL Office OfficeXL OfficeXXL OfficeXXXL light standard premium)], optional => 1 },
            additional_mail_quota  => { type => Str, optional => 1 },
            additional_cloud_quota => { type => Str, optional => 1 },
            first_name             => { type => Str, optional => 1 },
            last_name              => { type => Str, optional => 1 },
            inboxsave              => { type => Str, optional => 1 },
            forwards               => { type => Str, optional => 1 },
            aliases                => { type => Str, optional => 1 },
            alternate_mail         => { type => Str, optional => 1 },
            memo                   => { type => Str, optional => 1 },
            active                 => { type => Str, optional => 1 },
            title                  => { type => Str, optional => 1 },
            birthday               => { type => Str, optional => 1 },
            position               => { type => Str, optional => 1 },
            department             => { type => Str, optional => 1 },
            company                => { type => Str, optional => 1 },
            street                 => { type => Str, optional => 1 },
            postal_code            => { type => Str, optional => 1 },
            city                   => { type => Str, optional => 1 },
            phone                  => { type => Str, optional => 1 },
            fax                    => { type => Str, optional => 1 },
            cell_phone             => { type => Str, optional => 1 },

        },
    ),

);


sub add ($self, %params) {
    my $validator = $validators{'add'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.add', \%params, \%opt );
}

sub del ($self, %params) {
    my $validator = $validators{'del'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.del', \%params, \%opt );
}

sub get ($self, %params) {
    my $validator = $validators{'get'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.get', \%params, \%opt );
}

sub list ($self, %params) {
    my $validator = $validators{'list'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.list', \%params, \%opt );
}

sub register ($self, %params) {
    my $validator = $validators{'register'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'mail.register', \%params, \%opt );
}

sub set ($self, %params) {
    my $validator = $validators{'set'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.set', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Mail - MailboxOrg::API::Mail

=head1 VERSION

version 1.0.0

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 add

Adds an e-mail address

Available for admin, account, domain

Parameters:

=over 4

=item * mail

=item * password

=item * password_hash

=item * plan

=item * additional_mail_quota

=item * additional_cloud_quota

=item * first_name

=item * last_name

=item * inboxsave

=item * forwards

=item * memo

=item * catchall

=item * create_own_context

=item * title

=item * birthday

=item * position

=item * department

=item * company

=item * street

=item * postal_code

=item * city

=item * phone

=item * fax

=item * cell_phone

=item * recover

=item * skip_welcome_mail

=back

returns: array

    $api->mail->add(%params);

=head2 del

Deletes an e-mail address

Available for admin, reseller, account, domain

Parameters:

=over 4

=item * mail

=back

returns: boolean

    $api->mail->del(%params);

=head2 get

Returns e-mail address details

Available for admin, reseller, account, domain, mail

Parameters:

=over 4

=item * mail

=back

returns: array

    $api->mail->get(%params);

=head2 list

Returns a list of e-mail addresses + configuration information

Available for admin, reseller, account, domain

Parameters:

=over 4

=item * domain

=back

returns: array

    $api->mail->list(%params);

=head2 register

Adds an e-mail address (using a predefined token)

Parameters:

=over 4

=item * token

=item * mail

=item * password

=item * alternate_mail

=item * first_name

=item * last_name

=item * lang

=back

returns: boolean

    $api->mail->register(%params);

=head2 set

Modifies e-mail address properties

Available for admin, reseller, account, domain, mail, domain

Parameters:

=over 4

=item * mail

=item * password

=item * password_hash

=item * plan

=item * additional_mail_quota

=item * additional_cloud_quota

=item * first_name

=item * last_name

=item * inboxsave

=item * forwards

=item * aliases

=item * alternate_mail

=item * memo

=item * active

=item * title

=item * birthday

=item * position

=item * department

=item * company

=item * street

=item * postal_code

=item * city

=item * phone

=item * fax

=item * cell_phone

=back

returns: array

    $api->mail->set(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
