package API::MailboxOrg::API::Backup;

# ABSTRACT: MailboxOrg::API::Backup

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.0'; # VERSION

my %validators = (
    'backup_import' => validation_for(
        params => {
            mail   => { type => Str, optional => 0 },
            id     => { type => Int, optional => 0 },
            time   => { type => Int, optional => 0 },
            filter => { type => Str, optional => 0 },

        },
    ),
    'list' => validation_for(
        params => {
            mail => { type => Str, optional => 0 },

        },
    ),

);


sub backup_import ($self, %params) {
    my $validator = $validators{'backup_import'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.backup.import', \%params, \%opt );
}

sub list ($self, %params) {
    my $validator = $validators{'list'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mail.backup.list', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Backup - MailboxOrg::API::Backup

=head1 VERSION

version 1.0.0

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 backup_import

Import an E-Mail-Backup into the users mailaccount

Available for admin, account, domain, mail

Parameters:

=over 4

=item * mail

=item * id

=item * time

=item * filter

=back

returns: array

    $api->backup->backup_import(%params);

=head2 list

Lists all existing E-Mail-backups

Available for admin, account, domain, mail

Parameters:

=over 4

=item * mail

=back

returns: array

    $api->backup->list(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
