package Zodiac::Chinese::Table;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-01-02'; # DATE
our $DIST = 'Zodiac-Chinese-Table'; # DIST
our $VERSION = '0.020'; # VERSION

use 5.010001;
use strict;
use utf8;
use warnings;

use List::BinarySearch::XS qw(binsearch);

use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(
                       chinese_zodiac
               );

# BEGIN FRAGMENT id=meta-chinese_zodiac
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/chinese_zodiac/meta.yaml
# src-revision: 503280f40be8a30712dc437a3721edf784017757 (Sat Nov 21 08:21:54 2015 +0700)
# generate-date: Thu Jan  2 13:29:38 2020 UTC
# generated-by: update-fragments-in-perl-module
our $meta = {
  "fields" => {
    earthly_branch => { pos => 5, schema => "str*" },
    element        => { pos => 3, schema => "str*" },
    en_animal      => { pos => 7, schema => "str*" },
    end_date       => { pos => 1, schema => "date*" },
    heavenly_stem  => { pos => 4, schema => "str*" },
    start_date     => { pos => 0, schema => "date*" },
    yin_yang       => { pos => 2, schema => "str*" },
    zh_animal      => { pos => 6, schema => "str*" },
  },
  "pk" => "start_date",
  "summary" => "Chinese zodiac",
  "summary.alt.lang.id_ID" => "Zodiak Cina",
  "table_aliases.alt.lang.id_ID" => ["zodiak_cina"],
};
# END FRAGMENT id=meta-chinese_zodiac

# BEGIN FRAGMENT id=data-chinese_zodiac
# note: This fragment's content is generated by a script. Do not edit manually!
# src-file: /home/u1/repos/gudangdata/bin/../table/chinese_zodiac/data.csv
# src-revision: 503280f40be8a30712dc437a3721edf784017757 (Sat Nov 21 08:21:54 2015 +0700)
# generate-date: Thu Jan  2 13:29:38 2020 UTC
# generated-by: update-fragments-in-perl-module
our $data = [
  [
    "1900-01-31",
    "1901-02-18",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1901-02-19",
    "1902-02-07",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1902-02-08",
    "1903-01-28",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1903-01-29",
    "1904-02-15",
    "yin",
    "water",
    "\x{7678}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1904-02-16",
    "1905-02-03",
    "yang",
    "wood",
    "\x{7532}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1905-02-04",
    "1906-01-24",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1906-01-25",
    "1907-02-12",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1907-02-13",
    "1908-02-01",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1908-02-02",
    "1909-01-21",
    "yang",
    "earth",
    "\x{620A}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1909-01-22",
    "1910-02-09",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1910-02-10",
    "1911-01-29",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1911-01-30",
    "1912-02-17",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1912-02-18",
    "1913-02-05",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1913-02-06",
    "1914-01-25",
    "yin",
    "water",
    "\x{7678}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1914-01-26",
    "1915-02-13",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1915-02-14",
    "1916-02-02",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1916-02-03",
    "1917-01-22",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1917-01-23",
    "1918-02-10",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1918-02-11",
    "1919-01-31",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1919-02-01",
    "1920-02-19",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1920-02-20",
    "1921-02-07",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1921-02-08",
    "1922-01-27",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1922-01-28",
    "1923-02-15",
    "yang",
    "water",
    "\x{58EC}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1923-02-16",
    "1924-02-04",
    "yin",
    "water",
    "\x{7678}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1924-02-05",
    "1925-01-23",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1925-01-24",
    "1926-02-12",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1926-02-13",
    "1927-02-01",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1927-02-02",
    "1928-01-22",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1928-01-23",
    "1929-02-09",
    "yang",
    "earth",
    "\x{620A}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1929-02-10",
    "1930-01-29",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1930-01-30",
    "1931-02-16",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1931-02-17",
    "1932-02-05",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1932-02-06",
    "1933-01-25",
    "yang",
    "water",
    "\x{58EC}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1933-01-26",
    "1934-02-13",
    "yin",
    "water",
    "\x{7678}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1934-02-14",
    "1935-02-03",
    "yang",
    "wood",
    "\x{7532}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1935-02-04",
    "1936-01-23",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1936-01-24",
    "1937-02-10",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1937-02-11",
    "1938-01-30",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1938-01-31",
    "1939-02-18",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1939-02-19",
    "1940-02-07",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1940-02-08",
    "1941-01-26",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1941-01-27",
    "1942-02-14",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1942-02-15",
    "1943-02-04",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1943-02-05",
    "1944-01-24",
    "yin",
    "water",
    "\x{7678}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1944-01-25",
    "1945-02-12",
    "yang",
    "wood",
    "\x{7532}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1945-02-13",
    "1946-02-01",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1946-02-02",
    "1947-01-21",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1947-01-22",
    "1948-02-09",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1948-02-10",
    "1949-01-28",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1949-01-29",
    "1950-02-16",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1950-02-17",
    "1951-02-05",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1951-02-06",
    "1952-01-26",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1952-01-27",
    "1953-02-13",
    "yang",
    "water",
    "\x{58EC}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1953-02-14",
    "1954-02-02",
    "yin",
    "water",
    "\x{7678}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1954-02-03",
    "1955-01-23",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1955-01-24",
    "1956-02-11",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1956-02-12",
    "1957-01-30",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1957-01-31",
    "1958-02-17",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1958-02-18",
    "1959-02-07",
    "yang",
    "earth",
    "\x{620A}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1959-02-08",
    "1960-01-27",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1960-01-28",
    "1961-02-14",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1961-02-15",
    "1962-02-04",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1962-02-05",
    "1963-01-24",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1963-01-25",
    "1964-02-12",
    "yin",
    "water",
    "\x{7678}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1964-02-13",
    "1965-02-01",
    "yang",
    "wood",
    "\x{7532}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1965-02-02",
    "1966-01-20",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1966-01-21",
    "1967-02-08",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1967-02-09",
    "1968-01-29",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1968-01-30",
    "1969-02-16",
    "yang",
    "earth",
    "\x{620A}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1969-02-17",
    "1970-02-05",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1970-02-06",
    "1971-01-26",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1971-01-27",
    "1972-02-14",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1972-02-15",
    "1973-02-02",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1973-02-03",
    "1974-01-22",
    "yin",
    "water",
    "\x{7678}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1974-01-23",
    "1975-02-10",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1975-02-11",
    "1976-01-30",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1976-01-31",
    "1977-02-17",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1977-02-18",
    "1978-02-06",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1978-02-07",
    "1979-01-27",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1979-01-28",
    "1980-02-15",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1980-02-16",
    "1981-02-04",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1981-02-05",
    "1982-01-24",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1982-01-25",
    "1983-02-12",
    "yang",
    "water",
    "\x{58EC}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1983-02-13",
    "1984-02-01",
    "yin",
    "water",
    "\x{7678}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1984-02-02",
    "1985-02-19",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1985-02-20",
    "1986-02-08",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1986-02-09",
    "1987-01-28",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1987-01-29",
    "1988-02-16",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "1988-02-17",
    "1989-02-05",
    "yang",
    "earth",
    "\x{620A}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "1989-02-06",
    "1990-01-26",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "1990-01-27",
    "1991-02-14",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "1991-02-15",
    "1992-02-03",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "1992-02-04",
    "1993-01-22",
    "yang",
    "water",
    "\x{58EC}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "1993-01-23",
    "1994-02-09",
    "yin",
    "water",
    "\x{7678}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "1994-02-10",
    "1995-01-30",
    "yang",
    "wood",
    "\x{7532}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "1995-01-31",
    "1996-02-18",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "1996-02-19",
    "1997-02-06",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "1997-02-07",
    "1998-01-27",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "1998-01-28",
    "1999-02-15",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "1999-02-16",
    "2000-02-04",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2000-02-05",
    "2001-01-23",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2001-01-24",
    "2002-02-11",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2002-02-12",
    "2003-01-31",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2003-02-01",
    "2004-01-21",
    "yin",
    "water",
    "\x{7678}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2004-01-22",
    "2005-02-08",
    "yang",
    "wood",
    "\x{7532}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2005-02-09",
    "2006-01-28",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2006-01-29",
    "2007-02-17",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2007-02-18",
    "2008-02-06",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "2008-02-07",
    "2009-01-25",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "2009-01-26",
    "2010-02-13",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "2010-02-14",
    "2011-02-02",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "2011-02-03",
    "2012-01-22",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2012-01-23",
    "2013-02-09",
    "yang",
    "water",
    "\x{58EC}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2013-02-10",
    "2014-01-30",
    "yin",
    "water",
    "\x{7678}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2014-01-31",
    "2015-02-18",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2015-02-19",
    "2016-02-07",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2016-02-08",
    "2017-01-27",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2017-01-28",
    "2018-02-15",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2018-02-16",
    "2019-02-04",
    "yang",
    "earth",
    "\x{620A}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2019-02-05",
    "2020-01-24",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "2020-01-25",
    "2021-02-11",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "2021-02-12",
    "2022-01-31",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "2022-02-01",
    "2023-01-21",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "2023-01-22",
    "2024-02-09",
    "yin",
    "water",
    "\x{7678}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2024-02-10",
    "2025-01-28",
    "yang",
    "wood",
    "\x{7532}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2025-01-29",
    "2026-02-16",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2026-02-17",
    "2027-02-05",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2027-02-06",
    "2028-01-25",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2028-01-26",
    "2029-02-12",
    "yang",
    "earth",
    "\x{620A}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2029-02-13",
    "2030-02-02",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2030-02-03",
    "2031-01-22",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2031-01-23",
    "2032-02-10",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "2032-02-11",
    "2033-01-30",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "2033-01-31",
    "2034-02-18",
    "yin",
    "water",
    "\x{7678}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "2034-02-19",
    "2035-02-07",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "2035-02-08",
    "2036-01-27",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2036-01-28",
    "2037-02-14",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2037-02-15",
    "2038-02-03",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2038-02-04",
    "2039-01-23",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2039-01-24",
    "2040-02-11",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2040-02-12",
    "2041-01-31",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2041-02-01",
    "2042-01-21",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2042-01-22",
    "2043-02-09",
    "yang",
    "water",
    "\x{58EC}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2043-02-10",
    "2044-01-29",
    "yin",
    "water",
    "\x{7678}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "2044-01-30",
    "2045-02-16",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "2045-02-17",
    "2046-02-05",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "2046-02-06",
    "2047-01-25",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "2047-01-26",
    "2048-02-13",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2048-02-14",
    "2049-02-01",
    "yang",
    "earth",
    "\x{620A}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2049-02-02",
    "2050-01-22",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2050-01-23",
    "2051-02-10",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2051-02-11",
    "2052-01-31",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2052-02-01",
    "2053-02-18",
    "yang",
    "water",
    "\x{58EC}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2053-02-19",
    "2054-02-07",
    "yin",
    "water",
    "\x{7678}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2054-02-08",
    "2055-01-27",
    "yang",
    "wood",
    "\x{7532}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2055-01-28",
    "2056-02-14",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "2056-02-15",
    "2057-02-03",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "2057-02-04",
    "2058-01-23",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "2058-01-24",
    "2059-02-11",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "2059-02-12",
    "2060-02-01",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2060-02-02",
    "2061-01-20",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2061-01-21",
    "2062-02-08",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2062-02-09",
    "2063-01-28",
    "yang",
    "water",
    "\x{58EC}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2063-01-29",
    "2064-02-16",
    "yin",
    "water",
    "\x{7678}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2064-02-17",
    "2065-02-04",
    "yang",
    "wood",
    "\x{7532}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2065-02-05",
    "2066-01-25",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2066-01-26",
    "2067-02-13",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2067-02-14",
    "2068-02-02",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "2068-02-03",
    "2069-01-22",
    "yang",
    "earth",
    "\x{620A}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "2069-01-23",
    "2070-02-10",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "2070-02-11",
    "2071-01-30",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "2071-01-31",
    "2072-02-18",
    "yin",
    "metal",
    "\x{8F9B}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2072-02-19",
    "2073-02-06",
    "yang",
    "water",
    "\x{58EC}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2073-02-07",
    "2074-01-26",
    "yin",
    "water",
    "\x{7678}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2074-01-27",
    "2075-02-14",
    "yang",
    "wood",
    "\x{7532}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2075-02-15",
    "2076-02-04",
    "yin",
    "wood",
    "\x{4E59}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2076-02-05",
    "2077-01-23",
    "yang",
    "fire",
    "\x{4E19}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2077-01-24",
    "2078-02-11",
    "yin",
    "fire",
    "\x{4E01}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2078-02-12",
    "2079-02-01",
    "yang",
    "earth",
    "\x{620A}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2079-02-02",
    "2080-01-21",
    "yin",
    "earth",
    "\x{5DF1}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
  [
    "2080-01-22",
    "2081-02-08",
    "yang",
    "metal",
    "\x{5E9A}",
    "\x{5B50}",
    "\x{9F20}",
    "rat",
  ],
  [
    "2081-02-09",
    "2082-01-28",
    "yang",
    "metal",
    "\x{8F9B}",
    "\x{4E11}",
    "\x{725B}",
    "ox",
  ],
  [
    "2082-01-29",
    "2083-02-16",
    "yin",
    "water",
    "\x{58EC}",
    "\x{5BC5}",
    "\x{864E}",
    "tiger",
  ],
  [
    "2083-02-17",
    "2084-02-05",
    "yang",
    "water",
    "\x{7678}",
    "\x{536F}",
    "\x{5154}",
    "rabbit",
  ],
  [
    "2084-02-06",
    "2085-01-25",
    "yin",
    "wood",
    "\x{7532}",
    "\x{8FB0}",
    "\x{9F8D}",
    "dragon",
  ],
  [
    "2085-01-26",
    "2086-02-13",
    "yang",
    "wood",
    "\x{4E59}",
    "\x{5DF3}",
    "\x{86C7}",
    "snake",
  ],
  [
    "2086-02-14",
    "2087-02-02",
    "yin",
    "fire",
    "\x{4E19}",
    "\x{5348}",
    "\x{99AC}",
    "horse",
  ],
  [
    "2087-02-03",
    "2088-01-23",
    "yang",
    "fire",
    "\x{4E01}",
    "\x{672A}",
    "\x{7F8A}",
    "goat",
  ],
  [
    "2088-01-24",
    "2089-02-09",
    "yin",
    "earth",
    "\x{620A}",
    "\x{7533}",
    "\x{7334}",
    "monkey",
  ],
  [
    "2089-02-10",
    "2090-01-29",
    "yang",
    "earth",
    "\x{5DF1}",
    "\x{9149}",
    "\x{96DE}",
    "rooster",
  ],
  [
    "2090-01-30",
    "2091-02-17",
    "yin",
    "metal",
    "\x{5E9A}",
    "\x{620C}",
    "\x{72D7}",
    "dog",
  ],
  [
    "2091-02-18",
    "2092-02-06",
    "yang",
    "metal",
    "\x{8F9B}",
    "\x{4EA5}",
    "\x{732A}",
    "pig",
  ],
];
# END FRAGMENT id=data-chinese_zodiac

sub chinese_zodiac {
    my $date = shift;

    my $idx = binsearch {
        $a lt $b->[0] ? -1 :
            $a gt $b->[1] ? 1 : 0
        } $date, @$data;
    return undef unless defined $idx;

    $data->[$idx];
}

1;
# ABSTRACT: Look up Chinese zodiac for a given Gregorian date

__END__

=pod

=encoding UTF-8

=head1 NAME

Zodiac::Chinese::Table - Look up Chinese zodiac for a given Gregorian date

=head1 VERSION

This document describes version 0.020 of Zodiac::Chinese::Table (from Perl distribution Zodiac-Chinese-Table), released on 2020-01-02.

=head1 SYNOPSIS

 use Chinese::Zodiac::Table qw(chinese_zodiac);
 my $res = chinese_zodiac("1980-02-17");

Sample result:

 [
   "1980-02-16",
   "1981-02-04",
   "yang",
   "metal",
   "庚",
   "申",
   "猴",
   "monkey",
 ]

=head1 DESCRIPTION

This module can look up Chinese zodiac for a given Gregorian date. Compared to
L<Zodiac::Chinese>, it uses a lookup table (currently available for Jan 1900 -
Feb 2092) so it is more accurate.

Data source is currently at: https://github.com/perlancar/gudangdata
(table/chinese_zodiac), which in turn is parsed from Wikipedia article.

=head1 FUNCTIONS

=head2 chinese_zodiac($date) => arrayref

Return Chinese zodiac information for a Gregorian date C<$date>. Currently date
must be a string in the format of C<YYYY-MM-DD>. Will return an arrayref
containing these elements:

 # index: 0         1           2           3              4               5               6            7
 ["start_date", "end_date", "yin_yang", "element", "heavenly_stem", "earthly_branch", "zh_animal", "en_animal"].

Will return undef if date range is unsupported.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Zodiac-Chinese-Table>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Zodiac-Chinese-Table>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Zodiac-Chinese-Table>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Zodiac::Chinese>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
