## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::perl::modname_or_prefix;

# preamble code
no warnings 'experimental::regex_sets';

our $DATE = '2023-01-14'; # DATE
our $VERSION = '0.047'; # VERSION

our $rschema = do{my$var={base=>"str",clsets_after_base=>[{description=>"\nContains coercion rule so inputing `Foo-Bar` or `Foo/Bar` will be normalized to\n`Foo::Bar` while inputing `Foo-Bar-` or `Foo/Bar/` will be normalized to\n`Foo::Bar::`\n\nSee also: `perl::modname` and `perl::modprefix`.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,value=>"Foo::Bar"},{valid=>1,value=>"Foo::Bar::"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo/Bar"},{valid=>1,validated_value=>"Foo::Bar::",value=>"Foo/Bar/"},{valid=>1,validated_value=>"Foo::Bar",value=>"Foo-Bar"},{valid=>1,validated_value=>"Foo::Bar::",value=>"Foo-Bar-"},{valid=>0,value=>"Foo|Bar"}],match=>"\\A[A-Za-z_][A-Za-z_0-9]*(::[A-Za-z_0-9]+)*(?:::)?\\z",summary=>"Perl module name (e.g. Foo::Bar) or prefix (e.g. Foo::Bar::)","x.completion"=>"perl_modname_or_prefix","x.perl.coerce_rules"=>["From_str::normalize_perl_modname_or_prefix"]}],clsets_after_type=>['$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_base}[0]'],resolve_path=>["str"],type=>"str",v=>2};$var->{clsets_after_type}[0]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: Perl module name (e.g. Foo::Bar) or prefix (e.g. Foo::Bar::)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::perl::modname_or_prefix - Perl module name (e.g. Foo::Bar) or prefix (e.g. Foo::Bar::)

=head1 VERSION

This document describes version 0.047 of Sah::SchemaR::perl::modname_or_prefix (from Perl distribution Sah-Schemas-Perl), released on 2023-01-14.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Perl>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Perl>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2022, 2021, 2020, 2019, 2018, 2017, 2016 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Perl>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
