## no critic: TestingAndDebugging::RequireStrict
package Sah::SchemaR::filename::default_only_file_in_curdir;

our $DATE = '2023-11-23'; # DATE
our $VERSION = '0.026'; # VERSION

our $rschema = do{my$var={base=>"filename",clsets_after_base=>[{description=>"\nThis is like the `filename` schema but with a default value of \"only file in the\ncurrent directory\". That is, if the current directory has a single plain file\nand nothing else.\n\nDifference with `filename::default_only_file_not_subdir_in_subdir` schema: the\nother schema ignores subdirectories. Thus, if a directory only contains `file1`\nand `subdir1`, then that other schema will return `file1` but this schema will\nnot return a default value.\n\nNote: be careful when using this schema for actions that are destructive,\nbecause a user can perform those actions without giving an argument (e.g. in a\n`delete-file` script). It is safer to use this schema when performing a\nnon=destructive action (e.g. `checksum`) and/or operate in dry-run mode by\ndefault.\n\n",summary=>"File name, defaults to only file in current directory (if there is one)","x.perl.default_value_rules"=>["Path::only_file_in_curdir"]}],clsets_after_type=>[{description=>"\nThis schema is basically string with some checks and prefilters. Why use this\nschema instead of plain ol' str? Mainly to give you the ability to change tilde\nto user's home directory, e.g. `~/foo.txt` into `/home/someuser/foo.txt`.\nNormally this expansion is done by a Unix shell, but sometimes your program\nreceives an unexpanded path, e.g. when you get it from some config file.\n\nSee also more OS-specific schemas like `filename::unix`, which adds some more\nchecks (e.g. filename cannot contain forward slash and each component cannot be\nlonger than 255 characters) and preprocessing (e.g. stripping extraneous slashes\nlike `foo//bar` into `foo/bar`.\n\nWhat's the difference between this schema and `dirname`? The default completion\nrule. `dirname`'s completion only includes directories and not files.\n\n",examples=>[{valid=>0,value=>""},{valid=>1,value=>"foo"},{valid=>1,value=>"foo/bar"}],min_len=>1,prefilters=>["Path::expand_tilde_when_on_unix","Path::strip_slashes_when_on_unix"],summary=>"Filesystem file name","x.completion"=>["filename"]},'$var->{clsets_after_base}[0]'],"clsets_after_type.alt.merge.merged"=>['$var->{clsets_after_type}[0]','$var->{clsets_after_base}[0]'],resolve_path=>["str","filename"],type=>"str",v=>2};$var->{clsets_after_type}[1]=$var->{clsets_after_base}[0];$var->{"clsets_after_type.alt.merge.merged"}[0]=$var->{clsets_after_type}[0];$var->{"clsets_after_type.alt.merge.merged"}[1]=$var->{clsets_after_base}[0];$var};

1;
# ABSTRACT: File name, defaults to only file in current directory (if there is one)

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::SchemaR::filename::default_only_file_in_curdir - File name, defaults to only file in current directory (if there is one)

=head1 VERSION

This document describes version 0.026 of Sah::SchemaR::filename::default_only_file_in_curdir (from Perl distribution Sah-Schemas-Path), released on 2023-11-23.

=head1 DESCRIPTION

This module is automatically generated by Dist::Zilla::Plugin::Sah::Schemas during distribution build.

A Sah::SchemaR::* module is useful if a client wants to quickly lookup the base type of a schema without having to do any extra resolving. With Sah::Schema::*, one might need to do several lookups if a schema is based on another schema, and so on. Compare for example L<Sah::Schema::poseven> vs L<Sah::SchemaR::poseven>, where in Sah::SchemaR::poseven one can immediately get that the base type is C<int>. Currently L<Perinci::Sub::Complete> uses Sah::SchemaR::* instead of Sah::Schema::* for reduced startup overhead when doing tab completion.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Path>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Path>.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2020, 2019, 2018, 2016 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Path>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
