package BorderStyle::BoxChar::SingleLineVerticalOnly;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-01-31'; # DATE
our $DIST = 'BorderStyles-Standard'; # DIST
our $VERSION = '0.005'; # VERSION

use strict;
use parent 'BorderStyleBase';

our %BORDER = (
    v => 2,
    summary => 'Single line border with box-drawing characters, vertical only',
    chars => [
        ['x',' ','x','x'], # 0
        ['x','x','x'],     # 1
        ['x',' ','x','x', ' ',' '], # 2
        ['x','x','x'],     # 3
        ['x','q','x','x', 'q','q','x','x'], # 4
        ['x',' ','x','x'], # 5
    ],
    box_chars => 1,
);

1;
# ABSTRACT: Single line border with box-drawing characters, vertical only

__END__

=pod

=encoding UTF-8

=head1 NAME

BorderStyle::BoxChar::SingleLineVerticalOnly - Single line border with box-drawing characters, vertical only

=head1 VERSION

This document describes version 0.005 of BorderStyle::BoxChar::SingleLineVerticalOnly (from Perl distribution BorderStyles-Standard), released on 2021-01-31.

=head1 SYNOPSIS

To use with L<Text::Table::TinyBorderStyle>:

 use Text::Table::TinyBorderStyle qw/generate_table/;
 my $rows =
   [
     ["ColumName1", "ColumnNameB", "ColumnNameC"],
     ["row1A", "row1B", "row1C"],
     ["row2A", "row2B", "row2C"],
     ["row3A", "row3B", "row3C"],
   ];
 generate_table(rows=>$rows, header_row=>1, separate_rows=>1, border_style=>"BorderStyle::BoxChar::SingleLineVerticalOnly");

To use with L<Text::ANSITable>:

 # TODO

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/BorderStyles-Standard>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-BorderStyles-Standard>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-BorderStyles-Standard/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<BorderStyle::BoxChar::SingleLine>

L<BorderStyle::BoxChar::SingleLineHorizontalOnly>

L<BorderStyle::ASCII::SingleLineVerticalOnly>

L<BorderStyle::UTF8::SingleLineVerticalOnly>

L<BorderStyle::Custom>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
