package BorderStyle::ASCII::SingleLine;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-06-11'; # DATE
our $DIST = 'BorderStyles-Standard'; # DIST
our $VERSION = '0.001'; # VERSION

use strict;
use parent 'BorderStyleBase';

our %BORDER = (
    v => 2,
    summary => 'Single line border with ASCII characters',
    chars => [
        ['.','-','+','.'], # 0
        ['|','|','|'],     # 1
        ['+','-','+','+'], # 2
        ['|','|','|'],     # 3
        ['+','-','+','+'], # 4
        ['`','-','+',"'"], # 5
    ],
);

1;
# ABSTRACT: Single line border with ASCII characters

__END__

=pod

=encoding UTF-8

=head1 NAME

BorderStyle::ASCII::SingleLine - Single line border with ASCII characters

=head1 VERSION

This document describes version 0.001 of BorderStyle::ASCII::SingleLine (from Perl distribution BorderStyles-Standard), released on 2020-06-11.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/BorderStyles-Standard>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-BorderStyles-Standard>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=BorderStyles-Standard>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<BorderStyle::Custom>

L<BorderStyle::BoxChar::SingleLine>

L<BorderStyle::UTF8::SingleLine>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
