use 5.006;
use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::Compile 2.054

use Test::More;

plan tests => 25 + ($ENV{AUTHOR_TESTING} ? 1 : 0);

my @module_files = (
    'Bencher/Backend.pm',
    'Bencher/Formatter.pm',
    'Bencher/Formatter/AddVsSlowestField.pm',
    'Bencher/Formatter/CodeStartup.pm',
    'Bencher/Formatter/DeleteConstantFields.pm',
    'Bencher/Formatter/DeleteNotesFieldIfEmpty.pm',
    'Bencher/Formatter/DeleteSeqField.pm',
    'Bencher/Formatter/ModuleStartup.pm',
    'Bencher/Formatter/RenderAsTextTable.pm',
    'Bencher/Formatter/RoundNumbers.pm',
    'Bencher/Formatter/ScaleRate.pm',
    'Bencher/Formatter/ScaleSize.pm',
    'Bencher/Formatter/ScaleTime.pm',
    'Bencher/Formatter/ShowEnv.pm',
    'Bencher/Formatter/Sort.pm',
    'Bencher/Role/FieldMunger.pm',
    'Bencher/Role/ResultMunger.pm',
    'Bencher/Role/ResultRenderer.pm',
    'Bencher/Scenario/Example.pm',
    'Bencher/Scenario/Example/CmdLineTemplate.pm',
    'Bencher/Scenario/Example/CommandNotFound.pm',
    'Bencher/Scenario/Example/MultipleArgValues/Array.pm',
    'Bencher/Scenario/Example/MultipleArgValues/Hash.pm',
    'Benchmark/Dumb/SimpleTime.pm',
    'Sah/Schema/bencher/scenario.pm'
);



# no fake home requested

my $inc_switch = -d 'blib' ? '-Mblib' : '-Ilib';

use File::Spec;
use IPC::Open3;
use IO::Handle;

open my $stdin, '<', File::Spec->devnull or die "can't open devnull: $!";

my @warnings;
for my $lib (@module_files)
{
    # see L<perlfaq8/How can I capture STDERR from an external command?>
    my $stderr = IO::Handle->new;

    my $pid = open3($stdin, '>&STDERR', $stderr, $^X, $inc_switch, '-e', "require q[$lib]");
    binmode $stderr, ':crlf' if $^O eq 'MSWin32';
    my @_warnings = <$stderr>;
    waitpid($pid, 0);
    is($?, 0, "$lib loaded ok");

    shift @_warnings if @_warnings and $_warnings[0] =~ /^Using .*\bblib/
        and not eval { require blib; blib->VERSION('1.01') };

    if (@_warnings)
    {
        warn @_warnings;
        push @warnings, @_warnings;
    }
}



is(scalar(@warnings), 0, 'no warnings found')
    or diag 'got warnings: ', ( Test::More->can('explain') ? Test::More::explain(\@warnings) : join("\n", '', @warnings) ) if $ENV{AUTHOR_TESTING};


