package Acme::CPANModules::GrepVariants;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-07-02'; # DATE
our $DIST = 'Acme-CPANModules-GrepVariants'; # DIST
our $VERSION = '0.003'; # VERSION

use strict;
use Acme::CPANModulesUtil::Misc;

my $description = <<'_';
**1. Reimplementations**

grep for <pm:PerlPowerTools> simply tries to reimplement grep in Perl, as part
of the project to reimplement many Unix utilities in Perl. It has few practical
uses.


**2a. Improvements in recursive searching against files**

**ack**. Created in 2005 by Andy Lester, <pm:ack> is the granddaddy of grep-like
programs that try to improve the experience of using grep to search for text in
source code. ack skips VCS directories like `.git` or `.svn`, and understands
file types so it doesn't look into giant `.mp4`s and other binaries by default.
ack has spurred the development of other ack improvements (mostly in speed
aspect) like The Silver Searcher (`ag`) or `ripgrep`. `git` also now includes a
`git-grep` utility. ack has a website: <https://beyondgrep.com>. See also
<https://betterthanack.com>.


**2b. Improvements in specifying multiple patterns**

Normally with the regular grep, to search for all 'foo' and 'bar', you either
have to do something like:

    % grep --color=always foo FILES | grep bar

or:

    % grep -P 'foo.*bar|bar.*foo' FILES

both of which get unwieldy if the number of patterns get higher. Or you can use
look-ahead:

    % grep -P '(?=.*foo)(?=.*bar)' FILES

but this does not capture (thus highlight) the patterns.

Note that searching for multiple patterns in particular order ('foo.*bar'), or
searching for aternates from multiple patterns ('foo|bar') is no problem in
grep.

Some tools have been written to make it easier to specify multiple patterns.

<prog:abgrep> from <pm:App::abgrep>.

<prog:greple> from <pm:App::Greple>. greple also has a few other tricks up its
sleeve, like configuration file to define complex regexes, matching across
lines, and Japanese text support.

<prog:grep-terms> from <pm:App::GrepUtils> all try to make searching for
multiple patterns in grep easier.


**3. Variants: alternate ways of specifying regex**

Instead of specifying a pattern, with <pm:App::rpgrep> you can specify a pattern
name in a <pm:Regexp::Pattern>::* module instead.


**4a. Variants: alternate source: Perl source code**

<prog:pmgrep> from <pm:App::pmgrep> lets you grep over locally installed Perl
modules. It's basically a shortcut for something like this:

    % pmlist -Rx | xargs grep PAT
    % grep PAT `pmlist -Rx`

<prog:grepl> from <pm:App::Grepl> uses <pm:PPI> to let you grep over Perl
*documents*; it allows you to do things like: search only in Perl code comments
or inside string literals.


**4b. Variants: other alternate sources**

<prog:grep-from-iod> from <pm:App::IODUtils>.

<prog:grep-from-ini> from <pm:App::INIUtils>.

<prog:grep-from-coin> from <pm:App::CryptoCurrencyUtils>.

<prog:grep-from-exchange> from <pm:App::CryptoCurrencyUtils>.


**5a. Variants: searching URLs**

<pm:App::grep::url> greps URLs from lines of input. You don't have to manually
specify regex that matches URLs yourself; you can just add additional criteria
for the URLs, e.g. whether the host part must contain some text, or whether a
certain query parameter must match some pattern.

_

our $LIST = {
    summary => 'Grep-like CLI utilities available on CPAN',
    description => $description,
    entries => [
    ],
};

Acme::CPANModulesUtil::Misc::populate_entries_from_module_links_in_description;

1;
# ABSTRACT: Grep-like CLI utilities available on CPAN

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANModules::GrepVariants - Grep-like CLI utilities available on CPAN

=head1 VERSION

This document describes version 0.003 of Acme::CPANModules::GrepVariants (from Perl distribution Acme-CPANModules-GrepVariants), released on 2021-07-02.

=head1 DESCRIPTION

B<1. Reimplementations>

grep for L<PerlPowerTools> simply tries to reimplement grep in Perl, as part
of the project to reimplement many Unix utilities in Perl. It has few practical
uses.

B<2a. Improvements in recursive searching against files>

B<ack>. Created in 2005 by Andy Lester, L<ack> is the granddaddy of grep-like
programs that try to improve the experience of using grep to search for text in
source code. ack skips VCS directories like C<.git> or C<.svn>, and understands
file types so it doesn't look into giant C<.mp4>s and other binaries by default.
ack has spurred the development of other ack improvements (mostly in speed
aspect) like The Silver Searcher (C<ag>) or C<ripgrep>. C<git> also now includes a
C<git-grep> utility. ack has a website: L<https://beyondgrep.com>. See also
L<https://betterthanack.com>.

B<2b. Improvements in specifying multiple patterns>

Normally with the regular grep, to search for all 'foo' and 'bar', you either
have to do something like:

 % grep --color=always foo FILES | grep bar

or:

 % grep -P 'foo.*bar|bar.*foo' FILES

both of which get unwieldy if the number of patterns get higher. Or you can use
look-ahead:

 % grep -P '(?=.*foo)(?=.*bar)' FILES

but this does not capture (thus highlight) the patterns.

Note that searching for multiple patterns in particular order ('foo.*bar'), or
searching for aternates from multiple patterns ('foo|bar') is no problem in
grep.

Some tools have been written to make it easier to specify multiple patterns.

L<abgrep> from L<App::abgrep>.

L<greple> from L<App::Greple>. greple also has a few other tricks up its
sleeve, like configuration file to define complex regexes, matching across
lines, and Japanese text support.

L<grep-terms> from L<App::GrepUtils> all try to make searching for
multiple patterns in grep easier.

B<3. Variants: alternate ways of specifying regex>

Instead of specifying a pattern, with L<App::rpgrep> you can specify a pattern
name in a L<Regexp::Pattern>::* module instead.

B<4a. Variants: alternate source: Perl source code>

L<pmgrep> from L<App::pmgrep> lets you grep over locally installed Perl
modules. It's basically a shortcut for something like this:

 % pmlist -Rx | xargs grep PAT
 % grep PAT C<pmlist -Rx>

L<grepl> from L<App::Grepl> uses L<PPI> to let you grep over Perl
I<documents>; it allows you to do things like: search only in Perl code comments
or inside string literals.

B<4b. Variants: other alternate sources>

L<grep-from-iod> from L<App::IODUtils>.

L<grep-from-ini> from L<App::INIUtils>.

L<grep-from-coin> from L<App::CryptoCurrencyUtils>.

L<grep-from-exchange> from L<App::CryptoCurrencyUtils>.

B<5a. Variants: searching URLs>

L<App::grep::url> greps URLs from lines of input. You don't have to manually
specify regex that matches URLs yourself; you can just add additional criteria
for the URLs, e.g. whether the host part must contain some text, or whether a
certain query parameter must match some pattern.

=head1 ACME::MODULES ENTRIES

=over

=item * L<PerlPowerTools>

=item * L<ack>

=item * L<App::abgrep>

=item * L<App::Greple>

=item * L<App::GrepUtils>

=item * L<App::rpgrep>

=item * L<Regexp::Pattern>

=item * L<App::pmgrep>

=item * L<App::Grepl>

=item * L<PPI>

=item * L<App::IODUtils>

=item * L<App::INIUtils>

=item * L<App::CryptoCurrencyUtils>

=item * L<App::grep::url>

=back

=head1 FAQ

=head2 What is an Acme::CPANModules::* module?

An Acme::CPANModules::* module, like this module, contains just a list of module
names that share a common characteristics. It is a way to categorize modules and
document CPAN. See L<Acme::CPANModules> for more details.

=head2 What are ways to use this Acme::CPANModules module?

Aside from reading this Acme::CPANModules module's POD documentation, you can
install all the listed modules (entries) using L<cpanm-cpanmodules> script (from
L<App::cpanm::cpanmodules> distribution):

 % cpanm-cpanmodules -n GrepVariants

Alternatively you can use the L<cpanmodules> CLI (from L<App::cpanmodules>
distribution):

    % cpanmodules ls-entries GrepVariants | cpanm -n

or L<Acme::CM::Get>:

    % perl -MAcme::CM::Get=GrepVariants -E'say $_->{module} for @{ $LIST->{entries} }' | cpanm -n

or directly:

    % perl -MAcme::CPANModules::GrepVariants -E'say $_->{module} for @{ $Acme::CPANModules::GrepVariants::LIST->{entries} }' | cpanm -n

This Acme::CPANModules module also helps L<lcpan> produce a more meaningful
result for C<lcpan related-mods> command when it comes to finding related
modules for the modules listed in this Acme::CPANModules module.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANModules-GrepVariants>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANModules-GrepVariants>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANModules-GrepVariants>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANModules> - about the Acme::CPANModules namespace

L<cpanmodules> - CLI tool to let you browse/view the lists

L<Acme::CPANModules::GoodInterfaces>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021, 2020 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
