package WebService::DetectLanguage::Language;
$WebService::DetectLanguage::Language::VERSION = '0.02';
use 5.006;
use Moo;

has code => ( is => 'ro' );
has name => ( is => 'lazy' );

my %code2name = (
           aa => "AFAR",
           ab => "ABKHAZIAN",
           af => "AFRIKAANS",
           ak => "AKAN",
           am => "AMHARIC",
           ar => "ARABIC",
           as => "ASSAMESE",
           ay => "AYMARA",
           az => "AZERBAIJANI",
           ba => "BASHKIR",
           be => "BELARUSIAN",
           bg => "BULGARIAN",
           bh => "BIHARI",
           bi => "BISLAMA",
           bn => "BENGALI",
           bo => "TIBETAN",
           br => "BRETON",
           bs => "BOSNIAN",
          bug => "BUGINESE",
           ca => "CATALAN",
          ceb => "CEBUANO",
          chr => "CHEROKEE",
           co => "CORSICAN",
          crs => "SESELWA",
           cs => "CZECH",
           cy => "WELSH",
           da => "DANISH",
           de => "GERMAN",
           dv => "DHIVEHI",
           dz => "DZONGKHA",
          egy => "EGYPTIAN",
           el => "GREEK",
           en => "ENGLISH",
           eo => "ESPERANTO",
           es => "SPANISH",
           et => "ESTONIAN",
           eu => "BASQUE",
           fa => "PERSIAN",
           fi => "FINNISH",
           fj => "FIJIAN",
           fo => "FAROESE",
           fr => "FRENCH",
           fy => "FRISIAN",
           ga => "IRISH",
           gd => "SCOTS_GAELIC",
           gl => "GALICIAN",
           gn => "GUARANI",
          got => "GOTHIC",
           gu => "GUJARATI",
           gv => "MANX",
           ha => "HAUSA",
          haw => "HAWAIIAN",
           hi => "HINDI",
          hmn => "HMONG",
           hr => "CROATIAN",
           ht => "HAITIAN_CREOLE",
           hu => "HUNGARIAN",
           hy => "ARMENIAN",
           ia => "INTERLINGUA",
           id => "INDONESIAN",
           ie => "INTERLINGUE",
           ig => "IGBO",
           ik => "INUPIAK",
           is => "ICELANDIC",
           it => "ITALIAN",
           iu => "INUKTITUT",
           iw => "HEBREW",
           ja => "JAPANESE",
           jw => "JAVANESE",
           ka => "GEORGIAN",
          kha => "KHASI",
           kk => "KAZAKH",
           kl => "GREENLANDIC",
           km => "KHMER",
           kn => "KANNADA",
           ko => "KOREAN",
           ks => "KASHMIRI",
           ku => "KURDISH",
           ky => "KYRGYZ",
           la => "LATIN",
           lb => "LUXEMBOURGISH",
           lg => "GANDA",
           lif => "LIMBU",
           ln => "LINGALA",
           lo => "LAOTHIAN",
           lt => "LITHUANIAN",
           lv => "LATVIAN",
          mfe => "MAURITIAN_CREOLE",
           mg => "MALAGASY",
           mi => "MAORI",
           mk => "MACEDONIAN",
           ml => "MALAYALAM",
           mn => "MONGOLIAN",
           mr => "MARATHI",
           ms => "MALAY",
           mt => "MALTESE",
           my => "BURMESE",
           na => "NAURU",
           ne => "NEPALI",
           nl => "DUTCH",
           no => "NORWEGIAN",
           nr => "NDEBELE",
          nso => "PEDI",
           ny => "NYANJA",
           oc => "OCCITAN",
           om => "OROMO",
           or => "ORIYA",
           pa => "PUNJABI",
           pl => "POLISH",
           ps => "PASHTO",
           pt => "PORTUGUESE",
           qu => "QUECHUA",
           rm => "RHAETO_ROMANCE",
           rn => "RUNDI",
           ro => "ROMANIAN",
           ru => "RUSSIAN",
           rw => "KINYARWANDA",
           sa => "SANSKRIT",
          sco => "SCOTS",
           sd => "SINDHI",
           sg => "SANGO",
           si => "SINHALESE",
           sk => "SLOVAK",
           sl => "SLOVENIAN",
           sm => "SAMOAN",
           sn => "SHONA",
           so => "SOMALI",
           sq => "ALBANIAN",
           sr => "SERBIAN",
           ss => "SISWANT",
           st => "SESOTHO",
           su => "SUNDANESE",
           sv => "SWEDISH",
           sw => "SWAHILI",
          syr => "SYRIAC",
           ta => "TAMIL",
           te => "TELUGU",
           tg => "TAJIK",
           th => "THAI",
           ti => "TIGRINYA",
           tk => "TURKMEN",
           tl => "TAGALOG",
          tlh => "KLINGON",
           tn => "TSWANA",
           to => "TONGA",
           tr => "TURKISH",
           ts => "TSONGA",
           tt => "TATAR",
           ug => "UIGHUR",
           uk => "UKRAINIAN",
           ur => "URDU",
           uz => "UZBEK",
           ve => "VENDA",
           vi => "VIETNAMESE",
           vo => "VOLAPUK",
          war => "WARAY_PHILIPPINES",
           wo => "WOLOF",
           xh => "XHOSA",
           yi => "YIDDISH",
           yo => "YORUBA",
           za => "ZHUANG",
           zh => "CHINESE_SIMPLIFIED",
    "zh-Hant" => "CHINESE_TRADITIONAL",
           zu => "ZULU",

);

sub _build_name
{
    my $self = shift;

    return $code2name{ $self->code } // "UNKNOWN";
}

1;

