package Moose::Exception::UnableToCanonicalizeHandles;
our $VERSION = '2.2015';

use Moose;
extends 'Moose::Exception';
with 'Moose::Exception::Role::Attribute';

has 'handles' => (
    is       => 'ro',
    isa      => 'Any',
    required => 1,
);

sub _build_message {
    my $self = shift;
    "Unable to canonicalize the 'handles' option with ".$self->handles;
}

__PACKAGE__->meta->make_immutable;
1;
