package Alien::NLOpt;

# ABSTRACT: Build and Install the NLOpt library

use v5.12;
use strict;
use warnings;

our $VERSION = 'v2.7.1.0';

use base qw( Alien::Base );

1;

#
# This file is part of Alien-NLOpt
#
# This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

__END__

=pod

=for :stopwords Diab Jerius Smithsonian Astrophysical Observatory metacpan

=head1 NAME

Alien::NLOpt - Build and Install the NLOpt library

=head1 VERSION

version v2.7.1.0

=head1 SYNOPSIS

  use Alien::NLOpt;

=head1 DESCRIPTION

This module finds or builds the I<NLOpt> library.

=head1 USAGE

Please see L<Alien::Build::Manual::AlienUser> (or equivalently on L<metacpan|https://metacpan.org/pod/distribution/Alien-Build/lib/Alien/Build/Manual/AlienUser.pod>).

=head1 SUPPORT

=head2 Bugs

Please report any bugs or feature requests to bug-alien-nlopt@rt.cpan.org  or through the web interface at: L<https://rt.cpan.org/Public/Dist/Display.html?Name=Alien-NLOpt>

=head2 Source

Source is available at

  https://gitlab.com/djerius/alien-nlopt

and may be cloned from

  https://gitlab.com/djerius/alien-nlopt.git

=head1 AUTHOR

Diab Jerius <djerius@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2024 by Smithsonian Astrophysical Observatory.

This is free software, licensed under:

  The GNU General Public License, Version 3, June 2007

=cut
