#!perl
use 5.24.0;
use warnings;
use Module::Build;
Module::Build->VERSION('0.4004');

my $builder = Module::Build->new(
    module_name        => 'Test::UnixCmdWrap',
    license            => 'bsd',
    dist_author        => q{Jeremy Mates <jeremy.mates@gmail.com>},
    dist_version_from  => 'lib/Test/UnixCmdWrap.pm',
    release_status     => 'stable',
    configure_requires => { 'Module::Build' => '0.4004', },
    test_requires      => { 'Cwd' => '0', 'Test::Most' => '0', },
    requires           => {
        'Carp'              => '0',
        'Cwd'               => '0',
        'File::Spec'        => '0',
        'Moo'               => '0',
        'Test::Cmd'         => '0',
        'Test::Differences' => '0',
        'Test::More'        => '0',
        'Test::UnixExit'    => '0',
    },
    sign           => 1,
    add_to_cleanup => ['Test-UnixCmdWrap-*'],
);

$builder->create_build_script();
