package Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-01-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240101.0'; # VERSION

use Acme::CPANAuthors::Register (
    'BINGOS' => '',
    'ETHER' => '',
    'LEEJO' => '',
    'PERLANCAR' => '',
    'PEVANS' => '',
    'UTASHIRO' => '',
    'OALDERS' => '',
    'KIMOTO' => '',
    'OLIVER' => '',
    'SKIM' => '',
    'DERF' => '',
    'JDEGUEST' => '',
    'BDFOY' => '',
    'HMBRAND' => '',
    'JIMAVERA' => '',
    'ASPOSE' => '',
    'DJERIUS' => '',
    'JAVONET' => '',
    'DDUMONT' => '',
    'DRCLAW' => '',
    'JV' => '',
    'VVELOX' => '',
    'AJNN' => '',
    'DCANTRELL' => '',
    'ABALAMA' => '',
    'CADE' => '',
    'LICHTKIND' => '',
    'NERDVANA' => '',
    'SHLOMIF' => '',
    'BLIAKO' => '',
    'BURAK' => '',
    'CUKEBOT' => '',
    'DROLSKY' => '',
    'EXODIST' => '',
    'GRYPHON' => '',
    'NLNETLABS' => '',
    'TEAM' => '',
    'WYANT' => '',
    'YANICK' => '',
    'BPS' => '',
    'DART' => '',
    'MRUEDA' => '',
    'PJACKLAM' => '',
    'RKAPL' => '',
    'ZHMYLOVE' => '',
    'JGNI' => '',
    'JMATES' => '',
    'BRTASTIC' => '',
    'CCELSO' => '',
    'GENE' => '',
    'GSG' => '',
    'JJATRIA' => '',
    'JRM' => '',
    'OETIKER' => '',
    'RKELSCH' => '',
    'RRWO' => '',
    'SREZIC' => '',
    'TANIGUCHI' => '',
    'TODDR' => '',
    'YANGAK' => '',
    'ZMUGHAL' => '',
    'CGPAN' => '',
    'DAMI' => '',
    'DCHURCH' => '',
    'DERIV' => '',
    'DORNER' => '',
    'FELIPE' => '',
    'GDT' => '',
    'GRICHTER' => '',
    'ISHIGAKI' => '',
    'JGOMEZ' => '',
    'MIKKOI' => '',
    'OODLER' => '',
    'RJBS' => '',
    'RSCHUPP' => '',
    'SHOGO' => '',
    'SIDNEY' => '',
    'TONYC' => '',
    'VOEGELAS' => '',
    'AAHAZRED' => '',
    'ABH' => '',
    'ABRAXXA' => '',
    'AJM' => '',
    'AJOLMA' => '',
    'AKIYM' => '',
    'AVERKIOS' => '',
    'AZOMER' => '',
    'BARTL' => '',
    'BESINT' => '',
    'BLAINEM' => '',
    'BOD' => '',
    'BODOLFO' => '',
    'BOOK' => '',
    'BPSCHUCK' => '',
    'BWEST' => '',
    'CAVAC' => '',
    'CHOROBA' => '',
    'CJFIELDS' => '',
    'COUDOT' => '',
    'CRLCU' => '',
    'CROMEDOME' => '',
    'DAKKAR' => '',
    'DAVECROSS' => '',
    'DEPESZ' => '',
    'DKECHAG' => '',
    'DVEEDEN' => '',
    'EMUNDALL' => '',
    'FREED' => '',
    'GANGLION' => '',
    'GARU' => '',
    'GBROWN' => '',
    'GUILLEM' => '',
    'GUIMARD' => '',
    'HAKONH' => '',
    'HAUKEX' => '',
    'HKOBA' => '',
    'INGY' => '',
    'JKSTILL' => '',
    'JMCNAMARA' => '',
    'JSF' => '',
    'KARUPA' => '',
    'KRAIH' => '',
    'KUERBIS' => '',
    'LIS' => '',
    'LWP' => '',
    'MARKOV' => '',
    'MATHIAS' => '',
    'MAUKE' => '',
    'MBESSON' => '',
    'MERKYS' => '',
    'MHASCH' => '',
    'MICHIELB' => '',
    'MJONDET' => '',
    'MRDVT' => '',
    'OVID' => '',
    'PACMAN' => '',
    'PLICEASE' => '',
    'PMPERRY' => '',
    'POPEFELIX' => '',
    'RHESA' => '',
    'RJET' => '',
    'RMBARKER' => '',
    'SBECK' => '',
    'SKAJI' => '',
    'SLAFFAN' => '',
    'SZABGAB' => '',
    'TEEJAY' => '',
    'TEODESIAN' => '',
    'TOBYINK' => '',
    'TURNSTEP' => '',
    'TVDW' => '',
    'VANHOESEL' => '',
    'VEESH' => '',
    'VKON' => '',
    'WOLDRICH' => '',
    'YOUPONG' => '',
    'YTURTLE' => '',
    'ZEFRAM' => '',
);


1;
# ABSTRACT: Authors with ongoing month releases streak (do a release every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current - Authors with ongoing month releases streak (do a release every month)

=head1 VERSION

This document describes version 20240101.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-01-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-01-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | BINGOS    | 214 | 2006-03    | might-break |
  | ETHER     | 142 | 2012-03    | might-break |
  | LEEJO     | 117 | 2014-04    | might-break |
  | PERLANCAR | 114 | 2014-08    | ongoing     |
  | PEVANS    |  67 | 2018-06    | might-break |
  | UTASHIRO  |  67 | 2018-06    | might-break |
  | OALDERS   |  53 | 2019-08    | might-break |
  | KIMOTO    |  25 | 2021-12    | might-break |
  | OLIVER    |  23 | 2022-02    | might-break |
  | SKIM      |  21 | 2022-04    | might-break |
  | DERF      |  19 | 2022-06    | might-break |
  | JDEGUEST  |  19 | 2022-06    | might-break |
  | BDFOY     |  12 | 2023-01    | might-break |
  | HMBRAND   |  12 | 2023-01    | might-break |
  | JIMAVERA  |  12 | 2023-01    | might-break |
  | ASPOSE    |  11 | 2023-02    | might-break |
  | DJERIUS   |  10 | 2023-03    | might-break |
  | JAVONET   |   9 | 2023-04    | might-break |
  | DDUMONT   |   8 | 2023-05    | might-break |
  | DRCLAW    |   8 | 2023-05    | might-break |
  | JV        |   8 | 2023-05    | might-break |
  | VVELOX    |   8 | 2023-05    | might-break |
  | AJNN      |   7 | 2023-06    | might-break |
  | DCANTRELL |   7 | 2023-06    | might-break |
  | ABALAMA   |   6 | 2023-07    | might-break |
  | CADE      |   6 | 2023-07    | might-break |
  | LICHTKIND |   6 | 2023-07    | might-break |
  | NERDVANA  |   6 | 2023-07    | might-break |
  | SHLOMIF   |   6 | 2023-07    | might-break |
  | BLIAKO    |   5 | 2023-08    | might-break |
  | BURAK     |   5 | 2023-08    | might-break |
  | CUKEBOT   |   5 | 2023-08    | might-break |
  | DROLSKY   |   5 | 2023-08    | might-break |
  | EXODIST   |   5 | 2023-08    | might-break |
  | GRYPHON   |   5 | 2023-08    | might-break |
  | NLNETLABS |   5 | 2023-08    | might-break |
  | TEAM      |   5 | 2023-08    | might-break |
  | WYANT     |   5 | 2023-08    | might-break |
  | YANICK    |   5 | 2023-08    | might-break |
  | BPS       |   4 | 2023-09    | might-break |
  | DART      |   4 | 2023-09    | might-break |
  | MRUEDA    |   4 | 2023-09    | might-break |
  | PJACKLAM  |   4 | 2023-09    | might-break |
  | RKAPL     |   4 | 2023-09    | might-break |
  | ZHMYLOVE  |   4 | 2023-09    | might-break |
  | JGNI      |   4 | 2023-10    | ongoing     |
  | JMATES    |   4 | 2023-10    | ongoing     |
  | BRTASTIC  |   3 | 2023-10    | might-break |
  | CCELSO    |   3 | 2023-10    | might-break |
  | GENE      |   3 | 2023-10    | might-break |
  | GSG       |   3 | 2023-10    | might-break |
  | JJATRIA   |   3 | 2023-10    | might-break |
  | JRM       |   3 | 2023-10    | might-break |
  | OETIKER   |   3 | 2023-10    | might-break |
  | RKELSCH   |   3 | 2023-10    | might-break |
  | RRWO      |   3 | 2023-10    | might-break |
  | SREZIC    |   3 | 2023-10    | might-break |
  | TANIGUCHI |   3 | 2023-10    | might-break |
  | TODDR     |   3 | 2023-10    | might-break |
  | YANGAK    |   3 | 2023-10    | might-break |
  | ZMUGHAL   |   3 | 2023-10    | might-break |
  | CGPAN     |   2 | 2023-11    | might-break |
  | DAMI      |   2 | 2023-11    | might-break |
  | DCHURCH   |   2 | 2023-11    | might-break |
  | DERIV     |   2 | 2023-11    | might-break |
  | DORNER    |   2 | 2023-11    | might-break |
  | FELIPE    |   2 | 2023-11    | might-break |
  | GDT       |   2 | 2023-11    | might-break |
  | GRICHTER  |   2 | 2023-11    | might-break |
  | ISHIGAKI  |   2 | 2023-11    | might-break |
  | JGOMEZ    |   2 | 2023-11    | might-break |
  | MIKKOI    |   2 | 2023-11    | might-break |
  | OODLER    |   2 | 2023-11    | might-break |
  | RJBS      |   2 | 2023-11    | might-break |
  | RSCHUPP   |   2 | 2023-11    | might-break |
  | SHOGO     |   2 | 2023-11    | might-break |
  | SIDNEY    |   2 | 2023-11    | might-break |
  | TONYC     |   2 | 2023-11    | might-break |
  | VOEGELAS  |   2 | 2023-11    | might-break |
  | AAHAZRED  |   1 | 2023-12    | might-break |
  | ABH       |   1 | 2023-12    | might-break |
  | ABRAXXA   |   1 | 2023-12    | might-break |
  | AJM       |   1 | 2023-12    | might-break |
  | AJOLMA    |   1 | 2023-12    | might-break |
  | AKIYM     |   1 | 2023-12    | might-break |
  | AVERKIOS  |   1 | 2023-12    | might-break |
  | AZOMER    |   1 | 2023-12    | might-break |
  | BARTL     |   1 | 2023-12    | might-break |
  | BESINT    |   1 | 2023-12    | might-break |
  | BLAINEM   |   1 | 2023-12    | might-break |
  | BOD       |   1 | 2023-12    | might-break |
  | BODOLFO   |   1 | 2023-12    | might-break |
  | BOOK      |   1 | 2023-12    | might-break |
  | BPSCHUCK  |   1 | 2023-12    | might-break |
  | BWEST     |   1 | 2023-12    | might-break |
  | CAVAC     |   1 | 2023-12    | might-break |
  | CHOROBA   |   1 | 2023-12    | might-break |
  | CJFIELDS  |   1 | 2023-12    | might-break |
  | COUDOT    |   1 | 2023-12    | might-break |
  | CRLCU     |   1 | 2023-12    | might-break |
  | CROMEDOME |   1 | 2023-12    | might-break |
  | DAKKAR    |   1 | 2023-12    | might-break |
  | DAVECROSS |   1 | 2023-12    | might-break |
  | DEPESZ    |   1 | 2023-12    | might-break |
  | DKECHAG   |   1 | 2023-12    | might-break |
  | DVEEDEN   |   1 | 2023-12    | might-break |
  | EMUNDALL  |   1 | 2023-12    | might-break |
  | FREED     |   1 | 2023-12    | might-break |
  | GANGLION  |   1 | 2023-12    | might-break |
  | GARU      |   1 | 2023-12    | might-break |
  | GBROWN    |   1 | 2023-12    | might-break |
  | GUILLEM   |   1 | 2023-12    | might-break |
  | GUIMARD   |   1 | 2023-12    | might-break |
  | HAKONH    |   1 | 2023-12    | might-break |
  | HAUKEX    |   1 | 2023-12    | might-break |
  | HKOBA     |   1 | 2023-12    | might-break |
  | INGY      |   1 | 2023-12    | might-break |
  | JKSTILL   |   1 | 2023-12    | might-break |
  | JMCNAMARA |   1 | 2023-12    | might-break |
  | JSF       |   1 | 2023-12    | might-break |
  | KARUPA    |   1 | 2023-12    | might-break |
  | KRAIH     |   1 | 2023-12    | might-break |
  | KUERBIS   |   1 | 2023-12    | might-break |
  | LIS       |   1 | 2023-12    | might-break |
  | LWP       |   1 | 2023-12    | might-break |
  | MARKOV    |   1 | 2023-12    | might-break |
  | MATHIAS   |   1 | 2023-12    | might-break |
  | MAUKE     |   1 | 2023-12    | might-break |
  | MBESSON   |   1 | 2023-12    | might-break |
  | MERKYS    |   1 | 2023-12    | might-break |
  | MHASCH    |   1 | 2023-12    | might-break |
  | MICHIELB  |   1 | 2023-12    | might-break |
  | MJONDET   |   1 | 2023-12    | might-break |
  | MRDVT     |   1 | 2023-12    | might-break |
  | OVID      |   1 | 2023-12    | might-break |
  | PACMAN    |   1 | 2023-12    | might-break |
  | PLICEASE  |   1 | 2023-12    | might-break |
  | PMPERRY   |   1 | 2023-12    | might-break |
  | POPEFELIX |   1 | 2023-12    | might-break |
  | RHESA     |   1 | 2023-12    | might-break |
  | RJET      |   1 | 2023-12    | might-break |
  | RMBARKER  |   1 | 2023-12    | might-break |
  | SBECK     |   1 | 2023-12    | might-break |
  | SKAJI     |   1 | 2023-12    | might-break |
  | SLAFFAN   |   1 | 2023-12    | might-break |
  | SZABGAB   |   1 | 2023-12    | might-break |
  | TEEJAY    |   1 | 2023-12    | might-break |
  | TEODESIAN |   1 | 2023-12    | might-break |
  | TOBYINK   |   1 | 2023-12    | might-break |
  | TURNSTEP  |   1 | 2023-12    | might-break |
  | TVDW      |   1 | 2023-12    | might-break |
  | VANHOESEL |   1 | 2023-12    | might-break |
  | VEESH     |   1 | 2023-12    | might-break |
  | VKON      |   1 | 2023-12    | might-break |
  | WOLDRICH  |   1 | 2023-12    | might-break |
  | YOUPONG   |   1 | 2023-12    | might-break |
  | YTURTLE   |   1 | 2023-12    | might-break |
  | ZEFRAM    |   1 | 2023-12    | might-break |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
