package Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-01-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240101.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'SKIM' => '',
    'JJATRIA' => '',
    'GENE' => '',
    'JGOMEZ' => '',
    'KIMOTO' => '',
    'MIKKOI' => '',
    'VVELOX' => '',
    'ZMUGHAL' => '',
    'JGNI' => '',
    'AAHAZRED' => '',
    'ABALAMA' => '',
    'ABH' => '',
    'AJNN' => '',
    'AZOMER' => '',
    'BLIAKO' => '',
    'BOOK' => '',
    'BPS' => '',
    'CGPAN' => '',
    'CRLCU' => '',
    'CROMEDOME' => '',
    'DERIV' => '',
    'DJERIUS' => '',
    'EMUNDALL' => '',
    'ETHER' => '',
    'GBROWN' => '',
    'GSG' => '',
    'INGY' => '',
    'JKSTILL' => '',
    'JMATES' => '',
    'JV' => '',
    'KARUPA' => '',
    'KRAIH' => '',
    'MATHIAS' => '',
    'MAUKE' => '',
    'MERKYS' => '',
    'MRDVT' => '',
    'PACMAN' => '',
    'PEVANS' => '',
    'TEEJAY' => '',
    'TEODESIAN' => '',
    'VANHOESEL' => '',
    'VKON' => '',
);


1;
# ABSTRACT: Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current - Authors with ongoing monthly distributions streak (release a new [for them] distribution every month)

=head1 VERSION

This document describes version 20240101.0 of Acme::CPANAuthors::CPAN::Streaks::MonthlyDistributions::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-01-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-01-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 113 | 2014-08    | might-break |
  | SKIM      |  10 | 2023-03    | might-break |
  | JJATRIA   |   3 | 2023-10    | might-break |
  | GENE      |   2 | 2023-11    | might-break |
  | JGOMEZ    |   2 | 2023-11    | might-break |
  | KIMOTO    |   2 | 2023-11    | might-break |
  | MIKKOI    |   2 | 2023-11    | might-break |
  | VVELOX    |   2 | 2023-11    | might-break |
  | ZMUGHAL   |   2 | 2023-11    | might-break |
  | JGNI      |   2 | 2023-12    | ongoing     |
  | AAHAZRED  |   1 | 2023-12    | might-break |
  | ABALAMA   |   1 | 2023-12    | might-break |
  | ABH       |   1 | 2023-12    | might-break |
  | AJNN      |   1 | 2023-12    | might-break |
  | AZOMER    |   1 | 2023-12    | might-break |
  | BLIAKO    |   1 | 2023-12    | might-break |
  | BOOK      |   1 | 2023-12    | might-break |
  | BPS       |   1 | 2023-12    | might-break |
  | CGPAN     |   1 | 2023-12    | might-break |
  | CRLCU     |   1 | 2023-12    | might-break |
  | CROMEDOME |   1 | 2023-12    | might-break |
  | DERIV     |   1 | 2023-12    | might-break |
  | DJERIUS   |   1 | 2023-12    | might-break |
  | EMUNDALL  |   1 | 2023-12    | might-break |
  | ETHER     |   1 | 2023-12    | might-break |
  | GBROWN    |   1 | 2023-12    | might-break |
  | GSG       |   1 | 2023-12    | might-break |
  | INGY      |   1 | 2023-12    | might-break |
  | JKSTILL   |   1 | 2023-12    | might-break |
  | JMATES    |   1 | 2023-12    | might-break |
  | JV        |   1 | 2023-12    | might-break |
  | KARUPA    |   1 | 2023-12    | might-break |
  | KRAIH     |   1 | 2023-12    | might-break |
  | MATHIAS   |   1 | 2023-12    | might-break |
  | MAUKE     |   1 | 2023-12    | might-break |
  | MERKYS    |   1 | 2023-12    | might-break |
  | MRDVT     |   1 | 2023-12    | might-break |
  | PACMAN    |   1 | 2023-12    | might-break |
  | PEVANS    |   1 | 2023-12    | might-break |
  | TEEJAY    |   1 | 2023-12    | might-break |
  | TEODESIAN |   1 | 2023-12    | might-break |
  | VANHOESEL |   1 | 2023-12    | might-break |
  | VKON      |   1 | 2023-12    | might-break |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
