package Google::Ads::AdWords::v201607::ManualCPCAdGroupExperimentBidMultipliers;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201607' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201607::AdGroupExperimentBidMultipliers);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %AdGroupExperimentBidMultipliers__Type_of :ATTR(:get<AdGroupExperimentBidMultipliers__Type>);
my %maxCpcMultiplier_of :ATTR(:get<maxCpcMultiplier>);
my %maxContentCpcMultiplier_of :ATTR(:get<maxContentCpcMultiplier>);

__PACKAGE__->_factory(
    [ qw(        AdGroupExperimentBidMultipliers__Type
        maxCpcMultiplier
        maxContentCpcMultiplier

    ) ],
    {
        'AdGroupExperimentBidMultipliers__Type' => \%AdGroupExperimentBidMultipliers__Type_of,
        'maxCpcMultiplier' => \%maxCpcMultiplier_of,
        'maxContentCpcMultiplier' => \%maxContentCpcMultiplier_of,
    },
    {
        'AdGroupExperimentBidMultipliers__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'maxCpcMultiplier' => 'Google::Ads::AdWords::v201607::BidMultiplier',
        'maxContentCpcMultiplier' => 'Google::Ads::AdWords::v201607::BidMultiplier',
    },
    {

        'AdGroupExperimentBidMultipliers__Type' => 'AdGroupExperimentBidMultipliers.Type',
        'maxCpcMultiplier' => 'maxCpcMultiplier',
        'maxContentCpcMultiplier' => 'maxContentCpcMultiplier',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201607::ManualCPCAdGroupExperimentBidMultipliers

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ManualCPCAdGroupExperimentBidMultipliers from the namespace https://adwords.google.com/api/adwords/cm/v201607.

Adgroup level bid multipliers used in manual CPC bidding strategies. <span class="constraint AdxEnabled">This is disabled for AdX.</span> 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * maxCpcMultiplier


=item * maxContentCpcMultiplier




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

