use 5.028001;
use ExtUtils::MakeMaker;

sub pkgconfig ($)
{
  my $v = shift;
  my $cmd = "pkg-config --$v primesieve";
  my $r = `$cmd`;
  chomp $r;
  $r = undef if $r eq "";
  die "pkg-config error running: `$cmd`: $!" unless defined $r;
  $r;
}

my $libs = pkgconfig "libs";
my $cflags = pkgconfig "cflags";

WriteMakefile(
    NAME              => 'Primesieve',
    VERSION_FROM      => 'lib/Primesieve.pm', # finds $VERSION, requires EU::MM from perl >= 5.5
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ABSTRACT_FROM     => 'lib/Primesieve.pm', # retrieve abstract from module
    AUTHOR            => 'Stefan Traby <stefan@hello-penguin.com>',
    LICENSE           => 'perl',
    LIBS              => [$libs], # e.g., '-lm'
    DEFINE            => '', # e.g., '-DHAVE_SOMETHING'
    INC               => "-I. $cflags", # e.g., '-I. -I/usr/include/other'
	# Un-comment this if you add C files to link with later:
    # OBJECT            => '$(O_FILES)', # link all the C files too
);
