package Chart::Plotly::Trace::Area::Marker;
use Moose;
use MooseX::ExtraArgs;
use Moose::Util::TypeConstraints qw(enum union);
if ( !defined Moose::Util::TypeConstraints::find_type_constraint('PDL') ) {
    Moose::Util::TypeConstraints::type('PDL');
}

our $VERSION = '0.022';    # VERSION

# ABSTRACT: This attribute is one of the possible options for the trace area.

sub TO_JSON {
    my $self       = shift;
    my $extra_args = $self->extra_args // {};
    my $meta       = $self->meta;
    my %hash       = %$self;
    for my $name ( sort keys %hash ) {
        my $attr = $meta->get_attribute($name);
        if ( defined $attr ) {
            my $value = $hash{$name};
            my $type  = $attr->type_constraint;
            if ( $type && $type->equals('Bool') ) {
                $hash{$name} = $value ? \1 : \0;
            }
        }
    }
    %hash = ( %hash, %$extra_args );
    delete $hash{'extra_args'};
    if ( $self->can('type') && ( !defined $hash{'type'} ) ) {
        $hash{type} = $self->type();
    }
    return \%hash;
}

has color => (
    is  => "rw",
    isa => "Maybe[ArrayRef]",
    documentation =>
      "Area traces are deprecated! Please switch to the *barpolar* trace type. Sets themarkercolor. It accepts either a specific color or an array of numbers that are mapped to the colorscale relative to the max and min values of the array or relative to `marker.cmin` and `marker.cmax` if set.",
);

has colorsrc => ( is            => "rw",
                  isa           => "Str",
                  documentation => "Sets the source reference on plot.ly for  color .",
);

has opacity => (
    is            => "rw",
    isa           => "Num|ArrayRef[Num]",
    documentation => "Area traces are deprecated! Please switch to the *barpolar* trace type. Sets the marker opacity.",
);

has opacitysrc => ( is            => "rw",
                    isa           => "Str",
                    documentation => "Sets the source reference on plot.ly for  opacity .",
);

has size => ( is  => "rw",
              isa => "Num|ArrayRef[Num]",
              documentation =>
                "Area traces are deprecated! Please switch to the *barpolar* trace type. Sets the marker size (in px).",
);

has sizesrc => ( is            => "rw",
                 isa           => "Str",
                 documentation => "Sets the source reference on plot.ly for  size .",
);

has symbol => (
    is  => "rw",
    isa => "Maybe[ArrayRef]",
    documentation =>
      "Area traces are deprecated! Please switch to the *barpolar* trace type. Sets the marker symbol type. Adding 100 is equivalent to appending *-open* to a symbol name. Adding 200 is equivalent to appending *-dot* to a symbol name. Adding 300 is equivalent to appending *-open-dot* or *dot-open* to a symbol name.",
);

has symbolsrc => ( is            => "rw",
                   isa           => "Str",
                   documentation => "Sets the source reference on plot.ly for  symbol .",
);

__PACKAGE__->meta->make_immutable();
1;

__END__

=pod

=encoding utf-8

=head1 NAME

Chart::Plotly::Trace::Area::Marker - This attribute is one of the possible options for the trace area.

=head1 VERSION

version 0.022

=head1 SYNOPSIS

 use Chart::Plotly qw(show_plot);
 use Chart::Plotly::Trace::Area;
 # Example data from: https://plot.ly/javascript/wind-rose-charts/#wind-rose-chart
 my $area = Chart::Plotly::Trace::Area->new(
     r      => [ 77.5, 72.5, 70.0, 45.0, 22.5, 42.5, 40.0, 62.5 ],
     t      => [ 'North', 'N-E', 'East', 'S-E', 'South', 'S-W', 'West', 'N-W' ],
     name   => '11-14 m/s',
     marker => { color => 'rgb(106,81,163)' },
 );
 
 show_plot([ $area ]);

=head1 DESCRIPTION

This attribute is part of the possible options for the trace area.

This file has been autogenerated from the official plotly.js source.

If you like Plotly, please support them: L<https://plot.ly/> 
Open source announcement: L<https://plot.ly/javascript/open-source-announcement/>

Full reference: L<https://plot.ly/javascript/reference/#area>

=head1 DISCLAIMER

This is an unofficial Plotly Perl module. Currently I'm not affiliated in any way with Plotly. 
But I think plotly.js is a great library and I want to use it with perl.

=head1 METHODS

=head2 TO_JSON

Serialize the trace to JSON. This method should be called only by L<JSON> serializer.

=head1 ATTRIBUTES

=over

=item * color

Area traces are deprecated! Please switch to the *barpolar* trace type. Sets themarkercolor. It accepts either a specific color or an array of numbers that are mapped to the colorscale relative to the max and min values of the array or relative to `marker.cmin` and `marker.cmax` if set.

=item * colorsrc

Sets the source reference on plot.ly for  color .

=item * opacity

Area traces are deprecated! Please switch to the *barpolar* trace type. Sets the marker opacity.

=item * opacitysrc

Sets the source reference on plot.ly for  opacity .

=item * size

Area traces are deprecated! Please switch to the *barpolar* trace type. Sets the marker size (in px).

=item * sizesrc

Sets the source reference on plot.ly for  size .

=item * symbol

Area traces are deprecated! Please switch to the *barpolar* trace type. Sets the marker symbol type. Adding 100 is equivalent to appending *-open* to a symbol name. Adding 200 is equivalent to appending *-dot* to a symbol name. Adding 300 is equivalent to appending *-open-dot* or *dot-open* to a symbol name.

=item * symbolsrc

Sets the source reference on plot.ly for  symbol .

=back

=head1 AUTHOR

Pablo Rodríguez González <pablo.rodriguez.gonzalez@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Pablo Rodríguez González.

This is free software, licensed under:

  The MIT (X11) License

=cut
