# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl Finance-BankVal-UK.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';
use Finance::BankVal::UK qw(&bankValUK);
use Test::More tests => 5;
BEGIN { use_ok('Finance::BankVal::UK') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.
diag("testing sortcode prevalidation");
like( bankValUK('09012','12345678','abcd123','12345'),'/INVALID - Sortcode/','sort code validation') or diag("failed 1");
diag("testing account prevalidation");
like( bankValUK('090126','12345','abcd123','12345'),'/INVALID - Account/','account validation') or diag("failed 2");
diag("testing userid prevalidation");
like( bankValUK('090126','12345678','abcd','12345'),'/Invalid Credentials/','user id validation') or diag("failed 3");
diag("testing pin prevalidation");
like( bankValUK('090126','12345678','abcd123','1234'),'/Invalid Credentials/','PIN validation') or diag("failed 4");

done_testing();