package Task::Sites::BetterScm;
$Task::Sites::BetterScm::VERSION = '0.0.4';
use 5.014;
use warnings;
use strict;


1;    # End of Task::Latemp

__END__

=pod

=encoding UTF-8

=head1 NAME

Task::Sites::BetterScm - Specifications for modules needed by the better scm site.

=head1 VERSION

version 0.0.4

=head1 DESCRIPTION

See L<https://better-scm.shlomifish.org/> and L<https://github.com/shlomif/better-scm> .

=head1 TASK CONTENTS

=head2 Foo

=head3 L<App::Deps::Verify>

=head3 L<App::Gezer>

=head3 L<App::XML::DocBook::Builder>

=head3 L<Bit::Vector>

=head3 L<CGI>

=head3 L<Carp>

=head3 L<Carp::Always>

=head3 L<Class::XSAccessor>

=head3 L<Code::TidyAll::Plugin::TestCount>

=head3 L<Config::IniFiles>

=head3 L<Cwd>

=head3 L<Data::Dumper>

=head3 L<Data::Munge>

=head3 L<Encode>

=head3 L<English>

=head3 L<Exporter>

=head3 L<Fcntl>

=head3 L<File::Basename>

=head3 L<File::Copy>

=head3 L<File::Find>

=head3 L<File::Find::Object>

=head3 L<File::Find::Object::Rule>

=head3 L<File::Path>

=head3 L<File::Spec>

=head3 L<File::Spec::Functions>

=head3 L<File::Update>

=head3 L<File::Which>

=head3 L<GD>

=head3 L<Getopt::Long>

=head3 L<HTML::Latemp::GenMakeHelpers>

=head3 L<HTML::Latemp::NavLinks::GenHtml::ArrowImages>

=head3 L<HTML::Latemp::News>

=head3 L<HTML::Links::Localize>

=head3 L<HTML::Parser>

=head3 L<HTML::Spelling::Site>

=head3 L<HTML::T5>

=head3 L<HTML::TokeParser::Simple>

=head3 L<HTML::TreeBuilder::LibXML>

=head3 L<HTML::Widgets::NavMenu>

=head3 L<HTML::Widgets::NavMenu::EscapeHtml>

=head3 L<HTML::Widgets::NavMenu::ToJSON>

=head3 L<HTML::Widgets::NavMenu::ToJSON::Data_Persistence::YAML>

=head3 L<IO::All>

=head3 L<IO::Handle>

=head3 L<Image::Size>

=head3 L<JSON::MaybeXS>

=head3 L<List::MoreUtils>

=head3 L<List::Util>

=head3 L<POSIX>

=head3 L<Parallel::ForkManager::Segmented>

=head3 L<Path::Tiny>

=head3 L<Perl::Tidy>

=head3 L<Pod::Xhtml>

=head3 L<Task::Latemp>

=head3 L<Template>

=head3 L<Template::Preprocessor::TTML>

=head3 L<Term::ReadKey>

=head3 L<Test::Code::TidyAll>

=head3 L<Test::File::Find::CaseCollide>

=head3 L<Test::HTML::Recursive::DeprecatedTags>

=head3 L<Test::HTML::Tidy::Recursive>

=head3 L<Test::HTML::Tidy::Recursive::Strict>

=head3 L<Test::More>

=head3 L<Test::Perl::Critic>

=head3 L<Test::TrailingSpace>

=head3 L<Text::Hunspell>

=head3 L<Text::VimColor>

=head3 L<Text::WrapAsUtf8>

=head3 L<XML::CompareML::HTML>

=head3 L<XML::LibXML>

=head3 L<XML::LibXML::Reader>

=head3 L<XML::LibXML::XPathContext>

=head3 L<XML::LibXSLT>

=head3 L<XML::Parser>

=head3 L<XML::Writer>

=head3 L<autodie>

=head3 L<base>

=head3 L<constant>

=head3 L<lib>

=head3 L<parent>

=head3 L<strict>

=head3 L<utf8>

=head3 L<vars>

=head3 L<warnings>

=head1 AUTHOR

Shlomi Fish, L<https://www.shlomifish.org/> .

=head1 ACKNOWLEDGEMENTS

=head1 SEE ALSO

L<Task> .

=head1 COPYRIGHT & LICENSE

Copyright 2006 Shlomi Fish, all rights reserved.

This program is released under the following license: MIT / Expat .

=for :stopwords cpan testmatrix url bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<https://metacpan.org/release/Task-Sites-BetterScm>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=Task-Sites-BetterScm>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/Task-Sites-BetterScm>

=item *

CPAN Testers

The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/T/Task-Sites-BetterScm>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=Task-Sites-BetterScm>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=Task::Sites::BetterScm>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-task-sites-betterscm at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=Task-Sites-BetterScm>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/shlomif/better-scm>

  git clone git://github.com/shlomif/better-scm.git

=head1 AUTHOR

Shlomi Fish <shlomif@cpan.org>

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/shlomif/better-scm/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2019 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=cut
